/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.graphics.TextSprite;
import org.icepdf.core.util.Defs;
import org.icepdf.core.views.swing.PageViewComponentImpl;

public class Shapes {
    private static final Logger logger = Logger.getLogger(Shapes.class.toString());
    private static boolean scaleImages = Defs.sysPropertyBoolean("org.icepdf.core.scaleImages", true);
    protected Vector<Object> shapes = new Vector(1000, 50);
    private Vector<Image> images = new Vector();
    private Color lastColor;
    private BasicStroke lastBasicStroke;
    private Page parentPage;
    private static int paintDelay = 250;

    public int getShapesCount() {
        if (this.shapes != null) {
            return this.shapes.size();
        }
        return 0;
    }

    public void setPageParent(Page page) {
        this.parentPage = page;
    }

    public void dispose() {
        Image image;
        Object object;
        Enumeration<Image> enumeration = this.images.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof Image)) continue;
            image = object;
            image.flush();
        }
        this.images.clear();
        Enumeration<Object> enumeration2 = this.shapes.elements();
        while (enumeration2.hasMoreElements()) {
            object = enumeration2.nextElement();
            if (object instanceof Image) {
                image = (Image)object;
                image.flush();
                continue;
            }
            if (!(object instanceof TextSprite)) continue;
            ((TextSprite)object).dispose();
        }
        this.shapes.clear();
    }

    public void add(Object object) {
        if (object instanceof Image) {
            Image image;
            Image image2 = (Image)object;
            int n = image2.getWidth(null);
            if (scaleImages) {
                double d = 1.0;
                if (n > 1000 && n < 1500) {
                    d = 0.75;
                } else if (n > 1500) {
                    d = 0.5;
                }
                if (d < 1.0) {
                    image = image2.getScaledInstance((int)((double)n * d), -1, 4);
                    image2.flush();
                } else {
                    image = image2;
                }
            } else {
                image = image2;
            }
            this.images.addElement(image);
            this.shapes.add(image);
            return;
        }
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            for (Object e : vector) {
                if (!(e instanceof Image)) continue;
                this.images.addElement((Image)e);
            }
        }
        this.shapes.add(object);
    }

    public void addDrawCommand() {
        this.shapes.add(new Draw());
    }

    public void addFillCommand() {
        this.shapes.add(new Fill());
    }

    public void addClipCommand() {
        this.shapes.add(new Clip());
    }

    public void addNoClipCommand() {
        this.shapes.add(new NoClip());
    }

    public synchronized void paint(Graphics2D graphics2D) {
        this.paint(graphics2D, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void paint(Graphics2D var1_1, PageViewComponentImpl.PagePainter var2_2) {
        var3_3 = null;
        var4_4 = new AffineTransform(var1_1.getTransform());
        var5_5 = var1_1.getClip();
        var7_6 = new Area(var1_1.getClip());
        var10_7 = System.currentTimeMillis();
        var12_8 = this.shapes.elements();
        try {
            while (true) lbl-1000:
            // 28 sources

            {
                if (!var12_8.hasMoreElements()) {
                    if (var2_2 == null) return;
                    if (var2_2.isStopPaintingRequested() == false) return;
                }
                if ((var6_9 = var12_8.nextElement()) instanceof TextSprite) {
                    if (!((TextSprite)var6_9).intersects(var7_6)) continue;
                    ((TextSprite)var6_9).paint(var1_1);
                    var8_10 = System.currentTimeMillis();
                    if (var8_10 - var10_7 <= (long)Shapes.paintDelay) continue;
                    var10_7 = var8_10;
                    this.parentPage.notifyPaintPageListeners();
                    continue;
                }
                if (var6_9 instanceof Shape) {
                    var3_3 = (Shape)var6_9;
                    continue;
                }
                if (var6_9 instanceof Fill) {
                    if (!var7_6.intersects(var3_3.getBounds2D())) continue;
                    var1_1.fill(var3_3);
                    var8_10 = System.currentTimeMillis();
                    if (var8_10 - var10_7 <= (long)Shapes.paintDelay) continue;
                    var10_7 = var8_10;
                    this.parentPage.notifyPaintPageListeners();
                    continue;
                }
                if (var6_9 instanceof AffineTransform) {
                    var13_11 = new AffineTransform(var4_4);
                    var13_11.concatenate((AffineTransform)var6_9);
                    var1_1.setTransform((AffineTransform)var13_11);
                    if (var1_1.getClip() == null) continue;
                    var7_6 = new Area(var1_1.getClip());
                    continue;
                }
                if (var6_9 instanceof AlphaComposite) {
                    var1_1.setComposite((AlphaComposite)var6_9);
                    continue;
                }
                if (var6_9 instanceof Paint) {
                    var1_1.setPaint((Paint)var6_9);
                    continue;
                }
                if (var6_9 instanceof Clip) {
                    var13_11 = new AffineTransform(var1_1.getTransform());
                    var1_1.setTransform(var4_4);
                    var1_1.setClip(var5_5);
                    var1_1.setTransform((AffineTransform)var13_11);
                    if (var3_3 != null) {
                        var1_1.clip(var3_3);
                    }
                    var7_6 = new Area(var1_1.getClip());
                    continue;
                }
                if (var6_9 instanceof Draw) {
                    if (!var3_3.intersects(var7_6.getBounds2D()) && !(var3_3.getBounds2D().getWidth() < 1.0) && !(var3_3.getBounds2D().getHeight() < 1.0)) continue;
                    var1_1.draw(var3_3);
                    var8_10 = System.currentTimeMillis();
                    if (var8_10 - var10_7 <= (long)Shapes.paintDelay) continue;
                    var10_7 = var8_10;
                    this.parentPage.notifyPaintPageListeners();
                    continue;
                }
                if (var6_9 instanceof NoClip) {
                    var13_11 = new AffineTransform(var1_1.getTransform());
                    var1_1.setTransform(var4_4);
                    var1_1.setClip(var5_5);
                    var1_1.setTransform((AffineTransform)var13_11);
                    var7_6 = new Area(var1_1.getClip());
                    continue;
                }
                if (var6_9 instanceof Stroke) {
                    var1_1.setStroke((Stroke)var6_9);
                    continue;
                }
                if (var6_9 instanceof Image) {
                    var13_11 = (Image)var6_9;
                    if (!var7_6.intersects(0.0, 0.0, 1.0, 1.0)) continue;
                    try {
                        var1_1.drawImage((Image)var13_11, 0, 0, 1, 1, null);
                    }
                    catch (OutOfMemoryError var14_14) {
                        var15_15 = var13_11.getWidth(null);
                        var16_16 = var13_11.getHeight(null);
                        if (var15_15 < 600 || var16_16 < 600) ** GOTO lbl-1000
                        var17_17 = var1_1.getTransform();
                        var18_18 = (int)var17_17.getScaleX();
                        var19_19 = (int)var17_17.getScaleX();
                        if (var18_18 >= var15_15 && var19_19 >= var16_16) ** GOTO lbl-1000
                        var20_20 = var1_1.getRenderingHints();
                        var21_21 = var20_20.get(RenderingHints.KEY_INTERPOLATION);
                        try {
                            var20_20.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                            var1_1.setRenderingHints(var20_20);
                            var1_1.drawImage((Image)var13_11, 0, 0, 1, 1, null);
                        }
                        finally {
                            var20_20.put(RenderingHints.KEY_INTERPOLATION, var21_21);
                            var1_1.setRenderingHints(var20_20);
                            var8_10 = System.currentTimeMillis();
                            if (var8_10 - var10_7 <= (long)Shapes.paintDelay) ** GOTO lbl-1000
                            var10_7 = var8_10;
                            this.parentPage.notifyPaintPageListeners();
                        }
                    }
                    continue;
                }
                if (var6_9 instanceof Shapes) {
                    ((Shapes)var6_9).setPageParent(this.parentPage);
                    ((Shapes)var6_9).paint(var1_1);
                    ((Shapes)var6_9).setPageParent(null);
                    continue;
                }
                if (!(var6_9 instanceof Color)) continue;
                var1_1.setColor((Color)var6_9);
            }
        }
        catch (NoSuchElementException var13_12) {
            return;
        }
        catch (Exception var13_13) {
            Shapes.logger.log(Level.FINE, "Error painting shapes.", var13_13);
        }
    }

    public Vector getImages() {
        return this.images;
    }

    static {
        try {
            paintDelay = Defs.intProperty("org.icepdf.core.views.refreshfrequency", 250);
        }
        catch (NumberFormatException numberFormatException) {
            logger.log(Level.FINE, "Error reading buffered scale factor");
        }
    }

    class NoClip {
        NoClip() {
        }
    }

    class Clip {
        Clip() {
        }
    }

    class Fill {
        Fill() {
        }
    }

    class Draw {
        Draw() {
        }
    }
}

