/*
 * Decompiled with CFR 0.152.
 */
package thinlet;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import thinlet.Thinlet;

public class FrameLauncher
extends Frame
implements WindowListener {
    private transient Thinlet content;
    private transient Image doublebuffer;

    public FrameLauncher(String title, Thinlet content, int width, int height) {
        this(title, null, content, width, height, true);
    }

    public FrameLauncher(String title, Image icon, Thinlet content, int width, int height, boolean visible) {
        super(title);
        this.content = content;
        this.add((Component)content, "Center");
        this.addWindowListener(this);
        this.pack();
        Insets is = this.getInsets();
        width += is.left + is.right;
        height += is.top + is.bottom;
        Dimension ss = this.getToolkit().getScreenSize();
        width = Math.min(width, ss.width);
        height = Math.min(height, ss.height);
        this.setBounds((ss.width - width) / 2, (ss.height - height) / 2, width, height);
        if (icon == null || icon.getWidth(null) <= 0 || icon.getHeight(null) <= 0) {
            int[] pix = new int[256];
            int x = 0;
            while (x < 16) {
                int sx = x >= 1 && x <= 9 ? 1 : (x >= 11 && x <= 14 ? 2 : 0);
                int y = 0;
                while (y < 16) {
                    int sy;
                    int n = y >= 1 && y <= 9 ? 1 : (sy = y >= 11 && y <= 14 ? 2 : 0);
                    pix[y * 16 + x] = sx == 0 || sy == 0 ? -1 : (sx == 1 ? (sy == 1 ? (y == 2 && x >= 2 && x <= 8 ? -1 : (y >= 3 && y <= 8 ? (x == 5 ? -1 : (x == 4 || x == 6 ? -1524547 : -5237738)) : -5237738)) : -13140828) : (sy == 1 ? -12942563 : -865124));
                    ++y;
                }
                ++x;
            }
            icon = this.createImage(new MemoryImageSource(16, 16, pix, 0, 16));
        }
        this.setIconImage(icon);
        this.setVisible(visible);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.doublebuffer == null) {
            Dimension d = this.getSize();
            this.doublebuffer = this.createImage(d.width, d.height);
        }
        Graphics dg = this.doublebuffer.getGraphics();
        dg.setClip(g.getClipBounds());
        super.paint(dg);
        dg.dispose();
        g.drawImage(this.doublebuffer, 0, 0, this);
    }

    public void doLayout() {
        if (this.doublebuffer != null) {
            this.doublebuffer.flush();
            this.doublebuffer = null;
        }
        super.doLayout();
    }

    public void windowClosing(WindowEvent e) {
        if (this.content.destroy()) {
            System.exit(0);
        }
        this.setVisible(true);
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

