/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class OracleLog {
    private static StreamHandler printHandler;
    public static Logger rootLogger;
    public static Logger driverLogger;
    public static Logger conversionLogger;
    public static Logger adtLogger;
    public static Logger thinLogger;
    public static Logger datumLogger;
    public static Logger kprbLogger;
    public static Logger xaLogger;
    public static Logger sqljLogger;
    public static Logger ociLogger;
    public static Logger jpubLogger;
    public static final int MASK_ALL_SET = 0xFFFFFFF;
    public static final int MAX_VECTOR_BITS = 32;
    public static final int MAX_MODULES = 32;
    public static final int MODULE_ALL = 0xFFFFFFF;
    public static final int MODULE_DRIVER = 1;
    public static final int MODULE_unused1 = 2;
    public static final int MODULE_DBCONV = 4;
    public static final int MODULE_unused2 = 8;
    public static final int MODULE_PICKLE = 16;
    public static final int MODULE_JTTC = 32;
    public static final int MODULE_DATUM = 64;
    public static final int MODULE_KPRB = 128;
    public static final int MODULE_XA = 256;
    public static final int MODULE_SQLJ = 512;
    public static final int MODULE_JOCI = 1024;
    public static final int MODULE_JPUB = 2048;
    public static final int MODULE_T2C = 4096;
    public static final int MODULE_TOTAL = 13;
    public static final String[] ModuleName;
    public static final int SUBMOD_ALL = 0xFFFFFFF;
    public static final int SUBMOD_DEFAULT = 1;
    public static final int SUBMOD_DRVR_LOG = 2;
    public static final int SUBMOD_DRVR_ERR = 4;
    public static final int SUBMOD_DRVR_CONN = 8;
    public static final int SUBMOD_DRVR_STMT = 16;
    public static final int SUBMOD_DRVR_RSET = 32;
    public static final int SUBMOD_DRVR_UTIL = 64;
    public static final int SUBMOD_DRVR_SQL = 128;
    public static final int SUBMOD_DRVR_RWST = 256;
    public static final int SUBMOD_DRVR_POOL = 512;
    public static final int SUBMOD_DRVR_SCCH = 1024;
    public static final int SUBMOD_T2C_DRVEXT = 2;
    public static final int SUBMOD_T2C_STATEMENT = 4;
    public static final int SUBMOD_T2C_PREPSTATEMENT = 8;
    public static final int SUBMOD_T2C_CALLSTATEMENT = 16;
    public static final int SUBMOD_T2C_INPUTSTREAM = 32;
    public static final int SUBMOD_T2C_CLOB = 64;
    public static final int SUBMOD_T2C_BLOB = 128;
    public static final int SUBMOD_T2C_BFILE = 256;
    public static final int SUBMOD_DBAC_DATA = 2;
    public static final int SUBMOD_PCKL_INIT = 2;
    public static final int SUBMOD_PCKL_TYPE = 4;
    public static final int SUBMOD_PCKL_PCKL = 8;
    public static final int SUBMOD_PCKL_UNPK = 16;
    public static final int SUBMOD_PCKL_CONV = 32;
    public static final int SUBMOD_PCKL_DESC = 64;
    public static final int SUBMOD_PCKL_PARS = 128;
    public static final int SUBMOD_PCKL_SERL = 256;
    public static final int SUBMOD_JTTC_BASE = 2;
    public static final int SUBMOD_JTTC_TX = 4;
    public static final int SUBMOD_JTTC_RX = 8;
    public static final int SUBMOD_JTTC_MARS = 16;
    public static final int SUBMOD_JTTC_UNMA = 32;
    public static final int SUBMOD_JTTC_CONN = 64;
    public static final int SUBMOD_JTTC_COMM = 128;
    public static final int SUBMOD_JTTC_STMT = 256;
    public static final int SUBMOD_JTTC_LOBS = 512;
    public static final int SUBMOD_JTTC_ADTS = 1024;
    public static final int SUBMOD_JTTC_ACCE = 2048;
    public static final int SUBMOD_KPRB_ERR = 2;
    public static final int SUBMOD_KPRB_CONN = 4;
    public static final int SUBMOD_KPRB_STMT = 8;
    public static final int SUBMOD_KPRB_RSET = 16;
    public static final int SUBMOD_KPRB_UTIL = 32;
    public static final int SUBMOD_KPRB_SQL = 64;
    public static final int SUBMOD_KPRB_DATA = 128;
    public static final int SUBMOD_KPRB_CONV = 256;
    public static final int SUBMOD_XA_DSRC = 2;
    public static final int SUBMOD_XA_CONN = 4;
    public static final int SUBMOD_XA_RSRC = 8;
    public static final int SUBMOD_XA_ARGS = 16;
    public static final int SUBMOD_XA_EXC = 32;
    public static final int SUBMOD_XA_XID = 64;
    public static final int SUBMOD_XA_HCON = 128;
    public static final int SUBMOD_XA_HCCB = 256;
    public static final int SUBMOD_XA_HRSC = 512;
    public static final int SUBMOD_SQLJ_RUN = 2;
    public static final int SUBMOD_JOCI_ACCS = 2;
    public static final int SUBMOD_JOCI_DSET = 4;
    public static final int SUBMOD_JOCI_ITEM = 8;
    public static final int SUBMOD_JOCI_STMT = 16;
    public static final int SUBMOD_JOCI_TYPE = 32;
    public static final int SUBMOD_JOCI_ENV = 64;
    public static final int SUBMOD_JPUB_RUNTIME = 2;
    public static final int CATEGORY_ALL = 0xFFFFFFF;
    public static final int USER_OPER = 1;
    public static final int PROG_ERROR = 2;
    public static final int ERROR = 4;
    public static final int WARNING = 8;
    public static final int FUNCTION = 16;
    public static final int DEBUG1 = 32;
    public static final int DEBUG2 = 64;
    public static final int SQL_STR = 128;
    public static final int CATEGORY_TOTAL = 8;
    public static final String[] CategoryName;
    public static final int CATEGORY_LOW_VOL = 142;
    public static final int CATEGORY_MED_VOL = 143;
    public static final int CATEGORY_HIGH_VOL = 0xFFFFFFF;
    public static final int FIELD_NONE = 0;
    public static final int FIELD_ALL = 0xFFFFFFF;
    public static final int FIELD_NUMBER = 1;
    public static final int FIELD_TIME = 2;
    public static final int FIELD_MODULE = 4;
    public static final int FIELD_SUBMOD = 8;
    public static final int FIELD_CATEGORY = 16;
    public static final int FIELD_OBJECT = 32;
    public static final int FIELD_THREAD = 64;
    public static final int FIELD_DEFAULT = 20;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    private static PrintWriter m_logWriter;
    private static PrintStream m_logStream;
    private static int m_printMask;
    private static int m_moduleMask;
    private static int[] m_submodMasks;
    private static int m_categoryMask;
    private static int m_maxPrintBytes;
    private static boolean m_warningEnabled;
    private static int m_msgNumber;
    static boolean m_security_exception_getting_system_properties;

    public static boolean isDebugZip() {
        boolean bl = true;
        bl = false;
        return bl;
    }

    public static boolean isPrivateLogAvailable() {
        boolean bl = false;
        return bl;
    }

    public static boolean isEnabled() {
        return false;
    }

    public static void setLogWriter(PrintWriter printWriter) {
        if (!OracleLog.isDebugZip()) {
            if (printWriter != null) {
                printWriter.println("Oracle Jdbc tracing is not avaliable in a non-debug zip/jar file");
                printWriter.flush();
            }
            return;
        }
        if (printWriter != null) {
            printWriter.println("OracleLog.setLogWriter not supported. Use setLogStream instead, or better yet, java.util.logging.");
            printWriter.flush();
        }
    }

    public static PrintWriter getLogWriter() {
        return m_logWriter;
    }

    private static void initLoggers() {
        if (rootLogger == null) {
            rootLogger = Logger.getLogger("oracle.jdbc");
            driverLogger = Logger.getLogger("oracle.jdbc.driver");
            conversionLogger = Logger.getLogger("oracle.jdbc.conversion");
            adtLogger = Logger.getLogger("oracle.jdbc.adt");
            thinLogger = Logger.getLogger("oracle.jdbc.thin");
            datumLogger = Logger.getLogger("oracle.jdbc.datum");
            kprbLogger = Logger.getLogger("oracle.jdbc.kprb");
            xaLogger = Logger.getLogger("oracle.jdbc.xa");
            sqljLogger = Logger.getLogger("oracle.jdbc.sqlj");
            ociLogger = Logger.getLogger("oracle.jdbc.oci");
            jpubLogger = Logger.getLogger("oracle.jdbc.jpub");
        }
    }

    public static void setLogStream(PrintStream printStream) {
        if (!OracleLog.isDebugZip()) {
            if (printStream != null) {
                printStream.println("Oracle Jdbc tracing is not avaliable in a non-debug zip/jar file");
                printStream.flush();
            }
            return;
        }
        OracleLog.initLoggers();
        if (printHandler != null) {
            rootLogger.removeHandler(printHandler);
        }
        printHandler = new StreamHandler(printStream, new SimpleFormatter());
        printHandler.setLevel(Level.FINEST);
        rootLogger.addHandler(printHandler);
        OracleLog.setTrace(true);
    }

    public static PrintStream getLogStream() {
        return m_logStream;
    }

    public static void enableWarning(boolean bl) {
        m_warningEnabled = bl;
    }

    public static void setLogVolume(int n) {
        OracleLog.print(null, 1, 2, 1, "Set logging volume level to " + n);
        int n2 = 142;
        switch (n) {
            case 1: {
                n2 = 142;
                break;
            }
            case 2: {
                n2 = 143;
                break;
            }
            case 3: {
                n2 = 0xFFFFFFF;
                break;
            }
            default: {
                OracleLog.print(null, 1, 2, 4, "Logging volume level " + n + " is not in the range of 1 to 3");
                return;
            }
        }
        OracleLog.config(m_printMask, m_moduleMask, n2);
    }

    public static void startLogging() {
        OracleLog.setLogStream(System.out);
    }

    public static void stopLogging() {
        OracleLog.setLogStream(null);
    }

    public static void config(int n, int n2, int n3) {
        OracleLog.configForJavaUtilLogging(n2, n3);
    }

    static void configForJavaUtilLogging(int n, int n2) {
        Level level = Level.OFF;
        if ((n2 & 0x40) != 0) {
            level = Level.FINEST;
        } else if ((n2 & 0x20) != 0) {
            level = Level.FINER;
        } else if ((n2 & 0x10) != 0) {
            level = Level.FINE;
        } else if ((n2 & 1) != 0) {
            level = Level.INFO;
        } else if ((n2 & 0x80) != 0) {
            level = Level.CONFIG;
        } else if ((n2 & 8) != 0) {
            level = Level.WARNING;
        } else if ((n2 & 2) != 0) {
            level = Level.SEVERE;
        } else if ((n2 & 4) != 0) {
            level = Level.SEVERE;
        }
        OracleLog.initLoggers();
        rootLogger.setLevel(level);
        Level level2 = Level.OFF;
        driverLogger.setLevel((n & 1) != 0 ? level : level2);
        conversionLogger.setLevel((n & 4) != 0 ? level : level2);
        adtLogger.setLevel((n & 0x10) != 0 ? level : level2);
        thinLogger.setLevel((n & 0x20) != 0 ? level : level2);
        datumLogger.setLevel((n & 0x40) != 0 ? level : level2);
        kprbLogger.setLevel((n & 0x80) != 0 ? level : level2);
        xaLogger.setLevel((n & 0x100) != 0 ? level : level2);
        sqljLogger.setLevel((n & 0x200) != 0 ? level : level2);
        ociLogger.setLevel((n & 0x400) != 0 ? level : level2);
        jpubLogger.setLevel((n & 0x800) != 0 ? level : level2);
    }

    public static void setSubmodMask(int n, int n2) {
        int n3 = OracleLog.getBitNumFromVector(n);
        OracleLog.m_submodMasks[n3] = n2;
        OracleLog.print(null, 1, 2, 1, "Set logging sub-mask for module " + OracleLog.getMaskHexStr(m_moduleMask) + "(number " + n3 + ") to " + OracleLog.getMaskHexStr(n2));
    }

    public static void setMaxPrintBytes(int n) {
        if (n > 0) {
            m_maxPrintBytes = n;
        }
        OracleLog.print(null, 1, 2, 1, "Set the maximum number of bytes to be printed to " + m_maxPrintBytes);
    }

    public static boolean registerClassNameAndGetCurrentTraceSetting(Class clazz) {
        return false;
    }

    public static boolean registerClassNameAndGetCurrentPrivateTraceSetting(Class clazz) {
        return false;
    }

    public static void setTrace(boolean bl) {
    }

    public static void setPrivateTrace(boolean bl) {
    }

    private static void initialize() {
        OracleLog.internalCodeChecks();
        OracleLog.setupFromSystemProperties();
    }

    private static void internalCodeChecks() {
        if (ModuleName.length != 13) {
            System.out.println("ERROR: OracleLog.ModuleName[] has " + ModuleName.length + " items (expected " + 13 + ")");
        }
        if (CategoryName.length != 8) {
            System.out.println("ERROR: OracleLog.CategoryName[] has " + ModuleName.length + " items (expected " + 13 + ")");
        }
    }

    public static void setupFromSystemProperties() {
        boolean bl = false;
        m_security_exception_getting_system_properties = false;
        PrintStream printStream = System.out;
        try {
            String string = null;
            string = OracleLog.getSystemProperty("oracle.jdbc.LogFile");
            if (string != null) {
                try {
                    File file = new File(string);
                    printStream = new PrintStream(new FileOutputStream(file));
                    bl = true;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.out);
                }
            }
            if ((string = OracleLog.getSystemProperty("oracle.jdbc.Trace")) != null && string.compareTo("true") == 0) {
                bl = true;
            }
            if ((string = OracleLog.getSystemProperty("oracle.jdbc.PrintMask")) != null) {
                m_printMask = Integer.parseInt(string, 16);
                bl = true;
            }
            if ((string = OracleLog.getSystemProperty("oracle.jdbc.PrintFields")) != null) {
                if (string.equalsIgnoreCase("default")) {
                    m_printMask = 20;
                }
                if (string.equalsIgnoreCase("all")) {
                    m_printMask = 0xFFFFFFF;
                }
                if (string.equalsIgnoreCase("thread")) {
                    m_printMask = 84;
                }
                if (string.equalsIgnoreCase("none")) {
                    m_printMask = 0;
                }
                bl = true;
            }
            if ((string = OracleLog.getSystemProperty("oracle.jdbc.ModuleMask")) != null) {
                m_moduleMask = Integer.parseInt(string, 16);
                bl = true;
            }
            if ((string = OracleLog.getSystemProperty("oracle.jdbc.CategoryMask")) != null) {
                m_categoryMask = Integer.parseInt(string, 16);
                bl = true;
            }
            for (int i = 0; i < 32; ++i) {
                string = OracleLog.getSystemProperty("oracle.jdbc.SubmodMask" + i);
                if (string == null) continue;
                OracleLog.m_submodMasks[i] = Integer.parseInt(string, 16);
                bl = true;
            }
            string = OracleLog.getSystemProperty("oracle.jdbc.MaxPrintBytes");
            if (string != null) {
                m_maxPrintBytes = Integer.parseInt(string, 10);
                bl = true;
            }
        }
        catch (SecurityException securityException) {
            m_security_exception_getting_system_properties = true;
        }
        if (bl) {
            OracleLog.setLogStream(printStream);
        }
    }

    public static String getSystemProperty(String string) {
        return OracleLog.getSystemProperty(string, null);
    }

    public static String getSystemProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }

    public static void print(Object object, int n, int n2, int n3, String string) {
        if (m_logWriter == null) {
            return;
        }
        boolean bl = false;
        if ((n & m_moduleMask) != 0 && (n2 & m_submodMasks[OracleLog.getBitNumFromVector(n)]) != 0 && (n3 & m_categoryMask) != 0) {
            bl = true;
        }
        if ((n3 & 4) != 0) {
            bl = true;
        }
        if (m_warningEnabled && (n3 & 8) != 0) {
            bl = true;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer("");
            if ((m_printMask & 1) != 0) {
                stringBuffer.append(OracleLog.getMessageNumber());
            }
            if ((m_printMask & 2) != 0) {
                stringBuffer.append(OracleLog.getCurrTimeStr());
            }
            if ((m_printMask & 4) != 0) {
                stringBuffer.append(OracleLog.getModuleName(n));
            }
            if ((m_printMask & 8) != 0) {
                stringBuffer.append(OracleLog.getBitNumFromVector(n2) + " ");
            }
            if ((m_printMask & 0x10) != 0) {
                stringBuffer.append(OracleLog.getCategoryName(n3));
            }
            if ((m_printMask & 0x40) != 0) {
                stringBuffer.append(Thread.currentThread() + "_" + Thread.currentThread().hashCode() + "_");
            }
            stringBuffer.append(string);
            if ((m_printMask & 0x20) != 0) {
                stringBuffer.append(" " + object);
            }
            if (m_logStream == System.out) {
                m_logWriter.println();
            }
            m_logWriter.println(stringBuffer.toString());
            m_logWriter.flush();
        }
    }

    public static void print(Object object, int n, int n2, int n3, String string, Exception exception) {
        if (m_logWriter == null) {
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        OracleLog.print(object, n, n2, n3, string + stringWriter.toString());
    }

    public static void print(Object object, int n, int n2, String string) {
        OracleLog.print(object, n, 1, n2, string);
    }

    public static String info() {
        String string = null;
        string = OracleLog.isEnabled() ? "Enabled logging (moduleMask " + OracleLog.getMaskHexStr(m_moduleMask) + ", categoryMask " + OracleLog.getMaskHexStr(m_categoryMask) + ")" : "Disabled logging";
        return string;
    }

    public static String getModuleName(int n) {
        String string = null;
        int n2 = 1;
        for (int i = 0; i < 13; ++i) {
            if ((n2 & n) != 0) {
                string = ModuleName[i];
                break;
            }
            n2 <<= 1;
        }
        return string;
    }

    public static String getCategoryName(int n) {
        String string = null;
        int n2 = 1;
        for (int i = 0; i < 8; ++i) {
            if ((n2 & n) != 0) {
                string = CategoryName[i];
                break;
            }
            n2 <<= 1;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMessageNumber() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer("");
        PrintWriter printWriter = m_logWriter;
        synchronized (printWriter) {
            m_msgNumber = m_msgNumber == Integer.MAX_VALUE ? 0 : ++m_msgNumber;
            n2 = m_msgNumber;
        }
        String string = Integer.toString(n2);
        for (int i = n = string.length(); i < 10; ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    private static String getCurrTimeStr() {
        Date date = new Date();
        return date.toString() + " ";
    }

    public static String getMaskHexStr(int n) {
        int n2 = 8;
        String string = Integer.toHexString(n);
        char[] cArray = new char[n2 - string.length()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = 48;
        }
        String string2 = new String(cArray);
        return new String("0x" + string2 + string);
    }

    public static int getBitNumFromVector(int n) {
        int n2 = 0;
        int n3 = 1;
        for (int i = 0; i < 32; ++i) {
            if ((n & n3) != 0) {
                n2 = i;
                break;
            }
            n3 <<= 1;
        }
        return n2;
    }

    public static String byteToHexString(byte by) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0xFF & by;
        if (n <= 15) {
            stringBuffer.append("0x0");
        } else {
            stringBuffer.append("0x");
        }
        stringBuffer.append(Integer.toHexString(n));
        return stringBuffer.toString();
    }

    public static String bytesToPrintableForm(String string, byte[] byArray) {
        int n = byArray == null ? 0 : byArray.length;
        return OracleLog.bytesToPrintableForm(string, byArray, n);
    }

    public static String bytesToPrintableForm(String string, byte[] byArray, int n) {
        String string2 = null;
        string2 = byArray == null ? string + ": null" : string + " (" + byArray.length + " bytes):\n" + OracleLog.bytesToFormattedStr(byArray, n, "  ");
        return string2;
    }

    public static String bytesToFormattedStr(byte[] byArray, int n, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (string == null) {
            string = new String("");
        }
        stringBuffer.append(string);
        if (byArray == null) {
            stringBuffer.append("byte [] is null");
            return stringBuffer.toString();
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            if (i >= m_maxPrintBytes) {
                stringBuffer.append("\n" + string + "... last " + (n - m_maxPrintBytes) + " bytes were not printed to limit the output size");
                break;
            }
            if (i > 0 && i % 20 == 0) {
                stringBuffer.append("\n" + string);
            }
            if (i % 20 == 10) {
                stringBuffer.append(" ");
            }
            if ((n2 = 0xFF & byArray[i]) <= 15) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(n2) + " ");
        }
        return stringBuffer.toString();
    }

    public static byte[] strToUcs2Bytes(String string) {
        if (string == null) {
            return null;
        }
        return OracleLog.charsToUcs2Bytes(string.toCharArray());
    }

    public static byte[] charsToUcs2Bytes(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        return OracleLog.charsToUcs2Bytes(cArray, cArray.length);
    }

    public static byte[] charsToUcs2Bytes(char[] cArray, int n) {
        if (cArray == null) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        return OracleLog.charsToUcs2Bytes(cArray, n, 0);
    }

    public static byte[] charsToUcs2Bytes(char[] cArray, int n, int n2) {
        if (cArray == null) {
            return null;
        }
        if (n > cArray.length - n2) {
            n = cArray.length - n2;
        }
        if (n < 0) {
            return null;
        }
        byte[] byArray = new byte[2 * n];
        int n3 = 0;
        for (int i = n2; i < n; ++i) {
            byArray[n3++] = (byte)(cArray[i] >> 8 & 0xFF);
            byArray[n3++] = (byte)(cArray[i] & 0xFF);
        }
        return byArray;
    }

    public static String toPrintableStr(String string, int n) {
        if (string == null) {
            return "null";
        }
        if (string.length() > n) {
            return string.substring(0, n - 1) + "\n ... the actual length was " + string.length();
        }
        return string;
    }

    public static String toHex(long l, int n) {
        String string;
        switch (n) {
            case 1: {
                string = "00" + Long.toString(l & 0xFFL, 16);
                break;
            }
            case 2: {
                string = "0000" + Long.toString(l & 0xFFFFL, 16);
                break;
            }
            case 3: {
                string = "000000" + Long.toString(l & 0xFFFFFFL, 16);
                break;
            }
            case 4: {
                string = "00000000" + Long.toString(l & 0xFFFFFFFFL, 16);
                break;
            }
            case 5: {
                string = "0000000000" + Long.toString(l & 0xFFFFFFFFFFL, 16);
                break;
            }
            case 6: {
                string = "000000000000" + Long.toString(l & 0xFFFFFFFFFFFFL, 16);
                break;
            }
            case 7: {
                string = "00000000000000" + Long.toString(l & 0xFFFFFFFFFFFFFFL, 16);
                break;
            }
            case 8: {
                return OracleLog.toHex(l >> 32, 4) + OracleLog.toHex(l, 4).substring(2);
            }
            default: {
                return "more than 8 bytes";
            }
        }
        return "0x" + string.substring(string.length() - 2 * n);
    }

    public static String toHex(byte by) {
        String string = "00" + Integer.toHexString(by & 0xFF);
        return "0x" + string.substring(string.length() - 2);
    }

    public static String toHex(short s) {
        return OracleLog.toHex(s, 2);
    }

    public static String toHex(int n) {
        return OracleLog.toHex(n, 4);
    }

    public static String toHex(byte[] byArray, int n) {
        if (byArray == null) {
            return "null";
        }
        if (n > byArray.length) {
            return "byte array not long enough";
        }
        String string = "[";
        int n2 = Math.min(64, n);
        for (int i = 0; i < n2; ++i) {
            string = string + OracleLog.toHex(byArray[i]) + " ";
        }
        if (n2 < n) {
            string = string + "...";
        }
        return string + "]";
    }

    public static String toHex(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return OracleLog.toHex(byArray, byArray.length);
    }

    static {
        ModuleName = new String[]{"DRVR ", "unused", "DBCV ", "unused", "PIKL ", "JTTC ", "DATM ", "KPRB ", "XA   ", "SQLJ ", "JOCI ", "JPUB ", "T2C"};
        CategoryName = new String[]{"OPER ", "PERR ", "ERRO ", "WARN ", "FUNC ", "DBG1 ", "DBG2 ", "SQLS "};
        m_logWriter = null;
        m_logStream = null;
        m_printMask = 20;
        m_moduleMask = 0xFFFFFFF;
        m_submodMasks = null;
        m_categoryMask = 143;
        m_maxPrintBytes = 200;
        m_warningEnabled = true;
        m_msgNumber = 0;
        m_submodMasks = new int[32];
        for (int i = 0; i < 32; ++i) {
            OracleLog.m_submodMasks[i] = 0xFFFFFFF;
        }
        OracleLog.initialize();
    }
}

