/*
 * Decompiled with CFR 0.152.
 */
package railo.applet;

import java.applet.Applet;
import railo.applet.FormElement;
import railo.applet.FormElementException;
import thinlet.Thinlet;
import thinlet.objectwrapper.EnumOrientation;
import thinlet.objectwrapper.Label;
import thinlet.objectwrapper.Method;
import thinlet.objectwrapper.OWObject;
import thinlet.objectwrapper.Panel;
import thinlet.objectwrapper.Slider;

public class SliderThinlet
extends FormElement {
    private LabelValue labelValue;
    private Label label;
    private Slider slider;
    private boolean refreshLabel;

    public SliderThinlet(Applet applet) throws FormElementException {
        super(applet);
        int value;
        Panel panel = new Panel(this);
        panel.setColumns(1);
        panel.setGap(1);
        panel.setTop(3);
        panel.setLeft(3);
        panel.setRight(3);
        panel.setBottom(3);
        panel.setWidth(600);
        panel.setBorder(false);
        this.add(panel);
        String strLabel = this.getProperty("label", "");
        if (strLabel.length() > 0) {
            this.labelValue = new LabelValue(strLabel);
            this.label = new Label(this);
            panel.addChild(this.label);
            this.label.putProperty("color", "#cccccc");
        } else {
            strLabel = null;
        }
        this.slider = new Slider(this);
        this.slider.setWidth(600);
        this.slider.setWeightx(1);
        this.slider.setWeighty(1);
        int min = this.getProperty("minimum", 0);
        this.slider.getMinimum(min);
        int max = this.getProperty("maximum", 100);
        this.slider.getMaximum(max);
        int dspValue = value = this.getProperty("value", 50);
        if (dspValue < min) {
            dspValue = min;
        }
        if (dspValue > max) {
            dspValue = max;
        }
        this.slider.getValue(dspValue);
        this.drawLabel(String.valueOf(value));
        boolean vertical = this.getProperty("vertical", false);
        if (vertical) {
            this.slider.setOrientation(EnumOrientation.VERTICAL);
        } else {
            this.slider.setOrientation(EnumOrientation.HORIZONTAL);
        }
        panel.addChild(this.slider);
        this.refreshLabel = this.getProperty("refreshlabel", true);
        this.writeData(String.valueOf(value));
        this.slider.defineAction(new Method(){

            public void run(Thinlet thinlet, OWObject component) {
                String value = "" + SliderThinlet.this.slider.getValue();
                SliderThinlet.this.writeData(value);
                if (SliderThinlet.this.refreshLabel) {
                    SliderThinlet.this.drawLabel(value);
                }
            }
        });
    }

    private void drawLabel(String value) {
        if (this.labelValue != null) {
            this.label.setText(this.labelValue.toString(value));
        }
    }

    public static void main(String[] args) {
    }

    class LabelValue {
        private String before;
        private String after;

        public LabelValue(String str) {
            int index = str.indexOf("%value%");
            if (index == -1) {
                this.before = String.valueOf(str) + " ";
                this.after = "";
            } else {
                this.before = str.substring(0, index);
                this.after = str.substring(index + 7);
            }
        }

        public String toString(String value) {
            return this.before + value + this.after;
        }
    }
}

