# Project Ideas

Both tiers and specializations will require 'Tier Programming Projects', you are free to select any programming project you want. To help combat the 'but I don't know what I want' roadblock, this section lists a variety of ideas. Note: In specializations, the Tier Programming Projects might have extra criteria (such as 'if you're doing a mobile app development specialization your projects must be mobile apps')
  
**Note:** Your projects can be any programming project you wish: web development, mobile development, games, applications, command line utilities, browser extensions, compilers, _anything_. They can be small to large endeavors. Pick something you want to code, that will provide you practice with existing skills or stretch you to grow new skills. Ideas: clone a popular website, clone a website template, create or clone a game, build a command line utility, enter a hackathon/programming competition. Many other ideas are listed below but keep in mind that they are only ideas - you are completely free to either use one of the ideas listed below or an idea of your own.

- [Project Ideas](#project-ideas)
  - [To Practice Frontend Web, Mobile App, or Desktop Development](#to-practice-frontend-web-mobile-app-or-desktop-development)
  - [To Practice Algorithms and Data Structures](#to-practice-algorithms-and-data-structures)
  - [To Practice working with others](#to-practice-working-with-others)
  - [Game Programming ideas](#game-programming-ideas)

## To Practice Frontend Web, Mobile App, or Desktop Development

**Clone one or more of the following Website Templates (or the frontend of any website or theme you like) as a web or mobile app:**

- [this theme](https://blackrockdigital.github.io/startbootstrap-landing-page/), include all features (hover effects, animations, pages, etc)
- [this theme](https://blackrockdigital.github.io/startbootstrap-agency/), include all features (hover effects, animations, pages, etc)
- [this theme](https://blackrockdigital.github.io/startbootstrap-resume/), include all features (hover effects, animations, pages, etc)
- [this theme](https://blackrockdigital.github.io/startbootstrap-stylish-portfolio/), include all features (hover effects, animations, pages, etc)
- [this theme](https://webthemez.com/preview/?ballet-one-page-free-website-template/), include all features (hover effects, animations, pages, etc)
- [this theme](https://webthemez.com/demo/delta-corporate-material-design-bootstrap-html-template/index.html), include all features (hover effects, animations, pages, etc).
- [this theme](https://blackrockdigital.github.io/startbootstrap-creative/), include all features (hover effects, animations, pages, etc)
- [this theme](https://blackrockdigital.github.io/startbootstrap-coming-soon/), include all features (hover effects, animations, pages, etc)
- [this theme](https://webthemez.com/preview/?lookup-interior-design-bootstrap-website-template/), include all features (hover effects, animations, pages, etc)
- [this theme](https://webthemez.com/demo/flavour-restaurant-html5-responsive-web-template/), include all features (hover effects, animations, pages, etc)
- [this theme](https://webthemez.com/demo/fine-best-app-landing-page-free-web-template/), include all features (hover effects, animations, pages, etc)
- [this theme](https://webthemez.com/demo/startup-multi-purpose-responsive-html5-bootstrap-template/), include all features (hover effects, animations, pages, etc)

**Clone a Web Application as a Web, Mobile, or Desktop App:**

- Twitter
- Snapchat
- Instagram
- Uber
- Netflix
- Medium
- Trello
- Slack
- Facebook

**Create a new Web, Mobile, or Desktop App in a typical category:**

- Blog
- Forum
- Todos
- Notepad
- E-commerce
- Product
- Restaurant
- Real Estate
- School
- Festival
- Tech News
- Fitness
- Tutorial
- Flash Cards
- Recipes
- Document Editor
- Support Tickets
- Community Chat

**Clone a favorite game (or create a new one) as a Web, Mobile, or Desktop App**

## To Practice Algorithms and Data Structures

**Complete any of the following archived coding competitions prior to 2015:**

- [Facebook Hacker Cup](https://www.facebook.com/hackercup/past_rounds/228440181128818/)
- [Google Kick Start](https://codingcompetitions.withgoogle.com/kickstart/archive)
- [Google Code Jam](https://codingcompetitions.withgoogle.com/codejam/archive)
- [Google Hash Code](https://codingcompetitions.withgoogle.com/hashcode/archive)

**Complete a [CodinGame](https://www.codingame.com) Sponsored Contest**

**Complete one or more sections on [HackerRank](https://www.hackerrank.com)**

## To Practice working with others

**Contribute to Open Source**

- [CodeTriage](https://www.codetriage.com/)
- [First Timers Only](http://www.firsttimersonly.com/)

[This site](https://opensource.guide/how-to-contribute/) has a ton of information about how to break into open source.

**Enter a hackathon**

- [list on devpost](https://devpost.com/hackathons?utf8=%E2%9C%93&search=&challenge_type=online&sort_by=Submission+Deadline)
- [HackerRank Contests](https://www.hackerrank.com/contests)
- [Itch.io Game Jams](https://itch.io/jams)

## Game Programming ideas

Clone one of the following (note, do NOT publish as your own, you'll get sued)

- Pong
- Zork
- Mastermind
- Memory Puzzle
- Galaga
- PacMan
- Breakout
- Solitaire
- Flappy Bird
- Space Invaders
- Super Mario Bros
- Fruit Ninja
- Last Stand
- Tetris
- Angry Birds
- Bejeweled
- Sokoban
- Katamari Damacy
- Blackjack (with AI opponents)
- Checkers (with AI opponent)
- Donkey Kong
- Tron (two players, with an option for multiplayer or AI opponent)
- Pokemon
- Monopoly (1-4 players, with an option for multiplayer or AI opponent)
- Bomberman
- Diablo
- Zelda
- Scythe
- Minecraft
- Risk
- Lunar Lander
- Streetfighter
- Castlevania