# Design School 101

- [Color](#color-theory)
- [Typography](#typography-theory)
- [User Interface Design](#user-interface-ui-design)
- [Resources](#resources)


## Color Theory

### Understanding the Mood of Your Color Palette

- **RED** love, energy, intensity - exciting, fast, etc
- **YELLOW** joy, intellect, attention
- **GREEN** freshness, safety, growth
- **BLUE** stability, trust, serenety
- **PURPLE** royalty, wealth, femininity

### Combine Colors to Create Color Palette

- **Analogous color palette** create designs that are incredibly harmonious and easy to look at., E.g. main interface
  - analogous color on adjacent color or combine with the color next to it.
- **Completementary color palettes** produce extremely flashy designs that stand out that grab your attention, E.g. logo design, screenshots but not very good with the main interface
  - complementary color is the opposite of analogous color, taking a color and match it with a color that's directly opposite to it.
- **Split Colors palette**, E.g. app icon design
  - tone down the flashiness of complementary color by taking a color (red) then instead of direct opposite (green) split that color into analogous color (limy yellow and light blue), end up with designs that are still attention grabbing but are less classy and easier to look at
- **Triadic color palette** tends to be quite well balanced and yet still attention grabbing, E.g. overused during 90s traditional print & advertising design, feels a little bit dated
  - pick color then draw an equal natural triangle that links up to other colors
- **Monochromatic color palelte** tends to be incredibly contemporary and work really well with modern digital design
  - taking the same color and combining it with either various amounts of white or black to create different tones and shades that stand out from each other

### Tools for Designing with Color

- ColorHunt for Web and Apps
- FlatUIColors works more with IOS Apps
- MaterialPalette works well with Android
- ColorZilla is a free Chrome and Firefox browser extension


## Typography Theory

### The Serif Type Family

See the thinnest vs thickest part of the letters, you'll see an increased difference in modulation of the typeface

- **Old Style serif** typeface very conservative and very old looking, E.g. Adobe Jensons, Centaur, Goudy old style, 4400
- **Transitional serif** typeface is slightly more modern looking, E.g. `Times New Roman`, `Baskerville`, `Georgia`
- **Modern serif** typeface is much modern yet classy looking typeface, E.g. `Didot`
- **Slab-Serif** typeface is created specifically for newspaper printing to make it still look good even with poor quality paper

### The Sans-Serif Type Family

Differentiated from the Serif by not having a decorative elements along the central beams, top bars, and etc.

- **Grotesque sans-serif** typeface is the oldest sans-serif, E.g. `Franklin Gothic`, `News Gothic`
- **Neo-Grotesque sans-serif** typeface, E.g. `Helvetica`, `Arial`
- **Humanist sans-serif** typeface, E.g. `Gill Sans`, `Tahoma`, `Verdana`
- **Geometric sans-serif** typeface can be differentiated by their perfect circle letter `o`, E.g. Futura

### Combine Fonts Like a Pro

Have a different typeface for Heading and the body to create slight contrast and interest in your designs.

Each typeface has a personality and mood.

Rules:

- serifs and sans-serifs work together really well
- serif heading with a sans-serif body creates a good design because sans-serifs increased readability compared to serifs
- sans-serif heading with a serif body that have little bit of contrast creates a beautiful design
- don't mix a sans-serif with sans-serif or serif with serif because it can look a little bit bland, undifferentiated and it can look undesigned
- two different fonts will make your design look more elevated but too many fonts will ruin it
- each typeface has a personality and has a mood
- don't mix different moods or font eras
  - Similar
    - Mood
    - Time Era
  - Contrast
    - Serif-ness
    - Weights
- Avoid using these fonts:
  - Kristen
  - Comic Sans
  - Papyrus
  - Viner
  - Curlz
- **Font Tools**:
  - WhatFont
  - Font Squirrel
  - SkyFonts


## User Interface (UI) Design

### 1. If an App was a Journey

 - you are the tour guide that takes the user on a wonderful journey through the app
 - human attention is programmed in a way that's always drawn to the biggest, boldest, brightest things first, then moves to the rounder, then smaller, then light shade of thngs

### 2. How to Pretend You Have a Designer

- importance of alignment and it's the key to graphical and digital design
- low effort but makes a huge amount of difference
- two fundamental types of alignment:
 - **Edge Alignment** where you have all the elements having one side lining up with a single line, mostly used in UI design
 - **Centre Alignment** where you line up all the elements by their midpoint

### 3. How to Get More Clickthrough

- good practice in Interaction Design
- light always comes from above
- design your UI elements that give users a hint as how they can be interacted with, E.g. buy or download button
- design that gives a reminder of how a screen button is similar to a real life buttons
- golden rule in design: function comes before forms in all cases
- **flat design** is a style of interface design emphasizing minimum use of stylistic elements that give the illusion of three dimensions (such as the use of drop shadows, depth, gradients or textures) and is focused on a minimalist use of simple elements, typography and flat colors.
- **material design** is inspired by the physical world and its textures, including how they reflect light and cast shadows.


### 4. How to Design if You Know Nothing About Design

- start with the simplest thing possible then go upwards
- focus on the alignment making things look good without distracted by colors, images or any fancy stuff
- start in monochrome and give it a single color to highlight the key things that you want to draw people's attention to
- if everything is black and white event a hint of color will stand out

### 5. Make Text Visible on Images

- use a black background or a high opacity background just for the text
- if you can control the bakcground image or will never change then you can adjust the color of the text and the color of the image background to make it stand out
- if image has to change, you can have a colored overlay to your image that sits between your text and image, E.g. apply a single black overlay with 20% opacity just enough the text to stand out without obscuring the image behind
- use a gaussian blur that provides contrast between the blurry image and sharp text to make the text stand out
- apply an overlay to the image that starts off with 0% opacity at the center midline and then downwards there's a graded opacity so the overlay gets more and more opaque the further you go down
- if text is always going to be at the bottom of your image you can make the overlay super opaque at the bottom like 20% then 0% opaque at the middle so you don't obscure the image while making text appear sharp

### 6. How to Become an Attention Wizard

- make the text larger or smaller, make it bolder, brighter in color or make it more muted
- typeface with heavy weighting vs thin or light
- uppercase, lowercase, italic, increasing distance between each of the letters to make it look more spacy


## Resources

- Curated color palettes on [ColorHunt](https://colorhunt.co/)
- Popular iOS colors from [Flat UI Colors 2](https://flatuicolors.com/)
- Popular Android colours from [Material Palette](https://www.materialpalette.com/)
- [ColorZilla](https://www.colorzilla.com/)
- [WhatFont Chrome browser extension](https://chrome.google.com/webstore/detail/whatfont/jabopobgcpjmedljpbcaablpmlmfcogm?hl=en)
- [Font Squirrel](https://www.fontsquirrel.com/)
- [SkyFonts](https://skyfonts.com/)
- [Create Emotion With Color In UX Design](https://uxplanet.org/create-emotion-with-color-in-ux-design-446a3766b085)
- [26 Digital Typography Rules for Beginners](https://medium.com/product-design-ux-ui/26-digital-typography-rules-for-beginners-a04c6a5aaff3)
- [XD Essentials: Typography in Mobile Apps](https://medium.com/thinking-design/xd-essentials-typography-in-mobile-apps-7048abfb1cc5#.tu3y5hv6z)
- [Need hints for good fonts? Here's 14 typographers with their favorite fonts](https://www.canva.com/learn/distinguished-typographers-share-their-favorite-fonts/)
- [What's The Difference Between A Font And A Typeface](https://www.fastcompany.com/3028971/whats-the-difference-between-a-font-and-a-typeface)
- [Web Design in 4 minutes](https://jgthms.com/web-design-in-4-minutes/)
- Searching [dribbble](https://dribbble.com/) for Specific Color
- [Translating Client Speak: What Clients Say and What they Mean](http://platowebdesign.com/articles/translating-client-speak-infographic/)
- [Golden Rules of User Interface Design](https://uxplanet.org/golden-rules-of-user-interface-design-19282aeb06b#.kfznrp77q)
- [Designing User Interfaces for My Mother](https://medium.com/@TGines/designing-user-interfaces-for-your-mother-dd45ec50f7b0#.j4bcs8rto)
- [A Place for Sharing Ideas and Stories](https://www.teehanlax.com/story/medium/)