# Introductions

## Front-End Web Development

### Goal

- Understand how websites work and how HTML, CSS and JavaScript contribute.
- Understand how the internet works.
- Start coding with HTML, CSS, and JavaScript.
- Learn and understand git, GitHub and version control.
- Use the Unix command line to become a power user and write bash commands.
- Learn key troubleshooting and debugging skills to apply to the projects.

### What You'll Get in This Course

- Starting Course for Beginners to Expert
- 2019 Ready
- Full-Stack
- Vote for New Modules

### How to Get the Most Out of the Course

- Pause the video at around 10 minute mark and stop coding along, but instead understand the purpose of the code, then replicate the output of the code.
- Use Cornell Note Taking System, review the notes with keywords and summary.
- Change the speed phase of the video according on how you will understand it better.
- Don't Skip anything...
- Bookmark the section/topic you are struggling with, then come back to it later.
- Persevere and put an effort/time to practice.
  - Practice = Master
- You will be stuck just like everybody else. 99% of the time, you were not the first person who've across that problem. So search google, stackoverflow, and etc.
- Struggle is Good. Because you will improve and level up your skill.

### Setup Local Web Development Environment

- Download and Install a Web Browser Google Chrome
- Download and Install Code Editor Atom or Visual Studio Code

Atom Recommended Packages:

1. atom-beautify
2. atom-ternjs
3. autoclose-html
4. emmet
5. csslint
6. **linter**
  - When you install **linter** it will ask you to install the dependencies for the package, click agree to all and install. 
7. **linter-jshint**
8. pigments
9. language-ejs

Optional Packages:

1.  atom-html-preview
2.  Sublime-Style-Column-Selection
3.  linter-eslint

### How Does the Internet Actually Work

- Internet is just a long piece of wire, and the wire connects different computers to each other.
- Servers are computers that are online usually 24 hours to serve  you all the data and files you are requesting when you try to access websites.
- Clients are the ones we use to access internet.
- A Web Server is like a giant library that's open 24/7, you can go there any hour of the day and request I want to see google's homepage, then serves you with all the files and datas you will need to view that websites you requested.
- Internet Service Provider (ISP) are the ones you pay to access internet. example: ATNT, comcast
- IP Address is a unique identify or postal address of every devices/computer.
- Domain Name Systems(DNS) Server is just like a phonebook find the IP address of the website you are trying to access.
- Internet Backbone is literally the backbone of the internet, that shows the cables of the servers connected to each other.

Client (Browser) -> Internet Service Provider -> DNS -> Google Server  
Client (Browser) <- Internet Service Provider <- DNS <- Google Server

216.58.210.46 Google Homepage

### How Do Websites Actually Work

Code Files:

1. **HTML** is for body structure like headings, images buttons, and etc.
2. **CSS** is responsible for styling web site. Styling an elements like adding colors, changing font style, size and even animations.
3. **JavaScript** can do things, it can add behavior to the websites, rathen than just displaying text or styling. Button Click functionality is one example of javaScript event.

Google webiste analogy: When we received the files from Google server, the browser load the **HTML** files to see the structure of the website. Then when we received **CSS** it will modify the appearance of all those components. Finally when we received the **JavaScript** files, then the website will start having behavior. 


## Back-End Web Development

### Goal

- Explore the components of back-end development, working with an MVC framework
- Apply concepts like data types, objects, methods, object-oriented programming, and classes in the context of backend development.
- Server-Side JavaScript
- Using Node on the command line
- NPM
- JavaScript Build Processes
- Event Loop and Emitters
- File System Interaction
- Modules
- Native Node drivers

Full Stack = Front-End + Back-End

Back-End Development consist of:

1. Server
2. Database
3. Application

Web Application doesn't just display information, it also has functionality on the backend that enables it to do something concrete.

Restaurant Analogy for a Full Stack Web Application:

- FRONT OF HOUSE restaurant is basically the client side. It's what the user sees in the the browser. They're able to interact with the website using JavaScript and able to see the information that's being displayed using HTML and CSS.
- Kitchen is the place where all the dishes gets served from. So when a restaurant goer ask for for a Philly steal then that order gets sent to the server and the server should send it back.
- Larder is where all the ingredients are stored which is the database.


Take our ingredients from the database so the server interacts with the database, then execute some code on the server and create the application/dish. It is gets served to the client side.

Some of the Back-end Programming Language technologies:

- PHP
- Ruby
- Java
- Node.js

Some of the Frameworks to speed up the development:

- cake PHP
- Ruby on Rails
- sprint
- Express 


## Resources

- [Google Chrome](https://www.google.com/chrome/)
- [Atom](https://atom.io/)
- [Visual Studio Code](https://code.visualstudio.com/download)