# Introduction
## Welcome To The Course
- This is a comprehensive course on **HTML & CSS**. We will go from the core basics to the latest features such as flex, grid, animation, variables, etc

### Who Is This Course For?
- This course is for anyone between an **absolute beginner** and a **seasoned developer** that wants to get better at CSS/UI and not have to rely on Bootstrap.
- **Section 1 - 4** are geared toward beginners as they teach the basics of HTML & CSS. Feel free to skip if needed

### What You Will Learn
- Basics of How Websites Work
- Setup & Tools
- HTML 5
- CSS Fundamentals
- Responsive Design
- Flexbox
- CSS Grid
- Animation (Transitions, Keyframes, etc)
- CSS Variables, Transform, Pseudo Selectors, etc
- Sticky Menus, Overlays, Form Styling, Landing Pages, etc
- Website Deployment - Shared Host & Netlify
- Sass - Still to Come

## How The Web Works (Summarized)
### The Internet
- **A global network of computers**
- Each computer/router has a **IP address** 73.158.6.61
- Computers talk to each other using the **TCP/IP** protocol
- **HTTP** handles web traffic (requests/responses)

### Web Servers
- **Websites/Webpages** are files stored on computers that run a piece of software called a **web server** (Apache, Nginx, etc)
- **Hosting companies** provide space on a server for your website
- **Domain names** can be purchased from registrars and linked to your hosting account/web server
- **DNS** is used to map IP addresses to domain names

### Process Of Loading A Webpage
User search for google.com to a browser like Google Chrome or any other browsers, and the DNS looks for the domain names google.com and it maps it to the IP Address its needed. Once it gets the IP Address it then makes a HTTP request to the Web Server of that IP Address. And the Web Server will return a responsive with HTML, CSS, JS, images files and whatever else needed for google.com to be loaded on your browser.

## The Roles Of HTML & CSS In Web Development
### HTML
- **Hypertext Markup Language**
- HTML is <u>not</u> a programming language
- Markup for creating webpages/documents
- HTML is extremely important & relevant but is also just the beginning

### CSS
- **Cascading Style Sheets**
- Styling/Stylesheet Language
- Used for styling HTML elements
- Can be extended with Sass/Less

### The Roles Of Web Technologies
- HTML = Content Display/Structure
- CSS = Style & Design
- JavaScript = Dynamic Front End Programming
- PHP, Python, C#, JS = Backend Programming
- MySQL, MongoDB = Database/Storage

### What Can HTML & CSS Do?
- Build static websites - Portfolios, small business sites, informational & brochure websites, etc
- Build the **visual** part of anything - Stores, social networks, etc

## Geeting Setup With Visual Studio Code
Download and Install [Visual Studio Code](https://code.visualstudio.com/)