# [Learning How to Learn: Powerful mental tools to help you master tough subjects](https://www.coursera.org/learn/learning-how-to-learn)

## Week 1: What is Learning?
 
#### Brain Facts:
- Cells of the nervous system are called neurons. Information from one neuron flows to another neuron across a synapse. Human brain has a million billion synapses.
- Your brain creates synapses whenever you learn something new. Sleeping helps "update" your brain cells. Literally.

#### Why do we procrastinate (scientifically):
#### Problem:
Learning a new thing or doing something you would rather not do can be stressing. This can cause anxiety at first. This activates the area associated with pain in the brain.

Your brain looks for a way to stop that negative feeling by switching your attention to something else more pleasant.

#### Solution:
The trick is to just start. Researchers discovered that not long after people start actually working out what they didn’t like, that neuro-discomfort disappeared.  
Remember that the better you get at something, the more enjoyable it can become.  
Consider using the pomodoro technique.

 
#### Learning hard and abstract things:
The more abstract something is, the more important it is to practice to create and strengthen neural connections to bring the abstract ideas to reality for you.

**Ex:** You should practice a lot with the math vocabulary to understand it and recall it easier. [∫∞ex dx, k!(n−k)!]

#### Summary:
1. There are two modes of thinking:
    1. **Focused mode:** Concentrating on things that are usually familiar.
    2. **Diffused mode:** A relaxed mode of thinking "your thoughts are free to wander".
2. When you don’t desire doing/learning something, go through it and just start. The discomfort goes away and, in the long term, this will lead to satisfaction.
3. When you learn something new, make sure to take time to rest, then come back to it and **recall** what you learnt.
    - This is very important. Don’t cram information in one day. This leads to inefficient learning. It’s like building a wall without letting it dry.
    - Revisiting and practicing what you learn is important. Research shows that **spaced repetition** (repeating things after few days) is the best way to build and strengthen the synaptic connections.
4. **Sleep** is very important. It clears the metabolic toxins from the brain after a day of "brain use". It is best to sleep directly after learning new things.
5. It was shown that physical **exercise** and/or being in a rich social environment helps your brain produce new neurons.

## Week 2: Chunking

#### Chunks:
Pieces of information, neuroscientifically speaking, bond together through use and meaning. They can get bigger and more complex, but at the same time, they are single easy to access items that can fit into the slot of the working memory.

- **Chunking** is the act of grouping concepts into compact packages of information that are easier for the mind to access.

**Example:** If you understand and practice a math formula. You no longer need to focus much to solve it, like you did the first time. That’s because your "formula chunk" got so abstracted into your brain that it can only take one slot of your working memory to solve it.

**Turn off distractions.** You want to use all the **4** slots of your working memory when studying. Learning will be inefficient if some of those slots are connected to something else.

**You have to solve the problem yourself.** Just because you see it, or even understand it, doesn't mean that you will be able to solve it (**Illusion of competence**). It is always easier to look at the material, even if you think it’s easy, then doing it yourself.

**It gets easier.** When you think that a chapter or a book has too much information and that there’s no way to go through them all; just focus on whatever section you’re studying. You’ll find that once you put that first concept in your mental library, the following one will be easier.

This concept is called **Transfer**; a chunk you have mastered in one area can often help you much more easily learn other chunks of information in different areas.

**Master the main idea** and then start getting deeper. However, make sure not to get stuck in some details before having a general idea. Practice to help yourself gain mastery and sense of the big picture context. Try taking a "picture walk" before you dig through the material, this means, look briefly at the pictures, chapter titles, formulas used… before diving into details.

 
**Recall mentally** without looking at the material. This is proven more effective than to simply rereading. Reread only after you try to recall and write down what was in the material.

Consider recalling when you are in different places to become independent of the cues from any giving location. This will help you when taking a test in the class.

**Test yourself** to make sure you are actually learning and not fooling yourself into learning. Mistakes are a good thing. They allow you to catch illusions of competence.
 
**Don’t always trust your initial intuition.** **Einstellung** problem (a German word for Mindset). An idea or a neural pattern you developed might prevent a new better idea from being found. Sometimes your initial intuition on what you need to be doing is misleading.You’ve to unlearn old ideas and approaches as you are learning new ones.

 
**Mix up the problems (Interleaving)** from different chapters. This is helpful to create connections between your chunks. It can make your learning a bit more difficult, but it helps you learn more deeply. Interleaving is very important. It is where you leave the world of practice and repetition, and begin thinking more independently.
 
**Don’ts:**
- Highlighting too much and creating maps are often ineffective without recalling.
- Repeating something you already learnt or know very well is easy. It can bring the illusion of competence; that you’ve mastered the full material when you actually just know the easy stuff. Balance your studies and focus on the more difficult (deliberate practice). This sets the difference between a good student and a great student.
- A big mistake is to blindly start working on an exercise without reading the textbook or attending the class. This is a recipe of sinking. It’s like randomly allowing a thought to pop off in the focus mode without paying attention to where the solution truly lies.

## Week 3: Procrastination and Memory

#### Procrastination:
- The routine, habitual responses your brain falls into when you try to do something hard or unpleasant. Focusing only on making the present moment feels better.
- Unlike procrastination which is easy to fall into, Willpower is hard to come by. It uses a lot of neural resources and you shouldn’t waste it on fending off procrastination except when really necessary. You actually don’t need to.
- The long-term effect of Procrastination can be dangerous. Putting your studies off leads to studying becoming even more painful. Procrastination is a habit that affects many areas of your life, if you improve in this area, many positive changes will unfold.
- Procrastination shares features with addiction. At first, it leads you to think that if you study too early you’ll forget the material. Then, when the class is ahead of you, it leads you to think that you are inadequate or that the subject is too hard.
- You want to avoid cramming which doesn’t build solid neural structures, by putting the same amount into your learning, and spacing it over a long period by starting earlier.

#### First time learning something:
- The first time you do something the deluge of information coming at you would make the job seem almost impossibly difficult. But, once you've chunked it, it will be simple.
- At first, it's really hard, later it's easy. It becomes like a habit. **Ex:** Driving for the first time.

#### Habits:
- Neuro-scientifically speaking, chunking is related to habit.
- Habit is an energy saver. You don’t need to focus when performing different habitual tasks.
- Habits can be good or bad, brief or long.

#### Habits Parts:
1. **The cue:** The trigger that launches you into zombie mode (habitual routine).
    - Recognize what launches you in zombie procrastination mode:
        1. Location
        2. Time
        3. How you feel
        4. Reactions (to people/events..)
    - Consider shutting your phone/internet for brief periods of time to prevent most cues.
2. **The routine:** Routine you do in reaction to the cue.
    - You only need to use your willpower to change your reaction to the cues.
    - Actively focus on rewiring your old habits.
        - You need a plan. You need some willpower.
3. **The reward:** Habits exist because they reward us.
    - Give yourself bigger rewards for bigger achievements. But after you finish them.
        - **Ex**: If I study for 4 hours today, I’ll watch a movie, guilt free, at night.
    - Habits are powerful because they create neurological cravings. It helps to add a new reward if you want to overcome your previous cravings.
    - Only once your brain starts expecting a reward will the important rewiring takes place that will allow you to create new habits.
4. **The belief:** To change your habits, you need to change your underlying belief.
    - **Ex:** You might feel like you’ll never be able to change the habit of studying late. This is not true. You can actually rewire your brain
    - Joining a student community helps, either online or in real life.
    - Trust your system. You have to feel happy and worry-free when you are resting.

#### Weekly/Daily list:
- Researchers showed that writing your daily list the evening before helps you accomplish them the next day. If you don’t write them down, they will take the valuable slots of memory.
- Plan your finishing time, this is as important as planning your working time.
- Work in the most important and most disliked task first, even if it’s only one pomodoro.
- Take notes about what works and what doesn’t.
- Have a backup plan for when you will still procrastinate.

#### Focus on Process:
You should realize that it’s perfectly normal to start a learning session with a negative feeling even if you like the subject. It’s how you handle those feelings that matters.

**Solution:** Focus on the process, not the product. The product is what triggers the pain that causes you to procrastinate. Instead of saying "I will solve this task today", put your best effort for a period of time continuously over the days.

#### Memory:
- Use your **visual memory** to remember things.
    - **Ex:** Link a memorable picture to a formula.
- **Images** help you encapsulate a very hard to remember concept by tapping into visual areas with enhanced memory abilities.
- The more **neural hooks** you can build by evoking the senses the easier it will be for you to recall the concept.
- Keep repeating what you want to learn so that the metabolic toxins won’t suck away the neural patterns related to that memory. **Spaced repetition** is the key.
- **Flashcards** help. Consider using Anki.
- **Handwriting** helps you deeply convert what you are trying to learn into neural memory structures.

#### Memory Techniques:
- Create meaningful groups and abbreviations.
- To remember numbers, associate them to memorable events.
- Create mnemonic phrases from first letters of the words you want to remember.
- **Memory Palace Technique:** Use a _familiar place_ (like the blueprint of your house) and associate _visual images_ of things you want to remember with physical places.
    - This is not easy. You’ll be very slow at first. But with practice, you’ll get better.
    - The more you practice your "_memory muscle_" the easier you’ll remember.

## Week 4: Renaissance Learning and Unlocking Your Potential

#### You should know:
- **Exercising** is by far more effective than any drug to help you learn better. It helps new neurons survive.
- Learning doesn't always progress linearly and logically. Inevitably your brain will hit a knowledge-collapse sometimes. This usually means your brain is restructuring its understanding, building a more solid foundation.
- You learn complex concepts by trying to make sense out of the information you perceive. Not by having someone else telling it to you.

## Metaphors
- **Metaphors** and **analogies** are very helpful, not only to memorize, but to also understand different concepts.
- It is often helpful to pretend that you are the concept you’re trying to understand.

#### Intelligence:
- Intelligence does matter. Being smart usually equate to having a large working memory (more than just four slots).
- However, a super working memory can hold its thoughts so tightly that new thoughts won’t easily find a way into the brain. Such a tightly controlled attention could use an occasional breath of ADHD. You attention shifts even if you don’t want it to shift.
- **Deliberate practice** is what helps the average brain lift into the realm of those naturally gifted. Practicing certain mental patterns deepens your mind.
- Brilliant scientist like Ramón y Cajal, the father of neuroscience, or Charles Darwin, were not exceptionally gifted. The key to their success was **perseverance**, **taking responsibility for their learning and changing their thoughts**.
- Take pride in the qualities you excel at. Tune people out if they try to demean your efforts.

#### Right hemisphere:
- Helps us put our work into the **big picture perspective** and does reality checks.
- When you go through a homework or test questions and don’t go back to check your work, you’re acting like a person who’s refusing to use parts of his brain.

#### Left hemisphere:
- Interprets the world for us but with a tendency for rigidity, dogmatism and egocentricity.
- May lead to overconfidence. **Ex:** believing dismissively that your answers are corrects.

#### Best practices:
- Always step back and recheck to takes advantages of abilities of both-hemispheres interactions.
- Brainstorm and find focused people to analyze your work with.
    - Your errors are sometimes easier to be found by others.
    - Explaining yourself to others helps you understand more.
    - Studying in a team helps you catch what you missed, or what you can’t see.
- Don’t fool yourself. Don’t blindly believe in your intellectual abilities. Having a team can bring those projections down.

#### Test Checklist:
- Did you make a serious effort to understand the text? If you had a study guide, did you go through it?
- Did you attempt to outline every homework problem solution?
- Did you understand all your homework problems’ solutions? If not, did you ask for explanations?
- Did you work with classmates on homework problems? checked your solutions?
- Did you consult your instructor/teacher when you had a problem with something?
- Did you sleep well the night before the test?

#### Test Taking Technique: Hard Start - Jump to easy: (Try this strategy with homework problems first)
1. Take a quick look at the test when it’s handed to you to get a sense of what it involves.
2. Start with the hardest problem. Pull yourself out if you get stuck for over 2 minutes. _Starting with a hard problem loads your focused mode first and then switches attention away from it. This allows the diffused mode to start its work._
3. Turn next to an easy problem. Solve what you can, then move back to a hard one. _This allows the different part of your brain to work simultaneously on different thoughts._

#### Taking Test Tips:
- Being Stressed before a test is normal. The body puts ups out chemicals when it’s under stress. How you interpret the body reaction to those chemicals makes all the difference.
    - Shift your thinking from "I am afraid of this test" to “I am excited to do my best”.
- If you are stressed during a test, turn your attention to breathing. Relax, put your hand on your stomach and slowly draw some deep breaths. This will calm you down.
- Relax your brain on the last day before a test. Have a quick final look at the materials. Feeling guilty the last day is a natural reaction even if you prepared well. So relax.
- Good worry motivates you. Bad worry wastes your energy.
- Double check your answers. Look away, shift your attention, and then recheck.

 