# The Complete Software Developer's Career Guide

It's nice to read a book and perhaps even agree wholeheartedly with the author but, it doesn't come to much use if you don't apply what you are learning in your life.

**REPETITION**  
If you really want to change your behaviors and adopt principles and best practices in your life, one of the best ways to do so is to surround and immerse your brain in the ideas and concepts you want to integrate into your life.
- One of the best ways to do this is to utilize repetition.
- read and re-read the sections of this book which are most relevant.

**ACTION**  
All of the ideas and strategies I'm about to share with you won't do you or your career any good unless you start taking practical steps to put them into action.


## SECTION 1 - GETTING STARTED AS A SOFTWARE DEVELOPER
"If you have a dream, you can spend a lifetime studying, planning and getting ready for it. What you should be doing is getting started." —Drew Houston

Whether it's starting a new workout regimen, training for a marathon, starting a business, writing a book, or more specifically, in this case, programming, the most difficult part is always getting started.
- It's easy and tempting to waste away countless hours debating what you should do.
- It's much easier to read and study than to actually do.
- It's much easier to think about taking a step and debate endlessly of what direction you should take that step, than it is to actually do it.
- But, the secret is, you only need to take one step at a time.


Summon all the courage and determination you can muster and say to yourself `"I've debated enough, I've pontificated enough, I've got a plan and it might not be the best one but, I'm just going to do it anyway."`

All the advice and information about software development is just there, but nothing will happen until you step out in faith and put the first foot forward.. `"trust the process"`.


### CHAPTER 2 - HOW TO GET STARTED
Learning to code and learning how to get started in the world of software development are two very different things.


#### LEARNING ABOUT THE PROFESSION  
**Software development isn't just programming.** Programming is a large part of it, but just knowing how to code isn't going to take you very far especially if you want to make a career out of this vocation.

The idea behind most software development projects is to **automate a manual process**, or to create a new automated way to do something that was too difficult to do manually.

You have to know how to manually do something before you can automate it.

#### UNDERSTANDING THE PROBLEM
**The process of software development always begins by first understanding the problem to be solved.** What are you automating?

Right now, the point is that you have to, in some way, gather some kind of requirements and an understanding of the problem being solved before you can write any code.

#### DESIGN
Once you achieve that understanding, you then come up with some kind of design for how that problem is going to be solved in code, again, before any code is written.

What is important is that **you have some level of design before you jump in and start coding.**  
While Agile development focuses on less up front design, **design is still necessary.**

#### WRITING THE CODE
Once you have some idea of the design of the software, it will be time to either write some tests that will define what the software is supposed to do (also known as Test Driven Development or TDD), or it will be time to start coding.

#### TESTING AND DEPLOYMENT
**Now comes the process of testing the code.** [Different methodologies are going to handle this in different ways](https://simpleprogrammer.com/agile-testing-is-different/), but in general, some kind of testing has to happen before the code is released to the end user.

For example in traditional, waterfall development projects, testing happens at the very end of a project, but in "agile" projects, testing happens during each iteration, which usually last about 2 weeks.

Once code is tested, it's ready for deployment, [which may be a whole process in itself](https://simpleprogrammer.com/deployment-made-simple/).

Deployment is the process of getting the finished software installed on a server, put into an app store, or made accessible in some other way to the users of that software.

#### MORE TO WRITING CODE THAN JUST WRITING CODE
**And finally, let's not forget debugging.** As a developer, a large amount of your time is going to be spent figuring out why your code or someone else's doesn't work.

#### HAVING A PLAN
There are many roads you can take to get there, but what's important isn't so much what road you take but rather that **you pick a road and stick to it.**

#### PUTTING TOGETHER THE PLAN
First of all, you need an honest assessment of where you are right now and what things you are going to need to learn.
- Do you have any programming experience?
- Do you know any programming languages?
- Have you ever built an application, or are you starting completely from the beginning?
- What about all these other skills I talked about earlier?
- Do you have any of them?
- Do you know anything about databases, source control, TDD, testing, debugging, or software development methodologies?
- Also, ask yourself what **kind of software development you want to do.**

[Everyone wants to be a game developer](https://simpleprogrammer.com/2016/05/19/game-development-career-viable/), but is that practical? And is that where you want to start? Are you willing to put in the long hours and fight with all the competition you'll face going down that long and lonely road?

**So many people set off in a direction in life but don't think things completely through first.**

I can give you all the information you need to become a good, even great software developer, but you are going to have to **organize it into an action plan** that is tailored to you. And then you are going to have to follow it.

#### CREATING THE PLAN
**The best way to develop your plan is to work backwards from the goal you want to achieve.**

Rather than "learning to program" or "becoming a software developer", you should come up with **a specific goal of the kind of software developer you want to be.**

You want to be **as specific as possible**, so that you can know exactly what it is you need to learn, how you want to craft your resume and portfolio, what schools or programs you might want to enroll in, and even what jobs you want to apply for.

The more specific you are about what kind of software developer you want to become, **the easier EVERYTHING is going to be.**

#### WHO WANTS TO BE AN "ATHLETE"?
How should you train to be an "athlete?"

Maybe you should lift weights and run, but maybe you should practice swimming. Maybe you should hit a ball with a tennis racket.  
Better do all those things and more, so you are prepared for any sport that you might end up getting on a team to play.

**Pick your sport.**  
Once you know the sport, you can know how to train for that sport and that will make your life much easie.

**Start with the goal and works backwards** to determine what you need to know and do in order to reach that goal.

Once you've done that, you can work out your plan.

The beginning of your plan should be all about what you need to learn. Figuring out the order of what you need to learn and how you are going to learn it is important.

Then, you should be figuring out what you will need to do to prepare for applying for jobs and getting your first job.

Finally, you need an actual plan for getting the job. Where are you going to look? What are you going to do? **What kinds of jobs are you going to apply for?**

Start thinking about **what your plan is going to look like**, and try to figure out **what kind of developer you want to become.**

#### But what kind of developer do I want to become?
Fortunately, this is not something difficult to figure out, although it may require a little bit of research.

Ask software developers you know what kind of software development they do or what kind of developers they are.

Think about what kind of things you are interested in creating and research some of the associated technologies and programming languages.

Think carefully and then research. If you ask the right questions, the answers are never hard to find.

#### A CONCRETE EXAMPLE
Let's look at a realistic scenario for someone who wants to become a web developer utilizing Node.js as their primary technology

- Goal: become a Node.js developer.
- Plan:
  - LEARNING
    - Learn the basics of JavaScript.
    - Learn about web pages and web development technologies like HTML and CSS.
    - Learn the basics of Node.js.
    - Be able to write some kind of simple Node.js web application
    - Learn about the different frameworks and technologies developers use to develop Node.js applications.
      - Fill in some frameworks or technologies to use with Node.js from research above.
      - Learn some kind of database technology to use with Node.js.
      - Learn computer science basics:
        - Algorithms.
        - Data structures.
      - Learn best practices for writing good code.
      - Learn how to design the architecture of a Node.js app.

  - PREPARING FOR GETTING A JOB
    - Start looking at job descriptions for a Node.js developer in my area and find out what skills employers want.
    - Come up with a list of companies, locally, that I can likely get a job at.
    - Start attending user groups in the area.
    - Start networking with other local Node.js developers.
    - Hire a resume writer to help me write a good resume.
    - Practice coding interview questions.
    - Practice mock interviews.
    - Build a portfolio of a few apps to demo

  - GETTING A JOB
    - Contact all the people in my networks to let them know what value I can provide and what I am looking for.
    - Start applying for junior-level jobs or internship programs.
    - Plan to apply for at least two jobs each day.
    - Debrief with myself after interview and decide what skills need to be worked on.

**Your plan will be rough at first**, but as you figure out more about what you need to learn and do, you can fill in more details.

**Having some kind of plan in place is important.** You can always change and adapt the plan, but if you don't have a plan to begin with, you'll be aimlessly floating in random directions and will probably get frustrated and be more likely to give up.


### CHAPTER 3 - THE TECHNICAL SKILLS YOU NEED TO HAVE
If you can't actually write code and develop software, all the soft skills you learn won't really do you much good. Perhaps you'd make a good manager or coach, but not a software developer.

#### THE SKILLS THAT PAY THE BILLS
Now, this is a topic that tends to overwhelm many beginner software developers because it can feel like there is **so much to know**, and it can be difficult to even **know where to start.**

#### ONE PROGRAMMING LANGUAGE
Can't really be a programmer without knowing a programming language.

[The choice of which programming language to learn](https://simpleprogrammer.com/2013/12/02/programming-language-learn/) **is not as important as you may think it is.**

Instead, start with just one programming language and not trying to learn everything there is under the sun.

Many beginner programmers try to hedge their bets by learning several programming languages at once before they try to take on their first job as a software developer.

**Don't do it upfront** because it will just lead to confusion, and it will divert your energies from many of the other technical skills you are going to need to learn, but eventually learn more than one programming language.

**Go deep and focus on learning the ins and outs of a single programming language**, so you can feel really confident in your ability to write code in that language.

Remember about being as specific as possible when deciding what kind of software developer you were going to become. That's the idea.

#### HOW TO STRUCTURE CODE
After learning a programming language or preferably while learning it, I believe that the next thing you need to know is how to properly structure your code.

**Excellent resource** to help you to learn this extremely valuable skill: Code
Complete by Steven McConnell.

It means to write **good, clear, understandable code that doesn't require a large amount of comments because the code itself is communicative.**

Many software developers go through their whole career without learning this skill, and it's unfortunate because this is the primary way many others judge the skill and competence of a software developer.

Good code structure shows a dedication to the craft beyond just getting the job done.

**Structuring your code is really the art part of software development**, but it's also critical because you and your co-workers have to work with your code and will spend considerably more time maintaining existing code rather than writing new code.

**You should strive to learn how to write good, clean code from the beginning** rather than learn this skill afterwards.

It's guaranteed that, even if you are a beginner, if you can write good, clean, concise, and understandable code that expresses its meaning in the structure itself, just about any interviewer who sees your code is going to **assume you are an experienced professional.**

And to some degree you will be, or at least on the path to be, because you'll be treating this career as a profession, not just a job: a sign of a true craftsman.

#### OBJECT ORIENTED DESIGN
This one is debatable, especially if you are learning a program language that isn't object oriented (OO), **but enough of the software development world thinks in terms of OO design, so you need to make sure you understand it.**

Object oriented design is a way of designing complex programs that breaks them down into individual classes or objects (instantiations of classes), which encapsulate functionality and have specific roles and responsibilities.

In software development,**we are always trying to manage complexity.**

Thinking in terms of objects helps us do that because it allows us to define and design a complicated system out of a bunch of interacting components, rather than try to tackle the entire complexity as a whole.

There are plenty of functional programming languages out there today, but **the most popular languages and patterns you'll find in software development are still heavily, if not completely, influenced by object oriented design and analysis.**

You should have a good understanding of what a class is, what the different types of inheritance are and when to use them—as well as understanding terms like [polymorphism](https://simpleprogrammer.com/2013/01/13/so-you-think-you-can-polymorph/) and encapsulation.

#### ALGORITHMS AND DATA STRUCTURES
This is a large portion of what you will or would learn if you took a traditional college or university program to get a degree in computer science.

Algorithms are the common ways of solving various computer science/programming problems.

For example, there are several algorithms that are commonly used for sorting lists of things programmatically. Each of these sorting algorithms has a different set of properties regarding speed, memory size requirements, and the ideal kind of data it works on.

There are many of these algorithms in the field of computer science, and it is also **important to [understand how to write your own variations](https://simpleprogrammer.com/2011/01/08/solving-problems-breaking-it-down/) of these algorithms** to solve the kind of tricky problems you might encounter when solving real programming problems.

Often, being good with algorithms can allow one developer to solve a problem in an hour that might take another developer several days to figure out.

Unless you are familiar and  good with algorithms, **you won't even know an elegant solution already exists out there.** So, for this reason alone, I consider it a valuable skill to acquire.

**Data structures fall into a similar category and work in conjunction with algorithms.**

There are several data structures all software developers should be familiar with including:
- Arrays or vectors
- Linked lists
- Stacks
- Queues
- Trees
- Hashes
- Sets

**By having a good grasp of data structures and algorithms, you can easily and elegantly solve many difficult programming problems.**

When John first started programming, He said he was really bad at data structures and algorithms because he was mostly self taught.  
He didn't realize the true value of them until [he started competing on a site called TopCoder](https://simpleprogrammer.com/2010/04/02/so-you-want-to-become-a-better-programmer-topcoder/) where knowing data structures and the algorithms that operate on them gave you a serious competitive edge.

Quickly, it became apparent how useful these skills were in the real programming world as he encountered problems that he previously had no idea how to solve, and which are now extremely easy and fun.  
In fact, **he consider this to be one of the most fun areas of software development.** It's really rewarding to work through a difficult problem and to utilize data structures and algorithms to develop a clean, elegant solution that performs really well.


**Excellent book** about everything you need to know about algorithms and data structures, [Cracking the Coding Interview](https://aax-us-east.amazon-adsystem.com/x/c/Qo0tkCmaKay-7qTh1M8-8NYAAAFfbc83mAEAAAFKAQFzLOQ/http://www.amazon.com/Cracking-Coding-Interview-6th-Programming/dp/0984782850/ref=as_at/?imprToken=JRpDWGmsELDwlhpTxgLdxw&slotNum=7&ie=UTF8&qid=1464723794&sr=8-1&keywords=cracking+the+coding+interview&linkCode=sl1&tag=makithecompsi-20&linkId=702b6ced4c8d80c475aee7ad3849cc82) by Gayle Laakmann McDowell.

It's a challenge to learn this stuff, but well worth it. This is one of those skillsets that can set you far above your peers. **A MAJORITYof software developers are pitifully ill-equipped in this area.**

And if you want to pass an interview at a company like Microsoft or Google, **you will definitely need to master this skillset.**

#### A DEVELOPMENT PLATFORM AND RELATED TECHNOLOGIES
You should have some experience and mastery of at least one development platform and the related technologies or frameworks that go with it.

**Platform** -> **generally it means operating system (OS)**, but it can also apply to other abstractions that act similar to operating systems.

For example, you could be a Mac developer or Windows developer focusing on the Mac or Windows operating systems, but you could also be a web developer focused on a specific web platform.

Companies usually hire developers to develop for a specific platform or technology.

You'll have a much easier time getting a job as an iOS developer if you have expertise with that specific platform.

This means being familiar with the platform itself, as well as what development tools, idiomatic patterns, and common frameworks programmers typically use when developing for that platform.

**You might think the choice of a programming language determines the platform, but that is actually rarely the case.**

Take C# today. You can be a C# developer and write code for Windows, Mac, iOS, Android, Linux, and even embedded systems.  
So don't just pick a language; pick a platform as well.

#### FRAMEWORK OR STACK
In addition to learning a specific programming language and platform, it's highly advise learning a framework or, better yet, a complete development stack that goes with it.

**A framework is simply a set of libraries that are used to develop code on a particular platform or on multiple platforms.** It usually makes common programming tasks on that platform easier.

Most C# developers use the .NET Framework for writing C# applications. The .NET Framework consists of many libraries and classes that allow a C# developer to work at a higher level of abstraction since he doesn't have to completely reinvent the wheel every time he wants to do something.

For example, part of the .NET Framework contains code for manipulating images. This code would be extremely difficult to write from scratch, so the framework is a huge benefit for C# developers writing code that needs to manipulate images in some way.

A stack is a bit different. **A stack is a set of technologies, usually including a framework, that are commonly used together to create a full application.**

For example, there is a common stack called the MEAN stack. It stands for MongoDB, Express.js, AngularJS, and Node.js.

- MongoDB is a database technology.  
- Express.js is a Node.js framework for creating web applications.  
- AngularJS is a front-end JavaScript framework for creating the user interfaces for web applications
- Finally, Node.js is a runtime environment for developing web-based applications in JavaScript.

It's not important that you understand all that unless you are going to be a MEAN developer, but what is important to understand is that, if you know all those technologies and frameworks, you'll be able to develop an entire web application.

**Stacks make it easier to create applications** because they provide a common paradigm which many developers are using to develop applications, so knowledge can easily be shared and you can be sure that a particular set of technologies are proven to work together.

Learning a stack can be extremely valuable because it means you have all the required skills to develop a full application. Many companies that have an application which was developed using a particular stack will be looking for software developers that are familiar with that stack and can hit the ground running.

#### BASIC DATABASE KNOWLEDGE
Even though the landscape of databases has changed quite a bit in the last few years, We can't see databases going away anytime soon, so it's better to know a thing or two about them.

At the time of writing this book, **there are two main database technologies**: relational databases and document databases.

A developer today should at least be familiar with relational databases and probably should have some understanding of document databases as well.

In software development, databases are often used to store data for an application.

Some teams will, of course, have dedicated database developers or database administrators (DBAs), but that doesn't really excuse you from not knowing at least the basics of databases.

At the very least, you should know:
- How databases work
- How to perform basic queries to get data
- How to insert, update and delete data
- How to join datasets together

In addition, you are probably going to want to know how to **retrieve and store data programmatically from your code** with your chosen platform and / or framework.

Most developers are expected to be able to write code that can interact with a database.

#### SOURCE CONTROL
Source control is an integral part of any software development project.

Way back years ago, they used source control, they have a network share with all the files for a project on it, or they pass thumb drives back and forth with different versions of the software on them.

**Almost all professional developers today are expected to know how to use source control to check in code, check out code, and hopefully merge changes from multiple sources.**

Source control at its most basic level allows you to keep a history of the changes made to different files in a software project.

It also allows for multiple developers to work on the same code at the same time and to merge those changes back together.

**You should know how to use at least one source control system very well**, and you should be familiar with most of the basic source control concepts.  
Just about all professional software development teams will use some kind of source control in today's software development world.

#### BUILD AND DEPLOYMENT
Today, most software development projects have some kind of automated build and deployment system.

There are several different software applications out there that help teams to automate both of these tasks, which used to be manual and, for some teams, still are.

**It would probably be a good idea to have some way to make sure that code actually works after you check it in.**

That's where a build system comes in.  
At the very least, a build system is going to compile all the code and make sure there are no compilation errors.

A sophisticated build system may also **run unit tests or user tests, run code quality checks, and provide some reporting** on the current state of the code base.

**A deployment system** will be responsible for deploying the code either to a production machine or perhaps to some kind of a test environment.

You don't have to be an absolute expert in these technologies, but **it's pretty important that you understand at least the basics of how these systems work**, and the process of building and deploying code.

Often, the actual responsibilities for creating and maintaining a build and deployment system will belong to a quickly growing field called DevOps (short for developer operations).  
But, that doesn't excuse you from understanding at least the basics of how this process works.

#### TESTING
It used to be that developers didn't have to know much about testing.

It used to be that they write a bunch of code and "throw it over the wall" to a bunch of testers who would find all kinds of bugs in their code, they fix the bugs, and that was that.

Not anymore.  
With so many software projects adopting what is called an Agile process, (we'll discuss this more when we get to methodologies), software developers and testers are having to [work much more closely together](https://simpleprogrammer.com/2010/06/16/agile-testing-is-different/).

**Quality has really become the responsibility of the entire team.**

You should at least be familiar with some basic terms in testing like:
- Whitebox testing
- Blackbox testing
- Unit testing (not really testing)
- Boundary conditions
- [Test automation](https://simpleprogrammer.com/getting-up-to-bat-series/)
- Acceptance testing

A good developer tests their own code before giving it to someone else.  
If you really want to be considered a professional and not just a hack, **this is non-negotiable.**

#### DEBUGGING
Many novice software developer has his dream smashed on the rocks of the debugger.

Everyone wants to write code, but ain't nobody want to debug their code?

**You are going to spend perhaps 90% of your time as a software developer figuring out** [why the hell your code doesn't work](https://simpleprogrammer.com/2011/06/17/the-debugger-mindset/).

If you apply a methodology like test-driven development, you'll probably spend a whole lot less time in the debugger, but regardless, whatever you do, no matter how you try and get around it, **you are going to have to learn how to debug your code** or someone else's.

So, rather than taking a haphazard approach to something you know you are going to have to do, you should just **bite the bullet and actually learn how to do it effectively.**

#### METHODOLOGIES
While some software development teams just start writing code and get things done when they are done, **most teams have some kind of methodology they at least pretend to follow.**

**Side note here:** [don't expect any team to actually really follow the software development methodology they profess to use](https://simpleprogrammer.com/2010/04/07/dont-go-chasing-waterfalls-mini-waterfall-vs-agile/).

_There are a whole lot of people who say they are doing software development methodologies like Scrum just because they have a meeting where everyone stands up every day_.

For this reason, it's critical that you are at least familiar with some of the basic ideas behind the most common software development methodologies.

Today, these are **waterfall development** and **Agile development.**

Most teams will claim they are doing Agile. Agile itself is a pretty loose concept, but there are some practices and, let's say rituals that you should be aware of if you want to be able to talk the talk, so to speak, and fit in on an Agile team.


### CHAPTER 4 - HOW TO DEVELOP TECHNICAL SKILLS
you'll be developing your technical skills as long as you are a software developer. **Think of it as a journey, not a destination.**

You will always be able to get better if you choose to.

[John said, he spent plenty of time developing his technical skills the wrong way](https://simpleprogrammer.com/lp/5-learning-mistakes-1/).

However, in my three years of creating over 50 highly-technical developer training courses on Pluralsight, I've also learned how to develop technical skills at a lightning fast speed while teaching others at the same time.

**I used to think the best way to learn a technical skill was to take a big reference book and read it cover-to-cover.**

Back then, I read too many 800+ page books to count and didn't benefit much from the exercise; although my arms might have grown from carrying around books of that size.

I don't want you to make the same mistakes I did, and if you already have, I want to show you a better way.

#### LEARNING HOW TO LEARN QUICKLY
John said, **he learned [whole programming languages in a matter of weeks](https://aax-us-east.amazon-adsystem.com/x/c/Qo0tkCmaKay-7qTh1M8-8NYAAAFfbc83mAEAAAFKAQFzLOQ/http://www.amazon.com/Seven-Languages-Weeks-Programming-Programmers/dp/193435659X/ref=as_at/?imprToken=JRpDWGmsELDwlhpTxgLdxw&slotNum=8&ie=UTF8&qid=1464892691&sr=8-1&keywords=7+languages&linkCode=sl1&tag=makithecompsi-20&linkId=8be1472231a19a02f8583418067860d0)** and then turned around and taught courses on them.

During that process, I developed a **reliable system** for learning just about anything I needed to learn.

This wasn't so much a conscious effort as it was a necessity. I was trying to learn at such a rapid rate that I had to come up with efficient ways of doing things, and naturally, patterns of learning developed which helped me to become faster and faster.

I'm just going to cover the basics here, since you can find a whole course I put together on the subject at ["10 Steps to Learn Anything Quickly"](https://simpleprogrammer.com/products/learn-anything/) or in a few chapters in my _[Soft Skills](https://aax-us-east.amazon-adsystem.com/x/c/Qo0tkCmaKay-7qTh1M8-8NYAAAFfbc83mAEAAAFKAQFzLOQ/http://www.amazon.com/gp/product/1617292397/ref=as_at/?imprToken=JRpDWGmsELDwlhpTxgLdxw&slotNum=9&ie=UTF8&linkCode=sl1&tag=makithecompsi-20&linkId=6421c2dd2fa69dd10dc93d1a3672be26)_ book.

#### THE BASIC PROCESS
The basic idea is pretty simple.  
Essentially, you want to first **get a good idea of what you are learning and what the scope of it is.**

You need to get enough information about your subject to understand the big picture and narrow the subject down to a small enough scope that you can actually tackle it and wrap your head around it in a realistic amount of time.

Then, **you need a goal.** You need to establish what it is you are trying to learn and why and, most importantly, what metric you will use to know that you've learned it.

**Far too many people set out to learn something but have no way to measure whether they have succeeded or not.**  
Equipped with that starting point, you can start to **gather some resources for learning.**  

Not just reading one book cover to cover but to instead gather multiple resources, which may include books, blogs, podcasts, magazines, video courses and tutorials, expert opinions, etc.  

Then, you are going to use some of those resources to create an actual plan for learning.

You can do this by using the resources you've gathered to create a systematic, sequential set of steps for you to learn what you want to learn.

For example, you could utilize the table of contents of one of the books you found to help figure out what order you should try to learn things in and what is important.

You are basically going to figure out in what order to learn everything you need to know about your topic.

**Then, you dive in.** From your learning plan, start with each module you are going to learn about your subject. For each module, **learn enough to get started, play around** for a bit, and then go back and **answer any questions you had** while playing around.

You are basically going to focus on **learning by doing.**

The key here is to not learn too much up front. Instead, utilize natural curiosity to drive your learning as you play around on your own. Then, go back and actually read the text or consume the content about your topic, with questions in your head and some experience which will **naturally guide you to seek out what is actually important.**

A big problem we face when learning by consuming a bunch of material is that we don't actually know what is important. By playing around first and forming your own questions, you solve that problem and what you learn actually sticks.

Finally, you **take what you learned and you teach it to someone else.**

What matters is that you somehow reorganize the thoughts in your head in a way that communicates them to the outside world.

This is the place [where learning changes from knowledge to understanding](https://simpleprogrammer.com/2014/05/26/never-really-learn-something-teach/).

What we have here is a basic formula you can apply to **just about anything you want to learn quickly.**

#### LEARN BY DOING
**We all learn best by doing**, but when it comes to technical skills, this is paramount.

It is just not possible to learn most technical skills by simply reading a book or even watching a video tutorial.

You may get an idea of what is possible using a particular technology, programming language, or tool, but **until you've actually used it yourself, or solved problems with it, you are only going to have a surface level understanding.**

This might be obvious for programming languages, **but can you really learn how to use source control from just reading about the syntax?**

Reading a book, hoping to learn something, but the key is that the **learning doesn't stop there.**

At some point **you are going to need to put down this book and actually [take some real action](https://simpleprogrammer.com/2014/08/18/taking-action/)** to actively learn what you are reading about by doing (at least for the technical skills)

#### HOW TO LEARN BY DOING
Whenever you are going to try and learn a technical skill, start by **figuring out what it is going to help you do.**

**If you don't have an immediate need for the skill, you might even question whether you need to learn it at all.** A large amount of time is wasted by learning technical skills we are never actually going to use in the real world. 

**You'll have a much easier time learning something if you have an immediate application for it, a real reason to learn it.**

But what if you don't have a pressing need? What if you are learning a technical skill because you want to be able to get a job where you'll need to use it?  
In that case you need to manufacture a reason to use that skill. **Create a goal.**

#### AN EXAMPLE OF LEARNING BY DOING
Suppose you wanted to learn about relational databases and how to use them.  
You could just try and read about a database and run some queries against it to play around with and that might be somewhat effective.
- What if instead your goal involved creating a database to store a collection of movies you owned?
- What if your goal was to query this database, insert new movies, delete movies, update the titles, etc?
- What if you wanted to create a simple application to let you access the database and do all this?

Now, you have a purpose and a way to learn by doing.  
**Now, you have something to do.**

How do you approach learning about relational databases?  
You crack open that book or you watch that video tutorial, looking for specific information you need to know to solve your actual problems.

Then, you **actually create and use a database** and not just as an exercise. You have a real goal.  
Think about how much more information you'll retain when you work and learn in this way.

#### HOW I TEACH TECHNICAL SKILLS
John said, I want to give people the biggest bang for their buck, and I don't want to bore them with a bunch of stuff they don't really need to know or could learn on their own when they actually need to learn it.

Instead, I focus on teaching what will be **immediately valuable** and giving students the resources they need to practice what I call "just in time learning" when they need to go deeper on a topic.

There are three main things I try to teach someone when I am teaching a technical skill:
- The big picture: what can you do with the technology?
- How to get started.
- The 20% you need to know to be the most effective.

#### THE BIG PICTURE: WHAT CAN YOU DO WITH THE TECHNOLOGY?
Always start with the big picture.
Believe in the power of Google to solve most of your problems, but you can't Google something if you don't know what it is

Therefore, I first try to teach my students how big a particular technology is and an overview of what it can do.

This is at a very surface level. I'm not showing them or you how to do everything in a technology; I'm just giving you a quick tour and overview of all the points of interest on a map.

For a programming language, for instance, I might talk a bit about the **history of the language** and what it is mostly used for.

Then, I might jump in and show you **all the constructs of the language** and the **language features** especially the unique ones.

Finally, I might introduce you to the **various libraries** that are a standard part of the language and give you an idea of what you can do with them and what they cover.

The idea here is to **give you the complete lay of the land without going into the details.**  
You can always look up the details on your own for the things you are interested in

At this step, **I want to eliminate the unknown unknowns.** I want to make sure that you establish what you don't have any knowledge about, so when you need to learn about it, you can know where to look.

My goal is that you don't say, "Oh, I didn't know X could do that," but instead say, "I know X can do it. I'm not sure how, but I can figure that out later."

Imagine trying to learn woodworking without knowing that such a thing as a dremel or router existed.

You don't have to know how to use those tools, but without knowing they exist, you would be severely handicapped.

#### HOW TO GET STARTED
This is often the most difficult part of learning a technology and it's the precursor to "doing" so I try to make this as painless as possible.

I want to show a student how to download whatever they need to download, get it installed, create their first project, and compile their code.

Once a person is able to overcome this obstacle, they can start playing around and actually build things or work with the technology.

**If this barrier to entry seems too high, someone is likely to just read a book or watch a tutorial and never actually get their hands dirty.**

You can utilize this in your own studies by making sure you focus on discovering how to get started with a particular technical skill early on in your learning process.

Look for specific tutorials or guides that will show you how to get started, then you can take it from there.

#### YOU NEED TO KNOW 20% TO BE THE MOST EFFECTIVE
Finally, I try to teach students 20% of the information concerning the technology that they'll use 80% or more of the time.

**Almost everything in life falls into what is called the Pareto principle**, which basically states that 20% of something produces 80% of the results.

The key to learning a technical skill is figuring out what the 20% is.

What 20% can you learn that will be used in 80% of the work you do using that technical skill?

This is where it is really going to be critical to be doing rather than just reading.

**Many books and even tutorials are written like reference manuals, not giving particular emphasis to the 20%of the technology that is most important to know.**

If you are actively working with a technology, you'll quickly discover what you use the most because it will be extremely painful to not know it.

Most likely, if you learn about relational databases, you'll find that writing select statements is pretty squarely in that 20% area.

If you just read a book on SQL, you might find equal weight given to selecting, inserting, updating, deleting, indexing, and various other database functions.

However, if you actually try and create a database and use it, you are going to be doing a whole lot of select statements. You'll also quickly realize that you need to learn how to join tables.

Instead of wasting your time trying to learn everything there is to know about relational databases, you'll focus your efforts on learning how to write select statements, join tables, and other common operations that make up that critical 20%.

**This is why doing is so important**

It also can help to shadow an expert and watch them work, or even assist them in an apprentice like situation.

By just seeing someone who uses the technical skill you are developing and what their 20% is, you can learn what you need to know quickly.  
On the job training especially can be extremely effective.

#### READ WHAT EXPERTS ARE WRITING
Become an avid reader of what experts who already possess that technical skill are writing.

When I was learning my craft, I would spend about 30 minutes each day reading various blogs related to subjects I was learning about.

When I really wanted to get an in-depth knowledge of C++, I devoured [Scott Meyers' Ef ective C++ books](https://aax-us-east.amazon-adsystem.com/x/c/Qo0tkCmaKay-7qTh1M8-8NYAAAFfbc83mAEAAAFKAQFzLOQ/http://www.amazon.com/Effective-Digital-Collection-Improve-Programming-ebook/dp/B008E30L9A/ref=as_at/?imprToken=JRpDWGmsELDwlhpTxgLdxw&slotNum=10&ie=UTF8&keywords=effective+C++&qid=1464894010&ref_=sr_1_4&sr=8-4&linkCode=sl1&tag=makithecompsi-20&linkId=003c0c081af98f00cc8b8f9d3b8d71c6).

Oftentimes, just hearing an expert's opinion on a subject can grant you **deep insights you wouldn't be able to gather on your own.**

It's one thing to understand the syntax of a programming language or how to use a framework; it is another thing to understand the idiomatic usage of either.

Study how experts are applying the skills in the real world that you are trying to learn.

Read about the problems and arguments experts have regarding the intricacies of a technical skill, and your understanding will deepen.

#### PRACTICE, PRACTICE, PRACTICE
It should be pretty clear to you now that learning by doing is critical—especially when dealing with technical skills.

It should also be pretty clear to you that **you need to have an actual plan to learn** and **a clear goal** of what it is exactly that you want to learn.

It's going to take time to develop any technical skill. In order to get good at something, you are going to have to practice a lot.

Try not to get frustrated by how long it may seem to take, especially when you feel like you aren't making progress.

If you put in the time, **the skills will come** as long as you are following a solid plan with a clear goal.

Just keep at it and [trust the process](https://simpleprogrammer.com/2015/09/28/trust-the-process/).


### CHAPTER 5 - WHAT PROGRAMMING LANGUAGE SHOULD I LEARN
For some aspiring developers, **this question ends up being a stumbling block they never get over.**

plenty of developers who were always second-guessing themselves or changing their minds and kept jumping from programming language to programming language, always worrying about making the wrong decision.

First, to dispel some of doubts; then some real practical considerations for choosing your first programming language to learn.

#### THE ACTUAL LANGUAGE DOESN'T MATTER ALL THAT MUCH
[What language you learn doesn't actually matter nearly as much as you might think it does](https://simpleprogrammer.com/2013/12/02/programming-language-learn/).

Many programming languages, at their core, are very similar.

The syntax is different. Programming languages may look different. They may even have completely different sets of features.

However, at their core, all programming languages share more than you might first suspect.

Almost all programming languages will have basic constructs for branching, looping, and calling methods or procedures and a way to organize code at a high level.

There are even many programming languages that are so similar that if you know one language, you almost already know the other.

C# and Java are pretty good examples. JavaScript is very similar to either of those.

**Learning your first programming language is always the most difficult.** Once you learn a programming language, learning a second one is easier. After you know two or more programming languages, each additional programming language is exponentially easier to learn.

Not only are programming languages more similar than you might think, but you'll also easily be able to switch to a different programming language and learn it later on.

This means even if you learn one programming language and decide it's not the right one, or you get a job where you'll be using a different programming language, it's not a big deal. You'll already have done the hard work of learning your first programming language.

You'll also probably find that many developer jobs especially at big companies like Microsoft or Google don't require that you know a specific programming language.

#### CONSIDERATIONS FOR PICKING A PROGRAMMING LANGUAGE
Therefore, **it doesn't matters at all that much what programming language you decide to learn first**, but if you are still having some trouble making a decision, these are the few things to consider.

#### JOB PROSPECTS AND FUTURE
**The most important thing to consider is what job a particular programming language is likely to help you get** and what the future of that language is.

Now, for most popular programming languages, at any given time there are going to be plenty of jobs available.

Different programming languages may rise or fall in popularity, but if you are concerned with job availability, you might want to consider one of the main, popular programming languages.
- C#
- Java
- Python
- Ruby
- JavaScript
- C++
- PHP

**There is no shortage of jobs for developers who program in one of these languages.**

That said, depending on where you live in the world, you may need to be a bit more selective if you aren't willing to relocate.

For example, if you live in some small town in Arkansas and there is only one technology company and that technology company does everything in Java, it will be better you [learn you some Java](https://www.youtube.com/watch?v=OrUL2zCNBXM).

**If you are willing to relocate or you are planning on doing freelance programming, you could probably specialize in a more eccentric and less widely used language** and do pretty well by being an expert in an area where there are few experts.

But, if you are just starting out, try to stick to something a bit more mainstream.

Another consideration to take into account, along with job prospects, is **what the future is likely to hold for the programming language you are considering.**

Objective-C would probably not be a good choice of a language to get started in, simply because most iOS developers are switching to Swift and Apple is heavily investing in the [Swift programming language](https://aax-us-east.amazon-adsystem.com/x/c/Qo0tkCmaKay-7qTh1M8-8NYAAAFfbc83mAEAAAFKAQFzLOQ/http://www.amazon.com/Swift-Programming-Ranch-Guide-Guides/dp/0134398017/ref=as_at/?imprToken=JRpDWGmsELDwlhpTxgLdxw&slotNum=11&ie=UTF8&qid=1465083296&sr=8-1&keywords=swift&linkCode=sl1&tag=makithecompsi-20&linkId=4580442a5c55467b09d9542d99039390).

If you've already been programming in Objective-C, don't worry; there will still be plenty of jobs and legacy Objective-C applications to maintain. It just might not be the best choice for the future.

Of course, none of us have a crystal ball, so **it's pretty difficult to predict which languages are going to be popular and which ones aren't.**

John said, [awhile back I predicted the death of JavaScript](https://simpleprogrammer.com/2013/05/06/why-javascript-is-doomed/). That didn't exactly happen

I just went to a conference where one of the speakers was a co-inventor of Objective-C, which first came into being in the early 1980s.

The speaker, Tom Love, wrote a book in which he basically stated that the JavaScript language was dead. It's now one of the top five most used programming languages in the world.

The point is, **you never know what is going to happen.**

Ruby took years before it became popular.

JavaScript is arguably one of the worst designed languages ever and was originally used for making little pop up or alert boxes on web pages; now it's an extremely popular language.

#### Why do you hate JavaScript so much? JavaScript doesn't suck, you do
In May of 1995, Brendan Eich, who was working at Netscape at the time, created JavaScript in 10 days as a quick effort to create a simple "glue language" that was easy for web designers and parttime programmers to use. ([Wikipedia](https://en.wikipedia.org/wiki/JavaScript))

Originally, it was not very well thought out and was kind of thrown together in 10 days.

Now. With that said, the newer version of JavaScript, (now known as ECMAScript), is much better and has been enhanced to make up for many of JavaScript's original shortcomings.

Obviously JavaScript is an extremely popular language and it is used everywhere.

Oh, and in case you are still not convinced, why do you think one of the best selling JavaScript books of all time was called _"[JavaScript: The Good Parts](https://aax-us-east.amazon-adsystem.com/x/c/Qo0tkCmaKay-7qTh1M8-8NYAAAFfbc83mAEAAAFKAQFzLOQ/http://www.amazon.com/exec/obidos/ASIN/0596517742/ref=as_at/?imprToken=JRpDWGmsELDwlhpTxgLdxw&slotNum=12&ie=UTF8&linkCode=sl1&tag=makithecompsi-20&linkId=bdea626e019c1cdf62c28896f8758407)"_.

#### TECHNOLOGY THAT YOU ARE INTERESTED IN
One excellent consideration when picking a programming language is simply what technology you are interested in.

If you start with a technology, the programming language choice may be easier.

Plenty of developers who are interested in developing Android apps because they love the technology.

For most of them, Java is going to make sense because that is the native language in which to develop Android applications. (Although, you could also develop Android applications in many other languages, like C#, Ruby, and even JavaScript.)

**It definitely doesn't hurt to pick your first language based on what you are most interested most**, because learning your first programming language can be difficult.

The more you are interested in and excited about what you are learning, the easier it will be to stick with it and get through the difficult parts of the learning curve.

I really wanted to develop an iOS application because I had just gotten an iPhone and I was excited about the technology.  
**Had I not been excited about the technology, I probably wouldn't have made it very far.** -John

Don't be afraid to pick a programming language based on what excites you or what you are interested in. Your enthusiasm can carry you through the rough patches in the learning process.

#### DIFFICULTY LEVEL
Another major consideration would be difficulty level.

**Some programming languages are just much more difficult to learn than others.**

[I usually don't recommend starting out by learning C++](https://simpleprogrammer.com/2012/12/01/why-c-is-not-back/) because, in comparison to many other programming languages, [C++ is rather difficult to learn](https://www.youtube.com/watch?v=sXr2gRk8nco).

C++ has you dealing with managing memory and pointers and quite a few other nasty constructs that can throw a beginner for a loop.

It's a great language still one of the favorites but not the easiest one to learn.

**A language like C#, Lua, Python, Ruby, or PHP is going to be much easier starting out.**

There are even beginner languages specifically tailored to learning programming, like Scratch or Basic.

I don't want to discourage your from learning a more difficult language like C++ if that is what you really want to do, but you should at least know what you are getting into and decide if you'd rather your first language be something easier.

#### RESOURCES AVAILABLE TO YOU
You also might want to consider what resources are available to you for learning a programming language.

**Some obscure programming language may not have as many books, online videos, or other resources available, which might make them more difficult to learn.**

Other more popular programming languages may have plenty of tutorials online, bootcamps you can enroll in, and books and other resources you can utilize, so be sure to look into how many and what resources are available out there for you.

While this isn't as big of a concern today as it used to be since there are so many resources for beginners out there, it's still something to take into consideration.

**You might also want to consider what resources are specifically available to you**, like a computer or software.

A somewhat difficult to learn programming language may be an easier choice, simply because of how many interactive online tutorials there are.

You can learn JavaScript online through your web browser without installing anything on your computer.

**A language like C++ will require downloading some tools and software**, which might not be easy to do or as easily available.

For the final resource, consider looking to the people you know.  
Who can you turn to for help?

**Is there someone that can answer your questions if you get stuck or help accelerate your learning?**

#### ADAPTABILITY
**Different programming languages are going to be more adaptable to different situations and technologies.**

For example, the C# programming language, is one of the most adaptable thanks to companies like Microsoft and Xamarin (now part of Microsoft).

If you learn C#, you are not just constrained to Windows or web programming.

**C# is available on just about every platform today**, so it is highly adaptable.

You can use C# to write Linux and Mac applications, and you can even write Android and iOS applications, completely in C#.

Plenty of other programming languages are also highly adaptable.

For instance, Ruby has been ported to many different platforms and is used in quite a few areas of technology.

JavaScript is also highly adaptable. You can even use JavaScript to control Arduino boards and do robotics. ([Check out my good friend Derick Bailey's article on how to do it](https://www.safaribooksonline.com/blog/2013/07/16/javascript-powered-arduino-with-johnny-five/).)

Other programming languages are not as adaptable.

If you learn R or Go, for example, you are going to be a bit more restricted to the technologies and platforms those languages were designed for.

More and more programming languages especially popular ones are being ported to more platforms and used in a variety of different technologies, but there are still some that are not as versatile.

So, if you think you might want to be a web developer today but do Android development tomorrow, or you want to get involved in a bunch of different platforms or technologies, **you might want to consider how adaptable the language is you are trying to learn.**

#### SOME FINAL THOUGHTS ON PICKING A PROGRAMMING LANGUAGE
What is important is that you pick something and stick with it long enough to get through the learning curve required to gain proficiency.

Plenty of programmers who are starting out get frustrated, because they feel like they are **just not getting it.**

It can be tempting to get bored, or think you are learning the wrong language, and so keep switching languages, that is not a good idea.

Finally, consider this. When John first started programming, knowing a language in-depth was one of the most important skills a programmer could have.

He would pour over C++ books and try to learn every intricacy of the language.

That is no longer as important a skill today.

Today's programming is done at a higher level. **Programming today involves utilizing libraries and frameworks much more than language features.**

Sure, it's important to know a programming language and to be good at it but absolute mastery just
isn't as valuable a skill as it was.

That is why don't worry so much about what language you learn first. **Just make sure you do learn one and stick with it**, at least for now.


### CHAPTER 6 - LEARNING YOUR FIRST PROGRAMMING LANGUAGE
Ok, so you've decided what programming language you want to learn and now you are all set to learn it.

All you need to do is crack open a book and start reading, right?

Well, not exactly. You can do it that way if you like frustration.

Remember how **you learn best by doing?**  
That's the plan.

**I'm going to give you the layout for the ideal way to learn your first programming language**, and not just to learn it, but to become extremely comfortable and proficient in it, if not master it.

Learning your first programming language can be the most difficult thing about learning to program, but it doesn't have to be.

Most programmers learn by reading a book, trying a few things out, scratching our heads, and then rereading a book and continuing to try things out until it finally "clicks."

What I'm about to share with you comes from coaching and teaching many software developers through not only learning their first programming language but also improving their skills in that language. I also bring my own experience mastering languages like C++, C# and Java.

Basically, in this chapter, I'm showing you **what I would do knowing what I know now if I were in your shoes and were learning my first programming language today.**

#### START BY LOOKING AT A WORKING APPLICATION
Most beginner programmers, when they want to learn to program, pick up a book and start reading.

There are some excellent books out there which attempt to teach you programming in a very hands on approach. However, I think **the best place to start is by looking at the source code of an actual working application** and trying to figure out as much of what is happening as possible.

This is difficult.  
It's going to feel uncomfortable, but that's ok. Get used to feeling uncomfortable.

What I want you to do is to pick an open source application preferably a popular one that is likely to be well designed—and start looking through the source code.

[You can find plenty of projects on GitHub](http://github.com/).  
It's even better if you can download the code and build and run the application yourself.

What is important is that you **explore the code to get a feel for what the programming language syntax looks like and read the code to see if you can understand or make sense of anything.**

Use the application itself, if possible, so you can get a feel for the relationship between the code and what the code does.

**You might feel like you're not understanding anything.**

That's ok. Just do your best and see if you can figure out how one or two things work or what you might change in the code to change the functionality in some way.

Moreover, get a feel for how things are named and how they are organized.

Pretend like you are an archaeologist trying to understand the writing of some ancient civilization.

By starting out this way, **you are going to have a serious head start over most programmers who have no idea what the programming language they are trying to learn even looks like.**

It's always a good idea to get a lay of the land before embarking on any journey.  
Programming is no different.

#### FIND A FEW GOOD RESOURCES OR BOOKS AND SCAN THROUGH THEM
Further continuing with the theme of getting the lay of the land before setting sail, the next step is not to read a programming book cover to cover. Instead **pick out a few books or other resources such as videos, articles, or tutorials and scan through them.**

Again, this is going to be at least somewhat uncomfortable because much of what you are looking at isn't going to make much sense.

But… **the idea here is to scope out the territory.** You just want to get an idea of how big this thing is that you are about to learn and what the general concepts are.

This extra work upfront will pay off later when you have an idea of what types of things you are going to learn and how the concepts are going to build on each other.

If you have taken the "[10 Steps to Learn Anything Quickly](https://simpleprogrammer.com/products/learn-anything/)" course, you might recognize that what you are essentially doing here is getting the big picture and determining scope.

#### LEARN HOW TO CREATE HELLO WORLD
Ok, at this point you are still not "reading a book" or taking a training program.

You'll be doing that soon enough if you want to. (You can actually learn a programming language without doing that, if you follow these steps. [I learned Go and Dart in about two weeks utilizing only online documentation](https://www.pluralsight.com/authors/john-sonmez?utm_medium=affiliate&utm_source=1058191) and a similar process to what we're discussing here.)

What you want to do at this point is to **create the most basic kind of program you possibly can in whatever programming language you are learning.**

**You want to get started as soon as possible** so that you can develop the confidence and knowledge to apply what you will be learning and put it immediately into practice.

What you are going to start with is a very basic program called "Hello World."

Most programming books begin by having you create a "Hello World" program, which usually just prints "Hello World" to the screen.

The idea here isn't really to learn all that much about the language, but rather to **become familiar with and test out the basic tool chain required to build and run a program** in your programming
language of choice.

If you are reading about your programming language, it should contain an example of a "Hello World" program you can create.

If not, just do a Google search for "Hello World + _your programming language_." You should have no trouble finding an example.

By creating a "Hello World" program, you'll also learn the basic structure of a program in your programming language.

#### LEARN BASIC CONSTRUCTS AND TEST THEM OUT WITH REAL PROBLEMS
Now comes the point where, if you have a book on your programming language or tutorial of some sort, you can start reading or working through it.

At this point, what you are reading or consuming shouldn't be quite as mysterious as it would have been if you just dove in.

**What you want to do now is familiarize yourself with each of the basic constructs of the programming language you are learning, and then write some code that uses these constructs.**

You'll want to try and think of problems or applications associated with what you are learning that are as realistic as possible because, when you apply a skill to an actual problem, you understand and remember it better.

Here is a list of some of the basic constructs most programming languages should contain:
- Ability to write output to the screen
- Basic math capability
- Storage of information as a variable
- Organization of code into functions, methods, or modules
- Invoke a function or method
- Performance of boolean logic evaluations
- Branch conditional statements (if / else)
- Looping statements

**Once you know these basic constructs and how to use them, you'll have the basics of programming in any language.** Yes, the syntax might be different, but this is the core of programming.

You will probably spend a good amount of time in this phase.

Just work your way through, learning each of the constructs of your programming language one at a time, and apply each construct by actually writing some code.

If you are working on your own, you'll need to identify what all the constructs are and in what order it makes sense to learn them.

If you are going through a book or tutorial (or preferably multiple books and tutorials), the path should be laid out for you and should even have some examples and challenge assignments for you to do.

**Try to make sure you always understand what you are learning and how it is applied.**

Now is a great time to go back to that original source code you looked at in the first step and see how much more of it you understand.

#### KNOW THE DIFFERENCE BETWEEN LANGUAGE FEATURES AND LIBRARIES
One thing that often trips up beginning programmers especially with the programming languages of today is knowing what is part of the language and what is part of the standard libraries that come with the language.

Often the distinction is not very clear because, idiomatically, you are going to write code that uses the standard libraries very often.

That's ok. You are going to need to know the conventions for programming in the programming language you are learning, but **you should take special care to try and figure out what is part of the actual language and what is part of the libraries** that are often used with the language.

This might seem like nitpicking, but I think it's important because it will take that scrambled mess of syntax that you probably have floating in your head at this point and help you categorize and organize it to make more sense.

What you'll realize is that, **for most programming languages, the actual language part itself is not that large** and is relatively easy to learn, but the standard libraries are large and knowing your way around them is going to be the more difficult endeavor.

**Programming today is more about knowing how to use libraries and frameworks than being an absolute expert in the language.**

That is one of the reasons why this distinction is important.

By realizing what is not part of the language but is rather part of the library and learning how to look up libraries for common tasks you want to accomplish in the language, you'll become a much better programmer.

#### REVIEW EXISTING CODE AND WORK THROUGH UNDERSTANDING EACH LINE
At this point you should be familiar with all of the major concepts of the programming language you are learning, and you should have used most of the programming language features in real examples.

You also should have a decent understanding of the difference between the language itself and the libraries that are used in conjunction with the language.

**You still might not exactly feel comfortable with the language** or that you actually know it.

This is the stage where you may sort of feel like you can understand how everything works, but you have no idea how you would put it together to write a real application.

(Kind of like learning to speak another language.)

Many beginning programmers tend to get a bit stuck at this stage and feel frustrated, thinking they'll never be a real programmer.

One of the best ways to push forward from here and make sure you don't have gaps in your knowledge is to **start looking at existing code, line by line, making sure you understand exactly what each line and statement in the code is doing.** (Even if you don't always understand the why, being able to know the what is still progress.)

#### Don't I need to know the why? What good does it do me to just know what the code does if I don't understand why it does it?
Think of it this way: if you don't understand the what, you can can't possibly understand the why.

If you don't know what the words in this book mean, you can't understand the individual sentences and if you can't understand the individual sentences, you won't understand the concepts.

That's why we start at the lowest level.

I want to make sure you know what every single line and statement in the code is doing, because without that you don't have any shot of understanding the why or how it all fits together.

So, you start there and the why comes later.

Yes, it's important to understand the why and how the individual lines of code work to make up the program and make it function, but in order to do that you first have to understand the language itself.  
So, right now just focus on learning the language.  
The rest will come.

You can take the existing source code for a project you looked at in the first step and start randomly going through files in the project.

Open a file and go through each line of code in the file, making sure you understand exactly what it is doing.

If you don't understand and there will be plenty of things you won't take some time to think about it, and look up anything you don't understand.

This is tedious. It might even be boring, but it's totally worth it.

**When you get to the point where you feel like you can read any line of code and understand what it is doing again, the why is not as important at this stage you are ready to move on.**

#### BUILD SOMETHING… LOTS OF SOMETHINGS
Now it's time to really start using the programming language.

At this point, you should already have written a few small programs and utilized most of the features of the language, but you'll get a greater feel for the language once you start actually building real applications.

**Pick a few small project ideas nothing huge and start building applications.**

Don't pick anything too ambitious and don't try to do anything platform specific or UI intensive at this point. Preferably, your applications will just print text to the screen and take input from the keyboard for now.

**The idea is to build some simple applications that focus on utilizing the programming language you are learning and the standard libraries**, not additional frameworks for platform features.

By doing so, you will build confidence in the programming language and your ability to use it, and you'll learn what language constructs to use to reach the goal you are trying to accomplish.

Here are some simple project ideas to get you started:
- Create a program that **solves a mathematical problem** by getting inputs from the user.
- Create a **Choose Your Own Adventure type of program** where the input from the user determines what happens next.
- Create a very **simple text-based adventure game** where the user can issue commands to pick up objects, move through rooms, etc.
- Create a program that is able to **read input from a text file and write output** to a different text file.
- **Create a chatbot** that talks to the user and pretends to be human or gives humorous responses.

#### APPLY THE PROGRAMMING LANGUAGE TO A SPECIFIC TECHNOLOGY OR PLATFORM
Up until this point, you should have mainly been learning about and using the programming language you've chosen in isolation.

This is intentional because you need to understand and be comfortable with the programming language itself and its standard libraries before adding the extra complexity of the environment and other frameworks you might use to build a real-world application.

**In order to create something useful with a programming language, you are going to need to apply it to a specific technology or platform.**

At this point, you should decide on a few small projects you can complete which will require you to utilize the programming language on a specific platform.

For example, let's suppose you are learning Java.

Up until now, you would be writing Java code that would work on any platform that Java could run on, since you'd be mostly using the standard libraries and just working with input and output to the screen or a file.

At this point, you might decide to use Java to build an Android application.

You will have to learn how to build Android applications and about the Android framework. However, you'll already be familiar with Java, so you won't be trying to learn a huge amount of concepts at once without knowing what Java is or what Android is.

You can, of course, learn Android and Java together in fact, [John did a Pluralsight course teaching exactly how to do that](http://shareasale.com/r.cfm?b=611266&u=1058191&m=53701&urllink=www%2Epluralsight%2Ecom%2Fcourses%2Fandroid%2Dbeginner%2Djava%2Dintroduction&afftrack=career%2Dguide%2Dlinks) but to get a real mastery of the language and avoid confusion, isolating the language from the platform or technology and then combining them is probably going to be much easier.

Now you will be developing specific, specialized skills with the programming language you are learning that will be useful for getting a job.

Pick whatever platform or technology you think you are most likely to want to work with in the future and start creating a few small applications using it.

[It is also recommended that you specialize in just one technology or platform at this point](https://www.youtube.com/playlist?list=PLjwWT1Xy3c4W5SK-MGjp_KSFZF2pEMCt8). You can always learn more later.

By specializing, you will not only limit what you have to learn at this point, but you will allow yourself to gain a deeper knowledge and competency in a particular technology, which will make you much more confident and greatly increase the marketability of your skills.

#### SOLVE DIFFICULT ALGORITHM PROBLEMS WITH THE LANGUAGE TO MASTER IT
By now you should be pretty comfortable with the programming language you are learning.

You should know it pretty well and have used it in a variety of different applications.

You should have a specific technology or platform you've applied your skills to and feel comfortable creating basic applications using that technology.

Nevertheless, **you still might not feel like you have a mastery of the programming language.**

Don't worry; this is also normal.

[Discover the coding competition site called TopCoder](https://simpleprogrammer.com/2010/04/02/so-you-want-to-become-a-better-programmer-topcoder/).

Every week, there was a new set of programming challenges where you could compete against other programmers to solve some fairly difficult algorithm problems.

**At first I was horrible.** I couldn't even solve the easiest problem.

I would look at other people's solutions, and I would have no idea how they came up with that solution or even how their code worked.

They were using C++ in a way that I never imagined.

But then, over time, as I kept trying to solve problems and I looked at how other people had solved the problems, I started to get better… much better.

I started to see patterns in how certain types of problems were solved.

I started to really understand how to utilize features of C++ that I had previously ignored.

I learned how to effectively use the standard libraries and language features along with data structures to solve complex problems.

I became not just proficient at C++ but excellent at it. I finally felt as though I had mastered the language.

You don't have to go on TopCoder to compete, but **there are plenty of places where you can practice solving algorithm-type programming problems.**

Here are some more good resource for these kinds of problems:
- [Cracking the Coding Interview](https://aax-us-east.amazon-adsystem.com/x/c/Qo0tkCmaKay-7qTh1M8-8NYAAAFfbc83mAEAAAFKAQFzLOQ/http://www.amazon.com/Cracking-Coding-Interview-6th-Programming/dp/0984782850/ref=as_at/?imprToken=JRpDWGmsELDwlhpTxgLdxw&slotNum=13&ie=UTF8&qid=1464723794&sr=8-1&keywords=cracking+the+coding+interview&linkCode=sl1&tag=makithecompsi-20&linkId=702b6ced4c8d80c475aee7ad3849cc82) by Gayle Laakmann McDowell
- [Programming Pearls](https://aax-us-east.amazon-adsystem.com/x/c/Qo0tkCmaKay-7qTh1M8-8NYAAAFfbc83mAEAAAFKAQFzLOQ/http://www.amazon.com/Programming-Pearls-2nd-Jon-Bentley/dp/0201657880/ref=as_at/?imprToken=JRpDWGmsELDwlhpTxgLdxw&slotNum=14&s=books&ie=UTF8&qid=1497370972&sr=1-1&keywords=programming+pearls&linkCode=sl1&tag=makithecompsi-20&linkId=d3a931392f6637b7c2667dc82e1de500) by Jon Bentley
- [Project Euler](https://projecteuler.net/)
- [Codility](https://codility.com/)
- [Interview Cake](https://www.interviewcake.com/?utm_source=simpleprogrammer)
- [TopCoder](https://www.topcoder.com/) (check out the practice rooms for the algorithm contests)

**These problems will be extremely difficult at first**, and that is ok. They are supposed to be.

What you'll find is that, over time, you'll start to recognize that there are only a handful of types of problems, and you'll start to be able to identify how to solve them immediately.

At first, you'll have no clue what to do, and that's ok, just keep trying.

Also, **don't forget to look at how other people have solved the problems you are struggling with.** Try to understand why they solved particular problems the way they did.

Once you can solve these types of programming problems with the programming language you are learning, you will not only be pretty close to mastery of the language, but also **coding interviews will be a piece of cake for you** while other candidates are sweating through their shirts.


### CHAPTER 7 - GOING TO COLLEGE
In the next three chapters, I'm going to talk about **three different strategies or paths you can take to get started as a software developer.**

First, we'll talk about **going to college**; then we'll talk about **enrolling in a coding boot camp**, and finally we'll talk about **self-education.**

Any of these paths are viable, but let's lay out the pros and cons of each path then give you a solid strategy that will help you, if you choose to embark on that particular path.

**If you choose to go down this path, it means you are going to enroll in an accredited school which will take anywhere from two to six years to get a degree in a program like Computer Science, Computer Programming, or something similar.**

This is the route most software developers take, but is it the best one?

#### ADVANTAGES
Your parents probably think there are plenty of advantages in fact, they probably think college is the only optionbut I want to be as objective as possible.

We have to admit there are still some real benefits to getting that piece of paper.

**MANY COMPANIES STILL ONLY HIRE DEVELOPERS WITH DEGREES**

**[Often, you'll find that larger corporations with HR departments will pretty much only hire software developers with degrees](https://simpleprogrammer.com/2014/07/07/software-developers-really-need-degrees/) from accredited colleges or universities.**

This doesn't mean you can't get a job at one of these companies without a degree, but it might be very difficult to do so.

**Normally, HP doesn't hire anyone who doesn't have a degree**, but they approved John as an
exception since he had been recommended and had already proven himself as a contractor.

It took jumping through many hoops for him to get an offer, but **when the offer finally came, he was sorely disappointed.**

Instead of taking into account his experience and ability, heI got classified into a non-degree category, meaning they put him at the very bottom of the pay scale and told me him was lucky to get an offer at all.

By getting a real degree, you will potentially open yourself up to more opportunities you wouldn't have access to as someone who is self-taught or went to a coding boot camp.

There are plenty of companies that will hire someone without a degree and not discriminate against them but overall, choices without a degree will be more limited.

Bottom line: **having a degree will give you more job options than you might have without one.**

**GOOD BASE KNOWLEDGE OF COMPUTER SCIENCE CONCEPTS**
Many self-taught programmers are very good programmers but lack knowledge of some of the computer science concepts which are taught in college.

Today, these skills are not as important as the more practical aspects of software development, but **I do believe every software developer should learn about operating systems, data structures, algorithms, predicate logic, computer architecture**, and many of the other topics found in most computer science degree programs.

These topics can be difficult to learn on your own especially if you don't even know they exist.

Many top companies give [coding interviews](https://www.youtube.com/watch?v=zIS31BAL-_g) that specifically target this kind of traditional computer science knowledge.

**More programmers need to understand some of [the underlying basics and theory behind the code](https://aax-us-east.amazon-adsystem.com/x/c/Qo0tkCmaKay-7qTh1M8-8NYAAAFfbc83mAEAAAFKAQFzLOQ/http://www.amazon.com/Code-Language-Computer-Hardware-Software/dp/0735611319/ref=as_at/?imprToken=JRpDWGmsELDwlhpTxgLdxw&slotNum=15&ie=UTF8&qid=1465509528&sr=8-1&keywords=computer+science&linkCode=sl1&tag=makithecompsi-20&linkId=ef430b556579ce52fdd49e178805f01e) they are writing.**

While college is less likely to give you the pragmatic knowledge you need to work as a software developer today, most degree programs will give you the depth of knowledge in computer science concepts that can be extremely useful when getting into more complex programming scenarios, like working with real-time systems, developing new algorithms, and making them efficient. Newer fields like machine learning also need people with a deeper understanding of these computer science concepts.

**STRUCTURE**  
**One thing traditional education does better than anything else is give you structure.**

Some people simply cannot operate without a clear structure in place, telling them exactly what to do and when.

Many people have aspirations of becoming a software developer, but never end up doing it because they get overwhelmed by all the information they need to learn and don't know how to organize that information in a way that will progress them down the course of self-education.

Other wannabe software developers are simply **too unmotivated** and **lack the self-discipline** required to self-educate.

If you wouldn't identify yourself as being a self-starter or you have problems taking action when the path is not clearly laid out for you be honest you would probably benefit from the structure a college or university provides.

If you try to learn on your own, you have to decide what and when to learn, and how much time each day to dedicate to learning.

If you enroll in a computer science program or other program at a college or university, you'll pick some electives and have some say in your schedule, but you'll have everything else planned out for you. Then, you just have to stick to the plan.

**INTERNSHIPS AND OTHER OPPORTUNITIES**
Colleges and universities are often able to offer internship opportunities or other connections and resources that you might not have access to on your own.

**Many companies recruit directly from colleges** and have pre-established relationships with them, which can make getting a job easier.

Many colleges also have programs and opportunities available with different foundations, conferences, and other events that can greatly help you with networking and making the right connections.

**This can definitely be a huge advantage, especially if you want to work for a big technology company like Google or Microsoft early on in your career.**

A seasoned developer might be able to get a job at one of these larger technology companies based on merit and experience, but for a software developer just starting out, internships are a great way to get your foot in the door. Since most internship programs are run through colleges and universities, you must be a student or have recently graduated in order to have access to them.

#### DISADVANTAGES
**This is the part of the book your parents aren't going to like.**

Unfortunately, there are some definite disadvantages to going to college. Some obvious, some not so obvious.

**TIME**  
**Going to college is going to take a minimum of four years out of your life.** That's time where you can't really be working as a full-time software developer and gaining experience to put on your resume.

This is a pretty big commitment. A large amount can happen in four years' time.

Therefore, you really want to think about whether the benefits of having a degree are worth giving up four or more years of your life.

There is also the time commitment of college itself. **Not all of the activities and time you spend in school will directly benefit you.** You'll be expected to take core classes that have nothing to do with becoming a software developer, so you can conceivably see that as a waste of time.

Taking tests is also arguably a waste of time, as it doesn't benefit you directly.

The same can be said of listening to lectures, especially if you could have absorbed the same amount of information in a quicker way.

**Traditional education is not designed to maximize the use of time**, as often the programs must be taught to the lowest common denominator. (Not true for all schools, of course, but in general.)

**COST**  
Next up is money.

Everyone wants more of it, no one wants to part with it, but if you go to college, you are most likely going to have to part with a great deal of it.

**School is expensive, and it's getting more and more expensive every year.**

If you want, or are required, to live on campus or you have to finance your education, you can expect the bills to be even larger

**Plenty of software developers and non-software developers who are still paying for their higher education many years and even decades after getting their degrees.**

It can be very difficult to justify the cost of an expensive education when you consider the lost years of pay you would have received from working during that time, as well as the interest on school loans in comparison to the increased salary if any you get from having a degree.

**Make sure you actually add up all the costs of going to college, including interest, room and board, and lost employment income, so you at least know what you are getting into.**

**OUTDATED OR NON-REAL WORLD EDUCATION**  
It takes a long time to publish a textbook.  
It takes a long time to create a degree program and get it approved or to add new classes to an existing program.

**Often professors in colleges and universities are very disconnected from the kinds of software development which are being done in the real world.**

As a result, educational programs at colleges poorly reflect the skills and technologies which are most critical to know for success in a real software development job.

Yes, a computer science background can be helpful, but it's just not as pragmatic as learning how to use source control, Agile methodology, or even the most popular and widely used JavaScript framework.

To be fair, many traditional schools are realizing this weakness and taking some steps to make their degree programs more relevant to what is happening in the software development world today but many are not.

That is part of the reason why this book was written.

**I want to give you all the soft knowledge you need to know about a career in software development because I feel that most colleges and universities don't provide it.**

You can, of course, overcome this limitation by learning the other aspects of software development on your own, but at that point you really have to question why you are paying for a degree in the first place.

**DISTRACTIONS**  
There is a reason why there are rankings for the top party colleges in the country.  
There is a reason why some people say college was the most fun time of their lives.  
**College is full of distractions.**

Alcohol, parties, protests, sports, concerts, snoring roommates… distractions are everywhere.

Plenty of software developers who took six or more years to get their degree because they couldn't just buckle down and study. They got too distracted by all the other things college has to offer.

While some people might see this as an advantage, **if you are serious about becoming a software developer, the college atmosphere can be a huge distraction.**

#### But my parents are making me go to college. They say I have to do it. They'll disown me if I don't.

**You have one life and it is yours to live.**

You don't owe anyone anything and no one owes you anything.

Ultimately, at the end of the day, you are the one who has to live with the consequences of your choices, not your parents, not your guidance counselor, not your friends, just you.

So, while it may feel like you don't have a choice, you always do.

Don't get me wrong. I'm not saying "don't go to college," but what I am saying is that you need to decide for yourself whether it is right for you and not let someone else tell you what you are going to do.

Sometimes you have to make difficult decisions in life and sometimes you have to be willing to accept whatever consequences may came and the fact that some relationships may be ruined.

You'll be a much happier person in the long run living your life instead of [letting someone else live it for you](https://www.youtube.com/watch?v=RE80o2XFNOI).

#### STRATEGY
If you are choosing the traditional route and going to college, it's important to have a plan.

You don't want to end up with loads of debt and few benefits, like too many college graduates today

**START WITH ACOMMUNITY COLLEGE**  
First of all, [I'd highly suggest going to a community college](https://www.youtube.com/watch?v=Yv7TwPm1EjI) for the first two or even three years of your degree in order to save a ton of money.

If you get a scholarship, you can ignore this advice. However, if you are paying out of pocket or are taking on student loans for your degree, **going to a community college first can save you a bundle**, and you can still get a degree from a more prestigious college or university.

The key here is to make sure the credits and program you take at a community college will transfer over to the school where you'd eventually like to get your degree from.

**AVOID DEBT**  
Debt is horrible. **Debt can ruin your life.**

Some people see educational debt as good debt, like a mortgage on your house or investment property, but don't.

Instead, here are some ways to go to school and avoid debt:
1. **Take a year off, get a job, and save money.** You don't have to go to college right after high school. Saving up some cash can really help you avoid going into debt.
2. **Get scholarships.** Not for everyone, but if you can manage to get a few scholarships, this can greatly help to reduce expenses.
3. **Get a part-time job while going to school**, which enables you to pay for school. It's not fun, but it will pay off in the long run.
4. **Live at home.** Yes, it sucks, but you'll probably get more work done and you'll definitely
pay a lot less money.
5. **Move to a state where education is free**, like Alaska. Or move to Germany temporarily.

You can even combine these tactics to reduce debt further.

**MAKE LEARNING YOUR RESPONSIBILITY**  
Going to school and getting a degree is great, but it doesn't mean you learn anything.

**If you are going to spend the time and money to go to a college or university, you better get something more than just a fancy piece of paper.**

Unfortunately, no one can teach you anything. You have to learn it yourself, regardless of where you learn it or from whom.

Always remember that **education is your responsibility.**

Don't read textbooks or do assignments just to pass the test and make the grade.

Instead, **focus on actually learning and applying what you are learning as much as possible.**

That is how life works in the real world. No one is going to "teach" you anything. It's going to be up to you to learn, so it's better for you to get used to it now.

Many college graduates have spent tens of thousands of dollars and years of time on an education that is completely worthless. They thought that going through the motions and getting a degree would make them educated and guarantee them a job.

It won't, so if you are going to enroll, **do the work and take the responsibility of learning upon yourself**, rather than give the responsibility to the degree program you enrolled in or the professors who are teaching you.

**DO SIDE PROJECTS**  
Going to school will take a huge bite out of your work experience time.

It's a serious deal to dedicate four to six years of your life to something.

**One of the biggest problems new graduates have is that since they don't have experience, they can't get experience**, and they have a difficult time finding a job.

One really good way to avoid that problem is to [do side projects](https://simpleprogrammer.com/2015/11/19/advice-on-a-side-project/) while you are still in school.

**College is the perfect time to build up your portfolio or to start building a side business** whichcan give you some valuable experience and perhaps even some income while you are waiting to start your career.

Side projects can also help you to apply what you are learning so that you'll be less likely to forget it and more likely to gain the deep understanding needed to apply knowledge in the real world.

Plus, **how many stories can you recall of college students who started side projects and then became millionaires off of them?**

Microsoft, Facebook, Yahoo, Dell, and Google all started from side projects in dorm rooms, basements, or garages.

That doesn't mean you are going to get rich off of doing a side project from your dorm room, but you never know. At the very worst, you'll learn something and you could end up creating your own job for yourself when you graduate.

**INTERN**  
**Internships can be one of the easiest ways for a new software developer without experience to get a job at a big company like Google or Microsoft**, or even just to get a job period.

Internships can also make up for the lack of real world experience in many degree programs.

You really don't want to get your degree and then be hitting the pavement with all the other new grads with no experience.

Therefore, make sure you take advantage of an internship program if you can even if it doesn't pay well.

You can make money later in your career. Right now you need experience.

**GET YOUR DEGREE WHILE YOU ARE WORKING**  


### CHAPTER 8 - CODING BOOT CAMPS
In the not too distant past there were only two choices if you wanted to become a programmer: go to college or teach yourself.

#### WHAT IS A CODING BOOT CAMP?
Before we can get into the advantages and disadvantages of coding bootcamps, we need to first talk about what exactly a coding boot camp is.

While there is huge variety in what each coding boot camp teaches, how they teach it, and how long the boot camps are, they are all focused on one basic idea.

**They teach you to become a programmer FAST.**

Most boot camps aim to teach you enough to get a job as a software developer in a compressed amount of time by **just focusing on what is really important and by having you really focus on as much real world type programming as possible.**

[Is a programming boot camp a good idea](https://simpleprogrammer.com/2015/06/11/is-paying-for-developer-bootcamp-worth-it/) and is it the right choice for you?

#### ADVANTAGES
Contrary to popular belief, there are certainly a large number of advantages to going down the coding boot camp route.

**SHORT LEARNING TIME**  
One of the biggest advantages that you'll find a coding boot camp offers is the **compression of learning into a very short period of time.**

Going to college or even learning on your own could take years.

**Some boot camps promise to get you a job as a software developer in as little as three months.**

Some boot camps have you **working 10-12 hours a day, six days a week**, doing nothing but learning to code and practicing programming.

Many developers can get the equivalent of several years of experience in that time because,
**in a typical workplace, you might only code about 20% of your time** if that.

If you apply yourself and really buckle down, I could see you feasibly learning in an even shorter timeframe than three months.

**Time is money** ([and vice versa](https://simpleprogrammer.com/2014/05/01/money-time/)). Invest your time to make money, leverage that money to make more, then buy back your time for a net profit.

As advantages go, it's pretty clear that this one can't be overlooked, as long as you are willing to accept that you can actually learn to program in this short time frame.

Difficult, but possible.

**HIGH PLACEMENT RATE**  
It's undeniable that **many boot camps have an extremely high placement rate for their students** with real jobs working at real companies especially in Silicon Valley.

Now, not all boot camps are created equal, but **I have heard of good boot camps having placement rates as high or higher than 90%.**

This is an insanely valuable advantage.

To think that someone could go from making $30k a year to making $80-$100k a year as a software developer in as little as a few grueling months.

If you get a college degree, some degree programs will try and help you get a placement, but most leave you on your own unless you enroll in an internship program.

John said, **I know plenty of college graduates who can't find jobs and frequently complain about it [on my YouTube channel](http://youtube.com/jsonmez).**

I don't know anyone who has completed a boot camp and hasn't been able to find a job.

Granted, I'm sure that not all boot camp graduates are able to find a job easily, but since one of the biggest advantages that a boot camp offers is the ability to get you a job, many boot camps set up great relationships with employers to help them do just that.

**Boot camps have a vested interest in you getting a job after completing their program.**

In fact, some boot camps actually give you a full refund of your tuition and only make money when you find a job, at which point they take a cut of your first year's salary.

It is difficult to get a job without experience, so we consider this to be a significant advantage.

**LOW PRICE**  
While some people complain about how expensive boot camps are, [I find them to be extremely cheap for the value you get](https://www.youtube.com/watch?v=TO7DW4xtv8Q) especially compared to traditional college tuitions.

Boot camps range in price from free to around $20,000 at the top end.

When you consider that cheap college tuition might be around $10-$20k per year for 4+ years, **even the most expensive boot camp is really quite cheap.**

**FOCUSED STUDY**  
Another major advantage of a boot camp is **the opportunity for a very focused and intense study of the craft of programming.**

While you may focus for periods of time when going to college especially when finals are coming up more of your energy is scattered as you are learning information over several years and it's mixed with other subjects.

Not so with a boot cam

**Some boot camps have students working six days a week at 10-12 hours a day**, focused solely on learning to code.

While some people may see this as a drawback, **I've always found the best way to learn and improve at anything is through long periods of very intense focus.**

You've probably heard that the total immersion technique is the best way to learn a foreign language, and I'd say it's pretty much the same for programming as well.

This kind of focus is one of the reasons why boot camps can cover a large amount of information in such a small period of time.

**REAL WORK-LIKE SETTING**  
Since boot camps are usually focused on taking someone who has conceivably never written code before and getting them ready to immediately start working in a real job as a programmer in as short a time period as possible, **you can bet that most coding boot camps will be structured in such a way as to mimic real programming environments.**

The focus within most boot camps is pragmatic in nature, which I find to be highly advantageous if you want to get up to speed and working as soon as possible.

**WORK WITH OTHER HIGHLY MOTIVATED PEOPLE**  
"_For those who are wondering why some people are willing to pay a lot of money to go to a bootcamp, it's not because they don't know that you can learn this stuf on your own, obviously there's an abundance of cheap or even free resources on the web._

_But you can potentially get more personal growth by going to a bootcamp, there's a socialaspect to it, and some people learn better when they have a specific structure to follow._

_**It can be extremely motivating to be surrounded by other like-minded students**, and the type of inspiration you take in is more direct than if you get everything from a book or a video._" -David Tromholt

Many coding boot camps are set up like a hybrid classroom / work environment where you work and learn directly with other students.

Not only can this be motivating, but it is some good training for what it's like to work on a team.

#### DISADVANTAGES
**Coding boot camps are not for the timid or lazy.**

**HUGE TIME COMMITMENT**  
Even though you'll be learning to program rather quickly in calendar time, there is a massive time commitment required to attend and graduate from a coding boot camp.

**This isn't something you do in the evenings, or as a hobby.** It's not like working out or going for a run. A coding boot camp is pretty much a full-time commitment.

If you enroll in a coding boot camp, **expect it to completely consume your life.**

You are pretty much going to have to quit your job and drop everything else you have going on to focus only on learning to code for three or even six months.

Some of the longer programs might go at a slower pace, but the time commitment is still going to be much more intense than going to college or learning slowly on your own.

Like I said before, some coding boot camps require students to be in the classroom or working on projects 10-12 hours a day, six days a week.

**CAN BE EXTREMELY DIFFICULT**  
Most coding boot camps are extremely fast paced, taking you from knowing nothing about programming to writing real code in the first week.

There is a huge amount to learn in a very compressed amount of time, so **there is exactly zero room for slacking off** especially if you have no programming background at all.

If you are the kind of person who thrives under challenging situations, you may actually find this to be a good thing, but most people will consider this at least somewhat of a disadvantage, one that should not be overlooked.

**STILL SOMEWHAT EXPENSIVE**  
Even though coding boot camps are much cheaper than traditional colleges, they are still expensive, and they can seem even more expensive if there isn't an option of financial aid.

**PLENTY OF SCAMMY CODE CAMPS**  
This is probably the worst disadvantage I can think of when it comes to coding boot camps: **there are so many bad ones out there.**

Remember, **you have to be extremely careful** when picking a coding boot camp.

**The last thing you want to do is to spend several thousands of dollars, quit your current job, and devote three months of your life to something, only to find out it was all a waste of time and money.**

While there are plenty of legitimate coding boot camps out there with good track records and happy students, there are many more fly-by-night companies trying to make a quick buck off of the coding boot camps craze.

An experienced programmer might be able to spot these scams from a mile away, but for someone just starting out in the field, it can be very difficult to tell legitimate operations from money-grabbers.

**NO DEGREE TO FALL BACK ON**  
Even though a coding boot camp may teach you to program and help you get a job as a software developer, **it doesn't mean you are set for life.**

If you decide to change professions or want to apply to a company which requires applicants to have a degree, you might be out of luck if you invested in a coding boot camp instead of a college or
university.

It all depends on how risk averse you are and how much importance you place on having an actual degree.

**Once you break into the field of software development, a degree isn't nearly as important**, but others might disagree and who knows if that will change in the future.

**MAY BE LACKING IN SOME AREAS OF COMPUTER SCIENCE KNOWLEDGE**  
Boot camps are pragmatic.  
That can be both good and bad.

It's good because you are going to learn exactly what you need to know to get a job as a software developer and write code, but it can be bad because **you might be missing some other knowledge which could genuinely help you in your career** long term.

In fact, the reason why so many experienced programmers seem to have a large amount of animosity towards coding boot camps probably stems from this concern.

**Coding boot camps tend to focus on how to develop software, not the whys or science behind it.**

This can sometimes result in an **overconfidence in your abilities** without really understanding what you are doing.

Of course, it's easy to remedy this problem by going back and learning some of the computer science concepts not covered in your boot camp later on in your career, but most developers never seem to find the time to go back and do it.

Therefore, realize that even if attending a coding boot camp can teach you to code and get you a job as a programmer, **it may leave you with some knowledge gaps that you may want to go back and fill in** if you don't want to be held back from reaching your full potential.

#### STRATEGY
**RESEARCH TO MAKE SURE YOU AREN'T BEING SCAMMED**  
First of all, **do the research to make sure you aren't enrolling into one of those less than reputable coding boot camps.**

**Make sure you don't bargain hunt when shopping for a coding boot camp.**

It is much better to pay a few thousand more dollars and actually learn something valuable and get a real job as a software developer than to save a few bucks.

The easiest way to check out a coding boot camp is to **talk to its previous students.**

Make sure you talk to multiple previous students about their experiences with the boot camp, what they learned, and how easy it was to find a job after graduating.

**This is a basic step of due diligence that can save you from being scammed out of thousands of dollars and help you avoid many days of heartache and regret.**

Take the time, do the research, and be willing to pay a higher price for a higher quality result.

**SAVE UP TO PAY IN FULL**  
**There is no guarantee you are going to get a job after graduating from a coding boot camp**, so don't max out your credit cards, take a hammer to your piggy bank, mortgage your house, and borrow against your 401k to attend one.

Instead, **be smart about it.**

While you are researching boot camps, be saving money as well.

Sure, it might take you a bit longer before you can enroll and start your career as a newly minted programmer, but you'll also be hedging your bet and not be overcommitting yourself financially to something you can't afford, solely on the hope of future prospects.

In just about any arena, this kind of short-sighted thinking is a recipe for disaster.

**CLEAR YOUR SCHEDULE COMPLETELY**  
As humans, we tend to overestimate what we can accomplish in a day.

**To-do lists never end up getting done.**

We always pack more into our schedule than humanly possible.

If you are going to spend the time, money, and effort to attend a coding boot camp, **I would suggest clearing everything off of your schedule** and giving all your time and focus to that endeavor.

Yes, it might be possible to hold down a job and attend a coding boot camp at night or to continue to work on a [side project](https://simpleprogrammer.com/2015/11/19/advice-on-a-side-project/) or go to school, but because coding boot camps tend to be so fast paced, I wouldn't take the risk.

**STAY AFTER AND NETWORK AS MUCH AS POSSIBLE**  
**Stay after and work more on your projects.**

**Talk to people** in the boot camp.

**Get in good with the instructors** and offer to help them with anything they might need help on so that you can have a chance to learn even more.

Show that you are committed and willing to help others. People will see you working hard, they'll see your earnestness, and they'll remember that, which will come in handy when you do go looking for that job.

**MAKE SURE YOU ARE THE TOP OF THE CLASS**  
If a coding boot camp has a 90% placement rate of students into real jobs, after the boot camp is over, **you want to be damn sure that you are not in the bottom 10% of the class.**

In fact, **I'd be vying as hard as I could for the top spot** because that spot is almost guaranteed a great job.

So give it your all. Breaking into the software development industry without any experience or a degree is extremely difficult. I wouldn't want to take any chances, especially if I was paying a big chunk of cash and committing a large amount of time to the endeavor.

**LEARN THE BASICS AHEAD OF TIME**  
Last but not the least, **come into a coding boot camp with as much programming knowledge as possible** in the language you are going to be learning.

If you want to be one of the top students in the coding boot camp and you want to make sure you get the most out of it, you want to make sure you don't get left behind.

**Every advantage you can have, you should try to take**, and one of the biggest advantages you can start with is to already be at least somewhat familiar with the programming language and technology you will be learning in the coding boot camp.

Set yourself up for success. **Don't assume you are going to learn everything you need to know in a coding boot camp.**

Instead, come in with the attitude that you are going to the boot camp to **accelerate your learning** and leave with the knowledge of how to apply what you have learned to a real world setting.


<!-- ### CHAPTER 9 - TEACHING YOURSELF
Many programmers are self-taught.

It's not rare in the world of software development to come across a programmer who learned how to program on his own.

Some of **the best programmers learned programming out of necessity** when doing another job, and found they needed to automate some set of common tasks.

That doesn't mean teaching yourself programming is easy

**There are plenty of eager software developers in training who struggle with teaching themselves and get frustrated along the way.**

**Self-taught programmers tend to think they can take on just about any challenge.**

But… sometimes they get in over their heads or they move too fast, often being labeled as [cowboy coders](https://simpleprogrammer.com/2014/06/09/one-path-success/).

That doesn't mean all self-taught programmers are the same, but there are some distinct advantages and disadvantages when learning to code on your own.

If you are considering learning on your own, you should be aware of the advantages and disadvantages before you embark on this exciting and sometimes frustrating journey.

#### ADVANTAGES TO SELF-TAUGHT PROGRAMMING
**Most of the advantages here are based around flexibility.**

When you learn on your own, you have ultimate flexibility. Some people see this as a good thing,
others as a bad thing.

Flexibility is great when you can **utilize it to allow you to do more** and go down the path you want to go down.

It's not so good when the lack of structure leaves you **feeling like you don't know what to do and lacking the motivation to find out.**

But, that's not the only advantage.

Cost, and the acquisition of the skill of self education are also really good reasons to choose the selftaught road.

**COST IS LOW OR NOTHING**  
Teaching yourself to program can save you a huge amount of money.

Today, **anyone can conceivably learn to program just using the free resources available on the internet.**

We really do live in an amazing time as far as access to information, especially about programming.

The web abounds with free tutorials, blog posts, reference manuals, and even complete copies of books which one could use to learn how to become a software developer.

Even many of the programming tools and development environments are free for programmers learning their craft.

Now, **that doesn't mean free is always the best way to go.**

[Often it's worth paying some amount of money](https://www.youtube.com/watch?v=X9YSxrPdlxQ) to get access to a more curated set of learning materials.

But, again, that route is still much cheaper than college or a coding boot camp.

A few thousand dollars can buy you [far more books](http://simpleprogrammer.com/#) than you can ever read and gain you access to literally thousands of online courses through sites like [Pluralsight](http://simpleprogrammer.com/pluralsight), [Lynda](http://lynda.com) or [Udemy](http://udemy.com).

If you are cash-strapped, this reason alone might be enough to convince you to go down the self-taught programmer rout

**SELF-EDUCATION IS ONE OF THE MOST VALUABLE SKILLS YOU CAN LEARN**  
Whenever I give a talk on the [top five soft skills every software developer should know, selfeducation](https://www.youtube.com/watch?v=cVC3DQvAAIA), or learning to learn, always makes the top of the list.

I can't stress enough how valuable of a skill this is, not just in the field of computer programming and software development, but in life in general.

**People who master the skill of self-education have a whole world of possibility and opportunity open up to them that those who rely on others for education and learning do not.**

There is almost nothing you can't do in life if you have [the ability to teach yourself](https://aax-us-east.amazon-adsystem.com/x/c/Qo0tkCmaKay-7qTh1M8-8NYAAAFfbc83mAEAAAFKAQFzLOQ/http://www.amazon.com/Art-Self-Directed-Learning-Unconventional-Education-ebook/dp/B00NH0PDDY/ref=as_at/?imprToken=JRpDWGmsELDwlhpTxgLdxw&slotNum=16&ie=UTF8&qid=1466010055&sr=8-6&keywords=self+education&linkCode=sl1&tag=makithecompsi-20&linkId=aa2dcc6fc8e94f067c175818bf804c79), so **I place an extremely high value on learning this skill.**

That doesn't mean you have to learn this skill by learning to program on your own, but it is a great way to develop it since it's such a difficult and demanding endeavor.

**There are few things that are more difficult to learn in life than learning to program on your own.**

John said, I know some people will disagree with me on that statement, but I have taught myself many skills and I have been a teacher of all kinds of life skills for a long time, and I've only encountered one challenge greater than that of learning to code: learning to be an entrepreneur.

**YOU CAN LEARN AT YOUR OWN PACE**  
One of the major struggles people have with traditional education or boot camps is that they either move too quickly or too slowly.

Different people, with varied backgrounds, intelligence levels, and concentration abilities are going to learn and grasp things at a different pace.

**It can be frustrating to be in a setting where the teacher is teaching at a slower pace than what would be optimal for you**, because it feels like you are wasting your time and you may become bored and not pay attention.

On the other hand, **it can also be equally frustrating when you are sitting in a class that seems to be moving too quickly** and you are having trouble understanding what is going on.

By teaching yourself how to program, you can avoid this problem completely and move at the pace that is most comfortable to you.

In the end, you'll probably have a better understanding of what you are learning, because you'll be able to completely explore a concept before moving on to the next one.

If you consider yourself a slow learner or a very rapid learner, this could be a big advantage that you may want to consider.

**YOU CAN WORK AROUND YOUR SCHEDULE**  
When you decide to go to college or a coding boot camp, you are committing a huge amount of time in both your daily schedule and your life to one specific endeavor.

This can be great if you don't have other commitments and you have the luxury of focusing on just learning to program or getting your degree, but **if you already have a hectic schedule and you don't want to quit your full-time job, learning on your own can be a much better choice.**

In fact, it may be your only choice.

So, if you don't want to drop everything else in your life to focus on learning to program, this could be a pretty big reason to learn on your own.

**YOU CAN GO DEEP ON SUBJECTS YOU ARE INTERESTED IN**  
If you find yourself to be a very curious person who really wants to dig deep and understand what they are learning, you will probably be frustrated in college and perhaps in coding boot camps where there is often an emphasis on rushing to cover the required material, rather than going deep to gain true understanding.

#### DISADVANTAGES TO SELF-TAUGHT PROGRAMMING
That same flexibility that is great for working around your schedule and letting you set your own course can be a detriment when you feel like you don’t know what to do and no one is guiding you.

**YOU HAVE TO FIGURE OUT WHAT TO DO AND WHAT TO LEARN**  
**When you have absolute flexibility, it can be extremely difficult to decide what to do.**

What do you learn first?  
How do you know if you are doing it right?  
How do you know if you are done?

If you are not a self-starter and you have problems with motivating yourself and walking down paths that aren’t completely paved, you might want to consider learning programming via a more guided pathway.

**NO HELP WITH FINDING A JOB**  
While colleges don’t often offer a huge amount of direct support for finding a job after you graduate, there are usually internship programs or networking opportunities which you can take advantage of to greatly increase your chances of getting a job after getting your degree.

Coding boot camps are even more focused on helping graduates get placed into companies after completing their programs.

But, when you are on your own… you are on… your own.

**It can be pretty tough to find your first job as a self-taught programmer.**

Getting your foot in the door and proving that you know what you are doing without any experience, certificate, or degree, can prove challenging.

**IT’S EASY TO LOSE MOTIVATION**  
Not many people can [push on and accomplish a goal without motivation](https://www.youtube.com/watch?v=OgMAreNQiuQ).

It’s an extremely valuable skill in life, but it’s a rare one and is difficult to develop.

**Most people only do things when they feel motivated to do them** which is usually when they first start.

That is where committing to a structured program like a formal degree at a college or even a three to six month program at a coding boot camp can help.

When you feel obligated to complete something because you **threw down a large wad of cash**, or committed a large amount of time already, it can be easier to push on, even when motivation wanes.

**It can also help to be around other people whose motivation and enthusiasm may rub off on you**, for those times when you are lacking it.

Learning on your own can be difficult if you can’t either work without motivation or [you aren’t very good at self-motivating](https://aax-us-east.amazon-adsystem.com/x/c/Qo0tkCmaKay-7qTh1M8-8NYAAAFfbc83mAEAAAFKAQFzLOQ/http://www.amazon.com/Motivation-Manifesto-Brendon-Burchard/dp/1401948073/ref=as_at/?imprToken=JRpDWGmsELDwlhpTxgLdxw&slotNum=17&ie=UTF8&qid=1466010111&sr=8-2&keywords=motivation&linkCode=sl1&tag=makithecompsi-20&linkId=f9d73a4116916676517f8067a37b90bd).

Remember, everything eventually gets boring. The newness wears off.

At some point, studying programming at 7:30 PM, after a hard day of work is not going to seem so fun. Will you be able to push through and do it anyway?

Or will you be better off with a formal structure that guides you a little more firmly?

**SOCIAL ISOLATION**   -->
