# Progress towards my learning goals

In each folder, separated by courses, books, and others are my notes, related to what I'm studying, doing, or learning...

## 2018 -

My goals are to
- focus and be proficient with web development with computer science concepts
- learn while building useful projects
- increase my confidence and join the network of communications
- learn more by contributing to an open source project


## **Computer Science and Programming**

Current Book: [You Don't Know JS: Up & Going](https://github.com/getify/You-Dont-Know-JS/blob/master/up%20&%20going/README.md#you-dont-know-js-up--going)
Current Course: [The Complete 2019 Web Development Bootcamp](https://www.udemy.com/course/the-complete-web-development-bootcamp/)

## Junior developer

If you want to develop the skills necessary to be 'job ready' for a junior developer position - complete tier X, 0, and 1.

### Tier X - Math Prep

Math will be relevant throughout the guide. Begin it as you start the guide, and incrementally work through it alongside the guide. (You need not finish this before moving to tier 0, or tier 1, but be actively working on it alongside them.)

| Courses                                                       | Status | Evidence |
| :------------------------------------------------------------ | :----: | :------- |
| [Algebra I](https://www.khanacademy.org/math/algebra)         |        |
| [Algebra II](https://www.khanacademy.org/math/algebra2)       |        |
| [Trigonometry](https://www.khanacademy.org/math/trigonometry) |        |
| [Precalculus](https://www.khanacademy.org/math/precalculus)   |        |

### Tier X - Programming Prep Prep

A very gentle introduction, complete if feel you would benefit from it, skip if you'd rather dive right into tier 0

| Courses                                                                                                                                                               |   Status   | Evidence                                                                                                                 |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :--------: | :----------------------------------------------------------------------------------------------------------------------- |
| [Intro to JS: Drawing & Animation](https://www.khanacademy.org/computing/computer-programming/programming)                                                            |  08/22/19  | [Notes](https://github.com/genesisgabiola/khanacademy/blob/master/computer-programming/01-drawing--animation.md)         |
| [Intro to HTML/CSS: Making webpages](https://www.khanacademy.org/computing/computer-programming/html-css)                                                             |  09/05/19  | [Notes](https://github.com/genesisgabiola/khanacademy/blob/master/computer-programming/02-making-webpages.md)            |
| [Intro to SQL: Querying and managing data](https://www.khanacademy.org/computing/computer-programming/sql)                                                            |    WIP     | [Notes](https://github.com/genesisgabiola/khanacademy/blob/master/computer-programming/03-querying-and-managing-data.md) |
| [Advanced JS: Games & Visualizations](https://www.khanacademy.org/computing/computer-programming/programming-games-visualizations)                                    |            |
| [HTML/JS: Making webpages interactive](https://www.khanacademy.org/computing/computer-programming/html-css-js)                                                        |            |
| **Capstone**                                                                                                                                                          | **Status** | **Evidence**                                                                                                             |
| Create a website highlighting what you learned and built during this tier. Use this as an opportunity to create a portfolio of your projects, notes, blog posts, etc. |            |

### Tier 0 - Web Development - Fullstack Bootcamp - App Academy Open

Complete the [App Academy Open](https://open.appacademy.io/) free online Fullstack Bootcamp.

| Courses                                                                                                                                                               |   Status   | Evidence                                                                                       |
| :-------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :--------: | :--------------------------------------------------------------------------------------------- |
| Welcome To Coding                                                                                                                                                     | 03/28/2020 | [Notes](https://github.com/genesisgabiola/appacademy-open/tree/master/01-welcome-to-coding)    |
| Full Stack Online - Intro to Programming                                                                                                                              | 05/20/2020 | [Notes](https://github.com/genesisgabiola/appacademy-open/tree/master/02-intro-to-programming) |
| Full Stack Online - Software Engineering Foundations                                                                                                                  |            |
| Full Stack Online - Ruby                                                                                                                                              |            |
| Full Stack Online - SQL                                                                                                                                               |            |
| Full Stack Online - Rails                                                                                                                                             |            |
| Full Stack Online - JavaScript                                                                                                                                        |            |
| Full Stack Online - React                                                                                                                                             |            |
| Full Stack Online - Full Stack Project                                                                                                                                |            |
| Full Stack Online - Job Search                                                                                                                                        |            |
| **Capstone**                                                                                                                                                          | **Status** | **Evidence**                                                                                   |
| Create a website highlighting what you learned and built during this tier. Use this as an opportunity to create a portfolio of your projects, notes, blog posts, etc. |            |

### Tier 1 - Getting Started

Deepen understanding of Web Development and begin learning Computer Science topics

| Courses                                                                                                                                                                                                                                                                                                                                                        |   Status   | Evidence     |
| :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :--------: | :----------- |
| [CS50's Introduction to Computer Science](https://www.edx.org/course/cs50s-introduction-computer-science-harvardx-cs50x)                                                                                                                                                                                                                                       |    WIP     |
| [How to Learn Math: For Students](https://lagunita.stanford.edu/courses/Education/EDUC115-S/Spring2014/about)                                                                                                                                                                                                                                                  |            |
| [CS50's Web Programming with Python and JavaScript](https://www.edx.org/course/cs50s-web-programming-with-python-and-javascript)                                                                                                                                                                                                                               |            |
| [Single Variable Calculus](https://ocw.mit.edu/courses/mathematics/18-01sc-single-variable-calculus-fall-2010/) (more rigorous) or [Khan Academy Calculus I](https://www.khanacademy.org/math/calculus-1) and [Khan Academy Calculus II](https://www.khanacademy.org/math/calculus-2) (a more gentle introduction)                                             |            |
| [Algorithms](https://www.khanacademy.org/computing/computer-science/algorithms)                                                                                                                                                                                                                                                                                |            |
| [Software Debugging](https://www.udacity.com/course/software-debugging--cs259)                                                                                                                                                                                                                                                                                 |            |
| [Software Testing](https://www.udacity.com/course/software-testing--cs258)                                                                                                                                                                                                                                                                                     |            |
| [CS50's Mobile App Development with React Native](https://www.edx.org/course/cs50s-mobile-app-development-with-react-native)                                                                                                                                                                                                                                   |            |
| **Reading**                                                                                                                                                                                                                                                                                                                                                    | **Status** | **Evidence** |
| [MDN HTML - Advanced topics](https://developer.mozilla.org/en-US/docs/Web/HTML#Advanced_topics)                                                                                                                                                                                                                                                                |            |
| [MDN CSS - Reference - Key Concepts](https://developer.mozilla.org/en-US/docs/Web/CSS#Reference)                                                                                                                                                                                                                                                               |            |
| [MDN JavaScript - Tutorials - JavaScript Guide](https://developer.mozilla.org/en-US/docs/Web/JavaScript#JavaScript_guide)                                                                                                                                                                                                                                      |            |
| [You Don't Know JS: Up & Going](https://github.com/getify/You-Dont-Know-JS/blob/master/up%20&%20going/README.md#you-dont-know-js-up--going)                                                                                                                                                                                                                    |            |
| [You Don't Know JS: Scope & Closures](https://github.com/getify/You-Dont-Know-JS/blob/master/scope%20&%20closures/README.md#you-dont-know-js-scope--closures)                                                                                                                                                                                                  |            |
| [You Don't Know JS: this & Object Prototypes](https://github.com/getify/You-Dont-Know-JS/blob/master/this%20&%20object%20prototypes/README.md#you-dont-know-js-this--object-prototypes)                                                                                                                                                                        |            |
| **Practice**                                                                                                                                                                                                                                                                                                                                                   | **Status** | **Evidence** |
| Complete all Classic Puzzles - Easy on [CodinGame](https://www.codingame.com/)                                                                                                                                                                                                                                                                                 |            |
| Complete [Google Kick Start 2018](https://codingcompetitions.withgoogle.com/kickstart/archive/2018)                                                                                                                                                                                                                                                            |            |
| Tier Programming Project                                                                                                                                                                                                                                                                                                                                       |            |
| Tier Programming Project                                                                                                                                                                                                                                                                                                                                       |            |
| **Specialization**                                                                                                                                                                                                                                                                                                                                             | **Status** | **Evidence** |
| Complete a [Specialization](#specializations) - note: you will have the opportunity to complete a specialization in each tier so don't worry overmuch about picking 'the right one'. That said, if you didn't do App Academy in Tier 0 [Web Development - Fullstack Bootcamp - App Academy Open](./specializations/app-academy-open.md) is highly recommended. |            |

<br>

## Intermediate Developer

If you want to develop the skills necessary to move beyond junior to intermediate developer - once you've finished tiers X, 0 and 1, proceed to complete tiers 2 and 3.

### Tier 2 - Develop More Expertise

Dive deeper into the Computer Science topics which will prove useful throughout all programming

| Courses                                                                                                                                                                                                            |   Status   | Evidence     |
| :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :--------: | :----------- |
| [Mathematics for Computer Science](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-042j-mathematics-for-computer-science-spring-2015/)                                                   |            |
| [Introduction to Computer Science and Programming in Python](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-0001-introduction-to-computer-science-and-programming-in-python-fall-2016/) |            |
| [Introduction to Computational Thinking and Data Science](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-0002-introduction-to-computational-thinking-and-data-science-fall-2016/)       |            |
| [Software Construction](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-005-software-construction-spring-2016/)                                                                          |            |
| [Introduction to Algorithms](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-006-introduction-to-algorithms-fall-2011/)                                                                  |            |
| [Algorithms: Design and Analysis](https://lagunita.stanford.edu/courses/course-v1:Engineering+Algorithms1+SelfPaced/about)                                                                                         |            |
| **Reading**                                                                                                                                                                                                        | **Status** | **Evidence** |
| [MDN JavaScript - Tutorials - Advanced](https://developer.mozilla.org/en-US/docs/Web/JavaScript#Advanced)                                                                                                          |            |
| [MDN HTTP - Tutorials](https://developer.mozilla.org/en-US/docs/Web/HTTP#Tutorials)                                                                                                                                |            |
| [MDN Web Components](https://developer.mozilla.org/en-US/docs/Web/Web_components)                                                                                                                                  |            |
| [You Don't Know JS: Types & Grammar](https://github.com/getify/You-Dont-Know-JS/blob/master/types%20&%20grammar/README.md#you-dont-know-js-types--grammar)                                                         |            |
| [You Don't Know JS: ES6 & Beyond](https://github.com/getify/You-Dont-Know-JS/blob/master/es6%20&%20beyond/README.md#you-dont-know-js-es6--beyond)                                                                  |            |
| [JavaScript Allongé, the "Six" Edition](https://leanpub.com/javascriptallongesix)                                                                                                                                  |            |
| [D3 Tips and Tricks v3.x](https://leanpub.com/D3-Tips-and-Tricks/read#leanpub-auto-acknowledgements)                                                                                                               |            |
| **Practice**                                                                                                                                                                                                       | **Status** | **Evidence** |
| Complete all Classic Puzzles - Medium on [CodinGame](https://www.codingame.com/)                                                                                                                                   |            |
| Complete all ES6 Katas [here](http://es6katas.org/)                                                                                                                                                                |            |
| Complete [Google Kick Start 2017](https://codingcompetitions.withgoogle.com/kickstart/archive/2017)                                                                                                                |            |
| Complete [Google Code Jam 2018](https://codingcompetitions.withgoogle.com/codejam/archive/2018)                                                                                                                    |            |
| Complete [FaceBook Hacker Cup 2017](https://www.facebook.com/hackercup/past_rounds/)                                                                                                                               |            |
| Tier Programming Project                                                                                                                                                                                           |            |
| Tier Programming Project                                                                                                                                                                                           |            |
| **Specialization**                                                                                                                                                                                                 | **Status** | **Evidence** |
| Complete a [Specialization](#specializations) - note: you may elect to complete another round of a specialization you selected in a prior tier, or branch out and complete a different specialization              |            |

### Tier 3 - Add More Rigor

Dive deeper yet, exploring algorithms and different programming paradigms

| Courses                                                                                                                                                                                                                                                    |   Status   | Evidence     |
| :--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :--------: | :----------- |
| [Software Architecture & Design](https://www.udacity.com/course/software-architecture-design--ud821)                                                                                                                                                       |            |
| [Probabilistic Systems Analysis and Applied Probability](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-041sc-probabilistic-systems-analysis-and-applied-probability-fall-2013/)                                                |            |
| [Algorithms: Design and Analysis, Part 2](https://lagunita.stanford.edu/courses/course-v1:Engineering+Algorithms2+SelfPaced/about)                                                                                                                         |            |
| [Multivariable Calculus](https://ocw.mit.edu/courses/mathematics/18-02sc-multivariable-calculus-fall-2010/) (more rigorous) or [Khan Academy Multivariable Calculus](https://www.khanacademy.org/math/multivariable-calculus) (a more gentle introduction) |            |
| [Structure and Interpretation of Computer Programs](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-001-structure-and-interpretation-of-computer-programs-spring-2005/)                                                          |            |
| [Design and Analysis of Algorithms](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-046j-design-and-analysis-of-algorithms-spring-2015/)                                                                                         |            |
| [Artificial Intelligence](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-034-artificial-intelligence-fall-2010/index.htm)                                                                                                       |            |
| **Reading**                                                                                                                                                                                                                                                | **Status** | **Evidence** |
| Official docs for [Angular](https://angular.io/docs), [React](https://reactjs.org/docs/getting-started.html), or [Vue](https://vuejs.org/v2/guide/)                                                                                                        |            |
| [Jest Official Docs](https://jestjs.io/)                                                                                                                                                                                                                   |            |
| [JavaScript Design Patterns](https://addyosmani.com/resources/essentialjsdesignpatterns/book/)                                                                                                                                                             |            |
| [Understanding ECMAScript 6](https://leanpub.com/understandinges6/read)                                                                                                                                                                                    |            |
| [Professor Frisby's Mostly Adequate Guide to Functional Programming](https://www.gitbook.com/book/drboolean/mostly-adequate-guide/details)                                                                                                                 |            |
| [Functional Light JS](https://github.com/getify/Functional-Light-JS)                                                                                                                                                                                       |            |
| [Essential TypeScript](https://leanpub.com/essentialtypescript/read)                                                                                                                                                                                       |            |
| **Practice**                                                                                                                                                                                                                                               | **Status** | **Evidence** |
| Complete all Classic Puzzles - Hard on [CodinGame](https://www.codingame.com/)                                                                                                                                                                             |            |
| Write the CSS Necessary to create your own 12 column based grid layout - see [here](http://960.gs/) for an example                                                                                                                                         |            |
| Study [The official Sass docs](https://sass-lang.com/) and convert your 12 column based grid layout to Sass                                                                                                                                                |            |
| Complete All Tracks (Basic Programming, Data Structures, Algorithms, Math, Machine Learning, and Python) on [HackerEarth](https://www.hackerearth.com/practice/)                                                                                           |            |
| Complete [Google Kick Start 2016](https://codingcompetitions.withgoogle.com/kickstart/archive/2016)                                                                                                                                                        |            |
| Complete [Google Code Jam 2017](https://codingcompetitions.withgoogle.com/codejam/archive/2017)                                                                                                                                                            |            |
| Complete [FaceBook Hacker Cup 2016](https://www.facebook.com/hackercup/past_rounds/)                                                                                                                                                                       |            |
| Tier Programming Project                                                                                                                                                                                                                                   |            |
| Tier Programming Project                                                                                                                                                                                                                                   |            |
| **Specialization**                                                                                                                                                                                                                                         | **Status** | **Evidence** |
| Complete a [Specialization](#specializations) - note: you may elect to complete another round of a specialization you selected in a prior tier, or branch out and complete a different specialization                                                      |            |

<br>

## Senior Developer

If you want to develop the skills necessary to move beyond intermediate to senior developer - once you've finished tiers X, 0, 1, 2, and 3, proceed to complete tiers 4 and 5.

### Tier 4 - Polish the Rough Edges

Wrap up by taking a look at some specific areas of computing to complete a breadth of knowledge that can be leveraged regardless of specialty

| Courses                                                                                                                                                                                               |   Status   | Evidence     |
| :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :--------: | :----------- |
| [Computation Structures](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-004-computation-structures-spring-2009/index.htm)                                                  |            |
| [Introduction to Databases - all mini-courses](https://lagunita.stanford.edu/courses/DB/2014/SelfPaced/about)                                                                                         |            |
| [Differential Equations](https://ocw.mit.edu/courses/mathematics/18-03sc-differential-equations-fall-2011/)                                                                                           |            |
| [Computer System Engineering](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-033-computer-system-engineering-spring-2018/)                                                 |            |
| [Performance Engineering of Software Systems](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-172-performance-engineering-of-software-systems-fall-2010/index.htm)          |            |
| [Mining Massive Datasets](https://lagunita.stanford.edu/courses/course-v1:ComputerScience+MMDS+SelfPaced/about)                                                                                       |            |
| [Compilers](https://lagunita.stanford.edu/courses/Engineering/Compilers/Fall2014/about)                                                                                                               |            |
| **Reading**                                                                                                                                                                                           | **Status** | **Evidence** |
| [How to Design Programs](https://htdp.org/)                                                                                                                                                           |            |
| [97 Things Every Programmer Should Know - Extended](https://leanpub.com/97-Things-Every-Programmer-Should-Know-Extended)                                                                              |            |
| [Think Java - How to Think Like a Computer Scientist](http://greenteapress.com/wp/think-java/)                                                                                                        |            |
| [Open Data Structures](http://www.aupress.ca/books/120226/ebook/99Z_Morin_2013-Open_Data_Structures.pdf)                                                                                              |            |
| [Node.js Docs](https://nodejs.org/en/docs/)                                                                                                                                                           |            |
| **Practice**                                                                                                                                                                                          | **Status** | **Evidence** |
| Complete all Classic Puzzles - Very Hard on [CodinGame](https://www.codingame.com/)                                                                                                                   |            |
| Study [The Google Android Developer Guide](https://developer.android.com/guide) and build the Android App of your choice                                                                              |            |
| Complete [Google Kick Start 2015](https://codingcompetitions.withgoogle.com/kickstart/archive/2015)                                                                                                   |            |
| Complete [Google Code Jam 2016](https://codingcompetitions.withgoogle.com/codejam/archive/2016)                                                                                                       |            |
| Complete [FaceBook Hacker Cup 2015](https://www.facebook.com/hackercup/past_rounds/)                                                                                                                  |            |
| Tier Programming Project                                                                                                                                                                              |            |
| Tier Programming Project                                                                                                                                                                              |            |
| **Specialization**                                                                                                                                                                                    | **Status** | **Evidence** |
| Complete a [Specialization](#specializations) - note: you may elect to complete another round of a specialization you selected in a prior tier, or branch out and complete a different specialization |            |

### Tier 5 - Specialize

Wrap up by diving more deeply into your specialization(s). If you haven't already done an [Advanced Specialization](#advanced-specializations), strongly consider including it in this tier. Beyond that, feel free to laser focus on one specialization, practicing more in that area, or branch out and develop expertise across multiple specializations.

| **Practice**                                                                                                                                                                    | **Status** | **Evidence** |
| :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | :--------: | :----------- |
| Complete a [Specialization](#specializations)                                                                                                                                   |            |
| Complete a [Specialization](#specializations)                                                                                                                                   |            |
| Complete a [Specialization](#specializations)                                                                                                                                   |            |
| Complete a [Specialization](#specializations)                                                                                                                                   |            |
| Complete a [Specialization](#specializations)                                                                                                                                   |            |
| **Capstone**                                                                                                                                                                    | **Status** | **Evidence** |
| Create a website highlighting what you learned and built during this specialization. Use this as an opportunity to create a portfolio of your projects, notes, blog posts, etc. |            |

<br>

## Specializations

Each tier has a 'specialization' based capstone which involves further study and extensive practice in an area of your choosing. [Fullstack Bootcamp - App Academy Open](./specializations/app-academy-open.md) is highly recommended (but not required) as the first specialization. Beyond that, feel free to complete a different specialization each tier, or dive deeply into a specialization by selecting it during multiple tiers to explore it in greater detail and further develop your specialized profile.

- [Fullstack Bootcamp - App Academy Open](./specializations/app-academy-open.md) (recommended, but not required, first specialization)
- [Deep Dive Into Modern Web Development - Full Stack Open 2019](./specializations/full-stack-open-2019.md)
- [Fullstack Bootcamp - The Odin Project](./specializations/the-odin-project.md)
- [Frontend Development](./specializations/frontend-dev.md)
- [Backend Development](./specializations/backend-dev.md)
- [Mobile App Development](./specializations/mobile-dev.md)
- [Game Development](./specializations/game-dev.md)
- [Open Source Contributions](./specializations/open-source.md)

<br>

## Advanced Specializations

The following specializations rely on knowledge gained in earlier tiers. Additionally, they are typically 'more difficult' or will require more work than those listed above.

- [Computer Science - Algorithms](./specializations/algorithms.md) -Suggested for Tier 2 or later
- [Computer Science - Advanced Algorithms](./specializations/advanced-algorithms.md) - Computer Science - Algorithms is a pre-requisite
- [Computer Science - Intensive](./specializations/computer-science.md) - Suggested for Tier 4 or later
- [Data Science I](./specializations/data-science-i.md) - Suggested for Tier 2 or later
- [Data Science II](./specializations/data-science-ii.md) - Data Science I is a pre-requisite

<br>

## Tier Programming Projects

Both tiers and specializations will require 'Tier Programming Projects', you are free to select any programming project you want. To help combat the 'but I don't know what I want' roadblock, [Tier Programming Project Ideas](./project-ideas.md) lists a variety of ideas.

**Note:** In specializations, the Tier Programming Projects might have extra criteria (such as 'if you're doing a mobile app development specialization your projects must be mobile apps')

<br>

## Extras

| Courses                                                                                                                                            |  Status  | Evidence                                                                                |
| :------------------------------------------------------------------------------------------------------------------------------------------------- | :------: | :-------------------------------------------------------------------------------------- |
| [Build Responsive Real World Websites with HTML5 and CSS3](https://www.udemy.com/design-and-develop-a-killer-website-with-html5-and-css3/)         | 07-06-18 | N/A                                                                                     |
| [Advanced CSS and Sass: Flexbox, Grid, Animations and More!](https://www.udemy.com/advanced-css-and-sass/)                                         | 07-31-18 | [Notes](./courses/udemy/advanced-css-and-sass.md)                                       |
| [How to Use SMART Goals - Achieve More in Less Time](https://www.udemy.com/goal-setting/)                                                          | 08-10-18 | [Notes](./courses/udemy/how-to-use-smart-goals.md)                                      |
| [How to Contribute to an Open Source Project on GitHub](https://egghead.io/courses/how-to-contribute-to-an-open-source-project-on-github)          | 10-16-18 | N/A                                                                                     |
| [Pre-Programming: Everything you need to know before you code](https://www.udemy.com/pre-programming-everything-you-need-to-know-before-you-code/) | 10-19-18 | [Notes](./courses/udemy/pre-programming-everything-you-need-to-know-before-you-code.md) |
| [Introduction to JavaScript](https://learn.co/tracks/introduction-to-javascript/)                                                                  | 11-03-18 | N/A                                                                                     |
| [JavaScript Basics for Beginners](https://www.udemy.com/javascript-basics-for-beginners/)                                                          | 11-05-18 | [Notes](./courses/udemy/javascript-basics-for-beginners.md)                             |
| [Learning How to Learn: Powerful mental tools to help you master tough subjects](https://www.coursera.org/learn/learning-how-to-learn)             | 11-18-18 | [Notes](./courses/coursera/learning-how-to-learn.md)                                    |
| [Modern HTML & CSS From The Beginning (Including Sass)](https://www.udemy.com/course/modern-html-css-from-the-beginning/)                          | 07-23-19 | [Notes](./courses/udemy/modern-html-css-from-the-beginning-including-sass/README.md)    |
| [The Complete 2019 Web Development Bootcamp](https://www.udemy.com/course/the-complete-web-development-bootcamp/)                                  | 09-14-19 | [Notes](./courses/udemy/the-complete-web-development-bootcamp/README.md)                |
| [Learn JavaScript: Full-Stack from Scratch](https://www.udemy.com/course/learn-javascript-full-stack-from-scratch/)                                | 02-23-20 | [Notes](./courses/udemy/learn-js-full-stack-from-scratch/README.md)                     |
| [CS50's Understanding Technology](https://www.edx.org/course/cs50s-understanding-technology-harvardx-cs50t)                                        | 06-26/20 | [Notes](./courses/edx/understanding-technology.md)                                      |
| [Modern JavaScript From The Beginning](https://www.udemy.com/modern-javascript-from-the-beginning/)                                                |   WIP    | [Notes](./courses/udemy/modern-javascript-from-the-beginning.md)                        |
| [The Complete JavaScript Course 2018: Build Real Projects!](https://www.udemy.com/the-complete-javascript-course/)                                 |          |
| [The Web Developer Bootcamp](https://www.udemy.com/the-web-developer-bootcamp/)                                                                    |          |
| [The Advanced Web Developer Bootcamp](https://www.udemy.com/the-advanced-web-developer-bootcamp/)                                                  |          |
| [The Complete Web Developer in 2018: Zero to Mastery](https://www.udemy.com/the-complete-web-developer-in-2018/)                                   |          |
| [The Complete Web Developer Course 2.0](https://www.udemy.com/the-complete-web-developer-course-2/)                                                |          |
| [The Modern Python 3 Bootcamp](https://www.udemy.com/the-modern-python3-bootcamp/)                                                                 |          |
| [The Ultimate MySQL Bootcamp: Go from SQL Beginner to Expert](https://www.udemy.com/the-ultimate-mysql-bootcamp-go-from-sql-beginner-to-expert/)   |          |
| [JavaScript: Understanding the Weird Parts](https://www.udemy.com/understand-javascript/)                                                          |          |
| [Learn and Understand NodeJS](https://www.udemy.com/understand-nodejs/)                                                                            |          |
| [ES6 Javascript: The Complete Developer's Guide](https://www.udemy.com/javascript-es6-tutorial/)                                                   |          |
| [Node with React: Fullstack Web Development](https://www.udemy.com/node-with-react-fullstack-web-development/)                                     |          |
| [The Complete Developers Guide to MongoDB](https://www.udemy.com/the-complete-developers-guide-to-mongodb/)                                        |          |
| [Webpack 2: The Complete Developer's Guide](https://www.udemy.com/webpack-2-the-complete-developers-guide/)                                        |          |
| [Modern React with Redux](https://www.udemy.com/react-redux/)                                                                                      |          |
| [Advanced React and Redux: 2018 Edition](https://www.udemy.com/react-redux-tutorial/)                                                              |          |
| [React 16 - The Complete Guide (incl. React Router 4 & Redux)](https://www.udemy.com/react-the-complete-guide-incl-redux/)                         |          |
| [The Complete React Web Developer Course (with Redux)](https://www.udemy.com/react-2nd-edition/)                                                   |          |
| [The Complete Node.js Developer Course (2nd Edition)](https://www.udemy.com/the-complete-nodejs-developer-course-2/)                               |          |
| [Complete Python Bootcamp: Go from zero to hero in Python 3](https://www.udemy.com/complete-python-bootcamp/)                                      |          |
| [Intro to JavaScript](https://www.udacity.com/course/intro-to-javascript--ud803)                                                                   |          |
|                                                                                                                                                    |          |

<br>

| Books                                                                                                                                             | Status | Evidence                                                          |
| :------------------------------------------------------------------------------------------------------------------------------------------------ | :----: | :---------------------------------------------------------------- |
| [A Smarter Way to Learn JavaScript](https://www.amazon.com/Smarter-JavaScript-tech-assisted-approach-requires/dp/1497408180/ref=tmm_pap_swatch_0) |  WIP   | [Notes](./books/a-smart-way-to-learn-javascript.md)               |
| [The Complete Software Developer's Career Guide](https://www.amazon.com/Complete-Software-Developers-Career-Guide-ebook/dp/B073X6GNJ1)            |  WIP   | [Notes](./books/the-complete-software-developers-career-guide.md) |
| [The JavaScript Handbook](https://www.freecodecamp.org/news/the-complete-javascript-handbook-f26b2c71719c/)                                       |  WIP   | [Notes](./books/the-javascript-handbook.md)                       |
|                                                                                                                                                   |        |

<br>

| Projects                                                                                                                                                             |  Status  | Evidence                                                                                                                       |
| :------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :------: | :----------------------------------------------------------------------------------------------------------------------------- |
| Basic Project                                                                                                                                                        | 07-07-18 | [Omnifood](https://genesisgabiola.github.io/omnifood/)                                                                         |
| Basic Project                                                                                                                                                        | 07-19-18 | [Natours](https://genesisgabiola.github.io/natours/)                                                                           |
| Basic Project                                                                                                                                                        | 07-26-18 | [Trillo](https://genesisgabiola.github.io/trillo/)                                                                             |
| Basic Project                                                                                                                                                        | 07-31-18 | [Nexter](https://genesisgabiola.github.io/nexter/)                                                                             |
| Basic Project                                                                                                                                                        | 07-10-19 | [HBS](https://genesisgabiola.github.io/hbs)                                                                                    |
| Basic Project                                                                                                                                                        | 07-13-19 | [bridgeledger](https://bridgeledger.netlify.com)                                                                               |
| Basic Project                                                                                                                                                        | 07-19-19 | [TechNews](https://tech-news.netlify.com/)                                                                                     |
| Basic Project                                                                                                                                                        | 07-23-19 | [johndoe-portfolio](https://johndoe-portfolio.netlify.com/)                                                                    |
| Basic Project                                                                                                                                                        | 08-05-19 | [tinderPet](https://tinderpet.netlify.com/)                                                                                    |
| [Build a Tribute Page](https://www.freecodecamp.org/learn/responsive-web-design/responsive-web-design-projects/build-a-tribute-page)                                 | 03-09-20 | [Brad Traversy \| Tribute Page](https://genesisgabiola.github.io/fcc-projects/tribute-page/)                                   |
| [Build a Survey Form](https://www.freecodecamp.org/learn/responsive-web-design/responsive-web-design-projects/build-a-survey-form)                                   | 03-11-20 | [FCC Survey Form](https://genesisgabiola.github.io/fcc-projects/survey-form/)                                                  |
| [Build a Product Landing Page](https://www.freecodecamp.org/learn/responsive-web-design/responsive-web-design-projects/build-a-product-landing-page)                 | 03-12-20 | [UPlayer \| Product Landing Page](https://genesisgabiola.github.io/fcc-projects/product-landing-page/)                         |
| [Build a Technical Documentation Page](https://www.freecodecamp.org/learn/responsive-web-design/responsive-web-design-projects/build-a-technical-documentation-page) | 03-20-20 | [JS Documentation \| Technical Documentation Page](https://genesisgabiola.github.io/fcc-projects/technical-documentation-page) |
| [Build a Personal Portfolio Webpage](https://www.freecodecamp.org/learn/responsive-web-design/responsive-web-design-projects/build-a-personal-portfolio-webpage)     | 03-24-20 | [FCC Portfolio \| Personal Portfolio Webpage](https://genesisgabiola.github.io/fcc-projects/personal-portfolio-webpage)        |
|                                                                                                                                                                      |          |


**Additional books can be found** [here](https://github.com/P1xt/speedstudy/blob/master/book-lists.md)

---

## Helpful links

- [surge.sh](https://surge.sh/)
- [heroku](https://www.heroku.com/)
- [Glitch](https://glitch.com/)
- [MDN](https://developer.mozilla.org/en-US/)
- [YDKJS](https://github.com/getify/You-Dont-Know-JS/)
- For when you need assets/ideas
  - [pixabay](https://pixabay.com/)
  - [Unsplash](https://unsplash.com/)
  - [Pexels](https://www.pexels.com/)
  - [LibreStock](http://librestock.com/)
  - [Google Fonts](https://fonts.google.com/)
  - [FlatIcon's Free Icon Sets](https://www.flaticon.com/packs?license=selection&order_by=1)
- Official Docs
  - [MDN Learn web development](https://developer.mozilla.org/en-US/docs/Learn)
  - [MDN HTML](https://developer.mozilla.org/en-US/docs/Web/HTML) - for exploring all that HTML has to offer
  - [MDN CSS](https://developer.mozilla.org/en-US/docs/Web/CSS)- for exploring all that CSS has to offer
  - [MDN JavaScript](https://developer.mozilla.org/en-US/docs/Web/JavaScript)- for exploring all that JavaScript has to offer
  - [Flask](http://flask.pocoo.org/) - Python microframework
  - [Django](https://www.djangoproject.com/) - Python framework
  - [Sass](http://sass-lang.com/guide) - supercharged CSS, for more check [Getting Sassy with CSS](http://www.sassshop.com/)
  - [Node.js](https://nodejs.org/en/docs/) - should be your primary reference for building backend projects
  - [Express](https://expressjs.com/) - an excellent framework to accompany Node.js on the backend
  - [MongoDB](https://docs.mongodb.com/) - for storing data
  - [Mongoose](http://mongoosejs.com/) - access to MongoDB from Node.js made easy(er)
  - [Passport.js](http://passportjs.org/) - remember this link when you have to setup a login system
  - [D3](https://d3js.org/) - for creating awesome graphs and charts
  - [AngularJS](https://angularjs.org/) - option for creating single page apps on the frontend
  - [Angular](https://angular.io/) - option for creating single page apps on the frontend
  - [React](https://reactjs.org/) - option for creating single page apps on the frontend
  - [Vue](https://vuejs.org/) - option for creating single page apps on the frontend
  - [Redux](http://redux.js.org/) - for managing state in a single page app
  - [Mocha](https://mochajs.org/) - venture into testing
  - [Karma](https://karma-runner.github.io/1.0/index.html) - venture into testing
  - [Jest](https://facebook.github.io/jest/) - venture into testing
  - [Webpack](https://webpack.github.io/) - module bundler for use in your build process (so you can minify your HTML/CSS/JavaScript among other things and deliver an optimized build to production)
  - [Babel](http://babeljs.io/) - makes the new JavaScript work on old browsers (or node versions for that matter)
  - [Gulp](https://gulpjs.com/) - for automating your workflow
  - [ESLint](https://eslint.org/) - for helping to keep your code clean
  - [Prettier](https://prettier.io/) - more help keeping your code clean
  - [Travis](https://travis-ci.org/) - continuous deployment (how to trigger a build/deploy whenever you commit your changes via git)

- **Full Paths**:
  - [p1xt-guides](https://github.com/P1xt/p1xt-guides)
  - [FCC](https://www.freecodecamp.org/)
  - [OSSU](https://github.com/ossu/computer-science)
  - [Coding Interview University](https://github.com/jwasham/coding-interview-university)
  - [The Odin Project](https://www.theodinproject.com/)

---

Credits: [P1xt](https://github.com/P1xt)
