# Frequently Asked Questions
_From p1xt guides._

## What are the pre-requisites to begin any of the guides?
You should understand how to use Git and Github, which you can learn using any of these free resources:

**Note**: Just pick one of the courses below to learn the basics. You will learn a lot more once you get started!
- [Try Git](https://try.github.io/levels/1/challenges/1)
- [Git - the simple guide](http://rogerdudler.github.io/git-guide/)
- [GitHub Training & Guides](https://www.youtube.com/playlist?list=PLg7s6cbtAD15G8lNyoaYDuKZSKyJrgwB-)
- [GitHub Hello World](https://guides.github.com/activities/hello-world/)
- [Git Immersion](http://gitimmersion.com/index.html)
- [How to Use Git and GitHub](https://www.udacity.com/course/how-to-use-git-and-github--ud775)
- How to not f-up your local files with Git [part1](https://medium.com/@francesco.agnoletto/how-to-not-f-up-your-local-files-with-git-part-1-e0756c88fd3c), [part2](https://medium.com/@francesco.agnoletto/how-to-not-f-up-your-local-files-with-git-part-2-fc4e243be02a) and [part 3](https://medium.com/chingu/how-to-not-f-up-your-local-files-with-git-part-3-bf03b27b6e64)

## What development environment should I be using?
* Pick your favorite editor, write all your code on your own machine in that editor
* Save all your code to GitHub
* Publish all your projects to the web  - using surge.sh, github pages, heroku etc
* Avoid codepen.
* Avoid cloud 9 or any other "just code it on the web so you don't have to learn how to code on your own machine" site.
* Whenever you are doing a "Clone this" project - use only  assets you create yourself or that have copyrights which would allow you to use them.
* Develop the habit of giving attribution for everything you use that was the product of someone else's effort.

## How should I approach the items in the guides?
### Power up your learning - make every minute count 
* When you're working through a book, type out the example code and do all the exercises.
* When you're working through a course, do all the assignments.
* When you're building a Project, include a build process (like [gulp](http://gulpjs.com/)), include at least 5 automated tests ([Karma](https://karma-runner.github.io/1.0/index.html), [mocha](https://mochajs.org/), sinon, chai, jasmine, tape, whatever works for you), include a README.md file that clearly explains the project, and practice using [meaningful 
commit messages](http://chris.beams.io/posts/git-commit/) 
* Use each project to demonstrate that you can deliver an optimized product. Implement tests (as I mentioned above), use your build process to minimize assets, use a linter (like [ESLint](http://eslint.org/)) on your JavaScript and have some method to your madness when it comes to your css naming conventions (like [BEM](http://getbem.com/introduction/))
* As you learn, take the time to discuss what you're learning with others: write blog posts, spend time actively discussing code and concepts with other developers (of varying skill levels), if you're comfortable with it - produce some helpful videos explaining topics that others might find daunting, and (most importantly) embrace the opportunity to help others one on one. You never know something so thoroughly as when you take the time to deeply consider it and explain it to someone else who might be struggling. Helping others doesn't just benefit them, it benefits you by increasing your understanding and mastery of the topic. Help people - you'll learn a lot in the process - you'll be a better developer for having done it. 

### For each item you should:
* take notes, on a blog, in markdown, wherever, somewhere - not about what you read, or about what the instructor said - about what you learned
* build something - even if it's just a 20 line function that computes something you find interesting
* if you build something, document it and test it as appropriate
* do the exercises, build the projects - fully, not some scaled down halfassery

### For four projects of your choosing
* Seek 1-3 other developers to collaborate on the project
* Coordinate with the team to complete the project
* Build the project out to a full production quality application
* Invite others who are not associated with the team to rigorously test the final product.
* Resolve any legitimate issues found

### Once per month - do two or more of the following:
* Write up a comprehensive blog post or markdown entry in a repository detailing the high points of what you learned that month
* Watch [this video](https://www.youtube.com/watch?v=4NIb9l3imAo) and [this video](https://www.youtube.com/watch?v=Eg5-tdAwclo) - on interviewing
* Read [this](http://steve-yegge.blogspot.co.uk/2007_09_01_archive.html) - on crafting a resume
* Do one lesson from [CUST104: Business Communications](https://learn.saylor.org/course/view.php?id=345)
* Live stream what you're working on for an hour. Or, lend a hand to someone who needs help by screensharing and walking them through it.
* Catch up on industry reading on sites like [Joel on Software](https://www.joelonsoftware.com/), [Coding Horror](https://blog.codinghorror.com/), [CSS Tricks](https://css-tricks.com/), [A List Apart](http://alistapart.com/articles), [UX Myths](http://uxmyths.com/), [JavaScript Weekly](http://javascriptweekly.com/)

## Do you have any hints for success?
* have git commits every week, most of the days of the week
* try to get in one of [@tropicalchancer's cohorts](https://chingu-cohorts.github.io/chingu-directory/) - be active once you're in
* try to pick one to two other languages to use regularly for solving algorithms and implementing projects in addition to JavaScript (good choices would be to pick one of C++, Java or Python and one of Golang or Rust).
* spend 30 minutes a day studying math on Khan Academy

## What should I be studying alongside the guides?
There WILL be math. And, it's important. If the thought frightens you, or bores you, or has you thinking 
"this isn't for me", head to [Khan Academy](https://www.khanacademy.org/) right now, sign up, and start devoting 30 minutes a day. This is an investment that will pay off. I'm not making this up.

## Should I work through a guide in order?
Yes. Skip nothing, even if you think you already know it.
If you need to "double up" for variety, do no more than two items from the guide
simultaneously and don't add a third until you finish one of the two. 
Everything builds on everything else. Plus, if you try to do everything at once, you'll finish nothing - or
end up "accidentally on purpose" skipping early foundational material because it was "too hard" and you moved on 
"just for now" which eventually morphed to "forever".

## How long will this take me?
I don't know? How lazy are you? How much time are you devoting to it?
How often do you plan to decide "this is too hard" and waste a month or more
surfing YouTube for an easier option?

## I'm stuck, what should I do?
* Use the official docs.
* Use MDN
* Train yourself to write the code, not copy paste it.
* Stack overflow should be a resource for ideas, not a crutch to help you avoid writing code yourself.
* [Shay Howe](http://learn.shayhowe.com/) has a good overview of HTML and CSS if you need more than you got in the CS50 and MEAN stack course to feel comfortable with the projects.
* If you're at a loss for how to figure out the design for a page you're building, reference [Google's Material Design documentation](https://material.google.com/). Try to become familar with it by the time you finish the list of resources in this post. It will save you from having shoddy looking pages.

#### If you get lost. If this is too hard.
* Buck up camper - no one said this was easy - it is WORTH IT though.
* Figure it out. Ask for someone to point you in the right direction.
* Don't Quit.
* Don't Panic!

## How do I deploy a frontend project
Here are some resources to help you learn how to use surge.sh, you could also use GitHub Pages or any
other host you want, but figuring that out is up to you.

- [YouTube video by Hiếu Sensei walking through the entire process](https://www.youtube.com/watch?v=W10ckhQ1H7c)
- [YouTube video by David Wells that goes into far more detail](https://www.youtube.com/watch?v=LZA8QVLOinE)
- [Very brief article and video showing how to quickly deploy to surge.sh](http://toolsfortheweb.net/hosting/using-surge-for-free-static-site-hosting/)
- [surge.sh site](https://surge.sh/)

## What sites should I have bookmarked and reference frequently?
* [surge.sh](https://surge.sh/) - deploy your frontend projects here (or use github pages)
* [MDN](https://developer.mozilla.org/en-US/) - look HTML, CSS, and JavaScript stuff up here
* [Heroku](https://dashboard.heroku.com/) - deploy your fullstack projects here (or glitch)
* [Firebase](https://firebase.google.com/) or [mLab](https://mlab.com/) - database hosting
* [GitHub](https://github.com/) - store your code here
* [Material Design](https://material.google.com) - lean on this when you need a structure for creating a minimalistic but awesome looking site
* [Material Palette](https://www.materialpalette.com/) - for selecting color schemes
* [Wirify](https://www.wirify.com/) - for quickly turning a web page into a wireframe so you can see the big picture instead of all the graphics

## I need some extra stuff to do on the side for more practice. Have any ideas?
* sign up for https://www.codingame.com - finish every training challenge up through "very hard", for the hard and very hard challenges, you'll likely need to have worked down the main list in this post to the data structures book
* learn [Sass](http://sass-lang.com/guide)
* Join one of the Chingu cohorts that @tropicalchancer puts together and actively participate on one or more group projects
* Project: Clone [this](https://blackrockdigital.github.io/startbootstrap-creative/)  landing page
* Project: Clone [this](https://blackrockdigital.github.io/startbootstrap-clean-blog/) blog template - note that there are multiple pages
* Project: Clone [this](https://creativemarket.com/ikonome/686585-Material-Resume-Blue/screenshots/#screenshot2) online resume template
* Project: Clone the front page of [this](https://urbanarmorgear.com/) website modifying it to highlight a different product or industry. Make special note of the secondary navigation bar at the top. Implementing that is the highlight of this project.
* Project: Do one of the FCC projects not listed in this guide.
* Goal: Contribute one pull request per month to an open source project of your choosing.

## I really want some more advanced stuff for practice. Have any ideas?
* pick a pet web development project you can code in a week and complete it
* code an android application
* learn golang or rust and complete any of the backend projects from FCC with that language as the backend language
* redo any of the algorithmic type projects you've already completed from the list, in a language other than JavaScript
* pick an open source project from [Code Triage](https://www.codetriage.com/) and contribute to fixing an open issue
* code a flash cards application, for jotting quick notes you can use to quiz yourself later
* hit hackerrank and complete the Project Euler problems


## Are there any additional free resources you'd recommend alongside the materials in the guides?
[OpenStax](https://openstax.org/subjects) - Open Source textbooks on a variety of University level topics, check here if you want a reference math or physics textbook

---

Credits: [P1xt](https://github.com/P1xt)