# Architecture Decision Records (ADR) for Garden Linux

In Garden Linux, we use Architecture Decision Records (ADR) to capture important architectural decisions made about the system. This provides context, clarity, and documentation about the decisions we make.

## Installation

### MacOS
```
brew install adr-tools
```

### Linux

For installation instructions, please refer to the [official installation guide](https://github.com/npryce/adr-tools/blob/master/INSTALL.md).
In short, it is either 
1. https://github.com/npryce/adr-tools/releases download, extract and place `src/` folder in your PATH
2. Same as option 1, but you use git clone instead of downloading the release

## ADRs for past Versions of Garden Linux

ADRs in Garden Linux reflect the current state and decisions of the repository/branch they reside in. Unless otherwise specified, they do not retroactively apply to past versions that are still supported.

## Further Read
For a deeper understanding of the value and context of ADRs, we recommend reading [Documenting Architecture Decisions](https://cognitect.com/blog/2011/11/15/documenting-architecture-decisions) by Michael Nygard.