# Developers Guide

This section provides comprehensive documentation tailored for developers who are looking to contribute to Garden Linux, build custom images, or understand the internals of the system.

## Topics Covered:

### General Development
- [**Contributing**](./contributing.md) - Guidelines and best practices for contributing to the Garden Linux project.
- [**Building an Image**](./build_image.md) - Step-by-step instructions on how to build a Garden Linux image.
- [**Building Packages**](./build_packages.md) - A guide on how to build individual packages for Garden Linux.
- [**Testing an Image**](./test_image.md) - Instructions on how to test a built Garden Linux image.

### Platform-Specific Development
- [**Building for OpenStack**](./build_image_openstack.md) - Specific guidelines for building a Garden Linux image tailored for OpenStack.
- [**VMware OVA**](./vmware-ova.md) - Details on building and using the VMware OVA format for Garden Linux.
