/*******************************
Copyright (c) 2016-2024 Grégoire Angerand

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
**********************************/

#include <yave/meshes/MeshData.h>

namespace yave {

MeshData cube_mesh_data() {
    core::Vector<PackedVertex> vertices = {{{1.000f, -1.000f, 1.000f}, 0x1ff001ff, 0x1ff7ffff, {1.000f, 0.000f}}, {{-1.000f, -1.000f, -1.000f}, 0x1ff001ff, 0x1ff7ffff, {0.000f, 1.000f}}, {{1.000f, -1.000f, -1.000f}, 0x1ff001ff, 0x1ff7ffff, {0.000f, 0.000f}}, {{-1.000f, 1.000f, -1.000f}, 0x1ffffdff, 0x7fdff, {1.000f, 0.000f}}, {{1.000f, 1.000f, 1.000f}, 0x1ffffdff, 0x7fdff, {0.000f, 1.000f}}, {{1.000f, 1.000f, -1.000f}, 0x1ffffdff, 0x7fdff, {0.000f, 0.000f}}, {{1.000f, 1.000f, -1.000f}, 0x3ff7fdff, 0x1ffffdff, {1.000f, 0.000f}}, {{1.000f, -1.000f, 1.000f}, 0x3ff7fdff, 0x1ffffdff, {0.000f, 1.000f}}, {{1.000f, -1.000f, -1.000f}, 0x3ff7fdff, 0x1ffffdff, {0.000f, 0.000f}}, {{1.000f, 1.000f, 1.000f}, 0x1ff7ffff, 0x1ffffdff, {1.000f, 0.000f}}, {{-1.000f, -1.000f, 1.000f}, 0x1ff7ffff, 0x1ffffdff, {0.000f, 1.000f}}, {{1.000f, -1.000f, 1.000f}, 0x1ff7ffff, 0x1ffffdff, {0.000f, 0.000f}}, {{-1.000f, 1.000f, 1.000f}, 0x7fdff, 0x1ffffdff, {1.000f, 0.000f}}, {{-1.000f, -1.000f, -1.000f}, 0x7fdff, 0x1ffffdff, {0.000f, 1.000f}}, {{-1.000f, -1.000f, 1.000f}, 0x7fdff, 0x1ffffdff, {0.000f, 0.000f}}, {{1.000f, -1.000f, -1.000f}, 0x1ff7fc00, 0x1ff001ff, {1.000f, 0.000f}}, {{-1.000f, 1.000f, -1.000f}, 0x1ff7fc00, 0x1ff001ff, {0.000f, 1.000f}}, {{1.000f, 1.000f, -1.000f}, 0x1ff7fc00, 0x1ff001ff, {0.000f, 0.000f}}, {{-1.000f, -1.000f, 1.000f}, 0x1ff001ff, 0x1ff7ffff, {1.000f, 1.000f}}, {{-1.000f, 1.000f, 1.000f}, 0x1ffffdff, 0x7fdff, {1.000f, 1.000f}}, {{1.000f, 1.000f, 1.000f}, 0x3ff7fdff, 0x1ffffdff, {1.000f, 1.000f}}, {{-1.000f, 1.000f, 1.000f}, 0x1ff7ffff, 0x1ffffdff, {1.000f, 1.000f}}, {{-1.000f, 1.000f, -1.000f}, 0x7fdff, 0x1ffffdff, {1.000f, 1.000f}}, {{-1.000f, -1.000f, -1.000f}, 0x1ff7fc00, 0x1ff001ff, {1.000f, 1.000f}}};
    core::Vector<IndexedTriangle> triangles = {{0, 1, 2}, {0, 18, 1}, {3, 4, 5}, {3, 19, 4}, {6, 7, 8}, {6, 20, 7}, {9, 10, 11}, {9, 21, 10}, {12, 13, 14}, {12, 22, 13}, {15, 16, 17}, {15, 23, 16}};
    return MeshData(vertices, triangles);
}

MeshData cone_mesh_data() {
    core::Vector<PackedVertex> vertices = {{{0.098f, 1.000f, 0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.985f, 0.703f}}, {{-0.490f, 1.000f, 0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.797f, 0.985f}}, {{-0.098f, 1.000f, -0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.515f, 0.797f}}, {{0.490f, 1.000f, -0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.703f, 0.515f}}, {{0.500f, 1.000f, 0.000f}, 0x1ffffdff, 0x1ff7fc00, {0.750f, 0.510f}}, {{0.490f, 1.000f, 0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.797f, 0.515f}}, {{0.490f, 1.000f, 0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.797f, 0.515f}}, {{0.462f, 1.000f, 0.191f}, 0x1ffffdff, 0x1ff7fc00, {0.842f, 0.528f}}, {{0.416f, 1.000f, 0.278f}, 0x1ffffdff, 0x1ff7fc00, {0.883f, 0.550f}}, {{0.416f, 1.000f, 0.278f}, 0x1ffffdff, 0x1ff7fc00, {0.883f, 0.550f}}, {{0.354f, 1.000f, 0.354f}, 0x1ffffdff, 0x1ff7fc00, {0.920f, 0.580f}}, {{0.278f, 1.000f, 0.416f}, 0x1ffffdff, 0x1ff7fc00, {0.950f, 0.617f}}, {{0.278f, 1.000f, 0.416f}, 0x1ffffdff, 0x1ff7fc00, {0.950f, 0.617f}}, {{0.191f, 1.000f, 0.462f}, 0x1ffffdff, 0x1ff7fc00, {0.972f, 0.658f}}, {{0.416f, 1.000f, 0.278f}, 0x1ffffdff, 0x1ff7fc00, {0.883f, 0.550f}}, {{0.191f, 1.000f, 0.462f}, 0x1ffffdff, 0x1ff7fc00, {0.972f, 0.658f}}, {{0.098f, 1.000f, 0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.985f, 0.703f}}, {{0.416f, 1.000f, 0.278f}, 0x1ffffdff, 0x1ff7fc00, {0.883f, 0.550f}}, {{0.098f, 1.000f, 0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.985f, 0.703f}}, {{0.000f, 1.000f, 0.500f}, 0x1ffffdff, 0x1ff7fc00, {0.990f, 0.750f}}, {{-0.098f, 1.000f, 0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.985f, 0.797f}}, {{-0.098f, 1.000f, 0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.985f, 0.797f}}, {{-0.191f, 1.000f, 0.462f}, 0x1ffffdff, 0x1ff7fc00, {0.972f, 0.842f}}, {{0.098f, 1.000f, 0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.985f, 0.703f}}, {{-0.191f, 1.000f, 0.462f}, 0x1ffffdff, 0x1ff7fc00, {0.972f, 0.842f}}, {{-0.278f, 1.000f, 0.416f}, 0x1ffffdff, 0x1ff7fc00, {0.950f, 0.883f}}, {{0.098f, 1.000f, 0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.985f, 0.703f}}, {{-0.278f, 1.000f, 0.416f}, 0x1ffffdff, 0x1ff7fc00, {0.950f, 0.883f}}, {{-0.354f, 1.000f, 0.354f}, 0x1ffffdff, 0x1ff7fc00, {0.920f, 0.920f}}, {{-0.490f, 1.000f, 0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.797f, 0.985f}}, {{-0.354f, 1.000f, 0.354f}, 0x1ffffdff, 0x1ff7fc00, {0.920f, 0.920f}}, {{-0.416f, 1.000f, 0.278f}, 0x1ffffdff, 0x1ff7fc00, {0.883f, 0.950f}}, {{-0.490f, 1.000f, 0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.797f, 0.985f}}, {{-0.416f, 1.000f, 0.278f}, 0x1ffffdff, 0x1ff7fc00, {0.883f, 0.950f}}, {{-0.462f, 1.000f, 0.191f}, 0x1ffffdff, 0x1ff7fc00, {0.842f, 0.972f}}, {{-0.490f, 1.000f, 0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.797f, 0.985f}}, {{-0.490f, 1.000f, 0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.797f, 0.985f}}, {{-0.500f, 1.000f, 0.000f}, 0x1ffffdff, 0x1ff7fc00, {0.750f, 0.990f}}, {{-0.490f, 1.000f, -0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.703f, 0.985f}}, {{-0.490f, 1.000f, -0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.703f, 0.985f}}, {{-0.462f, 1.000f, -0.191f}, 0x1ffffdff, 0x1ff7fc00, {0.658f, 0.972f}}, {{-0.416f, 1.000f, -0.278f}, 0x1ffffdff, 0x1ff7fc00, {0.617f, 0.950f}}, {{-0.416f, 1.000f, -0.278f}, 0x1ffffdff, 0x1ff7fc00, {0.617f, 0.950f}}, {{-0.354f, 1.000f, -0.354f}, 0x1ffffdff, 0x1ff7fc00, {0.580f, 0.920f}}, {{-0.278f, 1.000f, -0.416f}, 0x1ffffdff, 0x1ff7fc00, {0.550f, 0.883f}}, {{-0.278f, 1.000f, -0.416f}, 0x1ffffdff, 0x1ff7fc00, {0.550f, 0.883f}}, {{-0.191f, 1.000f, -0.462f}, 0x1ffffdff, 0x1ff7fc00, {0.528f, 0.842f}}, {{-0.098f, 1.000f, -0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.515f, 0.797f}}, {{-0.098f, 1.000f, -0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.515f, 0.797f}}, {{0.000f, 1.000f, -0.500f}, 0x1ffffdff, 0x1ff7fc00, {0.510f, 0.750f}}, {{0.098f, 1.000f, -0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.515f, 0.703f}}, {{0.098f, 1.000f, -0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.515f, 0.703f}}, {{0.191f, 1.000f, -0.462f}, 0x1ffffdff, 0x1ff7fc00, {0.528f, 0.658f}}, {{0.278f, 1.000f, -0.416f}, 0x1ffffdff, 0x1ff7fc00, {0.550f, 0.617f}}, {{0.278f, 1.000f, -0.416f}, 0x1ffffdff, 0x1ff7fc00, {0.550f, 0.617f}}, {{0.354f, 1.000f, -0.354f}, 0x1ffffdff, 0x1ff7fc00, {0.580f, 0.580f}}, {{0.490f, 1.000f, -0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.703f, 0.515f}}, {{0.354f, 1.000f, -0.354f}, 0x1ffffdff, 0x1ff7fc00, {0.580f, 0.580f}}, {{0.416f, 1.000f, -0.278f}, 0x1ffffdff, 0x1ff7fc00, {0.617f, 0.550f}}, {{0.490f, 1.000f, -0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.703f, 0.515f}}, {{0.416f, 1.000f, -0.278f}, 0x1ffffdff, 0x1ff7fc00, {0.617f, 0.550f}}, {{0.462f, 1.000f, -0.191f}, 0x1ffffdff, 0x1ff7fc00, {0.658f, 0.528f}}, {{0.490f, 1.000f, -0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.703f, 0.515f}}, {{0.490f, 1.000f, -0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.703f, 0.515f}}, {{0.490f, 1.000f, 0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.797f, 0.515f}}, {{0.416f, 1.000f, 0.278f}, 0x1ffffdff, 0x1ff7fc00, {0.883f, 0.550f}}, {{-0.490f, 1.000f, 0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.797f, 0.985f}}, {{-0.490f, 1.000f, -0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.703f, 0.985f}}, {{-0.098f, 1.000f, -0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.515f, 0.797f}}, {{-0.490f, 1.000f, -0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.703f, 0.985f}}, {{-0.416f, 1.000f, -0.278f}, 0x1ffffdff, 0x1ff7fc00, {0.617f, 0.950f}}, {{-0.098f, 1.000f, -0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.515f, 0.797f}}, {{-0.416f, 1.000f, -0.278f}, 0x1ffffdff, 0x1ff7fc00, {0.617f, 0.950f}}, {{-0.278f, 1.000f, -0.416f}, 0x1ffffdff, 0x1ff7fc00, {0.550f, 0.883f}}, {{-0.098f, 1.000f, -0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.515f, 0.797f}}, {{-0.098f, 1.000f, -0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.515f, 0.797f}}, {{0.098f, 1.000f, -0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.515f, 0.703f}}, {{0.490f, 1.000f, -0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.703f, 0.515f}}, {{0.098f, 1.000f, -0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.515f, 0.703f}}, {{0.278f, 1.000f, -0.416f}, 0x1ffffdff, 0x1ff7fc00, {0.550f, 0.617f}}, {{0.490f, 1.000f, -0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.703f, 0.515f}}, {{0.490f, 1.000f, -0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.703f, 0.515f}}, {{0.416f, 1.000f, 0.278f}, 0x1ffffdff, 0x1ff7fc00, {0.883f, 0.550f}}, {{0.098f, 1.000f, 0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.985f, 0.703f}}, {{0.098f, 1.000f, 0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.985f, 0.703f}}, {{-0.278f, 1.000f, 0.416f}, 0x1ffffdff, 0x1ff7fc00, {0.950f, 0.883f}}, {{-0.490f, 1.000f, 0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.797f, 0.985f}}, {{0.490f, 1.000f, -0.098f}, 0x1ffffdff, 0x1ff7fc00, {0.703f, 0.515f}}, {{0.098f, 1.000f, 0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.985f, 0.703f}}, {{-0.098f, 1.000f, -0.490f}, 0x1ffffdff, 0x1ff7fc00, {0.515f, 0.797f}}, {{0.500f, 1.000f, 0.000f}, 0x3b9c01ff, 0x1ff7ffff, {0.250f, 0.510f}}, {{0.000f, 0.000f, 0.000f}, 0x1ff001ff, 0x1ff7ffff, {0.250f, 0.750f}}, {{0.490f, 1.000f, 0.098f}, 0x3b1c0255, 0x1ffad3dd, {0.297f, 0.515f}}, {{0.462f, 1.000f, 0.191f}, 0x397c02a8, 0x1ffccb98, {0.342f, 0.528f}}, {{0.416f, 1.000f, 0.278f}, 0x36ec02f5, 0x1ffde757, {0.383f, 0.550f}}, {{0.354f, 1.000f, 0.354f}, 0x338c0338, 0x1ffe8328, {0.420f, 0.580f}}, {{0.278f, 1.000f, 0.416f}, 0x2f5c036e, 0x1ffed707, {0.450f, 0.617f}}, {{0.191f, 1.000f, 0.462f}, 0x2a8c0397, 0x1fff06f2, {0.472f, 0.658f}}, {{0.098f, 1.000f, 0.490f}, 0x255c03b1, 0x1fff1ee7, {0.485f, 0.703f}}, {{0.000f, 1.000f, 0.500f}, 0x1ffc03b9, 0x1fff22e4, {0.490f, 0.750f}}, {{-0.098f, 1.000f, 0.490f}, 0x1a9c03b1, 0x1fff1ee7, {0.485f, 0.797f}}, {{-0.191f, 1.000f, 0.462f}, 0x156c0397, 0x1fff06f2, {0.472f, 0.842f}}, {{-0.278f, 1.000f, 0.416f}, 0x109c036e, 0x1ffed707, {0.450f, 0.883f}}, {{-0.354f, 1.000f, 0.354f}, 0xc6c0338, 0x1ffe8328, {0.420f, 0.920f}}, {{-0.416f, 1.000f, 0.278f}, 0x90c02f5, 0x1ffde757, {0.383f, 0.950f}}, {{-0.462f, 1.000f, 0.191f}, 0x67c02a8, 0x1ffccb98, {0.342f, 0.972f}}, {{-0.490f, 1.000f, 0.098f}, 0x4dc0255, 0x1ffad3dd, {0.297f, 0.985f}}, {{-0.500f, 1.000f, 0.000f}, 0x45c01ff, 0x1ff7ffff, {0.250f, 0.990f}}, {{-0.490f, 1.000f, -0.098f}, 0x4dc01a9, 0x1ff52bdd, {0.203f, 0.985f}}, {{-0.462f, 1.000f, -0.191f}, 0x67c0156, 0x1ff33398, {0.158f, 0.972f}}, {{-0.416f, 1.000f, -0.278f}, 0x90c0109, 0x1ff21757, {0.117f, 0.950f}}, {{-0.354f, 1.000f, -0.354f}, 0xc6c00c6, 0x1ff17b28, {0.080f, 0.920f}}, {{-0.278f, 1.000f, -0.416f}, 0x109c0090, 0x1ff12707, {0.050f, 0.883f}}, {{-0.191f, 1.000f, -0.462f}, 0x156c0067, 0x1ff0f6f2, {0.028f, 0.842f}}, {{-0.098f, 1.000f, -0.490f}, 0x1a9c004d, 0x1ff0dee7, {0.015f, 0.797f}}, {{0.000f, 1.000f, -0.500f}, 0x1ffc0045, 0x1ff0dae4, {0.010f, 0.750f}}, {{0.098f, 1.000f, -0.490f}, 0x255c004d, 0x1ff0dee7, {0.015f, 0.703f}}, {{0.191f, 1.000f, -0.462f}, 0x2a8c0067, 0x1ff0f6f2, {0.028f, 0.658f}}, {{0.278f, 1.000f, -0.416f}, 0x2f5c0090, 0x1ff12707, {0.050f, 0.617f}}, {{0.354f, 1.000f, -0.354f}, 0x338c00c6, 0x1ff17b28, {0.080f, 0.580f}}, {{0.416f, 1.000f, -0.278f}, 0x36ec0109, 0x1ff21757, {0.117f, 0.550f}}, {{0.462f, 1.000f, -0.191f}, 0x397c0156, 0x1ff33398, {0.158f, 0.528f}}, {{0.490f, 1.000f, -0.098f}, 0x3b1c01a9, 0x1ff52bdd, {0.203f, 0.515f}}};
    core::Vector<IndexedTriangle> triangles = {{1, 0, 2}, {4, 3, 5}, {7, 6, 8}, {10, 9, 11}, {13, 12, 14}, {16, 15, 17},
                                               {19, 18, 20}, {22, 21, 23}, {25, 24, 26}, {28, 27, 29}, {31, 30, 32}, {34, 33, 35},
                                               {37, 36, 38}, {40, 39, 41}, {43, 42, 44}, {46, 45, 47}, {49, 48, 50}, {52, 51, 53},
                                               {55, 54, 56}, {58, 57, 59}, {61, 60, 62}, {64, 63, 65}, {67, 66, 68}, {70, 69, 71},
                                               {73, 72, 74}, {76, 75, 77}, {79, 78, 80}, {82, 81, 83}, {85, 84, 86}, {88, 87, 89},
                                               {91, 90, 92}, {91, 92, 93}, {91, 93, 94}, {91, 94, 95}, {91, 95, 96}, {91, 96, 97},
                                               {91, 97, 98}, {91, 98, 99}, {91, 99, 100}, {91, 100, 101}, {91, 101, 102}, {91, 102, 103},
                                               {91, 103, 104}, {91, 104, 105}, {91, 105, 106}, {91, 106, 107}, {91, 107, 108}, {91, 108, 109},
                                               {91, 109, 110}, {91, 110, 111}, {91, 111, 112}, {91, 112, 113}, {91, 113, 114}, {91, 114, 115},
                                               {91, 115, 116}, {91, 116, 117}, {91, 117, 118}, {91, 118, 119}, {91, 119, 120}, {91, 120, 121},
                                               {91, 121, 122}, {91, 122, 90}};
    return MeshData(vertices, triangles);
}

MeshData simple_sphere_mesh_data() {
    core::Vector<PackedVertex> vertices = {{{0.000f, -1.000f, 0.000f}, 0x1ff001ff, 0x197fe9d, {0.818f, 0.000f}}, {{0.425f, -0.851f, 0.309f}, 0x2d81329d, 0x2779ac2, {0.773f, 0.079f}}, {{-0.162f, -0.851f, 0.500f}, 0x1ac132ff, 0xe86276, {0.864f, 0.079f}}, {{0.724f, -0.447f, 0.526f}, 0x37146b0c, 0xd27ff9d, {0.727f, 0.157f}}, {{0.425f, -0.851f, 0.309f}, 0x2d81329d, 0x1d7863fc, {0.682f, 0.079f}}, {{0.851f, -0.526f, 0.000f}, 0x3b23c9ff, 0x1ff7ffff, {0.636f, 0.157f}}, {{0.000f, -1.000f, 0.000f}, 0x1ff001ff, 0xd27fc61, {0.091f, 0.000f}}, {{-0.162f, -0.851f, 0.500f}, 0x1ac132ff, 0xb37987a, {0.045f, 0.079f}}, {{-0.526f, -0.851f, 0.000f}, 0xf2131ff, 0xf48604b, {0.136f, 0.079f}}, {{0.000f, -1.000f, 0.000f}, 0x1ff001ff, 0x32c7fc61, {0.273f, 0.000f}}, {{-0.526f, -0.851f, 0.000f}, 0xf2131ff, 0x30a7984b, {0.227f, 0.079f}}, {{-0.162f, -0.851f, -0.500f}, 0x1ac130ff, 0x34b8607a, {0.318f, 0.079f}}, {{0.000f, -1.000f, 0.000f}, 0x1ff001ff, 0x3e57fe9d, {0.455f, 0.000f}}, {{-0.162f, -0.851f, -0.500f}, 0x1ac130ff, 0x3f079a76, {0.409f, 0.079f}}, {{0.425f, -0.851f, -0.309f}, 0x2d813161, 0x3d7862c2, {0.500f, 0.079f}}, {{0.951f, 0.000f, 0.309f}, 0x3e57fe9d, 0x161867e5, {0.682f, 0.236f}}, {{-0.276f, -0.447f, 0.851f}, 0x17246bb2, 0x38c5e4, {0.909f, 0.157f}}, {{0.263f, -0.526f, 0.809f}, 0x2863cb9d, 0x197fe9d, {0.818f, 0.157f}}, {{0.000f, 0.000f, 1.000f}, 0x1ff7ffff, 0x865ff, {0.864f, 0.236f}}, {{-0.894f, -0.447f, 0.000f}, 0x36469ff, 0x1ff7fc00, {0.182f, 0.157f}}, {{-0.688f, -0.526f, 0.500f}, 0x9f3caff, 0xd27fc61, {0.091f, 0.157f}}, {{-0.951f, 0.000f, 0.309f}, 0x197fe9d, 0x16186419, {0.136f, 0.236f}}, {{-0.276f, -0.447f, -0.851f}, 0x1724684c, 0x3e57fd61, {0.364f, 0.157f}}, {{-0.688f, -0.526f, -0.500f}, 0x9f3c8ff, 0x32c7fc61, {0.273f, 0.157f}}, {{-0.588f, 0.000f, -0.809f}, 0xd27fc61, 0x39c864d3, {0.318f, 0.236f}}, {{0.724f, -0.447f, -0.526f}, 0x371468f2, 0x32c7ff9d, {0.545f, 0.157f}}, {{0.263f, -0.526f, -0.809f}, 0x2863c861, 0x3e57fe9d, {0.455f, 0.157f}}, {{0.588f, 0.000f, -0.809f}, 0x32c7fc61, 0x39c8672b, {0.500f, 0.236f}}, {{0.588f, 0.000f, 0.809f}, 0x32c7ff9d, 0x627972b, {0.773f, 0.236f}}, {{-0.588f, 0.000f, 0.809f}, 0xd27ff9d, 0x277993c, {0.955f, 0.236f}}, {{-0.951f, 0.000f, -0.309f}, 0x197fd61, 0x29d79419, {0.227f, 0.236f}}, {{0.000f, 0.000f, -1.000f}, 0x1ff7fc00, 0x3fe795ff, {0.409f, 0.236f}}, {{0.951f, 0.000f, -0.309f}, 0x3e57fd61, 0x29d797e5, {0.591f, 0.236f}}, {{0.276f, 0.447f, 0.851f}, 0x28cb93b2, 0x197fe9d, {0.818f, 0.315f}}, {{0.688f, 0.526f, 0.500f}, 0x35fc32ff, 0xd27ff9d, {0.727f, 0.315f}}, {{0.162f, 0.851f, 0.500f}, 0x252ecaff, 0xb379b84, {0.773f, 0.394f}}, {{-0.724f, 0.447f, 0.526f}, 0x8db930c, 0x506d4f6, {1.000f, 0.315f}}, {{-0.263f, 0.526f, 0.809f}, 0x178c339d, 0x197fd61, {0.909f, 0.315f}}, {{-0.425f, 0.851f, 0.309f}, 0x126eca9d, 0x277993c, {0.955f, 0.394f}}, {{-0.724f, 0.447f, -0.526f}, 0x8db90f2, 0x32c7fc61, {0.273f, 0.315f}}, {{-0.851f, 0.526f, 0.000f}, 0x4cc31ff, 0x1ff7fc00, {0.182f, 0.315f}}, {{-0.425f, 0.851f, -0.309f}, 0x126ec961, 0x22779802, {0.227f, 0.394f}}, {{0.276f, 0.447f, -0.851f}, 0x28cb904c, 0x3e57fe9d, {0.455f, 0.315f}}, {{-0.263f, 0.526f, -0.809f}, 0x178c3061, 0x3e57fd61, {0.364f, 0.315f}}, {{0.162f, 0.851f, -0.500f}, 0x252ec8ff, 0x3f079988, {0.409f, 0.394f}}, {{0.894f, 0.447f, 0.000f}, 0x3c8b91ff, 0x1ff7ffff, {0.636f, 0.315f}}, {{0.688f, 0.526f, -0.500f}, 0x35fc30ff, 0x32c7ff9d, {0.545f, 0.315f}}, {{0.526f, 0.851f, 0.000f}, 0x30cec9ff, 0x30a79bb3, {0.591f, 0.394f}}, {{0.162f, 0.851f, -0.500f}, 0x252ec8ff, 0x34b86384, {0.500f, 0.394f}}, {{0.000f, 1.000f, 0.000f}, 0x1ffffdff, 0x32c7ff9d, {0.545f, 0.472f}}, {{-0.425f, 0.851f, -0.309f}, 0x126ec961, 0x3d78613c, {0.318f, 0.394f}}, {{0.000f, 1.000f, 0.000f}, 0x1ffffdff, 0x3e57fd61, {0.364f, 0.472f}}, {{-0.425f, 0.851f, 0.309f}, 0x126eca9d, 0x1d786002, {0.136f, 0.394f}}, {{0.000f, 1.000f, 0.000f}, 0x1ffffdff, 0x1ff7fc00, {0.182f, 0.472f}}, {{-0.724f, 0.447f, 0.526f}, 0x8db930c, 0x1488c424, {0.091f, 0.315f}}, {{0.162f, 0.851f, 0.500f}, 0x252ecaff, 0xe86188, {0.864f, 0.394f}}, {{0.000f, 1.000f, 0.000f}, 0x1ffffdff, 0x197fd61, {0.909f, 0.472f}}, {{0.526f, 0.851f, 0.000f}, 0x30cec9ff, 0xf4863b3, {0.682f, 0.394f}}, {{0.000f, 1.000f, 0.000f}, 0x1ffffdff, 0xd27ff9d, {0.727f, 0.472f}}, {{-0.588f, 0.000f, 0.809f}, 0xd27ff9d, 0xb37987a, {0.045f, 0.236f}}, {{-0.276f, -0.447f, 0.851f}, 0x17246bb2, 0x7e6d4b7, {0.000f, 0.157f}}, {{0.425f, -0.851f, -0.309f}, 0x2d813161, 0x22779bfc, {0.591f, 0.079f}}, {{0.000f, -1.000f, 0.000f}, 0x1ff001ff, 0x1ff7ffff, {0.636f, 0.000f}}};
    core::Vector<IndexedTriangle> triangles = {{0, 1, 2}, {2, 1, 17}, {1, 3, 17}, {2, 17, 16}, {16, 17, 18}, {18, 17, 28}, {17, 3, 28},
                                               {3, 4, 5}, {3, 5, 15}, {3, 15, 28}, {28, 34, 33}, {28, 15, 34}, {18, 28, 33}, {15, 45, 34},
                                               {15, 32, 45}, {15, 5, 32}, {5, 25, 32}, {5, 61, 25}, {5, 4, 61}, {4, 62, 61}, {25, 26, 27},
                                               {25, 27, 32}, {14, 26, 25}, {32, 46, 45}, {32, 27, 46}, {27, 42, 46}, {27, 31, 42}, {27, 26, 31},
                                               {26, 22, 31}, {14, 13, 26}, {13, 22, 26}, {12, 13, 14}, {22, 23, 24}, {22, 24, 31}, {11, 23, 22},
                                               {31, 43, 42}, {31, 24, 43}, {24, 39, 43}, {24, 30, 39}, {24, 23, 30}, {23, 19, 30}, {11, 10, 23},
                                               {10, 19, 23}, {9, 10, 11}, {19, 20, 21}, {19, 21, 30}, {8, 20, 19}, {30, 40, 39}, {30, 21, 40},
                                               {21, 54, 40}, {21, 59, 54}, {21, 20, 59}, {20, 60, 59}, {8, 7, 20}, {7, 60, 20}, {6, 7, 8},
                                               {40, 54, 52}, {39, 40, 41}, {41, 40, 52}, {41, 52, 53}, {43, 39, 50}, {42, 43, 44}, {44, 43, 50},
                                               {44, 50, 51}, {46, 42, 48}, {45, 46, 47}, {47, 46, 48}, {47, 48, 49}, {34, 45, 57}, {33, 34, 35},
                                               {35, 34, 57}, {35, 57, 58}, {37, 33, 55}, {18, 33, 37}, {36, 37, 38}, {38, 37, 55}, {29, 37, 36},
                                               {29, 18, 37}, {38, 55, 56}, {16, 18, 29}};
    return MeshData(vertices, triangles);
}

MeshData sphere_mesh_data() {
    core::Vector<PackedVertex> vertices = {{{0.000f, 0.000f, -1.000f}, 0x1ff7fc00, 0x19585ff, {0.818f, 0.000f}}, {{0.203f, -0.148f, -0.968f}, 0x26b6c411, 0x2553db3, {0.795f, 0.039f}}, {{-0.078f, -0.239f, -0.968f}, 0x1d660011, 0x185de4b, {0.841f, 0.039f}}, {{0.724f, -0.526f, -0.447f}, 0x3713c91a, 0xec14e39, {0.727f, 0.157f}}, {{0.610f, -0.443f, -0.658f}, 0x334478ab, 0x1520d291, {0.705f, 0.118f}}, {{0.813f, -0.295f, -0.502f}, 0x3a05b4fd, 0x1830564c, {0.682f, 0.157f}}, {{0.000f, 0.000f, -1.000f}, 0x1ff7fc00, 0xd2e75ff, {0.091f, 0.000f}}, {{-0.078f, -0.239f, -0.968f}, 0x1d660011, 0xc4e2db3, {0.068f, 0.039f}}, {{-0.251f, 0.000f, -0.968f}, 0x1797fc11, 0xe7e924b, {0.114f, 0.039f}}, {{0.000f, 0.000f, -1.000f}, 0x1ff7fc00, 0x32ce75ff, {0.273f, 0.000f}}, {{-0.251f, 0.000f, -0.968f}, 0x1797fc11, 0x317e91b3, {0.250f, 0.039f}}, {{-0.078f, 0.239f, -0.968f}, 0x1d69f811, 0x33ae2e4b, {0.295f, 0.039f}}, {{0.000f, 0.000f, -1.000f}, 0x1ff7fc00, 0x3e5585ff, {0.455f, 0.000f}}, {{-0.078f, 0.239f, -0.968f}, 0x1d69f811, 0x3e65ddb3, {0.432f, 0.039f}}, {{0.203f, 0.148f, -0.968f}, 0x26b93411, 0x3d953e4b, {0.477f, 0.039f}}, {{0.861f, -0.443f, -0.251f}, 0x3b947983, 0x1230d22d, {0.705f, 0.197f}}, {{-0.276f, -0.851f, -0.447f}, 0x1721311a, 0x15a4618, {0.909f, 0.157f}}, {{-0.030f, -0.864f, -0.502f}, 0x1f5114fd, 0x677a4c, {0.864f, 0.157f}}, {{-0.155f, -0.955f, -0.251f}, 0x1b205583, 0x690e2d, {0.886f, 0.197f}}, {{-0.894f, 0.000f, -0.447f}, 0x367fd1a, 0x1f3ffa18, {0.182f, 0.157f}}, {{-0.831f, -0.239f, -0.502f}, 0x58600fd, 0x143f564c, {0.136f, 0.157f}}, {{-0.957f, -0.148f, -0.251f}, 0x156c583, 0x1a3fd22d, {0.159f, 0.197f}}, {{-0.276f, 0.851f, -0.447f}, 0x172ec91a, 0x3e1aa218, {0.364f, 0.157f}}, {{-0.484f, 0.717f, -0.502f}, 0x103da8fd, 0x384d0a4c, {0.318f, 0.157f}}, {{-0.436f, 0.864f, -0.251f}, 0x11dee583, 0x3bfbc62d, {0.341f, 0.197f}}, {{0.724f, 0.526f, -0.447f}, 0x371c311a, 0x3351a618, {0.545f, 0.157f}}, {{0.532f, 0.682f, -0.502f}, 0x30bd78fd, 0x3ab3c64c, {0.500f, 0.157f}}, {{0.687f, 0.682f, -0.251f}, 0x35dd7983, 0x3702822d, {0.523f, 0.197f}}, {{0.687f, -0.682f, -0.251f}, 0x35d28183, 0x9126de5, {0.750f, 0.197f}}, {{-0.436f, -0.864f, -0.251f}, 0x11d11583, 0x3bbb5e5, {0.932f, 0.197f}}, {{-0.957f, 0.148f, -0.251f}, 0x1593583, 0x256fd9e5, {0.205f, 0.197f}}, {{-0.155f, 0.955f, -0.251f}, 0x1b2fa583, 0x3f9921e5, {0.386f, 0.197f}}, {{0.861f, 0.443f, -0.251f}, 0x3b9b8183, 0x2e00d5e5, {0.568f, 0.197f}}, {{0.276f, -0.851f, 0.447f}, 0x28c132e4, 0x25519c5, {0.818f, 0.315f}}, {{0.484f, -0.717f, 0.502f}, 0x2fb25301, 0x7a2f1b2, {0.773f, 0.315f}}, {{0.233f, -0.717f, 0.658f}, 0x27525353, 0x653c56d, {0.795f, 0.354f}}, {{-0.724f, -0.526f, 0.447f}, 0x8d3cae4, 0xbde21c5, {1.000f, 0.315f}}, {{-0.532f, -0.682f, 0.502f}, 0xf328301, 0x53c35b2, {0.955f, 0.315f}}, {{-0.610f, -0.443f, 0.658f}, 0xca47b53, 0x80cc56d, {0.977f, 0.354f}}, {{-0.724f, 0.526f, 0.447f}, 0x8dc32e4, 0x312eadc5, {0.273f, 0.315f}}, {{-0.813f, 0.295f, 0.502f}, 0x5ea4701, 0x27bfa5b2, {0.227f, 0.315f}}, {{-0.610f, 0.443f, 0.658f}, 0xcab8353, 0x2acf296d, {0.250f, 0.354f}}, {{0.276f, 0.851f, 0.447f}, 0x28cecae4, 0x3eb5f9c5, {0.455f, 0.315f}}, {{0.030f, 0.864f, 0.502f}, 0x209ee701, 0x3f8881b2, {0.409f, 0.315f}}, {{0.233f, 0.717f, 0.658f}, 0x275dab53, 0x3e97a16d, {0.432f, 0.354f}}, {{0.894f, 0.000f, 0.447f}, 0x3c87fee4, 0x21c011c5, {0.636f, 0.315f}}, {{0.831f, 0.239f, 0.502f}, 0x3a69fb01, 0x2bb0a5b2, {0.591f, 0.315f}}, {{0.753f, 0.000f, 0.658f}, 0x37d7ff53, 0x2810996d, {0.614f, 0.354f}}, {{0.251f, 0.000f, 0.968f}, 0x2857ffed, 0x317169b3, {0.568f, 0.433f}}, {{0.078f, 0.239f, 0.968f}, 0x2289fbed, 0x33a1ce4b, {0.523f, 0.433f}}, {{0.000f, 0.000f, 1.000f}, 0x1ff7ffff, 0x32c185ff, {0.545f, 0.472f}}, {{0.526f, 0.000f, 0.851f}, 0x30c7ffb2, 0x2dc11976, {0.591f, 0.394f}}, {{0.362f, 0.263f, 0.894f}, 0x2bba23c6, 0x32c185ff, {0.545f, 0.394f}}, {{0.638f, 0.263f, 0.724f}, 0x342a2373, 0x2fd11dc5, {0.568f, 0.354f}}, {{0.162f, 0.500f, 0.851f}, 0x252bffb2, 0x35e29688, {0.500f, 0.394f}}, {{0.447f, 0.526f, 0.724f}, 0x2e5c2373, 0x35321a39, {0.523f, 0.354f}}, {{0.233f, 0.717f, 0.658f}, 0x275dab53, 0x3913ae9a, {0.477f, 0.354f}}, {{0.688f, 0.500f, 0.526f}, 0x35fbff0c, 0x32c185ff, {0.545f, 0.315f}}, {{0.484f, 0.717f, 0.502f}, 0x2fbdab01, 0x3842f24c, {0.500f, 0.315f}}, {{0.276f, 0.851f, 0.447f}, 0x28cecae4, 0x3b849a8c, {0.455f, 0.315f}}, {{0.078f, 0.239f, 0.968f}, 0x2289fbed, 0x3e6a1db3, {0.386f, 0.433f}}, {{-0.203f, 0.148f, 0.968f}, 0x193937ed, 0x3d9abe4b, {0.341f, 0.433f}}, {{0.000f, 0.000f, 1.000f}, 0x1ff7ffff, 0x3e5a75ff, {0.364f, 0.472f}}, {{0.162f, 0.500f, 0.851f}, 0x252bffb2, 0x3e692576, {0.409f, 0.394f}}, {{-0.138f, 0.425f, 0.894f}, 0x1b7b73c6, 0x3e5a75ff, {0.364f, 0.394f}}, {{-0.053f, 0.688f, 0.724f}, 0x1e1d7373, 0x3f09a1c5, {0.386f, 0.354f}}, {{-0.425f, 0.309f, 0.851f}, 0x126a77b2, 0x3b5b8a88, {0.318f, 0.394f}}, {{-0.362f, 0.588f, 0.724f}, 0x14acb373, 0x3cfb3a39, {0.341f, 0.354f}}, {{-0.610f, 0.443f, 0.658f}, 0xcab8353, 0x382ca29a, {0.295f, 0.354f}}, {{-0.263f, 0.809f, 0.526f}, 0x178e770c, 0x3e5a75ff, {0.364f, 0.315f}}, {{-0.532f, 0.682f, 0.502f}, 0xf3d7b01, 0x3abc364c, {0.318f, 0.315f}}, {{-0.724f, 0.526f, 0.447f}, 0x8dc32e4, 0x356d7e8c, {0.273f, 0.315f}}, {{-0.203f, 0.148f, 0.968f}, 0x193937ed, 0x214fe1b3, {0.205f, 0.433f}}, {{-0.203f, -0.148f, 0.968f}, 0x1936c7ed, 0x1eafe24b, {0.159f, 0.433f}}, {{0.000f, 0.000f, 1.000f}, 0x1ff7ffff, 0x1ffffdff, {0.182f, 0.472f}}, {{-0.425f, 0.309f, 0.851f}, 0x126a77b2, 0x24ff9576, {0.227f, 0.394f}}, {{-0.447f, 0.000f, 0.894f}, 0x1167ffc6, 0x1ffffdff, {0.182f, 0.394f}}, {{-0.671f, 0.162f, 0.724f}, 0xa993b73, 0x235fe1c5, {0.205f, 0.354f}}, {{-0.425f, -0.309f, 0.851f}, 0x126587b2, 0x1aff9688, {0.136f, 0.394f}}, {{-0.671f, -0.162f, 0.724f}, 0xa96c373, 0x1c9fe239, {0.159f, 0.354f}}, {{-0.610f, -0.443f, 0.658f}, 0xca47b53, 0x15cf2a9a, {0.114f, 0.354f}}, {{-0.851f, 0.000f, 0.526f}, 0x4c7ff0c, 0x1ffffdff, {0.182f, 0.315f}}, {{-0.813f, -0.295f, 0.502f}, 0x5e5b701, 0x183fa64c, {0.136f, 0.315f}}, {{-0.724f, -0.526f, 0.447f}, 0x8d3cae4, 0x11aeca8c, {0.091f, 0.315f}}, {{-0.203f, -0.148f, 0.968f}, 0x1936c7ed, 0x25abdb3, {0.932f, 0.433f}}, {{0.078f, -0.239f, 0.968f}, 0x228603ed, 0x18a1e4b, {0.886f, 0.433f}}, {{0.000f, 0.000f, 1.000f}, 0x1ff7ffff, 0x19a75ff, {0.909f, 0.472f}}, {{-0.425f, -0.309f, 0.851f}, 0x126587b2, 0x49b8976, {0.955f, 0.394f}}, {{-0.138f, -0.425f, 0.894f}, 0x1b748bc6, 0x19a75ff, {0.909f, 0.394f}}, {{-0.362f, -0.588f, 0.724f}, 0x14a34b73, 0x2fb39c5, {0.932f, 0.354f}}, {{0.162f, -0.500f, 0.851f}, 0x2523ffb2, 0x1892688, {0.864f, 0.394f}}, {{-0.053f, -0.688f, 0.724f}, 0x1e128b73, 0xe9a239, {0.886f, 0.354f}}, {{0.233f, -0.717f, 0.658f}, 0x27525353, 0x187ca9a, {0.841f, 0.354f}}, {{-0.263f, -0.809f, 0.526f}, 0x1781870c, 0x19a75ff, {0.909f, 0.315f}}, {{0.030f, -0.864f, 0.502f}, 0x20911701, 0x68824c, {0.864f, 0.315f}}, {{0.276f, -0.851f, 0.447f}, 0x28c132e4, 0x1b6b28c, {0.818f, 0.315f}}, {{0.078f, -0.239f, 0.968f}, 0x228603ed, 0xc41cdb3, {0.750f, 0.433f}}, {{0.251f, 0.000f, 0.968f}, 0x2857ffed, 0xe716a4b, {0.705f, 0.433f}}, {{0.000f, 0.000f, 1.000f}, 0x1ff7ffff, 0xd2185ff, {0.727f, 0.472f}}, {{0.162f, -0.500f, 0.851f}, 0x2523ffb2, 0xa029576, {0.773f, 0.394f}}, {{0.362f, -0.263f, 0.894f}, 0x2bb5dbc6, 0xd2185ff, {0.727f, 0.394f}}, {{0.447f, -0.526f, 0.724f}, 0x2e53db73, 0xaa219c5, {0.750f, 0.354f}}, {{0.526f, 0.000f, 0.851f}, 0x30c7ffb2, 0x12211a88, {0.682f, 0.394f}}, {{0.638f, -0.263f, 0.724f}, 0x3425db73, 0x10111e39, {0.705f, 0.354f}}, {{0.753f, 0.000f, 0.658f}, 0x37d7ff53, 0x1740b29a, {0.659f, 0.354f}}, {{0.688f, -0.500f, 0.526f}, 0x35f3ff0c, 0xd2185ff, {0.727f, 0.315f}}, {{0.831f, -0.239f, 0.502f}, 0x3a660301, 0x1430a64c, {0.682f, 0.315f}}, {{0.894f, 0.000f, 0.447f}, 0x3c87fee4, 0x1b80668c, {0.636f, 0.315f}}, {{0.957f, 0.148f, 0.251f}, 0x3e99367b, 0x25b029d1, {0.614f, 0.276f}}, {{0.951f, 0.309f, 0.000f}, 0x3e5a75ff, 0x29d065ec, {0.591f, 0.236f}}, {{0.862f, 0.425f, 0.276f}, 0x3b6b728a, 0x2ea0e5e9, {0.568f, 0.276f}}, {{0.809f, 0.588f, 0.000f}, 0x39dcb204, 0x32c185ff, {0.545f, 0.236f}}, {{0.671f, 0.688f, 0.276f}, 0x359d728a, 0x36624e15, {0.523f, 0.276f}}, {{0.588f, 0.809f, -0.000f}, 0x32ce75ff, 0x39d34a0c, {0.500f, 0.236f}}, {{0.436f, 0.864f, 0.251f}, 0x2e1ee67b, 0x3c143a25, {0.477f, 0.276f}}, {{0.155f, 0.955f, 0.251f}, 0x24cfa67b, 0x3f86edd1, {0.432f, 0.276f}}, {{0.000f, 1.000f, 0.000f}, 0x1ffffdff, 0x3fe7fdec, {0.409f, 0.236f}}, {{-0.138f, 0.951f, 0.276f}, 0x1b4f968a, 0x3f794de9, {0.386f, 0.276f}}, {{-0.309f, 0.951f, -0.000f}, 0x161f9604, 0x3e5a75ff, {0.364f, 0.236f}}, {{-0.447f, 0.851f, 0.276f}, 0x11ded28a, 0x3c8b9215, {0.341f, 0.276f}}, {{-0.588f, 0.809f, -0.000f}, 0xd2e75ff, 0x39dcb20c, {0.318f, 0.236f}}, {{-0.687f, 0.682f, 0.251f}, 0xa1d7a7b, 0x36fd8225, {0.295f, 0.276f}}, {{-0.861f, 0.443f, 0.251f}, 0x45b827b, 0x2dbf29d1, {0.250f, 0.276f}}, {{-0.951f, 0.309f, 0.000f}, 0x19a75ff, 0x29df95ec, {0.227f, 0.236f}}, {{-0.947f, 0.162f, 0.276f}, 0x1993a8a, 0x24bfe1e9, {0.205f, 0.276f}}, {{-1.000f, -0.000f, 0.000f}, 0x7fe04, 0x1ffffdff, {0.182f, 0.236f}}, {{-0.947f, -0.162f, 0.276f}, 0x196c28a, 0x1b3fe215, {0.159f, 0.276f}}, {{-0.951f, -0.309f, -0.000f}, 0x19585ff, 0x161f960c, {0.136f, 0.236f}}, {{-0.861f, -0.443f, 0.251f}, 0x4547a7b, 0x120f2a25, {0.114f, 0.276f}}, {{-0.724f, -0.526f, 0.447f}, 0x8d3cae4, 0xbde21c5, {0.091f, 0.315f}}, {{-0.687f, -0.682f, 0.251f}, 0xa12827b, 0x8ed79d1, {0.977f, 0.276f}}, {{-0.588f, -0.809f, 0.000f}, 0xd2185ff, 0x62cadec, {0.955f, 0.236f}}, {{-0.447f, -0.851f, 0.276f}, 0x11d12a8a, 0x36b91e9, {0.932f, 0.276f}}, {{-0.309f, -0.951f, -0.000f}, 0x16106604, 0x19a75ff, {0.909f, 0.236f}}, {{-0.138f, -0.951f, 0.276f}, 0x1b40668a, 0x794e15, {0.886f, 0.276f}}, {{0.000f, -1.000f, -0.000f}, 0x1ff001ff, 0x7fe0c, {0.864f, 0.236f}}, {{0.155f, -0.955f, 0.251f}, 0x24c0567b, 0x66e625, {0.841f, 0.276f}}, {{0.436f, -0.864f, 0.251f}, 0x2e11167b, 0x3f435d1, {0.795f, 0.276f}}, {{0.588f, -0.809f, 0.000f}, 0x32c185ff, 0x6234dec, {0.773f, 0.236f}}, {{0.671f, -0.688f, 0.276f}, 0x35928a8a, 0x9824de9, {0.750f, 0.276f}}, {{0.809f, -0.588f, -0.000f}, 0x39d34a04, 0xd2185ff, {0.727f, 0.236f}}, {{0.862f, -0.425f, 0.276f}, 0x3b648a8a, 0x1140e615, {0.705f, 0.276f}}, {{0.951f, -0.309f, -0.000f}, 0x3e5585ff, 0x1610660c, {0.682f, 0.236f}}, {{0.957f, -0.148f, 0.251f}, 0x3e96c67b, 0x1a502625, {0.659f, 0.276f}}, {{0.309f, 0.951f, -0.000f}, 0x29df95fa, 0x3e5585ff, {0.455f, 0.236f}}, {{0.447f, 0.851f, -0.276f}, 0x2e1ed174, 0x3c846a15, {0.477f, 0.197f}}, {{0.138f, 0.951f, -0.276f}, 0x24af9574, 0x3f76ade9, {0.432f, 0.197f}}, {{0.263f, 0.809f, -0.526f}, 0x286e74f2, 0x3e5585ff, {0.455f, 0.157f}}, {{-0.030f, 0.864f, -0.502f}, 0x1f5ee4fd, 0x3f8779b2, {0.409f, 0.157f}}, {{-0.809f, 0.588f, -0.000f}, 0x61cb1fa, 0x32ce75ff, {0.273f, 0.236f}}, {{-0.671f, 0.688f, -0.276f}, 0xa5d7174, 0x366dae15, {0.295f, 0.197f}}, {{-0.862f, 0.425f, -0.276f}, 0x48b7174, 0x2eaf15e9, {0.250f, 0.197f}}, {{-0.688f, 0.500f, -0.526f}, 0x9fbfcf2, 0x32ce75ff, {0.273f, 0.157f}}, {{-0.831f, 0.239f, -0.502f}, 0x589f8fd, 0x2bbf55b2, {0.227f, 0.157f}}, {{-0.687f, -0.682f, 0.251f}, 0xa12827b, 0x8ed79d1, {0.068f, 0.276f}}, {{-0.809f, -0.588f, 0.000f}, 0x61349fa, 0xd2e75ff, {0.091f, 0.236f}}, {{-0.862f, -0.425f, -0.276f}, 0x4848974, 0x114f1615, {0.114f, 0.197f}}, {{-0.588f, -0.809f, 0.000f}, 0xd2185ff, 0x62cadec, {0.045f, 0.236f}}, {{-0.671f, -0.688f, -0.276f}, 0xa528974, 0x98dade9, {0.068f, 0.197f}}, {{-0.436f, -0.864f, -0.251f}, 0x11d11583, 0x3bbb5e5, {0.023f, 0.197f}}, {{-0.688f, -0.500f, -0.526f}, 0x9f3fcf2, 0xd2e75ff, {0.091f, 0.157f}}, {{-0.484f, -0.717f, -0.502f}, 0x103250fd, 0x7ad09b2, {0.045f, 0.157f}}, {{-0.276f, -0.851f, -0.447f}, 0x1721311a, 0x15a4618, {0.000f, 0.157f}}, {{0.309f, -0.951f, 0.000f}, 0x29d065fa, 0x19585ff, {0.818f, 0.236f}}, {{0.138f, -0.951f, -0.276f}, 0x24a06574, 0x76ae15, {0.841f, 0.197f}}, {{0.447f, -0.851f, -0.276f}, 0x2e112974, 0x36469e9, {0.795f, 0.197f}}, {{0.263f, -0.809f, -0.526f}, 0x286184f2, 0x19585ff, {0.818f, 0.157f}}, {{0.532f, -0.682f, -0.502f}, 0x30b280fd, 0x533c5b2, {0.773f, 0.157f}}, {{1.000f, 0.000f, 0.000f}, 0x3ff7fdfa, 0x1ff001ff, {0.636f, 0.236f}}, {{0.947f, -0.162f, -0.276f}, 0x3e56c174, 0x1b301a15, {0.659f, 0.197f}}, {{0.947f, 0.162f, -0.276f}, 0x3e593974, 0x24b019e9, {0.614f, 0.197f}}, {{0.851f, 0.000f, -0.526f}, 0x3b27fcf2, 0x1ff001ff, {0.636f, 0.157f}}, {{0.813f, 0.295f, -0.502f}, 0x3a0a44fd, 0x27b055b2, {0.591f, 0.157f}}, {{0.610f, 0.443f, -0.658f}, 0x334b80ab, 0x37e33691, {0.523f, 0.118f}}, {{0.425f, 0.309f, -0.851f}, 0x2d8a744c, 0x3b144e82, {0.500f, 0.079f}}, {{0.362f, 0.588f, -0.724f}, 0x2b4cb08b, 0x3cf4c239, {0.477f, 0.118f}}, {{0.138f, 0.425f, -0.894f}, 0x247b7038, 0x3e5585ff, {0.455f, 0.079f}}, {{0.053f, 0.688f, -0.724f}, 0x21dd708b, 0x3f0659c5, {0.432f, 0.118f}}, {{-0.162f, 0.500f, -0.851f}, 0x1acbfc4c, 0x3e66d576, {0.409f, 0.079f}}, {{-0.233f, 0.717f, -0.658f}, 0x189da8ab, 0x3e683164, {0.386f, 0.118f}}, {{-0.233f, 0.717f, -0.658f}, 0x189da8ab, 0x399c3691, {0.341f, 0.118f}}, {{-0.162f, 0.500f, -0.851f}, 0x1acbfc4c, 0x366d4e82, {0.318f, 0.079f}}, {{-0.447f, 0.526f, -0.724f}, 0x119c208b, 0x354de239, {0.295f, 0.118f}}, {{-0.362f, 0.263f, -0.894f}, 0x143a2038, 0x32ce75ff, {0.273f, 0.079f}}, {{-0.638f, 0.263f, -0.724f}, 0xbca208b, 0x2fdeddc5, {0.250f, 0.118f}}, {{-0.526f, 0.000f, -0.851f}, 0xf27fc4c, 0x2dcee176, {0.227f, 0.079f}}, {{-0.753f, 0.000f, -0.658f}, 0x817fcab, 0x28af4964, {0.205f, 0.118f}}, {{-0.753f, 0.000f, -0.658f}, 0x817fcab, 0x17df6291, {0.159f, 0.118f}}, {{-0.526f, 0.000f, -0.851f}, 0xf27fc4c, 0x12aef682, {0.136f, 0.079f}}, {{-0.638f, -0.263f, -0.724f}, 0xbc5d88b, 0x101ede39, {0.114f, 0.118f}}, {{-0.362f, -0.263f, -0.894f}, 0x1435d838, 0xd2e75ff, {0.091f, 0.079f}}, {{-0.447f, -0.526f, -0.724f}, 0x1193d88b, 0xabde1c5, {0.068f, 0.118f}}, {{-0.162f, -0.500f, -0.851f}, 0x1ac3fc4c, 0xa0d6576, {0.045f, 0.079f}}, {{-0.233f, -0.717f, -0.658f}, 0x189250ab, 0x6dc4d64, {0.023f, 0.118f}}, {{0.610f, 0.443f, -0.658f}, 0x334b80ab, 0x2ac0d16d, {0.568f, 0.118f}}, {{0.671f, 0.162f, -0.724f}, 0x3559388b, 0x237019c7, {0.614f, 0.118f}}, {{0.671f, -0.162f, -0.724f}, 0x3556c08b, 0x1c701a37, {0.659f, 0.118f}}, {{0.425f, 0.309f, -0.851f}, 0x2d8a744c, 0x2590657c, {0.591f, 0.079f}}, {{0.447f, -0.000f, -0.894f}, 0x2e87fc38, 0x1ff001ff, {0.636f, 0.079f}}, {{0.203f, 0.148f, -0.968f}, 0x26b93411, 0x21a019b4, {0.614f, 0.039f}}, {{0.425f, -0.309f, -0.851f}, 0x2d85844c, 0x1a506682, {0.682f, 0.079f}}, {{0.203f, -0.148f, -0.968f}, 0x26b6c411, 0x1e401a4a, {0.659f, 0.039f}}, {{0.000f, 0.000f, -1.000f}, 0x1ff7fc00, 0x1ff001ff, {0.636f, 0.000f}}, {{-0.233f, -0.717f, -0.658f}, 0x189250ab, 0x1585a91, {0.886f, 0.118f}}, {{-0.162f, -0.500f, -0.851f}, 0x1ac3fc4c, 0x156fe82, {0.864f, 0.079f}}, {{0.053f, -0.688f, -0.724f}, 0x21d2888b, 0xe65a39, {0.841f, 0.118f}}, {{0.138f, -0.425f, -0.894f}, 0x24748838, 0x19585ff, {0.818f, 0.079f}}, {{0.362f, -0.588f, -0.724f}, 0x2b43488b, 0x2f4c1c5, {0.795f, 0.118f}}, {{0.425f, -0.309f, -0.851f}, 0x2d85844c, 0x4947176, {0.773f, 0.079f}}, {{0.610f, -0.443f, -0.658f}, 0x334478ab, 0x7c35964, {0.750f, 0.118f}}, {{0.724f, -0.526f, -0.447f}, 0x3713c91a, 0xa827d72, {0.727f, 0.157f}}};
    core::Vector<IndexedTriangle> triangles = {{0, 1, 2}, {2, 1, 206}, {1, 208, 206}, {2, 206, 204}, {204, 206, 205}, {206, 207, 205},
                                               {206, 208, 207}, {208, 209, 207}, {205, 207, 166}, {207, 167, 166}, {207, 209, 167}, {204, 205, 203},
                                               {203, 205, 17}, {205, 166, 17}, {17, 166, 164}, {164, 166, 165}, {166, 167, 165}, {165, 167, 28},
                                               {167, 3, 28}, {209, 210, 167}, {164, 165, 163}, {163, 165, 138}, {165, 28, 138}, {3, 15, 28},
                                               {28, 140, 138}, {28, 15, 140}, {3, 4, 5}, {3, 5, 15}, {15, 142, 140}, {15, 169, 142},
                                               {15, 5, 169}, {138, 140, 139}, {140, 141, 139}, {140, 142, 141}, {142, 143, 141}, {142, 168, 143},
                                               {142, 169, 168}, {169, 170, 168}, {5, 171, 169}, {169, 171, 170}, {143, 168, 108}, {168, 109, 108},
                                               {168, 170, 109}, {141, 143, 106}, {143, 45, 106}, {143, 108, 45}, {108, 46, 45}, {109, 110, 108},
                                               {108, 110, 46}, {32, 111, 109}, {109, 111, 110}, {170, 32, 109}, {110, 57, 46}, {111, 112, 110},
                                               {110, 112, 57}, {45, 46, 47}, {47, 46, 53}, {46, 57, 53}, {53, 57, 55}, {57, 58, 55},
                                               {112, 58, 57}, {111, 113, 112}, {113, 114, 112}, {112, 114, 58}, {55, 58, 56}, {58, 59, 56},
                                               {114, 42, 58}, {114, 115, 42}, {113, 144, 114}, {114, 144, 115}, {42, 43, 44}, {115, 43, 42},
                                               {116, 117, 115}, {115, 117, 43}, {144, 116, 115}, {113, 145, 144}, {145, 146, 144}, {144, 146, 116},
                                               {31, 118, 116}, {116, 118, 117}, {146, 31, 116}, {117, 69, 43}, {118, 119, 117}, {117, 119, 69},
                                               {31, 24, 118}, {24, 120, 118}, {118, 120, 119}, {22, 24, 31}, {146, 148, 31}, {148, 22, 31},
                                               {22, 23, 24}, {24, 150, 120}, {24, 23, 150}, {120, 121, 119}, {120, 149, 121}, {120, 150, 149},
                                               {150, 151, 149}, {23, 152, 150}, {150, 152, 151}, {180, 23, 22}, {180, 182, 23}, {182, 152, 23},
                                               {179, 22, 148}, {178, 179, 177}, {177, 179, 148}, {13, 178, 176}, {176, 178, 177}, {176, 177, 175},
                                               {175, 177, 147}, {177, 148, 147}, {14, 176, 174}, {174, 176, 175}, {14, 13, 176}, {12, 13, 14},
                                               {174, 175, 173}, {173, 175, 26}, {175, 147, 26}, {173, 26, 25}, {25, 26, 27}, {27, 26, 145},
                                               {26, 147, 145}, {25, 27, 32}, {172, 25, 32}, {172, 194, 25}, {32, 27, 111}, {27, 113, 111},
                                               {27, 145, 113}, {145, 147, 146}, {147, 148, 146}, {170, 172, 32}, {171, 172, 170}, {171, 195, 172},
                                               {5, 196, 171}, {171, 196, 195}, {172, 195, 194}, {195, 197, 194}, {196, 198, 195}, {195, 198, 197},
                                               {5, 4, 196}, {4, 200, 196}, {196, 200, 198}, {198, 199, 197}, {200, 201, 198}, {198, 201, 199},
                                               {201, 202, 199}, {152, 153, 151}, {182, 184, 152}, {184, 153, 152}, {151, 153, 30}, {153, 19, 30},
                                               {184, 186, 153}, {186, 19, 153}, {149, 151, 123}, {151, 30, 123}, {19, 21, 30}, {30, 125, 123},
                                               {30, 21, 125}, {19, 20, 21}, {187, 20, 19}, {21, 127, 125}, {21, 156, 127}, {21, 20, 156},
                                               {123, 125, 124}, {125, 126, 124}, {125, 127, 126}, {127, 128, 126}, {127, 155, 128}, {127, 156, 155},
                                               {156, 158, 155}, {20, 160, 156}, {156, 160, 158}, {128, 155, 154}, {155, 157, 154}, {155, 158, 157},
                                               {126, 128, 82}, {128, 129, 82}, {128, 154, 129}, {81, 82, 79}, {79, 82, 80}, {82, 83, 80},
                                               {126, 82, 81}, {77, 79, 76}, {76, 79, 78}, {79, 80, 78}, {77, 81, 79}, {41, 77, 75},
                                               {75, 77, 76}, {41, 40, 77}, {40, 81, 77}, {75, 76, 72}, {72, 76, 73}, {76, 78, 73},
                                               {72, 73, 74}, {124, 81, 40}, {124, 126, 81}, {39, 40, 41}, {122, 40, 39}, {122, 124, 40},
                                               {123, 124, 122}, {121, 122, 39}, {121, 149, 122}, {149, 123, 122}, {121, 39, 70}, {119, 121, 70},
                                               {69, 70, 67}, {67, 70, 68}, {70, 71, 68}, {119, 70, 69}, {43, 69, 65}, {65, 69, 67},
                                               {65, 67, 64}, {64, 67, 66}, {67, 68, 66}, {44, 65, 63}, {63, 65, 64}, {44, 43, 65},
                                               {63, 64, 60}, {60, 64, 61}, {64, 66, 61}, {60, 61, 62}, {158, 159, 157}, {160, 161, 158},
                                               {158, 161, 159}, {161, 162, 159}, {191, 161, 160}, {191, 193, 161}, {193, 162, 161}, {189, 160, 20},
                                               {189, 191, 160}, {190, 191, 189}, {190, 192, 191}, {192, 193, 191}, {188, 189, 187}, {187, 189, 20},
                                               {188, 190, 189}, {8, 190, 188}, {8, 7, 190}, {7, 192, 190}, {6, 7, 8}, {185, 186, 184},
                                               {10, 185, 183}, {183, 185, 184}, {183, 184, 182}, {11, 183, 181}, {181, 183, 182}, {11, 10, 183},
                                               {9, 10, 11}, {181, 182, 180}, {55, 56, 54}, {53, 55, 52}, {52, 55, 54}, {52, 54, 49},
                                               {51, 52, 48}, {48, 52, 49}, {51, 53, 52}, {47, 53, 51}, {48, 49, 50}, {105, 106, 103},
                                               {103, 106, 104}, {106, 107, 104}, {141, 106, 105}, {101, 103, 100}, {100, 103, 102}, {103, 104, 102},
                                               {101, 105, 103}, {35, 101, 99}, {99, 101, 100}, {35, 34, 101}, {34, 105, 101}, {99, 100, 96},
                                               {96, 100, 97}, {100, 102, 97}, {96, 97, 98}, {139, 105, 34}, {139, 141, 105}, {33, 34, 35},
                                               {137, 34, 33}, {137, 139, 34}, {138, 139, 137}, {136, 137, 33}, {136, 163, 137}, {163, 138, 137},
                                               {136, 33, 94}, {135, 136, 134}, {134, 136, 94}, {135, 163, 136}, {135, 164, 163}, {18, 135, 133},
                                               {133, 135, 134}, {18, 164, 135}, {133, 134, 132}, {132, 134, 93}, {134, 94, 93}, {29, 133, 131},
                                               {131, 133, 132}, {29, 18, 133}, {16, 17, 18}, {16, 18, 29}, {18, 17, 164}, {203, 17, 16},
                                               {131, 132, 130}, {130, 132, 37}, {132, 93, 37}, {130, 37, 36}, {36, 37, 38}, {38, 37, 89},
                                               {37, 93, 89}, {38, 89, 87}, {87, 89, 88}, {89, 91, 88}, {89, 93, 91}, {87, 88, 84},
                                               {84, 88, 85}, {88, 90, 85}, {88, 91, 90}, {91, 92, 90}, {93, 94, 91}, {91, 94, 92},
                                               {94, 95, 92}, {84, 85, 86}};
    return MeshData(vertices, triangles);
}

}

