/*******************************
Copyright (c) 2016-2024 Grégoire Angerand

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
**********************************/
#ifndef YAVE_DEVICE_DEVICEPROPERTIES_H
#define YAVE_DEVICE_DEVICEPROPERTIES_H

#include <yave/yave.h>

namespace yave {

struct DeviceProperties {
    u64 non_coherent_atom_size;
    u32 max_uniform_buffer_size;
    u64 uniform_buffer_alignment;
    u64 storage_buffer_alignment;

    u32 max_memory_allocations;

    u32 max_uniform_buffer_desc_array_size;
    u32 max_storage_buffer_desc_array_size;
    u32 max_sampled_image_desc_array_size;
    u32 max_storage_image_desc_array_size;

    u32 max_inline_uniform_size;

    float timestamp_period;


    bool has_raytracing;

    u32 shader_group_handle_size;
    u32 shader_group_handle_size_aligned;
    u32 shader_group_handle_size_base_aligned;
};

}

#endif // YAVE_DEVICE_DEVICEPROPERTIES_H

