/*******************************
Copyright (c) 2016-2024 Grégoire Angerand

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
**********************************/

#ifndef EDITOR_THUMBMAILRENDERER_H
#define EDITOR_THUMBMAILRENDERER_H

#include <editor/editor.h>

#include <yave/graphics/images/ImageView.h>
#include <yave/assets/AssetPtr.h>

#include <y/core/HashMap.h>
#include <y/concurrent/StaticThreadPool.h>
#include <y/concurrent/Mutexed.h>

namespace editor {

class ThumbmailRenderer : NonMovable {

    struct ThumbmailData : NonMovable {
        Texture texture;
        TextureView view;
        GenericAssetPtr asset_ptr;
        // To avoid futures...
        concurrent::DependencyGroup done;
        std::atomic<bool> failed = false;
    };

    public:
        static constexpr usize thumbmail_size = 128;

        ThumbmailRenderer(AssetLoader& loader);

        const TextureView* thumbmail(AssetId id);

        usize cached_thumbmails();

    private:
        std::unique_ptr<ThumbmailData> schedule_render(AssetId id);

        concurrent::Mutexed<core::FlatHashMap<AssetId, std::unique_ptr<ThumbmailData>>> _thumbmails;
        AssetLoader* _loader = nullptr;

        concurrent::WorkerThread _render_thread;
};

}

#endif // EDITOR_THUMBMAILRENDERER_H

