/*******************************
Copyright (c) 2016-2024 Grégoire Angerand

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
**********************************/
#ifndef EDITOR_EDITORRESOURCES_H
#define EDITOR_EDITORRESOURCES_H

#include <editor/editor.h>

#include <yave/graphics/images/Image.h>

namespace editor {

class EditorResources final : NonMovable {
    public:
        enum ComputePrograms {
            DepthAlphaProgram,
            PickingProgram,

            MaxComputePrograms
        };

        enum MaterialTemplates {
            ImGuiMaterialTemplate,
            ImGuiBillBoardMaterialTemplate,

            EngineViewMaterialTemplate,
            SelectionMaterialTemplate,

            MaxMaterialTemplates
        };


        EditorResources();

        // can't default for inclusion reasons
        ~EditorResources();

        const ComputeProgram& operator[](ComputePrograms i) const;
        const MaterialTemplate* operator[](MaterialTemplates i) const;

        void reload();

    private:
        void load_resources();

        std::unique_ptr<ComputeProgram[]> _computes;
        std::unique_ptr<MaterialTemplate[]> _material_templates;

};

}

#endif // EDITOR_CONTEXT_EDITORRESOURCES_H

