# Contributing to the-things-network

First off, thank you for considering contributing to **the-things-network**! We're excited to collaborate with you and appreciate your help in improving the package. This document provides some guidelines and information to help you get started.

## Code of Conduct

Please read and follow our [Code of Conduct](CODE_OF_CONDUCT.md) to ensure that everyone in our community is treated with respect.

## How Can I Contribute?

There are several ways you can contribute to the project:

1. **Bug Reports**: If you find a bug or issue, please create an issue in the GitHub repository with the "bug" label. Provide as much information as possible to help us reproduce the problem.

2. **Feature Requests**: If you have an idea for a new feature or improvement, please create an issue with the "enhancement" label. Provide a clear description of the feature and any supporting details.

3. **Documentation**: Help us improve our documentation by fixing typos, adding examples, or clarifying existing content. Submit a pull request with your changes.

4. **Code Contributions**: You can also contribute directly by implementing new features or fixing bugs. See the next section for more details on how to do this.

### Pull Requests

Here are some steps to get started with contributing code:

1. **Fork the repository**: Click the "Fork" button at the top of the repository page to create your own copy of the project.

2. **Clone your fork**: Clone your forked repository to your local machine using the `git clone` command.

3. **Create a new branch**: Create a new branch for your feature or bug fix. Use a descriptive name for your branch, like `fix-bug-xyz` or `add-feature-abc`.

4. **Make your changes**: Implement your changes on the new branch. Follow the project's coding standards and write tests for your changes, if applicable.

5. **Commit your changes**: Commit your changes using the `git commit` command. Write a clear and concise commit message.

6. **Push your changes**: Push your changes to your forked repository on GitHub using the `git push` command.

7. **Create a pull request**: Open a pull request against the original repository. Provide a clear description of your changes and any relevant context.

8. **Review and revisions**: The maintainers will review your pull request and may request changes or provide feedback. Address any comments and push your updates.

9. **Merge**: Once your pull request is approved, it will be merged into the main branch.

## Development Environment

1. Ensure you have the necessary tools and dependencies installed on your local machine. Refer to the project's [README.md](README.md) for instructions.

2. Run the tests and ensure they pass before submitting your pull request. Check the project's documentation for instructions on how to run the tests.

3. Follow the project's coding style guidelines. If the project uses a linter or formatter, make sure to use it.

## Questions?

If you have any questions or need help with your contributions, feel free to reach out to us by creating an [issue](https://github.com/fuota-io/The-Things-Network-NodeJS-SDK/issues).

Thank you for contributing to **the-things-network**! We're excited to see your contributions and work together to make this project even better.
