<?php
/**
 * Plugin configuration interface
 *
 * @package Email SMTP
 */

require_once 'ProgramFunctions/SendEmail.fnc.php';

// Check the script is called by the right program & plugin is activated.
if ( $_REQUEST['modname'] !== 'School_Setup/Configuration.php'
	|| ! $RosarioPlugins['Email_SMTP']
	|| $_REQUEST['modfunc'] !== 'config' )
{
	$error[] = _( 'You\'re not allowed to use this program!' );

	echo ErrorMessage( $error, 'fatal' );
}

// Note: no need to call ProgramTitle() here!

if ( $_REQUEST['save'] === 'true' )
{
	if ( $_REQUEST['values']['CONFIG']
		&& $_POST['values']
		&& AllowEdit() )
	{
		// Update the CONFIG table.
		$sql = '';

		if ( isset( $_REQUEST['values']['CONFIG'] )
			&& is_array( $_REQUEST['values']['CONFIG'] ) )
		{
			foreach ( (array) $_REQUEST['values']['CONFIG'] as $column => $value )
			{
				if ( $column === 'EMAIL_SMTP_PORT' )
				{
					// Sanitize port (positive int).
					$value = preg_replace( '/[^0-9]/', '', $value );
				}

				$sql .= "UPDATE CONFIG
					SET CONFIG_VALUE='" . $value . "'
					WHERE TITLE='" . $column . "'
					AND SCHOOL_ID IN('" . UserSchool() . "','0');"; // Save for all schools too.
			}
		}

		if ( $sql != '' )
		{
			DBQuery( $sql );

			$note[] = button( 'check' ) . '&nbsp;' . _( 'The plugin configuration has been modified.' );
		}

		unset( $_ROSARIO['Config'] ); // Update Config var.
	}

	if ( filter_var( $_REQUEST['test-email'], FILTER_VALIDATE_EMAIL ) )
	{
		$to = $_REQUEST['test-email'];
		$subject_test = sprintf( dgettext( 'Email_SMTP', 'Test email to %s' ), $to );
		$subject = 'Email SMTP: ' . $subject_test;
		$msg = dgettext( 'Email_SMTP', 'This is a test email generated by the Email SMTP RosarioSIS plugin.' );

		$sent = SendEmail(
			$to,
			$subject,
			$msg
		);

		if ( ! $sent )
		{
			$error[] = $subject_test . ': ' . _( 'Fail' );
		}
		else
		{
			$note[] = $subject_test . ': ' . _( 'Success' );
		}

		// Unset test & redirect URL.
		RedirectURL( 'test-email' );
	}

	if ( function_exists( 'RedirectURL' ) )
	{
		// Unset save & values & redirect URL.
		RedirectURL( 'save', 'values' );
	}
}

if ( empty( $_REQUEST['save'] )
	&& empty( $_REQUEST['remove'] ) )
{
	echo '<form action="Modules.php?modname=' . $_REQUEST['modname'] . '&tab=plugins&modfunc=config&plugin=Email_SMTP&save=true" method="POST">';

	DrawHeader( '', SubmitButton( _( 'Save' ) ) );

	echo ErrorMessage( $note, 'note' );

	echo ErrorMessage( $error, 'error' );

	echo '<br />';

	$school_title = '';

	// If more than 1 school, add its title to table title.
	if ( SchoolInfo( 'SCHOOLS_NB' ) > 1 )
	{
		$school_title = SchoolInfo( 'SHORT_NAME' );

		if ( ! $school_title )
		{
			// No short name, get full title.
			$school_title = SchoolInfo( 'TITLE' );
		}

		$school_title = '(' . $school_title . ')';
	}

	PopTable(
		'header',
		sprintf(
			dgettext( 'Email_SMTP', 'Email SMTP %s' ),
			$school_title
		)
	);

	$tooltip = '<div class="tooltip"><i>' . dgettext(
		'Email_SMTP',
		'If you are sending using an email provider (Gmail, Yahoo, Hotmail, Outlook.com, etc) this setting should be your email address for this account.'
	) . '</i></div>';

	// From email.
	echo '<table class="width-100p"><tr><td>' . TextInput(
		Config( 'EMAIL_SMTP_FROM' ),
		'values[CONFIG][EMAIL_SMTP_FROM]',
		dgettext( 'Email_SMTP', 'From Email' ) . $tooltip,
		'type="email" size="20"',
		false
	) . '</td></tr>';

	$tooltip = '<div class="tooltip"><i>' . sprintf( dgettext(
		'Email_SMTP',
		'You can specify the name that emails should be sent from. If you leave this blank, the emails will be sent from %s.'
	), Config( 'NAME' ) ) . '</i></div>';

	// From name.
	echo '<tr><td>' . TextInput(
		Config( 'EMAIL_SMTP_FROM_NAME' ),
		'values[CONFIG][EMAIL_SMTP_FROM_NAME]',
		dgettext( 'Email_SMTP', 'From Name' ) . $tooltip,
		'size="20" placeholder="' . Config( 'NAME' ) . '"',
		false
	) . '<hr/></td></tr>';

	// Host.
	echo '<tr><td>' . TextInput(
		Config( 'EMAIL_SMTP_HOST' ),
		'values[CONFIG][EMAIL_SMTP_HOST]',
		dgettext( 'Email_SMTP', 'SMTP Host' ),
		'required',
		false
	) . '</td></tr>';

	// Port.
	echo '<tr><td>' . TextInput(
		Config( 'EMAIL_SMTP_PORT' ),
		'values[CONFIG][EMAIL_SMTP_PORT]',
		dgettext( 'Email_SMTP', 'SMTP Port' ),
		'type="number" min="0" required placeholder="587"',
		false
	) . '</td></tr>';

	$encryption_options = array(
		'ssl' => 'SSL',
		'tls' => 'TLS',
	);

	// Encryption.
	echo '<tr><td>' . SelectInput(
		Config( 'EMAIL_SMTP_ENCRYPTION' ),
		'values[CONFIG][EMAIL_SMTP_ENCRYPTION]',
		dgettext( 'Email_SMTP', 'Encryption' ),
		$encryption_options,
		_( 'None' ),
		'',
		false
	) . '</td></tr>';

	// Username.
	echo '<tr><td>' . TextInput(
		Config( 'EMAIL_SMTP_USERNAME' ),
		'values[CONFIG][EMAIL_SMTP_USERNAME]',
		_( 'Username' ),
		'size="20"',
		false
	) . '</td></tr>';

	// Password.
	echo '<tr><td>' . TextInput(
		Config( 'EMAIL_SMTP_PASSWORD' ),
		'values[CONFIG][EMAIL_SMTP_PASSWORD]',
		_( 'Password' ),
		'size="20" type="password"',
		false
	) . '<hr /></td></tr>';

	echo '<tr><td>' . TextInput(
		'',
		'test-email',
		dgettext( 'Email_SMTP', 'Send a test email To' ),
		'type="email" size="20"',
		false
	) . '<br />' . SubmitButton( dgettext( 'Email_SMTP', 'Send Test' ) ) . '</td></tr>';

	echo '</table>';

	PopTable( 'footer' );

	echo '<br /><div class="center">' . SubmitButton( _( 'Save' ) ) . '</div></form>';
}
