# Foundry Zero Open Source Project Contributing Guide

👍🎉 First off, thanks for taking the time to contribute! 🎉👍


The following is a set of guidelines for contributing to LLEF which is hosted in the Foundry Zero organisation on GitHub. These are mostly guidelines, not rules. Use your best judgment, and feel free to propose changes to this document in a pull request.

## Code of Conduct
This project and everyone participating in it is governed by the Code of Conduct. By participating, you are expected to uphold this code. Please report unacceptable behavior to info@foundryzero.co.uk.

## What should I know before I get started?

Take a look at the [README.md](https://github.com/foundryzero/llef/blob/main/README.md) for more information about LLEF.
 
## How Can I Contribute?

### Your First Code Contribution

Unsure where to begin contributing to LLEF? You can start by looking through these `beginner` and `help-wanted` issues:

* [Beginner issues](https://github.com/foundryzero/llef/labels/good%20first%20issue) - issues which should only require a few lines of code, and a test or two.
* [Help wanted issues](https://github.com/foundryzero/llef/labels/help-wanted) - issues which should be a bit more involved than `beginner` issues.

#### Pull Requests

The process described here has several goals:

- Maintain LLEF's quality
- Fix problems that are important to users
- Engage the community in working toward the best possible LLEF

Please follow the [styleguides](https://github.com/foundryzero/llef/blob/main/.CONTRIBUTING/PYTHON%20STYLE.md)

While the prerequisites above must be satisfied prior to having your pull request reviewed, the reviewer(s) may ask you to complete additional design work, tests, or other changes before your pull request can be ultimately accepted.


### Reporting Bugs

#### Before Submitting A Bug Report

Before submitting a bug report, please check to see if the bug has already been raised as an issue by searching [our github issues](https://github.com/foundryzero/llef/labels/bug)

#### How Do I Submit A (Good) Bug Report?

Bugs are tracked as GitHub issues. Please raise your bug as a GitHub issue using our [enhancement template](https://github.com/foundryzero/llef/blob/main/.github/ISSUE_TEMPLATE/BUG%20REPORT.md).

Explain the problem and include additional details to help maintainers reproduce the problem:

* Use a clear and descriptive title for the issue to identify the problem.
* Describe the exact steps which reproduce the problem in as many details as possible.
* Provide specific examples to demonstrate the steps. Include links to files or GitHub projects, or copy/pasteable snippets, which you use in those examples. If you're providing snippets in the issue, use Markdown code blocks.
* Describe the behavior you observed after following the steps and point out what exactly is the problem with that behavior.
* Explain which behavior you expected to see instead and why.

### Suggesting Enhancements

This section guides you through submitting an enhancement suggestion for LLEF, including completely new features and minor improvements to existing functionality. Following these guidelines helps maintainers and the community understand your suggestion 📝 and find related suggestions 🔎.

#### Before Submitting A Feature Request

Before submitting a feature request, please check to see if the bug has already been raised as an issue by searching [our github issues](https://github.com/foundryzero/llef/labels/enhancement)

#### How Do I Submit A (Good) Enhancement Suggestion?

Features are tracked as GitHub issues. Please raise your bug as a GitHub issue using our [bug issue template](https://github.com/foundryzero/llef/blob/main/.github/ISSUE_TEMPLATE/FEATURE%20REQUEST.md).

* **Use a clear and descriptive title** for the issue to identify the suggestion.
* **Provide a step-by-step description of the suggested enhancement** in as many details as possible.
* **Provide specific examples to demonstrate the steps**. Include copy/pasteable snippets which you use in those examples, as [Markdown code blocks](https://help.github.com/articles/markdown-basics/#multiple-lines).
* **Describe the current behavior** and **explain which behavior you would like to see instead** and why.
* **Explain why this enhancement would be useful**
* **Specify the name and version of the OS you're using.**


## Attribution

This contributor guide is based on the [guide](https://github.com/atom/atom/blob/master/.CONTRIBUTING/CONTRIBUTING.md) developed by the Atom project