# fortty 和 M_attr

本节介绍两个 ESC 码终端样式库。

有些控制台是不支持的 ESC 码的，GFortran 和 Intel OneAPI 为我们提供了拓展函数 `isatty`，
利用 `isatty` 来判断控制台是否为 TTY 终端，从而选择为字符添加 ESC 码。

## 使用M_attr输出彩色控制台文本

M_attr仓库（许可证：MIT）：[https://github.com/urbanjost/M_attr][1]

M_attr是urbanjost的开源项目，使用ANSI码escape序列来输出终端彩色文本属性。

<!-- @todo: LOGO -->

[1]: https://github.com/urbanjost/M_attr

### 简介

M_attr之所以被推荐，是因为它足够简单，巧妙使用类似HTML的标记化风格来控制输出文本的属性。

它的应用场景主要是：
- 屏幕日志输出；
- 屏幕UI效果增强；
- 炫技。

另外，urbanjost是一个资深的Fortran开源开发者。

### 使用`M_attr`输出彩色控制台文本

`M_attr`库可以在 GBK 编码的 CMD 或 UTF8 编码的 Bash 上正确运行。

#### `attr`函数

`M_attr`库的精髓即`attr`函数，我们建立一个简单的示例来演示它：

```sh
cd workspace  # 切换到你常用的工作区间
fpm new --app m-attr-demo  # 创建fpm项目
cd m-attr-demo && code .   # 切换到`m_attr-demo`文件夹，并使用vs code打开它
```

我们创建了一个`m_attr-demo`工程，使用vs code打开了它，我们可以在fpm工程的`fpm.toml`文件中添加以下语句，以使用`M_attr`：

```toml
[dependencies]
M_attr = { git="https://github.com/urbanjost/M_attr.git" }
```

![M_attr-demo](media/M_attr-demo.png)

我们可以使用属性的全称和缩写来标记目标文本，大写属性表示背景色，小写属性表示前景色。

#### 示例代码

```fortran
{{#include demo/m-attr-demo/app/main.F90}}
```

### 说明

`attr`函数是核心函数，除此之外，还有一些辅助函数，可以对内部实现效果进行自定义调整，建议深度使用者细读源代码和帮助文档。

## fortty

fortty 仓库（许可证：Apache 2.0）：[https://github.com/awvwgk/fortty][2]

fortty 是 [Sebastian Ehlert][3] 的开源项目，原本是为 Fortran-stdlib 设计的，现单独做了一个库。

<!-- @todo: LOGO -->

[2]: https://github.com/awvwgk/fortty
[3]: https://github.com/awvwgk

### 示例代码

```fortran
{{#include demo/fortty-demo/app/main.f90}}
```

fortty 提供了 `is_stdout_a_tty` 和 `is_stdin_a_tty` 包装了 `isatty` 函数，用于判断控制台是否为 TTY 终端。

## 小结

如果我们需要完整的 ANSI escape 序列，可以使用 `M_attr` 或 `fortty` 库，否则，我们可以仅使用部分 ESC 码和 `isatty`
函数即可包装为我们自定义需求的代码。
