

<a name="fontlab"></a>

# `fontlab`


<h2>fontlab</h2> <div class="module">  <div class="docstring">

<pre class="doc" markdown="0">Python interface for FontLab data objects

CurveEx: CurveEx representation
ExportControl: ExportControl representation
FaBasicPtr: FaBasicPtr representation
Interval: Interval representation
PaintBrush: PaintBrush representation
TransformFrame: TransformFrame representation
fgSymbol: fgSymbol representation
fgSymbolList: fgSymbolList representation
flAbstractEditor: flAbstractEditor representation
flAbstractVectorNode: flAbstractVectorNode representation
flAnchor: flAnchor representation
flAuditInfo: flAuditInfo representation
flAxis: flAxis representation
flBasicTool: flBasicTool representation
flCanvas: flCanvas representation
flContour: flContour representation
flContourInfo: flContourInfo representation
flContourMarker: flContourMarker representation
flEvent: flEvent representation
flExpression: flExpression representation
flGlyph: flGlyph representation
flGlyphInfo: flGlyphInfo representation
flGraphicsInfo: flGraphicsInfo representation
flGuideLine: flGuideLine representation
flHintingParameters: flHintingParameters representation
flInstance: flInstance representation
flItems: flItems representation
flLayer: flLayer representation
flLayerInfo: flLayerInfo representation
flLocation: flLocation representation
LocationValue: LocationValue representation
flMarkerPoint: flMarkerPoint representation
flMouseEvent: flMouseEvent representation
flModelProducer: flModelProducer representation
flNode: flNode representation
flNodeInfo: flNodeInfo representation
flObject: flObject representation
flPackage: flPackage representation
flPaper: flPaper representation
flPinPoint: flPinPoint representation
flPreferences: flPreferences representation
flProperty: flProperty representation
flPropertyDouble: flPropertyDouble representation
flPropertyPoint: flPropertyPoint representation
flSearchInfo: flSearchInfo representation
flShape: flShape representation
flShapeBuilder: flShapeBuilder representation
flShapeData: flShapeData representation
flShapeInfo: flShapeInfo representation
flSnapLine: flSnapLine representation
flSnapObject: flSnapObject representation
flStem: flStem representation
flZone: flZone representation
flSticker: flSticker representation
flTextBlock: flTextBlock representation
flTransform: flTransform representation
flVectorNode: flVectorNode representation
flVisualItem: flVisualItem representation
flWorkspace: flWorkspace representation
FontMetrics: FontMetrics representation
GlyphComponent: GlyphComponent representation
flTTHCommand: flTTHCommand representation
YPanelManager: YPanelManager representation
YPanelWidget: YPanelWidget representation
Info: Font Info data
FontLayer: FontLayer object
flObjectsList<flGuideLine>: flObjectsList<flGuideLine> doc
flObjectsList<flShape>: flObjectsList<flShape> doc
flSnaps: snap object constants
flModel: flModel representation
PaintBrushShape: Data wrapper
SmartCornerParameters: Data wrapper
AccentInfo: Data wrapper
flLayerAttributes: Data wrapper</pre>

</div>  <div class="classes"><h3>Classes</h3><ul class="tree"><li><span class="class-name">PythonQt.PythonQtInstanceWrapper</span>(<span class="bases">__builtin__.object</span>)</li><li><ul class="tree"><li><span class="class-name"><a href="./fontlab.html#YPanelManager">YPanelManager</a></span></li><li><span class="class-name"><a href="./fontlab.html#YPanelWidget">YPanelWidget</a></span></li></ul></li><li><span class="class-name"><a href="./__builtin__.html#object">__builtin__.object</a></span></li><li><ul class="tree"><li><span class="class-name">__builtin__.AccentInfo</span></li><li><span class="class-name">__builtin__.CurveEx</span></li><li><span class="class-name">__builtin__.ExportControl</span></li><li><span class="class-name">__builtin__.FaBasicPtr</span></li><li><span class="class-name">__builtin__.FontLayer</span></li><li><span class="class-name">__builtin__.FontMetrics</span></li><li><span class="class-name">__builtin__.GlyphComponent</span></li><li><span class="class-name">__builtin__.Info</span></li><li><span class="class-name">__builtin__.Interval</span></li><li><span class="class-name">__builtin__.LocationValue</span></li><li><span class="class-name">__builtin__.PaintBrush</span></li><li><span class="class-name">__builtin__.PaintBrushShape</span></li><li><span class="class-name">__builtin__.SmartCornerParameters</span></li><li><span class="class-name">__builtin__.TransformFrame</span></li><li><span class="class-name">__builtin__.fgSymbol</span></li><li><span class="class-name">__builtin__.fgSymbolList</span></li><li><span class="class-name">__builtin__.flAbstractEditor</span></li><li><span class="class-name">__builtin__.flAbstractVectorNode</span></li><li><span class="class-name">__builtin__.flAnchor</span></li><li><span class="class-name">__builtin__.flAuditInfo</span></li><li><span class="class-name">__builtin__.flAxis</span></li><li><span class="class-name">__builtin__.flBasicTool</span></li><li><span class="class-name">__builtin__.flCanvas</span></li><li><span class="class-name">__builtin__.flContour</span></li><li><span class="class-name">__builtin__.flContourInfo</span></li><li><span class="class-name">__builtin__.flContourMarker</span></li><li><span class="class-name">__builtin__.flEvent</span></li><li><span class="class-name">__builtin__.flExpression</span></li><li><span class="class-name">__builtin__.flGlyph</span></li><li><span class="class-name">__builtin__.flGlyphInfo</span></li><li><span class="class-name">__builtin__.flGraphicsInfo</span></li><li><span class="class-name">__builtin__.flGuideLine</span></li><li><span class="class-name">__builtin__.flHintingParameters</span></li><li><span class="class-name">__builtin__.flInstance</span></li><li><span class="class-name">__builtin__.flItems</span></li><li><span class="class-name">__builtin__.flLayer</span></li><li><span class="class-name">__builtin__.flLayerAttributes</span></li><li><span class="class-name">__builtin__.flLayerInfo</span></li><li><span class="class-name">__builtin__.flLocation</span></li><li><span class="class-name">__builtin__.flMarkerPoint</span></li><li><span class="class-name">__builtin__.flModel</span></li><li><span class="class-name">__builtin__.flModelProducer</span></li><li><span class="class-name">__builtin__.flMouseEvent</span></li><li><span class="class-name">__builtin__.flNode</span></li><li><span class="class-name">__builtin__.flNodeInfo</span></li><li><span class="class-name">__builtin__.flObject</span></li><li><span class="class-name">__builtin__.flObjectsList<flGuideLine></span></li><li><span class="class-name">__builtin__.flObjectsList<flShape></span></li><li><span class="class-name">__builtin__.flPackage</span></li><li><span class="class-name">__builtin__.flPaper</span></li><li><span class="class-name">__builtin__.flPinPoint</span></li><li><span class="class-name">__builtin__.flPreferences</span></li><li><span class="class-name">__builtin__.flProperty</span></li><li><span class="class-name">__builtin__.flPropertyDouble</span></li><li><span class="class-name">__builtin__.flPropertyPoint</span></li><li><span class="class-name">__builtin__.flSearchInfo</span></li><li><span class="class-name">__builtin__.flShape</span></li><li><span class="class-name">__builtin__.flShapeBuilder</span></li><li><span class="class-name">__builtin__.flShapeData</span></li><li><span class="class-name">__builtin__.flShapeInfo</span></li><li><span class="class-name">__builtin__.flSnapLine</span></li><li><span class="class-name">__builtin__.flSnapObject</span></li><li><span class="class-name">__builtin__.flSnaps</span></li><li><span class="class-name">__builtin__.flStem</span></li><li><span class="class-name">__builtin__.flSticker</span></li><li><span class="class-name">__builtin__.flTTHCommand</span></li><li><span class="class-name">__builtin__.flTextBlock</span></li><li><span class="class-name">__builtin__.flTransform</span></li><li><span class="class-name">__builtin__.flVectorNode</span></li><li><span class="class-name">__builtin__.flVisualItem</span></li><li><span class="class-name">__builtin__.flWorkspace</span></li><li><span class="class-name">__builtin__.flZone</span></li></ul></li></ul><dl class="classes"><dt class="class"><h2><a name="AccentInfo" href="#AccentInfo">class <span class="class-name">AccentInfo</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Data wrapper</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="AccentInfo-__add__" href="#AccentInfo-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#AccentInfo-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="AccentInfo-__delattr__" href="#AccentInfo-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#AccentInfo-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="AccentInfo-__delitem__" href="#AccentInfo-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#AccentInfo-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="AccentInfo-__delslice__" href="#AccentInfo-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#AccentInfo-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="AccentInfo-__getattribute__" href="#AccentInfo-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#AccentInfo-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="AccentInfo-__getitem__" href="#AccentInfo-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#AccentInfo-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="AccentInfo-__getslice__" href="#AccentInfo-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#AccentInfo-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="AccentInfo-__init__" href="#AccentInfo-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#AccentInfo-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="AccentInfo-__len__" href="#AccentInfo-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#AccentInfo-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="AccentInfo-__mul__" href="#AccentInfo-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#AccentInfo-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="AccentInfo-__repr__" href="#AccentInfo-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#AccentInfo-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="AccentInfo-__rmul__" href="#AccentInfo-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#AccentInfo-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="AccentInfo-__setattr__" href="#AccentInfo-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#AccentInfo-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="AccentInfo-__setitem__" href="#AccentInfo-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#AccentInfo-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="AccentInfo-__setslice__" href="#AccentInfo-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#AccentInfo-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="AccentInfo-__str__" href="#AccentInfo-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#AccentInfo-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="AccentInfo-asDict" href="#AccentInfo-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="AccentInfo-asTuple" href="#AccentInfo-asTuple"><span class="function-name">asTuple</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as tuple</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>layer</dt>
</dl>
<dl class="descriptor"><dt>offset</dt>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#AccentInfo-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="CurveEx" href="#CurveEx">class <span class="class-name">CurveEx</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">CurveEx representation

Constructors:
  CurveEx() - default
  CurveEx(QPointF p0, QPointF p1[, int leftIdx=0[, int _rightIdx=0]])
  CurveEx(QPointF p0, QPointF p1, QPointF p2, QPointF p3)
  CurveEx( list(QPointF) )</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="CurveEx-__add__" href="#CurveEx-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#CurveEx-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-__delattr__" href="#CurveEx-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#CurveEx-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-__delitem__" href="#CurveEx-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#CurveEx-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-__delslice__" href="#CurveEx-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#CurveEx-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-__getattribute__" href="#CurveEx-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#CurveEx-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-__getitem__" href="#CurveEx-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#CurveEx-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-__getslice__" href="#CurveEx-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#CurveEx-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-__init__" href="#CurveEx-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#CurveEx-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-__len__" href="#CurveEx-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#CurveEx-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-__mul__" href="#CurveEx-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#CurveEx-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-__repr__" href="#CurveEx-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#CurveEx-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-__rmul__" href="#CurveEx-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#CurveEx-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-__setattr__" href="#CurveEx-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#CurveEx-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-__setitem__" href="#CurveEx-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#CurveEx-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-__setslice__" href="#CurveEx-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#CurveEx-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-applyTransform" href="#CurveEx-applyTransform"><span class="function-name">applyTransform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#CurveEx-applyTransform">applyTransform</a>(QTransform& tx)</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-empty" href="#CurveEx-empty"><span class="function-name">empty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#CurveEx-empty">empty</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-extremum" href="#CurveEx-extremum"><span class="function-name">extremum</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#CurveEx-extremum">extremum</a>(<a href="#CurveEx">CurveEx</a> prev)</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-fastLength" href="#CurveEx-fastLength"><span class="function-name">fastLength</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#CurveEx-fastLength">fastLength</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-improve" href="#CurveEx-improve"><span class="function-name">improve</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#CurveEx-improve">improve</a>([double curvature = 1.0])</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-smooth" href="#CurveEx-smooth"><span class="function-name">smooth</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#CurveEx-smooth">smooth</a>(<a href="#CurveEx">CurveEx</a> prev)</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-smoothCurvature" href="#CurveEx-smoothCurvature"><span class="function-name">smoothCurvature</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#CurveEx">CurveEx</a> <a href="#CurveEx-smoothCurvature">smoothCurvature</a>(<a href="#CurveEx">CurveEx</a> c1, bool complete)</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-split" href="#CurveEx-split"><span class="function-name">split</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#CurveEx-split">split</a>(<a href="#CurveEx">CurveEx</a>, <a href="#CurveEx">CurveEx</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="CurveEx-updateBRect" href="#CurveEx-updateBRect"><span class="function-name">updateBRect</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#CurveEx-updateBRect">updateBRect</a>()</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>bcp0</dt>
<dd>

<pre class="doc" markdown="0">QPointF bcp0</pre>

</dd>
</dl>
<dl class="descriptor"><dt>bcp1</dt>
<dd>

<pre class="doc" markdown="0">QPointF bcp1</pre>

</dd>
</dl>
<dl class="descriptor"><dt>bcv0</dt>
<dd>

<pre class="doc" markdown="0">QPointF bcv0</pre>

</dd>
</dl>
<dl class="descriptor"><dt>bcv1</dt>
<dd>

<pre class="doc" markdown="0">QPointF bcv1</pre>

</dd>
</dl>
<dl class="descriptor"><dt>brect</dt>
<dd>

<pre class="doc" markdown="0">QRectF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>contourIx</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>countPoints</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>leftIdx</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>p0</dt>
<dd>

<pre class="doc" markdown="0">QPointF p0</pre>

</dd>
</dl>
<dl class="descriptor"><dt>p1</dt>
<dd>

<pre class="doc" markdown="0">QPointF p1</pre>

</dd>
</dl>
<dl class="descriptor"><dt>paramT</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>rightIdx</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#CurveEx-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="ExportControl" href="#ExportControl">class <span class="class-name">ExportControl</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">ExportControl representation

Constructors:</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="ExportControl-__delattr__" href="#ExportControl-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#ExportControl-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="ExportControl-__getattribute__" href="#ExportControl-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#ExportControl-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="ExportControl-__init__" href="#ExportControl-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#ExportControl-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="ExportControl-__repr__" href="#ExportControl-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#ExportControl-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="ExportControl-__setattr__" href="#ExportControl-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#ExportControl-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="ExportControl-init" href="#ExportControl-init"><span class="function-name">init</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#ExportControl-init">init</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="ExportControl-load" href="#ExportControl-load"><span class="function-name">load</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#ExportControl-load">load</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="ExportControl-store" href="#ExportControl-store"><span class="function-name">store</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#ExportControl-store">store</a>()</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>conflictMode</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>contentMode</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>contentName</dt>
<dd>

<pre class="doc" markdown="0">string contentName</pre>

</dd>
</dl>
<dl class="descriptor"><dt>destinationFolder</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>destinationMode</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>groupFamily</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>groupProfiles</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>profileId</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>profileName</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#ExportControl-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="FaBasicPtr" href="#FaBasicPtr">class <span class="class-name">FaBasicPtr</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">FaBasicPtr representation

Constructors:</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="FaBasicPtr-__delattr__" href="#FaBasicPtr-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#FaBasicPtr-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="FaBasicPtr-__getattribute__" href="#FaBasicPtr-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#FaBasicPtr-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="FaBasicPtr-__init__" href="#FaBasicPtr-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#FaBasicPtr-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="FaBasicPtr-__repr__" href="#FaBasicPtr-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#FaBasicPtr-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="FaBasicPtr-__setattr__" href="#FaBasicPtr-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#FaBasicPtr-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="FaBasicPtr-fix" href="#FaBasicPtr-fix"><span class="function-name">fix</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph">flGlyph</a>/Nothing <a href="#FaBasicPtr-fix">fix</a>()</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>canBeFixed</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>contour</dt>
<dd>

<pre class="doc" markdown="0">flContour</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>location</dt>
<dd>

<pre class="doc" markdown="0">QPointF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>nodeIndex</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>priority</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>report</dt>
<dd>

<pre class="doc" markdown="0">QString</pre>

</dd>
</dl>
<dl class="descriptor"><dt>title</dt>
<dd>

<pre class="doc" markdown="0">QString</pre>

</dd>
</dl>
<dl class="descriptor"><dt>vector</dt>
<dd>

<pre class="doc" markdown="0">QPointF</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#FaBasicPtr-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="FontLayer" href="#FontLayer">class <span class="class-name">FontLayer</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">FontLayer object</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="FontLayer-__delattr__" href="#FontLayer-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#FontLayer-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="FontLayer-__getattribute__" href="#FontLayer-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#FontLayer-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="FontLayer-__init__" href="#FontLayer-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#FontLayer-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="FontLayer-__repr__" href="#FontLayer-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#FontLayer-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="FontLayer-__setattr__" href="#FontLayer-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#FontLayer-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#FontLayer-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="FontMetrics" href="#FontMetrics">class <span class="class-name">FontMetrics</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">FontMetrics representation

Constructors:
  FontMetrics() - default
  FontMetrics(FontMetrics)
  FontMetrics(double upm)
  FontMetrics(fg::Package *p)
  FontMetrics(flPackage p, string layer_name)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="FontMetrics-__delattr__" href="#FontMetrics-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#FontMetrics-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="FontMetrics-__getattribute__" href="#FontMetrics-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#FontMetrics-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="FontMetrics-__init__" href="#FontMetrics-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#FontMetrics-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="FontMetrics-__repr__" href="#FontMetrics-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#FontMetrics-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="FontMetrics-__setattr__" href="#FontMetrics-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#FontMetrics-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="FontMetrics-init" href="#FontMetrics-init"><span class="function-name">init</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#FontMetrics-init">init</a>()</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>ascender</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>capsHeight</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>descender</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>lineGap</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>upm</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>xHeight</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#FontMetrics-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="GlyphComponent" href="#GlyphComponent">class <span class="class-name">GlyphComponent</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">GlyphComponent representation

Constructors:
  GlyphComponent() - default
  GlyphComponent(GlyphComponent)
  GlyphComponent(uint id)
  GlyphComponent(string name)
  GlyphComponent(uint id, QTransform tx, double w, bool ua)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="GlyphComponent-__delattr__" href="#GlyphComponent-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#GlyphComponent-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="GlyphComponent-__getattribute__" href="#GlyphComponent-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#GlyphComponent-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="GlyphComponent-__init__" href="#GlyphComponent-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#GlyphComponent-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="GlyphComponent-__repr__" href="#GlyphComponent-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#GlyphComponent-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="GlyphComponent-__setattr__" href="#GlyphComponent-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#GlyphComponent-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>name_id</dt>
<dd>

<pre class="doc" markdown="0">uint</pre>

</dd>
</dl>
<dl class="descriptor"><dt>transform</dt>
<dd>

<pre class="doc" markdown="0">QTransform</pre>

</dd>
</dl>
<dl class="descriptor"><dt>use_anchors</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>width_scale</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#GlyphComponent-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="Info" href="#Info">class <span class="class-name">Info</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Font Info data</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="Info-__delattr__" href="#Info-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#Info-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="Info-__getattribute__" href="#Info-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#Info-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="Info-__init__" href="#Info-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#Info-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="Info-__repr__" href="#Info-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#Info-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="Info-__setattr__" href="#Info-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#Info-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>ascender</dt>
<dd>

<pre class="doc" markdown="0">Ascender value. This should be a integer or float</pre>

</dd>
</dl>
<dl class="descriptor"><dt>capHeight</dt>
<dd>

<pre class="doc" markdown="0">Cap height value. This should be a integer or float</pre>

</dd>
</dl>
<dl class="descriptor"><dt>copyright</dt>
<dd>

<pre class="doc" markdown="0">Copyright statement. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>descender</dt>
<dd>

<pre class="doc" markdown="0">Descender value. This should be a integer or float</pre>

</dd>
</dl>
<dl class="descriptor"><dt>familyName</dt>
<dd>

<pre class="doc" markdown="0">Family name. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>italicAngle</dt>
<dd>

<pre class="doc" markdown="0">Italic angle. This must be an angle in counter-clockwise degrees from the vertical. This should be a integer or float</pre>

</dd>
</dl>
<dl class="descriptor"><dt>macintoshFONDFamilyID</dt>
<dd>

<pre class="doc" markdown="0">Family ID number. Corresponds to the ffFamID in the FOND resource. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>macintoshFONDName</dt>
<dd>

<pre class="doc" markdown="0">Font name for the FOND resource. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>note</dt>
<dd>

<pre class="doc" markdown="0">Arbitrary note about the font. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeGaspRangeRecords</dt>
<dd>

<pre class="doc" markdown="0">A list of gasp Range Records. These must be sorted in ascending order based on the rangeMaxPPEM value of the record. This should be a list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeHeadCreated</dt>
<dd>

<pre class="doc" markdown="0">Creation date. Expressed as a string of the format "YYYY/MM/DD HH:MM:SS". "YYYY/MM/DD" is year/month/day. The month must be in the range 1-12 and the day must be in the range 1-end of month. "HH:MM:SS" is hour:minute:second. The hour must be in the range 0:23. The minute and second must each be in the range 0-59. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeHeadFlags</dt>
<dd>

<pre class="doc" markdown="0">A list of bit numbers indicating the flags. The bit numbers are listed in the OpenType head specification. Corresponds to the OpenType head table flags field. This should be a list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeHeadLowestRecPPEM</dt>
<dd>

<pre class="doc" markdown="0">Smallest readable size in pixels. Corresponds to the OpenType head table lowestRecPPEM field. This should be a non-negative integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeHheaAscender</dt>
<dd>

<pre class="doc" markdown="0">Ascender value. Corresponds to the OpenType hhea table Ascender field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeHheaCaretOffset</dt>
<dd>

<pre class="doc" markdown="0">Caret offset value. Corresponds to the OpenType hhea table caretOffset field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeHheaCaretSlopeRise</dt>
<dd>

<pre class="doc" markdown="0">Caret slope rise value. Corresponds to the OpenType hhea table caretSlopeRise field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeHheaCaretSlopeRun</dt>
<dd>

<pre class="doc" markdown="0">Caret slope run value. Corresponds to the OpenType hhea table caretSlopeRun field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeHheaDescender</dt>
<dd>

<pre class="doc" markdown="0">Descender value. Corresponds to the OpenType hhea table Descender field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeHheaLineGap</dt>
<dd>

<pre class="doc" markdown="0">Line gap value. Corresponds to the OpenType hhea table LineGap field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameCompatibleFullName</dt>
<dd>

<pre class="doc" markdown="0">Compatible full name. Corresponds to the OpenType name table name ID 18. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameDescription</dt>
<dd>

<pre class="doc" markdown="0">Description of the font. Corresponds to the OpenType name table name ID 10. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameDesigner</dt>
<dd>

<pre class="doc" markdown="0">Designer name. Corresponds to the OpenType name table name ID 9. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameDesignerURL</dt>
<dd>

<pre class="doc" markdown="0">URL for the designer. Corresponds to the OpenType name table name ID 12. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameLicense</dt>
<dd>

<pre class="doc" markdown="0">License text. Corresponds to the OpenType name table name ID 13. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameLicenseURL</dt>
<dd>

<pre class="doc" markdown="0">URL for the license. Corresponds to the OpenType name table name ID 14. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameManufacturer</dt>
<dd>

<pre class="doc" markdown="0">Manufacturer name. Corresponds to the OpenType name table name ID 8. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameManufacturerURL</dt>
<dd>

<pre class="doc" markdown="0">Manufacturer URL. Corresponds to the OpenType name table name ID 11. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNamePreferredFamilyName</dt>
<dd>

<pre class="doc" markdown="0">Preferred family name. Corresponds to the OpenType name table name ID 16. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNamePreferredSubfamilyName</dt>
<dd>

<pre class="doc" markdown="0">Preferred subfamily name. Corresponds to the OpenType name table name ID 17. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameRecords</dt>
<dd>

<pre class="doc" markdown="0">A list of name records. This name record storage area is intended for records that require platform, encoding and or language localization. This should be a list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameSampleText</dt>
<dd>

<pre class="doc" markdown="0">Sample text. Corresponds to the OpenType name table name ID 19. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameUniqueID</dt>
<dd>

<pre class="doc" markdown="0">Unique ID string. Corresponds to the OpenType name table name ID 3. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameVersion</dt>
<dd>

<pre class="doc" markdown="0">Version string. Corresponds to the OpenType name table name ID 5. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameWWSFamilyName</dt>
<dd>

<pre class="doc" markdown="0">WWS family name. Corresponds to the OpenType name table name ID 21. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameWWSSubfamilyName</dt>
<dd>

<pre class="doc" markdown="0">WWS Subfamily name. Corresponds to the OpenType name table name ID 22. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2CodePageRanges</dt>
<dd>

<pre class="doc" markdown="0">A list of bit numbers that are supported code page ranges in the font. The bit numbers are listed in the OpenType OS/2 specification. Corresponds to the OpenType OS/2 table ulCodePageRange1 and ulCodePageRange2 fields. This should be a list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2FamilyClass</dt>
<dd>

<pre class="doc" markdown="0">Two integers representing the IBM font class and font subclass of the font. The first number, representing the class ID, must be in the range 0-14. The second number, representing the subclass, must be in the range 0-15. The numbers are listed in the OpenType OS/2 specification. Corresponds to the OpenType OS/2 table sFamilyClass field. This should be a list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2Panose</dt>
<dd>

<pre class="doc" markdown="0">The list must contain 10 non-negative integers that represent the setting for each category in the Panose specification. The integers correspond with the option numbers in each of the Panose categories. This corresponds to the OpenType OS/2 table Panose field. This should be a list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2Selection</dt>
<dd>

<pre class="doc" markdown="0">A list of bit numbers indicating the bits that should be set in fsSelection. The bit numbers are listed in the OpenType OS/2 specification. Corresponds to the OpenType OS/2 table selection field. Note: Bits 0 (italic), 5 (bold) and 6 (regular) must not be set here. These bits should be taken from the generic styleMapStyle attribute. This should be a list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2StrikeoutPosition</dt>
<dd>

<pre class="doc" markdown="0">Strikeout position. Corresponds to the OpenType OS/2 table yStrikeoutPosition field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2StrikeoutSize</dt>
<dd>

<pre class="doc" markdown="0">Strikeout size. Corresponds to the OpenType OS/2 table yStrikeoutSize field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2SubscriptXOffset</dt>
<dd>

<pre class="doc" markdown="0">Subscript x offset. Corresponds to the OpenType OS/2 table ySubscriptXOffset field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2SubscriptXSize</dt>
<dd>

<pre class="doc" markdown="0">Subscript horizontal font size. Corresponds to the OpenType OS/2 table ySubscriptXSize field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2SubscriptYOffset</dt>
<dd>

<pre class="doc" markdown="0">Subscript y offset. Corresponds to the OpenType OS/2 table ySubscriptYOffset field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2SubscriptYSize</dt>
<dd>

<pre class="doc" markdown="0">Subscript vertical font size. Corresponds to the OpenType OS/2 table ySubscriptYSize field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2SuperscriptXOffset</dt>
<dd>

<pre class="doc" markdown="0">Superscript x offset. Corresponds to the OpenType OS/2 table ySuperscriptXOffset field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2SuperscriptXSize</dt>
<dd>

<pre class="doc" markdown="0">Superscript horizontal font size. Corresponds to the OpenType OS/2 table ySuperscriptXSize field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2SuperscriptYOffset</dt>
<dd>

<pre class="doc" markdown="0">Superscript y offset. Corresponds to the OpenType OS/2 table ySuperscriptYOffset field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2SuperscriptYSize</dt>
<dd>

<pre class="doc" markdown="0">Superscript vertical font size. Corresponds to the OpenType OS/2 table ySuperscriptYSize field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2Type</dt>
<dd>

<pre class="doc" markdown="0">A list of bit numbers indicating the embedding type. The bit numbers are listed in the OpenType OS/2 specification. Corresponds to the OpenType OS/2 table fsType field. This should be a list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2TypoAscender</dt>
<dd>

<pre class="doc" markdown="0">Ascender value. Corresponds to the OpenType OS/2 table sTypoAscender field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2TypoDescender</dt>
<dd>

<pre class="doc" markdown="0">Descender value. Corresponds to the OpenType OS/2 table sTypoDescender field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2TypoLineGap</dt>
<dd>

<pre class="doc" markdown="0">Line gap value. Corresponds to the OpenType OS/2 table sTypoLineGap field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2UnicodeRanges</dt>
<dd>

<pre class="doc" markdown="0">A list of bit numbers that are supported Unicode ranges in the font. The bit numbers are listed in the OpenType OS/2 specification. Corresponds to the OpenType OS/2 table ulUnicodeRange1, ulUnicodeRange2, ulUnicodeRange3 and ulUnicodeRange4 fields. This should be a list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2VendorID</dt>
<dd>

<pre class="doc" markdown="0">Four character identifier for the creator of the font. Corresponds to the OpenType OS/2 table achVendID field. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2WeightClass</dt>
<dd>

<pre class="doc" markdown="0">Weight class value. Must be a non-negative integer. Corresponds to the OpenType OS/2 table usWeightClass field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2WidthClass</dt>
<dd>

<pre class="doc" markdown="0">Width class value. Must be in the range 1-9. Corresponds to the OpenType OS/2 table usWidthClass field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2WinAscent</dt>
<dd>

<pre class="doc" markdown="0">Ascender value. Corresponds to the OpenType OS/2 table usWinAscent field. This should be a non-negative integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2WinDescent</dt>
<dd>

<pre class="doc" markdown="0">Descender value. Corresponds to the OpenType OS/2 table usWinDescent field. This should be a non-negative integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeVheaCaretOffset</dt>
<dd>

<pre class="doc" markdown="0">Caret offset value. Corresponds to the OpenType vhea table caretOffset field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeVheaCaretSlopeRise</dt>
<dd>

<pre class="doc" markdown="0">Caret slope rise value. Corresponds to the OpenType vhea table caretSlopeRise field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeVheaCaretSlopeRun</dt>
<dd>

<pre class="doc" markdown="0">Caret slope run value. Corresponds to the OpenType vhea table caretSlopeRun field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeVheaVertTypoAscender</dt>
<dd>

<pre class="doc" markdown="0">Ascender value. Corresponds to the OpenType vhea table vertTypoAscender field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeVheaVertTypoDescender</dt>
<dd>

<pre class="doc" markdown="0">Descender value. Corresponds to the OpenType vhea table vertTypoDescender field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeVheaVertTypoLineGap</dt>
<dd>

<pre class="doc" markdown="0">Line gap value. Corresponds to the OpenType vhea table vertTypoLineGap field. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>panose</dt>
<dd>

<pre class="doc" markdown="0">PANOSE identification. Should be a string containing 10 space-separated numbers</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptBlueFuzz</dt>
<dd>

<pre class="doc" markdown="0">BlueFuzz value. This corresponds to the Type 1/CFF BlueFuzz field. This should be a integer or float</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptBlueScale</dt>
<dd>

<pre class="doc" markdown="0">BlueScale value. This corresponds to the Type 1/CFF BlueScale field. This should be a float</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptBlueShift</dt>
<dd>

<pre class="doc" markdown="0">BlueShift value. This corresponds to the Type 1/CFF BlueShift field. This should be a integer or float</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptBlueValues</dt>
<dd>

<pre class="doc" markdown="0">A list of up to 14 integers or floats specifying the values that should be in the Type 1/CFF BlueValues field. This list must contain an even number of integers following the rules defined in the Type 1/CFF specification. This should be a list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptDefaultCharacter</dt>
<dd>

<pre class="doc" markdown="0">The name of the glyph that should be used as the default character in PFM files. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptDefaultWidthX</dt>
<dd>

<pre class="doc" markdown="0">Default width for glyphs. This should be a integer or float</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptFamilyBlues</dt>
<dd>

<pre class="doc" markdown="0">A list of up to 14 integers or floats specifying the values that should be in the Type 1/CFF FamilyBlues field. This list must contain an even number of integers following the rules defined in the Type 1/CFF specification. This should be a list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptFamilyOtherBlues</dt>
<dd>

<pre class="doc" markdown="0">A list of up to 10 integers or floats specifying the values that should be in the Type 1/CFF FamilyOtherBlues field. This list must contain an even number of integers following the rules defined in the Type 1/CFF specification. This should be a list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptFontName</dt>
<dd>

<pre class="doc" markdown="0">Name to be used for the FontName field in Type 1/CFF table. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptForceBold</dt>
<dd>

<pre class="doc" markdown="0">Indicates how the Type 1/CFF ForceBold field should be set. This should be a boolean</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptFullName</dt>
<dd>

<pre class="doc" markdown="0">Name to be used for the FullName field in Type 1/CFF table. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptIsFixedPitch</dt>
<dd>

<pre class="doc" markdown="0">Indicates if the font is monospaced. An authoring tool could calculate this automatically, but the designer may wish to override this setting. This corresponds to the Type 1/CFF isFixedPitched field This should be a boolean</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptNominalWidthX</dt>
<dd>

<pre class="doc" markdown="0">Nominal width for glyphs. This should be a integer or float</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptOtherBlues</dt>
<dd>

<pre class="doc" markdown="0">A list of up to 10 integers or floats specifying the values that should be in the Type 1/CFF OtherBlues field. This list must contain an even number of integers following the rules defined in the Type 1/CFF specification. This should be a list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptStemSnapH</dt>
<dd>

<pre class="doc" markdown="0">List of horizontal stems sorted in the order specified in the Type 1/CFF specification. Up to 12 integers or floats are possible. This corresponds to the Type 1/CFF StemSnapH field. This should be a list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptStemSnapV</dt>
<dd>

<pre class="doc" markdown="0">List of vertical stems sorted in the order specified in the Type 1/CFF specification. Up to 12 integers or floats are possible. This corresponds to the Type 1/CFF StemSnapV field. This should be a list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptUnderlinePosition</dt>
<dd>

<pre class="doc" markdown="0">Underline position value. Corresponds to the Type 1/CFF/post table UnderlinePosition field. This should be a integer or float</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptUnderlineThickness</dt>
<dd>

<pre class="doc" markdown="0">Underline thickness value. Corresponds to the Type 1/CFF/post table UnderlineThickness field. This should be a integer or float</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptUniqueID</dt>
<dd>

<pre class="doc" markdown="0">A unique ID number as defined in the Type 1/CFF specification. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptWeightName</dt>
<dd>

<pre class="doc" markdown="0">A string indicating the overall weight of the font. This corresponds to the Type 1/CFF Weight field. It should be in sync with the openTypeOS2WeightClass value. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptWindowsCharacterSet</dt>
<dd>

<pre class="doc" markdown="0">The Windows character set. The values are defined below. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>styleMapFamilyName</dt>
<dd>

<pre class="doc" markdown="0">Family name used for bold, italic and bold italic style mapping. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>styleMapStyleName</dt>
<dd>

<pre class="doc" markdown="0">Style map style. The possible values are regular, italic, bold and bold italic. These are case sensitive. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>styleName</dt>
<dd>

<pre class="doc" markdown="0">Style name. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>trademark</dt>
<dd>

<pre class="doc" markdown="0">Trademark statement. This should be a string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>unitsPerEm</dt>
<dd>

<pre class="doc" markdown="0">Units per em. This should be a non-negative integer or float</pre>

</dd>
</dl>
<dl class="descriptor"><dt>versionMajor</dt>
<dd>

<pre class="doc" markdown="0">Major version. This should be a integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>versionMinor</dt>
<dd>

<pre class="doc" markdown="0">Minor version. This should be a non-negative integer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>xHeight</dt>
<dd>

<pre class="doc" markdown="0">x-height value. This should be a integer or float</pre>

</dd>
</dl>
<dl class="descriptor"><dt>year</dt>
<dd>

<pre class="doc" markdown="0">The year the font was created. This attribute is deprecated as of version 2. It's presence should not be relied upon by authoring tools. However, it may occur in a font's info so authoring tools should preserve it if present. This should be a integer</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#Info-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="Interval" href="#Interval">class <span class="class-name">Interval</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Interval representation

Constructors:</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="Interval-__delattr__" href="#Interval-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#Interval-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="Interval-__eq__" href="#Interval-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#Interval-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="Interval-__ge__" href="#Interval-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#Interval-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="Interval-__getattribute__" href="#Interval-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#Interval-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="Interval-__gt__" href="#Interval-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#Interval-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="Interval-__init__" href="#Interval-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#Interval-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="Interval-__le__" href="#Interval-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#Interval-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="Interval-__lt__" href="#Interval-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#Interval-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="Interval-__ne__" href="#Interval-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#Interval-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="Interval-__repr__" href="#Interval-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#Interval-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="Interval-__setattr__" href="#Interval-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#Interval-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="Interval-isEmpty" href="#Interval-isEmpty"><span class="function-name">isEmpty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#Interval-isEmpty">isEmpty</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="Interval-middle" href="#Interval-middle"><span class="function-name">middle</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#Interval-middle">middle</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="Interval-reversed" href="#Interval-reversed"><span class="function-name">reversed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#Interval">Interval</a> <a href="#Interval-reversed">reversed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="Interval-setT0T1" href="#Interval-setT0T1"><span class="function-name">setT0T1</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#Interval-setT0T1">setT0T1</a>(double t0, double t1)</pre>

</dd></dl>
<dl class="function"><dt><a name="Interval-toAbsolute" href="#Interval-toAbsolute"><span class="function-name">toAbsolute</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#Interval-toAbsolute">toAbsolute</a>(double v)</pre>

</dd></dl>
<dl class="function"><dt><a name="Interval-toInterval" href="#Interval-toInterval"><span class="function-name">toInterval</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#Interval-toInterval">toInterval</a>(double absv)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>d</dt>
<dd>

<pre class="doc" markdown="0">double d</pre>

</dd>
</dl>
<dl class="descriptor"><dt>key</dt>
<dd>

<pre class="doc" markdown="0">uint key</pre>

</dd>
</dl>
<dl class="descriptor"><dt>t0</dt>
<dd>

<pre class="doc" markdown="0">double t0</pre>

</dd>
</dl>
<dl class="descriptor"><dt>t1</dt>
<dd>

<pre class="doc" markdown="0">double t1</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#Interval-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="LocationValue" href="#LocationValue">class <span class="class-name">LocationValue</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">LocationValue representation

Constructors:
  LocationValue(flLocation)
  LocationValue(double)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="LocationValue-__delattr__" href="#LocationValue-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#LocationValue-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="LocationValue-__getattribute__" href="#LocationValue-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#LocationValue-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="LocationValue-__init__" href="#LocationValue-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#LocationValue-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="LocationValue-__repr__" href="#LocationValue-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#LocationValue-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="LocationValue-__setattr__" href="#LocationValue-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#LocationValue-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#LocationValue-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="PaintBrush" href="#PaintBrush">class <span class="class-name">PaintBrush</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">PaintBrush representation

Constructors:</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="PaintBrush-__delattr__" href="#PaintBrush-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrush-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrush-__getattribute__" href="#PaintBrush-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrush-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrush-__init__" href="#PaintBrush-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrush-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrush-__repr__" href="#PaintBrush-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrush-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrush-__setattr__" href="#PaintBrush-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrush-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrush-assign" href="#PaintBrush-assign"><span class="function-name">assign</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#PaintBrush-assign">assign</a>(<a href="#PaintBrush">PaintBrush</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrush-init" href="#PaintBrush-init"><span class="function-name">init</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#PaintBrush-init">init</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrush-render" href="#PaintBrush-render"><span class="function-name">render</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#PaintBrush-render">render</a>(double scale)</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrush-toString" href="#PaintBrush-toString"><span class="function-name">toString</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QString <a href="#PaintBrush-toString">toString</a>()</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>angle</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>flatness</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>shape</dt>
<dd>

<pre class="doc" markdown="0">PaintBrushShape</pre>

</dd>
</dl>
<dl class="descriptor"><dt>size</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#PaintBrush-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="PaintBrushShape" href="#PaintBrushShape">class <span class="class-name">PaintBrushShape</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Data wrapper</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="PaintBrushShape-__add__" href="#PaintBrushShape-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrushShape-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrushShape-__delattr__" href="#PaintBrushShape-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrushShape-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrushShape-__delitem__" href="#PaintBrushShape-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrushShape-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrushShape-__delslice__" href="#PaintBrushShape-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrushShape-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrushShape-__getattribute__" href="#PaintBrushShape-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrushShape-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrushShape-__getitem__" href="#PaintBrushShape-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrushShape-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrushShape-__getslice__" href="#PaintBrushShape-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrushShape-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrushShape-__init__" href="#PaintBrushShape-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrushShape-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrushShape-__len__" href="#PaintBrushShape-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrushShape-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrushShape-__mul__" href="#PaintBrushShape-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrushShape-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrushShape-__repr__" href="#PaintBrushShape-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrushShape-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrushShape-__rmul__" href="#PaintBrushShape-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrushShape-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrushShape-__setattr__" href="#PaintBrushShape-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrushShape-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrushShape-__setitem__" href="#PaintBrushShape-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrushShape-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrushShape-__setslice__" href="#PaintBrushShape-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrushShape-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrushShape-__str__" href="#PaintBrushShape-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#PaintBrushShape-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrushShape-asDict" href="#PaintBrushShape-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="PaintBrushShape-asTuple" href="#PaintBrushShape-asTuple"><span class="function-name">asTuple</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as tuple</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>cap0</dt>
</dl>
<dl class="descriptor"><dt>cap1</dt>
</dl>
<dl class="descriptor"><dt>cap_length0</dt>
</dl>
<dl class="descriptor"><dt>cap_length1</dt>
</dl>
<dl class="descriptor"><dt>data</dt>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#PaintBrushShape-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="SmartCornerParameters" href="#SmartCornerParameters">class <span class="class-name">SmartCornerParameters</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Data wrapper</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="SmartCornerParameters-__add__" href="#SmartCornerParameters-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#SmartCornerParameters-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="SmartCornerParameters-__delattr__" href="#SmartCornerParameters-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#SmartCornerParameters-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="SmartCornerParameters-__delitem__" href="#SmartCornerParameters-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#SmartCornerParameters-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="SmartCornerParameters-__delslice__" href="#SmartCornerParameters-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#SmartCornerParameters-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="SmartCornerParameters-__getattribute__" href="#SmartCornerParameters-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#SmartCornerParameters-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="SmartCornerParameters-__getitem__" href="#SmartCornerParameters-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#SmartCornerParameters-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="SmartCornerParameters-__getslice__" href="#SmartCornerParameters-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#SmartCornerParameters-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="SmartCornerParameters-__init__" href="#SmartCornerParameters-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#SmartCornerParameters-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="SmartCornerParameters-__len__" href="#SmartCornerParameters-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#SmartCornerParameters-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="SmartCornerParameters-__mul__" href="#SmartCornerParameters-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#SmartCornerParameters-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="SmartCornerParameters-__repr__" href="#SmartCornerParameters-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#SmartCornerParameters-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="SmartCornerParameters-__rmul__" href="#SmartCornerParameters-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#SmartCornerParameters-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="SmartCornerParameters-__setattr__" href="#SmartCornerParameters-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#SmartCornerParameters-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="SmartCornerParameters-__setitem__" href="#SmartCornerParameters-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#SmartCornerParameters-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="SmartCornerParameters-__setslice__" href="#SmartCornerParameters-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#SmartCornerParameters-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="SmartCornerParameters-__str__" href="#SmartCornerParameters-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#SmartCornerParameters-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="SmartCornerParameters-asDict" href="#SmartCornerParameters-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="SmartCornerParameters-asTuple" href="#SmartCornerParameters-asTuple"><span class="function-name">asTuple</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as tuple</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>curvature</dt>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#SmartCornerParameters-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="TransformFrame" href="#TransformFrame">class <span class="class-name">TransformFrame</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">TransformFrame representation

Constructors:</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="TransformFrame-__delattr__" href="#TransformFrame-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#TransformFrame-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-__getattribute__" href="#TransformFrame-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#TransformFrame-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-__init__" href="#TransformFrame-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#TransformFrame-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-__repr__" href="#TransformFrame-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#TransformFrame-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-__setattr__" href="#TransformFrame-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#TransformFrame-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-boundingRect" href="#TransformFrame-boundingRect"><span class="function-name">boundingRect</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF <a href="#TransformFrame-boundingRect">boundingRect</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-bw" href="#TransformFrame-bw"><span class="function-name">bw</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#TransformFrame-bw">bw</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-doTransformation" href="#TransformFrame-doTransformation"><span class="function-name">doTransformation</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#TransformFrame-doTransformation">doTransformation</a>(int code, QPointF value)</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-flipHorizontal" href="#TransformFrame-flipHorizontal"><span class="function-name">flipHorizontal</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#TransformFrame-flipHorizontal">flipHorizontal</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-flipVertical" href="#TransformFrame-flipVertical"><span class="function-name">flipVertical</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#TransformFrame-flipVertical">flipVertical</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-getControlPos" href="#TransformFrame-getControlPos"><span class="function-name">getControlPos</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#TransformFrame-getControlPos">getControlPos</a>(TransformFrameControls)</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-getMapped" href="#TransformFrame-getMapped"><span class="function-name">getMapped</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#TransformFrame">TransformFrame</a> <a href="#TransformFrame-getMapped">getMapped</a>(QTransform t)</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-getTransform" href="#TransformFrame-getTransform"><span class="function-name">getTransform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QTransform <a href="#TransformFrame-getTransform">getTransform</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-horizontalReflection" href="#TransformFrame-horizontalReflection"><span class="function-name">horizontalReflection</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#TransformFrame-horizontalReflection">horizontalReflection</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-initCenter" href="#TransformFrame-initCenter"><span class="function-name">initCenter</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#TransformFrame-initCenter">initCenter</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-lh" href="#TransformFrame-lh"><span class="function-name">lh</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#TransformFrame-lh">lh</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-mb" href="#TransformFrame-mb"><span class="function-name">mb</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#TransformFrame-mb">mb</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-mh" href="#TransformFrame-mh"><span class="function-name">mh</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#TransformFrame-mh">mh</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-ml" href="#TransformFrame-ml"><span class="function-name">ml</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#TransformFrame-ml">ml</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-mr" href="#TransformFrame-mr"><span class="function-name">mr</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#TransformFrame-mr">mr</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-mt" href="#TransformFrame-mt"><span class="function-name">mt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#TransformFrame-mt">mt</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-mw" href="#TransformFrame-mw"><span class="function-name">mw</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#TransformFrame-mw">mw</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-polygon" href="#TransformFrame-polygon"><span class="function-name">polygon</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPolygonF <a href="#TransformFrame-polygon">polygon</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-prepareTransformations" href="#TransformFrame-prepareTransformations"><span class="function-name">prepareTransformations</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#TransformFrame-prepareTransformations">prepareTransformations</a>([TransformFrameControls control, QPointF p,] double scale)</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-rh" href="#TransformFrame-rh"><span class="function-name">rh</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#TransformFrame-rh">rh</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-rotate" href="#TransformFrame-rotate"><span class="function-name">rotate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#TransformFrame-rotate">rotate</a>(double)</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-rotate180" href="#TransformFrame-rotate180"><span class="function-name">rotate180</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#TransformFrame-rotate180">rotate180</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-scale" href="#TransformFrame-scale"><span class="function-name">scale</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#TransformFrame-scale">scale</a>(QPointF s)</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-setControlPos" href="#TransformFrame-setControlPos"><span class="function-name">setControlPos</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#TransformFrame-setControlPos">setControlPos</a>([TransformFrameControls control,] QPointF position, bool reflection, bool proportional, bool fixed)</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-setProjectionPos" href="#TransformFrame-setProjectionPos"><span class="function-name">setProjectionPos</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#TransformFrame-setProjectionPos">setProjectionPos</a>([TransformFrameControls control,] QPointF position, bool reflection, bool proportional, bool fixed)</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-slant" href="#TransformFrame-slant"><span class="function-name">slant</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#TransformFrame-slant">slant</a>(double angle)</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-translate" href="#TransformFrame-translate"><span class="function-name">translate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#TransformFrame-translate">translate</a>(QPointF)</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-tw" href="#TransformFrame-tw"><span class="function-name">tw</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#TransformFrame-tw">tw</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="TransformFrame-verticalReflection" href="#TransformFrame-verticalReflection"><span class="function-name">verticalReflection</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#TransformFrame-verticalReflection">verticalReflection</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="TransformFrame-expandPolygon" href="#TransformFrame-expandPolygon"><span class="function-name">expandPolygon</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPolygonF <a href="#TransformFrame-expandPolygon">expandPolygon</a>(QPolygonF polygon)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>bl</dt>
<dd>

<pre class="doc" markdown="0">QPointF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>br</dt>
<dd>

<pre class="doc" markdown="0">QPointF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>cr</dt>
<dd>

<pre class="doc" markdown="0">QPointF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>tl</dt>
<dd>

<pre class="doc" markdown="0">QPointF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>tr</dt>
<dd>

<pre class="doc" markdown="0">QPointF</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#TransformFrame-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="YPanelManager" href="#YPanelManager">class <span class="class-name">YPanelManager</span></a>(PythonQt.PythonQtInstanceWrapper)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0"></pre>


</dd>  <div class="mro"><dl class="mro"><dt>Method resolution order:</dt><dd><a href="./fontlab.html#YPanelManager">YPanelManager</a></dd><dd>PythonQt.PythonQtInstanceWrapper</dd><dd><a href="./__builtin__.html#object">__builtin__.object</a></dd></dl></div><h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>__dict__</dt>
<dd>

<pre class="doc" markdown="0">dictionary for instance variables (if defined)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>__weakref__</dt>
<dd>

<pre class="doc" markdown="0">list of weak references to the object (if defined)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">blockSignals</span> = &lt;unbound qt slot blockSignals of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-blockSignals">blockSignals</a>(a, b) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">childEvent</span> = &lt;unbound qt slot py_q_childEvent of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-childEvent">childEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">children</span> = &lt;unbound qt slot children of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-children">children</a>(a) -> tuple</pre>

</dd></dl>
<dl><dt><span class="other-name">className</span> = &lt;built-in method className of PythonQt.PythonQtClassWrapper object&gt;<dd>

<pre class="doc" markdown="0">Return the classname of the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl><dt><span class="other-name">connect</span> = &lt;unbound qt slot connect of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-connect">connect</a>(a, b, c, d, e) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">customEvent</span> = &lt;unbound qt slot py_q_customEvent of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-customEvent">customEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">delete</span> = &lt;built-in method delete of PythonQt.PythonQtClassWrapper object&gt;<dd>

<pre class="doc" markdown="0">Deletes the given C++ <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl><dt><span class="other-name">deleteLater</span> = &lt;unbound qt slot deleteLater of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-deleteLater">deleteLater</a>()</pre>

</dd></dl>
<dl><dt><span class="other-name">desktopClientRectChanged</span> = &lt;unbound qt signal desktopClientRectChanged of YPanelManager type&gt;</dt></dl>
<dl><dt><span class="other-name">destroyed</span> = &lt;unbound qt signal destroyed of YPanelManager type&gt;</dt></dl>
<dl><dt><span class="other-name">disconnect</span> = &lt;unbound qt slot disconnect of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-disconnect">disconnect</a>(a, b, c, d) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">dumpObjectInfo</span> = &lt;unbound qt slot dumpObjectInfo of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-dumpObjectInfo">dumpObjectInfo</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">dumpObjectTree</span> = &lt;unbound qt slot dumpObjectTree of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-dumpObjectTree">dumpObjectTree</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">dynamicPropertyNames</span> = &lt;unbound qt slot dynamicPropertyNames of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-dynamicPropertyNames">dynamicPropertyNames</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">event</span> = &lt;unbound qt slot py_q_event of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-event">event</a>(a, b) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">eventFilter</span> = &lt;unbound qt slot py_q_eventFilter of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-eventFilter">eventFilter</a>(a, b, c) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">findChild</span> = &lt;unbound qt slot findChild of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-findChild">findChild</a>(a, b, c) -> PythonQt.private.QObject</pre>

</dd></dl>
<dl><dt><span class="other-name">findChildren</span> = &lt;unbound qt slot findChildren of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-findChildren">findChildren</a>(a, b, c) -> tuple</pre>

</dd></dl>
<dl><dt><span class="other-name">help</span> = &lt;built-in method help of PythonQt.PythonQtClassWrapper object&gt;<dd>

<pre class="doc" markdown="0">Shows the help of available methods for this class</pre>

</dd></dl>
<dl><dt><span class="other-name">inherits</span> = &lt;built-in method inherits of PythonQt.PythonQtClassWrapper object&gt;<dd>

<pre class="doc" markdown="0">Returns if the class inherits or is of given type name</pre>

</dd></dl>
<dl><dt><span class="other-name">installEventFilter</span> = &lt;unbound qt slot installEventFilter of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-installEventFilter">installEventFilter</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">isSignalConnected</span> = &lt;unbound qt slot isSignalConnected of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-isSignalConnected">isSignalConnected</a>(a, b) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">isWidgetType</span> = &lt;unbound qt slot isWidgetType of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-isWidgetType">isWidgetType</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">isWindowType</span> = &lt;unbound qt slot isWindowType of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-isWindowType">isWindowType</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">killTimer</span> = &lt;unbound qt slot killTimer of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-killTimer">killTimer</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">metaObject</span> = &lt;unbound qt slot metaObject of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-metaObject">metaObject</a>(a) -> PythonQt.QtCore.QMetaObject</pre>

</dd></dl>
<dl><dt><span class="other-name">moveToThread</span> = &lt;unbound qt slot moveToThread of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-moveToThread">moveToThread</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">objectName</span> = None</dt></dl>
<dl><dt><span class="other-name">objectNameChanged</span> = &lt;unbound qt signal objectNameChanged of YPanelManager type&gt;</dt></dl>
<dl><dt><span class="other-name">panelClosed</span> = &lt;unbound qt signal panelClosed of YPanelManager type&gt;</dt></dl>
<dl><dt><span class="other-name">parent</span> = &lt;unbound qt slot parent of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-parent">parent</a>(a) -> PythonQt.private.QObject</pre>

</dd></dl>
<dl><dt><span class="other-name">property</span> = &lt;unbound qt slot property of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-property">property</a>(a, b) -> <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl><dt><span class="other-name">removeEventFilter</span> = &lt;unbound qt slot removeEventFilter of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-removeEventFilter">removeEventFilter</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">sender</span> = &lt;unbound qt slot sender of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-sender">sender</a>(a) -> PythonQt.private.QObject</pre>

</dd></dl>
<dl><dt><span class="other-name">senderSignalIndex</span> = &lt;unbound qt slot senderSignalIndex of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-senderSignalIndex">senderSignalIndex</a>(a) -> int</pre>

</dd></dl>
<dl><dt><span class="other-name">setObjectName</span> = &lt;unbound qt slot setObjectName of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-setObjectName">setObjectName</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setParent</span> = &lt;unbound qt slot setParent of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-setParent">setParent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setProperty</span> = &lt;unbound qt slot setProperty of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-setProperty">setProperty</a>(a, b, c) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">showContextMenu</span> = &lt;unbound qt signal showContextMenu of YPanelManager type&gt;</dt></dl>
<dl><dt><span class="other-name">signalsBlocked</span> = &lt;unbound qt slot signalsBlocked of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-signalsBlocked">signalsBlocked</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">startTimer</span> = &lt;unbound qt slot startTimer of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-startTimer">startTimer</a>(a, b, c) -> int</pre>

</dd></dl>
<dl><dt><span class="other-name">thread</span> = &lt;unbound qt slot thread of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-thread">thread</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">timerEvent</span> = &lt;unbound qt slot py_q_timerEvent of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-timerEvent">timerEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">toolbarClosed</span> = &lt;unbound qt signal toolbarClosed of YPanelManager type&gt;</dt></dl>
<dl><dt><span class="other-name">toolbarOpened</span> = &lt;unbound qt signal toolbarOpened of YPanelManager type&gt;</dt></dl>
<dl><dt><span class="other-name">tr</span> = &lt;unbound qt slot tr of YPanelManager type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelManager-tr">tr</a>(a, b, c, d) -> str</pre>

</dd></dl>

  <h4 class="head-methods">Methods from PythonQt.PythonQtInstanceWrapper</h4><dl class="function"><dt><a name="YPanelManager-__delattr__" href="#YPanelManager-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelManager-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelManager-__eq__" href="#YPanelManager-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelManager-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelManager-__ge__" href="#YPanelManager-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelManager-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelManager-__getattribute__" href="#YPanelManager-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelManager-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelManager-__gt__" href="#YPanelManager-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelManager-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelManager-__hash__" href="#YPanelManager-__hash__"><span class="function-name">__hash__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelManager-__hash__">__hash__</a>() <==> hash(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelManager-__init__" href="#YPanelManager-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelManager-__init__">__init__</a>(...) initializes x; see <a href="#YPanelManager-help">help</a>(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelManager-__le__" href="#YPanelManager-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelManager-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelManager-__lt__" href="#YPanelManager-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelManager-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelManager-__ne__" href="#YPanelManager-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelManager-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelManager-__nonzero__" href="#YPanelManager-__nonzero__"><span class="function-name">__nonzero__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelManager-__nonzero__">__nonzero__</a>() <==> x != 0</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelManager-__repr__" href="#YPanelManager-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelManager-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelManager-__setattr__" href="#YPanelManager-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelManager-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelManager-__str__" href="#YPanelManager-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelManager-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes from PythonQt.PythonQtInstanceWrapper</h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of PythonQt.PythonQtClassWrapper object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#YPanelManager-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="YPanelWidget" href="#YPanelWidget">class <span class="class-name">YPanelWidget</span></a>(PythonQt.PythonQtInstanceWrapper)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0"></pre>


</dd>  <div class="mro"><dl class="mro"><dt>Method resolution order:</dt><dd><a href="./fontlab.html#YPanelWidget">YPanelWidget</a></dd><dd>PythonQt.PythonQtInstanceWrapper</dd><dd><a href="./__builtin__.html#object">__builtin__.object</a></dd></dl></div><h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>__dict__</dt>
<dd>

<pre class="doc" markdown="0">dictionary for instance variables (if defined)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>__weakref__</dt>
<dd>

<pre class="doc" markdown="0">list of weak references to the object (if defined)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">DrawChildren</span> = 2</dt></dl>
<dl><dt><span class="other-name">DrawWindowBackground</span> = 1</dt></dl>
<dl><dt><span class="other-name">IgnoreMask</span> = 4</dt></dl>
<dl><dt><span class="other-name">PaintDeviceMetric</span> = &lt;class 'PythonQt.QtGui.PaintDeviceMetric'&gt;</dt></dl>
<dl><dt><span class="other-name">PdmDepth</span> = 6</dt></dl>
<dl><dt><span class="other-name">PdmDevicePixelRatio</span> = 11</dt></dl>
<dl><dt><span class="other-name">PdmDevicePixelRatioScaled</span> = 12</dt></dl>
<dl><dt><span class="other-name">PdmDpiX</span> = 7</dt></dl>
<dl><dt><span class="other-name">PdmDpiY</span> = 8</dt></dl>
<dl><dt><span class="other-name">PdmHeight</span> = 2</dt></dl>
<dl><dt><span class="other-name">PdmHeightMM</span> = 4</dt></dl>
<dl><dt><span class="other-name">PdmNumColors</span> = 5</dt></dl>
<dl><dt><span class="other-name">PdmPhysicalDpiX</span> = 9</dt></dl>
<dl><dt><span class="other-name">PdmPhysicalDpiY</span> = 10</dt></dl>
<dl><dt><span class="other-name">PdmWidth</span> = 1</dt></dl>
<dl><dt><span class="other-name">PdmWidthMM</span> = 3</dt></dl>
<dl><dt><span class="other-name">RenderFlag</span> = &lt;class 'PythonQt.QtGui.RenderFlag'&gt;</dt></dl>
<dl><dt><span class="other-name">RenderFlags</span> = &lt;class 'PythonQt.QtGui.RenderFlags'&gt;</dt></dl>
<dl><dt><span class="other-name">acceptDrops</span> = None</dt></dl>
<dl><dt><span class="other-name">accessibleDescription</span> = None</dt></dl>
<dl><dt><span class="other-name">accessibleName</span> = None</dt></dl>
<dl><dt><span class="other-name">actionEvent</span> = &lt;unbound qt slot py_q_actionEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-actionEvent">actionEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">actions</span> = &lt;unbound qt slot actions of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-actions">actions</a>(a) -> tuple</pre>

</dd></dl>
<dl><dt><span class="other-name">activateWindow</span> = &lt;unbound qt slot activateWindow of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-activateWindow">activateWindow</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">addAction</span> = &lt;unbound qt slot addAction of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-addAction">addAction</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">addActions</span> = &lt;unbound qt slot addActions of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-addActions">addActions</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">adjustSize</span> = &lt;unbound qt slot adjustSize of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-adjustSize">adjustSize</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">autoFillBackground</span> = None</dt></dl>
<dl><dt><span class="other-name">backgroundRole</span> = &lt;unbound qt slot backgroundRole of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-backgroundRole">backgroundRole</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">backingStore</span> = &lt;unbound qt slot backingStore of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-backingStore">backingStore</a>(a) -> PythonQt.QtGui.QBackingStore</pre>

</dd></dl>
<dl><dt><span class="other-name">baseSize</span> = QSize (QSize at: 0x0)</dt></dl>
<dl><dt><span class="other-name">blockSignals</span> = &lt;unbound qt slot blockSignals of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-blockSignals">blockSignals</a>(a, b) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">changeEvent</span> = &lt;unbound qt slot py_q_changeEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-changeEvent">changeEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">childAt</span> = &lt;unbound qt slot childAt of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-childAt">childAt</a>(a, b, c) -> PythonQt.QtGui.QWidget</pre>

</dd></dl>
<dl><dt><span class="other-name">childEvent</span> = &lt;unbound qt slot py_q_childEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-childEvent">childEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">children</span> = &lt;unbound qt slot children of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-children">children</a>(a) -> tuple</pre>

</dd></dl>
<dl><dt><span class="other-name">childrenRect</span> = QRect (QRect at: 0x0)</dt></dl>
<dl><dt><span class="other-name">childrenRegion</span> = QRegion (QRegion at: 0x0)</dt></dl>
<dl><dt><span class="other-name">className</span> = &lt;built-in method className of PythonQt.PythonQtClassWrapper object&gt;<dd>

<pre class="doc" markdown="0">Return the classname of the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl><dt><span class="other-name">clearFocus</span> = &lt;unbound qt slot clearFocus of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-clearFocus">clearFocus</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">clearMask</span> = &lt;unbound qt slot clearMask of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-clearMask">clearMask</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">close</span> = &lt;unbound qt slot close of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-close">close</a>() -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">closeEvent</span> = &lt;unbound qt slot py_q_closeEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-closeEvent">closeEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">colorCount</span> = &lt;unbound qt slot colorCount of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-colorCount">colorCount</a>(a) -> int</pre>

</dd></dl>
<dl><dt><span class="other-name">connect</span> = &lt;unbound qt slot connect of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-connect">connect</a>(a, b, c, d, e) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">contentsMargins</span> = &lt;unbound qt slot contentsMargins of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-contentsMargins">contentsMargins</a>(a) -> PythonQt.QtGui.QMargins</pre>

</dd></dl>
<dl><dt><span class="other-name">contentsRect</span> = &lt;unbound qt slot contentsRect of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-contentsRect">contentsRect</a>(a) -> PythonQt.QtCore.QRect</pre>

</dd></dl>
<dl><dt><span class="other-name">contextMenuEvent</span> = &lt;unbound qt slot py_q_contextMenuEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-contextMenuEvent">contextMenuEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">contextMenuPolicy</span> = None</dt></dl>
<dl><dt><span class="other-name">createWinId</span> = &lt;unbound qt slot createWinId of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-createWinId">createWinId</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">createWindowContainer</span> = &lt;unbound qt slot static_QWidget_createWindowContainer of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-createWindowContainer">createWindowContainer</a>(a, b, c) -> PythonQt.QtGui.QWidget</pre>

</dd></dl>
<dl><dt><span class="other-name">cursor</span> = QCursor (QCursor at: 0x0)</dt></dl>
<dl><dt><span class="other-name">customContextMenuRequested</span> = &lt;unbound qt signal customContextMenuRequested of YPanelWidget type&gt;</dt></dl>
<dl><dt><span class="other-name">customEvent</span> = &lt;unbound qt slot py_q_customEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-customEvent">customEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">delete</span> = &lt;built-in method delete of PythonQt.PythonQtClassWrapper object&gt;<dd>

<pre class="doc" markdown="0">Deletes the given C++ <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl><dt><span class="other-name">deleteLater</span> = &lt;unbound qt slot deleteLater of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-deleteLater">deleteLater</a>()</pre>

</dd></dl>
<dl><dt><span class="other-name">depth</span> = &lt;unbound qt slot depth of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-depth">depth</a>(a) -> int</pre>

</dd></dl>
<dl><dt><span class="other-name">destroy</span> = &lt;unbound qt slot destroy of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-destroy">destroy</a>(a, b, c)</pre>

</dd></dl>
<dl><dt><span class="other-name">destroyed</span> = &lt;unbound qt signal destroyed of YPanelWidget type&gt;</dt></dl>
<dl><dt><span class="other-name">devType</span> = &lt;unbound qt slot py_q_devType of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-devType">devType</a>(a) -> int</pre>

</dd></dl>
<dl><dt><span class="other-name">devicePixelRatio</span> = &lt;unbound qt slot devicePixelRatio of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-devicePixelRatio">devicePixelRatio</a>(a) -> int</pre>

</dd></dl>
<dl><dt><span class="other-name">devicePixelRatioF</span> = &lt;unbound qt slot devicePixelRatioF of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-devicePixelRatioF">devicePixelRatioF</a>(a) -> float</pre>

</dd></dl>
<dl><dt><span class="other-name">devicePixelRatioFScale</span> = &lt;unbound qt slot static_QPaintDevice_devicePixelRatioFScale of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-devicePixelRatioFScale">devicePixelRatioFScale</a>() -> float</pre>

</dd></dl>
<dl><dt><span class="other-name">disconnect</span> = &lt;unbound qt slot disconnect of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-disconnect">disconnect</a>(a, b, c, d) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">dragEnterEvent</span> = &lt;unbound qt slot py_q_dragEnterEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-dragEnterEvent">dragEnterEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">dragLeaveEvent</span> = &lt;unbound qt slot py_q_dragLeaveEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-dragLeaveEvent">dragLeaveEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">dragMoveEvent</span> = &lt;unbound qt slot py_q_dragMoveEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-dragMoveEvent">dragMoveEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">dropEvent</span> = &lt;unbound qt slot py_q_dropEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-dropEvent">dropEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">dumpObjectInfo</span> = &lt;unbound qt slot dumpObjectInfo of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-dumpObjectInfo">dumpObjectInfo</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">dumpObjectTree</span> = &lt;unbound qt slot dumpObjectTree of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-dumpObjectTree">dumpObjectTree</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">dynamicPropertyNames</span> = &lt;unbound qt slot dynamicPropertyNames of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-dynamicPropertyNames">dynamicPropertyNames</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">effectiveWinId</span> = &lt;unbound qt slot effectiveWinId of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-effectiveWinId">effectiveWinId</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">enabled</span> = None</dt></dl>
<dl><dt><span class="other-name">ensurePolished</span> = &lt;unbound qt slot ensurePolished of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-ensurePolished">ensurePolished</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">enterEvent</span> = &lt;unbound qt slot py_q_enterEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-enterEvent">enterEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">event</span> = &lt;unbound qt slot py_q_event of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-event">event</a>(a, b) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">eventFilter</span> = &lt;unbound qt slot py_q_eventFilter of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-eventFilter">eventFilter</a>(a, b, c) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">findChild</span> = &lt;unbound qt slot findChild of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-findChild">findChild</a>(a, b, c) -> PythonQt.private.QObject</pre>

</dd></dl>
<dl><dt><span class="other-name">findChildren</span> = &lt;unbound qt slot findChildren of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-findChildren">findChildren</a>(a, b, c) -> tuple</pre>

</dd></dl>
<dl><dt><span class="other-name">focus</span> = None</dt></dl>
<dl><dt><span class="other-name">focusInEvent</span> = &lt;unbound qt slot py_q_focusInEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-focusInEvent">focusInEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">focusNextChild</span> = &lt;unbound qt slot focusNextChild of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-focusNextChild">focusNextChild</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">focusNextPrevChild</span> = &lt;unbound qt slot py_q_focusNextPrevChild of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-focusNextPrevChild">focusNextPrevChild</a>(a, b) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">focusOutEvent</span> = &lt;unbound qt slot py_q_focusOutEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-focusOutEvent">focusOutEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">focusPolicy</span> = None</dt></dl>
<dl><dt><span class="other-name">focusPreviousChild</span> = &lt;unbound qt slot focusPreviousChild of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-focusPreviousChild">focusPreviousChild</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">focusProxy</span> = &lt;unbound qt slot focusProxy of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-focusProxy">focusProxy</a>(a) -> PythonQt.QtGui.QWidget</pre>

</dd></dl>
<dl><dt><span class="other-name">focusWidget</span> = &lt;unbound qt slot focusWidget of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-focusWidget">focusWidget</a>(a) -> PythonQt.QtGui.QWidget</pre>

</dd></dl>
<dl><dt><span class="other-name">font</span> = QFont (QFont at: 0x0)</dt></dl>
<dl><dt><span class="other-name">foregroundRole</span> = &lt;unbound qt slot foregroundRole of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-foregroundRole">foregroundRole</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">frameGeometry</span> = QRect (QRect at: 0x0)</dt></dl>
<dl><dt><span class="other-name">frameSize</span> = QSize (QSize at: 0x0)</dt></dl>
<dl><dt><span class="other-name">fullScreen</span> = None</dt></dl>
<dl><dt><span class="other-name">geometry</span> = QRect (QRect at: 0x0)</dt></dl>
<dl><dt><span class="other-name">grab</span> = &lt;unbound qt slot grab of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-grab">grab</a>(a, b) -> PythonQt.QtGui.QPixmap</pre>

</dd></dl>
<dl><dt><span class="other-name">grabGesture</span> = &lt;unbound qt slot grabGesture of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-grabGesture">grabGesture</a>(a, b, c)</pre>

</dd></dl>
<dl><dt><span class="other-name">grabKeyboard</span> = &lt;unbound qt slot grabKeyboard of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-grabKeyboard">grabKeyboard</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">grabMouse</span> = &lt;unbound qt slot grabMouse of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-grabMouse">grabMouse</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">grabShortcut</span> = &lt;unbound qt slot grabShortcut of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-grabShortcut">grabShortcut</a>(a, b, c) -> int</pre>

</dd></dl>
<dl><dt><span class="other-name">graphicsEffect</span> = &lt;unbound qt slot graphicsEffect of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-graphicsEffect">graphicsEffect</a>(a) -> PythonQt.QtGui.QGraphicsEffect</pre>

</dd></dl>
<dl><dt><span class="other-name">graphicsProxyWidget</span> = &lt;unbound qt slot graphicsProxyWidget of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-graphicsProxyWidget">graphicsProxyWidget</a>(a) -> PythonQt.QtGui.QGraphicsProxyWidget</pre>

</dd></dl>
<dl><dt><span class="other-name">hasFocus</span> = &lt;unbound qt slot hasFocus of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-hasFocus">hasFocus</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">hasHeightForWidth</span> = &lt;unbound qt slot py_q_hasHeightForWidth of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-hasHeightForWidth">hasHeightForWidth</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">hasMouseTracking</span> = &lt;unbound qt slot hasMouseTracking of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-hasMouseTracking">hasMouseTracking</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">height</span> = None</dt></dl>
<dl><dt><span class="other-name">heightForWidth</span> = &lt;unbound qt slot py_q_heightForWidth of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-heightForWidth">heightForWidth</a>(a, b) -> int</pre>

</dd></dl>
<dl><dt><span class="other-name">heightMM</span> = &lt;unbound qt slot heightMM of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-heightMM">heightMM</a>(a) -> int</pre>

</dd></dl>
<dl><dt><span class="other-name">help</span> = &lt;built-in method help of PythonQt.PythonQtClassWrapper object&gt;<dd>

<pre class="doc" markdown="0">Shows the help of available methods for this class</pre>

</dd></dl>
<dl><dt><span class="other-name">hide</span> = &lt;unbound qt slot hide of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-hide">hide</a>()</pre>

</dd></dl>
<dl><dt><span class="other-name">hideEvent</span> = &lt;unbound qt slot py_q_hideEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-hideEvent">hideEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">inherits</span> = &lt;built-in method inherits of PythonQt.PythonQtClassWrapper object&gt;<dd>

<pre class="doc" markdown="0">Returns if the class inherits or is of given type name</pre>

</dd></dl>
<dl><dt><span class="other-name">initPainter</span> = &lt;unbound qt slot py_q_initPainter of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-initPainter">initPainter</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">inputMethodEvent</span> = &lt;unbound qt slot py_q_inputMethodEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-inputMethodEvent">inputMethodEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">inputMethodHints</span> = None</dt></dl>
<dl><dt><span class="other-name">inputMethodQuery</span> = &lt;unbound qt slot py_q_inputMethodQuery of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-inputMethodQuery">inputMethodQuery</a>(a, b) -> <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl><dt><span class="other-name">insertAction</span> = &lt;unbound qt slot insertAction of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-insertAction">insertAction</a>(a, b, c)</pre>

</dd></dl>
<dl><dt><span class="other-name">insertActions</span> = &lt;unbound qt slot insertActions of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-insertActions">insertActions</a>(a, b, c)</pre>

</dd></dl>
<dl><dt><span class="other-name">installEventFilter</span> = &lt;unbound qt slot installEventFilter of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-installEventFilter">installEventFilter</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">isActiveWindow</span> = None</dt></dl>
<dl><dt><span class="other-name">isAncestorOf</span> = &lt;unbound qt slot isAncestorOf of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-isAncestorOf">isAncestorOf</a>(a, b) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">isEnabled</span> = &lt;unbound qt slot isEnabled of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-isEnabled">isEnabled</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">isEnabledTo</span> = &lt;unbound qt slot isEnabledTo of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-isEnabledTo">isEnabledTo</a>(a, b) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">isFullScreen</span> = &lt;unbound qt slot isFullScreen of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-isFullScreen">isFullScreen</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">isHidden</span> = &lt;unbound qt slot isHidden of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-isHidden">isHidden</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">isLeftToRight</span> = &lt;unbound qt slot isLeftToRight of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-isLeftToRight">isLeftToRight</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">isMaximized</span> = &lt;unbound qt slot isMaximized of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-isMaximized">isMaximized</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">isMinimized</span> = &lt;unbound qt slot isMinimized of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-isMinimized">isMinimized</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">isModal</span> = &lt;unbound qt slot isModal of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-isModal">isModal</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">isRightToLeft</span> = &lt;unbound qt slot isRightToLeft of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-isRightToLeft">isRightToLeft</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">isSignalConnected</span> = &lt;unbound qt slot isSignalConnected of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-isSignalConnected">isSignalConnected</a>(a, b) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">isVisible</span> = &lt;unbound qt slot isVisible of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-isVisible">isVisible</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">isVisibleTo</span> = &lt;unbound qt slot isVisibleTo of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-isVisibleTo">isVisibleTo</a>(a, b) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">isWidgetType</span> = &lt;unbound qt slot isWidgetType of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-isWidgetType">isWidgetType</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">isWindow</span> = &lt;unbound qt slot isWindow of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-isWindow">isWindow</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">isWindowModified</span> = &lt;unbound qt slot isWindowModified of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-isWindowModified">isWindowModified</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">isWindowType</span> = &lt;unbound qt slot isWindowType of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-isWindowType">isWindowType</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">keyPressEvent</span> = &lt;unbound qt slot py_q_keyPressEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-keyPressEvent">keyPressEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">keyReleaseEvent</span> = &lt;unbound qt slot py_q_keyReleaseEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-keyReleaseEvent">keyReleaseEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">keyboardGrabber</span> = &lt;unbound qt slot static_QWidget_keyboardGrabber of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-keyboardGrabber">keyboardGrabber</a>() -> PythonQt.QtGui.QWidget</pre>

</dd></dl>
<dl><dt><span class="other-name">killTimer</span> = &lt;unbound qt slot killTimer of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-killTimer">killTimer</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">layout</span> = &lt;unbound qt slot layout of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-layout">layout</a>(a) -> PythonQt.QtGui.QLayout</pre>

</dd></dl>
<dl><dt><span class="other-name">layoutDirection</span> = None</dt></dl>
<dl><dt><span class="other-name">leaveEvent</span> = &lt;unbound qt slot py_q_leaveEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-leaveEvent">leaveEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">locale</span> = QLocale (QLocale at: 0x0)</dt></dl>
<dl><dt><span class="other-name">logicalDpiX</span> = &lt;unbound qt slot logicalDpiX of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-logicalDpiX">logicalDpiX</a>(a) -> int</pre>

</dd></dl>
<dl><dt><span class="other-name">logicalDpiY</span> = &lt;unbound qt slot logicalDpiY of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-logicalDpiY">logicalDpiY</a>(a) -> int</pre>

</dd></dl>
<dl><dt><span class="other-name">lower</span> = &lt;unbound qt slot lower of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-lower">lower</a>()</pre>

</dd></dl>
<dl><dt><span class="other-name">mapFrom</span> = &lt;unbound qt slot mapFrom of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-mapFrom">mapFrom</a>(a, b, c) -> PythonQt.QtCore.QPoint</pre>

</dd></dl>
<dl><dt><span class="other-name">mapFromGlobal</span> = &lt;unbound qt slot mapFromGlobal of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-mapFromGlobal">mapFromGlobal</a>(a, b) -> PythonQt.QtCore.QPoint</pre>

</dd></dl>
<dl><dt><span class="other-name">mapFromParent</span> = &lt;unbound qt slot mapFromParent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-mapFromParent">mapFromParent</a>(a, b) -> PythonQt.QtCore.QPoint</pre>

</dd></dl>
<dl><dt><span class="other-name">mapTo</span> = &lt;unbound qt slot mapTo of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-mapTo">mapTo</a>(a, b, c) -> PythonQt.QtCore.QPoint</pre>

</dd></dl>
<dl><dt><span class="other-name">mapToGlobal</span> = &lt;unbound qt slot mapToGlobal of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-mapToGlobal">mapToGlobal</a>(a, b) -> PythonQt.QtCore.QPoint</pre>

</dd></dl>
<dl><dt><span class="other-name">mapToParent</span> = &lt;unbound qt slot mapToParent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-mapToParent">mapToParent</a>(a, b) -> PythonQt.QtCore.QPoint</pre>

</dd></dl>
<dl><dt><span class="other-name">mask</span> = &lt;unbound qt slot mask of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-mask">mask</a>(a) -> PythonQt.QtGui.QRegion</pre>

</dd></dl>
<dl><dt><span class="other-name">maximized</span> = None</dt></dl>
<dl><dt><span class="other-name">maximumHeight</span> = None</dt></dl>
<dl><dt><span class="other-name">maximumSize</span> = QSize (QSize at: 0x0)</dt></dl>
<dl><dt><span class="other-name">maximumWidth</span> = None</dt></dl>
<dl><dt><span class="other-name">metaObject</span> = &lt;unbound qt slot metaObject of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-metaObject">metaObject</a>(a) -> PythonQt.QtCore.QMetaObject</pre>

</dd></dl>
<dl><dt><span class="other-name">metric</span> = &lt;unbound qt slot py_q_metric of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-metric">metric</a>(a, b) -> int</pre>

</dd></dl>
<dl><dt><span class="other-name">minimized</span> = None</dt></dl>
<dl><dt><span class="other-name">minimumHeight</span> = None</dt></dl>
<dl><dt><span class="other-name">minimumSize</span> = QSize (QSize at: 0x0)</dt></dl>
<dl><dt><span class="other-name">minimumSizeHint</span> = QSize (QSize at: 0x0)</dt></dl>
<dl><dt><span class="other-name">minimumWidth</span> = None</dt></dl>
<dl><dt><span class="other-name">modal</span> = None</dt></dl>
<dl><dt><span class="other-name">mouseDoubleClickEvent</span> = &lt;unbound qt slot py_q_mouseDoubleClickEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-mouseDoubleClickEvent">mouseDoubleClickEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">mouseGrabber</span> = &lt;unbound qt slot static_QWidget_mouseGrabber of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-mouseGrabber">mouseGrabber</a>() -> PythonQt.QtGui.QWidget</pre>

</dd></dl>
<dl><dt><span class="other-name">mouseMoveEvent</span> = &lt;unbound qt slot py_q_mouseMoveEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-mouseMoveEvent">mouseMoveEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">mousePressEvent</span> = &lt;unbound qt slot py_q_mousePressEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-mousePressEvent">mousePressEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">mouseReleaseEvent</span> = &lt;unbound qt slot py_q_mouseReleaseEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-mouseReleaseEvent">mouseReleaseEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">mouseTracking</span> = None</dt></dl>
<dl><dt><span class="other-name">move</span> = &lt;unbound qt slot move of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-move">move</a>(a, b, c)</pre>

</dd></dl>
<dl><dt><span class="other-name">moveEvent</span> = &lt;unbound qt slot py_q_moveEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-moveEvent">moveEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">moveToThread</span> = &lt;unbound qt slot moveToThread of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-moveToThread">moveToThread</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">nativeEvent</span> = &lt;unbound qt slot py_q_nativeEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-nativeEvent">nativeEvent</a>(a, b, c, d) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">nativeParentWidget</span> = &lt;unbound qt slot nativeParentWidget of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-nativeParentWidget">nativeParentWidget</a>(a) -> PythonQt.QtGui.QWidget</pre>

</dd></dl>
<dl><dt><span class="other-name">nextInFocusChain</span> = &lt;unbound qt slot nextInFocusChain of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-nextInFocusChain">nextInFocusChain</a>(a) -> PythonQt.QtGui.QWidget</pre>

</dd></dl>
<dl><dt><span class="other-name">normalGeometry</span> = QRect (QRect at: 0x0)</dt></dl>
<dl><dt><span class="other-name">objectName</span> = None</dt></dl>
<dl><dt><span class="other-name">objectNameChanged</span> = &lt;unbound qt signal objectNameChanged of YPanelWidget type&gt;</dt></dl>
<dl><dt><span class="other-name">overrideWindowFlags</span> = &lt;unbound qt slot overrideWindowFlags of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-overrideWindowFlags">overrideWindowFlags</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">overrideWindowState</span> = &lt;unbound qt slot overrideWindowState of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-overrideWindowState">overrideWindowState</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">paintEngine</span> = &lt;unbound qt slot py_q_paintEngine of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-paintEngine">paintEngine</a>(a) -> PythonQt.QtGui.QPaintEngine</pre>

</dd></dl>
<dl><dt><span class="other-name">paintEvent</span> = &lt;unbound qt slot py_q_paintEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-paintEvent">paintEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">paintingActive</span> = &lt;unbound qt slot paintingActive of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-paintingActive">paintingActive</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">palette</span> = QPalette (QPalette at: 0x0)</dt></dl>
<dl><dt><span class="other-name">parent</span> = &lt;unbound qt slot parent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-parent">parent</a>(a) -> PythonQt.private.QObject</pre>

</dd></dl>
<dl><dt><span class="other-name">parentWidget</span> = &lt;unbound qt slot parentWidget of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-parentWidget">parentWidget</a>(a) -> PythonQt.QtGui.QWidget</pre>

</dd></dl>
<dl><dt><span class="other-name">physicalDpiX</span> = &lt;unbound qt slot physicalDpiX of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-physicalDpiX">physicalDpiX</a>(a) -> int</pre>

</dd></dl>
<dl><dt><span class="other-name">physicalDpiY</span> = &lt;unbound qt slot physicalDpiY of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-physicalDpiY">physicalDpiY</a>(a) -> int</pre>

</dd></dl>
<dl><dt><span class="other-name">pos</span> = QPoint (QPoint at: 0x0)</dt></dl>
<dl><dt><span class="other-name">previousInFocusChain</span> = &lt;unbound qt slot previousInFocusChain of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-previousInFocusChain">previousInFocusChain</a>(a) -> PythonQt.QtGui.QWidget</pre>

</dd></dl>
<dl><dt><span class="other-name">property</span> = &lt;unbound qt slot property of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-property">property</a>(a, b) -> <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl><dt><span class="other-name">raise</span> = &lt;unbound qt slot raise of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-raise">raise</a>()</pre>

</dd></dl>
<dl><dt><span class="other-name">rect</span> = QRect (QRect at: 0x0)</dt></dl>
<dl><dt><span class="other-name">redirected</span> = &lt;unbound qt slot py_q_redirected of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-redirected">redirected</a>(a, b) -> PythonQt.QtGui.QPaintDevice</pre>

</dd></dl>
<dl><dt><span class="other-name">releaseKeyboard</span> = &lt;unbound qt slot releaseKeyboard of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-releaseKeyboard">releaseKeyboard</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">releaseMouse</span> = &lt;unbound qt slot releaseMouse of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-releaseMouse">releaseMouse</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">releaseShortcut</span> = &lt;unbound qt slot releaseShortcut of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-releaseShortcut">releaseShortcut</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">removeAction</span> = &lt;unbound qt slot removeAction of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-removeAction">removeAction</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">removeEventFilter</span> = &lt;unbound qt slot removeEventFilter of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-removeEventFilter">removeEventFilter</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">render</span> = &lt;unbound qt slot render of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-render">render</a>(a, b, c, d, e)</pre>

</dd></dl>
<dl><dt><span class="other-name">repaint</span> = &lt;unbound qt slot repaint of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-repaint">repaint</a>(a, b, c, d, e)</pre>

</dd></dl>
<dl><dt><span class="other-name">resize</span> = &lt;unbound qt slot resize of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-resize">resize</a>(a, b, c)</pre>

</dd></dl>
<dl><dt><span class="other-name">resizeEvent</span> = &lt;unbound qt slot py_q_resizeEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-resizeEvent">resizeEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">restoreGeometry</span> = &lt;unbound qt slot restoreGeometry of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-restoreGeometry">restoreGeometry</a>(a, b) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">saveGeometry</span> = &lt;unbound qt slot saveGeometry of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-saveGeometry">saveGeometry</a>(a) -> PythonQt.QtCore.QByteArray</pre>

</dd></dl>
<dl><dt><span class="other-name">scroll</span> = &lt;unbound qt slot scroll of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-scroll">scroll</a>(a, b, c, d)</pre>

</dd></dl>
<dl><dt><span class="other-name">sender</span> = &lt;unbound qt slot sender of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-sender">sender</a>(a) -> PythonQt.private.QObject</pre>

</dd></dl>
<dl><dt><span class="other-name">senderSignalIndex</span> = &lt;unbound qt slot senderSignalIndex of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-senderSignalIndex">senderSignalIndex</a>(a) -> int</pre>

</dd></dl>
<dl><dt><span class="other-name">setAcceptDrops</span> = &lt;unbound qt slot setAcceptDrops of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setAcceptDrops">setAcceptDrops</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setAccessibleDescription</span> = &lt;unbound qt slot setAccessibleDescription of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setAccessibleDescription">setAccessibleDescription</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setAccessibleName</span> = &lt;unbound qt slot setAccessibleName of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setAccessibleName">setAccessibleName</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setAttribute</span> = &lt;unbound qt slot setAttribute of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setAttribute">setAttribute</a>(a, b, c)</pre>

</dd></dl>
<dl><dt><span class="other-name">setAutoFillBackground</span> = &lt;unbound qt slot setAutoFillBackground of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setAutoFillBackground">setAutoFillBackground</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setBackgroundRole</span> = &lt;unbound qt slot setBackgroundRole of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setBackgroundRole">setBackgroundRole</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setBaseSize</span> = &lt;unbound qt slot setBaseSize of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setBaseSize">setBaseSize</a>(a, b, c)</pre>

</dd></dl>
<dl><dt><span class="other-name">setContentsMargins</span> = &lt;unbound qt slot setContentsMargins of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setContentsMargins">setContentsMargins</a>(a, b, c, d, e)</pre>

</dd></dl>
<dl><dt><span class="other-name">setContextMenuPolicy</span> = &lt;unbound qt slot setContextMenuPolicy of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setContextMenuPolicy">setContextMenuPolicy</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setCursor</span> = &lt;unbound qt slot setCursor of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setCursor">setCursor</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setDisabled</span> = &lt;unbound qt slot setDisabled of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setDisabled">setDisabled</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">setEnabled</span> = &lt;unbound qt slot setEnabled of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setEnabled">setEnabled</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">setFixedHeight</span> = &lt;unbound qt slot setFixedHeight of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setFixedHeight">setFixedHeight</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setFixedSize</span> = &lt;unbound qt slot setFixedSize of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setFixedSize">setFixedSize</a>(a, b, c)</pre>

</dd></dl>
<dl><dt><span class="other-name">setFixedWidth</span> = &lt;unbound qt slot setFixedWidth of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setFixedWidth">setFixedWidth</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setFocus</span> = &lt;unbound qt slot setFocus of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setFocus">setFocus</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setFocusPolicy</span> = &lt;unbound qt slot setFocusPolicy of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setFocusPolicy">setFocusPolicy</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setFocusProxy</span> = &lt;unbound qt slot setFocusProxy of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setFocusProxy">setFocusProxy</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setFont</span> = &lt;unbound qt slot setFont of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setFont">setFont</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setForegroundRole</span> = &lt;unbound qt slot setForegroundRole of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setForegroundRole">setForegroundRole</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setGeometry</span> = &lt;unbound qt slot setGeometry of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setGeometry">setGeometry</a>(a, b, c, d, e)</pre>

</dd></dl>
<dl><dt><span class="other-name">setGraphicsEffect</span> = &lt;unbound qt slot setGraphicsEffect of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setGraphicsEffect">setGraphicsEffect</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setHidden</span> = &lt;unbound qt slot setHidden of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setHidden">setHidden</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">setInputMethodHints</span> = &lt;unbound qt slot setInputMethodHints of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setInputMethodHints">setInputMethodHints</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setLayout</span> = &lt;unbound qt slot setLayout of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setLayout">setLayout</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setLayoutDirection</span> = &lt;unbound qt slot setLayoutDirection of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setLayoutDirection">setLayoutDirection</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setLocale</span> = &lt;unbound qt slot setLocale of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setLocale">setLocale</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setMask</span> = &lt;unbound qt slot setMask of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setMask">setMask</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setMaximumHeight</span> = &lt;unbound qt slot setMaximumHeight of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setMaximumHeight">setMaximumHeight</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setMaximumSize</span> = &lt;unbound qt slot setMaximumSize of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setMaximumSize">setMaximumSize</a>(a, b, c)</pre>

</dd></dl>
<dl><dt><span class="other-name">setMaximumWidth</span> = &lt;unbound qt slot setMaximumWidth of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setMaximumWidth">setMaximumWidth</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setMinimumHeight</span> = &lt;unbound qt slot setMinimumHeight of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setMinimumHeight">setMinimumHeight</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setMinimumSize</span> = &lt;unbound qt slot setMinimumSize of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setMinimumSize">setMinimumSize</a>(a, b, c)</pre>

</dd></dl>
<dl><dt><span class="other-name">setMinimumWidth</span> = &lt;unbound qt slot setMinimumWidth of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setMinimumWidth">setMinimumWidth</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setMouseTracking</span> = &lt;unbound qt slot setMouseTracking of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setMouseTracking">setMouseTracking</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setObjectName</span> = &lt;unbound qt slot setObjectName of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setObjectName">setObjectName</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setPalette</span> = &lt;unbound qt slot setPalette of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setPalette">setPalette</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setParent</span> = &lt;unbound qt slot setParent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setParent">setParent</a>(a, b, c)</pre>

</dd></dl>
<dl><dt><span class="other-name">setProperty</span> = &lt;unbound qt slot setProperty of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setProperty">setProperty</a>(a, b, c) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">setShortcutAutoRepeat</span> = &lt;unbound qt slot setShortcutAutoRepeat of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setShortcutAutoRepeat">setShortcutAutoRepeat</a>(a, b, c)</pre>

</dd></dl>
<dl><dt><span class="other-name">setShortcutEnabled</span> = &lt;unbound qt slot setShortcutEnabled of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setShortcutEnabled">setShortcutEnabled</a>(a, b, c)</pre>

</dd></dl>
<dl><dt><span class="other-name">setSizeIncrement</span> = &lt;unbound qt slot setSizeIncrement of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setSizeIncrement">setSizeIncrement</a>(a, b, c)</pre>

</dd></dl>
<dl><dt><span class="other-name">setSizePolicy</span> = &lt;unbound qt slot setSizePolicy of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setSizePolicy">setSizePolicy</a>(a, b, c)</pre>

</dd></dl>
<dl><dt><span class="other-name">setStatusTip</span> = &lt;unbound qt slot setStatusTip of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setStatusTip">setStatusTip</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setStyle</span> = &lt;unbound qt slot setStyle of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setStyle">setStyle</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setStyleSheet</span> = &lt;unbound qt slot setStyleSheet of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setStyleSheet">setStyleSheet</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">setTabOrder</span> = &lt;unbound qt slot static_QWidget_setTabOrder of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setTabOrder">setTabOrder</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setToolTip</span> = &lt;unbound qt slot setToolTip of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setToolTip">setToolTip</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setToolTipDuration</span> = &lt;unbound qt slot setToolTipDuration of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setToolTipDuration">setToolTipDuration</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setUpdatesEnabled</span> = &lt;unbound qt slot setUpdatesEnabled of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setUpdatesEnabled">setUpdatesEnabled</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setVisible</span> = &lt;unbound qt slot py_q_setVisible of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setVisible">setVisible</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setWhatsThis</span> = &lt;unbound qt slot setWhatsThis of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setWhatsThis">setWhatsThis</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setWindowFilePath</span> = &lt;unbound qt slot setWindowFilePath of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setWindowFilePath">setWindowFilePath</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setWindowFlags</span> = &lt;unbound qt slot setWindowFlags of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setWindowFlags">setWindowFlags</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setWindowIcon</span> = &lt;unbound qt slot setWindowIcon of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setWindowIcon">setWindowIcon</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setWindowIconText</span> = &lt;unbound qt slot setWindowIconText of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setWindowIconText">setWindowIconText</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setWindowModality</span> = &lt;unbound qt slot setWindowModality of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setWindowModality">setWindowModality</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setWindowModified</span> = &lt;unbound qt slot setWindowModified of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setWindowModified">setWindowModified</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">setWindowOpacity</span> = &lt;unbound qt slot setWindowOpacity of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setWindowOpacity">setWindowOpacity</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setWindowRole</span> = &lt;unbound qt slot setWindowRole of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setWindowRole">setWindowRole</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setWindowState</span> = &lt;unbound qt slot setWindowState of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setWindowState">setWindowState</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">setWindowTitle</span> = &lt;unbound qt slot setWindowTitle of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-setWindowTitle">setWindowTitle</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">sharedPainter</span> = &lt;unbound qt slot py_q_sharedPainter of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-sharedPainter">sharedPainter</a>(a) -> PythonQt.QtGui.QPainter</pre>

</dd></dl>
<dl><dt><span class="other-name">show</span> = &lt;unbound qt slot show of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-show">show</a>()</pre>

</dd></dl>
<dl><dt><span class="other-name">showEvent</span> = &lt;unbound qt slot py_q_showEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-showEvent">showEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">showFullScreen</span> = &lt;unbound qt slot showFullScreen of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-showFullScreen">showFullScreen</a>()</pre>

</dd></dl>
<dl><dt><span class="other-name">showMaximized</span> = &lt;unbound qt slot showMaximized of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-showMaximized">showMaximized</a>()</pre>

</dd></dl>
<dl><dt><span class="other-name">showMinimized</span> = &lt;unbound qt slot showMinimized of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-showMinimized">showMinimized</a>()</pre>

</dd></dl>
<dl><dt><span class="other-name">showNormal</span> = &lt;unbound qt slot showNormal of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-showNormal">showNormal</a>()</pre>

</dd></dl>
<dl><dt><span class="other-name">signalsBlocked</span> = &lt;unbound qt slot signalsBlocked of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-signalsBlocked">signalsBlocked</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">size</span> = QSize (QSize at: 0x0)</dt></dl>
<dl><dt><span class="other-name">sizeHint</span> = QSize (QSize at: 0x0)</dt></dl>
<dl><dt><span class="other-name">sizeIncrement</span> = QSize (QSize at: 0x0)</dt></dl>
<dl><dt><span class="other-name">sizePolicy</span> = QSizePolicy (QSizePolicy at: 0x0)</dt></dl>
<dl><dt><span class="other-name">stackUnder</span> = &lt;unbound qt slot stackUnder of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-stackUnder">stackUnder</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">startTimer</span> = &lt;unbound qt slot startTimer of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-startTimer">startTimer</a>(a, b, c) -> int</pre>

</dd></dl>
<dl><dt><span class="other-name">statusTip</span> = None</dt></dl>
<dl><dt><span class="other-name">style</span> = &lt;unbound qt slot style of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-style">style</a>(a) -> PythonQt.QtGui.QStyle</pre>

</dd></dl>
<dl><dt><span class="other-name">styleSheet</span> = None</dt></dl>
<dl><dt><span class="other-name">tabletEvent</span> = &lt;unbound qt slot py_q_tabletEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-tabletEvent">tabletEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">tabletTracking</span> = None</dt></dl>
<dl><dt><span class="other-name">testAttribute</span> = &lt;unbound qt slot testAttribute of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-testAttribute">testAttribute</a>(a, b) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">thread</span> = &lt;unbound qt slot thread of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-thread">thread</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">timerEvent</span> = &lt;unbound qt slot py_q_timerEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-timerEvent">timerEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">toolTip</span> = None</dt></dl>
<dl><dt><span class="other-name">toolTipDuration</span> = None</dt></dl>
<dl><dt><span class="other-name">tr</span> = &lt;unbound qt slot tr of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-tr">tr</a>(a, b, c, d) -> str</pre>

</dd></dl>
<dl><dt><span class="other-name">underMouse</span> = &lt;unbound qt slot underMouse of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-underMouse">underMouse</a>(a) -> bool</pre>

</dd></dl>
<dl><dt><span class="other-name">ungrabGesture</span> = &lt;unbound qt slot ungrabGesture of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-ungrabGesture">ungrabGesture</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">unsetCursor</span> = &lt;unbound qt slot unsetCursor of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-unsetCursor">unsetCursor</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">unsetLayoutDirection</span> = &lt;unbound qt slot unsetLayoutDirection of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-unsetLayoutDirection">unsetLayoutDirection</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">unsetLocale</span> = &lt;unbound qt slot unsetLocale of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-unsetLocale">unsetLocale</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">update</span> = &lt;unbound qt slot update of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-update">update</a>(a, b, c, d, e)</pre>

</dd></dl>
<dl><dt><span class="other-name">updateGeometry</span> = &lt;unbound qt slot updateGeometry of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-updateGeometry">updateGeometry</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">updatesEnabled</span> = None</dt></dl>
<dl><dt><span class="other-name">visible</span> = None</dt></dl>
<dl><dt><span class="other-name">visibleRegion</span> = &lt;unbound qt slot visibleRegion of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-visibleRegion">visibleRegion</a>(a) -> PythonQt.QtGui.QRegion</pre>

</dd></dl>
<dl><dt><span class="other-name">whatsThis</span> = None</dt></dl>
<dl><dt><span class="other-name">wheelEvent</span> = &lt;unbound qt slot py_q_wheelEvent of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-wheelEvent">wheelEvent</a>(a, b)</pre>

</dd></dl>
<dl><dt><span class="other-name">width</span> = None</dt></dl>
<dl><dt><span class="other-name">widthMM</span> = &lt;unbound qt slot widthMM of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-widthMM">widthMM</a>(a) -> int</pre>

</dd></dl>
<dl><dt><span class="other-name">winId</span> = &lt;unbound qt slot winId of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-winId">winId</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">window</span> = &lt;unbound qt slot window of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-window">window</a>(a) -> PythonQt.QtGui.QWidget</pre>

</dd></dl>
<dl><dt><span class="other-name">windowFilePath</span> = None</dt></dl>
<dl><dt><span class="other-name">windowFlags</span> = &lt;unbound qt slot windowFlags of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-windowFlags">windowFlags</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">windowHandle</span> = &lt;unbound qt slot windowHandle of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-windowHandle">windowHandle</a>(a) -> PythonQt.QtGui.QWindow</pre>

</dd></dl>
<dl><dt><span class="other-name">windowIcon</span> = QIcon (QIcon at: 0x0)</dt></dl>
<dl><dt><span class="other-name">windowIconChanged</span> = &lt;unbound qt signal windowIconChanged of YPanelWidget type&gt;</dt></dl>
<dl><dt><span class="other-name">windowIconText</span> = None</dt></dl>
<dl><dt><span class="other-name">windowIconTextChanged</span> = &lt;unbound qt signal windowIconTextChanged of YPanelWidget type&gt;</dt></dl>
<dl><dt><span class="other-name">windowModality</span> = None</dt></dl>
<dl><dt><span class="other-name">windowModified</span> = None</dt></dl>
<dl><dt><span class="other-name">windowOpacity</span> = None</dt></dl>
<dl><dt><span class="other-name">windowRole</span> = &lt;unbound qt slot windowRole of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-windowRole">windowRole</a>(a) -> str</pre>

</dd></dl>
<dl><dt><span class="other-name">windowState</span> = &lt;unbound qt slot windowState of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-windowState">windowState</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">windowTitle</span> = None</dt></dl>
<dl><dt><span class="other-name">windowTitleChanged</span> = &lt;unbound qt signal windowTitleChanged of YPanelWidget type&gt;</dt></dl>
<dl><dt><span class="other-name">windowType</span> = &lt;unbound qt slot windowType of YPanelWidget type&gt;<dd>

<pre class="doc" markdown="0">X.<a href="#YPanelWidget-windowType">windowType</a>(a)</pre>

</dd></dl>
<dl><dt><span class="other-name">x</span> = None</dt></dl>
<dl><dt><span class="other-name">y</span> = None</dt></dl>

  <h4 class="head-methods">Methods from PythonQt.PythonQtInstanceWrapper</h4><dl class="function"><dt><a name="YPanelWidget-__delattr__" href="#YPanelWidget-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelWidget-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelWidget-__eq__" href="#YPanelWidget-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelWidget-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelWidget-__ge__" href="#YPanelWidget-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelWidget-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelWidget-__getattribute__" href="#YPanelWidget-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelWidget-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelWidget-__gt__" href="#YPanelWidget-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelWidget-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelWidget-__hash__" href="#YPanelWidget-__hash__"><span class="function-name">__hash__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelWidget-__hash__">__hash__</a>() <==> hash(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelWidget-__init__" href="#YPanelWidget-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelWidget-__init__">__init__</a>(...) initializes x; see <a href="#YPanelWidget-help">help</a>(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelWidget-__le__" href="#YPanelWidget-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelWidget-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelWidget-__lt__" href="#YPanelWidget-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelWidget-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelWidget-__ne__" href="#YPanelWidget-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelWidget-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelWidget-__nonzero__" href="#YPanelWidget-__nonzero__"><span class="function-name">__nonzero__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelWidget-__nonzero__">__nonzero__</a>() <==> x != 0</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelWidget-__repr__" href="#YPanelWidget-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelWidget-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelWidget-__setattr__" href="#YPanelWidget-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelWidget-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="YPanelWidget-__str__" href="#YPanelWidget-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#YPanelWidget-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes from PythonQt.PythonQtInstanceWrapper</h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of PythonQt.PythonQtClassWrapper object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#YPanelWidget-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgSymbol" href="#fgSymbol">class <span class="class-name">fgSymbol</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgSymbol representation

Constructors:
  fgSymbol() - default
  fgSymbol(fgSymbol) - copy
  fgSymbol(unicode)
  fgSymbol('name')
  fgSymbol(id, fgFont)
  fgSymbol(glyph_id, package_id)
  fgSymbol(unicode, 'name', id)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgSymbol-__delattr__" href="#fgSymbol-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgSymbol-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbol-__getattribute__" href="#fgSymbol-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgSymbol-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbol-__init__" href="#fgSymbol-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgSymbol-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbol-__repr__" href="#fgSymbol-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgSymbol-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbol-__setattr__" href="#fgSymbol-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgSymbol-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbol-clear" href="#fgSymbol-clear"><span class="function-name">clear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbol-clear">clear</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbol-clearData" href="#fgSymbol-clearData"><span class="function-name">clearData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbol-clearData">clearData</a>(DataCode)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbol-clearID" href="#fgSymbol-clearID"><span class="function-name">clearID</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbol-clearID">clearID</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbol-compare" href="#fgSymbol-compare"><span class="function-name">compare</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgSymbol-compare">compare</a>(<a href="#fgSymbol">fgSymbol</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbol-computeID" href="#fgSymbol-computeID"><span class="function-name">computeID</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgSymbol-computeID">computeID</a>(fgFont)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbol-containsData" href="#fgSymbol-containsData"><span class="function-name">containsData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgSymbol-containsData">containsData</a>(DataCode)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbol-data" href="#fgSymbol-data"><span class="function-name">data</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QVariant <a href="#fgSymbol-data">data</a>(DataCode)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbol-glyph" href="#fgSymbol-glyph"><span class="function-name">glyph</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">fgGlyph <a href="#fgSymbol-glyph">glyph</a>(fgFont, bool setId)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbol-init" href="#fgSymbol-init"><span class="function-name">init</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbol-init">init</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbol-setData" href="#fgSymbol-setData"><span class="function-name">setData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbol-setData">setData</a>(DataCode, QVariant d)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbol-setSterile" href="#fgSymbol-setSterile"><span class="function-name">setSterile</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbol-setSterile">setSterile</a>()</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>cr</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>empty</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>glyphIndex</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasName</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasUnicode</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">unsigned long</pre>

</dd>
</dl>
<dl class="descriptor"><dt>layerName</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>ligatureIndex</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">QString</pre>

</dd>
</dl>
<dl class="descriptor"><dt>pid</dt>
<dd>

<pre class="doc" markdown="0">unsigned long</pre>

</dd>
</dl>
<dl class="descriptor"><dt>space</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>unicode</dt>
<dd>

<pre class="doc" markdown="0">uint</pre>

</dd>
</dl>
<dl class="descriptor"><dt>unicodeEnsure</dt>
<dd>

<pre class="doc" markdown="0">uint</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">DataCode</span> = {'Active': 9, 'ColorMark': 10, 'DoFeatures': 6, 'DoLayout': 5, 'Features': 7, 'FontSize': 3, 'GlyphIndex': 0, 'LigatureIndex': 1, 'Locked': 2, 'PackageID': 4, ...}</dt></dl>
<dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgSymbol-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgSymbolList" href="#fgSymbolList">class <span class="class-name">fgSymbolList</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgSymbolList representation

Constructors:
  fgSymbolList() - default
  fgSymbolList(fgSymbolList) - copy
  fgSymbolList(list(fgSymbol))
  fgSymbolList(string[, bool advancedProcessing = false])
  fgSymbolList(fgSymbolList, int len)
  fgSymbolList(fgFont, fgGlyphIDsSet)
  fgSymbolList(fgFont, list(glyph_id))</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgSymbolList-__add__" href="#fgSymbolList-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgSymbolList-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-__delattr__" href="#fgSymbolList-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgSymbolList-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-__delitem__" href="#fgSymbolList-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgSymbolList-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-__delslice__" href="#fgSymbolList-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgSymbolList-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-__getattribute__" href="#fgSymbolList-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgSymbolList-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-__getitem__" href="#fgSymbolList-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgSymbolList-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-__getslice__" href="#fgSymbolList-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgSymbolList-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-__init__" href="#fgSymbolList-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgSymbolList-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-__len__" href="#fgSymbolList-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgSymbolList-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-__mul__" href="#fgSymbolList-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgSymbolList-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-__repr__" href="#fgSymbolList-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgSymbolList-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-__rmul__" href="#fgSymbolList-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgSymbolList-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-__setattr__" href="#fgSymbolList-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgSymbolList-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-__setitem__" href="#fgSymbolList-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgSymbolList-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-__setslice__" href="#fgSymbolList-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgSymbolList-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-append" href="#fgSymbolList-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList-append">append</a>(<a href="#fgSymbol">fgSymbol</a> | <a href="#fgSymbolList">fgSymbolList</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-assign" href="#fgSymbolList-assign"><span class="function-name">assign</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList-assign">assign</a>(fgFont, list(glyphsId))</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-at" href="#fgSymbolList-at"><span class="function-name">at</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbol">fgSymbol</a> <a href="#fgSymbolList-at">at</a>(index)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-clear" href="#fgSymbolList-clear"><span class="function-name">clear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList-clear">clear</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-clearData" href="#fgSymbolList-clearData"><span class="function-name">clearData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList-clearData">clearData</a>(int dataCode)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-clearString" href="#fgSymbolList-clearString"><span class="function-name">clearString</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList-clearString">clearString</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-compare" href="#fgSymbolList-compare"><span class="function-name">compare</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgSymbolList-compare">compare</a>(<a href="#fgSymbolList">fgSymbolList</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-computeString" href="#fgSymbolList-computeString"><span class="function-name">computeString</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList-computeString">computeString</a>(bool advancedProcessing)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-data" href="#fgSymbolList-data"><span class="function-name">data</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QVariant <a href="#fgSymbolList-data">data</a>(int index, int dataCode[, QVariant v = QVariant()])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-empty" href="#fgSymbolList-empty"><span class="function-name">empty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgSymbolList-empty">empty</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-equals" href="#fgSymbolList-equals"><span class="function-name">equals</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgSymbolList-equals">equals</a>(<a href="#fgSymbolList">fgSymbolList</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-insert" href="#fgSymbolList-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList-insert">insert</a>(index, <a href="#fgSymbol">fgSymbol</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-last" href="#fgSymbolList-last"><span class="function-name">last</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbol">fgSymbol</a> <a href="#fgSymbolList-last">last</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-limitLineLength" href="#fgSymbolList-limitLineLength"><span class="function-name">limitLineLength</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgSymbolList-limitLineLength">limitLineLength</a>(int len)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-mid" href="#fgSymbolList-mid"><span class="function-name">mid</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList">fgSymbolList</a> <a href="#fgSymbolList-mid">mid</a>(int index[, int count=-1])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-remove" href="#fgSymbolList-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList-remove">remove</a>(index, count)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-replace" href="#fgSymbolList-replace"><span class="function-name">replace</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList-replace">replace</a>(index,  count, <a href="#fgSymbolList">fgSymbolList</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-reserve" href="#fgSymbolList-reserve"><span class="function-name">reserve</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList-reserve">reserve</a>(int count)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-restore" href="#fgSymbolList-restore"><span class="function-name">restore</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgSymbolList-restore">restore</a>(QByteArray, list(fgFont))</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-set" href="#fgSymbolList-set"><span class="function-name">set</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList-set">set</a>(index, <a href="#fgSymbol">fgSymbol</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-setData" href="#fgSymbolList-setData"><span class="function-name">setData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList-setData">setData</a>(index,  DataCode, QVariant)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-setGlyphsList" href="#fgSymbolList-setGlyphsList"><span class="function-name">setGlyphsList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList-setGlyphsList">setGlyphsList</a>(list(fgGlyph), fgFont)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-setIdList" href="#fgSymbolList-setIdList"><span class="function-name">setIdList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList-setIdList">setIdList</a>(list(id), fgFont)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-setList" href="#fgSymbolList-setList"><span class="function-name">setList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList-setList">setList</a>(fgSymbols list)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-setNamesList" href="#fgSymbolList-setNamesList"><span class="function-name">setNamesList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList-setNamesList">setNamesList</a>(string | QStringList)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-setSterile" href="#fgSymbolList-setSterile"><span class="function-name">setSterile</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList-setSterile">setSterile</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-setString" href="#fgSymbolList-setString"><span class="function-name">setString</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList-setString">setString</a>(string[, bool advancedProcessing = true])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-setUnicodeList" href="#fgSymbolList-setUnicodeList"><span class="function-name">setUnicodeList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList-setUnicodeList">setUnicodeList</a>( list(unicodes) )</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-size" href="#fgSymbolList-size"><span class="function-name">size</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgSymbolList-size">size</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-store" href="#fgSymbolList-store"><span class="function-name">store</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QByteArray <a href="#fgSymbolList-store">store</a>(packageID)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-string" href="#fgSymbolList-string"><span class="function-name">string</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QString <a href="#fgSymbolList-string">string</a>(bool advancedProcessing)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgSymbolList-symbols" href="#fgSymbolList-symbols"><span class="function-name">symbols</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#fgSymbol">fgSymbol</a>) <a href="#fgSymbolList-symbols">symbols</a>()</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgSymbolList-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="flAbstractEditor" href="#flAbstractEditor">class <span class="class-name">flAbstractEditor</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flAbstractEditor representation

Constructors:
  flAbstractEditor()
  flAbstractEditor(flObject)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flAbstractEditor-__delattr__" href="#flAbstractEditor-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractEditor-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-__eq__" href="#flAbstractEditor-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractEditor-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-__ge__" href="#flAbstractEditor-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractEditor-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-__getattribute__" href="#flAbstractEditor-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractEditor-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-__gt__" href="#flAbstractEditor-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractEditor-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-__init__" href="#flAbstractEditor-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractEditor-__init__">__init__</a>(...) initializes x; see help(<a href="#flAbstractEditor-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-__le__" href="#flAbstractEditor-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractEditor-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-__lt__" href="#flAbstractEditor-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractEditor-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-__ne__" href="#flAbstractEditor-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractEditor-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-__repr__" href="#flAbstractEditor-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractEditor-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-__setattr__" href="#flAbstractEditor-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractEditor-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-activate" href="#flAbstractEditor-activate"><span class="function-name">activate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-activate">activate</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-changed" href="#flAbstractEditor-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-checkInitHistoryState" href="#flAbstractEditor-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-clearAboveHistory" href="#flAbstractEditor-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-clearFlag" href="#flAbstractEditor-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-clearFlags" href="#flAbstractEditor-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-clone" href="#flAbstractEditor-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-createHistoryState" href="#flAbstractEditor-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-currentHistoryState" href="#flAbstractEditor-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-deactivate" href="#flAbstractEditor-deactivate"><span class="function-name">deactivate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-deactivate">deactivate</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-flag" href="#flAbstractEditor-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-getProperties" href="#flAbstractEditor-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-getProperty" href="#flAbstractEditor-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-getPropertyFloat" href="#flAbstractEditor-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-getPropertyInt" href="#flAbstractEditor-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-hasHistoryState" href="#flAbstractEditor-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-historyStates" href="#flAbstractEditor-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-independedAll" href="#flAbstractEditor-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-initialHistoryState" href="#flAbstractEditor-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-isEqual" href="#flAbstractEditor-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-release" href="#flAbstractEditor-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-remove" href="#flAbstractEditor-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-removeChild" href="#flAbstractEditor-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-removeProperty" href="#flAbstractEditor-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-restoreHistoryState" href="#flAbstractEditor-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-setFlag" href="#flAbstractEditor-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-setProperty" href="#flAbstractEditor-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-setPropertyFloat" href="#flAbstractEditor-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-setPropertyInt" href="#flAbstractEditor-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-tag" href="#flAbstractEditor-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-update" href="#flAbstractEditor-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractEditor-update">update</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flAbstractEditor-cloneObject" href="#flAbstractEditor-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flAbstractEditor-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-createObject" href="#flAbstractEditor-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flAbstractEditor-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-haveObject" href="#flAbstractEditor-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractEditor-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractEditor-instanceType" href="#flAbstractEditor-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flAbstractEditor-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>
<dl class="descriptor"><dt>widget</dt>
<dd>

<pre class="doc" markdown="0">QWidget*</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flAbstractEditor-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flAbstractVectorNode" href="#flAbstractVectorNode">class <span class="class-name">flAbstractVectorNode</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flAbstractVectorNode representation

Constructors:
  flAbstractVectorNode(flAbstractVectorNode)
  flAbstractVectorNode(flObject)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flAbstractVectorNode-__delattr__" href="#flAbstractVectorNode-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractVectorNode-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-__eq__" href="#flAbstractVectorNode-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractVectorNode-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-__ge__" href="#flAbstractVectorNode-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractVectorNode-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-__getattribute__" href="#flAbstractVectorNode-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractVectorNode-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-__gt__" href="#flAbstractVectorNode-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractVectorNode-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-__init__" href="#flAbstractVectorNode-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractVectorNode-__init__">__init__</a>(...) initializes x; see help(<a href="#flAbstractVectorNode-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-__le__" href="#flAbstractVectorNode-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractVectorNode-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-__lt__" href="#flAbstractVectorNode-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractVectorNode-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-__ne__" href="#flAbstractVectorNode-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractVectorNode-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-__repr__" href="#flAbstractVectorNode-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractVectorNode-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-__setattr__" href="#flAbstractVectorNode-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAbstractVectorNode-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-angleTo" href="#flAbstractVectorNode-angleTo"><span class="function-name">angleTo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flAbstractVectorNode-angleTo">angleTo</a>(QPointF p)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-applyTransform" href="#flAbstractVectorNode-applyTransform"><span class="function-name">applyTransform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-applyTransform">applyTransform</a>(QTransform)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-canBeHobby" href="#flAbstractVectorNode-canBeHobby"><span class="function-name">canBeHobby</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-canBeHobby">canBeHobby</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-canBeSmooth" href="#flAbstractVectorNode-canBeSmooth"><span class="function-name">canBeSmooth</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-canBeSmooth">canBeSmooth</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-canCollapse" href="#flAbstractVectorNode-canCollapse"><span class="function-name">canCollapse</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-canCollapse">canCollapse</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-canImprove" href="#flAbstractVectorNode-canImprove"><span class="function-name">canImprove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-canImprove">canImprove</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-changed" href="#flAbstractVectorNode-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-checkInitHistoryState" href="#flAbstractVectorNode-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-checkVectors" href="#flAbstractVectorNode-checkVectors"><span class="function-name">checkVectors</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-checkVectors">checkVectors</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-clearAboveHistory" href="#flAbstractVectorNode-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-clearFlag" href="#flAbstractVectorNode-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-clearFlags" href="#flAbstractVectorNode-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-clearStored" href="#flAbstractVectorNode-clearStored"><span class="function-name">clearStored</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-clearStored">clearStored</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-clone" href="#flAbstractVectorNode-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-cloneMapped" href="#flAbstractVectorNode-cloneMapped"><span class="function-name">cloneMapped</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode">flNode</a> <a href="#flAbstractVectorNode-cloneMapped">cloneMapped</a>(QTransform)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-collapseHandles" href="#flAbstractVectorNode-collapseHandles"><span class="function-name">collapseHandles</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-collapseHandles">collapseHandles</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-convertToCurve" href="#flAbstractVectorNode-convertToCurve"><span class="function-name">convertToCurve</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-convertToCurve">convertToCurve</a>([bool smooth = false])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-convertToCurves" href="#flAbstractVectorNode-convertToCurves"><span class="function-name">convertToCurves</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-convertToCurves">convertToCurves</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-convertToLine" href="#flAbstractVectorNode-convertToLine"><span class="function-name">convertToLine</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-convertToLine">convertToLine</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-copyFrom" href="#flAbstractVectorNode-copyFrom"><span class="function-name">copyFrom</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-copyFrom">copyFrom</a>(Node[, withSelected=False])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-createHistoryState" href="#flAbstractVectorNode-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-currentHistoryState" href="#flAbstractVectorNode-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-distanceTo" href="#flAbstractVectorNode-distanceTo"><span class="function-name">distanceTo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flAbstractVectorNode-distanceTo">distanceTo</a>(Node/QPointF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-flag" href="#flAbstractVectorNode-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-getLines" href="#flAbstractVectorNode-getLines"><span class="function-name">getLines</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(QLineF, QLineF)/None <a href="#flAbstractVectorNode-getLines">getLines</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-getOn" href="#flAbstractVectorNode-getOn"><span class="function-name">getOn</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Node/None <a href="#flAbstractVectorNode-getOn">getOn</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-getProperties" href="#flAbstractVectorNode-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-getProperty" href="#flAbstractVectorNode-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-getPropertyFloat" href="#flAbstractVectorNode-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-getPropertyInt" href="#flAbstractVectorNode-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-hasHistoryState" href="#flAbstractVectorNode-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-historyStates" href="#flAbstractVectorNode-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-improve" href="#flAbstractVectorNode-improve"><span class="function-name">improve</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-improve">improve</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-independedAll" href="#flAbstractVectorNode-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-initialHistoryState" href="#flAbstractVectorNode-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-isCorner" href="#flAbstractVectorNode-isCorner"><span class="function-name">isCorner</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-isCorner">isCorner</a>([double a = 10.])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-isCurve" href="#flAbstractVectorNode-isCurve"><span class="function-name">isCurve</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-isCurve">isCurve</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-isEqual" href="#flAbstractVectorNode-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-isEqualTo" href="#flAbstractVectorNode-isEqualTo"><span class="function-name">isEqualTo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-isEqualTo">isEqualTo</a>(Node[, tolerance=0.1[, offset=QPointF(0, 0)]])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-isExtreme" href="#flAbstractVectorNode-isExtreme"><span class="function-name">isExtreme</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-isExtreme">isExtreme</a>(bool x[, bool open = true[, double limit = 0]])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-isFirst" href="#flAbstractVectorNode-isFirst"><span class="function-name">isFirst</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-isFirst">isFirst</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-isG2" href="#flAbstractVectorNode-isG2"><span class="function-name">isG2</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-isG2">isG2</a>(double tolerance)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-isInternal" href="#flAbstractVectorNode-isInternal"><span class="function-name">isInternal</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-isInternal">isInternal</a>(bool clockwise)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-isInterpolated" href="#flAbstractVectorNode-isInterpolated"><span class="function-name">isInterpolated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-isInterpolated">isInterpolated</a>(bool x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-isLast" href="#flAbstractVectorNode-isLast"><span class="function-name">isLast</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-isLast">isLast</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-isOff" href="#flAbstractVectorNode-isOff"><span class="function-name">isOff</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-isOff">isOff</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-isOn" href="#flAbstractVectorNode-isOn"><span class="function-name">isOn</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-isOn">isOn</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-isSmartAngle" href="#flAbstractVectorNode-isSmartAngle"><span class="function-name">isSmartAngle</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-isSmartAngle">isSmartAngle</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-makeStart" href="#flAbstractVectorNode-makeStart"><span class="function-name">makeStart</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-makeStart">makeStart</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-moveBy" href="#flAbstractVectorNode-moveBy"><span class="function-name">moveBy</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-moveBy">moveBy</a>(float dx, float dy[, bool round=false]</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-nextNode" href="#flAbstractVectorNode-nextNode"><span class="function-name">nextNode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Node/None <a href="#flAbstractVectorNode-nextNode">nextNode</a>([string nodeType= [, int searchDepth=1]])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-pointG2" href="#flAbstractVectorNode-pointG2"><span class="function-name">pointG2</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF/None <a href="#flAbstractVectorNode-pointG2">pointG2</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-prevNode" href="#flAbstractVectorNode-prevNode"><span class="function-name">prevNode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Node/None <a href="#flAbstractVectorNode-prevNode">prevNode</a>([string nodeType= [, int searchDepth=1]])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-release" href="#flAbstractVectorNode-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-remove" href="#flAbstractVectorNode-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-removeChild" href="#flAbstractVectorNode-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-removeProperty" href="#flAbstractVectorNode-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-restoreCoordinates" href="#flAbstractVectorNode-restoreCoordinates"><span class="function-name">restoreCoordinates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-restoreCoordinates">restoreCoordinates</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-restoreHistoryState" href="#flAbstractVectorNode-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-rotateBy" href="#flAbstractVectorNode-rotateBy"><span class="function-name">rotateBy</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-rotateBy">rotateBy</a>(valueDegree[, QPointF origin=(0, 0)])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-round" href="#flAbstractVectorNode-round"><span class="function-name">round</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-round">round</a>() - Round the node's coordinate</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-scaleBy" href="#flAbstractVectorNode-scaleBy"><span class="function-name">scaleBy</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-scaleBy">scaleBy</a>(valueXY | (valueX, valueY)[, QPointF origin=(0, 0)])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-setExtraLast" href="#flAbstractVectorNode-setExtraLast"><span class="function-name">setExtraLast</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-setExtraLast">setExtraLast</a>(bool)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-setFlag" href="#flAbstractVectorNode-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-setNextSmooth" href="#flAbstractVectorNode-setNextSmooth"><span class="function-name">setNextSmooth</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-setNextSmooth">setNextSmooth</a>(QPointF base)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-setPosition" href="#flAbstractVectorNode-setPosition"><span class="function-name">setPosition</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flAbstractVectorNode-setPosition">setPosition</a>(QPointF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-setPrevSmooth" href="#flAbstractVectorNode-setPrevSmooth"><span class="function-name">setPrevSmooth</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-setPrevSmooth">setPrevSmooth</a>(QPointF base)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-setProperty" href="#flAbstractVectorNode-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-setPropertyFloat" href="#flAbstractVectorNode-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-setPropertyInt" href="#flAbstractVectorNode-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-setSmartAngleEnbl" href="#flAbstractVectorNode-setSmartAngleEnbl"><span class="function-name">setSmartAngleEnbl</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-setSmartAngleEnbl">setSmartAngleEnbl</a>(bool)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-setSmartSharp" href="#flAbstractVectorNode-setSmartSharp"><span class="function-name">setSmartSharp</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-setSmartSharp">setSmartSharp</a>([double tension = 0.6])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-skewBy" href="#flAbstractVectorNode-skewBy"><span class="function-name">skewBy</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-skewBy">skewBy</a>(valueDegreeX | (valueDegreX, valueDegreY)[, QPointF origin=(0, 0)])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-smartMove" href="#flAbstractVectorNode-smartMove"><span class="function-name">smartMove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(uint) <a href="#flAbstractVectorNode-smartMove">smartMove</a>(offset)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-smartSetXY" href="#flAbstractVectorNode-smartSetXY"><span class="function-name">smartSetXY</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-smartSetXY">smartSetXY</a>(QPointF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-storeCoordinates" href="#flAbstractVectorNode-storeCoordinates"><span class="function-name">storeCoordinates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-storeCoordinates">storeCoordinates</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-storeTestParameters" href="#flAbstractVectorNode-storeTestParameters"><span class="function-name">storeTestParameters</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-storeTestParameters">storeTestParameters</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-tag" href="#flAbstractVectorNode-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-transformBy" href="#flAbstractVectorNode-transformBy"><span class="function-name">transformBy</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-transformBy">transformBy</a>(QTransform tx[, QPointF origin=(0, 0)])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-update" href="#flAbstractVectorNode-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-update">update</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-updateG2" href="#flAbstractVectorNode-updateG2"><span class="function-name">updateG2</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-updateG2">updateG2</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-updateSmooth" href="#flAbstractVectorNode-updateSmooth"><span class="function-name">updateSmooth</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAbstractVectorNode-updateSmooth">updateSmooth</a>([bool extended_neibh=true])</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flAbstractVectorNode-cloneObject" href="#flAbstractVectorNode-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flAbstractVectorNode-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-createObject" href="#flAbstractVectorNode-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flAbstractVectorNode-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-haveObject" href="#flAbstractVectorNode-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAbstractVectorNode-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flAbstractVectorNode-instanceType" href="#flAbstractVectorNode-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flAbstractVectorNode-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>angle</dt>
<dd>

<pre class="doc" markdown="0">angle</pre>

</dd>
</dl>
<dl class="descriptor"><dt>contour</dt>
<dd>

<pre class="doc" markdown="0">The parent Contour or None if not present</pre>

</dd>
</dl>
<dl class="descriptor"><dt>g2</dt>
<dd>

<pre class="doc" markdown="0">g2</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hobby</dt>
<dd>

<pre class="doc" markdown="0">hobby</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>index</dt>
<dd>

<pre class="doc" markdown="0">The index of the node in parent's contour (if present, otherwise -1)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>interpolated</dt>
<dd>

<pre class="doc" markdown="0">interpolated</pre>

</dd>
</dl>
<dl class="descriptor"><dt>interpolatedX</dt>
<dd>

<pre class="doc" markdown="0">interpolatedX</pre>

</dd>
</dl>
<dl class="descriptor"><dt>interpolatedY</dt>
<dd>

<pre class="doc" markdown="0">interpolatedY</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isSelectedAlone</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isTerminal</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>nodeState</dt>
<dd>

<pre class="doc" markdown="0">nodeState</pre>

</dd>
</dl>
<dl class="descriptor"><dt>position</dt>
<dd>

<pre class="doc" markdown="0">Coordinates of the node as QPointF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>preview</dt>
<dd>

<pre class="doc" markdown="0">preview</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>scv</dt>
<dd>

<pre class="doc" markdown="0">scv</pre>

</dd>
</dl>
<dl class="descriptor"><dt>selected</dt>
<dd>

<pre class="doc" markdown="0">The selected flag</pre>

</dd>
</dl>
<dl class="descriptor"><dt>smartAngleR</dt>
<dd>

<pre class="doc" markdown="0">smartAngleR</pre>

</dd>
</dl>
<dl class="descriptor"><dt>smooth</dt>
<dd>

<pre class="doc" markdown="0">The smooth flag</pre>

</dd>
</dl>
<dl class="descriptor"><dt>state</dt>
<dd>

<pre class="doc" markdown="0">state</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">The node type</pre>

</dd>
</dl>
<dl class="descriptor"><dt>x</dt>
<dd>

<pre class="doc" markdown="0">The x coordinate of the node</pre>

</dd>
</dl>
<dl class="descriptor"><dt>y</dt>
<dd>

<pre class="doc" markdown="0">The y coordinate of the node</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">NodeKind</span> = {'ExtraLast': 16384, 'First': 16, 'G2': 4096, 'Hobby': 8192, 'HotSpot': 2048, 'InterpolatedX': 256, 'InterpolatedY': 512, 'KindMask': 65535, 'None': 0, 'Preview': 64, ...}</dt></dl>
<dl><dt><span class="other-name">NodeType</span> = {'AnyNodeMask': 7, 'Curve': 4, 'Off': 2, 'On': 1}</dt></dl>
<dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flAbstractVectorNode-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flAnchor" href="#flAnchor">class <span class="class-name">flAnchor</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flAnchor representation

Constructors:
  flAnchor() - default
  flAnchor(flAnchor) - copy
  flAnchor(flObject)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flAnchor-__delattr__" href="#flAnchor-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAnchor-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-__eq__" href="#flAnchor-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAnchor-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-__ge__" href="#flAnchor-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAnchor-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-__getattribute__" href="#flAnchor-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAnchor-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-__gt__" href="#flAnchor-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAnchor-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-__init__" href="#flAnchor-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAnchor-__init__">__init__</a>(...) initializes x; see help(<a href="#flAnchor-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-__le__" href="#flAnchor-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAnchor-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-__lt__" href="#flAnchor-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAnchor-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-__ne__" href="#flAnchor-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAnchor-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-__repr__" href="#flAnchor-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAnchor-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-__setattr__" href="#flAnchor-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAnchor-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-added" href="#flAnchor-added"><span class="function-name">added</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-added">added</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-changed" href="#flAnchor-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-checkInitHistoryState" href="#flAnchor-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-clearAboveHistory" href="#flAnchor-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-clearFlag" href="#flAnchor-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-clearFlags" href="#flAnchor-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-clone" href="#flAnchor-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-createHistoryState" href="#flAnchor-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-currentHistoryState" href="#flAnchor-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-flag" href="#flAnchor-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-getProperties" href="#flAnchor-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-getProperty" href="#flAnchor-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-getPropertyFloat" href="#flAnchor-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-getPropertyInt" href="#flAnchor-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-hasHistoryState" href="#flAnchor-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-hasObject" href="#flAnchor-hasObject"><span class="function-name">hasObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAnchor-hasObject">hasObject</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-historyStates" href="#flAnchor-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-independedAll" href="#flAnchor-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-initialHistoryState" href="#flAnchor-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-isEqual" href="#flAnchor-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-release" href="#flAnchor-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-remove" href="#flAnchor-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-removeChild" href="#flAnchor-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-removeProperty" href="#flAnchor-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-removed" href="#flAnchor-removed"><span class="function-name">removed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-removed">removed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-restoreHistoryState" href="#flAnchor-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-setFlag" href="#flAnchor-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-setProperty" href="#flAnchor-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-setPropertyFloat" href="#flAnchor-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-setPropertyInt" href="#flAnchor-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-tag" href="#flAnchor-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-update" href="#flAnchor-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAnchor-update">update</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flAnchor-cloneObject" href="#flAnchor-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flAnchor-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-createObject" href="#flAnchor-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flAnchor-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-haveObject" href="#flAnchor-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAnchor-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flAnchor-instanceType" href="#flAnchor-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flAnchor-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>anchorCode</dt>
<dd>

<pre class="doc" markdown="0">quint64</pre>

</dd>
</dl>
<dl class="descriptor"><dt>anchorPoint</dt>
<dd>

<pre class="doc" markdown="0">QPointF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>fixHorzDirection</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>fixVertDirection</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isGlobal</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">ModeSnap</span> = {'CoordSnap': 256, 'SnapToHorz': 64, 'SnapToVert': 128}</dt></dl>
<dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flAnchor-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flAuditInfo" href="#flAuditInfo">class <span class="class-name">flAuditInfo</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flAuditInfo representation

Constructors:
  flAuditInfo()
  flAuditInfo(flObject)
  flAuditInfo(flAuditInfo)
  flAuditInfo(FaBasic, QTransform)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flAuditInfo-__delattr__" href="#flAuditInfo-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAuditInfo-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-__eq__" href="#flAuditInfo-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAuditInfo-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-__ge__" href="#flAuditInfo-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAuditInfo-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-__getattribute__" href="#flAuditInfo-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAuditInfo-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-__gt__" href="#flAuditInfo-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAuditInfo-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-__init__" href="#flAuditInfo-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAuditInfo-__init__">__init__</a>(...) initializes x; see help(<a href="#flAuditInfo-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-__le__" href="#flAuditInfo-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAuditInfo-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-__lt__" href="#flAuditInfo-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAuditInfo-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-__ne__" href="#flAuditInfo-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAuditInfo-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-__repr__" href="#flAuditInfo-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAuditInfo-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-__setattr__" href="#flAuditInfo-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAuditInfo-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-changed" href="#flAuditInfo-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-checkInitHistoryState" href="#flAuditInfo-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-clearAboveHistory" href="#flAuditInfo-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-clearFlag" href="#flAuditInfo-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-clearFlags" href="#flAuditInfo-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-clone" href="#flAuditInfo-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-createHistoryState" href="#flAuditInfo-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-currentHistoryState" href="#flAuditInfo-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-flag" href="#flAuditInfo-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-getProperties" href="#flAuditInfo-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-getProperty" href="#flAuditInfo-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-getPropertyFloat" href="#flAuditInfo-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-getPropertyInt" href="#flAuditInfo-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-glyphLocation" href="#flAuditInfo-glyphLocation"><span class="function-name">glyphLocation</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#flAuditInfo-glyphLocation">glyphLocation</a>([QPointF])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-hasHistoryState" href="#flAuditInfo-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-historyStates" href="#flAuditInfo-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-independedAll" href="#flAuditInfo-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-initialHistoryState" href="#flAuditInfo-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-isEqual" href="#flAuditInfo-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-release" href="#flAuditInfo-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-remove" href="#flAuditInfo-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-removeChild" href="#flAuditInfo-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-removeProperty" href="#flAuditInfo-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-restoreHistoryState" href="#flAuditInfo-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-setFlag" href="#flAuditInfo-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-setProperty" href="#flAuditInfo-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-setPropertyFloat" href="#flAuditInfo-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-setPropertyInt" href="#flAuditInfo-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-tag" href="#flAuditInfo-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-update" href="#flAuditInfo-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAuditInfo-update">update</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flAuditInfo-cloneObject" href="#flAuditInfo-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flAuditInfo-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-createObject" href="#flAuditInfo-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flAuditInfo-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-haveObject" href="#flAuditInfo-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAuditInfo-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flAuditInfo-instanceType" href="#flAuditInfo-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flAuditInfo-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>basic</dt>
<dd>

<pre class="doc" markdown="0">FaBasic</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>item</dt>
<dd>

<pre class="doc" markdown="0">flObject</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flAuditInfo-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flAxis" href="#flAxis">class <span class="class-name">flAxis</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flAxis representation

Constructors:
  flAxis() - default
  flAxis(string name)
  flAxis(string name, string tag, string short_name)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flAxis-__delattr__" href="#flAxis-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAxis-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-__getattribute__" href="#flAxis-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAxis-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-__init__" href="#flAxis-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAxis-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-__repr__" href="#flAxis-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAxis-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-__setattr__" href="#flAxis-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flAxis-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-checkValue" href="#flAxis-checkValue"><span class="function-name">checkValue</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flAxis-checkValue">checkValue</a>(double v)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-getRange" href="#flAxis-getRange"><span class="function-name">getRange</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flAxis-getRange">getRange</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-instanceIndex" href="#flAxis-instanceIndex"><span class="function-name">instanceIndex</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flAxis-instanceIndex">instanceIndex</a>(double v)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-instances2map" href="#flAxis-instances2map"><span class="function-name">instances2map</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAxis-instances2map">instances2map</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-instances2string" href="#flAxis-instances2string"><span class="function-name">instances2string</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#flAxis-instances2string">instances2string</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-map2instances" href="#flAxis-map2instances"><span class="function-name">map2instances</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAxis-map2instances">map2instances</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-mappedValue" href="#flAxis-mappedValue"><span class="function-name">mappedValue</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flAxis-mappedValue">mappedValue</a>(double v)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-normalize" href="#flAxis-normalize"><span class="function-name">normalize</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flAxis-normalize">normalize</a>(double userValue)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-onEdge" href="#flAxis-onEdge"><span class="function-name">onEdge</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAxis-onEdge">onEdge</a>(double v)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-string2instances" href="#flAxis-string2instances"><span class="function-name">string2instances</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAxis-string2instances">string2instances</a>(string s)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-styleName" href="#flAxis-styleName"><span class="function-name">styleName</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#flAxis-styleName">styleName</a>(double v)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-styleValue" href="#flAxis-styleValue"><span class="function-name">styleValue</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flAxis-styleValue">styleValue</a>(string style_name)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-updateInstances" href="#flAxis-updateInstances"><span class="function-name">updateInstances</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flAxis-updateInstances">updateInstances</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-updateShortName" href="#flAxis-updateShortName"><span class="function-name">updateShortName</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flAxis-updateShortName">updateShortName</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-updateTag" href="#flAxis-updateTag"><span class="function-name">updateTag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flAxis-updateTag">updateTag</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flAxis-isWeight" href="#flAxis-isWeight"><span class="function-name">isWeight</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAxis-isWeight">isWeight</a>(string s)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-isWidth" href="#flAxis-isWidth"><span class="function-name">isWidth</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flAxis-isWidth">isWidth</a>(string s)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-locationName" href="#flAxis-locationName"><span class="function-name">locationName</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QString <a href="#flAxis-locationName">locationName</a>(QList<<a href="#flAxis">flAxis</a>> axes, <a href="#flLocation">flLocation</a> location)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-valueWeight" href="#flAxis-valueWeight"><span class="function-name">valueWeight</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flAxis-valueWeight">valueWeight</a>(<a href="#flLocation">flLocation</a> location, double value)</pre>

</dd></dl>
<dl class="function"><dt><a name="flAxis-valueWidth" href="#flAxis-valueWidth"><span class="function-name">valueWidth</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flAxis-valueWidth">valueWidth</a>(<a href="#flLocation">flLocation</a> location, double value)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>default</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>designDef</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>designMax</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>designMin</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hidden</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>map</dt>
<dd>

<pre class="doc" markdown="0">QMap<double,double></pre>

</dd>
</dl>
<dl class="descriptor"><dt>maximum</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>minimal</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>playRange</dt>
<dd>

<pre class="doc" markdown="0">(double, double)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>shortName</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>tag</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flAxis-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="flBasicTool" href="#flBasicTool">class <span class="class-name">flBasicTool</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flBasicTool representation

Constructors:
  flBasicTool()
  flBasicTool(flObject)
  flBasicTool(flBasicTool)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flBasicTool-__delattr__" href="#flBasicTool-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flBasicTool-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-__eq__" href="#flBasicTool-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flBasicTool-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-__ge__" href="#flBasicTool-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flBasicTool-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-__getattribute__" href="#flBasicTool-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flBasicTool-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-__gt__" href="#flBasicTool-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flBasicTool-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-__init__" href="#flBasicTool-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flBasicTool-__init__">__init__</a>(...) initializes x; see help(<a href="#flBasicTool-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-__le__" href="#flBasicTool-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flBasicTool-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-__lt__" href="#flBasicTool-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flBasicTool-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-__ne__" href="#flBasicTool-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flBasicTool-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-__repr__" href="#flBasicTool-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flBasicTool-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-__setattr__" href="#flBasicTool-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flBasicTool-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-activateTool" href="#flBasicTool-activateTool"><span class="function-name">activateTool</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-activateTool">activateTool</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-changed" href="#flBasicTool-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-checkInitHistoryState" href="#flBasicTool-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-clearAboveHistory" href="#flBasicTool-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-clearFlag" href="#flBasicTool-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-clearFlags" href="#flBasicTool-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-clone" href="#flBasicTool-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-createHistoryState" href="#flBasicTool-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-currentHistoryState" href="#flBasicTool-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-deactivateTool" href="#flBasicTool-deactivateTool"><span class="function-name">deactivateTool</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-deactivateTool">deactivateTool</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-flag" href="#flBasicTool-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-getProperties" href="#flBasicTool-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-getProperty" href="#flBasicTool-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-getPropertyFloat" href="#flBasicTool-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-getPropertyInt" href="#flBasicTool-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-hasHistoryState" href="#flBasicTool-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-historyStates" href="#flBasicTool-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-independedAll" href="#flBasicTool-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-initialHistoryState" href="#flBasicTool-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-isEqual" href="#flBasicTool-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-release" href="#flBasicTool-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-remove" href="#flBasicTool-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-removeChild" href="#flBasicTool-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-removeProperty" href="#flBasicTool-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-restoreHistoryState" href="#flBasicTool-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-setFlag" href="#flBasicTool-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-setProperty" href="#flBasicTool-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-setPropertyFloat" href="#flBasicTool-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-setPropertyInt" href="#flBasicTool-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-tag" href="#flBasicTool-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-update" href="#flBasicTool-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flBasicTool-update">update</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flBasicTool-cloneObject" href="#flBasicTool-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flBasicTool-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-createObject" href="#flBasicTool-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flBasicTool-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-haveObject" href="#flBasicTool-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flBasicTool-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flBasicTool-instanceType" href="#flBasicTool-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flBasicTool-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>cursorId</dt>
<dd>

<pre class="doc" markdown="0">CursorId</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>needDeactivateParent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flBasicTool-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flCanvas" href="#flCanvas">class <span class="class-name">flCanvas</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flCanvas representation

Constructors:
  flCanvas()
  flCanvas(flCanvas)
  flCanvas(flObject)
  flCanvas(id)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flCanvas-__delattr__" href="#flCanvas-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flCanvas-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-__eq__" href="#flCanvas-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flCanvas-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-__ge__" href="#flCanvas-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flCanvas-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-__getattribute__" href="#flCanvas-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flCanvas-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-__gt__" href="#flCanvas-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flCanvas-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-__init__" href="#flCanvas-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flCanvas-__init__">__init__</a>(...) initializes x; see help(<a href="#flCanvas-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-__le__" href="#flCanvas-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flCanvas-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-__lt__" href="#flCanvas-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flCanvas-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-__ne__" href="#flCanvas-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flCanvas-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-__repr__" href="#flCanvas-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flCanvas-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-__setattr__" href="#flCanvas-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flCanvas-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-acceptEvents" href="#flCanvas-acceptEvents"><span class="function-name">acceptEvents</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flCanvas-acceptEvents">acceptEvents</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-activateEditor" href="#flCanvas-activateEditor"><span class="function-name">activateEditor</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flCanvas-activateEditor">activateEditor</a>(QPointF canvas_pos)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-activatePreviewNodes" href="#flCanvas-activatePreviewNodes"><span class="function-name">activatePreviewNodes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-activatePreviewNodes">activatePreviewNodes</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-addTextBlock" href="#flCanvas-addTextBlock"><span class="function-name">addTextBlock</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-addTextBlock">addTextBlock</a>(<a href="#flTextBlock">flTextBlock</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-addedToCanvas" href="#flCanvas-addedToCanvas"><span class="function-name">addedToCanvas</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flCanvas-addedToCanvas">addedToCanvas</a>(<a href="#flCanvas">flCanvas</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-addedToWorkspace" href="#flCanvas-addedToWorkspace"><span class="function-name">addedToWorkspace</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-addedToWorkspace">addedToWorkspace</a>(<a href="#flWorkspace">flWorkspace</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-adjustCanvasPosition" href="#flCanvas-adjustCanvasPosition"><span class="function-name">adjustCanvasPosition</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#flCanvas-adjustCanvasPosition">adjustCanvasPosition</a>(QPointF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-adjustPosition" href="#flCanvas-adjustPosition"><span class="function-name">adjustPosition</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF | double <a href="#flCanvas-adjustPosition">adjustPosition</a>(QPointF | double)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-appendDecorator" href="#flCanvas-appendDecorator"><span class="function-name">appendDecorator</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flCanvas-appendDecorator">appendDecorator</a>(<a href="#flVisualItem">flVisualItem</a>, DecoratorOrder)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-availableRect" href="#flCanvas-availableRect"><span class="function-name">availableRect</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF <a href="#flCanvas-availableRect">availableRect</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-boundingRectOnCanvas" href="#flCanvas-boundingRectOnCanvas"><span class="function-name">boundingRectOnCanvas</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF <a href="#flCanvas-boundingRectOnCanvas">boundingRectOnCanvas</a>(</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-canvas" href="#flCanvas-canvas"><span class="function-name">canvas</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas">flCanvas</a> <a href="#flCanvas-canvas">canvas</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-changed" href="#flCanvas-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-checkInitHistoryState" href="#flCanvas-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-clear" href="#flCanvas-clear"><span class="function-name">clear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-clear">clear</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-clearAboveHistory" href="#flCanvas-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-clearDecorators" href="#flCanvas-clearDecorators"><span class="function-name">clearDecorators</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-clearDecorators">clearDecorators</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-clearFlag" href="#flCanvas-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-clearFlags" href="#flCanvas-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-clearItems" href="#flCanvas-clearItems"><span class="function-name">clearItems</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-clearItems">clearItems</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-clearSurfaces" href="#flCanvas-clearSurfaces"><span class="function-name">clearSurfaces</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-clearSurfaces">clearSurfaces</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-clearTextBlocks" href="#flCanvas-clearTextBlocks"><span class="function-name">clearTextBlocks</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-clearTextBlocks">clearTextBlocks</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-clone" href="#flCanvas-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-collectChangedRects" href="#flCanvas-collectChangedRects"><span class="function-name">collectChangedRects</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-collectChangedRects">collectChangedRects</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-contain" href="#flCanvas-contain"><span class="function-name">contain</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flCanvas-contain">contain</a>(QPointF canvas_pos)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-containsItem" href="#flCanvas-containsItem"><span class="function-name">containsItem</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flCanvas-containsItem">containsItem</a>(<a href="#flVisualItem">flVisualItem</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-createFrame" href="#flCanvas-createFrame"><span class="function-name">createFrame</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgSymbolList">fgSymbolList</a> <a href="#flCanvas-createFrame">createFrame</a>(<a href="#fgSymbolList">fgSymbolList</a> list, QPointF position)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-createHistoryState" href="#flCanvas-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-currentHistoryState" href="#flCanvas-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-deactivateEditor" href="#flCanvas-deactivateEditor"><span class="function-name">deactivateEditor</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-deactivateEditor">deactivateEditor</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-deactivatePreviewNodes" href="#flCanvas-deactivatePreviewNodes"><span class="function-name">deactivatePreviewNodes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-deactivatePreviewNodes">deactivatePreviewNodes</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-distanceTo" href="#flCanvas-distanceTo"><span class="function-name">distanceTo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flCanvas-distanceTo">distanceTo</a>(QPointF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-ensureVisible" href="#flCanvas-ensureVisible"><span class="function-name">ensureVisible</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-ensureVisible">ensureVisible</a>(QPointF | QRectF canvas_rect[, bool total_cover = true])</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-flag" href="#flCanvas-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-getHighlight" href="#flCanvas-getHighlight"><span class="function-name">getHighlight</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF/Nothing <a href="#flCanvas-getHighlight">getHighlight</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-getProperties" href="#flCanvas-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-getProperty" href="#flCanvas-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-getPropertyFloat" href="#flCanvas-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-getPropertyInt" href="#flCanvas-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-getScaleTo" href="#flCanvas-getScaleTo"><span class="function-name">getScaleTo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flCanvas-getScaleTo">getScaleTo</a>(<a href="#flShapeInfo">flShapeInfo</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-hasHistoryState" href="#flCanvas-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-haveCanvas" href="#flCanvas-haveCanvas"><span class="function-name">haveCanvas</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flCanvas-haveCanvas">haveCanvas</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-haveEditor" href="#flCanvas-haveEditor"><span class="function-name">haveEditor</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flCanvas-haveEditor">haveEditor</a>(QPointF canvas_pos)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-haveHoveredItem" href="#flCanvas-haveHoveredItem"><span class="function-name">haveHoveredItem</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flCanvas-haveHoveredItem">haveHoveredItem</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-haveSelectedNodes" href="#flCanvas-haveSelectedNodes"><span class="function-name">haveSelectedNodes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flCanvas-haveSelectedNodes">haveSelectedNodes</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-hide" href="#flCanvas-hide"><span class="function-name">hide</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-hide">hide</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-highlight" href="#flCanvas-highlight"><span class="function-name">highlight</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-highlight">highlight</a>(QRectF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-historyStates" href="#flCanvas-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-hoveredItem" href="#flCanvas-hoveredItem"><span class="function-name">hoveredItem</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flVisualItem">flVisualItem</a> <a href="#flCanvas-hoveredItem">hoveredItem</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-independedAll" href="#flCanvas-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-initialHistoryState" href="#flCanvas-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-invertSelectedNodes" href="#flCanvas-invertSelectedNodes"><span class="function-name">invertSelectedNodes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-invertSelectedNodes">invertSelectedNodes</a>(QList<<a href="#flNodeInfo">flNodeInfo</a>>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-invselect" href="#flCanvas-invselect"><span class="function-name">invselect</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-invselect">invselect</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-isActiveCanvas" href="#flCanvas-isActiveCanvas"><span class="function-name">isActiveCanvas</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flCanvas-isActiveCanvas">isActiveCanvas</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-isEqual" href="#flCanvas-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-isFocusedCanvas" href="#flCanvas-isFocusedCanvas"><span class="function-name">isFocusedCanvas</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flCanvas-isFocusedCanvas">isFocusedCanvas</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-isSelectable" href="#flCanvas-isSelectable"><span class="function-name">isSelectable</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flCanvas-isSelectable">isSelectable</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-isStableSelect" href="#flCanvas-isStableSelect"><span class="function-name">isStableSelect</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flCanvas-isStableSelect">isStableSelect</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-itemScale" href="#flCanvas-itemScale"><span class="function-name">itemScale</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flCanvas-itemScale">itemScale</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-mapCanvasDistanceToItem" href="#flCanvas-mapCanvasDistanceToItem"><span class="function-name">mapCanvasDistanceToItem</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#flCanvas-mapCanvasDistanceToItem">mapCanvasDistanceToItem</a>(QPointF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-mapCanvasToItem" href="#flCanvas-mapCanvasToItem"><span class="function-name">mapCanvasToItem</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF | QRectF <a href="#flCanvas-mapCanvasToItem">mapCanvasToItem</a>(QPointF | QRectF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-mapDeltaFromGlobalToCanvas" href="#flCanvas-mapDeltaFromGlobalToCanvas"><span class="function-name">mapDeltaFromGlobalToCanvas</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#flCanvas-mapDeltaFromGlobalToCanvas">mapDeltaFromGlobalToCanvas</a>(QPoint)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-mapFromGlobal" href="#flCanvas-mapFromGlobal"><span class="function-name">mapFromGlobal</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF | QPointF <a href="#flCanvas-mapFromGlobal">mapFromGlobal</a>(QRect | QPoint)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-mapFromViewport" href="#flCanvas-mapFromViewport"><span class="function-name">mapFromViewport</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF | QLineF | QPointF <a href="#flCanvas-mapFromViewport">mapFromViewport</a>(QRectF | QRect | QLineF | QPointF | QPoint)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-mapItemToCanvas" href="#flCanvas-mapItemToCanvas"><span class="function-name">mapItemToCanvas</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF | QRectF <a href="#flCanvas-mapItemToCanvas">mapItemToCanvas</a>(QPointF | QRectF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-mapToGlobal" href="#flCanvas-mapToGlobal"><span class="function-name">mapToGlobal</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#flCanvas-mapToGlobal">mapToGlobal</a>(QPointF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-mapToViewport" href="#flCanvas-mapToViewport"><span class="function-name">mapToViewport</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPolygonF | QRect | QPoint <a href="#flCanvas-mapToViewport">mapToViewport</a>(QPolygonF | QRect | QPoint)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-mapToViewportF" href="#flCanvas-mapToViewportF"><span class="function-name">mapToViewportF</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF | QLineF <a href="#flCanvas-mapToViewportF">mapToViewportF</a>(QPointF | QLineF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-metricStep" href="#flCanvas-metricStep"><span class="function-name">metricStep</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flCanvas-metricStep">metricStep</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-mousePosition" href="#flCanvas-mousePosition"><span class="function-name">mousePosition</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#flCanvas-mousePosition">mousePosition</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-mousePressed" href="#flCanvas-mousePressed"><span class="function-name">mousePressed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flCanvas-mousePressed">mousePressed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-move" href="#flCanvas-move"><span class="function-name">move</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flCanvas-move">move</a>(QPointF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationAdjustMetrics" href="#flCanvas-operationAdjustMetrics"><span class="function-name">operationAdjustMetrics</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationAdjustMetrics">operationAdjustMetrics</a>(double delta, bool percent)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationAlign" href="#flCanvas-operationAlign"><span class="function-name">operationAlign</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationAlign">operationAlign</a>(Qt::Alignment)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationBeauty" href="#flCanvas-operationBeauty"><span class="function-name">operationBeauty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationBeauty">operationBeauty</a>(bool)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationBreak" href="#flCanvas-operationBreak"><span class="function-name">operationBreak</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flCanvas-operationBreak">operationBreak</a>(bool notify, bool alone_selected)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationCopyToMask" href="#flCanvas-operationCopyToMask"><span class="function-name">operationCopyToMask</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationCopyToMask">operationCopyToMask</a>(bool global = false)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationDecompose" href="#flCanvas-operationDecompose"><span class="function-name">operationDecompose</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flCanvas-operationDecompose">operationDecompose</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationFlipHorizontal" href="#flCanvas-operationFlipHorizontal"><span class="function-name">operationFlipHorizontal</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationFlipHorizontal">operationFlipHorizontal</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationFlipVertical" href="#flCanvas-operationFlipVertical"><span class="function-name">operationFlipVertical</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationFlipVertical">operationFlipVertical</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationGenius" href="#flCanvas-operationGenius"><span class="function-name">operationGenius</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationGenius">operationGenius</a>(bool)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationHarmonize" href="#flCanvas-operationHarmonize"><span class="function-name">operationHarmonize</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationHarmonize">operationHarmonize</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationImprove" href="#flCanvas-operationImprove"><span class="function-name">operationImprove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationImprove">operationImprove</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationJoin" href="#flCanvas-operationJoin"><span class="function-name">operationJoin</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationJoin">operationJoin</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationNoServant" href="#flCanvas-operationNoServant"><span class="function-name">operationNoServant</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationNoServant">operationNoServant</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationPrepare" href="#flCanvas-operationPrepare"><span class="function-name">operationPrepare</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(<a href="#flModelProducer">flModelProducer</a>, QList<<a href="#flNodeInfo">flNodeInfo</a>> selection, <a href="#flShapeInfo">flShapeInfo</a>, <a href="#flGlyphInfo">flGlyphInfo</a>)/Nothing <a href="#flCanvas-operationPrepare">operationPrepare</a>(bool allow_all_contours, bool allow_all_nodes = false)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationReverseContours" href="#flCanvas-operationReverseContours"><span class="function-name">operationReverseContours</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationReverseContours">operationReverseContours</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationRotate180" href="#flCanvas-operationRotate180"><span class="function-name">operationRotate180</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationRotate180">operationRotate180</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationRotate90" href="#flCanvas-operationRotate90"><span class="function-name">operationRotate90</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationRotate90">operationRotate90</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationServantX" href="#flCanvas-operationServantX"><span class="function-name">operationServantX</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationServantX">operationServantX</a>(bool)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationServantY" href="#flCanvas-operationServantY"><span class="function-name">operationServantY</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationServantY">operationServantY</a>(bool)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationSetMetrics" href="#flCanvas-operationSetMetrics"><span class="function-name">operationSetMetrics</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationSetMetrics">operationSetMetrics</a>(int mode)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationSimplify" href="#flCanvas-operationSimplify"><span class="function-name">operationSimplify</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationSimplify">operationSimplify</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationSmartAngle" href="#flCanvas-operationSmartAngle"><span class="function-name">operationSmartAngle</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationSmartAngle">operationSmartAngle</a>(bool)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationSmooth" href="#flCanvas-operationSmooth"><span class="function-name">operationSmooth</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationSmooth">operationSmooth</a>(bool)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationToBeziers" href="#flCanvas-operationToBeziers"><span class="function-name">operationToBeziers</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationToBeziers">operationToBeziers</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationToCurve" href="#flCanvas-operationToCurve"><span class="function-name">operationToCurve</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationToCurve">operationToCurve</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationToLine" href="#flCanvas-operationToLine"><span class="function-name">operationToLine</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationToLine">operationToLine</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-operationToSplines" href="#flCanvas-operationToSplines"><span class="function-name">operationToSplines</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-operationToSplines">operationToSplines</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-paint" href="#flCanvas-paint"><span class="function-name">paint</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flCanvas-paint">paint</a>(QPainter*)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-placeAICB" href="#flCanvas-placeAICB"><span class="function-name">placeAICB</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flCanvas-placeAICB">placeAICB</a>(QPointF position, QString filename | QMimeData mime_data)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-placeArtwork" href="#flCanvas-placeArtwork"><span class="function-name">placeArtwork</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flCanvas-placeArtwork">placeArtwork</a>(QPointF position, QList<QUrl> urls_list)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-popupHost" href="#flCanvas-popupHost"><span class="function-name">popupHost</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">YPopupHost* <a href="#flCanvas-popupHost">popupHost</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-preview" href="#flCanvas-preview"><span class="function-name">preview</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-preview">preview</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-producer" href="#flCanvas-producer"><span class="function-name">producer</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flCanvas-producer">producer</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-rectToUpdate" href="#flCanvas-rectToUpdate"><span class="function-name">rectToUpdate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRect& <a href="#flCanvas-rectToUpdate">rectToUpdate</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-referencePoint" href="#flCanvas-referencePoint"><span class="function-name">referencePoint</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#flCanvas-referencePoint">referencePoint</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-regionToUpdate" href="#flCanvas-regionToUpdate"><span class="function-name">regionToUpdate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRegion& <a href="#flCanvas-regionToUpdate">regionToUpdate</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-release" href="#flCanvas-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-remove" href="#flCanvas-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-removeChild" href="#flCanvas-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-removeDeadSmartAngles" href="#flCanvas-removeDeadSmartAngles"><span class="function-name">removeDeadSmartAngles</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-removeDeadSmartAngles">removeDeadSmartAngles</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-removeDecorator" href="#flCanvas-removeDecorator"><span class="function-name">removeDecorator</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flCanvas-removeDecorator">removeDecorator</a>(<a href="#flVisualItem">flVisualItem</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-removeItem" href="#flCanvas-removeItem"><span class="function-name">removeItem</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-removeItem">removeItem</a>(<a href="#flVisualItem">flVisualItem</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-removeProperty" href="#flCanvas-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-removeTextBlock" href="#flCanvas-removeTextBlock"><span class="function-name">removeTextBlock</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-removeTextBlock">removeTextBlock</a>(<a href="#flTextBlock">flTextBlock</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-removedFromCanvas" href="#flCanvas-removedFromCanvas"><span class="function-name">removedFromCanvas</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-removedFromCanvas">removedFromCanvas</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-removedFromWorkspace" href="#flCanvas-removedFromWorkspace"><span class="function-name">removedFromWorkspace</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-removedFromWorkspace">removedFromWorkspace</a>(<a href="#flWorkspace">flWorkspace</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-resetHighlight" href="#flCanvas-resetHighlight"><span class="function-name">resetHighlight</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-resetHighlight">resetHighlight</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-restoreHistoryState" href="#flCanvas-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-scale" href="#flCanvas-scale"><span class="function-name">scale</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flCanvas-scale">scale</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-scaled" href="#flCanvas-scaled"><span class="function-name">scaled</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flCanvas-scaled">scaled</a>(double d)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-select" href="#flCanvas-select"><span class="function-name">select</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-select">select</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-selectNode" href="#flCanvas-selectNode"><span class="function-name">selectNode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-selectNode">selectNode</a>(<a href="#flNodeInfo">flNodeInfo</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-selectNodes" href="#flCanvas-selectNodes"><span class="function-name">selectNodes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-selectNodes">selectNodes</a>(QList<<a href="#flNodeInfo">flNodeInfo</a>>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-selectedNodes" href="#flCanvas-selectedNodes"><span class="function-name">selectedNodes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QList<<a href="#flNodeInfo">flNodeInfo</a>> <a href="#flCanvas-selectedNodes">selectedNodes</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-selection" href="#flCanvas-selection"><span class="function-name">selection</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QList<<a href="#flVisualItem">flVisualItem</a>> <a href="#flCanvas-selection">selection</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-setCursor" href="#flCanvas-setCursor"><span class="function-name">setCursor</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-setCursor">setCursor</a>(QCursor)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-setCursorId" href="#flCanvas-setCursorId"><span class="function-name">setCursorId</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-setCursorId">setCursorId</a>(CursorId)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-setFlag" href="#flCanvas-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-setProperty" href="#flCanvas-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-setPropertyFloat" href="#flCanvas-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-setPropertyInt" href="#flCanvas-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-setSelectedNodes" href="#flCanvas-setSelectedNodes"><span class="function-name">setSelectedNodes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-setSelectedNodes">setSelectedNodes</a>(QList<<a href="#flNodeInfo">flNodeInfo</a>>, bool )</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-show" href="#flCanvas-show"><span class="function-name">show</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-show">show</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-slantTransform" href="#flCanvas-slantTransform"><span class="function-name">slantTransform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QTransform <a href="#flCanvas-slantTransform">slantTransform</a>(<a href="#flGlyphInfo">flGlyphInfo</a> glyph_info)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-tag" href="#flCanvas-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-textBlocks" href="#flCanvas-textBlocks"><span class="function-name">textBlocks</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QList<<a href="#flTextBlock">flTextBlock</a>> <a href="#flCanvas-textBlocks">textBlocks</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-unselect" href="#flCanvas-unselect"><span class="function-name">unselect</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-unselect">unselect</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-unselectAll" href="#flCanvas-unselectAll"><span class="function-name">unselectAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flCanvas-unselectAll">unselectAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-unselectAllNodes" href="#flCanvas-unselectAllNodes"><span class="function-name">unselectAllNodes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flCanvas-unselectAllNodes">unselectAllNodes</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-update" href="#flCanvas-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-update">update</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-updateCanvasRectA" href="#flCanvas-updateCanvasRectA"><span class="function-name">updateCanvasRectA</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-updateCanvasRectA">updateCanvasRectA</a>(QRectF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-updateMousePos" href="#flCanvas-updateMousePos"><span class="function-name">updateMousePos</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-updateMousePos">updateMousePos</a>(QPoint)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-updateScreenRect" href="#flCanvas-updateScreenRect"><span class="function-name">updateScreenRect</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-updateScreenRect">updateScreenRect</a>(QRectF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-updateScreenRegion" href="#flCanvas-updateScreenRegion"><span class="function-name">updateScreenRegion</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-updateScreenRegion">updateScreenRegion</a>(QRegion)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-updateViewRect" href="#flCanvas-updateViewRect"><span class="function-name">updateViewRect</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-updateViewRect">updateViewRect</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-updateViewport" href="#flCanvas-updateViewport"><span class="function-name">updateViewport</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-updateViewport">updateViewport</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-viewPortHasFocus" href="#flCanvas-viewPortHasFocus"><span class="function-name">viewPortHasFocus</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flCanvas-viewPortHasFocus">viewPortHasFocus</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-viewPortRect" href="#flCanvas-viewPortRect"><span class="function-name">viewPortRect</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRect <a href="#flCanvas-viewPortRect">viewPortRect</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-viewRect" href="#flCanvas-viewRect"><span class="function-name">viewRect</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF <a href="#flCanvas-viewRect">viewRect</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-zoomTo" href="#flCanvas-zoomTo"><span class="function-name">zoomTo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-zoomTo">zoomTo</a>(QPointF canvas_point, double scale, ViewPointAlignment=vpCenter) | <a href="#flCanvas-zoomTo">zoomTo</a>(QRectF canvas_rect)</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-zoomToReaded" href="#flCanvas-zoomToReaded"><span class="function-name">zoomToReaded</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas-zoomToReaded">zoomToReaded</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flCanvas-cloneObject" href="#flCanvas-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flCanvas-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-createInstance" href="#flCanvas-createInstance"><span class="function-name">createInstance</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flCanvas">flCanvas</a> <a href="#flCanvas-createInstance">createInstance</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-createObject" href="#flCanvas-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flCanvas-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-haveObject" href="#flCanvas-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flCanvas-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-instanceAcceptEvents" href="#flCanvas-instanceAcceptEvents"><span class="function-name">instanceAcceptEvents</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flCanvas-instanceAcceptEvents">instanceAcceptEvents</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flCanvas-instanceType" href="#flCanvas-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flCanvas-instanceType">instanceType</a>()</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hovered</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>locked</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>modelProducer</dt>
<dd>

<pre class="doc" markdown="0">flModelProducer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>opacity</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>owner</dt>
<dd>

<pre class="doc" markdown="0">flVisualItem</pre>

</dd>
</dl>
<dl class="descriptor"><dt>paper</dt>
<dd>

<pre class="doc" markdown="0">flPaper</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>selected</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>transform</dt>
<dd>

<pre class="doc" markdown="0">QTransform</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>
<dl class="descriptor"><dt>viewPoint</dt>
<dd>

<pre class="doc" markdown="0">QPointF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>viewPort</dt>
<dd>

<pre class="doc" markdown="0">QWidget*</pre>

</dd>
</dl>
<dl class="descriptor"><dt>viewTransform</dt>
<dd>

<pre class="doc" markdown="0">flTransform</pre>

</dd>
</dl>
<dl class="descriptor"><dt>visible</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>workspace</dt>
<dd>

<pre class="doc" markdown="0">flWorkspace</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">Listeners</span> = {'ClickListener': 8, 'DragListener': 4, 'HoverListener': 1, 'MoveListener': 2}</dt></dl>
<dl><dt><span class="other-name">SetMetricsAuto</span> = 2</dt></dl>
<dl><dt><span class="other-name">SetMetricsDefault</span> = 1</dt></dl>
<dl><dt><span class="other-name">SetMetricsZero</span> = 0</dt></dl>
<dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flCanvas-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flContour" href="#flContour">class <span class="class-name">flContour</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flContour representation

Constructors:
  flContour()
  flContour(flObject)
  flContour(flContour)
  flContour(fgContour)
  flContour(id)
  flContour(list(Node)[, bool closed=false])
  flContour(list(QPointF)[, flNode::NodeType=flNode::On[, bool closed=false]])
  flContour(QRectF)
  flContour(QLineF)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flContour-__delattr__" href="#flContour-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContour-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-__eq__" href="#flContour-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContour-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-__ge__" href="#flContour-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContour-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-__getattribute__" href="#flContour-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContour-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-__gt__" href="#flContour-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContour-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-__init__" href="#flContour-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContour-__init__">__init__</a>(...) initializes x; see help(<a href="#flContour-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-__le__" href="#flContour-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContour-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-__lt__" href="#flContour-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContour-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-__ne__" href="#flContour-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContour-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-__repr__" href="#flContour-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContour-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-__setattr__" href="#flContour-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContour-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-add" href="#flContour-add"><span class="function-name">add</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-add">add</a>(<a href="#flNode">flNode</a> | QPointF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-addInterval" href="#flContour-addInterval"><span class="function-name">addInterval</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-addInterval">addInterval</a>(<a href="#Interval">Interval</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-addMarker" href="#flContour-addMarker"><span class="function-name">addMarker</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-addMarker">addMarker</a>( <a href="#flContourMarker">flContourMarker</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-addMarkers" href="#flContour-addMarkers"><span class="function-name">addMarkers</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-addMarkers">addMarkers</a>( list(<a href="#flContourMarker">flContourMarker</a>) )</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-append" href="#flContour-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-append">append</a>(list(<a href="#flNode">flNode</a>) | <a href="#flContour">flContour</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-appendMapped" href="#flContour-appendMapped"><span class="function-name">appendMapped</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-appendMapped">appendMapped</a>(list(<a href="#flNode">flNode</a>) | <a href="#flContour">flContour</a>, QTransform)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-appendMarkers" href="#flContour-appendMarkers"><span class="function-name">appendMarkers</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-appendMarkers">appendMarkers</a>(list(<a href="#flContourMarker">flContourMarker</a>))</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-applyTransform" href="#flContour-applyTransform"><span class="function-name">applyTransform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-applyTransform">applyTransform</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-assign" href="#flContour-assign"><span class="function-name">assign</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-assign">assign</a>(<a href="#flContour">flContour</a> | fgContour | list(<a href="#flNode">flNode</a>))</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-assignOwner" href="#flContour-assignOwner"><span class="function-name">assignOwner</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-assignOwner">assignOwner</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-at" href="#flContour-at"><span class="function-name">at</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode">flNode</a> <a href="#flContour-at">at</a>(int index)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-autoG2" href="#flContour-autoG2"><span class="function-name">autoG2</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-autoG2">autoG2</a>(float tolerance)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-beautify" href="#flContour-beautify"><span class="function-name">beautify</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flContour-beautify">beautify</a>([int precision = 1])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-bindDependencies" href="#flContour-bindDependencies"><span class="function-name">bindDependencies</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-bindDependencies">bindDependencies</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-boundingBox" href="#flContour-boundingBox"><span class="function-name">boundingBox</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF <a href="#flContour-boundingBox">boundingBox</a>([QTransform])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-breakContour" href="#flContour-breakContour"><span class="function-name">breakContour</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(<a href="#flContour">flContour</a>, <a href="#flNode">flNode</a>, <a href="#flNode">flNode</a>)/Nothing <a href="#flContour-breakContour">breakContour</a>(<a href="#flNode">flNode</a>) | <a href="#flContour">flContour</a>/Nothing <a href="#flContour-breakContour">breakContour</a>(int node_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-breakContourExpanded" href="#flContour-breakContourExpanded"><span class="function-name">breakContourExpanded</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour">flContour</a>/Nothing <a href="#flContour-breakContourExpanded">breakContourExpanded</a>(int node_ix | <a href="#flNode">flNode</a> [, float extrapolate_d]</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-calculate" href="#flContour-calculate"><span class="function-name">calculate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#flContour-calculate">calculate</a>(float t[, QTransform tx])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-changed" href="#flContour-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-checkFa" href="#flContour-checkFa"><span class="function-name">checkFa</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(FaBasic) <a href="#flContour-checkFa">checkFa</a>(list(int) tests)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-checkInitHistoryState" href="#flContour-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-checkSmooth" href="#flContour-checkSmooth"><span class="function-name">checkSmooth</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-checkSmooth">checkSmooth</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-clearAboveHistory" href="#flContour-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-clearFlag" href="#flContour-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-clearFlags" href="#flContour-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-clearIntervals" href="#flContour-clearIntervals"><span class="function-name">clearIntervals</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-clearIntervals">clearIntervals</a>([uint key])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-clearMarkers" href="#flContour-clearMarkers"><span class="function-name">clearMarkers</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-clearMarkers">clearMarkers</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-clearNodes" href="#flContour-clearNodes"><span class="function-name">clearNodes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-clearNodes">clearNodes</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-clone" href="#flContour-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-cloneMapped" href="#flContour-cloneMapped"><span class="function-name">cloneMapped</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour">flContour</a> <a href="#flContour-cloneMapped">cloneMapped</a>(QTransform[, float ex_t0, float ex_t1])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-cloneMappedByT" href="#flContour-cloneMappedByT"><span class="function-name">cloneMappedByT</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour">flContour</a> <a href="#flContour-cloneMappedByT">cloneMappedByT</a>(QTransform tx, float t0, float t1)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-cloneSelected" href="#flContour-cloneSelected"><span class="function-name">cloneSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#flContour">flContour</a>)/Nothing <a href="#flContour-cloneSelected">cloneSelected</a>([QTransform, [bool ignore_alone=true]])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-compare" href="#flContour-compare"><span class="function-name">compare</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(bool result, QPointF offset) <a href="#flContour-compare">compare</a>(<a href="#flContour">flContour</a>, float error)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-contains" href="#flContour-contains"><span class="function-name">contains</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flContour-contains">contains</a>(<a href="#flContour">flContour</a> knife | QPointF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-convertClToT" href="#flContour-convertClToT"><span class="function-name">convertClToT</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#flContour-convertClToT">convertClToT</a>(float)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-convertExToCl" href="#flContour-convertExToCl"><span class="function-name">convertExToCl</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#flContour-convertExToCl">convertExToCl</a>(float)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-convertExToT" href="#flContour-convertExToT"><span class="function-name">convertExToT</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#flContour-convertExToT">convertExToT</a>(float)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-convertTTtoCurve" href="#flContour-convertTTtoCurve"><span class="function-name">convertTTtoCurve</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-convertTTtoCurve">convertTTtoCurve</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-convertToFgContour" href="#flContour-convertToFgContour"><span class="function-name">convertToFgContour</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">fgContour <a href="#flContour-convertToFgContour">convertToFgContour</a>([QTransform tx])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-convertTtoCl" href="#flContour-convertTtoCl"><span class="function-name">convertTtoCl</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#flContour-convertTtoCl">convertTtoCl</a>(float)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-convertTtoEx" href="#flContour-convertTtoEx"><span class="function-name">convertTtoEx</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#flContour-convertTtoEx">convertTtoEx</a>(float)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-createHistoryState" href="#flContour-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-currentHistoryState" href="#flContour-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-curvature" href="#flContour-curvature"><span class="function-name">curvature</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float  <a href="#flContour-curvature">curvature</a>(float)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-derivative" href="#flContour-derivative"><span class="function-name">derivative</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#flContour-derivative">derivative</a>(float)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-distanceBetween" href="#flContour-distanceBetween"><span class="function-name">distanceBetween</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#flContour-distanceBetween">distanceBetween</a>(float t0, float t1[, float step =0.1])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-draw" href="#flContour-draw"><span class="function-name">draw</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-draw">draw</a>(pen) - Draw the contour’s outline data to the given type-pen</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-drawPoints" href="#flContour-drawPoints"><span class="function-name">drawPoints</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-drawPoints">drawPoints</a>(point-pen) - Draw the contour’s outline data to the given type-point-pen</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-extrapolateFirst" href="#flContour-extrapolateFirst"><span class="function-name">extrapolateFirst</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-extrapolateFirst">extrapolateFirst</a>(float)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-extrapolateLast" href="#flContour-extrapolateLast"><span class="function-name">extrapolateLast</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-extrapolateLast">extrapolateLast</a>(float)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-fastAppend" href="#flContour-fastAppend"><span class="function-name">fastAppend</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-fastAppend">fastAppend</a>( list(<a href="#flNode">flNode</a>) )</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-fastClone" href="#flContour-fastClone"><span class="function-name">fastClone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour">flContour</a> <a href="#flContour-fastClone">fastClone</a>(float ex_t0, float ex_t1)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-fastCloneByT" href="#flContour-fastCloneByT"><span class="function-name">fastCloneByT</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour">flContour</a> <a href="#flContour-fastCloneByT">fastCloneByT</a>(float t0, float t1)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-find" href="#flContour-find"><span class="function-name">find</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode">flNode</a> <a href="#flContour-find">find</a>(QPointF, float, <a href="#flNode">flNode</a>::NodeType)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-findNearest" href="#flContour-findNearest"><span class="function-name">findNearest</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(float out_nearest_t, float dist)/Nothing <a href="#flContour-findNearest">findNearest</a>(QPointF shape_p[, int orientation=0])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-findNearestNode" href="#flContour-findNearestNode"><span class="function-name">findNearestNode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(<a href="#flNode">flNode</a>, float new_maxd)/Nothing <a href="#flContour-findNearestNode">findNearestNode</a>(QPointF p, <a href="#flNode">flNode</a>::NodeType node_type, float maxd)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-findNearestOn" href="#flContour-findNearestOn"><span class="function-name">findNearestOn</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float out_nearest_t/Nothing <a href="#flContour-findNearestOn">findNearestOn</a>(QPointF  p, float base_t)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-findNode" href="#flContour-findNode"><span class="function-name">findNode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode">flNode</a>/Nothing <a href="#flContour-findNode">findNode</a>(uint id | string name)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-flag" href="#flContour-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getBoundedT" href="#flContour-getBoundedT"><span class="function-name">getBoundedT</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#flContour-getBoundedT">getBoundedT</a>(float param_t, float radius)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getChangesRect" href="#flContour-getChangesRect"><span class="function-name">getChangesRect</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF <a href="#flContour-getChangesRect">getChangesRect</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getFirstPoint" href="#flContour-getFirstPoint"><span class="function-name">getFirstPoint</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF/Nothing <a href="#flContour-getFirstPoint">getFirstPoint</a>([int =0])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getIntervals" href="#flContour-getIntervals"><span class="function-name">getIntervals</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#Interval">Interval</a>) <a href="#flContour-getIntervals">getIntervals</a>(uint key)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getLastPoint" href="#flContour-getLastPoint"><span class="function-name">getLastPoint</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF/Nothing <a href="#flContour-getLastPoint">getLastPoint</a>([int =0])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getLength" href="#flContour-getLength"><span class="function-name">getLength</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#flContour-getLength">getLength</a>([float t0, float t1,] int =10)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getLengthSquareBRect" href="#flContour-getLengthSquareBRect"><span class="function-name">getLengthSquareBRect</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(float square, float length, QRectF brect) <a href="#flContour-getLengthSquareBRect">getLengthSquareBRect</a>(float t0, float t1[, int step=10])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getNext" href="#flContour-getNext"><span class="function-name">getNext</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode">flNode</a>/Nothing <a href="#flContour-getNext">getNext</a>(index[, <a href="#flNode">flNode</a>::NodeType=<a href="#flNode">flNode</a>::On])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getNextT" href="#flContour-getNextT"><span class="function-name">getNextT</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(bool, float) <a href="#flContour-getNextT">getNextT</a>(float base_t, float offset)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getNodeAt" href="#flContour-getNodeAt"><span class="function-name">getNodeAt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode">flNode</a>/Nothing <a href="#flContour-getNodeAt">getNodeAt</a>(int idx[, <a href="#flNode">flNode</a>::NodeType = <a href="#flNode">flNode</a>::AnyNodeMask])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getPoint" href="#flContour-getPoint"><span class="function-name">getPoint</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF/Nothing <a href="#flContour-getPoint">getPoint</a>(int idx[, <a href="#flNode">flNode</a>::NodeType = <a href="#flNode">flNode</a>::On])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getPrev" href="#flContour-getPrev"><span class="function-name">getPrev</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode">flNode</a>/Nothing <a href="#flContour-getPrev">getPrev</a>(index[, <a href="#flNode">flNode</a>::NodeType=<a href="#flNode">flNode</a>::On])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getPrevT" href="#flContour-getPrevT"><span class="function-name">getPrevT</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(bool, float) <a href="#flContour-getPrevT">getPrevT</a>(float base_t, float offset)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getProperties" href="#flContour-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getProperty" href="#flContour-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getPropertyFloat" href="#flContour-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getPropertyInt" href="#flContour-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getSegment" href="#flContour-getSegment"><span class="function-name">getSegment</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#flNode">flNode</a>) <a href="#flContour-getSegment">getSegment</a>(int i0, int i1, bool left)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getSelectedBoundingBox" href="#flContour-getSelectedBoundingBox"><span class="function-name">getSelectedBoundingBox</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF <a href="#flContour-getSelectedBoundingBox">getSelectedBoundingBox</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getSelectedNodes" href="#flContour-getSelectedNodes"><span class="function-name">getSelectedNodes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#flNode">flNode</a>)/Nothing <a href="#flContour-getSelectedNodes">getSelectedNodes</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getSideOf" href="#flContour-getSideOf"><span class="function-name">getSideOf</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#flContour-getSideOf">getSideOf</a>(QPointF p)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getSquare" href="#flContour-getSquare"><span class="function-name">getSquare</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flContour-getSquare">getSquare</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getT" href="#flContour-getT"><span class="function-name">getT</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#flContour-getT">getT</a>(<a href="#flNode">flNode</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-getUpdateRect" href="#flContour-getUpdateRect"><span class="function-name">getUpdateRect</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF <a href="#flContour-getUpdateRect">getUpdateRect</a>(float ex_t)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-hasHistoryState" href="#flContour-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-hasIntersPoints" href="#flContour-hasIntersPoints"><span class="function-name">hasIntersPoints</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flContour-hasIntersPoints">hasIntersPoints</a>(<a href="#flContour">flContour</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-hasSelected" href="#flContour-hasSelected"><span class="function-name">hasSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flContour-hasSelected">hasSelected</a>(SelectionMode)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-historyStates" href="#flContour-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-improve" href="#flContour-improve"><span class="function-name">improve</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flContour-improve">improve</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-indentParamT" href="#flContour-indentParamT"><span class="function-name">indentParamT</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#flContour-indentParamT">indentParamT</a>(float base_t, float indent[, float step =0.1])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-independedAll" href="#flContour-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-initialHistoryState" href="#flContour-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-inkBox" href="#flContour-inkBox"><span class="function-name">inkBox</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF <a href="#flContour-inkBox">inkBox</a>([QTransform tx])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-insert" href="#flContour-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-insert">insert</a>(index, <a href="#flNode">flNode</a> | list(<a href="#flNode">flNode</a>) )</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-insertNodeTo" href="#flContour-insertNodeTo"><span class="function-name">insertNodeTo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode">flNode</a> <a href="#flContour-insertNodeTo">insertNodeTo</a>(float t)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-insertSafeNodeTo" href="#flContour-insertSafeNodeTo"><span class="function-name">insertSafeNodeTo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode">flNode</a> <a href="#flContour-insertSafeNodeTo">insertSafeNodeTo</a>(float t, float dst)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-intervals" href="#flContour-intervals"><span class="function-name">intervals</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#Interval">Interval</a>) <a href="#flContour-intervals">intervals</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-isAllNodesSelected" href="#flContour-isAllNodesSelected"><span class="function-name">isAllNodesSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flContour-isAllNodesSelected">isAllNodesSelected</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-isCompatible" href="#flContour-isCompatible"><span class="function-name">isCompatible</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flContour-isCompatible">isCompatible</a>(<a href="#flContour">flContour</a>, bool strong)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-isEqual" href="#flContour-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-isFirst" href="#flContour-isFirst"><span class="function-name">isFirst</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flContour-isFirst">isFirst</a>(<a href="#flNode">flNode</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-isLast" href="#flContour-isLast"><span class="function-name">isLast</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flContour-isLast">isLast</a>(<a href="#flNode">flNode</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-isSelected" href="#flContour-isSelected"><span class="function-name">isSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flContour-isSelected">isSelected</a>(float)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-mapParamT" href="#flContour-mapParamT"><span class="function-name">mapParamT</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#flContour-mapParamT">mapParamT</a>(float, float, float)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-markers" href="#flContour-markers"><span class="function-name">markers</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#flContourMarker">flContourMarker</a>) <a href="#flContour-markers">markers</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-move" href="#flContour-move"><span class="function-name">move</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-move">move</a>(QPointF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-nodes" href="#flContour-nodes"><span class="function-name">nodes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#flNode">flNode</a>) <a href="#flContour-nodes">nodes</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-normalAt" href="#flContour-normalAt"><span class="function-name">normalAt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#flContour-normalAt">normalAt</a>(float t[, QTransform])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-normalPoint" href="#flContour-normalPoint"><span class="function-name">normalPoint</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#flContour-normalPoint">normalPoint</a>(float t, float length)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-normalizeExT" href="#flContour-normalizeExT"><span class="function-name">normalizeExT</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#flContour-normalizeExT">normalizeExT</a>(float)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-path" href="#flContour-path"><span class="function-name">path</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPainterPath <a href="#flContour-path">path</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-pointInside" href="#flContour-pointInside"><span class="function-name">pointInside</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-pointInside">pointInside</a>(QPointF pt) - Bool indicating if the point pt in the black area of the contour</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-pointf" href="#flContour-pointf"><span class="function-name">pointf</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#flContour-pointf">pointf</a>(int index)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-release" href="#flContour-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-remove" href="#flContour-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-removeAt" href="#flContour-removeAt"><span class="function-name">removeAt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-removeAt">removeAt</a>(int index)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-removeChild" href="#flContour-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-removeLast" href="#flContour-removeLast"><span class="function-name">removeLast</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-removeLast">removeLast</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-removeMarker" href="#flContour-removeMarker"><span class="function-name">removeMarker</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-removeMarker">removeMarker</a>( <a href="#flContourMarker">flContourMarker</a> )</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-removeNodesBetween" href="#flContour-removeNodesBetween"><span class="function-name">removeNodesBetween</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-removeNodesBetween">removeNodesBetween</a>(<a href="#flNode">flNode</a> prev,  <a href="#flNode">flNode</a> next)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-removeOne" href="#flContour-removeOne"><span class="function-name">removeOne</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-removeOne">removeOne</a>(<a href="#flNode">flNode</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-removeProperty" href="#flContour-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-replace" href="#flContour-replace"><span class="function-name">replace</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-replace">replace</a>(<a href="#flNode">flNode</a> old_node, <a href="#flNode">flNode</a> new_node)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-restoreHistoryState" href="#flContour-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-reverse" href="#flContour-reverse"><span class="function-name">reverse</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-reverse">reverse</a>() - Reverse the direction of the contour</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-secondDerivative" href="#flContour-secondDerivative"><span class="function-name">secondDerivative</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#flContour-secondDerivative">secondDerivative</a>(float)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-segment" href="#flContour-segment"><span class="function-name">segment</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#CurveEx">CurveEx</a>/Nothing <a href="#flContour-segment">segment</a>(float t)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-segments" href="#flContour-segments"><span class="function-name">segments</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#CurveEx">CurveEx</a>) <a href="#flContour-segments">segments</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-selectedPath" href="#flContour-selectedPath"><span class="function-name">selectedPath</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPainterPath <a href="#flContour-selectedPath">selectedPath</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-selectionChanged" href="#flContour-selectionChanged"><span class="function-name">selectionChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-selectionChanged">selectionChanged</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-setFlag" href="#flContour-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-setNext" href="#flContour-setNext"><span class="function-name">setNext</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode">flNode</a> <a href="#flContour-setNext">setNext</a>(int, QPointF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-setPoint" href="#flContour-setPoint"><span class="function-name">setPoint</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode">flNode</a> <a href="#flContour-setPoint">setPoint</a>(int index, QPointF p)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-setPrev" href="#flContour-setPrev"><span class="function-name">setPrev</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode">flNode</a> <a href="#flContour-setPrev">setPrev</a>(int, QPointF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-setProperty" href="#flContour-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-setPropertyFloat" href="#flContour-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-setPropertyInt" href="#flContour-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-setSelectedNodes" href="#flContour-setSelectedNodes"><span class="function-name">setSelectedNodes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-setSelectedNodes">setSelectedNodes</a>(bool)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-setStartPoint" href="#flContour-setStartPoint"><span class="function-name">setStartPoint</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flContour-setStartPoint">setStartPoint</a>(int i)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-simplify" href="#flContour-simplify"><span class="function-name">simplify</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-simplify">simplify</a>(float precision, bool lossy, bool extremes)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-tag" href="#flContour-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-takeNodes" href="#flContour-takeNodes"><span class="function-name">takeNodes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#flNode">flNode</a>) <a href="#flContour-takeNodes">takeNodes</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-tangent" href="#flContour-tangent"><span class="function-name">tangent</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#flContour-tangent">tangent</a>(float t)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-toBeziers" href="#flContour-toBeziers"><span class="function-name">toBeziers</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-toBeziers">toBeziers</a>(float tolerance)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-toSplines" href="#flContour-toSplines"><span class="function-name">toSplines</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-toSplines">toSplines</a>(float tolerance, bool short_splines)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-unselectAll" href="#flContour-unselectAll"><span class="function-name">unselectAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-unselectAll">unselectAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-unselectedPath" href="#flContour-unselectedPath"><span class="function-name">unselectedPath</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPainterPath <a href="#flContour-unselectedPath">unselectedPath</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-update" href="#flContour-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-update">update</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-updateG2" href="#flContour-updateG2"><span class="function-name">updateG2</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-updateG2">updateG2</a>(bool all_nodes)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-updateHobby" href="#flContour-updateHobby"><span class="function-name">updateHobby</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-updateHobby">updateHobby</a>(bool all_nodes)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-updateIndices" href="#flContour-updateIndices"><span class="function-name">updateIndices</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-updateIndices">updateIndices</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-validateExT" href="#flContour-validateExT"><span class="function-name">validateExT</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(new_ex_t, bool) <a href="#flContour-validateExT">validateExT</a>(float ex_t)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-validateIndex" href="#flContour-validateIndex"><span class="function-name">validateIndex</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(new_inx, bool) <a href="#flContour-validateIndex">validateIndex</a>(int inx)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-validateSmartR" href="#flContour-validateSmartR"><span class="function-name">validateSmartR</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(new_r, max_available_r, bool) <a href="#flContour-validateSmartR">validateSmartR</a>(int node_ix, float r)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-validateT" href="#flContour-validateT"><span class="function-name">validateT</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(new_t, bool) <a href="#flContour-validateT">validateT</a>(float t)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-validatedT" href="#flContour-validatedT"><span class="function-name">validatedT</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#flContour-validatedT">validatedT</a>(float t)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-verifySmooth" href="#flContour-verifySmooth"><span class="function-name">verifySmooth</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour-verifySmooth">verifySmooth</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flContour-cloneObject" href="#flContour-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flContour-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-createObject" href="#flContour-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flContour-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-haveObject" href="#flContour-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flContour-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flContour-instanceType" href="#flContour-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flContour-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>bounds</dt>
<dd>

<pre class="doc" markdown="0">The bounds of the contour as tuple (xMin, yMin, xMax, yMax) or None</pre>

</dd>
</dl>
<dl class="descriptor"><dt>clockwise</dt>
<dd>

<pre class="doc" markdown="0">Bool indicating if the contour’s winding direction is clockwise</pre>

</dd>
</dl>
<dl class="descriptor"><dt>closed</dt>
<dd>

<pre class="doc" markdown="0">closed attribute</pre>

</dd>
</dl>
<dl class="descriptor"><dt>closedT0</dt>
<dd>

<pre class="doc" markdown="0">closedT0 attr</pre>

</dd>
</dl>
<dl class="descriptor"><dt>closedT1</dt>
<dd>

<pre class="doc" markdown="0">closedT1 attr</pre>

</dd>
</dl>
<dl class="descriptor"><dt>first</dt>
<dd>

<pre class="doc" markdown="0">first node</pre>

</dd>
</dl>
<dl class="descriptor"><dt>font</dt>
<dd>

<pre class="doc" markdown="0">The contour’s parent font</pre>

</dd>
</dl>
<dl class="descriptor"><dt>glyph</dt>
<dd>

<pre class="doc" markdown="0">The contour’s parent glyph</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasCorners</dt>
<dd>

<pre class="doc" markdown="0">hasCorners</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasSmartAngle</dt>
<dd>

<pre class="doc" markdown="0">hasSmartAngle</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isComplete</dt>
<dd>

<pre class="doc" markdown="0">isComplete</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isTT</dt>
<dd>

<pre class="doc" markdown="0">is truetype</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>last</dt>
<dd>

<pre class="doc" markdown="0">last node</pre>

</dd>
</dl>
<dl class="descriptor"><dt>layer</dt>
<dd>

<pre class="doc" markdown="0">The contour’s parent layer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>nodesCount</dt>
<dd>

<pre class="doc" markdown="0">nodes count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>paramT0</dt>
<dd>

<pre class="doc" markdown="0">paramT0 attr</pre>

</dd>
</dl>
<dl class="descriptor"><dt>paramT1</dt>
<dd>

<pre class="doc" markdown="0">paramT1 attr</pre>

</dd>
</dl>
<dl class="descriptor"><dt>paramsClosed</dt>
<dd>

<pre class="doc" markdown="0">paramsClosed attribute</pre>

</dd>
</dl>
<dl class="descriptor"><dt>prevLast</dt>
<dd>

<pre class="doc" markdown="0">last but one node</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>reversed</dt>
<dd>

<pre class="doc" markdown="0">reversed</pre>

</dd>
</dl>
<dl class="descriptor"><dt>selection</dt>
<dd>

<pre class="doc" markdown="0">selection list (list<bool>)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>transform</dt>
<dd>

<pre class="doc" markdown="0">transform matrix</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">FigureType</span> = {'figureEllipse': 1, 'figureRectangle': 2}</dt></dl>
<dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flContour-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flContourInfo" href="#flContourInfo">class <span class="class-name">flContourInfo</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flContourInfo representation

Constructors:
  flContourInfo()
  flContourInfo(flObject)
  flContourInfo(flContour, flSearchInfo)
  flContourInfo(flContour, flShapeInfo)
  flContourInfo(flContour, flContourInfo)
  flContourInfo(flContour, QTransform)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flContourInfo-__delattr__" href="#flContourInfo-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourInfo-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-__eq__" href="#flContourInfo-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourInfo-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-__ge__" href="#flContourInfo-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourInfo-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-__getattribute__" href="#flContourInfo-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourInfo-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-__gt__" href="#flContourInfo-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourInfo-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-__init__" href="#flContourInfo-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourInfo-__init__">__init__</a>(...) initializes x; see help(<a href="#flContourInfo-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-__le__" href="#flContourInfo-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourInfo-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-__lt__" href="#flContourInfo-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourInfo-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-__ne__" href="#flContourInfo-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourInfo-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-__repr__" href="#flContourInfo-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourInfo-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-__setattr__" href="#flContourInfo-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourInfo-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-brectOnCanvas" href="#flContourInfo-brectOnCanvas"><span class="function-name">brectOnCanvas</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF <a href="#flContourInfo-brectOnCanvas">brectOnCanvas</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-changed" href="#flContourInfo-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-checkInitHistoryState" href="#flContourInfo-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-clearAboveHistory" href="#flContourInfo-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-clearFlag" href="#flContourInfo-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-clearFlags" href="#flContourInfo-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-clone" href="#flContourInfo-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-cloneSelected" href="#flContourInfo-cloneSelected"><span class="function-name">cloneSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QList<<a href="#flContourInfo">flContourInfo</a>> <a href="#flContourInfo-cloneSelected">cloneSelected</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-combine" href="#flContourInfo-combine"><span class="function-name">combine</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-combine">combine</a>(QTransform transform)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-createHistoryState" href="#flContourInfo-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-currentHistoryState" href="#flContourInfo-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-flag" href="#flContourInfo-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-getHitNode" href="#flContourInfo-getHitNode"><span class="function-name">getHitNode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo">flNodeInfo</a>/Nothing <a href="#flContourInfo-getHitNode">getHitNode</a>(QPointF canvas_pos, double dist[, int node_mask=<a href="#flNode">flNode</a>::AnyNodeMask])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-getNodesInfo" href="#flContourInfo-getNodesInfo"><span class="function-name">getNodesInfo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QList<<a href="#flNodeInfo">flNodeInfo</a>> <a href="#flContourInfo-getNodesInfo">getNodesInfo</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-getProperties" href="#flContourInfo-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-getProperty" href="#flContourInfo-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-getPropertyFloat" href="#flContourInfo-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-getPropertyInt" href="#flContourInfo-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-getUpdateRect" href="#flContourInfo-getUpdateRect"><span class="function-name">getUpdateRect</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF <a href="#flContourInfo-getUpdateRect">getUpdateRect</a>(double ex_t)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-hasHistoryState" href="#flContourInfo-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-historyStates" href="#flContourInfo-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-independedAll" href="#flContourInfo-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-initialHistoryState" href="#flContourInfo-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-isEqual" href="#flContourInfo-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-paramExT" href="#flContourInfo-paramExT"><span class="function-name">paramExT</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flContourInfo-paramExT">paramExT</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-paramT" href="#flContourInfo-paramT"><span class="function-name">paramT</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flContourInfo-paramT">paramT</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-release" href="#flContourInfo-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-remove" href="#flContourInfo-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-removeChild" href="#flContourInfo-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-removeProperty" href="#flContourInfo-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-restoreHistoryState" href="#flContourInfo-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-setExT" href="#flContourInfo-setExT"><span class="function-name">setExT</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-setExT">setExT</a>(double ex_t)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-setFlag" href="#flContourInfo-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-setProperty" href="#flContourInfo-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-setPropertyFloat" href="#flContourInfo-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-setPropertyInt" href="#flContourInfo-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-tag" href="#flContourInfo-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-update" href="#flContourInfo-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo-update">update</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flContourInfo-cloneObject" href="#flContourInfo-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flContourInfo-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-createInstance" href="#flContourInfo-createInstance"><span class="function-name">createInstance</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourInfo">flContourInfo</a> <a href="#flContourInfo-createInstance">createInstance</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-createObject" href="#flContourInfo-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flContourInfo-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-haveObject" href="#flContourInfo-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flContourInfo-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourInfo-instanceType" href="#flContourInfo-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flContourInfo-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>contour</dt>
<dd>

<pre class="doc" markdown="0">flContour></pre>

</dd>
</dl>
<dl class="descriptor"><dt>dist</dt>
<dd>

<pre class="doc" markdown="0">double dist</pre>

</dd>
</dl>
<dl class="descriptor"><dt>glyphInfo</dt>
<dd>

<pre class="doc" markdown="0">flObject - glyph info</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>shapeInfo</dt>
<dd>

<pre class="doc" markdown="0">flShapeInfo</pre>

</dd>
</dl>
<dl class="descriptor"><dt>transform</dt>
<dd>

<pre class="doc" markdown="0">transform matrix</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flContourInfo-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flContourMarker" href="#flContourMarker">class <span class="class-name">flContourMarker</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flContourMarker representation

Constructors:
  flContourMarker()
  flContourMarker(flObject)
  flContourMarker(flContourMarker)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flContourMarker-__delattr__" href="#flContourMarker-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourMarker-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-__eq__" href="#flContourMarker-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourMarker-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-__ge__" href="#flContourMarker-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourMarker-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-__getattribute__" href="#flContourMarker-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourMarker-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-__gt__" href="#flContourMarker-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourMarker-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-__init__" href="#flContourMarker-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourMarker-__init__">__init__</a>(...) initializes x; see help(<a href="#flContourMarker-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-__le__" href="#flContourMarker-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourMarker-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-__lt__" href="#flContourMarker-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourMarker-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-__ne__" href="#flContourMarker-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourMarker-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-__repr__" href="#flContourMarker-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourMarker-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-__setattr__" href="#flContourMarker-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flContourMarker-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-changed" href="#flContourMarker-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-checkInitHistoryState" href="#flContourMarker-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-clearAboveHistory" href="#flContourMarker-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-clearFlag" href="#flContourMarker-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-clearFlags" href="#flContourMarker-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-clone" href="#flContourMarker-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-createHistoryState" href="#flContourMarker-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-currentHistoryState" href="#flContourMarker-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-flag" href="#flContourMarker-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-getProperties" href="#flContourMarker-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-getProperty" href="#flContourMarker-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-getPropertyFloat" href="#flContourMarker-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-getPropertyInt" href="#flContourMarker-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-hasHistoryState" href="#flContourMarker-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-historyStates" href="#flContourMarker-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-independedAll" href="#flContourMarker-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-initialHistoryState" href="#flContourMarker-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-isEqual" href="#flContourMarker-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-point" href="#flContourMarker-point"><span class="function-name">point</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#flContourMarker-point">point</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-release" href="#flContourMarker-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-remove" href="#flContourMarker-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-removeChild" href="#flContourMarker-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-removeProperty" href="#flContourMarker-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-restoreHistoryState" href="#flContourMarker-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-setFlag" href="#flContourMarker-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-setProperty" href="#flContourMarker-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-setPropertyFloat" href="#flContourMarker-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-setPropertyInt" href="#flContourMarker-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-shiftT" href="#flContourMarker-shiftT"><span class="function-name">shiftT</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-shiftT">shiftT</a>(float shift_d)</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-tag" href="#flContourMarker-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-update" href="#flContourMarker-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContourMarker-update">update</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flContourMarker-cloneObject" href="#flContourMarker-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flContourMarker-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-createObject" href="#flContourMarker-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flContourMarker-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-haveObject" href="#flContourMarker-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flContourMarker-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flContourMarker-instanceType" href="#flContourMarker-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flContourMarker-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>contour</dt>
<dd>

<pre class="doc" markdown="0">flObject</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>outer</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>paramT</dt>
<dd>

<pre class="doc" markdown="0">float</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flContourMarker-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flEvent" href="#flEvent">class <span class="class-name">flEvent</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flEvent representation

Constructors:
  flEvent(flEvent)
  flEvent(flEvent(EventType type[, int modifiers=-1])</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flEvent-__delattr__" href="#flEvent-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flEvent-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flEvent-__getattribute__" href="#flEvent-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flEvent-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flEvent-__init__" href="#flEvent-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flEvent-__init__">__init__</a>(...) initializes x; see help(<a href="#flEvent-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flEvent-__repr__" href="#flEvent-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flEvent-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flEvent-__setattr__" href="#flEvent-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flEvent-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>modifiers</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">EventType</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">EventType</span> = {'MouseEvent': 1, 'MovementEvent': 3, 'WheelEvent': 2}</dt></dl>
<dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flEvent-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="flExpression" href="#flExpression">class <span class="class-name">flExpression</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flExpression representation

Constructors:
  flExpression()
  flExpression(flObject)
  flExpression(flExpression)
  flExpression(string)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flExpression-__delattr__" href="#flExpression-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flExpression-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-__eq__" href="#flExpression-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flExpression-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-__ge__" href="#flExpression-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flExpression-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-__getattribute__" href="#flExpression-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flExpression-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-__gt__" href="#flExpression-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flExpression-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-__init__" href="#flExpression-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flExpression-__init__">__init__</a>(...) initializes x; see help(<a href="#flExpression-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-__le__" href="#flExpression-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flExpression-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-__lt__" href="#flExpression-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flExpression-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-__ne__" href="#flExpression-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flExpression-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-__repr__" href="#flExpression-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flExpression-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-__setattr__" href="#flExpression-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flExpression-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-changed" href="#flExpression-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-checkInitHistoryState" href="#flExpression-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-clearAboveHistory" href="#flExpression-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-clearError" href="#flExpression-clearError"><span class="function-name">clearError</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-clearError">clearError</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-clearFlag" href="#flExpression-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-clearFlags" href="#flExpression-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-clone" href="#flExpression-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-createHistoryState" href="#flExpression-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-currentHistoryState" href="#flExpression-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-expression" href="#flExpression-expression"><span class="function-name">expression</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QString <a href="#flExpression-expression">expression</a>(QMap<QString, QString> aliases)</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-flag" href="#flExpression-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-getProperties" href="#flExpression-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-getProperty" href="#flExpression-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-getPropertyFloat" href="#flExpression-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-getPropertyInt" href="#flExpression-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-hasError" href="#flExpression-hasError"><span class="function-name">hasError</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flExpression-hasError">hasError</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-hasExpression" href="#flExpression-hasExpression"><span class="function-name">hasExpression</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flExpression-hasExpression">hasExpression</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-hasHistoryState" href="#flExpression-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-historyStates" href="#flExpression-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-independedAll" href="#flExpression-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-initialHistoryState" href="#flExpression-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-isEqual" href="#flExpression-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-isNeedToComplete" href="#flExpression-isNeedToComplete"><span class="function-name">isNeedToComplete</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flExpression-isNeedToComplete">isNeedToComplete</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-release" href="#flExpression-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-remove" href="#flExpression-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-removeChild" href="#flExpression-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-removeProperty" href="#flExpression-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-resetReady" href="#flExpression-resetReady"><span class="function-name">resetReady</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-resetReady">resetReady</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-restoreHistoryState" href="#flExpression-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-setFlag" href="#flExpression-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-setProperty" href="#flExpression-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-setPropertyFloat" href="#flExpression-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-setPropertyInt" href="#flExpression-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-tag" href="#flExpression-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-update" href="#flExpression-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flExpression-update">update</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-variables" href="#flExpression-variables"><span class="function-name">variables</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QStringList <a href="#flExpression-variables">variables</a>([QMap<QString, QString> aliases])</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flExpression-cloneObject" href="#flExpression-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flExpression-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-createObject" href="#flExpression-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flExpression-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-haveObject" href="#flExpression-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flExpression-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flExpression-instanceType" href="#flExpression-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flExpression-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>error</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>ready</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flExpression-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flGlyph" href="#flGlyph">class <span class="class-name">flGlyph</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flGlyph representation

Constructors:
  flGlyph()
  flGlyph(flGlyph)
  flGlyph(flObject)
  flGlyph(fgGlyph, fgFont)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flGlyph-__delattr__" href="#flGlyph-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyph-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-__eq__" href="#flGlyph-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyph-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-__ge__" href="#flGlyph-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyph-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-__getattribute__" href="#flGlyph-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyph-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-__gt__" href="#flGlyph-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyph-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-__init__" href="#flGlyph-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyph-__init__">__init__</a>(...) initializes x; see help(<a href="#flGlyph-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-__le__" href="#flGlyph-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyph-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-__lt__" href="#flGlyph-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyph-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-__ne__" href="#flGlyph-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyph-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-__repr__" href="#flGlyph-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyph-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-__setattr__" href="#flGlyph-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyph-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-addLayer" href="#flGlyph-addLayer"><span class="function-name">addLayer</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flGlyph-addLayer">addLayer</a>(<a href="#flLayer">flLayer</a>[, bool back = false])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-addLayers" href="#flGlyph-addLayers"><span class="function-name">addLayers</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flGlyph-addLayers">addLayers</a>(list(<a href="#flLayer">flLayer</a>))</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-applyTransform" href="#flGlyph-applyTransform"><span class="function-name">applyTransform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-applyTransform">applyTransform</a>([QTransform transform])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-assignFontGateData" href="#flGlyph-assignFontGateData"><span class="function-name">assignFontGateData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flGlyph-assignFontGateData">assignFontGateData</a>(fgFontGateData, bool doGuide = true, bool doHints = true, bool doAnchors = true)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-bindDependencies" href="#flGlyph-bindDependencies"><span class="function-name">bindDependencies</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-bindDependencies">bindDependencies</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-changed" href="#flGlyph-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-checkInitHistoryState" href="#flGlyph-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-clearAboveHistory" href="#flGlyph-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-clearFlag" href="#flGlyph-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-clearFlags" href="#flGlyph-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-clone" href="#flGlyph-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-createHistoryState" href="#flGlyph-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-currentHistoryState" href="#flGlyph-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-deactivateAll" href="#flGlyph-deactivateAll"><span class="function-name">deactivateAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-deactivateAll">deactivateAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-ensureMaskLayer" href="#flGlyph-ensureMaskLayer"><span class="function-name">ensureMaskLayer</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer">flLayer</a> <a href="#flGlyph-ensureMaskLayer">ensureMaskLayer</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-fillFgData" href="#flGlyph-fillFgData"><span class="function-name">fillFgData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">fgFontGateData <a href="#flGlyph-fillFgData">fillFgData</a>(bool doGuides, bool doHints)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-findLayer" href="#flGlyph-findLayer"><span class="function-name">findLayer</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer">flLayer</a> <a href="#flGlyph-findLayer">findLayer</a>(QString name[, Qt::CaseSensitivity cs = Qt::CaseSensitive])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-findLayerCreate" href="#flGlyph-findLayerCreate"><span class="function-name">findLayerCreate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer">flLayer</a> <a href="#flGlyph-findLayerCreate">findLayerCreate</a>(QString name[, Qt::CaseSensitivity cs = Qt::CaseSensitive])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-findVerticalGuideline" href="#flGlyph-findVerticalGuideline"><span class="function-name">findVerticalGuideline</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double/Nothing <a href="#flGlyph-findVerticalGuideline">findVerticalGuideline</a>(QString)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-flag" href="#flGlyph-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-getAuditInfo" href="#flGlyph-getAuditInfo"><span class="function-name">getAuditInfo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#flAuditInfo">flAuditInfo</a>) <a href="#flGlyph-getAuditInfo">getAuditInfo</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-getFastFontGateData" href="#flGlyph-getFastFontGateData"><span class="function-name">getFastFontGateData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">fgFontGateData <a href="#flGlyph-getFastFontGateData">getFastFontGateData</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-getLSB" href="#flGlyph-getLSB"><span class="function-name">getLSB</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flGlyph-getLSB">getLSB</a>(QTransform tr)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-getLayerByName" href="#flGlyph-getLayerByName"><span class="function-name">getLayerByName</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer">flLayer</a> <a href="#flGlyph-getLayerByName">getLayerByName</a>(QString[, bool create =false])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-getProperties" href="#flGlyph-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-getProperty" href="#flGlyph-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-getPropertyFloat" href="#flGlyph-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-getPropertyInt" href="#flGlyph-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-getRSB" href="#flGlyph-getRSB"><span class="function-name">getRSB</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flGlyph-getRSB">getRSB</a>(QTransform tr)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-getSB" href="#flGlyph-getSB"><span class="function-name">getSB</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(double l, double r) <a href="#flGlyph-getSB">getSB</a>(QTransform tr)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-glyphName" href="#flGlyph-glyphName"><span class="function-name">glyphName</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QString <a href="#flGlyph-glyphName">glyphName</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-hasFontAudit" href="#flGlyph-hasFontAudit"><span class="function-name">hasFontAudit</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGlyph-hasFontAudit">hasFontAudit</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-hasHistoryState" href="#flGlyph-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-haveSelected" href="#flGlyph-haveSelected"><span class="function-name">haveSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGlyph-haveSelected">haveSelected</a>(SelectionMode)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-historyStates" href="#flGlyph-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-horzReflection" href="#flGlyph-horzReflection"><span class="function-name">horzReflection</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGlyph-horzReflection">horzReflection</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-independedAll" href="#flGlyph-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-initialHistoryState" href="#flGlyph-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-inkBox" href="#flGlyph-inkBox"><span class="function-name">inkBox</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF <a href="#flGlyph-inkBox">inkBox</a>([QTransform tx = QTransform()])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-isEqual" href="#flGlyph-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-isUnbindedDependecies" href="#flGlyph-isUnbindedDependecies"><span class="function-name">isUnbindedDependecies</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGlyph-isUnbindedDependecies">isUnbindedDependecies</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-issele" href="#flGlyph-issele"><span class="function-name">issele</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flGlyph-issele">issele</a>(bool)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-measurementLine" href="#flGlyph-measurementLine"><span class="function-name">measurementLine</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double/Nothing <a href="#flGlyph-measurementLine">measurementLine</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-prepareTransformationData" href="#flGlyph-prepareTransformationData"><span class="function-name">prepareTransformationData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-prepareTransformationData">prepareTransformationData</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-release" href="#flGlyph-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-remove" href="#flGlyph-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-removeChild" href="#flGlyph-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-removeEmptyShapes" href="#flGlyph-removeEmptyShapes"><span class="function-name">removeEmptyShapes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-removeEmptyShapes">removeEmptyShapes</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-removeLayer" href="#flGlyph-removeLayer"><span class="function-name">removeLayer</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flGlyph-removeLayer">removeLayer</a>(<a href="#flLayer">flLayer</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-removeProperty" href="#flGlyph-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-resetInkBox" href="#flGlyph-resetInkBox"><span class="function-name">resetInkBox</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-resetInkBox">resetInkBox</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-resetTransformationData" href="#flGlyph-resetTransformationData"><span class="function-name">resetTransformationData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-resetTransformationData">resetTransformationData</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-restoreHistoryState" href="#flGlyph-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-setAllShapesSelected" href="#flGlyph-setAllShapesSelected"><span class="function-name">setAllShapesSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-setAllShapesSelected">setAllShapesSelected</a>(bool)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-setFlag" href="#flGlyph-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-setLSB" href="#flGlyph-setLSB"><span class="function-name">setLSB</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGlyph-setLSB">setLSB</a>(double v, bool move_guidelines, QTransform tr)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-setLayers" href="#flGlyph-setLayers"><span class="function-name">setLayers</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flGlyph-setLayers">setLayers</a>(list(<a href="#flLayer">flLayer</a>))</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-setProperty" href="#flGlyph-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-setPropertyFloat" href="#flGlyph-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-setPropertyInt" href="#flGlyph-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-setRSB" href="#flGlyph-setRSB"><span class="function-name">setRSB</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGlyph-setRSB">setRSB</a>(double v, QTransform tr)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-setReflected" href="#flGlyph-setReflected"><span class="function-name">setReflected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-setReflected">setReflected</a>(bool, bool)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-setSB" href="#flGlyph-setSB"><span class="function-name">setSB</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGlyph-setSB">setSB</a>(double l, double r, bool move_guidelines, bool all_layers, QTransform tr)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-tag" href="#flGlyph-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-unselectAllNodes" href="#flGlyph-unselectAllNodes"><span class="function-name">unselectAllNodes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-unselectAllNodes">unselectAllNodes</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-update" href="#flGlyph-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-update">update</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-updateActiveLayer" href="#flGlyph-updateActiveLayer"><span class="function-name">updateActiveLayer</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer">flLayer</a> <a href="#flGlyph-updateActiveLayer">updateActiveLayer</a>(bool)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-updateAudit" href="#flGlyph-updateAudit"><span class="function-name">updateAudit</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flGlyph-updateAudit">updateAudit</a>(list(int))</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-updateSidebearings" href="#flGlyph-updateSidebearings"><span class="function-name">updateSidebearings</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGlyph-updateSidebearings">updateSidebearings</a>(bool nofify)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-vertReflection" href="#flGlyph-vertReflection"><span class="function-name">vertReflection</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGlyph-vertReflection">vertReflection</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-virtualTags" href="#flGlyph-virtualTags"><span class="function-name">virtualTags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QSet<QString>/Nothing <a href="#flGlyph-virtualTags">virtualTags</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flGlyph-clearUpdateFgGlyphs" href="#flGlyph-clearUpdateFgGlyphs"><span class="function-name">clearUpdateFgGlyphs</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-clearUpdateFgGlyphs">clearUpdateFgGlyphs</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-cloneObject" href="#flGlyph-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flGlyph-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-createInstance" href="#flGlyph-createInstance"><span class="function-name">createInstance</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph">flGlyph</a> <a href="#flGlyph-createInstance">createInstance</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-createObject" href="#flGlyph-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flGlyph-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-ensureFgData" href="#flGlyph-ensureFgData"><span class="function-name">ensureFgData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">fgFontGateData <a href="#flGlyph-ensureFgData">ensureFgData</a>(fgGlyph)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-hasInstance" href="#flGlyph-hasInstance"><span class="function-name">hasInstance</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGlyph-hasInstance">hasInstance</a>(fgGlyph)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-haveObject" href="#flGlyph-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGlyph-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-instanceType" href="#flGlyph-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flGlyph-instanceType">instanceType</a>();</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-linkInstances" href="#flGlyph-linkInstances"><span class="function-name">linkInstances</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGlyph-linkInstances">linkInstances</a>(<a href="#flGlyph">flGlyph</a>, fgGlyph)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-updateFgGlyph" href="#flGlyph-updateFgGlyph"><span class="function-name">updateFgGlyph</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph-updateFgGlyph">updateFgGlyph</a>(uint id)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyph-updatedFgGlyphs" href="#flGlyph-updatedFgGlyphs"><span class="function-name">updatedFgGlyphs</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(uint32_t) <a href="#flGlyph-updatedFgGlyphs">updatedFgGlyphs</a>()</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>activeLayer</dt>
<dd>

<pre class="doc" markdown="0">flLayer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>advanceWidth</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>ascender</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>bodyLayer</dt>
<dd>

<pre class="doc" markdown="0">flLayer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>bodyRect</dt>
<dd>

<pre class="doc" markdown="0">QRectF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>boundingBox</dt>
<dd>

<pre class="doc" markdown="0">QRectF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>descender</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>fgGlyph</dt>
<dd>

<pre class="doc" markdown="0">fgGlyph</pre>

</dd>
</dl>
<dl class="descriptor"><dt>fgGlyphId</dt>
<dd>

<pre class="doc" markdown="0">FgTypeId</pre>

</dd>
</dl>
<dl class="descriptor"><dt>fgPackage</dt>
<dd>

<pre class="doc" markdown="0">fgFont</pre>

</dd>
</dl>
<dl class="descriptor"><dt>getStateObject</dt>
<dd>

<pre class="doc" markdown="0">flObject</pre>

</dd>
</dl>
<dl class="descriptor"><dt>glyphRect</dt>
<dd>

<pre class="doc" markdown="0">QRectF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasBody</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>lastModified</dt>
<dd>

<pre class="doc" markdown="0">QDateTime</pre>

</dd>
</dl>
<dl class="descriptor"><dt>layers</dt>
<dd>

<pre class="doc" markdown="0">list(flLayer)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>leftMetric</dt>
<dd>

<pre class="doc" markdown="0">QPointF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>mark</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>metricsLeft</dt>
<dd>

<pre class="doc" markdown="0">QString</pre>

</dd>
</dl>
<dl class="descriptor"><dt>metricsRect</dt>
<dd>

<pre class="doc" markdown="0">QRectF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>metricsRight</dt>
<dd>

<pre class="doc" markdown="0">QString</pre>

</dd>
</dl>
<dl class="descriptor"><dt>metricsWidth</dt>
<dd>

<pre class="doc" markdown="0">QString</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">QString</pre>

</dd>
</dl>
<dl class="descriptor"><dt>nodesCount</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>note</dt>
<dd>

<pre class="doc" markdown="0">QString</pre>

</dd>
</dl>
<dl class="descriptor"><dt>package</dt>
<dd>

<pre class="doc" markdown="0">flObject</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>rightMetric</dt>
<dd>

<pre class="doc" markdown="0">QPointF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>tags</dt>
<dd>

<pre class="doc" markdown="0">QStringList</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flGlyph-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flGlyphInfo" href="#flGlyphInfo">class <span class="class-name">flGlyphInfo</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flGlyphInfo representation

Constructors:
  flGlyphInfo()
  flGlyphInfo(flObject)
  flGlyphInfo(flGlyphInfo)
  flGlyphInfo(flGlyph, QTransform)
  flGlyphInfo(fgSymbol, fgGlyph, fgFont)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flGlyphInfo-__delattr__" href="#flGlyphInfo-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyphInfo-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-__eq__" href="#flGlyphInfo-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyphInfo-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-__ge__" href="#flGlyphInfo-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyphInfo-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-__getattribute__" href="#flGlyphInfo-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyphInfo-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-__gt__" href="#flGlyphInfo-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyphInfo-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-__init__" href="#flGlyphInfo-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyphInfo-__init__">__init__</a>(...) initializes x; see help(<a href="#flGlyphInfo-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-__le__" href="#flGlyphInfo-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyphInfo-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-__lt__" href="#flGlyphInfo-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyphInfo-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-__ne__" href="#flGlyphInfo-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyphInfo-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-__repr__" href="#flGlyphInfo-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyphInfo-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-__setattr__" href="#flGlyphInfo-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGlyphInfo-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-applyTransform" href="#flGlyphInfo-applyTransform"><span class="function-name">applyTransform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-applyTransform">applyTransform</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-applyTransformTo" href="#flGlyphInfo-applyTransformTo"><span class="function-name">applyTransformTo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-applyTransformTo">applyTransformTo</a>(uint type)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-changed" href="#flGlyphInfo-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-checkInitHistoryState" href="#flGlyphInfo-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-clearAboveHistory" href="#flGlyphInfo-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-clearFlag" href="#flGlyphInfo-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-clearFlags" href="#flGlyphInfo-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-clone" href="#flGlyphInfo-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-createBoundingBox" href="#flGlyphInfo-createBoundingBox"><span class="function-name">createBoundingBox</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-createBoundingBox">createBoundingBox</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-createHistoryState" href="#flGlyphInfo-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-currentHistoryState" href="#flGlyphInfo-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-flag" href="#flGlyphInfo-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-getNearbyContours" href="#flGlyphInfo-getNearbyContours"><span class="function-name">getNearbyContours</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#flContourInfo">flContourInfo</a>) <a href="#flGlyphInfo-getNearbyContours">getNearbyContours</a>(QPointF, double max_dist, QString exclude_attr)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-getProperties" href="#flGlyphInfo-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-getProperty" href="#flGlyphInfo-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-getPropertyFloat" href="#flGlyphInfo-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-getPropertyInt" href="#flGlyphInfo-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-getTopHitShape" href="#flGlyphInfo-getTopHitShape"><span class="function-name">getTopHitShape</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flShapeInfo">flShapeInfo</a>/Nothing <a href="#flGlyphInfo-getTopHitShape">getTopHitShape</a>(QPointF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-hasHistoryState" href="#flGlyphInfo-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-historyStates" href="#flGlyphInfo-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-hitToShape" href="#flGlyphInfo-hitToShape"><span class="function-name">hitToShape</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGlyphInfo-hitToShape">hitToShape</a>(QPointF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-independedAll" href="#flGlyphInfo-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-initialHistoryState" href="#flGlyphInfo-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-isEqual" href="#flGlyphInfo-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-kerningOffset" href="#flGlyphInfo-kerningOffset"><span class="function-name">kerningOffset</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flGlyphInfo-kerningOffset">kerningOffset</a>(bool useKerning)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-release" href="#flGlyphInfo-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-remove" href="#flGlyphInfo-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-removeChild" href="#flGlyphInfo-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-removeProperty" href="#flGlyphInfo-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-restoreHistoryState" href="#flGlyphInfo-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-setBoundAscender" href="#flGlyphInfo-setBoundAscender"><span class="function-name">setBoundAscender</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-setBoundAscender">setBoundAscender</a>(double)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-setBoundDescender" href="#flGlyphInfo-setBoundDescender"><span class="function-name">setBoundDescender</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-setBoundDescender">setBoundDescender</a>(double)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-setBoundLeft" href="#flGlyphInfo-setBoundLeft"><span class="function-name">setBoundLeft</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-setBoundLeft">setBoundLeft</a>(double)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-setBoundRight" href="#flGlyphInfo-setBoundRight"><span class="function-name">setBoundRight</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-setBoundRight">setBoundRight</a>(double)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-setFlag" href="#flGlyphInfo-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-setGlyphScale" href="#flGlyphInfo-setGlyphScale"><span class="function-name">setGlyphScale</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-setGlyphScale">setGlyphScale</a>(double, double)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-setKerningOffset" href="#flGlyphInfo-setKerningOffset"><span class="function-name">setKerningOffset</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-setKerningOffset">setKerningOffset</a>(double offs)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-setProperty" href="#flGlyphInfo-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-setPropertyFloat" href="#flGlyphInfo-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-setPropertyInt" href="#flGlyphInfo-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-tag" href="#flGlyphInfo-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-update" href="#flGlyphInfo-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyphInfo-update">update</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flGlyphInfo-cloneObject" href="#flGlyphInfo-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flGlyphInfo-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-createObject" href="#flGlyphInfo-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flGlyphInfo-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-haveObject" href="#flGlyphInfo-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGlyphInfo-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flGlyphInfo-instanceType" href="#flGlyphInfo-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flGlyphInfo-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>bodyRectOnCanvas</dt>
<dd>

<pre class="doc" markdown="0">QRectF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>boundingBox</dt>
<dd>

<pre class="doc" markdown="0">QRectF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>brectOnCanvas</dt>
<dd>

<pre class="doc" markdown="0">QRectF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>changedRect</dt>
<dd>

<pre class="doc" markdown="0">QRectF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>dist</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>fontSize</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>glyph</dt>
<dd>

<pre class="doc" markdown="0">flGlyph</pre>

</dd>
</dl>
<dl class="descriptor"><dt>glyphRectCanvas</dt>
<dd>

<pre class="doc" markdown="0">QRectF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isActive</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNullGlyph</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isSelected</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>leftOffset</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>metricsRectOnCanvas</dt>
<dd>

<pre class="doc" markdown="0">QRectF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">QString</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>rightOffset</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>shapesBoundingBoxOnCanvas</dt>
<dd>

<pre class="doc" markdown="0">QRectF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>state</dt>
<dd>

<pre class="doc" markdown="0">uint</pre>

</dd>
</dl>
<dl class="descriptor"><dt>symbol</dt>
<dd>

<pre class="doc" markdown="0">fgSymbol</pre>

</dd>
</dl>
<dl class="descriptor"><dt>textBlock</dt>
<dd>

<pre class="doc" markdown="0">flTextBlock, int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>transform</dt>
<dd>

<pre class="doc" markdown="0">transform matrix</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flGlyphInfo-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flGraphicsInfo" href="#flGraphicsInfo">class <span class="class-name">flGraphicsInfo</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flGraphicsInfo representation

Constructors:
  flGraphicsInfo()
  flGraphicsInfo(flObject)
  flGraphicsInfo(flGraphicsInfo)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flGraphicsInfo-__delattr__" href="#flGraphicsInfo-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGraphicsInfo-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-__eq__" href="#flGraphicsInfo-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGraphicsInfo-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-__ge__" href="#flGraphicsInfo-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGraphicsInfo-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-__getattribute__" href="#flGraphicsInfo-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGraphicsInfo-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-__gt__" href="#flGraphicsInfo-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGraphicsInfo-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-__init__" href="#flGraphicsInfo-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGraphicsInfo-__init__">__init__</a>(...) initializes x; see help(<a href="#flGraphicsInfo-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-__le__" href="#flGraphicsInfo-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGraphicsInfo-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-__lt__" href="#flGraphicsInfo-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGraphicsInfo-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-__ne__" href="#flGraphicsInfo-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGraphicsInfo-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-__repr__" href="#flGraphicsInfo-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGraphicsInfo-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-__setattr__" href="#flGraphicsInfo-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGraphicsInfo-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-changed" href="#flGraphicsInfo-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-checkInitHistoryState" href="#flGraphicsInfo-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-clearAboveHistory" href="#flGraphicsInfo-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-clearFlag" href="#flGraphicsInfo-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-clearFlags" href="#flGraphicsInfo-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-clone" href="#flGraphicsInfo-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-createHistoryState" href="#flGraphicsInfo-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-currentHistoryState" href="#flGraphicsInfo-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-flag" href="#flGraphicsInfo-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-getProperties" href="#flGraphicsInfo-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-getProperty" href="#flGraphicsInfo-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-getPropertyFloat" href="#flGraphicsInfo-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-getPropertyInt" href="#flGraphicsInfo-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-hasHistoryState" href="#flGraphicsInfo-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-historyStates" href="#flGraphicsInfo-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-independedAll" href="#flGraphicsInfo-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-initialHistoryState" href="#flGraphicsInfo-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-isEqual" href="#flGraphicsInfo-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-release" href="#flGraphicsInfo-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-remove" href="#flGraphicsInfo-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-removeChild" href="#flGraphicsInfo-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-removeProperty" href="#flGraphicsInfo-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-restoreHistoryState" href="#flGraphicsInfo-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-setFlag" href="#flGraphicsInfo-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-setProperty" href="#flGraphicsInfo-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-setPropertyFloat" href="#flGraphicsInfo-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-setPropertyInt" href="#flGraphicsInfo-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-tag" href="#flGraphicsInfo-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-update" href="#flGraphicsInfo-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGraphicsInfo-update">update</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flGraphicsInfo-cloneObject" href="#flGraphicsInfo-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flGraphicsInfo-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-createObject" href="#flGraphicsInfo-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flGraphicsInfo-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-haveObject" href="#flGraphicsInfo-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGraphicsInfo-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flGraphicsInfo-instanceType" href="#flGraphicsInfo-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flGraphicsInfo-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>transform</dt>
<dd>

<pre class="doc" markdown="0">transform matrix</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flGraphicsInfo-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flGuideLine" href="#flGuideLine">class <span class="class-name">flGuideLine</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flGuideLine representation

Constructors:
  flGuideLine()
  flGuideLine(flObject)
  flGuideLine(flGuideLine)
  flGuideLine(double angle, QPointF canvas_point, uint=flSnaps::Vector, SnapObjectsStyle=gsPageGuideline)
  flGuideLine(QLineF line, uint=flSnaps::Vector, SnapObjectsStyle=gsPageGuideline)
  flGuideLine(QPointF center, QPointF vector_point, uint =flSnaps::Vector, SnapObjectsStyle=gsPageGuideline)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flGuideLine-__delattr__" href="#flGuideLine-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGuideLine-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-__eq__" href="#flGuideLine-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGuideLine-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-__ge__" href="#flGuideLine-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGuideLine-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-__getattribute__" href="#flGuideLine-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGuideLine-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-__gt__" href="#flGuideLine-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGuideLine-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-__init__" href="#flGuideLine-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGuideLine-__init__">__init__</a>(...) initializes x; see help(<a href="#flGuideLine-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-__le__" href="#flGuideLine-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGuideLine-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-__lt__" href="#flGuideLine-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGuideLine-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-__ne__" href="#flGuideLine-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGuideLine-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-__repr__" href="#flGuideLine-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGuideLine-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-__setattr__" href="#flGuideLine-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flGuideLine-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-applyTransform" href="#flGuideLine-applyTransform"><span class="function-name">applyTransform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flGuideLine-applyTransform">applyTransform</a>(QTransform)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-changed" href="#flGuideLine-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-checkInitHistoryState" href="#flGuideLine-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-clearAboveHistory" href="#flGuideLine-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-clearFlag" href="#flGuideLine-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-clearFlags" href="#flGuideLine-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-clone" href="#flGuideLine-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-createHistoryState" href="#flGuideLine-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-currentHistoryState" href="#flGuideLine-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-disconnectFromContour" href="#flGuideLine-disconnectFromContour"><span class="function-name">disconnectFromContour</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-disconnectFromContour">disconnectFromContour</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-distanceTo" href="#flGuideLine-distanceTo"><span class="function-name">distanceTo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flGuideLine-distanceTo">distanceTo</a>(QPointF, uint mode)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-flag" href="#flGuideLine-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-getProperties" href="#flGuideLine-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-getProperty" href="#flGuideLine-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-getPropertyFloat" href="#flGuideLine-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-getPropertyInt" href="#flGuideLine-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-hasHistoryState" href="#flGuideLine-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-historyStates" href="#flGuideLine-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-independedAll" href="#flGuideLine-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-initialHistoryState" href="#flGuideLine-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-isEqual" href="#flGuideLine-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-isHorizontal" href="#flGuideLine-isHorizontal"><span class="function-name">isHorizontal</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGuideLine-isHorizontal">isHorizontal</a>([double a=1])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-isVertical" href="#flGuideLine-isVertical"><span class="function-name">isVertical</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGuideLine-isVertical">isVertical</a>([double a=1])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-offsetTo" href="#flGuideLine-offsetTo"><span class="function-name">offsetTo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#flGuideLine-offsetTo">offsetTo</a>(QPointF, uint mode)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-release" href="#flGuideLine-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-remove" href="#flGuideLine-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-removeChild" href="#flGuideLine-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-removeProperty" href="#flGuideLine-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-reset" href="#flGuideLine-reset"><span class="function-name">reset</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-reset">reset</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-restoreHistoryState" href="#flGuideLine-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-setFlag" href="#flGuideLine-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-setProperty" href="#flGuideLine-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-setPropertyFloat" href="#flGuideLine-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-setPropertyInt" href="#flGuideLine-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-setSnapFlag" href="#flGuideLine-setSnapFlag"><span class="function-name">setSnapFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-setSnapFlag">setSnapFlag</a>(uint role, uint snapFlags)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-setSnapFlagValue" href="#flGuideLine-setSnapFlagValue"><span class="function-name">setSnapFlagValue</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-setSnapFlagValue">setSnapFlagValue</a>(uint role, bool)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-snapFlag" href="#flGuideLine-snapFlag"><span class="function-name">snapFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">uint <a href="#flGuideLine-snapFlag">snapFlag</a>(uint role)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-tag" href="#flGuideLine-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-update" href="#flGuideLine-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine-update">update</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flGuideLine-cloneObject" href="#flGuideLine-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flGuideLine-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-counterPaper" href="#flGuideLine-counterPaper"><span class="function-name">counterPaper</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flGuideLine-counterPaper">counterPaper</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-createInstance" href="#flGuideLine-createInstance"><span class="function-name">createInstance</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGuideLine">flGuideLine</a> <a href="#flGuideLine-createInstance">createInstance</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-createObject" href="#flGuideLine-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flGuideLine-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-createPowerGuides" href="#flGuideLine-createPowerGuides"><span class="function-name">createPowerGuides</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGuideLine-createPowerGuides">createPowerGuides</a>(fgFont, <a href="#flLayer">flLayer</a>, bool horizontal, bool vertical, bool diagonal[, bool use_glyph_guides=true[, bool use_font_guides = true]])</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-getHashCode" href="#flGuideLine-getHashCode"><span class="function-name">getHashCode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">long <a href="#flGuideLine-getHashCode">getHashCode</a>(QPointF, double angle)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-haveObject" href="#flGuideLine-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGuideLine-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-instanceType" href="#flGuideLine-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flGuideLine-instanceType">instanceType</a>();</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-isGuideLine" href="#flGuideLine-isGuideLine"><span class="function-name">isGuideLine</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGuideLine-isGuideLine">isGuideLine</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-isSnapLine" href="#flGuideLine-isSnapLine"><span class="function-name">isSnapLine</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flGuideLine-isSnapLine">isSnapLine</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flGuideLine-sortGuideLines" href="#flGuideLine-sortGuideLines"><span class="function-name">sortGuideLines</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#flGuideLine">flGuideLine</a>) <a href="#flGuideLine-sortGuideLines">sortGuideLines</a>(list(<a href="#flGuideLine">flGuideLine</a>)[, bool ascending = true])</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>angle</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>angleMode</dt>
<dd>

<pre class="doc" markdown="0">SnapAngleMode</pre>

</dd>
</dl>
<dl class="descriptor"><dt>center</dt>
<dd>

<pre class="doc" markdown="0">flNode</pre>

</dd>
</dl>
<dl class="descriptor"><dt>centerPoint</dt>
<dd>

<pre class="doc" markdown="0">QPointF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>color</dt>
<dd>

<pre class="doc" markdown="0">QColor</pre>

</dd>
</dl>
<dl class="descriptor"><dt>constraints</dt>
<dd>

<pre class="doc" markdown="0">QRectF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>expression</dt>
<dd>

<pre class="doc" markdown="0">QString</pre>

</dd>
</dl>
<dl class="descriptor"><dt>extLinef</dt>
<dd>

<pre class="doc" markdown="0">QLineF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>extPosition</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasColor</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasExpression</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasTags</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>haveExtLine</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isAbsoluteMarkerPos</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isExluded</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isHint</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isInUse</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isMeasurementLine</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPassive</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isShortGuideline</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isVerticalQuarter</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isZone</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>length</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>linef</dt>
<dd>

<pre class="doc" markdown="0">QLineF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>markers</dt>
<dd>

<pre class="doc" markdown="0">list(flMarkerPoint)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>markersStructVersion</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>snapFlags</dt>
<dd>

<pre class="doc" markdown="0">uint</pre>

</dd>
</dl>
<dl class="descriptor"><dt>style</dt>
<dd>

<pre class="doc" markdown="0">SnapObjectsStyle</pre>

</dd>
</dl>
<dl class="descriptor"><dt>tags</dt>
<dd>

<pre class="doc" markdown="0">QSet<QString></pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>
<dl class="descriptor"><dt>vector</dt>
<dd>

<pre class="doc" markdown="0">flNode</pre>

</dd>
</dl>
<dl class="descriptor"><dt>vectorPoint</dt>
<dd>

<pre class="doc" markdown="0">QPointF</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flGuideLine-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flHintingParameters" href="#flHintingParameters">class <span class="class-name">flHintingParameters</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flHintingParameters representation

Constructors:
  flHintingParameters() - default</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flHintingParameters-__delattr__" href="#flHintingParameters-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flHintingParameters-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flHintingParameters-__getattribute__" href="#flHintingParameters-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flHintingParameters-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flHintingParameters-__init__" href="#flHintingParameters-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flHintingParameters-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flHintingParameters-__repr__" href="#flHintingParameters-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flHintingParameters-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flHintingParameters-__setattr__" href="#flHintingParameters-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flHintingParameters-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flHintingParameters-init" href="#flHintingParameters-init"><span class="function-name">init</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flHintingParameters-init">init</a>()</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>blueFuzz</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>blueScale</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>blueShift</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>codePPM</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>dropoutPPM</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>flex</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>fontDirectionHint</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>forceBold</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>forceBoldTreshold</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>lowestRecPPEM</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>maxFunctionDefs</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>maxInstructionDefs</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>maxStackElements</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>maxStorage</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>maxTwilightPoints</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>maxZones</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>stemSnapLimit</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>zonePPM</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flHintingParameters-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="flInstance" href="#flInstance">class <span class="class-name">flInstance</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flInstance representation

Constructors:
  flInstance()
  flInstance(string name, string tsn, flLocation location)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flInstance-__delattr__" href="#flInstance-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flInstance-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flInstance-__getattribute__" href="#flInstance-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flInstance-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flInstance-__init__" href="#flInstance-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flInstance-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flInstance-__repr__" href="#flInstance-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flInstance-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flInstance-__setattr__" href="#flInstance-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flInstance-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flInstance-autoSGN" href="#flInstance-autoSGN"><span class="function-name">autoSGN</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#flInstance-autoSGN">autoSGN</a>(const string &tfn)</pre>

</dd></dl>
<dl class="function"><dt><a name="flInstance-autoSLV" href="#flInstance-autoSLV"><span class="function-name">autoSLV</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flInstance-autoSLV">autoSLV</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flInstance-autoTSN" href="#flInstance-autoTSN"><span class="function-name">autoTSN</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#flInstance-autoTSN">autoTSN</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flInstance-setSLV" href="#flInstance-setSLV"><span class="function-name">setSLV</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flInstance-setSLV">setSLV</a>(bool bold, bool italic)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>bold</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>exportable</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>italic</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>location</dt>
<dd>

<pre class="doc" markdown="0">flLocation</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>sgn</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>slv</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>tsn</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>weight</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>weightValue</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>width</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flInstance-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="flItems" href="#flItems">class <span class="class-name">flItems</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flItems representation

Constructors:
  flItems()</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flItems-__delattr__" href="#flItems-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flItems-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-__getattribute__" href="#flItems-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flItems-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-__init__" href="#flItems-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flItems-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-__repr__" href="#flItems-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flItems-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-__setattr__" href="#flItems-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flItems-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-shapeBuilders" href="#flItems-shapeBuilders"><span class="function-name">shapeBuilders</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#flObject">flObject</a>) <a href="#flItems-shapeBuilders">shapeBuilders</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flItems-appendRecentFile" href="#flItems-appendRecentFile"><span class="function-name">appendRecentFile</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-appendRecentFile">appendRecentFile</a>(QString, QString file_name)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-buildRecentList" href="#flItems-buildRecentList"><span class="function-name">buildRecentList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QStringList/Nothing <a href="#flItems-buildRecentList">buildRecentList</a>(QString)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-clearRecentFiles" href="#flItems-clearRecentFiles"><span class="function-name">clearRecentFiles</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-clearRecentFiles">clearRecentFiles</a>(QString )</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-createObject" href="#flItems-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flItems-createObject">createObject</a>(int type, <a href="#flObject">flObject</a> key)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-getCursor" href="#flItems-getCursor"><span class="function-name">getCursor</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QCursor <a href="#flItems-getCursor">getCursor</a>(CursorId)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-getCursorId" href="#flItems-getCursorId"><span class="function-name">getCursorId</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">CursorId <a href="#flItems-getCursorId">getCursorId</a>(QString, int hot_x, int hot_y)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-guidelinesEditingEnabled" href="#flItems-guidelinesEditingEnabled"><span class="function-name">guidelinesEditingEnabled</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flItems-guidelinesEditingEnabled">guidelinesEditingEnabled</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-init" href="#flItems-init"><span class="function-name">init</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-init">init</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-instance" href="#flItems-instance"><span class="function-name">instance</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems">flItems</a> <a href="#flItems-instance">instance</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyActivateGlyph" href="#flItems-notifyActivateGlyph"><span class="function-name">notifyActivateGlyph</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyActivateGlyph">notifyActivateGlyph</a>(<a href="#flGlyphInfo">flGlyphInfo</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyAnchorsChanged" href="#flItems-notifyAnchorsChanged"><span class="function-name">notifyAnchorsChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyAnchorsChanged">notifyAnchorsChanged</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyApplyTranformFrame" href="#flItems-notifyApplyTranformFrame"><span class="function-name">notifyApplyTranformFrame</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyApplyTranformFrame">notifyApplyTranformFrame</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyAuditHovered" href="#flItems-notifyAuditHovered"><span class="function-name">notifyAuditHovered</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyAuditHovered">notifyAuditHovered</a>(uint id)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyAutoShapseChanges" href="#flItems-notifyAutoShapseChanges"><span class="function-name">notifyAutoShapseChanges</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyAutoShapseChanges">notifyAutoShapseChanges</a>(<a href="#flLayer">flLayer</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyAvailableToSelectNodes" href="#flItems-notifyAvailableToSelectNodes"><span class="function-name">notifyAvailableToSelectNodes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyAvailableToSelectNodes">notifyAvailableToSelectNodes</a>( list(list(<a href="#flNodeInfo">flNodeInfo</a>)) )</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyBrushModeSelected" href="#flItems-notifyBrushModeSelected"><span class="function-name">notifyBrushModeSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyBrushModeSelected">notifyBrushModeSelected</a>(bool smart)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyBrushSelected" href="#flItems-notifyBrushSelected"><span class="function-name">notifyBrushSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyBrushSelected">notifyBrushSelected</a>(<a href="#PaintBrush">PaintBrush</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyBrushSet" href="#flItems-notifyBrushSet"><span class="function-name">notifyBrushSet</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyBrushSet">notifyBrushSet</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyCancelTranformFrame" href="#flItems-notifyCancelTranformFrame"><span class="function-name">notifyCancelTranformFrame</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyCancelTranformFrame">notifyCancelTranformFrame</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyCanvasAttached" href="#flItems-notifyCanvasAttached"><span class="function-name">notifyCanvasAttached</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyCanvasAttached">notifyCanvasAttached</a>(<a href="#flCanvas">flCanvas</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyCanvasEnterFocus" href="#flItems-notifyCanvasEnterFocus"><span class="function-name">notifyCanvasEnterFocus</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyCanvasEnterFocus">notifyCanvasEnterFocus</a>(<a href="#flCanvas">flCanvas</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyCanvasLeaveFocus" href="#flItems-notifyCanvasLeaveFocus"><span class="function-name">notifyCanvasLeaveFocus</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyCanvasLeaveFocus">notifyCanvasLeaveFocus</a>(<a href="#flCanvas">flCanvas</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyCanvasRemoved" href="#flItems-notifyCanvasRemoved"><span class="function-name">notifyCanvasRemoved</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyCanvasRemoved">notifyCanvasRemoved</a>(<a href="#flCanvas">flCanvas</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyChangesApplied" href="#flItems-notifyChangesApplied"><span class="function-name">notifyChangesApplied</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyChangesApplied">notifyChangesApplied</a>([QString title, <a href="#flObject">flObject</a> <a href="./__builtin__.html#object">object</a> / list(<a href="#flObject">flObject</a>)[, bool recursive=false]])</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyClipboardChanged" href="#flItems-notifyClipboardChanged"><span class="function-name">notifyClipboardChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyClipboardChanged">notifyClipboardChanged</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyColorSet" href="#flItems-notifyColorSet"><span class="function-name">notifyColorSet</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyColorSet">notifyColorSet</a>(QColor, bool b)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyCommandSelected" href="#flItems-notifyCommandSelected"><span class="function-name">notifyCommandSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyCommandSelected">notifyCommandSelected</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyCurrentPaperChanged" href="#flItems-notifyCurrentPaperChanged"><span class="function-name">notifyCurrentPaperChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyCurrentPaperChanged">notifyCurrentPaperChanged</a>(<a href="#flPaper">flPaper</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyDropDone" href="#flItems-notifyDropDone"><span class="function-name">notifyDropDone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyDropDone">notifyDropDone</a>(<a href="#flCanvas">flCanvas</a>& canvas)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyEditActionFinished" href="#flItems-notifyEditActionFinished"><span class="function-name">notifyEditActionFinished</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyEditActionFinished">notifyEditActionFinished</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyEditActionStarted" href="#flItems-notifyEditActionStarted"><span class="function-name">notifyEditActionStarted</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyEditActionStarted">notifyEditActionStarted</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyEditModeChanged" href="#flItems-notifyEditModeChanged"><span class="function-name">notifyEditModeChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyEditModeChanged">notifyEditModeChanged</a>(EditMode mode)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyEditingChanged" href="#flItems-notifyEditingChanged"><span class="function-name">notifyEditingChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyEditingChanged">notifyEditingChanged</a>(<a href="#flAbstractEditor">flAbstractEditor</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyEditingFinished" href="#flItems-notifyEditingFinished"><span class="function-name">notifyEditingFinished</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyEditingFinished">notifyEditingFinished</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyFeaturesChanged" href="#flItems-notifyFeaturesChanged"><span class="function-name">notifyFeaturesChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyFeaturesChanged">notifyFeaturesChanged</a>(uint package_id, bool binary)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyFontPanelActivated" href="#flItems-notifyFontPanelActivated"><span class="function-name">notifyFontPanelActivated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyFontPanelActivated">notifyFontPanelActivated</a>(bool b)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyFontSelected" href="#flItems-notifyFontSelected"><span class="function-name">notifyFontSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyFontSelected">notifyFontSelected</a>(uint id);</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyFrameSelected" href="#flItems-notifyFrameSelected"><span class="function-name">notifyFrameSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyFrameSelected">notifyFrameSelected</a>(list(<a href="#flNodeInfo">flNodeInfo</a>))</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyGalleryChanged" href="#flItems-notifyGalleryChanged"><span class="function-name">notifyGalleryChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyGalleryChanged">notifyGalleryChanged</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyGlyphActivated" href="#flItems-notifyGlyphActivated"><span class="function-name">notifyGlyphActivated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyGlyphActivated">notifyGlyphActivated</a>(<a href="#flGlyphInfo">flGlyphInfo</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyGlyphDeactivated" href="#flItems-notifyGlyphDeactivated"><span class="function-name">notifyGlyphDeactivated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyGlyphDeactivated">notifyGlyphDeactivated</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyGlyphDoubleClick" href="#flItems-notifyGlyphDoubleClick"><span class="function-name">notifyGlyphDoubleClick</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyGlyphDoubleClick">notifyGlyphDoubleClick</a>(<a href="#flGlyphInfo">flGlyphInfo</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyGlyphIdSelected" href="#flItems-notifyGlyphIdSelected"><span class="function-name">notifyGlyphIdSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyGlyphIdSelected">notifyGlyphIdSelected</a>(uint packageId, uint glyphId, bool replace)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyGlyphMaximized" href="#flItems-notifyGlyphMaximized"><span class="function-name">notifyGlyphMaximized</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyGlyphMaximized">notifyGlyphMaximized</a>(<a href="#flGlyphInfo">flGlyphInfo</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyGlyphPinPointChanged" href="#flItems-notifyGlyphPinPointChanged"><span class="function-name">notifyGlyphPinPointChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyGlyphPinPointChanged">notifyGlyphPinPointChanged</a>([<a href="#flPinPoint">flPinPoint</a> pin_point = flnull[, <a href="#flGlyphInfo">flGlyphInfo</a> glyph_info = flnull]])</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyGlyphPinPointCreated" href="#flItems-notifyGlyphPinPointCreated"><span class="function-name">notifyGlyphPinPointCreated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyGlyphPinPointCreated">notifyGlyphPinPointCreated</a>(<a href="#flGlyphInfo">flGlyphInfo</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyGlyphUpdated" href="#flItems-notifyGlyphUpdated"><span class="function-name">notifyGlyphUpdated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyGlyphUpdated">notifyGlyphUpdated</a>(uint packageId, uint glyphId)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyGlyphWindowInactive" href="#flItems-notifyGlyphWindowInactive"><span class="function-name">notifyGlyphWindowInactive</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyGlyphWindowInactive">notifyGlyphWindowInactive</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyGlyphsUpdated" href="#flItems-notifyGlyphsUpdated"><span class="function-name">notifyGlyphsUpdated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyGlyphsUpdated">notifyGlyphsUpdated</a>(uint packageId, QSet<uint32_t> glyphIds)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyGraphEdgeSelectionChanged" href="#flItems-notifyGraphEdgeSelectionChanged"><span class="function-name">notifyGraphEdgeSelectionChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyGraphEdgeSelectionChanged">notifyGraphEdgeSelectionChanged</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyGuidelinesChanged" href="#flItems-notifyGuidelinesChanged"><span class="function-name">notifyGuidelinesChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyGuidelinesChanged">notifyGuidelinesChanged</a>(<a href="#flCanvas">flCanvas</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyGuidelinesSelected" href="#flItems-notifyGuidelinesSelected"><span class="function-name">notifyGuidelinesSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyGuidelinesSelected">notifyGuidelinesSelected</a>(list(<a href="#flGuideLine">flGuideLine</a>))</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyHidePanels" href="#flItems-notifyHidePanels"><span class="function-name">notifyHidePanels</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyHidePanels">notifyHidePanels</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyHistoryChanged" href="#flItems-notifyHistoryChanged"><span class="function-name">notifyHistoryChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyHistoryChanged">notifyHistoryChanged</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyKeyHash" href="#flItems-notifyKeyHash"><span class="function-name">notifyKeyHash</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyKeyHash">notifyKeyHash</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyKeyRepeat" href="#flItems-notifyKeyRepeat"><span class="function-name">notifyKeyRepeat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyKeyRepeat">notifyKeyRepeat</a>(int key)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyKeySlash" href="#flItems-notifyKeySlash"><span class="function-name">notifyKeySlash</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyKeySlash">notifyKeySlash</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyLayerActivated" href="#flItems-notifyLayerActivated"><span class="function-name">notifyLayerActivated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyLayerActivated">notifyLayerActivated</a>(<a href="#flLayer">flLayer</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyModelChanged" href="#flItems-notifyModelChanged"><span class="function-name">notifyModelChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyModelChanged">notifyModelChanged</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyNodeChanged" href="#flItems-notifyNodeChanged"><span class="function-name">notifyNodeChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyNodeChanged">notifyNodeChanged</a>(<a href="#flNodeInfo">flNodeInfo</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyNodesSelected" href="#flItems-notifyNodesSelected"><span class="function-name">notifyNodesSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyNodesSelected">notifyNodesSelected</a>(list(<a href="#flNodeInfo">flNodeInfo</a>))</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyPackageAdded" href="#flItems-notifyPackageAdded"><span class="function-name">notifyPackageAdded</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyPackageAdded">notifyPackageAdded</a>(<a href="#flPackage">flPackage</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyPackageClosed" href="#flItems-notifyPackageClosed"><span class="function-name">notifyPackageClosed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyPackageClosed">notifyPackageClosed</a>(<a href="#flPackage">flPackage</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyPackageContentUpdated" href="#flItems-notifyPackageContentUpdated"><span class="function-name">notifyPackageContentUpdated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyPackageContentUpdated">notifyPackageContentUpdated</a>(uint id)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyPackageReaded" href="#flItems-notifyPackageReaded"><span class="function-name">notifyPackageReaded</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyPackageReaded">notifyPackageReaded</a>(<a href="#flPackage">flPackage</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyPackageRemoved" href="#flItems-notifyPackageRemoved"><span class="function-name">notifyPackageRemoved</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyPackageRemoved">notifyPackageRemoved</a>(<a href="#flPackage">flPackage</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyPackageUpdated" href="#flItems-notifyPackageUpdated"><span class="function-name">notifyPackageUpdated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyPackageUpdated">notifyPackageUpdated</a>(<a href="#flPackage">flPackage</a> | uint id)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyPackagesRemoved" href="#flItems-notifyPackagesRemoved"><span class="function-name">notifyPackagesRemoved</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyPackagesRemoved">notifyPackagesRemoved</a>(list(<a href="#flObject">flObject</a>))</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyPackagesUpdated" href="#flItems-notifyPackagesUpdated"><span class="function-name">notifyPackagesUpdated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyPackagesUpdated">notifyPackagesUpdated</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyPinPointChanged" href="#flItems-notifyPinPointChanged"><span class="function-name">notifyPinPointChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyPinPointChanged">notifyPinPointChanged</a>([<a href="#flPinPoint">flPinPoint</a> pin_point = flnull[, <a href="#flShapeInfo">flShapeInfo</a> shape_info = flnull]])</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyPinPointCreated" href="#flItems-notifyPinPointCreated"><span class="function-name">notifyPinPointCreated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyPinPointCreated">notifyPinPointCreated</a>(<a href="#flShapeInfo">flShapeInfo</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyPinPointSelectionChanged" href="#flItems-notifyPinPointSelectionChanged"><span class="function-name">notifyPinPointSelectionChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyPinPointSelectionChanged">notifyPinPointSelectionChanged</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyPinSelected" href="#flItems-notifyPinSelected"><span class="function-name">notifyPinSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyPinSelected">notifyPinSelected</a>(uint id)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyPreferencesChanged" href="#flItems-notifyPreferencesChanged"><span class="function-name">notifyPreferencesChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyPreferencesChanged">notifyPreferencesChanged</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyProjectClosed" href="#flItems-notifyProjectClosed"><span class="function-name">notifyProjectClosed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyProjectClosed">notifyProjectClosed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyProjectReaded" href="#flItems-notifyProjectReaded"><span class="function-name">notifyProjectReaded</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyProjectReaded">notifyProjectReaded</a>(QString file_name)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyProjectSaved" href="#flItems-notifyProjectSaved"><span class="function-name">notifyProjectSaved</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyProjectSaved">notifyProjectSaved</a>(QString file_name)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyPropertiesChanged" href="#flItems-notifyPropertiesChanged"><span class="function-name">notifyPropertiesChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyPropertiesChanged">notifyPropertiesChanged</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyRenderingBegin" href="#flItems-notifyRenderingBegin"><span class="function-name">notifyRenderingBegin</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyRenderingBegin">notifyRenderingBegin</a>(QString info)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyRenderingFinished" href="#flItems-notifyRenderingFinished"><span class="function-name">notifyRenderingFinished</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyRenderingFinished">notifyRenderingFinished</a>(bool success)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyReplaceGlyphsByFgId" href="#flItems-notifyReplaceGlyphsByFgId"><span class="function-name">notifyReplaceGlyphsByFgId</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyReplaceGlyphsByFgId">notifyReplaceGlyphsByFgId</a>(list(unsigned long), int replace_count)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyRequestChangeCurrentClipboard" href="#flItems-notifyRequestChangeCurrentClipboard"><span class="function-name">notifyRequestChangeCurrentClipboard</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyRequestChangeCurrentClipboard">notifyRequestChangeCurrentClipboard</a>(QString xml)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyRequestNewProject" href="#flItems-notifyRequestNewProject"><span class="function-name">notifyRequestNewProject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyRequestNewProject">notifyRequestNewProject</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyRequestOpenProject" href="#flItems-notifyRequestOpenProject"><span class="function-name">notifyRequestOpenProject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyRequestOpenProject">notifyRequestOpenProject</a>(QString file_name)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyRequestPasteAction" href="#flItems-notifyRequestPasteAction"><span class="function-name">notifyRequestPasteAction</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyRequestPasteAction">notifyRequestPasteAction</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyRequestShowWelcome" href="#flItems-notifyRequestShowWelcome"><span class="function-name">notifyRequestShowWelcome</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyRequestShowWelcome">notifyRequestShowWelcome</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyRequestShowWorkspace" href="#flItems-notifyRequestShowWorkspace"><span class="function-name">notifyRequestShowWorkspace</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyRequestShowWorkspace">notifyRequestShowWorkspace</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifySCVItemsChanged" href="#flItems-notifySCVItemsChanged"><span class="function-name">notifySCVItemsChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifySCVItemsChanged">notifySCVItemsChanged</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyScrollToGlyph" href="#flItems-notifyScrollToGlyph"><span class="function-name">notifyScrollToGlyph</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyScrollToGlyph">notifyScrollToGlyph</a>(<a href="#flGlyphInfo">flGlyphInfo</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifySelectionChanged" href="#flItems-notifySelectionChanged"><span class="function-name">notifySelectionChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifySelectionChanged">notifySelectionChanged</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyShapeActivated" href="#flItems-notifyShapeActivated"><span class="function-name">notifyShapeActivated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyShapeActivated">notifyShapeActivated</a>(<a href="#flShapeInfo">flShapeInfo</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyShapeDeactivated" href="#flItems-notifyShapeDeactivated"><span class="function-name">notifyShapeDeactivated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyShapeDeactivated">notifyShapeDeactivated</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyShowPanels" href="#flItems-notifyShowPanels"><span class="function-name">notifyShowPanels</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyShowPanels">notifyShowPanels</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifySnapLineChanged" href="#flItems-notifySnapLineChanged"><span class="function-name">notifySnapLineChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifySnapLineChanged">notifySnapLineChanged</a>(<a href="#flGuideLine">flGuideLine</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifySnapLinesChanged" href="#flItems-notifySnapLinesChanged"><span class="function-name">notifySnapLinesChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifySnapLinesChanged">notifySnapLinesChanged</a>(list(<a href="#flGuideLine">flGuideLine</a>))</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyStaplerPreviewEnabled" href="#flItems-notifyStaplerPreviewEnabled"><span class="function-name">notifyStaplerPreviewEnabled</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyStaplerPreviewEnabled">notifyStaplerPreviewEnabled</a>(bool enbl)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyStickerCreated" href="#flItems-notifyStickerCreated"><span class="function-name">notifyStickerCreated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyStickerCreated">notifyStickerCreated</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyStopButtonClicked" href="#flItems-notifyStopButtonClicked"><span class="function-name">notifyStopButtonClicked</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyStopButtonClicked">notifyStopButtonClicked</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyTextBlockAdded" href="#flItems-notifyTextBlockAdded"><span class="function-name">notifyTextBlockAdded</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyTextBlockAdded">notifyTextBlockAdded</a>(<a href="#flTextBlock">flTextBlock</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyTextBlockItemActivated" href="#flItems-notifyTextBlockItemActivated"><span class="function-name">notifyTextBlockItemActivated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyTextBlockItemActivated">notifyTextBlockItemActivated</a>(flTextBlockItem[, bool check_tools = true])</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyTextBlockItemChanged" href="#flItems-notifyTextBlockItemChanged"><span class="function-name">notifyTextBlockItemChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyTextBlockItemChanged">notifyTextBlockItemChanged</a>(flTextBlockItem)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyTextBlockItemDeactivated" href="#flItems-notifyTextBlockItemDeactivated"><span class="function-name">notifyTextBlockItemDeactivated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyTextBlockItemDeactivated">notifyTextBlockItemDeactivated</a>(flTextBlockItem)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyTextBlockItemMaximized" href="#flItems-notifyTextBlockItemMaximized"><span class="function-name">notifyTextBlockItemMaximized</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyTextBlockItemMaximized">notifyTextBlockItemMaximized</a>(flTextBlockItem)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyTextBlockItemNormalized" href="#flItems-notifyTextBlockItemNormalized"><span class="function-name">notifyTextBlockItemNormalized</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyTextBlockItemNormalized">notifyTextBlockItemNormalized</a>(flTextBlockItem)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyTextBlockItemsSelectionChanged" href="#flItems-notifyTextBlockItemsSelectionChanged"><span class="function-name">notifyTextBlockItemsSelectionChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyTextBlockItemsSelectionChanged">notifyTextBlockItemsSelectionChanged</a>(<a href="#flCanvas">flCanvas</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyTextBlockRemoved" href="#flItems-notifyTextBlockRemoved"><span class="function-name">notifyTextBlockRemoved</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyTextBlockRemoved">notifyTextBlockRemoved</a>(<a href="#flTextBlock">flTextBlock</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyToolChanged" href="#flItems-notifyToolChanged"><span class="function-name">notifyToolChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyToolChanged">notifyToolChanged</a>(<a href="#flBasicTool">flBasicTool</a>& tool)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyTransformDataChanged" href="#flItems-notifyTransformDataChanged"><span class="function-name">notifyTransformDataChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyTransformDataChanged">notifyTransformDataChanged</a>(<a href="#TransformFrame">TransformFrame</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyTransformFrameChanged" href="#flItems-notifyTransformFrameChanged"><span class="function-name">notifyTransformFrameChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyTransformFrameChanged">notifyTransformFrameChanged</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyTransformFrameFinished" href="#flItems-notifyTransformFrameFinished"><span class="function-name">notifyTransformFrameFinished</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyTransformFrameFinished">notifyTransformFrameFinished</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyTransformFrameStarted" href="#flItems-notifyTransformFrameStarted"><span class="function-name">notifyTransformFrameStarted</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyTransformFrameStarted">notifyTransformFrameStarted</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyTransformStarted" href="#flItems-notifyTransformStarted"><span class="function-name">notifyTransformStarted</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyTransformStarted">notifyTransformStarted</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyUpdateHistory" href="#flItems-notifyUpdateHistory"><span class="function-name">notifyUpdateHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyUpdateHistory">notifyUpdateHistory</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyUpdateStaplers" href="#flItems-notifyUpdateStaplers"><span class="function-name">notifyUpdateStaplers</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyUpdateStaplers">notifyUpdateStaplers</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyViewportChanged" href="#flItems-notifyViewportChanged"><span class="function-name">notifyViewportChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyViewportChanged">notifyViewportChanged</a>(QWidget* old_viewport, QWidget* new_viewport)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyWorkspaceClosed" href="#flItems-notifyWorkspaceClosed"><span class="function-name">notifyWorkspaceClosed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyWorkspaceClosed">notifyWorkspaceClosed</a>(<a href="#flWorkspace">flWorkspace</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyWorkspaceHasChanges" href="#flItems-notifyWorkspaceHasChanges"><span class="function-name">notifyWorkspaceHasChanges</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyWorkspaceHasChanges">notifyWorkspaceHasChanges</a>(bool c)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyWorkspaceInitialized" href="#flItems-notifyWorkspaceInitialized"><span class="function-name">notifyWorkspaceInitialized</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyWorkspaceInitialized">notifyWorkspaceInitialized</a>(<a href="#flWorkspace">flWorkspace</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-notifyZoomChanged" href="#flItems-notifyZoomChanged"><span class="function-name">notifyZoomChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-notifyZoomChanged">notifyZoomChanged</a>(<a href="#flCanvas">flCanvas</a>& canvas)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestActivateNodesTool" href="#flItems-requestActivateNodesTool"><span class="function-name">requestActivateNodesTool</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-requestActivateNodesTool">requestActivateNodesTool</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestActivateShapeTool" href="#flItems-requestActivateShapeTool"><span class="function-name">requestActivateShapeTool</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-requestActivateShapeTool">requestActivateShapeTool</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestActivateTransformTool" href="#flItems-requestActivateTransformTool"><span class="function-name">requestActivateTransformTool</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-requestActivateTransformTool">requestActivateTransformTool</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestCheckHistoryInitIndex" href="#flItems-requestCheckHistoryInitIndex"><span class="function-name">requestCheckHistoryInitIndex</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-requestCheckHistoryInitIndex">requestCheckHistoryInitIndex</a>(<a href="#flGlyphInfo">flGlyphInfo</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestContent" href="#flItems-requestContent"><span class="function-name">requestContent</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-requestContent">requestContent</a>(<a href="#fgSymbolList">fgSymbolList</a> characters, int cursorLocation</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestFontInfoDlg" href="#flItems-requestFontInfoDlg"><span class="function-name">requestFontInfoDlg</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-requestFontInfoDlg">requestFontInfoDlg</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestGlyphActivate" href="#flItems-requestGlyphActivate"><span class="function-name">requestGlyphActivate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-requestGlyphActivate">requestGlyphActivate</a>(uint pid, uint gid)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestGlyphDeactivate" href="#flItems-requestGlyphDeactivate"><span class="function-name">requestGlyphDeactivate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-requestGlyphDeactivate">requestGlyphDeactivate</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestGlyphReactivated" href="#flItems-requestGlyphReactivated"><span class="function-name">requestGlyphReactivated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-requestGlyphReactivated">requestGlyphReactivated</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestLoadingFont" href="#flItems-requestLoadingFont"><span class="function-name">requestLoadingFont</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-requestLoadingFont">requestLoadingFont</a>(QString font_source)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestPackageAcceptFonts" href="#flItems-requestPackageAcceptFonts"><span class="function-name">requestPackageAcceptFonts</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-requestPackageAcceptFonts">requestPackageAcceptFonts</a>(<a href="#flPackage">flPackage</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestPackagePostProcess" href="#flItems-requestPackagePostProcess"><span class="function-name">requestPackagePostProcess</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-requestPackagePostProcess">requestPackagePostProcess</a>(<a href="#flPackage">flPackage</a>, QString encoding)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestPermissionsForDragGuidelineByNode" href="#flItems-requestPermissionsForDragGuidelineByNode"><span class="function-name">requestPermissionsForDragGuidelineByNode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flItems-requestPermissionsForDragGuidelineByNode">requestPermissionsForDragGuidelineByNode</a>(QPointF canvas_pos, uint modifiers)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestProgressMessage" href="#flItems-requestProgressMessage"><span class="function-name">requestProgressMessage</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-requestProgressMessage">requestProgressMessage</a>(QString message)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestProgressRange" href="#flItems-requestProgressRange"><span class="function-name">requestProgressRange</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-requestProgressRange">requestProgressRange</a>(int v)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestProgressShow" href="#flItems-requestProgressShow"><span class="function-name">requestProgressShow</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-requestProgressShow">requestProgressShow</a>(bool b)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestProgressValue" href="#flItems-requestProgressValue"><span class="function-name">requestProgressValue</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-requestProgressValue">requestProgressValue</a>(int v)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestSaveBar" href="#flItems-requestSaveBar"><span class="function-name">requestSaveBar</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-requestSaveBar">requestSaveBar</a>(bool b)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestSaveBarValue" href="#flItems-requestSaveBarValue"><span class="function-name">requestSaveBarValue</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-requestSaveBarValue">requestSaveBarValue</a>(int v)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestSubContent" href="#flItems-requestSubContent"><span class="function-name">requestSubContent</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-requestSubContent">requestSubContent</a>(<a href="#fgSymbolList">fgSymbolList</a> characters, int cursorLocation</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-requestUpdateActiveShape" href="#flItems-requestUpdateActiveShape"><span class="function-name">requestUpdateActiveShape</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-requestUpdateActiveShape">requestUpdateActiveShape</a>(<a href="#flShapeInfo">flShapeInfo</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-resetToolCursor" href="#flItems-resetToolCursor"><span class="function-name">resetToolCursor</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-resetToolCursor">resetToolCursor</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-setCursor" href="#flItems-setCursor"><span class="function-name">setCursor</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-setCursor">setCursor</a>(CursorId cursor_id);</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-setEllipseCurvature" href="#flItems-setEllipseCurvature"><span class="function-name">setEllipseCurvature</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-setEllipseCurvature">setEllipseCurvature</a>(double d)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-setEllipseData" href="#flItems-setEllipseData"><span class="function-name">setEllipseData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-setEllipseData">setEllipseData</a>(QPointF p0, QPointF p1)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-setGuidelinesEditingEnabled" href="#flItems-setGuidelinesEditingEnabled"><span class="function-name">setGuidelinesEditingEnabled</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-setGuidelinesEditingEnabled">setGuidelinesEditingEnabled</a>(bool b)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-setMeterData" href="#flItems-setMeterData"><span class="function-name">setMeterData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-setMeterData">setMeterData</a>(QPointF p0, QPointF p1)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-setParameterName" href="#flItems-setParameterName"><span class="function-name">setParameterName</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-setParameterName">setParameterName</a>(<a href="#flObject">flObject</a>, QString)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-setTransformation" href="#flItems-setTransformation"><span class="function-name">setTransformation</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flItems-setTransformation">setTransformation</a>(int code, QPointF value)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-strToType" href="#flItems-strToType"><span class="function-name">strToType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flItems-strToType">strToType</a>(QString)</pre>

</dd></dl>
<dl class="function"><dt><a name="flItems-typeToStr" href="#flItems-typeToStr"><span class="function-name">typeToStr</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QString <a href="#flItems-typeToStr">typeToStr</a>(int type)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>qobject</dt>
<dd>

<pre class="doc" markdown="0">QObject</pre>

</dd>
</dl>
<dl class="descriptor"><dt>workspace</dt>
<dd>

<pre class="doc" markdown="0">flObject</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">ItemStates</span> = {'AutoUpdate': 2097152, 'Custom': 1048576, 'Hovered': 131072, 'Locked': 2, 'Normal': 0, 'Preview': 524288, 'Selected': 65536, 'Small': 262144, 'Visible': 1}</dt></dl>
<dl><dt><span class="other-name">ItemType</span> = {}</dt></dl>
<dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flItems-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">bBrush</span> = 9</dt></dl>
<dl><dt><span class="other-name">bCount</span> = 14</dt></dl>
<dl><dt><span class="other-name">bEllipse</span> = 6</dt></dl>
<dl><dt><span class="other-name">bGlyph</span> = 3</dt></dl>
<dl><dt><span class="other-name">bGuideline</span> = 2</dt></dl>
<dl><dt><span class="other-name">bMeter</span> = 5</dt></dl>
<dl><dt><span class="other-name">bMetrics</span> = 0</dt></dl>
<dl><dt><span class="other-name">bPen</span> = 7</dt></dl>
<dl><dt><span class="other-name">bPin</span> = 4</dt></dl>
<dl><dt><span class="other-name">bSingleNode</span> = 1</dt></dl>
<dl><dt><span class="other-name">bText</span> = 10</dt></dl>
<dl><dt><span class="other-name">bTransform</span> = 8</dt></dl>
<dl><dt><span class="other-name">transformRotate</span> = 2</dt></dl>
<dl><dt><span class="other-name">transformScale</span> = 1</dt></dl>
<dl><dt><span class="other-name">transformShift</span> = 0</dt></dl>
<dl><dt><span class="other-name">transformSlant</span> = 3</dt></dl>
</dd>
<dt class="class"><h2><a name="flLayer" href="#flLayer">class <span class="class-name">flLayer</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flLayer representation

Constructors:
  flLayer()
  flLayer(flObject)
  flLayer(flGlyph)
  flLayer('title')</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flLayer-__delattr__" href="#flLayer-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayer-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-__eq__" href="#flLayer-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayer-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-__ge__" href="#flLayer-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayer-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-__getattribute__" href="#flLayer-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayer-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-__gt__" href="#flLayer-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayer-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-__init__" href="#flLayer-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayer-__init__">__init__</a>(...) initializes x; see help(<a href="#flLayer-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-__le__" href="#flLayer-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayer-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-__lt__" href="#flLayer-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayer-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-__ne__" href="#flLayer-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayer-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-__repr__" href="#flLayer-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayer-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-__setattr__" href="#flLayer-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayer-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-addAnchor" href="#flLayer-addAnchor"><span class="function-name">addAnchor</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-addAnchor">addAnchor</a>(<a href="#flPinPoint">flPinPoint</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-addComponent" href="#flLayer-addComponent"><span class="function-name">addComponent</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-addComponent">addComponent</a>(flComponent component)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-addShape" href="#flLayer-addShape"><span class="function-name">addShape</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flShape">flShape</a> <a href="#flLayer-addShape">addShape</a>(<a href="#flShape">flShape</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-addShapes" href="#flLayer-addShapes"><span class="function-name">addShapes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-addShapes">addShapes</a>(list(<a href="#flShape">flShape</a>))</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-appendGuidelines" href="#flLayer-appendGuidelines"><span class="function-name">appendGuidelines</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-appendGuidelines">appendGuidelines</a>(list(<a href="#flGuideLine">flGuideLine</a>))</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-applyTransform" href="#flLayer-applyTransform"><span class="function-name">applyTransform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-applyTransform">applyTransform</a>([QTransform transform])</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-assignFgLayer" href="#flLayer-assignFgLayer"><span class="function-name">assignFgLayer</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-assignFgLayer">assignFgLayer</a>(fgLayer, bool doGuides, bool doHints, bool doAnchors, bool doShapes, bool doTTH)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-assignStyle" href="#flLayer-assignStyle"><span class="function-name">assignStyle</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-assignStyle">assignStyle</a>(<a href="#flLayer">flLayer</a> layer)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-autohint" href="#flLayer-autohint"><span class="function-name">autohint</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-autohint">autohint</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-bindDependencies" href="#flLayer-bindDependencies"><span class="function-name">bindDependencies</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-bindDependencies">bindDependencies</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-buildAuto" href="#flLayer-buildAuto"><span class="function-name">buildAuto</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-buildAuto">buildAuto</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-changed" href="#flLayer-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-checkInitHistoryState" href="#flLayer-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-cleanEmptyShapes" href="#flLayer-cleanEmptyShapes"><span class="function-name">cleanEmptyShapes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-cleanEmptyShapes">cleanEmptyShapes</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-clearAboveHistory" href="#flLayer-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-clearAnchors" href="#flLayer-clearAnchors"><span class="function-name">clearAnchors</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-clearAnchors">clearAnchors</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-clearComponents" href="#flLayer-clearComponents"><span class="function-name">clearComponents</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-clearComponents">clearComponents</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-clearFlag" href="#flLayer-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-clearFlags" href="#flLayer-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-clone" href="#flLayer-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-cloneCustom" href="#flLayer-cloneCustom"><span class="function-name">cloneCustom</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(<a href="#flLayer">flLayer</a>, list(<a href="#flObject">flObject</a>)) <a href="#flLayer-cloneCustom">cloneCustom</a>(uint)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-compare" href="#flLayer-compare"><span class="function-name">compare</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-compare">compare</a>(<a href="#flLayer">flLayer</a> layer, double error)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-compoundMakeSelected" href="#flLayer-compoundMakeSelected"><span class="function-name">compoundMakeSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-compoundMakeSelected">compoundMakeSelected</a>(bool set_active, bool process_all)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-compoundMakeSelectedToShapes" href="#flLayer-compoundMakeSelectedToShapes"><span class="function-name">compoundMakeSelectedToShapes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-compoundMakeSelectedToShapes">compoundMakeSelectedToShapes</a>([bool set_active =true])</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-contourRect" href="#flLayer-contourRect"><span class="function-name">contourRect</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF <a href="#flLayer-contourRect">contourRect</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-createAnchor" href="#flLayer-createAnchor"><span class="function-name">createAnchor</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint">flPinPoint</a> <a href="#flLayer-createAnchor">createAnchor</a>(QPointF p, bool auto_positioning)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-createHistoryState" href="#flLayer-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-currentHistoryState" href="#flLayer-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-deactivateAllShapes" href="#flLayer-deactivateAllShapes"><span class="function-name">deactivateAllShapes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-deactivateAllShapes">deactivateAllShapes</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-fillFgAnchors" href="#flLayer-fillFgAnchors"><span class="function-name">fillFgAnchors</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-fillFgAnchors">fillFgAnchors</a>(fgLayer)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-fillFgGuides" href="#flLayer-fillFgGuides"><span class="function-name">fillFgGuides</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-fillFgGuides">fillFgGuides</a>(fgLayer)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-fillFgHints" href="#flLayer-fillFgHints"><span class="function-name">fillFgHints</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-fillFgHints">fillFgHints</a>(fgLayer)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-findAnchor" href="#flLayer-findAnchor"><span class="function-name">findAnchor</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint">flPinPoint</a> <a href="#flLayer-findAnchor">findAnchor</a>(QString name)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-findNearestNode" href="#flLayer-findNearestNode"><span class="function-name">findNearestNode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(<a href="#flShape">flShape</a>, <a href="#flNode">flNode</a> best_node, double maxd) <a href="#flLayer-findNearestNode">findNearestNode</a>(QPointF, <a href="#flNode">flNode</a>::NodeType node_type, double maxd)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-findNode" href="#flLayer-findNode"><span class="function-name">findNode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(<a href="#flNode">flNode</a>, QPointF)/Nothing <a href="#flLayer-findNode">findNode</a>(string name)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-flag" href="#flLayer-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-getActiveComposite" href="#flLayer-getActiveComposite"><span class="function-name">getActiveComposite</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flShape">flShape</a>/Nothing <a href="#flLayer-getActiveComposite">getActiveComposite</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-getActiveShape" href="#flLayer-getActiveShape"><span class="function-name">getActiveShape</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(<a href="#flShape">flShape</a>, QTransform)/Nothing <a href="#flLayer-getActiveShape">getActiveShape</a>([bool = true])</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-getContours" href="#flLayer-getContours"><span class="function-name">getContours</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#flContour">flContour</a>) <a href="#flLayer-getContours">getContours</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-getImgLayer" href="#flLayer-getImgLayer"><span class="function-name">getImgLayer</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer">flLayer</a> <a href="#flLayer-getImgLayer">getImgLayer</a>(bool create)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-getMaskLayer" href="#flLayer-getMaskLayer"><span class="function-name">getMaskLayer</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer">flLayer</a> <a href="#flLayer-getMaskLayer">getMaskLayer</a>(bool create)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-getMasterPosition" href="#flLayer-getMasterPosition"><span class="function-name">getMasterPosition</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QMap<QString, double>/Nothing <a href="#flLayer-getMasterPosition">getMasterPosition</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-getOwnerComposite" href="#flLayer-getOwnerComposite"><span class="function-name">getOwnerComposite</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flShapeInfo">flShapeInfo</a> <a href="#flLayer-getOwnerComposite">getOwnerComposite</a>(<a href="#flShape">flShape</a>, QTransform) / <a href="#flShapeData">flShapeData</a> <a href="#flLayer-getOwnerComposite">getOwnerComposite</a>(<a href="#flShape">flShape</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-getProperties" href="#flLayer-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-getProperty" href="#flLayer-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-getPropertyFloat" href="#flLayer-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-getPropertyInt" href="#flLayer-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-getSelected" href="#flLayer-getSelected"><span class="function-name">getSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#flContour">flContour</a>)/Nothing <a href="#flLayer-getSelected">getSelected</a>(SelectionMode)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-getShapes" href="#flLayer-getShapes"><span class="function-name">getShapes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#flShape">flShape</a>) <a href="#flLayer-getShapes">getShapes</a>(ShapeType shape_type)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-getTthCode" href="#flLayer-getTthCode"><span class="function-name">getTthCode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-getTthCode">getTthCode</a>(fgLayer fg_layer, fgTTInterpreter itr)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-getTthData" href="#flLayer-getTthData"><span class="function-name">getTthData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(bytes) / Nothing <a href="#flLayer-getTthData">getTthData</a>(fgLayer fg_layer, fgTTInterpreter itr)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-getTthProgram" href="#flLayer-getTthProgram"><span class="function-name">getTthProgram</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QString <a href="#flLayer-getTthProgram">getTthProgram</a>(fgTTInterpreter itr)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-goDown" href="#flLayer-goDown"><span class="function-name">goDown</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-goDown">goDown</a>(<a href="#flShape">flShape</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-goUp" href="#flLayer-goUp"><span class="function-name">goUp</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-goUp">goUp</a>(<a href="#flShape">flShape</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-hasHistoryState" href="#flLayer-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-hasShape" href="#flLayer-hasShape"><span class="function-name">hasShape</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-hasShape">hasShape</a>(<a href="#flShape">flShape</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-hasShapeData" href="#flLayer-hasShapeData"><span class="function-name">hasShapeData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-hasShapeData">hasShapeData</a>(<a href="#flShapeData">flShapeData</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-haveSelected" href="#flLayer-haveSelected"><span class="function-name">haveSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-haveSelected">haveSelected</a>(SelectionMode)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-hints2links" href="#flLayer-hints2links"><span class="function-name">hints2links</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-hints2links">hints2links</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-historyStates" href="#flLayer-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-independedAll" href="#flLayer-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-initialHistoryState" href="#flLayer-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-inkBox" href="#flLayer-inkBox"><span class="function-name">inkBox</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF <a href="#flLayer-inkBox">inkBox</a>([QTransform tx = QTransform()])</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-insertShape" href="#flLayer-insertShape"><span class="function-name">insertShape</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flShape">flShape</a> <a href="#flLayer-insertShape">insertShape</a>(int index, <a href="#flShape">flShape</a> shape)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-isBack" href="#flLayer-isBack"><span class="function-name">isBack</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-isBack">isBack</a>(<a href="#flShape">flShape</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-isCompatible" href="#flLayer-isCompatible"><span class="function-name">isCompatible</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-isCompatible">isCompatible</a>(<a href="#flLayer">flLayer</a>, bool strong)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-isEqual" href="#flLayer-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-isFront" href="#flLayer-isFront"><span class="function-name">isFront</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-isFront">isFront</a>(<a href="#flShape">flShape</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-killAuto" href="#flLayer-killAuto"><span class="function-name">killAuto</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-killAuto">killAuto</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-nodesCount" href="#flLayer-nodesCount"><span class="function-name">nodesCount</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flLayer-nodesCount">nodesCount</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-prepareTransformationData" href="#flLayer-prepareTransformationData"><span class="function-name">prepareTransformationData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-prepareTransformationData">prepareTransformationData</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-release" href="#flLayer-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-remove" href="#flLayer-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-removeAllShapes" href="#flLayer-removeAllShapes"><span class="function-name">removeAllShapes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-removeAllShapes">removeAllShapes</a>([ShapeType shape_type=AnyShape])</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-removeAnchor" href="#flLayer-removeAnchor"><span class="function-name">removeAnchor</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-removeAnchor">removeAnchor</a>(<a href="#flPinPoint">flPinPoint</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-removeChild" href="#flLayer-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-removeGuides" href="#flLayer-removeGuides"><span class="function-name">removeGuides</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-removeGuides">removeGuides</a>(bool horizontal, bool vertical)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-removeHints" href="#flLayer-removeHints"><span class="function-name">removeHints</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-removeHints">removeHints</a>(bool horizontal, bool vertical)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-removeProperty" href="#flLayer-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-removeShape" href="#flLayer-removeShape"><span class="function-name">removeShape</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-removeShape">removeShape</a>(<a href="#flShape">flShape</a>[, bool recursive=true])</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-reorderShapes" href="#flLayer-reorderShapes"><span class="function-name">reorderShapes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-reorderShapes">reorderShapes</a>(QList<uint>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-replaceShape" href="#flLayer-replaceShape"><span class="function-name">replaceShape</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-replaceShape">replaceShape</a>(<a href="#flShape">flShape</a> old_shape, <a href="#flShape">flShape</a> new_shape)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-resetInkBox" href="#flLayer-resetInkBox"><span class="function-name">resetInkBox</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-resetInkBox">resetInkBox</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-resetMetricsLeft" href="#flLayer-resetMetricsLeft"><span class="function-name">resetMetricsLeft</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-resetMetricsLeft">resetMetricsLeft</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-resetMetricsRight" href="#flLayer-resetMetricsRight"><span class="function-name">resetMetricsRight</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-resetMetricsRight">resetMetricsRight</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-resetMetricsWidth" href="#flLayer-resetMetricsWidth"><span class="function-name">resetMetricsWidth</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-resetMetricsWidth">resetMetricsWidth</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-resetTransformationData" href="#flLayer-resetTransformationData"><span class="function-name">resetTransformationData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-resetTransformationData">resetTransformationData</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-restoreHistoryState" href="#flLayer-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-selectAll" href="#flLayer-selectAll"><span class="function-name">selectAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-selectAll">selectAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-sendToBack" href="#flLayer-sendToBack"><span class="function-name">sendToBack</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-sendToBack">sendToBack</a>(<a href="#flShape">flShape</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-sendToFront" href="#flLayer-sendToFront"><span class="function-name">sendToFront</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-sendToFront">sendToFront</a>(<a href="#flShape">flShape</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-setActive" href="#flLayer-setActive"><span class="function-name">setActive</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-setActive">setActive</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-setActiveShape" href="#flLayer-setActiveShape"><span class="function-name">setActiveShape</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-setActiveShape">setActiveShape</a>(<a href="#flShape">flShape</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-setAllShapesSelected" href="#flLayer-setAllShapesSelected"><span class="function-name">setAllShapesSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-setAllShapesSelected">setAllShapesSelected</a>(bool)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-setFlag" href="#flLayer-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-setGlyphComponents" href="#flLayer-setGlyphComponents"><span class="function-name">setGlyphComponents</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-setGlyphComponents">setGlyphComponents</a>(QList<<a href="#GlyphComponent">GlyphComponent</a>> result, double width, <a href="#flPackage">flPackage</a> package, bool colorize)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-setProperty" href="#flLayer-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-setPropertyFloat" href="#flLayer-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-setPropertyInt" href="#flLayer-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-setWireframeColorIx" href="#flLayer-setWireframeColorIx"><span class="function-name">setWireframeColorIx</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-setWireframeColorIx">setWireframeColorIx</a>(int)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-sortShapes" href="#flLayer-sortShapes"><span class="function-name">sortShapes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-sortShapes">sortShapes</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-tag" href="#flLayer-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-takeShapes" href="#flLayer-takeShapes"><span class="function-name">takeShapes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QList<<a href="#flShape">flShape</a>> <a href="#flLayer-takeShapes">takeShapes</a>(ShapeType shape_type)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-transferNames" href="#flLayer-transferNames"><span class="function-name">transferNames</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-transferNames">transferNames</a>(<a href="#flLayer">flLayer</a> layer)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-transferTTH" href="#flLayer-transferTTH"><span class="function-name">transferTTH</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-transferTTH">transferTTH</a>(<a href="#flLayer">flLayer</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-tthAutohint" href="#flLayer-tthAutohint"><span class="function-name">tthAutohint</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-tthAutohint">tthAutohint</a>(bool make_hints, fgTTInterpreter itr)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-tthFixZones" href="#flLayer-tthFixZones"><span class="function-name">tthFixZones</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-tthFixZones">tthFixZones</a>(fgTTInterpreter itr)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-tthReassignStems" href="#flLayer-tthReassignStems"><span class="function-name">tthReassignStems</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-tthReassignStems">tthReassignStems</a>(fgTTInterpreter itr)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-tthReassignZones" href="#flLayer-tthReassignZones"><span class="function-name">tthReassignZones</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-tthReassignZones">tthReassignZones</a>(fgTTInterpreter itr, bool)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-tthRemoveCommands" href="#flLayer-tthRemoveCommands"><span class="function-name">tthRemoveCommands</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-tthRemoveCommands">tthRemoveCommands</a>(bool vertical, bool horizontal)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-tthRemoveDeltas" href="#flLayer-tthRemoveDeltas"><span class="function-name">tthRemoveDeltas</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-tthRemoveDeltas">tthRemoveDeltas</a>(bool middle, bool final)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-unselectAllNodes" href="#flLayer-unselectAllNodes"><span class="function-name">unselectAllNodes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-unselectAllNodes">unselectAllNodes</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-update" href="#flLayer-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-update">update</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-updateAnchors" href="#flLayer-updateAnchors"><span class="function-name">updateAnchors</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayer-updateAnchors">updateAnchors</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-updateGuidelineNode" href="#flLayer-updateGuidelineNode"><span class="function-name">updateGuidelineNode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode">flNode</a> <a href="#flLayer-updateGuidelineNode">updateGuidelineNode</a>(<a href="#flNode">flNode</a> node)</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flLayer-checkTags" href="#flLayer-checkTags"><span class="function-name">checkTags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-checkTags">checkTags</a>(QSet<QString> glyph_tags, QString item_tags)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-cloneObject" href="#flLayer-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flLayer-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-createInstance" href="#flLayer-createInstance"><span class="function-name">createInstance</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-createObject" href="#flLayer-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flLayer-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-haveObject" href="#flLayer-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayer-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayer-instanceType" href="#flLayer-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flLayer-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>advanceHeight</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>advanceWidth</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>anchors</dt>
<dd>

<pre class="doc" markdown="0">list(flPinPoint) anchors()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>autoLayer</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>boundingBox</dt>
<dd>

<pre class="doc" markdown="0">QRectF boundingBox()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>components</dt>
<dd>

<pre class="doc" markdown="0">list(name, transform)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>componentsCount</dt>
<dd>

<pre class="doc" markdown="0">int componentsCount()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>compoundReleaseSelected</dt>
<dd>

<pre class="doc" markdown="0">bool compoundReleaseSelected();</pre>

</dd>
</dl>
<dl class="descriptor"><dt>counterAnchors</dt>
<dd>

<pre class="doc" markdown="0">int counterAnchors()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>glyph</dt>
<dd>

<pre class="doc" markdown="0">flGlyph</pre>

</dd>
</dl>
<dl class="descriptor"><dt>guidelines</dt>
<dd>

<pre class="doc" markdown="0">list(flGuideLine) guidelines()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasAdvanceHeight</dt>
<dd>

<pre class="doc" markdown="0">bool hasAdvanceHeight()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasAdvanceWidth</dt>
<dd>

<pre class="doc" markdown="0">bool hasAdvanceWidth()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasBody</dt>
<dd>

<pre class="doc" markdown="0">bool hasBody()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasComponents</dt>
<dd>

<pre class="doc" markdown="0">bool hasComponents()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasComposites</dt>
<dd>

<pre class="doc" markdown="0">bool hasComposites()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasGuides</dt>
<dd>

<pre class="doc" markdown="0">bool hasGuides()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHints</dt>
<dd>

<pre class="doc" markdown="0">bool hasHints()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasNote</dt>
<dd>

<pre class="doc" markdown="0">bool hasNote()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasTTData</dt>
<dd>

<pre class="doc" markdown="0">bool hasTTData()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasTTH</dt>
<dd>

<pre class="doc" markdown="0">bool hasTTH()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>haveActiveComposite</dt>
<dd>

<pre class="doc" markdown="0">bool haveActiveComposite()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isActive</dt>
<dd>

<pre class="doc" markdown="0">bool isActive()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isAllSelected</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isBodyLayer</dt>
<dd>

<pre class="doc" markdown="0">bool isBodyLayer()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isImg</dt>
<dd>

<pre class="doc" markdown="0">bool isImg()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isImgLayer</dt>
<dd>

<pre class="doc" markdown="0">bool isImgLayer()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isLocked</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isLockedI</dt>
<dd>

<pre class="doc" markdown="0">bool isLockedI()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isMask</dt>
<dd>

<pre class="doc" markdown="0">bool isMask()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isMaskLayer</dt>
<dd>

<pre class="doc" markdown="0">bool isMaskLayer()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isMasterLayer</dt>
<dd>

<pre class="doc" markdown="0">bool isMasterLayer()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isService</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isServiceMA</dt>
<dd>

<pre class="doc" markdown="0">bool isServiceMA()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isVisible</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isVisibleA</dt>
<dd>

<pre class="doc" markdown="0">bool isVisibleA()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isWireframe</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>mark</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>metricsLeft</dt>
<dd>

<pre class="doc" markdown="0">QString</pre>

</dd>
</dl>
<dl class="descriptor"><dt>metricsRight</dt>
<dd>

<pre class="doc" markdown="0">QString</pre>

</dd>
</dl>
<dl class="descriptor"><dt>metricsWidth</dt>
<dd>

<pre class="doc" markdown="0">QString</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>note</dt>
<dd>

<pre class="doc" markdown="0">QString</pre>

</dd>
</dl>
<dl class="descriptor"><dt>opacity</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>recipe</dt>
<dd>

<pre class="doc" markdown="0">QString</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>shapes</dt>
<dd>

<pre class="doc" markdown="0">list(flShape) shapes()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>shapesCount</dt>
<dd>

<pre class="doc" markdown="0">int shapesCount()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>transform</dt>
<dd>

<pre class="doc" markdown="0">QTransform</pre>

</dd>
</dl>
<dl class="descriptor"><dt>ttData</dt>
<dd>

<pre class="doc" markdown="0">fgTrueTypeData</pre>

</dd>
</dl>
<dl class="descriptor"><dt>tthProgram</dt>
<dd>

<pre class="doc" markdown="0">QList<flTTHCommand></pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>
<dl class="descriptor"><dt>wireframeColor</dt>
<dd>

<pre class="doc" markdown="0">QColor</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flLayer-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flLayerAttributes" href="#flLayerAttributes">class <span class="class-name">flLayerAttributes</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Data wrapper</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flLayerAttributes-__add__" href="#flLayerAttributes-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerAttributes-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerAttributes-__delattr__" href="#flLayerAttributes-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerAttributes-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerAttributes-__delitem__" href="#flLayerAttributes-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerAttributes-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerAttributes-__delslice__" href="#flLayerAttributes-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerAttributes-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerAttributes-__getattribute__" href="#flLayerAttributes-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerAttributes-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerAttributes-__getitem__" href="#flLayerAttributes-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerAttributes-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerAttributes-__getslice__" href="#flLayerAttributes-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerAttributes-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerAttributes-__init__" href="#flLayerAttributes-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerAttributes-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerAttributes-__len__" href="#flLayerAttributes-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerAttributes-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerAttributes-__mul__" href="#flLayerAttributes-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerAttributes-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerAttributes-__repr__" href="#flLayerAttributes-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerAttributes-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerAttributes-__rmul__" href="#flLayerAttributes-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerAttributes-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerAttributes-__setattr__" href="#flLayerAttributes-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerAttributes-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerAttributes-__setitem__" href="#flLayerAttributes-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerAttributes-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerAttributes-__setslice__" href="#flLayerAttributes-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerAttributes-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerAttributes-__str__" href="#flLayerAttributes-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerAttributes-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerAttributes-asDict" href="#flLayerAttributes-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerAttributes-asTuple" href="#flLayerAttributes-asTuple"><span class="function-name">asTuple</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as tuple</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>isActive</dt>
</dl>
<dl class="descriptor"><dt>isLocked</dt>
</dl>
<dl class="descriptor"><dt>isService</dt>
</dl>
<dl class="descriptor"><dt>isVisible</dt>
</dl>
<dl class="descriptor"><dt>isWireframe</dt>
</dl>
<dl class="descriptor"><dt>wireframeColor</dt>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flLayerAttributes-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="flLayerInfo" href="#flLayerInfo">class <span class="class-name">flLayerInfo</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flLayerInfo representation

Constructors:
  flLayerInfo()
  flLayerInfo(flObject)
  flLayerInfo(flLayerInfo)
  flLayerInfo(flLayer, QTransform)
  flLayerInfo(flLayer, flObject glyph_info, QTransform)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flLayerInfo-__delattr__" href="#flLayerInfo-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerInfo-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-__eq__" href="#flLayerInfo-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerInfo-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-__ge__" href="#flLayerInfo-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerInfo-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-__getattribute__" href="#flLayerInfo-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerInfo-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-__gt__" href="#flLayerInfo-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerInfo-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-__init__" href="#flLayerInfo-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerInfo-__init__">__init__</a>(...) initializes x; see help(<a href="#flLayerInfo-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-__le__" href="#flLayerInfo-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerInfo-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-__lt__" href="#flLayerInfo-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerInfo-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-__ne__" href="#flLayerInfo-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerInfo-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-__repr__" href="#flLayerInfo-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerInfo-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-__setattr__" href="#flLayerInfo-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLayerInfo-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-brectOnCanvas" href="#flLayerInfo-brectOnCanvas"><span class="function-name">brectOnCanvas</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF <a href="#flLayerInfo-brectOnCanvas">brectOnCanvas</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-changed" href="#flLayerInfo-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-checkInitHistoryState" href="#flLayerInfo-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-clearAboveHistory" href="#flLayerInfo-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-clearFlag" href="#flLayerInfo-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-clearFlags" href="#flLayerInfo-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-clone" href="#flLayerInfo-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-combine" href="#flLayerInfo-combine"><span class="function-name">combine</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-combine">combine</a>(QTransform transform)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-createHistoryState" href="#flLayerInfo-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-currentHistoryState" href="#flLayerInfo-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-flag" href="#flLayerInfo-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-getProperties" href="#flLayerInfo-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-getProperty" href="#flLayerInfo-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-getPropertyFloat" href="#flLayerInfo-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-getPropertyInt" href="#flLayerInfo-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-hasHistoryState" href="#flLayerInfo-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-historyStates" href="#flLayerInfo-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-independedAll" href="#flLayerInfo-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-initialHistoryState" href="#flLayerInfo-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-isEqual" href="#flLayerInfo-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-release" href="#flLayerInfo-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-remove" href="#flLayerInfo-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-removeChild" href="#flLayerInfo-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-removeProperty" href="#flLayerInfo-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-restoreHistoryState" href="#flLayerInfo-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-setFlag" href="#flLayerInfo-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-setProperty" href="#flLayerInfo-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-setPropertyFloat" href="#flLayerInfo-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-setPropertyInt" href="#flLayerInfo-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-tag" href="#flLayerInfo-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-update" href="#flLayerInfo-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo-update">update</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flLayerInfo-cloneObject" href="#flLayerInfo-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flLayerInfo-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-createInstance" href="#flLayerInfo-createInstance"><span class="function-name">createInstance</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLayerInfo">flLayerInfo</a> <a href="#flLayerInfo-createInstance">createInstance</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-createObject" href="#flLayerInfo-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flLayerInfo-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-haveObject" href="#flLayerInfo-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flLayerInfo-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flLayerInfo-instanceType" href="#flLayerInfo-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flLayerInfo-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>dist</dt>
<dd>

<pre class="doc" markdown="0">double dist</pre>

</dd>
</dl>
<dl class="descriptor"><dt>glyphInfo</dt>
<dd>

<pre class="doc" markdown="0">flObject - glyph info</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>layer</dt>
<dd>

<pre class="doc" markdown="0">flLayer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>transform</dt>
<dd>

<pre class="doc" markdown="0">transform matrix</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flLayerInfo-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flLocation" href="#flLocation">class <span class="class-name">flLocation</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flLocation representation

Constructors:
  flLocation(flLocation)
  flLocation()</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flLocation-__delattr__" href="#flLocation-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLocation-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flLocation-__delitem__" href="#flLocation-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLocation-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="flLocation-__getattribute__" href="#flLocation-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLocation-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flLocation-__getitem__" href="#flLocation-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLocation-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="flLocation-__init__" href="#flLocation-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLocation-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flLocation-__len__" href="#flLocation-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLocation-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLocation-__repr__" href="#flLocation-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLocation-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flLocation-__setattr__" href="#flLocation-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLocation-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flLocation-__setitem__" href="#flLocation-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flLocation-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flLocation-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="flMarkerPoint" href="#flMarkerPoint">class <span class="class-name">flMarkerPoint</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flMarkerPoint representation

Constructors:
  flMarkerPoint()
  flMarkerPoint(flObject)
  flMarkerPoint(flMarkerPoint)
  flMarkerPoint(double marker_pos, uint markerFlags, flSnaps::MarkerKey key)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flMarkerPoint-__delattr__" href="#flMarkerPoint-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flMarkerPoint-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-__eq__" href="#flMarkerPoint-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flMarkerPoint-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-__ge__" href="#flMarkerPoint-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flMarkerPoint-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-__getattribute__" href="#flMarkerPoint-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flMarkerPoint-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-__gt__" href="#flMarkerPoint-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flMarkerPoint-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-__init__" href="#flMarkerPoint-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flMarkerPoint-__init__">__init__</a>(...) initializes x; see help(<a href="#flMarkerPoint-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-__le__" href="#flMarkerPoint-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flMarkerPoint-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-__lt__" href="#flMarkerPoint-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flMarkerPoint-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-__ne__" href="#flMarkerPoint-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flMarkerPoint-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-__repr__" href="#flMarkerPoint-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flMarkerPoint-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-__setattr__" href="#flMarkerPoint-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flMarkerPoint-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-changed" href="#flMarkerPoint-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-checkInitHistoryState" href="#flMarkerPoint-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-clearAboveHistory" href="#flMarkerPoint-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-clearFlag" href="#flMarkerPoint-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-clearFlags" href="#flMarkerPoint-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-clone" href="#flMarkerPoint-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-createHistoryState" href="#flMarkerPoint-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-currentHistoryState" href="#flMarkerPoint-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-flag" href="#flMarkerPoint-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-getProperties" href="#flMarkerPoint-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-getProperty" href="#flMarkerPoint-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-getPropertyFloat" href="#flMarkerPoint-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-getPropertyInt" href="#flMarkerPoint-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-hasHistoryState" href="#flMarkerPoint-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-historyStates" href="#flMarkerPoint-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-independedAll" href="#flMarkerPoint-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-initialHistoryState" href="#flMarkerPoint-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-isEqual" href="#flMarkerPoint-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-markerFlag" href="#flMarkerPoint-markerFlag"><span class="function-name">markerFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">uint <a href="#flMarkerPoint-markerFlag">markerFlag</a>(uint role)</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-release" href="#flMarkerPoint-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-remove" href="#flMarkerPoint-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-removeChild" href="#flMarkerPoint-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-removeProperty" href="#flMarkerPoint-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-restoreHistoryState" href="#flMarkerPoint-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-setFlag" href="#flMarkerPoint-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-setMarkerFlag" href="#flMarkerPoint-setMarkerFlag"><span class="function-name">setMarkerFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-setMarkerFlag">setMarkerFlag</a>(uint role, uint markerFlags)</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-setProperty" href="#flMarkerPoint-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-setPropertyFloat" href="#flMarkerPoint-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-setPropertyInt" href="#flMarkerPoint-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-tag" href="#flMarkerPoint-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-update" href="#flMarkerPoint-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint-update">update</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flMarkerPoint-cloneObject" href="#flMarkerPoint-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flMarkerPoint-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-createInstance" href="#flMarkerPoint-createInstance"><span class="function-name">createInstance</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flMarkerPoint">flMarkerPoint</a> <a href="#flMarkerPoint-createInstance">createInstance</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-createObject" href="#flMarkerPoint-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flMarkerPoint-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-haveObject" href="#flMarkerPoint-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flMarkerPoint-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flMarkerPoint-instanceType" href="#flMarkerPoint-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flMarkerPoint-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isSelected</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isStem</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>key</dt>
<dd>

<pre class="doc" markdown="0">flSnaps::MarkerKey key()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>markerFlags</dt>
<dd>

<pre class="doc" markdown="0">uint</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>position</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flMarkerPoint-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flModel" href="#flModel">class <span class="class-name">flModel</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flModel representation

Constructors:
None, static only methods</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flModel-__delattr__" href="#flModel-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flModel-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flModel-__getattribute__" href="#flModel-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flModel-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flModel-__init__" href="#flModel-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flModel-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flModel-__repr__" href="#flModel-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flModel-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModel-__setattr__" href="#flModel-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flModel-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flModel-createObject" href="#flModel-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flModel-createObject">createObject</a>(int type)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModel-getClassMask" href="#flModel-getClassMask"><span class="function-name">getClassMask</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int  <a href="#flModel-getClassMask">getClassMask</a>(int type)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModel-instance" href="#flModel-instance"><span class="function-name">instance</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModel">flModel</a> <a href="#flModel-instance">instance</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flModel-isClassMask" href="#flModel-isClassMask"><span class="function-name">isClassMask</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flModel-isClassMask">isClassMask</a>(int type)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModel-notifyGlyphChanged" href="#flModel-notifyGlyphChanged"><span class="function-name">notifyGlyphChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModel-notifyGlyphChanged">notifyGlyphChanged</a>(unsigned long fg_glyphId)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModel-notifyGlyphUpdate" href="#flModel-notifyGlyphUpdate"><span class="function-name">notifyGlyphUpdate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModel-notifyGlyphUpdate">notifyGlyphUpdate</a>(unsigned long fg_glyphId)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModel-notifyGlyphsChanged" href="#flModel-notifyGlyphsChanged"><span class="function-name">notifyGlyphsChanged</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModel-notifyGlyphsChanged">notifyGlyphsChanged</a>(QSet<uint32_t> glyphs)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModel-typeToStr" href="#flModel-typeToStr"><span class="function-name">typeToStr</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QString <a href="#flModel-typeToStr">typeToStr</a>(int type | <a href="#flObject">flObject</a>)</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">ModelType</span> = {'Anchor': 185, 'AnchorNode': 186, 'AnchorNodeToGuidelineCoords': 187, 'AutoShape': 55, 'Bezier': 48, 'Container': 8, 'Contour': 47, 'ContourInfo': 181, 'Controls': 14, 'Edge': 101, ...}</dt></dl>
<dl><dt><span class="other-name">ObjectParameter</span> = {'prmBrush': 2, 'prmPen': 3, 'prmStructure': 0, 'prmTransform': 1}</dt></dl>
<dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flModel-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="flModelProducer" href="#flModelProducer">class <span class="class-name">flModelProducer</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flModelProducer representation

Constructors:
  flModelProducer()
  flModelProducer(flModelProducer)
  flModelProducer(flObject)
  flModelProducer(flCanvas)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flModelProducer-__delattr__" href="#flModelProducer-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flModelProducer-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-__eq__" href="#flModelProducer-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flModelProducer-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-__ge__" href="#flModelProducer-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flModelProducer-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-__getattribute__" href="#flModelProducer-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flModelProducer-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-__gt__" href="#flModelProducer-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flModelProducer-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-__init__" href="#flModelProducer-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flModelProducer-__init__">__init__</a>(...) initializes x; see help(<a href="#flModelProducer-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-__le__" href="#flModelProducer-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flModelProducer-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-__lt__" href="#flModelProducer-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flModelProducer-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-__ne__" href="#flModelProducer-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flModelProducer-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-__repr__" href="#flModelProducer-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flModelProducer-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-__setattr__" href="#flModelProducer-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flModelProducer-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-changed" href="#flModelProducer-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-checkInitHistoryState" href="#flModelProducer-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-clearAboveHistory" href="#flModelProducer-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-clearFlag" href="#flModelProducer-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-clearFlags" href="#flModelProducer-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-clone" href="#flModelProducer-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-createHistoryState" href="#flModelProducer-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-currentHistoryState" href="#flModelProducer-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-flag" href="#flModelProducer-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-getProperties" href="#flModelProducer-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-getProperty" href="#flModelProducer-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-getPropertyFloat" href="#flModelProducer-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-getPropertyInt" href="#flModelProducer-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-hasHistoryState" href="#flModelProducer-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-historyStates" href="#flModelProducer-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-independedAll" href="#flModelProducer-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-initialHistoryState" href="#flModelProducer-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-isEqual" href="#flModelProducer-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-release" href="#flModelProducer-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-remove" href="#flModelProducer-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-removeChild" href="#flModelProducer-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-removeProperty" href="#flModelProducer-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-restoreHistoryState" href="#flModelProducer-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-setFlag" href="#flModelProducer-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-setProperty" href="#flModelProducer-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-setPropertyFloat" href="#flModelProducer-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-setPropertyInt" href="#flModelProducer-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-tag" href="#flModelProducer-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-update" href="#flModelProducer-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-update">update</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flModelProducer-cloneObject" href="#flModelProducer-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flModelProducer-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-copyToClipboard" href="#flModelProducer-copyToClipboard"><span class="function-name">copyToClipboard</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flModelProducer-copyToClipboard">copyToClipboard</a>(objId package_id, QList<<a href="#flObject">flObject</a>> objects)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-countGlyphsInData" href="#flModelProducer-countGlyphsInData"><span class="function-name">countGlyphsInData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flModelProducer-countGlyphsInData">countGlyphsInData</a>(QByteArray *data)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-createObject" href="#flModelProducer-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flModelProducer-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-getClipboardData" href="#flModelProducer-getClipboardData"><span class="function-name">getClipboardData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QByteArray <a href="#flModelProducer-getClipboardData">getClipboardData</a>(objId package_id, QList<<a href="#flObject">flObject</a>>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-getObjectsFromClipboard" href="#flModelProducer-getObjectsFromClipboard"><span class="function-name">getObjectsFromClipboard</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">flObjects/Nothing <a href="#flModelProducer-getObjectsFromClipboard">getObjectsFromClipboard</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-getObjectsFromData" href="#flModelProducer-getObjectsFromData"><span class="function-name">getObjectsFromData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">flObjects/Nothing <a href="#flModelProducer-getObjectsFromData">getObjectsFromData</a>(QByteArray *data)</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-haveObject" href="#flModelProducer-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flModelProducer-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flModelProducer-instanceType" href="#flModelProducer-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flModelProducer-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flModelProducer-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flMouseEvent" href="#flMouseEvent">class <span class="class-name">flMouseEvent</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flMouseEvent representation

Constructors:
  flMouseEvent(flMouseEvent)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flMouseEvent-__delattr__" href="#flMouseEvent-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flMouseEvent-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flMouseEvent-__getattribute__" href="#flMouseEvent-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flMouseEvent-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flMouseEvent-__init__" href="#flMouseEvent-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flMouseEvent-__init__">__init__</a>(...) initializes x; see help(<a href="#flMouseEvent-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flMouseEvent-__repr__" href="#flMouseEvent-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flMouseEvent-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flMouseEvent-__setattr__" href="#flMouseEvent-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flMouseEvent-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>button</dt>
<dd>

<pre class="doc" markdown="0">Qt::MouseButton</pre>

</dd>
</dl>
<dl class="descriptor"><dt>buttons</dt>
<dd>

<pre class="doc" markdown="0">Qt::MouseButtons</pre>

</dd>
</dl>
<dl class="descriptor"><dt>delta</dt>
<dd>

<pre class="doc" markdown="0">QPointF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>firstPressed</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>global</dt>
<dd>

<pre class="doc" markdown="0">QPoint</pre>

</dd>
</dl>
<dl class="descriptor"><dt>modifiers</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>movement</dt>
<dd>

<pre class="doc" markdown="0">float</pre>

</dd>
</dl>
<dl class="descriptor"><dt>origin</dt>
<dd>

<pre class="doc" markdown="0">QPoint</pre>

</dd>
</dl>
<dl class="descriptor"><dt>prev</dt>
<dd>

<pre class="doc" markdown="0">QPoint</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">EventType</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flMouseEvent-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="flNode" href="#flNode">class <span class="class-name">flNode</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flNode representation

Constructors:
  flNode()
  flNode(Node) - make clone
  flNode(QPointF position[, string nodeType="on"[, int nodeKind=None]])
  flNode(double x, double y[, string nodeType="on"[, int nodeKind=None]])</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flNode-__delattr__" href="#flNode-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNode-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-__eq__" href="#flNode-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNode-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-__ge__" href="#flNode-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNode-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-__getattribute__" href="#flNode-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNode-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-__gt__" href="#flNode-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNode-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-__init__" href="#flNode-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNode-__init__">__init__</a>(...) initializes x; see help(<a href="#flNode-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-__le__" href="#flNode-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNode-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-__lt__" href="#flNode-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNode-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-__ne__" href="#flNode-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNode-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-__repr__" href="#flNode-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNode-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-__setattr__" href="#flNode-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNode-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-angleTo" href="#flNode-angleTo"><span class="function-name">angleTo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flNode-angleTo">angleTo</a>(QPointF p)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-applyTransform" href="#flNode-applyTransform"><span class="function-name">applyTransform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-applyTransform">applyTransform</a>(QTransform)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-canBeHobby" href="#flNode-canBeHobby"><span class="function-name">canBeHobby</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-canBeHobby">canBeHobby</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-canBeSmooth" href="#flNode-canBeSmooth"><span class="function-name">canBeSmooth</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-canBeSmooth">canBeSmooth</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-canCollapse" href="#flNode-canCollapse"><span class="function-name">canCollapse</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-canCollapse">canCollapse</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-canImprove" href="#flNode-canImprove"><span class="function-name">canImprove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-canImprove">canImprove</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-changed" href="#flNode-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-checkInitHistoryState" href="#flNode-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-checkVectors" href="#flNode-checkVectors"><span class="function-name">checkVectors</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-checkVectors">checkVectors</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-clearAboveHistory" href="#flNode-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-clearFlag" href="#flNode-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-clearFlags" href="#flNode-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-clearStored" href="#flNode-clearStored"><span class="function-name">clearStored</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-clearStored">clearStored</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-clone" href="#flNode-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-cloneMapped" href="#flNode-cloneMapped"><span class="function-name">cloneMapped</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode">flNode</a> <a href="#flNode-cloneMapped">cloneMapped</a>(QTransform)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-collapseHandles" href="#flNode-collapseHandles"><span class="function-name">collapseHandles</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-collapseHandles">collapseHandles</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-convertToCurve" href="#flNode-convertToCurve"><span class="function-name">convertToCurve</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-convertToCurve">convertToCurve</a>([bool smooth = false])</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-convertToCurves" href="#flNode-convertToCurves"><span class="function-name">convertToCurves</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-convertToCurves">convertToCurves</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-convertToLine" href="#flNode-convertToLine"><span class="function-name">convertToLine</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-convertToLine">convertToLine</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-copyFrom" href="#flNode-copyFrom"><span class="function-name">copyFrom</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-copyFrom">copyFrom</a>(Node[, withSelected=False])</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-createHistoryState" href="#flNode-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-currentHistoryState" href="#flNode-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-distanceTo" href="#flNode-distanceTo"><span class="function-name">distanceTo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flNode-distanceTo">distanceTo</a>(Node/QPointF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-flag" href="#flNode-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-getLines" href="#flNode-getLines"><span class="function-name">getLines</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(QLineF, QLineF)/None <a href="#flNode-getLines">getLines</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-getOn" href="#flNode-getOn"><span class="function-name">getOn</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Node/None <a href="#flNode-getOn">getOn</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-getProperties" href="#flNode-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-getProperty" href="#flNode-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-getPropertyFloat" href="#flNode-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-getPropertyInt" href="#flNode-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-hasHistoryState" href="#flNode-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-historyStates" href="#flNode-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-improve" href="#flNode-improve"><span class="function-name">improve</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-improve">improve</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-independedAll" href="#flNode-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-initialHistoryState" href="#flNode-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-isCorner" href="#flNode-isCorner"><span class="function-name">isCorner</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-isCorner">isCorner</a>([double a = 10.])</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-isCurve" href="#flNode-isCurve"><span class="function-name">isCurve</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-isCurve">isCurve</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-isEqual" href="#flNode-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-isEqualTo" href="#flNode-isEqualTo"><span class="function-name">isEqualTo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-isEqualTo">isEqualTo</a>(Node[, tolerance=0.1[, offset=QPointF(0, 0)]])</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-isExtreme" href="#flNode-isExtreme"><span class="function-name">isExtreme</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-isExtreme">isExtreme</a>(bool x[, bool open = true[, double limit = 0]])</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-isFirst" href="#flNode-isFirst"><span class="function-name">isFirst</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-isFirst">isFirst</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-isG2" href="#flNode-isG2"><span class="function-name">isG2</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-isG2">isG2</a>(double tolerance)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-isInternal" href="#flNode-isInternal"><span class="function-name">isInternal</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-isInternal">isInternal</a>(bool clockwise)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-isInterpolated" href="#flNode-isInterpolated"><span class="function-name">isInterpolated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-isInterpolated">isInterpolated</a>(bool x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-isLast" href="#flNode-isLast"><span class="function-name">isLast</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-isLast">isLast</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-isOff" href="#flNode-isOff"><span class="function-name">isOff</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-isOff">isOff</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-isOn" href="#flNode-isOn"><span class="function-name">isOn</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-isOn">isOn</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-isSmartAngle" href="#flNode-isSmartAngle"><span class="function-name">isSmartAngle</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-isSmartAngle">isSmartAngle</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-makeStart" href="#flNode-makeStart"><span class="function-name">makeStart</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-makeStart">makeStart</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-moveBy" href="#flNode-moveBy"><span class="function-name">moveBy</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-moveBy">moveBy</a>(float dx, float dy[, bool round=false]</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-nextNode" href="#flNode-nextNode"><span class="function-name">nextNode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Node/None <a href="#flNode-nextNode">nextNode</a>([string nodeType= [, int searchDepth=1]])</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-pointG2" href="#flNode-pointG2"><span class="function-name">pointG2</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF/None <a href="#flNode-pointG2">pointG2</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-prevNode" href="#flNode-prevNode"><span class="function-name">prevNode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Node/None <a href="#flNode-prevNode">prevNode</a>([string nodeType= [, int searchDepth=1]])</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-release" href="#flNode-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-remove" href="#flNode-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-removeChild" href="#flNode-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-removeProperty" href="#flNode-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-restoreCoordinates" href="#flNode-restoreCoordinates"><span class="function-name">restoreCoordinates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-restoreCoordinates">restoreCoordinates</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-restoreHistoryState" href="#flNode-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-rotateBy" href="#flNode-rotateBy"><span class="function-name">rotateBy</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-rotateBy">rotateBy</a>(valueDegree[, QPointF origin=(0, 0)])</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-round" href="#flNode-round"><span class="function-name">round</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-round">round</a>() - Round the node's coordinate</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-scaleBy" href="#flNode-scaleBy"><span class="function-name">scaleBy</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-scaleBy">scaleBy</a>(valueXY | (valueX, valueY)[, QPointF origin=(0, 0)])</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-setExtraLast" href="#flNode-setExtraLast"><span class="function-name">setExtraLast</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-setExtraLast">setExtraLast</a>(bool)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-setFlag" href="#flNode-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-setNextSmooth" href="#flNode-setNextSmooth"><span class="function-name">setNextSmooth</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-setNextSmooth">setNextSmooth</a>(QPointF base)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-setPrevSmooth" href="#flNode-setPrevSmooth"><span class="function-name">setPrevSmooth</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-setPrevSmooth">setPrevSmooth</a>(QPointF base)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-setProperty" href="#flNode-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-setPropertyFloat" href="#flNode-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-setPropertyInt" href="#flNode-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-setSmartAngleEnbl" href="#flNode-setSmartAngleEnbl"><span class="function-name">setSmartAngleEnbl</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-setSmartAngleEnbl">setSmartAngleEnbl</a>(bool)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-setSmartSharp" href="#flNode-setSmartSharp"><span class="function-name">setSmartSharp</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-setSmartSharp">setSmartSharp</a>([double tension = 0.6])</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-skewBy" href="#flNode-skewBy"><span class="function-name">skewBy</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-skewBy">skewBy</a>(valueDegreeX | (valueDegreX, valueDegreY)[, QPointF origin=(0, 0)])</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-smartMove" href="#flNode-smartMove"><span class="function-name">smartMove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(uint) <a href="#flNode-smartMove">smartMove</a>(offset)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-smartSetXY" href="#flNode-smartSetXY"><span class="function-name">smartSetXY</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-smartSetXY">smartSetXY</a>(QPointF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-storeCoordinates" href="#flNode-storeCoordinates"><span class="function-name">storeCoordinates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-storeCoordinates">storeCoordinates</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-storeTestParameters" href="#flNode-storeTestParameters"><span class="function-name">storeTestParameters</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-storeTestParameters">storeTestParameters</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-tag" href="#flNode-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-transformBy" href="#flNode-transformBy"><span class="function-name">transformBy</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-transformBy">transformBy</a>(QTransform tx[, QPointF origin=(0, 0)])</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-update" href="#flNode-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-update">update</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-updateG2" href="#flNode-updateG2"><span class="function-name">updateG2</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-updateG2">updateG2</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-updateSmooth" href="#flNode-updateSmooth"><span class="function-name">updateSmooth</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNode-updateSmooth">updateSmooth</a>([bool extended_neibh=true])</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flNode-cloneObject" href="#flNode-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flNode-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-createObject" href="#flNode-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flNode-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-haveObject" href="#flNode-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNode-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flNode-instanceType" href="#flNode-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flNode-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>angle</dt>
<dd>

<pre class="doc" markdown="0">angle</pre>

</dd>
</dl>
<dl class="descriptor"><dt>contour</dt>
<dd>

<pre class="doc" markdown="0">The parent Contour or None if not present</pre>

</dd>
</dl>
<dl class="descriptor"><dt>g2</dt>
<dd>

<pre class="doc" markdown="0">g2</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hobby</dt>
<dd>

<pre class="doc" markdown="0">hobby</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>index</dt>
<dd>

<pre class="doc" markdown="0">The index of the node in parent's contour (if present, otherwise -1)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>interpolated</dt>
<dd>

<pre class="doc" markdown="0">interpolated</pre>

</dd>
</dl>
<dl class="descriptor"><dt>interpolatedX</dt>
<dd>

<pre class="doc" markdown="0">interpolatedX</pre>

</dd>
</dl>
<dl class="descriptor"><dt>interpolatedY</dt>
<dd>

<pre class="doc" markdown="0">interpolatedY</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isSelectedAlone</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isTerminal</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>nodeState</dt>
<dd>

<pre class="doc" markdown="0">nodeState</pre>

</dd>
</dl>
<dl class="descriptor"><dt>position</dt>
<dd>

<pre class="doc" markdown="0">Coordinates of the node as QPointF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>preview</dt>
<dd>

<pre class="doc" markdown="0">preview</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>scv</dt>
<dd>

<pre class="doc" markdown="0">scv</pre>

</dd>
</dl>
<dl class="descriptor"><dt>selected</dt>
<dd>

<pre class="doc" markdown="0">The selected flag</pre>

</dd>
</dl>
<dl class="descriptor"><dt>smartAngleR</dt>
<dd>

<pre class="doc" markdown="0">smartAngleR</pre>

</dd>
</dl>
<dl class="descriptor"><dt>smooth</dt>
<dd>

<pre class="doc" markdown="0">The smooth flag</pre>

</dd>
</dl>
<dl class="descriptor"><dt>state</dt>
<dd>

<pre class="doc" markdown="0">state</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">The node type</pre>

</dd>
</dl>
<dl class="descriptor"><dt>x</dt>
<dd>

<pre class="doc" markdown="0">The x coordinate of the node</pre>

</dd>
</dl>
<dl class="descriptor"><dt>y</dt>
<dd>

<pre class="doc" markdown="0">The y coordinate of the node</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">NodeKind</span> = {'ExtraLast': 16384, 'First': 16, 'G2': 4096, 'Hobby': 8192, 'HotSpot': 2048, 'InterpolatedX': 256, 'InterpolatedY': 512, 'KindMask': 65535, 'None': 0, 'Preview': 64, ...}</dt></dl>
<dl><dt><span class="other-name">NodeType</span> = {'AnyNodeMask': 7, 'Curve': 4, 'Off': 2, 'On': 1}</dt></dl>
<dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flNode-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flNodeInfo" href="#flNodeInfo">class <span class="class-name">flNodeInfo</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flNodeInfo representation

Constructors:
  flNodeInfo()
  flNodeInfo(flObject)
  flNodeInfo(flNodeInfo)
  flNodeInfo(flNode, QTransform)
  flNodeInfo(flNode, flObject contour_info)
  flNodeInfo(flNode, flObject glyph_info, QTransform)
  flNodeInfo(flNode, flNodeInfo)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flNodeInfo-__delattr__" href="#flNodeInfo-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNodeInfo-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-__eq__" href="#flNodeInfo-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNodeInfo-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-__ge__" href="#flNodeInfo-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNodeInfo-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-__getattribute__" href="#flNodeInfo-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNodeInfo-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-__gt__" href="#flNodeInfo-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNodeInfo-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-__init__" href="#flNodeInfo-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNodeInfo-__init__">__init__</a>(...) initializes x; see help(<a href="#flNodeInfo-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-__le__" href="#flNodeInfo-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNodeInfo-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-__lt__" href="#flNodeInfo-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNodeInfo-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-__ne__" href="#flNodeInfo-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNodeInfo-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-__repr__" href="#flNodeInfo-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNodeInfo-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-__setattr__" href="#flNodeInfo-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flNodeInfo-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-breakContourExpanded" href="#flNodeInfo-breakContourExpanded"><span class="function-name">breakContourExpanded</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNodeInfo-breakContourExpanded">breakContourExpanded</a>([double extrapolate_d=0.5])</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-changed" href="#flNodeInfo-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-checkInitHistoryState" href="#flNodeInfo-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-clearAboveHistory" href="#flNodeInfo-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-clearFlag" href="#flNodeInfo-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-clearFlags" href="#flNodeInfo-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-clone" href="#flNodeInfo-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-combine" href="#flNodeInfo-combine"><span class="function-name">combine</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-combine">combine</a>(QTransform transform)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-contour" href="#flNodeInfo-contour"><span class="function-name">contour</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flContour">flContour</a> <a href="#flNodeInfo-contour">contour</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-createHistoryState" href="#flNodeInfo-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-currentHistoryState" href="#flNodeInfo-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-flag" href="#flNodeInfo-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-getGlyphPoint" href="#flNodeInfo-getGlyphPoint"><span class="function-name">getGlyphPoint</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#flNodeInfo-getGlyphPoint">getGlyphPoint</a>(bool round)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-getMappedNeighborsRect" href="#flNodeInfo-getMappedNeighborsRect"><span class="function-name">getMappedNeighborsRect</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF <a href="#flNodeInfo-getMappedNeighborsRect">getMappedNeighborsRect</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-getMappedPoint" href="#flNodeInfo-getMappedPoint"><span class="function-name">getMappedPoint</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF <a href="#flNodeInfo-getMappedPoint">getMappedPoint</a>([QPointF])</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-getProperties" href="#flNodeInfo-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-getProperty" href="#flNodeInfo-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-getPropertyFloat" href="#flNodeInfo-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-getPropertyInt" href="#flNodeInfo-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-getUpdateCanvasRect" href="#flNodeInfo-getUpdateCanvasRect"><span class="function-name">getUpdateCanvasRect</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF <a href="#flNodeInfo-getUpdateCanvasRect">getUpdateCanvasRect</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-hasHistoryState" href="#flNodeInfo-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-historyStates" href="#flNodeInfo-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-independedAll" href="#flNodeInfo-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-initialHistoryState" href="#flNodeInfo-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-isEqual" href="#flNodeInfo-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-isValid" href="#flNodeInfo-isValid"><span class="function-name">isValid</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNodeInfo-isValid">isValid</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-release" href="#flNodeInfo-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-remove" href="#flNodeInfo-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-removeChild" href="#flNodeInfo-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-removeProperty" href="#flNodeInfo-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-restoreHistoryState" href="#flNodeInfo-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-setFlag" href="#flNodeInfo-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-setGlyphPoint" href="#flNodeInfo-setGlyphPoint"><span class="function-name">setGlyphPoint</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-setGlyphPoint">setGlyphPoint</a>(QPointF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-setGlyphPointX" href="#flNodeInfo-setGlyphPointX"><span class="function-name">setGlyphPointX</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-setGlyphPointX">setGlyphPointX</a>(double x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-setGlyphPointY" href="#flNodeInfo-setGlyphPointY"><span class="function-name">setGlyphPointY</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-setGlyphPointY">setGlyphPointY</a>(double y)</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-setProperty" href="#flNodeInfo-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-setPropertyFloat" href="#flNodeInfo-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-setPropertyInt" href="#flNodeInfo-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-shape" href="#flNodeInfo-shape"><span class="function-name">shape</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flShape">flShape</a> <a href="#flNodeInfo-shape">shape</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-shapeInfo" href="#flNodeInfo-shapeInfo"><span class="function-name">shapeInfo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flShapeInfo">flShapeInfo</a> <a href="#flNodeInfo-shapeInfo">shapeInfo</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-tag" href="#flNodeInfo-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-toNodesInfo" href="#flNodeInfo-toNodesInfo"><span class="function-name">toNodesInfo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#flNodeInfo">flNodeInfo</a>) <a href="#flNodeInfo-toNodesInfo">toNodesInfo</a>(list(<a href="#flNode">flNode</a>))</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-update" href="#flNodeInfo-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo-update">update</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flNodeInfo-cloneObject" href="#flNodeInfo-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flNodeInfo-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-createInstance" href="#flNodeInfo-createInstance"><span class="function-name">createInstance</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flNodeInfo">flNodeInfo</a> <a href="#flNodeInfo-createInstance">createInstance</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-createObject" href="#flNodeInfo-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flNodeInfo-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-haveObject" href="#flNodeInfo-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flNodeInfo-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flNodeInfo-instanceType" href="#flNodeInfo-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flNodeInfo-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>contourInfo</dt>
<dd>

<pre class="doc" markdown="0">flObject</pre>

</dd>
</dl>
<dl class="descriptor"><dt>dist</dt>
<dd>

<pre class="doc" markdown="0">double dist</pre>

</dd>
</dl>
<dl class="descriptor"><dt>glyphInfo</dt>
<dd>

<pre class="doc" markdown="0">flObject - glyph info</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>node</dt>
<dd>

<pre class="doc" markdown="0">flNode</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>transform</dt>
<dd>

<pre class="doc" markdown="0">transform matrix</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flNodeInfo-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flObject" href="#flObject">class <span class="class-name">flObject</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flObject representation

Constructors:
  flObject()
  flObject(flObject)
  flObject(uint id)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flObject-__delattr__" href="#flObject-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObject-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-__eq__" href="#flObject-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObject-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-__ge__" href="#flObject-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObject-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-__getattribute__" href="#flObject-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObject-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-__gt__" href="#flObject-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObject-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-__init__" href="#flObject-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObject-__init__">__init__</a>(...) initializes x; see help(<a href="#flObject-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-__le__" href="#flObject-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObject-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-__lt__" href="#flObject-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObject-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-__ne__" href="#flObject-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObject-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-__repr__" href="#flObject-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObject-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-__setattr__" href="#flObject-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObject-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-changed" href="#flObject-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-checkInitHistoryState" href="#flObject-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-clearAboveHistory" href="#flObject-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-clearFlag" href="#flObject-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-clearFlags" href="#flObject-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-clone" href="#flObject-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-createHistoryState" href="#flObject-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-currentHistoryState" href="#flObject-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-flag" href="#flObject-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-getProperties" href="#flObject-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-getProperty" href="#flObject-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-getPropertyFloat" href="#flObject-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-getPropertyInt" href="#flObject-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-hasHistoryState" href="#flObject-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-historyStates" href="#flObject-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-independedAll" href="#flObject-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-initialHistoryState" href="#flObject-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-isEqual" href="#flObject-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-release" href="#flObject-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-remove" href="#flObject-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-removeChild" href="#flObject-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-removeProperty" href="#flObject-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-restoreHistoryState" href="#flObject-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-setFlag" href="#flObject-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-setProperty" href="#flObject-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-setPropertyFloat" href="#flObject-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-setPropertyInt" href="#flObject-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-tag" href="#flObject-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-update" href="#flObject-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject-update">update</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flObject-cloneObject" href="#flObject-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flObject-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-createObject" href="#flObject-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flObject-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-haveObject" href="#flObject-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flObject-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flObject-instanceType" href="#flObject-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flObject-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flObject-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flObjectsList<flGuideLine>" href="#flObjectsList<flGuideLine>">class <span class="class-name">flObjectsList<flGuideLine></span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flObjectsList<flGuideLine> doc</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flObjectsList<flGuideLine>-__delattr__" href="#flObjectsList<flGuideLine>-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flGuideLine>-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-__eq__" href="#flObjectsList<flGuideLine>-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flGuideLine>-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-__ge__" href="#flObjectsList<flGuideLine>-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flGuideLine>-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-__getattribute__" href="#flObjectsList<flGuideLine>-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flGuideLine>-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-__gt__" href="#flObjectsList<flGuideLine>-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flGuideLine>-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-__init__" href="#flObjectsList<flGuideLine>-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flGuideLine>-__init__">__init__</a>(...) initializes x; see help(<a href="#flObjectsList<flGuideLine>-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-__le__" href="#flObjectsList<flGuideLine>-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flGuideLine>-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-__lt__" href="#flObjectsList<flGuideLine>-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flGuideLine>-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-__ne__" href="#flObjectsList<flGuideLine>-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flGuideLine>-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-__repr__" href="#flObjectsList<flGuideLine>-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flGuideLine>-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-__setattr__" href="#flObjectsList<flGuideLine>-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flGuideLine>-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-append" href="#flObjectsList<flGuideLine>-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flObjectsList<flGuideLine>-append">append</a>(T o)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-at" href="#flObjectsList<flGuideLine>-at"><span class="function-name">at</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">T <a href="#flObjectsList<flGuideLine>-at">at</a>(int i)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-changed" href="#flObjectsList<flGuideLine>-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-checkInitHistoryState" href="#flObjectsList<flGuideLine>-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-clear" href="#flObjectsList<flGuideLine>-clear"><span class="function-name">clear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flObjectsList<flGuideLine>-clear">clear</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-clearAboveHistory" href="#flObjectsList<flGuideLine>-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-clearFlag" href="#flObjectsList<flGuideLine>-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-clearFlags" href="#flObjectsList<flGuideLine>-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-clone" href="#flObjectsList<flGuideLine>-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-contains" href="#flObjectsList<flGuideLine>-contains"><span class="function-name">contains</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flObjectsList<flGuideLine>-contains">contains</a>(T o)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-createHistoryState" href="#flObjectsList<flGuideLine>-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-currentHistoryState" href="#flObjectsList<flGuideLine>-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-flag" href="#flObjectsList<flGuideLine>-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-getProperties" href="#flObjectsList<flGuideLine>-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-getProperty" href="#flObjectsList<flGuideLine>-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-getPropertyFloat" href="#flObjectsList<flGuideLine>-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-getPropertyInt" href="#flObjectsList<flGuideLine>-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-hasHistoryState" href="#flObjectsList<flGuideLine>-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-historyStates" href="#flObjectsList<flGuideLine>-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-independedAll" href="#flObjectsList<flGuideLine>-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-indexOf" href="#flObjectsList<flGuideLine>-indexOf"><span class="function-name">indexOf</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flObjectsList<flGuideLine>-indexOf">indexOf</a>(T o)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-initialHistoryState" href="#flObjectsList<flGuideLine>-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-insert" href="#flObjectsList<flGuideLine>-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flObjectsList<flGuideLine>-insert">insert</a>(int index, T o)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-isEqual" href="#flObjectsList<flGuideLine>-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-release" href="#flObjectsList<flGuideLine>-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-remove" href="#flObjectsList<flGuideLine>-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-removeChild" href="#flObjectsList<flGuideLine>-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-removeOne" href="#flObjectsList<flGuideLine>-removeOne"><span class="function-name">removeOne</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flObjectsList<flGuideLine>-removeOne">removeOne</a>(T o)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-removeProperty" href="#flObjectsList<flGuideLine>-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-restoreHistoryState" href="#flObjectsList<flGuideLine>-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-setFlag" href="#flObjectsList<flGuideLine>-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-setProperty" href="#flObjectsList<flGuideLine>-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-setPropertyFloat" href="#flObjectsList<flGuideLine>-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-setPropertyInt" href="#flObjectsList<flGuideLine>-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-swap" href="#flObjectsList<flGuideLine>-swap"><span class="function-name">swap</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flObjectsList<flGuideLine>-swap">swap</a>(int i0, int i1)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-tag" href="#flObjectsList<flGuideLine>-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-update" href="#flObjectsList<flGuideLine>-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flGuideLine>-update">update</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flObjectsList<flGuideLine>-cloneObject" href="#flObjectsList<flGuideLine>-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flObjectsList<flGuideLine>-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-createObject" href="#flObjectsList<flGuideLine>-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flObjectsList<flGuideLine>-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-haveObject" href="#flObjectsList<flGuideLine>-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flObjectsList<flGuideLine>-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flGuideLine>-instanceType" href="#flObjectsList<flGuideLine>-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flObjectsList<flGuideLine>-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>count</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>first</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>last</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>list</dt>
<dd>

<pre class="doc" markdown="0">as list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flObjectsList<flGuideLine>-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flObjectsList<flShape>" href="#flObjectsList<flShape>">class <span class="class-name">flObjectsList<flShape></span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flObjectsList<flShape> doc</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flObjectsList<flShape>-__delattr__" href="#flObjectsList<flShape>-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flShape>-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-__eq__" href="#flObjectsList<flShape>-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flShape>-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-__ge__" href="#flObjectsList<flShape>-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flShape>-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-__getattribute__" href="#flObjectsList<flShape>-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flShape>-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-__gt__" href="#flObjectsList<flShape>-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flShape>-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-__init__" href="#flObjectsList<flShape>-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flShape>-__init__">__init__</a>(...) initializes x; see help(<a href="#flObjectsList<flShape>-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-__le__" href="#flObjectsList<flShape>-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flShape>-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-__lt__" href="#flObjectsList<flShape>-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flShape>-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-__ne__" href="#flObjectsList<flShape>-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flShape>-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-__repr__" href="#flObjectsList<flShape>-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flShape>-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-__setattr__" href="#flObjectsList<flShape>-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flObjectsList<flShape>-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-append" href="#flObjectsList<flShape>-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flObjectsList<flShape>-append">append</a>(T o)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-at" href="#flObjectsList<flShape>-at"><span class="function-name">at</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">T <a href="#flObjectsList<flShape>-at">at</a>(int i)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-changed" href="#flObjectsList<flShape>-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-checkInitHistoryState" href="#flObjectsList<flShape>-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-clear" href="#flObjectsList<flShape>-clear"><span class="function-name">clear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flObjectsList<flShape>-clear">clear</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-clearAboveHistory" href="#flObjectsList<flShape>-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-clearFlag" href="#flObjectsList<flShape>-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-clearFlags" href="#flObjectsList<flShape>-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-clone" href="#flObjectsList<flShape>-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-contains" href="#flObjectsList<flShape>-contains"><span class="function-name">contains</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flObjectsList<flShape>-contains">contains</a>(T o)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-createHistoryState" href="#flObjectsList<flShape>-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-currentHistoryState" href="#flObjectsList<flShape>-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-flag" href="#flObjectsList<flShape>-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-getProperties" href="#flObjectsList<flShape>-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-getProperty" href="#flObjectsList<flShape>-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-getPropertyFloat" href="#flObjectsList<flShape>-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-getPropertyInt" href="#flObjectsList<flShape>-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-hasHistoryState" href="#flObjectsList<flShape>-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-historyStates" href="#flObjectsList<flShape>-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-independedAll" href="#flObjectsList<flShape>-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-indexOf" href="#flObjectsList<flShape>-indexOf"><span class="function-name">indexOf</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flObjectsList<flShape>-indexOf">indexOf</a>(T o)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-initialHistoryState" href="#flObjectsList<flShape>-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-insert" href="#flObjectsList<flShape>-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flObjectsList<flShape>-insert">insert</a>(int index, T o)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-isEqual" href="#flObjectsList<flShape>-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-release" href="#flObjectsList<flShape>-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-remove" href="#flObjectsList<flShape>-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-removeChild" href="#flObjectsList<flShape>-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-removeOne" href="#flObjectsList<flShape>-removeOne"><span class="function-name">removeOne</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flObjectsList<flShape>-removeOne">removeOne</a>(T o)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-removeProperty" href="#flObjectsList<flShape>-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-restoreHistoryState" href="#flObjectsList<flShape>-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-setFlag" href="#flObjectsList<flShape>-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-setProperty" href="#flObjectsList<flShape>-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-setPropertyFloat" href="#flObjectsList<flShape>-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-setPropertyInt" href="#flObjectsList<flShape>-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-swap" href="#flObjectsList<flShape>-swap"><span class="function-name">swap</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">void <a href="#flObjectsList<flShape>-swap">swap</a>(int i0, int i1)</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-tag" href="#flObjectsList<flShape>-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-update" href="#flObjectsList<flShape>-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObjectsList<flShape>-update">update</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flObjectsList<flShape>-cloneObject" href="#flObjectsList<flShape>-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flObjectsList<flShape>-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-createObject" href="#flObjectsList<flShape>-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flObjectsList<flShape>-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-haveObject" href="#flObjectsList<flShape>-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flObjectsList<flShape>-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flObjectsList<flShape>-instanceType" href="#flObjectsList<flShape>-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flObjectsList<flShape>-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>count</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>first</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>last</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>list</dt>
<dd>

<pre class="doc" markdown="0">as list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flObjectsList<flShape>-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flPackage" href="#flPackage">class <span class="class-name">flPackage</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flPackage representation

Constructors:
  flPackage()
  flPackage(flObject)
  flPackage(fgFont)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flPackage-__delattr__" href="#flPackage-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPackage-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-__eq__" href="#flPackage-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPackage-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-__ge__" href="#flPackage-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPackage-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-__getattribute__" href="#flPackage-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPackage-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-__gt__" href="#flPackage-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPackage-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-__init__" href="#flPackage-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPackage-__init__">__init__</a>(...) initializes x; see help(<a href="#flPackage-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-__le__" href="#flPackage-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPackage-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-__lt__" href="#flPackage-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPackage-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-__ne__" href="#flPackage-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPackage-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-__repr__" href="#flPackage-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPackage-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-__setattr__" href="#flPackage-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPackage-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-activateGlyph" href="#flPackage-activateGlyph"><span class="function-name">activateGlyph</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-activateGlyph">activateGlyph</a>(<a href="#flGlyph">flGlyph</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-addAxis" href="#flPackage-addAxis"><span class="function-name">addAxis</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#flPackage-addAxis">addAxis</a>(<a href="#flAxis">flAxis</a> variable)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-addGlyph" href="#flPackage-addGlyph"><span class="function-name">addGlyph</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-addGlyph">addGlyph</a>(fgGlyph / <a href="#flGlyph">flGlyph</a> )</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-addInstance" href="#flPackage-addInstance"><span class="function-name">addInstance</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-addInstance">addInstance</a>(const <a href="#flInstance">flInstance</a> &instance)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-addMaster" href="#flPackage-addMaster"><span class="function-name">addMaster</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#flPackage-addMaster">addMaster</a>(string master_name, bool create_glyphs, <a href="#flPackage">flPackage</a> source, string source_layer_name, bool copy_metrics, bool create_missing_glyphs[, <a href="#flLocation">flLocation</a> location])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-assignData" href="#flPackage-assignData"><span class="function-name">assignData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-assignData">assignData</a>(const <a href="#flPackage">flPackage</a> &package)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-autohintGlyphs" href="#flPackage-autohintGlyphs"><span class="function-name">autohintGlyphs</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-autohintGlyphs">autohintGlyphs</a>(QList<<a href="#flGlyph">flGlyph</a>> glyphs, bool make_hints)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-buildShapeDataNames" href="#flPackage-buildShapeDataNames"><span class="function-name">buildShapeDataNames</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QSet<string> <a href="#flPackage-buildShapeDataNames">buildShapeDataNames</a>(objId exclude[, string layer_name])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-can_interpolate" href="#flPackage-can_interpolate"><span class="function-name">can_interpolate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPackage-can_interpolate">can_interpolate</a>([string master_name])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-changed" href="#flPackage-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-checkAxisName" href="#flPackage-checkAxisName"><span class="function-name">checkAxisName</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#flPackage-checkAxisName">checkAxisName</a>(string name)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-checkInitHistoryState" href="#flPackage-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-checkVariableName" href="#flPackage-checkVariableName"><span class="function-name">checkVariableName</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#flPackage-checkVariableName">checkVariableName</a>(string name)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-clearAboveHistory" href="#flPackage-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-clearActiveGlyphs" href="#flPackage-clearActiveGlyphs"><span class="function-name">clearActiveGlyphs</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-clearActiveGlyphs">clearActiveGlyphs</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-clearFlag" href="#flPackage-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-clearFlags" href="#flPackage-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-clearInstances" href="#flPackage-clearInstances"><span class="function-name">clearInstances</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-clearInstances">clearInstances</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-clearMasters" href="#flPackage-clearMasters"><span class="function-name">clearMasters</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-clearMasters">clearMasters</a>(bool release)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-clone" href="#flPackage-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-close" href="#flPackage-close"><span class="function-name">close</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-close">close</a>(save=False) - Close the font</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-collectNames" href="#flPackage-collectNames"><span class="function-name">collectNames</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-collectNames">collectNames</a>(StorageInfo * storage)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-collectShapes" href="#flPackage-collectShapes"><span class="function-name">collectShapes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QList<<a href="#flShape">flShape</a>>/Nothing <a href="#flPackage-collectShapes">collectShapes</a>(<a href="#flShape">flShape</a>, string layer_name)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-completeData" href="#flPackage-completeData"><span class="function-name">completeData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-completeData">completeData</a>([bool fg_data = false])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-convertZonesToGuidelines" href="#flPackage-convertZonesToGuidelines"><span class="function-name">convertZonesToGuidelines</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-convertZonesToGuidelines">convertZonesToGuidelines</a>(flZones zonesT, flZones zonesB)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-createHistoryState" href="#flPackage-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-currentHistoryState" href="#flPackage-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-deleteGlyph" href="#flPackage-deleteGlyph"><span class="function-name">deleteGlyph</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPackage-deleteGlyph">deleteGlyph</a>(fgGlyph / <a href="#flGlyph">flGlyph</a> )</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-deleteGroups" href="#flPackage-deleteGroups"><span class="function-name">deleteGroups</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-deleteGroups">deleteGroups</a>(QSet<uint> ids, bool deleteDependentContent)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-ensureProteusData" href="#flPackage-ensureProteusData"><span class="function-name">ensureProteusData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-ensureProteusData">ensureProteusData</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-family_zones" href="#flPackage-family_zones"><span class="function-name">family_zones</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#flZone">flZone</a>)& <a href="#flPackage-family_zones">family_zones</a>(bool top)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-featuresContainer" href="#flPackage-featuresContainer"><span class="function-name">featuresContainer</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flPackage-featuresContainer">featuresContainer</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-findAxis" href="#flPackage-findAxis"><span class="function-name">findAxis</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAxis">flAxis</a>/Nothing <a href="#flPackage-findAxis">findAxis</a>(string name[, Qt::CaseSensitivity cs = Qt::CaseSensitive])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-findAxisShort" href="#flPackage-findAxisShort"><span class="function-name">findAxisShort</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flAxis">flAxis</a>/Nothing <a href="#flPackage-findAxisShort">findAxisShort</a>(string short_name)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-findFgId" href="#flPackage-findFgId"><span class="function-name">findFgId</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph">flGlyph</a> <a href="#flPackage-findFgId">findFgId</a>(uint id)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-findGroup" href="#flPackage-findGroup"><span class="function-name">findGroup</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">fg::GlyphGroup* <a href="#flPackage-findGroup">findGroup</a>(int _id)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-findName" href="#flPackage-findName"><span class="function-name">findName</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph">flGlyph</a> <a href="#flPackage-findName">findName</a>(string name)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-findNameId" href="#flPackage-findNameId"><span class="function-name">findNameId</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph">flGlyph</a> <a href="#flPackage-findNameId">findNameId</a>(uint fg_id)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-findNewName" href="#flPackage-findNewName"><span class="function-name">findNewName</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#flPackage-findNewName">findNewName</a>(string name)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-findShapeRoot" href="#flPackage-findShapeRoot"><span class="function-name">findShapeRoot</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph">flGlyph</a> <a href="#flPackage-findShapeRoot">findShapeRoot</a>(<a href="#flShapeData">flShapeData</a> shape_data)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-findStem" href="#flPackage-findStem"><span class="function-name">findStem</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flPackage-findStem">findStem</a>(string n, bool b, bool loose)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-findUnicode" href="#flPackage-findUnicode"><span class="function-name">findUnicode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flGlyph">flGlyph</a> <a href="#flPackage-findUnicode">findUnicode</a>(uint uni)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-findZone" href="#flPackage-findZone"><span class="function-name">findZone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flPackage-findZone">findZone</a>(string n, bool b)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-flag" href="#flPackage-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-generateGlyph" href="#flPackage-generateGlyph"><span class="function-name">generateGlyph</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">( QList<<a href="#GlyphComponent">GlyphComponent</a>>, double width )/Nothing <a href="#flPackage-generateGlyph">generateGlyph</a>(string recipe, string layer_name, <a href="#FontMetrics">FontMetrics</a> metrics, bool rtl)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-getAccentsInfo" href="#flPackage-getAccentsInfo"><span class="function-name">getAccentsInfo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#AccentInfo">AccentInfo</a>)/Nothing <a href="#flPackage-getAccentsInfo">getAccentsInfo</a>(<a href="#flLayer">flLayer</a>, <a href="#flPinPoint">flPinPoint</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-getAllGroups" href="#flPackage-getAllGroups"><span class="function-name">getAllGroups</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list( (bool kernGroup, string groupName, int id, int mark, list(string glyphName) )/Nothing <a href="#flPackage-getAllGroups">getAllGroups</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-getAxisName" href="#flPackage-getAxisName"><span class="function-name">getAxisName</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#flPackage-getAxisName">getAxisName</a>(string short_name)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-getAxisShortName" href="#flPackage-getAxisShortName"><span class="function-name">getAxisShortName</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#flPackage-getAxisShortName">getAxisShortName</a>(string name)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-getLayerName" href="#flPackage-getLayerName"><span class="function-name">getLayerName</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#flPackage-getLayerName">getLayerName</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-getMarkOffset" href="#flPackage-getMarkOffset"><span class="function-name">getMarkOffset</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QPointF/Nothing <a href="#flPackage-getMarkOffset">getMarkOffset</a>(<a href="#flGlyph">flGlyph</a> g1, <a href="#flGlyph">flGlyph</a> g2)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-getProperties" href="#flPackage-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-getProperty" href="#flPackage-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-getPropertyFloat" href="#flPackage-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-getPropertyInt" href="#flPackage-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-getShapes" href="#flPackage-getShapes"><span class="function-name">getShapes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QList<int>/Nothing <a href="#flPackage-getShapes">getShapes</a>(string filter[, string layer_name])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-hasAxis" href="#flPackage-hasAxis"><span class="function-name">hasAxis</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPackage-hasAxis">hasAxis</a>(string name[, Qt::CaseSensitivity cs = Qt::CaseSensitive])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-hasAxisShort" href="#flPackage-hasAxisShort"><span class="function-name">hasAxisShort</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPackage-hasAxisShort">hasAxisShort</a>(string short_name)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-hasGuides" href="#flPackage-hasGuides"><span class="function-name">hasGuides</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPackage-hasGuides">hasGuides</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-hasHistoryState" href="#flPackage-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-hasMaster" href="#flPackage-hasMaster"><span class="function-name">hasMaster</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPackage-hasMaster">hasMaster</a>(string name)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-hasName" href="#flPackage-hasName"><span class="function-name">hasName</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPackage-hasName">hasName</a>(string name[, bool relaxed=false])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-hasPackageHistoryStorages" href="#flPackage-hasPackageHistoryStorages"><span class="function-name">hasPackageHistoryStorages</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPackage-hasPackageHistoryStorages">hasPackageHistoryStorages</a>(uint to_history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-hasZones" href="#flPackage-hasZones"><span class="function-name">hasZones</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPackage-hasZones">hasZones</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-historyStack" href="#flPackage-historyStack"><span class="function-name">historyStack</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flPackage-historyStack">historyStack</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-historyStates" href="#flPackage-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-independedAll" href="#flPackage-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-initItr" href="#flPackage-initItr"><span class="function-name">initItr</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-initItr">initItr</a>(fgTTInterpreter itr)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-initItrGlyph" href="#flPackage-initItrGlyph"><span class="function-name">initItrGlyph</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-initItrGlyph">initItrGlyph</a>(fgTTInterpreter itr, <a href="#flGlyph">flGlyph</a> glyph)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-initialHistoryState" href="#flPackage-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-isComponent" href="#flPackage-isComponent"><span class="function-name">isComponent</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(<a href="#flGlyph">flGlyph</a>, QTransform) <a href="#flPackage-isComponent">isComponent</a>(<a href="#flShapeData">flShapeData</a>[, string layer_name])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-isEqual" href="#flPackage-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-kerning" href="#flPackage-kerning"><span class="function-name">kerning</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">fgKerning <a href="#flPackage-kerning">kerning</a>([string master_name])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-kerningContainer" href="#flPackage-kerningContainer"><span class="function-name">kerningContainer</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flPackage-kerningContainer">kerningContainer</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-location" href="#flPackage-location"><span class="function-name">location</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flLocation">flLocation</a>& <a href="#flPackage-location">location</a>([string master_name])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-makeShapeDataName" href="#flPackage-makeShapeDataName"><span class="function-name">makeShapeDataName</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#flPackage-makeShapeDataName">makeShapeDataName</a>(string name, objId _id, string layer_name)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-mastersContainer" href="#flPackage-mastersContainer"><span class="function-name">mastersContainer</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flPackage-mastersContainer">mastersContainer</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-optimizeShapeTransformations" href="#flPackage-optimizeShapeTransformations"><span class="function-name">optimizeShapeTransformations</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPackage-optimizeShapeTransformations">optimizeShapeTransformations</a>(QList<<a href="#flObject">flObject</a>> changes)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-optimizeStemData" href="#flPackage-optimizeStemData"><span class="function-name">optimizeStemData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(flStems stemsH, flStems stemsV) <a href="#flPackage-optimizeStemData">optimizeStemData</a>(flStems stemsH, flStems stemsV)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-prepareAxes" href="#flPackage-prepareAxes"><span class="function-name">prepareAxes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QList<<a href="#flAxis">flAxis</a>>/Nothing <a href="#flPackage-prepareAxes">prepareAxes</a>(QList<<a href="#flPackage">flPackage</a>> packages, QList<<a href="#flGlyph">flGlyph</a>> glyphs)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-prepareFontGateData" href="#flPackage-prepareFontGateData"><span class="function-name">prepareFontGateData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-prepareFontGateData">prepareFontGateData</a>(bool prepare_tth)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-preparePropertiesData" href="#flPackage-preparePropertiesData"><span class="function-name">preparePropertiesData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-preparePropertiesData">preparePropertiesData</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-projectPackageName" href="#flPackage-projectPackageName"><span class="function-name">projectPackageName</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#flPackage-projectPackageName">projectPackageName</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-referencesCount" href="#flPackage-referencesCount"><span class="function-name">referencesCount</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flPackage-referencesCount">referencesCount</a>(uint shapeDataId)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-release" href="#flPackage-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-remove" href="#flPackage-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-removeChild" href="#flPackage-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-removeMaster" href="#flPackage-removeMaster"><span class="function-name">removeMaster</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-removeMaster">removeMaster</a>(string name, bool remove_glyph_masters)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-removeProperty" href="#flPackage-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-renameGlyph" href="#flPackage-renameGlyph"><span class="function-name">renameGlyph</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPackage-renameGlyph">renameGlyph</a>(fgGlyph glyph, string name, bool rename)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-renameMaster" href="#flPackage-renameMaster"><span class="function-name">renameMaster</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#flPackage-renameMaster">renameMaster</a>(string old_name, string new_name)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-replaceGlyph" href="#flPackage-replaceGlyph"><span class="function-name">replaceGlyph</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPackage-replaceGlyph">replaceGlyph</a>(fgGlyph target, fgGlyph newGlyph, bool rename)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-replaceShapeWithReference" href="#flPackage-replaceShapeWithReference"><span class="function-name">replaceShapeWithReference</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flShape">flShape</a>/Nothing <a href="#flPackage-replaceShapeWithReference">replaceShapeWithReference</a>(<a href="#flShape">flShape</a> shape, bool process[, string layer_name])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-resetPackage" href="#flPackage-resetPackage"><span class="function-name">resetPackage</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-resetPackage">resetPackage</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-resetStemData" href="#flPackage-resetStemData"><span class="function-name">resetStemData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(flStems stemsH, flStems stemsV) <a href="#flPackage-resetStemData">resetStemData</a>(flStems stemsH, flStems stemsV)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-restoreHistoryState" href="#flPackage-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-setAxis" href="#flPackage-setAxis"><span class="function-name">setAxis</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-setAxis">setAxis</a>(const <a href="#flAxis">flAxis</a> &p)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-setFlag" href="#flPackage-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-setLocation" href="#flPackage-setLocation"><span class="function-name">setLocation</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-setLocation">setLocation</a>(<a href="#flLocation">flLocation</a> location[, string master_name])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-setMaster" href="#flPackage-setMaster"><span class="function-name">setMaster</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-setMaster">setMaster</a>(string name[, bool notify = false])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-setProperty" href="#flPackage-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-setPropertyFloat" href="#flPackage-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-setPropertyInt" href="#flPackage-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-setUpm" href="#flPackage-setUpm"><span class="function-name">setUpm</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-setUpm">setUpm</a>(int upm, bool scale)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-set_ascender_locked" href="#flPackage-set_ascender_locked"><span class="function-name">set_ascender_locked</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-set_ascender_locked">set_ascender_locked</a>(bool b)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-set_capsHeight_locked" href="#flPackage-set_capsHeight_locked"><span class="function-name">set_capsHeight_locked</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-set_capsHeight_locked">set_capsHeight_locked</a>(bool b)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-set_descender_locked" href="#flPackage-set_descender_locked"><span class="function-name">set_descender_locked</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-set_descender_locked">set_descender_locked</a>(bool b)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-set_interpolate" href="#flPackage-set_interpolate"><span class="function-name">set_interpolate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-set_interpolate">set_interpolate</a>(bool b[, string master_name])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-set_measurement_locked" href="#flPackage-set_measurement_locked"><span class="function-name">set_measurement_locked</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-set_measurement_locked">set_measurement_locked</a>(bool b)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-set_xHeight_locked" href="#flPackage-set_xHeight_locked"><span class="function-name">set_xHeight_locked</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-set_xHeight_locked">set_xHeight_locked</a>(bool b)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-stems" href="#flPackage-stems"><span class="function-name">stems</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#flStem">flStem</a>)& <a href="#flPackage-stems">stems</a>(HintingDataType, bool top)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-store_font_info" href="#flPackage-store_font_info"><span class="function-name">store_font_info</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-store_font_info">store_font_info</a>(fg::Package *package)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-store_hinting_data" href="#flPackage-store_hinting_data"><span class="function-name">store_hinting_data</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-store_hinting_data">store_hinting_data</a>(fgPackage package)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-styleCode" href="#flPackage-styleCode"><span class="function-name">styleCode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">unsigned char <a href="#flPackage-styleCode">styleCode</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-tag" href="#flPackage-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-title_name" href="#flPackage-title_name"><span class="function-name">title_name</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#flPackage-title_name">title_name</a>([bool force_full = true])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-tthRenameStems" href="#flPackage-tthRenameStems"><span class="function-name">tthRenameStems</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPackage-tthRenameStems">tthRenameStems</a>(QMap<QString, QString> map_h, QMap<QString, QString> map_v)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-tthRenameZones" href="#flPackage-tthRenameZones"><span class="function-name">tthRenameZones</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPackage-tthRenameZones">tthRenameZones</a>(QMap<QString, QString> map_top, QMap<QString, QString> map_bottom)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-update" href="#flPackage-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-update">update</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-updateAxesMap" href="#flPackage-updateAxesMap"><span class="function-name">updateAxesMap</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-updateAxesMap">updateAxesMap</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-updateFontMetrics" href="#flPackage-updateFontMetrics"><span class="function-name">updateFontMetrics</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-updateFontMetrics">updateFontMetrics</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-updateShapeReferenceCount" href="#flPackage-updateShapeReferenceCount"><span class="function-name">updateShapeReferenceCount</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-updateShapeReferenceCount">updateShapeReferenceCount</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-updateZonesFromGuidelines" href="#flPackage-updateZonesFromGuidelines"><span class="function-name">updateZonesFromGuidelines</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage-updateZonesFromGuidelines">updateZonesFromGuidelines</a>([flZones zonesT, flZones zonesB])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-zones" href="#flPackage-zones"><span class="function-name">zones</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#flZone">flZone</a>)& <a href="#flPackage-zones">zones</a>(HintingDataType, bool top)</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flPackage-cloneObject" href="#flPackage-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flPackage-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-createObject" href="#flPackage-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flPackage-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-hasInstaceFor" href="#flPackage-hasInstaceFor"><span class="function-name">hasInstaceFor</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPackage-hasInstaceFor">hasInstaceFor</a>(fgFont)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-haveObject" href="#flPackage-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPackage-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-instanceType" href="#flPackage-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flPackage-instanceType">instanceType</a>();</pre>

</dd></dl>
<dl class="function"><dt><a name="flPackage-readFromFile" href="#flPackage-readFromFile"><span class="function-name">readFromFile</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPackage">flPackage</a>/Nothing <a href="#flPackage-readFromFile">readFromFile</a>(string[, StorageInfo*=0])</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>allGuidelines</dt>
<dd>

<pre class="doc" markdown="0">QList<flObject></pre>

</dd>
</dl>
<dl class="descriptor"><dt>ascender_value</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>axes</dt>
<dd>

<pre class="doc" markdown="0">QList<flAxis></pre>

</dd>
</dl>
<dl class="descriptor"><dt>bold</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>capsHeight_value</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>caretOffset_value</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>cornerTension_value</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>counterAnchors</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>counterGuides</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>currentSearch</dt>
<dd>

<pre class="doc" markdown="0">QByteArray</pre>

</dd>
</dl>
<dl class="descriptor"><dt>curveTension</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>curveTension_value</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>defaultMaster</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>descender_value</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>elidedName</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>family_zonesB</dt>
<dd>

<pre class="doc" markdown="0">list(flZone)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>family_zonesT</dt>
<dd>

<pre class="doc" markdown="0">list(flZone)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>ffn</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>fgId</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>fgPackage</dt>
<dd>

<pre class="doc" markdown="0">fgFont</pre>

</dd>
</dl>
<dl class="descriptor"><dt>fileName</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>fontLayerOrder</dt>
<dd>

<pre class="doc" markdown="0">A list of layer names indicating order of the layers in the font</pre>

</dd>
</dl>
<dl class="descriptor"><dt>glyphsCount</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>guidelines</dt>
<dd>

<pre class="doc" markdown="0">flObjectsList<flGuideLine></pre>

</dd>
</dl>
<dl class="descriptor"><dt>guidelinesHost</dt>
<dd>

<pre class="doc" markdown="0">GuidelinesHostIntf*</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasWeightAxis</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasWidthAxis</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hinting</dt>
<dd>

<pre class="doc" markdown="0">flHintingParameters</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>info</dt>
<dd>

<pre class="doc" markdown="0">FontInfo</pre>

</dd>
</dl>
<dl class="descriptor"><dt>inktrapLen_value</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>instanceAttributes</dt>
<dd>

<pre class="doc" markdown="0">flLayerAttributes</pre>

</dd>
</dl>
<dl class="descriptor"><dt>instances</dt>
<dd>

<pre class="doc" markdown="0">QList<flInstance></pre>

</dd>
</dl>
<dl class="descriptor"><dt>interpolationCheckGeometry</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>interpolationExtrapolate</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>interpolationFlags</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>interpolationMutatorMath</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>interpolationSortContours</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isKey</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isMaster</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>italic</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>italicAngle_value</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>keepShapeData</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>lineGap_value</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>mask</dt>
<dd>

<pre class="doc" markdown="0">flLayer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>master</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>masters</dt>
<dd>

<pre class="doc" markdown="0">QList<string></pre>

</dd>
</dl>
<dl class="descriptor"><dt>mastersCount</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>measurement_value</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>monospaced</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>note</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>other</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>panose</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>path</dt>
<dd>

<pre class="doc" markdown="0">The path to the source font file</pre>

</dd>
</dl>
<dl class="descriptor"><dt>ps_stemsH</dt>
<dd>

<pre class="doc" markdown="0">list(flStem)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>ps_stemsV</dt>
<dd>

<pre class="doc" markdown="0">list(flStem)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>ps_zonesB</dt>
<dd>

<pre class="doc" markdown="0">list(flZone)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>ps_zonesT</dt>
<dd>

<pre class="doc" markdown="0">list(flZone)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>psn</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>safeBottom_value</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>safeTop_value</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>sampleString</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>sgn</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>slantTransform</dt>
<dd>

<pre class="doc" markdown="0">QTransform</pre>

</dd>
</dl>
<dl class="descriptor"><dt>slope</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>smartCornerParameters</dt>
<dd>

<pre class="doc" markdown="0">SmartCornerParameters</pre>

</dd>
</dl>
<dl class="descriptor"><dt>stateObject</dt>
<dd>

<pre class="doc" markdown="0">flObject</pre>

</dd>
</dl>
<dl class="descriptor"><dt>tfn</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>tsn</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>tt_stemsH</dt>
<dd>

<pre class="doc" markdown="0">list(flStem)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>tt_stemsV</dt>
<dd>

<pre class="doc" markdown="0">list(flStem)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>tt_zonesB</dt>
<dd>

<pre class="doc" markdown="0">list(flZone)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>tt_zonesT</dt>
<dd>

<pre class="doc" markdown="0">list(flZone)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>
<dl class="descriptor"><dt>underlinePosition_value</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>underlineThickness_value</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>upm</dt>
<dd>

<pre class="doc" markdown="0">float</pre>

</dd>
</dl>
<dl class="descriptor"><dt>variables</dt>
<dd>

<pre class="doc" markdown="0">list(flPropertyDouble)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>variationPackages</dt>
<dd>

<pre class="doc" markdown="0">QList<flPackage></pre>

</dd>
</dl>
<dl class="descriptor"><dt>versionMajor</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>versionMinor</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>weight</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>weight_value</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>width</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>width_value</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>xHeight_value</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flPackage-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flPaper" href="#flPaper">class <span class="class-name">flPaper</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flPaper representation

Constructors:
  flPaper()
  flPaper(flPaper)
  flPaper(flObject)
  flPaper(QBrush)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flPaper-__delattr__" href="#flPaper-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPaper-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-__eq__" href="#flPaper-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPaper-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-__ge__" href="#flPaper-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPaper-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-__getattribute__" href="#flPaper-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPaper-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-__gt__" href="#flPaper-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPaper-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-__init__" href="#flPaper-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPaper-__init__">__init__</a>(...) initializes x; see help(<a href="#flPaper-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-__le__" href="#flPaper-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPaper-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-__lt__" href="#flPaper-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPaper-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-__ne__" href="#flPaper-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPaper-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-__repr__" href="#flPaper-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPaper-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-__setattr__" href="#flPaper-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPaper-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-activeGlyphInfo" href="#flPaper-activeGlyphInfo"><span class="function-name">activeGlyphInfo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flPaper-activeGlyphInfo">activeGlyphInfo</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-changed" href="#flPaper-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-checkInitHistoryState" href="#flPaper-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-clearAboveHistory" href="#flPaper-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-clearFlag" href="#flPaper-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-clearFlags" href="#flPaper-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-clone" href="#flPaper-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-createHistoryState" href="#flPaper-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-currentHistoryState" href="#flPaper-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-flag" href="#flPaper-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-getGlyphInfo" href="#flPaper-getGlyphInfo"><span class="function-name">getGlyphInfo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flPaper-getGlyphInfo">getGlyphInfo</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-getProperties" href="#flPaper-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-getProperty" href="#flPaper-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-getPropertyFloat" href="#flPaper-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-getPropertyInt" href="#flPaper-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-glyph" href="#flPaper-glyph"><span class="function-name">glyph</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flPaper-glyph">glyph</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-glyphInfoAt" href="#flPaper-glyphInfoAt"><span class="function-name">glyphInfoAt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flPaper-glyphInfoAt">glyphInfoAt</a>(int index)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-glyphsBoundRect" href="#flPaper-glyphsBoundRect"><span class="function-name">glyphsBoundRect</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QRectF <a href="#flPaper-glyphsBoundRect">glyphsBoundRect</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-hasActive" href="#flPaper-hasActive"><span class="function-name">hasActive</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPaper-hasActive">hasActive</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-hasContent" href="#flPaper-hasContent"><span class="function-name">hasContent</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPaper-hasContent">hasContent</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-hasHistoryState" href="#flPaper-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-historyStates" href="#flPaper-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-independedAll" href="#flPaper-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-initialHistoryState" href="#flPaper-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-isEqual" href="#flPaper-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-package" href="#flPaper-package"><span class="function-name">package</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flPaper-package">package</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-release" href="#flPaper-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-remove" href="#flPaper-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-removeChild" href="#flPaper-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-removeProperty" href="#flPaper-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-restoreHistoryState" href="#flPaper-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-setActiveGlyph" href="#flPaper-setActiveGlyph"><span class="function-name">setActiveGlyph</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flPaper-setActiveGlyph">setActiveGlyph</a>(<a href="#flObject">flObject</a> glyph)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-setFlag" href="#flPaper-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-setPaperGlyph" href="#flPaper-setPaperGlyph"><span class="function-name">setPaperGlyph</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flPaper-setPaperGlyph">setPaperGlyph</a>(<a href="#flObject">flObject</a> glyph)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-setProperty" href="#flPaper-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-setPropertyFloat" href="#flPaper-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-setPropertyInt" href="#flPaper-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-tag" href="#flPaper-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-update" href="#flPaper-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper-update">update</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flPaper-cloneObject" href="#flPaper-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flPaper-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-createInstance" href="#flPaper-createInstance"><span class="function-name">createInstance</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPaper">flPaper</a> <a href="#flPaper-createInstance">createInstance</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-createObject" href="#flPaper-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flPaper-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-haveObject" href="#flPaper-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPaper-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flPaper-instanceType" href="#flPaper-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flPaper-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flPaper-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flPinPoint" href="#flPinPoint">class <span class="class-name">flPinPoint</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flPinPoint representation

Constructors:
  flPinPoint()
  flPinPoint(flPinPoint)
  flPinPoint(flObject)
  flPinPoint(QPointF[, PinPointStyle=FreePosition])</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flPinPoint-__delattr__" href="#flPinPoint-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPinPoint-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-__eq__" href="#flPinPoint-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPinPoint-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-__ge__" href="#flPinPoint-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPinPoint-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-__getattribute__" href="#flPinPoint-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPinPoint-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-__gt__" href="#flPinPoint-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPinPoint-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-__init__" href="#flPinPoint-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPinPoint-__init__">__init__</a>(...) initializes x; see help(<a href="#flPinPoint-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-__le__" href="#flPinPoint-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPinPoint-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-__lt__" href="#flPinPoint-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPinPoint-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-__ne__" href="#flPinPoint-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPinPoint-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-__repr__" href="#flPinPoint-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPinPoint-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-__setattr__" href="#flPinPoint-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPinPoint-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-changed" href="#flPinPoint-changed"><span class="function-name">changed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-changed">changed</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-checkInitHistoryState" href="#flPinPoint-checkInitHistoryState"><span class="function-name">checkInitHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-checkInitHistoryState">checkInitHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-clearAboveHistory" href="#flPinPoint-clearAboveHistory"><span class="function-name">clearAboveHistory</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-clearAboveHistory">clearAboveHistory</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-clearFlag" href="#flPinPoint-clearFlag"><span class="function-name">clearFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-clearFlag">clearFlag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-clearFlags" href="#flPinPoint-clearFlags"><span class="function-name">clearFlags</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-clearFlags">clearFlags</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-clone" href="#flPinPoint-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Clone the <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-createHistoryState" href="#flPinPoint-createHistoryState"><span class="function-name">createHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-createHistoryState">createHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-currentHistoryState" href="#flPinPoint-currentHistoryState"><span class="function-name">currentHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">currentHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-flag" href="#flPinPoint-flag"><span class="function-name">flag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-flag">flag</a>(uint f)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-getProperties" href="#flPinPoint-getProperties"><span class="function-name">getProperties</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">Get <a href="./__builtin__.html#object">object</a>'s properties list</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-getProperty" href="#flPinPoint-getProperty"><span class="function-name">getProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-getProperty">getProperty</a>('key') - get <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-getPropertyFloat" href="#flPinPoint-getPropertyFloat"><span class="function-name">getPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-getPropertyFloat">getPropertyFloat</a>('key') - get float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-getPropertyInt" href="#flPinPoint-getPropertyInt"><span class="function-name">getPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-getPropertyInt">getPropertyInt</a>('key') - get int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-hasHistoryState" href="#flPinPoint-hasHistoryState"><span class="function-name">hasHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-hasHistoryState">hasHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-historyStates" href="#flPinPoint-historyStates"><span class="function-name">historyStates</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-historyStates">historyStates</a>(bool accepted_state)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-independedAll" href="#flPinPoint-independedAll"><span class="function-name">independedAll</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-independedAll">independedAll</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-initialHistoryState" href="#flPinPoint-initialHistoryState"><span class="function-name">initialHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">initialHistoryIx()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-isEqual" href="#flPinPoint-isEqual"><span class="function-name">isEqual</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-isEqual">isEqual</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-release" href="#flPinPoint-release"><span class="function-name">release</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-release">release</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-remove" href="#flPinPoint-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-remove">remove</a>([<a href="#flObject">flObject</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-removeChild" href="#flPinPoint-removeChild"><span class="function-name">removeChild</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-removeChild">removeChild</a>(<a href="#flObject">flObject</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-removeProperty" href="#flPinPoint-removeProperty"><span class="function-name">removeProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-removeProperty">removeProperty</a>('key')</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-restoreHistoryState" href="#flPinPoint-restoreHistoryState"><span class="function-name">restoreHistoryState</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-restoreHistoryState">restoreHistoryState</a>(uint history_ix)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-setFlag" href="#flPinPoint-setFlag"><span class="function-name">setFlag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-setFlag">setFlag</a>(uint f [, bool value])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-setProperty" href="#flPinPoint-setProperty"><span class="function-name">setProperty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-setProperty">setProperty</a>('key', value) - set <a href="./__builtin__.html#object">object</a> property by 'key' or number</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-setPropertyFloat" href="#flPinPoint-setPropertyFloat"><span class="function-name">setPropertyFloat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-setPropertyFloat">setPropertyFloat</a>('key', value) - set float <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-setPropertyInt" href="#flPinPoint-setPropertyInt"><span class="function-name">setPropertyInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-setPropertyInt">setPropertyInt</a>('key', value) - set int <a href="./__builtin__.html#object">object</a> property by 'key'</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-tag" href="#flPinPoint-tag"><span class="function-name">tag</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-tag">tag</a>([string])</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-translate" href="#flPinPoint-translate"><span class="function-name">translate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-translate">translate</a>(QPointF)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-update" href="#flPinPoint-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint-update">update</a>()</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flPinPoint-cloneObject" href="#flPinPoint-cloneObject"><span class="function-name">cloneObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a> <a href="#flPinPoint-cloneObject">cloneObject</a>(const <a href="#flObject">flObject</a>&);</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-createInstance" href="#flPinPoint-createInstance"><span class="function-name">createInstance</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPinPoint">flPinPoint</a> <a href="#flPinPoint-createInstance">createInstance</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-createObject" href="#flPinPoint-createObject"><span class="function-name">createObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flObject">flObject</a>/Nothing <a href="#flPinPoint-createObject">createObject</a>(int);</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-haveObject" href="#flPinPoint-haveObject"><span class="function-name">haveObject</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPinPoint-haveObject">haveObject</a>(uint);</pre>

</dd></dl>
<dl class="function"><dt><a name="flPinPoint-instanceType" href="#flPinPoint-instanceType"><span class="function-name">instanceType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flPinPoint-instanceType">instanceType</a>();</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>anchor</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>cloudEnabled</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasChanges</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasHistoryStates</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">object id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isChanged</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isLatch</dt>
<dd>

<pre class="doc" markdown="0">bool isLatch()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isNull</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isPresent</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isReleased</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>isValid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">object name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>point</dt>
<dd>

<pre class="doc" markdown="0">QPointF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>refCnt</dt>
<dd>

<pre class="doc" markdown="0">object references count</pre>

</dd>
</dl>
<dl class="descriptor"><dt>style</dt>
<dd>

<pre class="doc" markdown="0">PinPointStyle style()</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">object type</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">PinPointStyle</span> = {'FreePosition': 1, 'ShapeBound': 2}</dt></dl>
<dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#flPinPoint-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
<dl><dt><span class="other-name">flObjectFlags</span> = {'ofAnchored': 64, 'ofChanged': 2, 'ofHistory': 128, 'ofIgnore': 8, 'ofIgnoreChanges': 4, 'ofPassive': 16, 'ofReleased': 1, 'ofSlowUpdate': 32}</dt></dl>
</dd>
<dt class="class"><h2><a name="flPreferences" href="#flPreferences">class <span class="class-name">flPreferences</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">flPreferences representation

Constructors:
  flPreferences()</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="flPreferences-__delattr__" href="#flPreferences-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPreferences-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flPreferences-__getattribute__" href="#flPreferences-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPreferences-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="flPreferences-__init__" href="#flPreferences-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPreferences-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="flPreferences-__repr__" href="#flPreferences-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPreferences-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPreferences-__setattr__" href="#flPreferences-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#flPreferences-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="flPreferences-doInterpolate" href="#flPreferences-doInterpolate"><span class="function-name">doInterpolate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPreferences-doInterpolate">doInterpolate</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPreferences-fontAuditTests" href="#flPreferences-fontAuditTests"><span class="function-name">fontAuditTests</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(int) <a href="#flPreferences-fontAuditTests">fontAuditTests</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPreferences-instance" href="#flPreferences-instance"><span class="function-name">instance</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPreferences">flPreferences</a> <a href="#flPreferences-instance">instance</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPreferences-namecaptionFont" href="#flPreferences-namecaptionFont"><span class="function-name">namecaptionFont</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QFont  namecaptionFont (bool condensed)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPreferences-namecaptionFontFamilyName" href="#flPreferences-namecaptionFontFamilyName"><span class="function-name">namecaptionFontFamilyName</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string namecaptionFontFamilyName (bool condensed)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPreferences-namecaptionFontId" href="#flPreferences-namecaptionFontId"><span class="function-name">namecaptionFontId</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int    namecaptionFontId (bool condensed)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPreferences-options2tracer_precision" href="#flPreferences-options2tracer_precision"><span class="function-name">options2tracer_precision</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flPreferences-options2tracer_precision">options2tracer_precision</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPreferences-options2tracer_smoothness" href="#flPreferences-options2tracer_smoothness"><span class="function-name">options2tracer_smoothness</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#flPreferences-options2tracer_smoothness">options2tracer_smoothness</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPreferences-saveView" href="#flPreferences-saveView"><span class="function-name">saveView</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPreferences-saveView">saveView</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPreferences-setEnabledHorizontalTextBlockAlignment" href="#flPreferences-setEnabledHorizontalTextBlockAlignment"><span class="function-name">setEnabledHorizontalTextBlockAlignment</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPreferences-setEnabledHorizontalTextBlockAlignment">setEnabledHorizontalTextBlockAlignment</a>(bool)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPreferences-setFontAuditTest" href="#flPreferences-setFontAuditTest"><span class="function-name">setFontAuditTest</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPreferences-setFontAuditTest">setFontAuditTest</a>(int id, bool value)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPreferences-setGridDistances" href="#flPreferences-setGridDistances"><span class="function-name">setGridDistances</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#flPreferences-setGridDistances">setGridDistances</a>(double x, double y)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPreferences-sourceMetricsSamples" href="#flPreferences-sourceMetricsSamples"><span class="function-name">sourceMetricsSamples</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QString <a href="#flPreferences-sourceMetricsSamples">sourceMetricsSamples</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPreferences-textBlockAlignmentCenter" href="#flPreferences-textBlockAlignmentCenter"><span class="function-name">textBlockAlignmentCenter</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#flPreferences-textBlockAlignmentCenter">textBlockAlignmentCenter</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="flPreferences-tracer2options_precision" href="#flPreferences-tracer2options_precision"><span class="function-name">tracer2options_precision</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flPreferences-tracer2options_precision">tracer2options_precision</a>(double curve_fit)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPreferences-tracer2options_smoothness" href="#flPreferences-tracer2options_smoothness"><span class="function-name">tracer2options_smoothness</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">double <a href="#flPreferences-tracer2options_smoothness">tracer2options_smoothness</a>(int straighten_angle)</pre>

</dd></dl>
<dl class="function"><dt><a name="flPreferences-unicode2text" href="#flPreferences-unicode2text"><span class="function-name">unicode2text</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">QString <a href="#flPreferences-unicode2text">unicode2text</a>(uint unc)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>colorEncoding</dt>
<dd>

<pre class="doc" markdown="0">QColor</pre>

</dd>
</dl>
<dl class="descriptor"><dt>colorFontCell</dt>
<dd>

<pre class="doc" markdown="0">QColor</pre>

</dd>
</dl>
<dl class="descriptor"><dt>colorGrid</dt>
<dd>

<pre class="doc" markdown="0">QColor</pre>

</dd>
</dl>
<dl class="descriptor"><dt>colorKerning</dt>
<dd>

<pre class="doc" markdown="0">QColor</pre>

</dd>
</dl>
<dl class="descriptor"><dt>colorMask</dt>
<dd>

<pre class="doc" markdown="0">QColor</pre>

</dd>
</dl>
<dl class="descriptor"><dt>colorMaskGlobal</dt>
<dd>

<pre class="doc" markdown="0">QColor</pre>

</dd>
</dl>
<dl class="descriptor"><dt>colorMaskLocal</dt>
<dd>

<pre class="doc" markdown="0">QColor</pre>

</dd>
</dl>
<dl class="descriptor"><dt>colorMetrics</dt>
<dd>

<pre class="doc" markdown="0">QColor</pre>

</dd>
</dl>
<dl class="descriptor"><dt>colorMetricsLines</dt>
<dd>

<pre class="doc" markdown="0">QColor</pre>

</dd>
</dl>
<dl class="descriptor"><dt>colorWorkspace</dt>
<dd>

<pre class="doc" markdown="0">QColor</pre>

</dd>
</dl>
<dl class="descriptor"><dt>convertDetectZoneTags</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>convertPostScriptPrecision</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>convertTrueTypePrecision</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>convertTrueTypeShortCurves</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>dataPath</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>dataPathDefault</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>deactivateShapeByClick</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>defaultTexts</dt>
<dd>

<pre class="doc" markdown="0">QStringList</pre>

</dd>
</dl>
<dl class="descriptor"><dt>developerBacklightUpdate</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>developerLargeQuickHelp</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>developerNoParameters</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>developerOpenGL</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>developerShowKeys</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>drawFocusRect</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>dsigAlgorithm</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>dsigAuthority</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>dsigCertificatePath</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>dsigPassword</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>dsigPrivateKeyPath</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>dsigTimestamp</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>dsigTimestampUrl</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>dsigUrl</dt>
<dd>

<pre class="doc" markdown="0">string</pre>

</dd>
</dl>
<dl class="descriptor"><dt>dsigWrite</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorAcrossGlyphs</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorAcrossLayers</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorAcrossShapes</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorAlternativePencil</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorAutoNonSpacing</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorCenterGlyph</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorClickSelectsCurve</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorCloseDistance</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorCommandSelector</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorCommandToggle</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorContrast</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorCoordinatesEditable</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorCopyText</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorCross</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorCurvatureOpacity</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorCurvatureSize</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorDeleteBreaksContour</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorDeleteSingleNode</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorDirectKerning</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorDirectedShift</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorDoubleClickToggle</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorDragInactiveShape</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorFastPreview</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorFeatures</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorFillOpacity</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorFillOpenContours</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorFixedBCP</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorFocus</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorFollowItalicAngle</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorForcedGrid</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorForcedSnap</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorFrameSelectsOnNodes</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorGestures</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorGuideHitDistance</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorHideMetricsTable</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorHidePlaceholders</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorInactiveHandles</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorInactiveNodes</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorInactiveWireframe</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorInertion</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorInstanceLayer</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorInterpolate</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorInterpolateModifier</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorKerningExclusive</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorLayerDoubleClick</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorListMaskLayers</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorMatch</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorMetricsDoubleClick</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorMinHandle</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorMissingGlyphs</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorModalPen</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorNodeColor</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorNodeFontDefault</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorNodeFontHovered</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorNodeHitDistance</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorNodeSize</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorNoteExpanded</dt>
<dd>

<pre class="doc" markdown="0">bool</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorNudge1</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorNudge10</dt>
<dd>

<pre class="doc" markdown="0">double</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorOffsetDuplicate</dt>
<dd>

<pre class="doc" markdown="0">QPointF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorOffsetPaste</dt>
<dd>

<pre class="doc" markdown="0">QPointF</pre>

</dd>
</dl>
<dl class="descriptor"><dt>editorOutlineThickness</dt>
<dd>

<pre class="doc" markdown="0">int</pre>

</dd>
</dl>
<dl cl