

<a name="fontgate"></a>

# `fontgate`


<h2>fontgate</h2> <div class="module">  <div class="docstring">

<pre class="doc" markdown="0">FontGate Python interface

fgAnchor: Anchor representation
fgAnchors: list of fgAnchor objects
fgAxes: Axes list representation
fgAxis: Axis representation
fgCMaps: list of fgCmapRecord objects
fgCaret: Caret representation
fgCarets: list of fgCaret objects
fgCmapRecord: fgCmapRecord representation
fgCoding: Coding data representation
fgComponent: Component representation
fgComponents: list of fgComponent objects
fgContour: Contour representation
fgContours: list of fgContour objects
fgCuspPoint: CuspPoint representation
fgCuspPoints: list of fgCuspPoint objects
pyfgDataOwnerData: pyfgDataOwnerData objects
fgDesignPosition: Anchor representation
fgDeviceRecord: DeviceRecord representation
fgDeviceRecords: list of fgDeviceRecord objects
fgExtMapUIntToString: fgExtMapUIntToString dictionary
fgFont: Font representation
fgFontHinting: Font Hinting data representation
fgFontInfo: FontInfo data
fgFontInfoDict: Font info dictionaries
fgGaspRecord: GaspRecord representation
fgGaspRecords: list of fgGaspRecord objects
fgGlyph: Glyph representation
fgGlyphsR: fgGlyphsR representation
fgGlyphDict: Glyph dictionaries
fgGlyphIDsSet: GlyphIDs set
fgGlyphs: list of fgGlyph objects
fgGroup: Kerning/Metrics group
fgGroups: Glyph groups list
fgGuide: Guide representation
fgGuides: list of fgGuide objects
fgHint: Hint representation
fgHintCommand: HintCommand representation
fgHintCommands: list of fgHintCommand objects
fgHints: list of fgHint objects
fgKerning: Kerning representation
fgKerningGroups: Dictionary of kerning groups
fgKerningObject: KerningObject representation
fgKerningObjectPair: KerningObjectPair representation
fgLayer: Layer representation
fgLayers: list of fgLayer objects
fgLib: Dictionary with font- or glyph-related data
fgMapBytes: Raw data dictionary
fgExtMapIntTofgShape: fgExtMapIntTofgShape dictionary
fgFlagsDict: bool flags diactionary
fgValuesDict: float values dictionary
fgIntDict: int dictionary
fgStringDict: string dictionary
fgMaster: Anchor representation
fgMasters: list of fgMaster objects
fgMaxP: fgMaxP representation
fgMetricsClass: MetricsClass representation
fgMetricsClasses: list of fgMetricsClass objects
fgNametable: NameTable - unicode->name translation and vice versa
fgNode: Node representation
fgNodes: list of fgNode objects
fgOTLayout: OpenType Layout representation
fgOtInfo: OT Info representation
fgOtValue: OT Value representation
fgPackages: Font packages representation
fgPen: Pen representation
fgExtMapUShortToShort: fgExtMapUShortToShort dictionary
fgShape: Shape representation
fgShapes: list of fgShape objects
fgStem: Stem representation
fgStems: list of fgStem objects
fgTrueTypePoint: TrueType Point representation
fgTrueTypePoints: list of fgTrueTypePoint objects
fgTTInterpreter: TTInterpreter representation
fgVdmxRecord: fgVdmxRecord representation
fgVdmxRecords: list of fgVdmxRecord objects
fgVectorBool: [char] vector
fgVectorChar: [char] vector
fgVectorDouble: [double] vector
fgVectorInt: [int] vector
fgVectorUInt16: [uint16_t] vector
fgVectorUInt32: [uint32t] vector
fgVectorPoint: [fgPoint] vector
fgZone: Zone representation
fgZones: list of fgZone objects
fgOptions: FontGate options
fgOpt_T1Import: fgOpt_T1Import options page
fgOpt_OTImport: fgOpt_OTImport options page
fgOpt_UfoFontImport: fgOpt_UfoFontImport options page
fgOpt_VfbImport: fgOpt_VfbImport options page
fgOpt_VfbExport: fgOpt_VfbExport options page
fgOpt_UfoFontExport: fgOpt_UfoFontExport options page
fgOpt_OTExport: fgOpt_OTExport options page
fgOpt_T1Export: fgOpt_T1Export options page
fgOpt_EOTExport: fgOpt_EOTExport options page
fgOpt_WOFFExport: fgOpt_WOFFExport options page
fgOpt_Font: fgOpt_Font options page
fgOpt_KerningOptions: fgOpt_KerningOptions options page
fgOpt_OTExportFeaFile: fgOpt_OTExportFeaFile options page
fgOpt_TTAutohint: fgOpt_TTAutohint options page
fgOpt_T1Autohint: fgOpt_T1Autohint options page
fgOpt_TTFAutohint: fgOpt_TTFAutohint options page
fgOpt_AutoMetrics: fgOpt_AutoMetrics options page
fgOpt_ExpandKerning: fgOpt_ExpandKerning options page
fgOpt_Optimize: fgOpt_Optimize options page
fgBitmap: Bitmap representation
fgBitmaps: list of  fgBitmap objects
fgBitmapsData: BitmapsData representation
fgBrush: Brush representation
fgColor: Color representation
fgCurve: Curve representation
fgFontGateData: FontGateData representation
fgGlyphData: GlyphData representation
fgExtMapUCharToUChar: fgExtMapUCharToUChar dictionary
fgMatrix: Transformation matrix representation
fgPoint: Point representation
fgPointU: PointU representation
fgRect: Rectangle representation
fgRendered: fgRendered representation
fgTrueTypeData: TrueTypeData representation
fgVector: Vector representation</pre>

</div>  <div class="classes"><h3>Classes</h3><ul class="tree"><li><span class="class-name"><a href="./__builtin__.html#object">__builtin__.object</a></span></li><li><ul class="tree"><li><span class="class-name">__builtin__.fgAnchor</span></li><li><span class="class-name">__builtin__.fgAnchors</span></li><li><span class="class-name">__builtin__.fgAxes</span></li><li><span class="class-name">__builtin__.fgAxis</span></li><li><span class="class-name">__builtin__.fgBitmap</span></li><li><span class="class-name">__builtin__.fgBitmaps</span></li><li><span class="class-name">__builtin__.fgBitmapsData</span></li><li><span class="class-name">__builtin__.fgBrush</span></li><li><span class="class-name">__builtin__.fgCMaps</span></li><li><span class="class-name">__builtin__.fgCaret</span></li><li><span class="class-name">__builtin__.fgCarets</span></li><li><span class="class-name">__builtin__.fgCmapRecord</span></li><li><span class="class-name">__builtin__.fgCoding</span></li><li><span class="class-name">__builtin__.fgColor</span></li><li><span class="class-name">__builtin__.fgComponent</span></li><li><span class="class-name">__builtin__.fgComponents</span></li><li><span class="class-name">__builtin__.fgContour</span></li><li><span class="class-name">__builtin__.fgContours</span></li><li><span class="class-name">__builtin__.fgCurve</span></li><li><span class="class-name">__builtin__.fgCuspPoint</span></li><li><span class="class-name">__builtin__.fgCuspPoints</span></li><li><span class="class-name">__builtin__.fgDesignPosition</span></li><li><span class="class-name">__builtin__.fgDeviceRecord</span></li><li><span class="class-name">__builtin__.fgDeviceRecords</span></li><li><span class="class-name">__builtin__.fgExtMapIntTofgShape</span></li><li><span class="class-name">__builtin__.fgExtMapUCharToUChar</span></li><li><span class="class-name">__builtin__.fgExtMapUIntToString</span></li><li><span class="class-name">__builtin__.fgExtMapUShortToShort</span></li><li><span class="class-name">__builtin__.fgFlagsDict</span></li><li><span class="class-name">__builtin__.fgFont</span></li><li><span class="class-name">__builtin__.fgFontGateData</span></li><li><span class="class-name">__builtin__.fgFontHinting</span></li><li><span class="class-name">__builtin__.fgFontInfo</span></li><li><span class="class-name">__builtin__.fgFontInfoDict</span></li><li><span class="class-name">__builtin__.fgGaspRecord</span></li><li><span class="class-name">__builtin__.fgGaspRecords</span></li><li><span class="class-name">__builtin__.fgGlyph</span></li><li><span class="class-name">__builtin__.fgGlyphData</span></li><li><span class="class-name">__builtin__.fgGlyphDict</span></li><li><span class="class-name">__builtin__.fgGlyphIDsSet</span></li><li><span class="class-name">__builtin__.fgGlyphs</span></li><li><span class="class-name">__builtin__.fgGlyphsR</span></li><li><span class="class-name">__builtin__.fgGroup</span></li><li><span class="class-name">__builtin__.fgGroups</span></li><li><span class="class-name">__builtin__.fgGuide</span></li><li><span class="class-name">__builtin__.fgGuides</span></li><li><span class="class-name">__builtin__.fgHint</span></li><li><span class="class-name">__builtin__.fgHintCommand</span></li><li><span class="class-name">__builtin__.fgHintCommands</span></li><li><span class="class-name">__builtin__.fgHints</span></li><li><span class="class-name">__builtin__.fgIntDict</span></li><li><span class="class-name">__builtin__.fgKerning</span></li><li><span class="class-name">__builtin__.fgKerningGroups</span></li><li><span class="class-name">__builtin__.fgKerningObject</span></li><li><span class="class-name">__builtin__.fgKerningObjectPair</span></li><li><span class="class-name">__builtin__.fgLayer</span></li><li><span class="class-name">__builtin__.fgLayers</span></li><li><span class="class-name">__builtin__.fgLib</span></li><li><span class="class-name">__builtin__.fgMapBytes</span></li><li><span class="class-name">__builtin__.fgMaster</span></li><li><span class="class-name">__builtin__.fgMasters</span></li><li><span class="class-name">__builtin__.fgMatrix</span></li><li><span class="class-name">__builtin__.fgMaxP</span></li><li><span class="class-name">__builtin__.fgMetricsClass</span></li><li><span class="class-name">__builtin__.fgMetricsClasses</span></li><li><span class="class-name">__builtin__.fgNametable</span></li><li><span class="class-name">__builtin__.fgNode</span></li><li><span class="class-name">__builtin__.fgNodes</span></li><li><span class="class-name">__builtin__.fgOTLayout</span></li><li><span class="class-name">__builtin__.fgOpt_AutoMetrics</span></li><li><span class="class-name">__builtin__.fgOpt_EOTExport</span></li><li><span class="class-name">__builtin__.fgOpt_ExpandKerning</span></li><li><span class="class-name">__builtin__.fgOpt_Font</span></li><li><span class="class-name">__builtin__.fgOpt_KerningOptions</span></li><li><span class="class-name">__builtin__.fgOpt_OTExport</span></li><li><span class="class-name">__builtin__.fgOpt_OTExportFeaFile</span></li><li><span class="class-name">__builtin__.fgOpt_OTImport</span></li><li><span class="class-name">__builtin__.fgOpt_Optimize</span></li><li><span class="class-name">__builtin__.fgOpt_T1Autohint</span></li><li><span class="class-name">__builtin__.fgOpt_T1Export</span></li><li><span class="class-name">__builtin__.fgOpt_T1Import</span></li><li><span class="class-name">__builtin__.fgOpt_TTAutohint</span></li><li><span class="class-name">__builtin__.fgOpt_TTFAutohint</span></li><li><span class="class-name">__builtin__.fgOpt_UfoFontExport</span></li><li><span class="class-name">__builtin__.fgOpt_UfoFontImport</span></li><li><span class="class-name">__builtin__.fgOpt_VfbExport</span></li><li><span class="class-name">__builtin__.fgOpt_VfbImport</span></li><li><span class="class-name">__builtin__.fgOpt_WOFFExport</span></li><li><span class="class-name">__builtin__.fgOptions</span></li><li><span class="class-name">__builtin__.fgOtInfo</span></li><li><span class="class-name">__builtin__.fgOtValue</span></li><li><span class="class-name">__builtin__.fgPackages</span></li><li><span class="class-name">__builtin__.fgPen</span></li><li><span class="class-name">__builtin__.fgPoint</span></li><li><span class="class-name">__builtin__.fgPointU</span></li><li><span class="class-name">__builtin__.fgRect</span></li><li><span class="class-name">__builtin__.fgRendered</span></li><li><span class="class-name">__builtin__.fgShape</span></li><li><span class="class-name">__builtin__.fgShapes</span></li><li><span class="class-name">__builtin__.fgStem</span></li><li><span class="class-name">__builtin__.fgStems</span></li><li><span class="class-name">__builtin__.fgStringDict</span></li><li><span class="class-name">__builtin__.fgTTInterpreter</span></li><li><span class="class-name">__builtin__.fgTrueTypeData</span></li><li><span class="class-name">__builtin__.fgTrueTypePoint</span></li><li><span class="class-name">__builtin__.fgTrueTypePoints</span></li><li><span class="class-name">__builtin__.fgValuesDict</span></li><li><span class="class-name">__builtin__.fgVdmxRecord</span></li><li><span class="class-name">__builtin__.fgVdmxRecords</span></li><li><span class="class-name">__builtin__.fgVector</span></li><li><span class="class-name">__builtin__.fgVectorBool</span></li><li><span class="class-name">__builtin__.fgVectorChar</span></li><li><span class="class-name">__builtin__.fgVectorDouble</span></li><li><span class="class-name">__builtin__.fgVectorInt</span></li><li><span class="class-name">__builtin__.fgVectorPoint</span></li><li><span class="class-name">__builtin__.fgVectorUInt16</span></li><li><span class="class-name">__builtin__.fgVectorUInt32</span></li><li><span class="class-name">__builtin__.fgZone</span></li><li><span class="class-name">__builtin__.fgZones</span></li><li><span class="class-name">__builtin__.pyfgDataOwnerData</span></li></ul></li></ul><dl class="classes"><dt class="class"><h2><a name="fgAnchor" href="#fgAnchor">class <span class="class-name">fgAnchor</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Anchor representation

Constructors:
  fgAnchor() - default
  fgAnchor(fgAnchor) - copy
  fgAnchor((x, y), 'name') - create with position=(x, y) and name='name'
  fgAnchor(x, y, 'name') - create with position=(x, y) and name='name'</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgAnchor-__cmp__" href="#fgAnchor-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchor-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchor-__delattr__" href="#fgAnchor-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchor-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchor-__getattribute__" href="#fgAnchor-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchor-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchor-__init__" href="#fgAnchor-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchor-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchor-__repr__" href="#fgAnchor-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchor-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchor-__setattr__" href="#fgAnchor-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchor-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchor-__str__" href="#fgAnchor-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchor-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchor-copy" href="#fgAnchor-copy"><span class="function-name">copy</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgAnchor-copy">copy</a>(<a href="#fgAnchor">fgAnchor</a>) - copy data from another <a href="#fgAnchor">fgAnchor</a> <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchor-draw" href="#fgAnchor-draw"><span class="function-name">draw</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgAnchor-draw">draw</a>(penObject) - draw the <a href="./__builtin__.html#object">object</a> with a segment pen</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchor-drawPoints" href="#fgAnchor-drawPoints"><span class="function-name">drawPoints</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgAnchor-drawPoints">drawPoints</a>(penObject) - draw the <a href="./__builtin__.html#object">object</a> with a point pen</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchor-move" href="#fgAnchor-move"><span class="function-name">move</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgAnchor-move">move</a>(dx, dy) - move anchor by (dx, dy)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchor-round" href="#fgAnchor-round"><span class="function-name">round</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgAnchor-round">round</a>() - round anchor coordinates</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchor-scale" href="#fgAnchor-scale"><span class="function-name">scale</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgAnchor-scale">scale</a>((scale_x, scale_y)[, (center_x, center_y)]) - scale anchor by (scale_x, scale_y) with center=(center_x, center_y) or (0,0) if not defined</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchor-transform" href="#fgAnchor-transform"><span class="function-name">transform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgAnchor-transform">transform</a>(<a href="#fgMatrix">fgMatrix</a>) - transform anchor coordinates by matrix</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>data</dt>
<dd>

<pre class="doc" markdown="0">(uint) - data</pre>

</dd>
</dl>
<dl class="descriptor"><dt>index</dt>
<dd>

<pre class="doc" markdown="0">(int) - index of object for owner's base layer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>mark</dt>
<dd>

<pre class="doc" markdown="0">(uint) - mark</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">(string) - name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>position</dt>
<dd>

<pre class="doc" markdown="0">(fgPoint) - coordinates as fgPoint</pre>

</dd>
</dl>
<dl class="descriptor"><dt>x</dt>
<dd>

<pre class="doc" markdown="0">(int/double) - horizontal coordinate</pre>

</dd>
</dl>
<dl class="descriptor"><dt>y</dt>
<dd>

<pre class="doc" markdown="0">(int/double) - vertical coordinate</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgAnchor-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgAnchors" href="#fgAnchors">class <span class="class-name">fgAnchors</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgAnchor objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgAnchors-__add__" href="#fgAnchors-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchors-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchors-__cmp__" href="#fgAnchors-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchors-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchors-__delattr__" href="#fgAnchors-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchors-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchors-__delitem__" href="#fgAnchors-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchors-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchors-__delslice__" href="#fgAnchors-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchors-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchors-__getattribute__" href="#fgAnchors-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchors-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchors-__getitem__" href="#fgAnchors-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchors-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchors-__getslice__" href="#fgAnchors-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchors-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchors-__init__" href="#fgAnchors-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchors-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchors-__len__" href="#fgAnchors-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchors-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchors-__mul__" href="#fgAnchors-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchors-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchors-__repr__" href="#fgAnchors-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchors-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchors-__rmul__" href="#fgAnchors-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchors-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchors-__setattr__" href="#fgAnchors-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchors-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchors-__setitem__" href="#fgAnchors-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchors-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchors-__setslice__" href="#fgAnchors-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAnchors-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchors-append" href="#fgAnchors-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgAnchors-append">append</a>(item) or <a href="#fgAnchors-append">append</a>( list(item) ) - add items to the end of the list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchors-asList" href="#fgAnchors-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(items) <a href="#fgAnchors-asList">asList</a>() - get items as list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchors-clean" href="#fgAnchors-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgAnchors-clean">clean</a>() - delete all items</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchors-del" href="#fgAnchors-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgAnchors-del">del</a>(index) - delete item by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAnchors-insert" href="#fgAnchors-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgAnchors-insert">insert</a>(position, item) - insert item into list at specified position</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgAnchors-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgAxes" href="#fgAxes">class <span class="class-name">fgAxes</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Axes list representation

Constructors:
  fgAxes() - default
  fgAxes(fgAxes) - copy</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgAxes-__add__" href="#fgAxes-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxes-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxes-__cmp__" href="#fgAxes-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxes-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxes-__delattr__" href="#fgAxes-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxes-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxes-__delitem__" href="#fgAxes-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxes-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxes-__delslice__" href="#fgAxes-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxes-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxes-__getattribute__" href="#fgAxes-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxes-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxes-__getitem__" href="#fgAxes-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxes-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxes-__getslice__" href="#fgAxes-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxes-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxes-__init__" href="#fgAxes-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxes-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxes-__len__" href="#fgAxes-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxes-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxes-__mul__" href="#fgAxes-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxes-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxes-__repr__" href="#fgAxes-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxes-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxes-__rmul__" href="#fgAxes-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxes-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxes-__setattr__" href="#fgAxes-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxes-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxes-__setitem__" href="#fgAxes-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxes-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxes-__setslice__" href="#fgAxes-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxes-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxes-__str__" href="#fgAxes-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxes-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>masters</dt>
<dd>

<pre class="doc" markdown="0">(fgMasters) - masters</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgAxes-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgAxis" href="#fgAxis">class <span class="class-name">fgAxis</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Axis representation

Constructors:
  fgAxis('name') - create with name='name'</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgAxis-__cmp__" href="#fgAxis-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxis-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxis-__delattr__" href="#fgAxis-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxis-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxis-__getattribute__" href="#fgAxis-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxis-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxis-__init__" href="#fgAxis-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxis-__init__">__init__</a>(...) initializes x; see help(<a href="#fgAxis-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxis-__repr__" href="#fgAxis-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxis-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxis-__setattr__" href="#fgAxis-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxis-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgAxis-__str__" href="#fgAxis-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgAxis-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>blendMap</dt>
<dd>

<pre class="doc" markdown="0">(list(Point))</pre>

</dd>
</dl>
<dl class="descriptor"><dt>map</dt>
<dd>

<pre class="doc" markdown="0">(list(Point))</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">(string) - name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>shortName</dt>
<dd>

<pre class="doc" markdown="0">(string) - shortName</pre>

</dd>
</dl>
<dl class="descriptor"><dt>type</dt>
<dd>

<pre class="doc" markdown="0">(string) - type</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgAxis-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgBitmap" href="#fgBitmap">class <span class="class-name">fgBitmap</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Bitmap representation

Constructors:
  fgBitmap() - default
  fgBitmap(fgBitmap) - make orphan copy of another object
  fgBitmap(width, height, bitsPerPixel)
  fgBitmap(width, height, rowBytes, bitsPerPixel, bytesarray)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgBitmap-__add__" href="#fgBitmap-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__cmp__" href="#fgBitmap-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__delattr__" href="#fgBitmap-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__delitem__" href="#fgBitmap-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__delslice__" href="#fgBitmap-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__eq__" href="#fgBitmap-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__ge__" href="#fgBitmap-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__getattribute__" href="#fgBitmap-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__getitem__" href="#fgBitmap-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__getslice__" href="#fgBitmap-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__gt__" href="#fgBitmap-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__init__" href="#fgBitmap-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__le__" href="#fgBitmap-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__len__" href="#fgBitmap-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__lt__" href="#fgBitmap-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__mul__" href="#fgBitmap-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__ne__" href="#fgBitmap-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__repr__" href="#fgBitmap-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__rmul__" href="#fgBitmap-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__setattr__" href="#fgBitmap-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__setitem__" href="#fgBitmap-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__setslice__" href="#fgBitmap-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-__str__" href="#fgBitmap-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmap-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-asDict" href="#fgBitmap-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-asTuple" href="#fgBitmap-asTuple"><span class="function-name">asTuple</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as tuple</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-clear" href="#fgBitmap-clear"><span class="function-name">clear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">clear all data</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-clone" href="#fgBitmap-clone"><span class="function-name">clone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgBitmap-clone">clone</a>(<a href="#fgBitmap">fgBitmap</a> source) - make clone of source bitmap</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-copy" href="#fgBitmap-copy"><span class="function-name">copy</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgBitmap-copy">copy</a>(<a href="#fgBitmap">fgBitmap</a> source[, x, y, w, h]) - copy whole source bitmap or part of it with size (w, h) from pos (x, y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-copyData" href="#fgBitmap-copyData"><span class="function-name">copyData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgBitmap-copy">copy</a>(bytesarray) - assign new bitmap data</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-create" href="#fgBitmap-create"><span class="function-name">create</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgBitmap-create">create</a>(<same as constructor's arguments>') - allocate new bitmap data</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-downsample" href="#fgBitmap-downsample"><span class="function-name">downsample</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgBitmap-downsample">downsample</a>(<a href="#fgBitmap">fgBitmap</a>, int oversampling)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-empty" href="#fgBitmap-empty"><span class="function-name">empty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgBitmap-empty">empty</a>() - return true if no data assigned or bitmap size is 0</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-emptyRow" href="#fgBitmap-emptyRow"><span class="function-name">emptyRow</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgBitmap-emptyRow">emptyRow</a>(y, x0, x1) - return true if part of row y from x0 till x1 has no non-zero pixels</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-fill" href="#fgBitmap-fill"><span class="function-name">fill</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgBitmap-fill">fill</a>(<a href="#fgColor">fgColor</a> color) - fill entire bitmap by color</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-flipV" href="#fgBitmap-flipV"><span class="function-name">flipV</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">flip bitmap by vertical axis</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-getPixel" href="#fgBitmap-getPixel"><span class="function-name">getPixel</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgColor">fgColor</a> <a href="#fgBitmap-getPixel">getPixel</a>(x, y) - get color of pixel (x, y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-row" href="#fgBitmap-row"><span class="function-name">row</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmap-setPixel" href="#fgBitmap-setPixel"><span class="function-name">setPixel</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgBitmap-setPixel">setPixel</a>(x, y, <a href="#fgColor">fgColor</a> color) - set color for pixel (x, y)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>bpp</dt>
<dd>

<pre class="doc" markdown="0">bits per pixel</pre>

</dd>
</dl>
<dl class="descriptor"><dt>bytes</dt>
<dd>

<pre class="doc" markdown="0">bytes per row</pre>

</dd>
</dl>
<dl class="descriptor"><dt>data</dt>
<dd>

<pre class="doc" markdown="0">bitmap data</pre>

</dd>
</dl>
<dl class="descriptor"><dt>height</dt>
<dd>

<pre class="doc" markdown="0">bitmap height in pixels</pre>

</dd>
</dl>
<dl class="descriptor"><dt>size</dt>
<dd>

<pre class="doc" markdown="0">overall bytes count for bitmap storage</pre>

</dd>
</dl>
<dl class="descriptor"><dt>width</dt>
<dd>

<pre class="doc" markdown="0">bitmap width in pixels</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgBitmap-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgBitmaps" href="#fgBitmaps">class <span class="class-name">fgBitmaps</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of  fgBitmap objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgBitmaps-__add__" href="#fgBitmaps-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmaps-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmaps-__cmp__" href="#fgBitmaps-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmaps-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmaps-__delattr__" href="#fgBitmaps-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmaps-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmaps-__delitem__" href="#fgBitmaps-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmaps-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmaps-__delslice__" href="#fgBitmaps-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmaps-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmaps-__getattribute__" href="#fgBitmaps-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmaps-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmaps-__getitem__" href="#fgBitmaps-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmaps-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmaps-__getslice__" href="#fgBitmaps-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmaps-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmaps-__init__" href="#fgBitmaps-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmaps-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmaps-__len__" href="#fgBitmaps-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmaps-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmaps-__mul__" href="#fgBitmaps-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmaps-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmaps-__repr__" href="#fgBitmaps-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmaps-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmaps-__rmul__" href="#fgBitmaps-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmaps-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmaps-__setattr__" href="#fgBitmaps-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmaps-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmaps-__setitem__" href="#fgBitmaps-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmaps-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmaps-__setslice__" href="#fgBitmaps-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmaps-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmaps-append" href="#fgBitmaps-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmaps-asList" href="#fgBitmaps-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmaps-clean" href="#fgBitmaps-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmaps-del" href="#fgBitmaps-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmaps-insert" href="#fgBitmaps-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgBitmaps-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgBitmapsData" href="#fgBitmapsData">class <span class="class-name">fgBitmapsData</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">BitmapsData representation

Constructors:
  fgBitmapsData() - default
  fgBitmapsData(fgBitmapsData) - copy</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgBitmapsData-OK" href="#fgBitmapsData-OK"><span class="function-name">OK</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgBitmapsData-OK">OK</a>() - return true if status is gdsOK</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-__cmp__" href="#fgBitmapsData-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmapsData-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-__delattr__" href="#fgBitmapsData-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmapsData-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-__getattribute__" href="#fgBitmapsData-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmapsData-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-__init__" href="#fgBitmapsData-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmapsData-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-__repr__" href="#fgBitmapsData-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmapsData-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-__setattr__" href="#fgBitmapsData-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmapsData-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-__str__" href="#fgBitmapsData-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBitmapsData-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-bad" href="#fgBitmapsData-bad"><span class="function-name">bad</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgBitmapsData-bad">bad</a>() - return true if status isn't gdsOK</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-boundingBox" href="#fgBitmapsData-boundingBox"><span class="function-name">boundingBox</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect">fgRect</a> <a href="#fgBitmapsData-boundingBox">boundingBox</a>(<a href="#fgGlyphsR">fgGlyphsR</a>, <a href="#fgMatrix">fgMatrix</a>, bool prepareExport) - calculate bounding box</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-copy" href="#fgBitmapsData-copy"><span class="function-name">copy</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgBitmapsData">fgBitmapsData</a> <a href="#fgBitmapsData-copy">copy</a>() - create alone copy of data</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-countPictures" href="#fgBitmapsData-countPictures"><span class="function-name">countPictures</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgBitmapsData-countPictures">countPictures</a>() - return pictures count</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-getFontGateData" href="#fgBitmapsData-getFontGateData"><span class="function-name">getFontGateData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgBitmapsData-getFontGateData">getFontGateData</a>() always return 0</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-getType" href="#fgBitmapsData-getType"><span class="function-name">getType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#fgBitmapsData-getType">getType</a>() - return 'dtBitmaps'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-hasBody" href="#fgBitmapsData-hasBody"><span class="function-name">hasBody</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgBitmapsData-hasBody">hasBody</a>(bool prepareExport) - return true if non-empty body layer is present</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-hasColors" href="#fgBitmapsData-hasColors"><span class="function-name">hasColors</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgBitmapsData-hasColors">hasColors</a>() - return true if colors is present</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-hasHints" href="#fgBitmapsData-hasHints"><span class="function-name">hasHints</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgBitmapsData-hasHints">hasHints</a>() - return true if hints is present</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-hasPictures" href="#fgBitmapsData-hasPictures"><span class="function-name">hasPictures</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgBitmapsData-hasPictures">hasPictures</a>() - return true if pictures is present</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-modified" href="#fgBitmapsData-modified"><span class="function-name">modified</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgBitmapsData-modified">modified</a>() - always return false</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-setParent" href="#fgBitmapsData-setParent"><span class="function-name">setParent</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgBitmapsData-setParent">setParent</a>(<a href="#fgGlyph">fgGlyph</a>) - set parent glyph</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-status" href="#fgBitmapsData-status"><span class="function-name">status</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">'gdsOK'/'gdsInvalid' <a href="#fgBitmapsData-status">status</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-transform" href="#fgBitmapsData-transform"><span class="function-name">transform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgBitmapsData-transform">transform</a>(<a href="#fgMatrix">fgMatrix</a>) - transform data</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBitmapsData-updated" href="#fgBitmapsData-updated"><span class="function-name">updated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgBitmapsData-updated">updated</a>() - mark data as changed, reset internal caches</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>bitmaps</dt>
<dd>

<pre class="doc" markdown="0">(fgBitmaps) - list of fgRendered objects</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgBitmapsData-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgBrush" href="#fgBrush">class <span class="class-name">fgBrush</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Brush representation

Constructors:
  fgBrush() - default
  fgBrush(fgBrush) - copy
  fgBrush(fgColor) - solid brush with selected color and default size (1, 0)
  fgBrush(fgColor, fgPoint) - solid brush with selected color and size</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgBrush-__add__" href="#fgBrush-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__delattr__" href="#fgBrush-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__delitem__" href="#fgBrush-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__delslice__" href="#fgBrush-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__eq__" href="#fgBrush-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__ge__" href="#fgBrush-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__getattribute__" href="#fgBrush-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__getitem__" href="#fgBrush-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__getslice__" href="#fgBrush-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__gt__" href="#fgBrush-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__init__" href="#fgBrush-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__le__" href="#fgBrush-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__len__" href="#fgBrush-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__lt__" href="#fgBrush-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__mul__" href="#fgBrush-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__ne__" href="#fgBrush-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__repr__" href="#fgBrush-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__rmul__" href="#fgBrush-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__setattr__" href="#fgBrush-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__setitem__" href="#fgBrush-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__setslice__" href="#fgBrush-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-__str__" href="#fgBrush-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgBrush-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-asDict" href="#fgBrush-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-asTuple" href="#fgBrush-asTuple"><span class="function-name">asTuple</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as tuple</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-isBlack" href="#fgBrush-isBlack"><span class="function-name">isBlack</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgBrush-isBlack">isBlack</a>() - return true if brush is black</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-isTransparent" href="#fgBrush-isTransparent"><span class="function-name">isTransparent</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgBrush-isTransparent">isTransparent</a>() - return true if brush is transparent</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="fgBrush-black" href="#fgBrush-black"><span class="function-name">black</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgBrush">fgBrush</a> <a href="#fgBrush-black">black</a>() - get black solid brush</pre>

</dd></dl>
<dl class="function"><dt><a name="fgBrush-transparent" href="#fgBrush-transparent"><span class="function-name">transparent</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgBrush">fgBrush</a> <a href="#fgBrush-transparent">transparent</a>() - get transparent solid brush</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>kind</dt>
<dd>

<pre class="doc" markdown="0">('Empty'/'Solid'/'Gradient') brush type</pre>

</dd>
</dl>
<dl class="descriptor"><dt>size</dt>
<dd>

<pre class="doc" markdown="0">(fgPoint) brush size by x and y axis</pre>

</dd>
</dl>
<dl class="descriptor"><dt>solid</dt>
<dd>

<pre class="doc" markdown="0">(fgColor) brush color</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgBrush-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgCMaps" href="#fgCMaps">class <span class="class-name">fgCMaps</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgCmapRecord objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgCMaps-__add__" href="#fgCMaps-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCMaps-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCMaps-__cmp__" href="#fgCMaps-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCMaps-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCMaps-__delattr__" href="#fgCMaps-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCMaps-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCMaps-__delitem__" href="#fgCMaps-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCMaps-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCMaps-__delslice__" href="#fgCMaps-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCMaps-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCMaps-__getattribute__" href="#fgCMaps-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCMaps-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCMaps-__getitem__" href="#fgCMaps-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCMaps-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCMaps-__getslice__" href="#fgCMaps-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCMaps-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCMaps-__init__" href="#fgCMaps-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCMaps-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCMaps-__len__" href="#fgCMaps-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCMaps-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCMaps-__mul__" href="#fgCMaps-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCMaps-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCMaps-__repr__" href="#fgCMaps-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCMaps-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCMaps-__rmul__" href="#fgCMaps-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCMaps-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCMaps-__setattr__" href="#fgCMaps-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCMaps-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCMaps-__setitem__" href="#fgCMaps-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCMaps-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCMaps-__setslice__" href="#fgCMaps-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCMaps-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCMaps-append" href="#fgCMaps-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgCMaps-asList" href="#fgCMaps-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgCMaps-clean" href="#fgCMaps-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgCMaps-del" href="#fgCMaps-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgCMaps-insert" href="#fgCMaps-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgCMaps-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgCaret" href="#fgCaret">class <span class="class-name">fgCaret</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Caret representation

Constructors:
fgCaret() - default
fgCaret(fgCaret) - copy
fgCaret((fgOtValue/float/int, 'name')) - by coordinate and name</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgCaret-__cmp__" href="#fgCaret-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCaret-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCaret-__delattr__" href="#fgCaret-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCaret-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCaret-__getattribute__" href="#fgCaret-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCaret-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCaret-__init__" href="#fgCaret-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCaret-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCaret-__repr__" href="#fgCaret-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCaret-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCaret-__setattr__" href="#fgCaret-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCaret-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">(string) name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>v</dt>
<dd>

<pre class="doc" markdown="0">(fgOtValue) coordinate</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgCaret-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgCarets" href="#fgCarets">class <span class="class-name">fgCarets</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgCaret objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgCarets-__add__" href="#fgCarets-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCarets-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCarets-__cmp__" href="#fgCarets-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCarets-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCarets-__delattr__" href="#fgCarets-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCarets-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCarets-__delitem__" href="#fgCarets-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCarets-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCarets-__delslice__" href="#fgCarets-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCarets-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCarets-__getattribute__" href="#fgCarets-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCarets-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCarets-__getitem__" href="#fgCarets-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCarets-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCarets-__getslice__" href="#fgCarets-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCarets-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCarets-__init__" href="#fgCarets-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCarets-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCarets-__len__" href="#fgCarets-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCarets-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCarets-__mul__" href="#fgCarets-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCarets-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCarets-__repr__" href="#fgCarets-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCarets-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCarets-__rmul__" href="#fgCarets-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCarets-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCarets-__setattr__" href="#fgCarets-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCarets-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCarets-__setitem__" href="#fgCarets-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCarets-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCarets-__setslice__" href="#fgCarets-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCarets-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCarets-append" href="#fgCarets-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgCarets-append">append</a>(item) or <a href="#fgCarets-append">append</a>( list(item) ) - add items to the end of the list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCarets-asList" href="#fgCarets-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(items) <a href="#fgCarets-asList">asList</a>() - get items as list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCarets-clean" href="#fgCarets-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgCarets-clean">clean</a>() - delete all items</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCarets-del" href="#fgCarets-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgCarets-del">del</a>(index) - delete item by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCarets-insert" href="#fgCarets-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgCarets-insert">insert</a>(position, item) - insert item into list at specified position</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgCarets-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgCmapRecord" href="#fgCmapRecord">class <span class="class-name">fgCmapRecord</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgCmapRecord representation</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgCmapRecord-__add__" href="#fgCmapRecord-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCmapRecord-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCmapRecord-__delattr__" href="#fgCmapRecord-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCmapRecord-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCmapRecord-__delitem__" href="#fgCmapRecord-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCmapRecord-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCmapRecord-__delslice__" href="#fgCmapRecord-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCmapRecord-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCmapRecord-__getattribute__" href="#fgCmapRecord-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCmapRecord-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCmapRecord-__getitem__" href="#fgCmapRecord-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCmapRecord-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCmapRecord-__getslice__" href="#fgCmapRecord-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCmapRecord-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCmapRecord-__init__" href="#fgCmapRecord-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCmapRecord-__init__">__init__</a>(...) initializes x; see help(<a href="#fgCmapRecord-type">type</a>(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCmapRecord-__len__" href="#fgCmapRecord-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCmapRecord-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCmapRecord-__mul__" href="#fgCmapRecord-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCmapRecord-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCmapRecord-__repr__" href="#fgCmapRecord-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCmapRecord-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCmapRecord-__rmul__" href="#fgCmapRecord-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCmapRecord-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCmapRecord-__setattr__" href="#fgCmapRecord-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCmapRecord-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCmapRecord-__setitem__" href="#fgCmapRecord-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCmapRecord-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCmapRecord-__setslice__" href="#fgCmapRecord-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCmapRecord-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCmapRecord-__str__" href="#fgCmapRecord-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCmapRecord-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCmapRecord-asDict" href="#fgCmapRecord-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCmapRecord-asTuple" href="#fgCmapRecord-asTuple"><span class="function-name">asTuple</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as tuple</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>eid</dt>
</dl>
<dl class="descriptor"><dt>format</dt>
</dl>
<dl class="descriptor"><dt>lid</dt>
</dl>
<dl class="descriptor"><dt>nid</dt>
</dl>
<dl class="descriptor"><dt>pagename</dt>
</dl>
<dl class="descriptor"><dt>pid</dt>
</dl>
<dl class="descriptor"><dt>type</dt>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgCmapRecord-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgCoding" href="#fgCoding">class <span class="class-name">fgCoding</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Coding data representation

Constructors:
  fgCoding() - default
  fgCoding(fgCoding) - copy
  fgCoding( bool [unicodeRange], bool [codepageRange], fgCMaps cmaps,
         fgEncoding encoding, fgEncoding importedEncoding,
         'encDefault'/'encStandard'/'encCustom')</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgCoding-__cmp__" href="#fgCoding-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCoding-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCoding-__delattr__" href="#fgCoding-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCoding-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCoding-__getattribute__" href="#fgCoding-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCoding-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCoding-__init__" href="#fgCoding-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCoding-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCoding-__repr__" href="#fgCoding-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCoding-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCoding-__setattr__" href="#fgCoding-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCoding-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCoding-__str__" href="#fgCoding-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCoding-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>cmaps</dt>
<dd>

<pre class="doc" markdown="0">(fgCMaps)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>codepageRange</dt>
<dd>

<pre class="doc" markdown="0">(bool list)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>encoding</dt>
<dd>

<pre class="doc" markdown="0">(fgEncoding)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>encodingType</dt>
<dd>

<pre class="doc" markdown="0">('encDefault'/'encStandard'/'encCustom')</pre>

</dd>
</dl>
<dl class="descriptor"><dt>importedEncoding</dt>
<dd>

<pre class="doc" markdown="0">(fgEncoding)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>unicodeRange</dt>
<dd>

<pre class="doc" markdown="0">(bool list)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgCoding-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgColor" href="#fgColor">class <span class="class-name">fgColor</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Color representation

Constructors:  fgColor() - default
  fgColor(fgColor) - copy
  fgColor(float hueValue) - by hue value  fgColor(r, g, b) - by r, g, b, float values from 0 to 1.0
  fgColor(r, g, b, a) - by r, g, b, a float values from 0 to 1.0</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgColor-A" href="#fgColor-A"><span class="function-name">A</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgColor-A">A</a>() - get alpha value as int (0..255)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-B" href="#fgColor-B"><span class="function-name">B</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgColor-B">B</a>() - get blue value as int (0..255)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-G" href="#fgColor-G"><span class="function-name">G</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgColor-G">G</a>() - get green value as int (0..255)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-R" href="#fgColor-R"><span class="function-name">R</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgColor-B">B</a>() - get blue value as int (0..255)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__add__" href="#fgColor-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__delattr__" href="#fgColor-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__delitem__" href="#fgColor-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__delslice__" href="#fgColor-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__eq__" href="#fgColor-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__ge__" href="#fgColor-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__getattribute__" href="#fgColor-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__getitem__" href="#fgColor-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__getslice__" href="#fgColor-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__gt__" href="#fgColor-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__init__" href="#fgColor-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__le__" href="#fgColor-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__len__" href="#fgColor-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__lt__" href="#fgColor-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__mul__" href="#fgColor-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__ne__" href="#fgColor-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__repr__" href="#fgColor-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__rmul__" href="#fgColor-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__setattr__" href="#fgColor-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__setitem__" href="#fgColor-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__setslice__" href="#fgColor-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-__str__" href="#fgColor-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgColor-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-asDict" href="#fgColor-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-asTuple" href="#fgColor-asTuple"><span class="function-name">asTuple</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as tuple</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-getCMYK" href="#fgColor-getCMYK"><span class="function-name">getCMYK</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(c, m, y, k, a) <a href="#fgColor-getCMYK">getCMYK</a>([varK = 0.3]) - get color as CMYK+A components</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-gray" href="#fgColor-gray"><span class="function-name">gray</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgColor-gray">gray</a>() - get color as grayscale level</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-hue" href="#fgColor-hue"><span class="function-name">hue</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgColor-hue">hue</a>() - get hue value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-lab" href="#fgColor-lab"><span class="function-name">lab</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(l, a, b) <a href="#fgColor-lab">lab</a>() - get color as lab float values</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-lightness" href="#fgColor-lightness"><span class="function-name">lightness</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgColor-lightness">lightness</a>() - get lightness value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-saturation" href="#fgColor-saturation"><span class="function-name">saturation</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgColor-saturation">saturation</a>() - get saturation value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-set" href="#fgColor-set"><span class="function-name">set</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgColor-set">set</a>((r, g, b[, a])) - set color by tuple with rgb or rgba float values</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-setCMYK" href="#fgColor-setCMYK"><span class="function-name">setCMYK</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgColor-setCMYK">setCMYK</a>(c, m, y, k[, _a = 1.0]) = set color by CMYK[A] float values</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-setGray" href="#fgColor-setGray"><span class="function-name">setGray</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">segGray(float v) - set rgb components to v</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-setHue" href="#fgColor-setHue"><span class="function-name">setHue</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgColor-setHue">setHue</a>(h[, s=1.0[, l = 0.5]]) - set by hsl float values</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-xyz" href="#fgColor-xyz"><span class="function-name">xyz</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(x, y, z) <a href="#fgColor-xyz">xyz</a>() - get color as xyz float values</pre>

</dd></dl>

  <h4 class="head-static-methods">Static methods </h4><dl class="function"><dt><a name="fgColor-black" href="#fgColor-black"><span class="function-name">black</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgColor">fgColor</a> <a href="#fgColor-black">black</a>() - get black color</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-fromInt" href="#fgColor-fromInt"><span class="function-name">fromInt</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgColor">fgColor</a> <a href="#fgColor-fromInt">fromInt</a>(r, g, b[, a=255]) - get color by int rgb(a) values (0..255)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-fromLab" href="#fgColor-fromLab"><span class="function-name">fromLab</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgColor">fgColor</a> <a href="#fgColor-fromLab">fromLab</a>(l, a, b) - get color by float lab values</pre>

</dd></dl>
<dl class="function"><dt><a name="fgColor-transparent" href="#fgColor-transparent"><span class="function-name">transparent</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgColor">fgColor</a> <a href="#fgColor-transparent">transparent</a>() - get transparent color</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>a</dt>
<dd>

<pre class="doc" markdown="0">(float 0..1.0) - alpha channel</pre>

</dd>
</dl>
<dl class="descriptor"><dt>b</dt>
<dd>

<pre class="doc" markdown="0">(float 0..1.0) - blue channel</pre>

</dd>
</dl>
<dl class="descriptor"><dt>g</dt>
<dd>

<pre class="doc" markdown="0">(float 0..1.0) - green channel</pre>

</dd>
</dl>
<dl class="descriptor"><dt>r</dt>
<dd>

<pre class="doc" markdown="0">(float 0..1.0) - red channel</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgColor-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgComponent" href="#fgComponent">class <span class="class-name">fgComponent</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Component representation

Constructors:
  fgComponent() - default
  fgComponent(fgComponent) - copy
  fgComponent('name', fgMatrix) - by 'name' and transformation matrix fgMatrix</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgComponent-__cmp__" href="#fgComponent-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponent-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponent-__delattr__" href="#fgComponent-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponent-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponent-__getattribute__" href="#fgComponent-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponent-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponent-__init__" href="#fgComponent-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponent-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponent-__repr__" href="#fgComponent-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponent-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponent-__setattr__" href="#fgComponent-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponent-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponent-__str__" href="#fgComponent-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponent-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponent-draw" href="#fgComponent-draw"><span class="function-name">draw</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgComponent-draw">draw</a>(pen <a href="./__builtin__.html#object">object</a>) - draw the <a href="./__builtin__.html#object">object</a> with a segment pen</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponent-drawPoints" href="#fgComponent-drawPoints"><span class="function-name">drawPoints</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgComponent-drawPoints">drawPoints</a>(pen <a href="./__builtin__.html#object">object</a>) - draw the <a href="./__builtin__.html#object">object</a> with a point pen</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponent-move" href="#fgComponent-move"><span class="function-name">move</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgComponent-move">move</a>(dx, dy) - move by float dx, dy value</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>baseGlyph</dt>
<dd>

<pre class="doc" markdown="0">(string) name of base glyph</pre>

</dd>
</dl>
<dl class="descriptor"><dt>box</dt>
<dd>

<pre class="doc" markdown="0">(fgRect) - bounding box</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hasFullMatrix</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>index</dt>
<dd>

<pre class="doc" markdown="0">(int) component index in glyph's components list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>matrix</dt>
<dd>

<pre class="doc" markdown="0">(fgMatrix) - component transform matrix</pre>

</dd>
</dl>
<dl class="descriptor"><dt>offset</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>scale</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgComponent-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgComponents" href="#fgComponents">class <span class="class-name">fgComponents</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgComponent objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgComponents-__add__" href="#fgComponents-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponents-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-__cmp__" href="#fgComponents-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponents-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-__delattr__" href="#fgComponents-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponents-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-__delitem__" href="#fgComponents-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponents-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-__delslice__" href="#fgComponents-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponents-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-__getattribute__" href="#fgComponents-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponents-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-__getitem__" href="#fgComponents-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponents-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-__getslice__" href="#fgComponents-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponents-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-__init__" href="#fgComponents-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponents-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-__len__" href="#fgComponents-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponents-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-__mul__" href="#fgComponents-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponents-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-__repr__" href="#fgComponents-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponents-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-__rmul__" href="#fgComponents-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponents-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-__setattr__" href="#fgComponents-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponents-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-__setitem__" href="#fgComponents-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponents-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-__setslice__" href="#fgComponents-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgComponents-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-append" href="#fgComponents-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-asList" href="#fgComponents-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-clean" href="#fgComponents-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-decompose" href="#fgComponents-decompose"><span class="function-name">decompose</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-del" href="#fgComponents-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-getAsList" href="#fgComponents-getAsList"><span class="function-name">getAsList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgComponents-insert" href="#fgComponents-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgComponents-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgContour" href="#fgContour">class <span class="class-name">fgContour</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Contour representation

Constructors:
  fgContour() - default
  fgContour(fgContour) - copy</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgContour-__add__" href="#fgContour-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContour-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-__cmp__" href="#fgContour-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContour-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-__delattr__" href="#fgContour-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContour-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-__delitem__" href="#fgContour-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContour-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-__delslice__" href="#fgContour-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContour-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-__getattribute__" href="#fgContour-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContour-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-__getitem__" href="#fgContour-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContour-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-__getslice__" href="#fgContour-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContour-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-__init__" href="#fgContour-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContour-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-__len__" href="#fgContour-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContour-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-__mul__" href="#fgContour-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContour-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-__repr__" href="#fgContour-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContour-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-__rmul__" href="#fgContour-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContour-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-__setattr__" href="#fgContour-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContour-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-__setitem__" href="#fgContour-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContour-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-__setslice__" href="#fgContour-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContour-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-__str__" href="#fgContour-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContour-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-appendNode" href="#fgContour-appendNode"><span class="function-name">appendNode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgContour-appendNode">appendNode</a>(<a href="#fgNode">fgNode</a>) - add node to the end of the contour</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-area" href="#fgContour-area"><span class="function-name">area</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgContour-area">area</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-autoClose" href="#fgContour-autoClose"><span class="function-name">autoClose</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgContour-autoClose">autoClose</a>() - bool <a href="#fgContour-autoClose">autoClose</a>() - close contour, return true if changes was made</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-autoInterpolated" href="#fgContour-autoInterpolated"><span class="function-name">autoInterpolated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgContour-autoInterpolated">autoInterpolated</a>() - interpolate contour nodes, return true if changes was made</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-autoSmooth" href="#fgContour-autoSmooth"><span class="function-name">autoSmooth</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgContour-autoSmooth">autoSmooth</a>() - smooth contour nodes, return true if changes was made</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-boundingBox" href="#fgContour-boundingBox"><span class="function-name">boundingBox</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect">fgRect</a> <a href="#fgContour-boundingBox">boundingBox</a>(<a href="#fgMatrix">fgMatrix</a>[, bool prepareExport = false])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-clear" href="#fgContour-clear"><span class="function-name">clear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgContour-clear">clear</a>() - clear all nodes</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-contains" href="#fgContour-contains"><span class="function-name">contains</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool/Nothing <a href="#fgContour-contains">contains</a>(<a href="#fgPoint">fgPoint</a>[, bool winding = false])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-containsCurvePoint" href="#fgContour-containsCurvePoint"><span class="function-name">containsCurvePoint</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgContour-containsCurvePoint">containsCurvePoint</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-containsOffPoint" href="#fgContour-containsOffPoint"><span class="function-name">containsOffPoint</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgContour-containsOffPoint">containsOffPoint</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-countNodes" href="#fgContour-countNodes"><span class="function-name">countNodes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgContour-countNodes">countNodes</a>() - get count of nodes</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-deleteNode" href="#fgContour-deleteNode"><span class="function-name">deleteNode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgContour-deleteNode">deleteNode</a>(int nodeIndex) - delete node</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-draw" href="#fgContour-draw"><span class="function-name">draw</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgContour-draw">draw</a>(segmentPen) - draw the <a href="./__builtin__.html#object">object</a> with a segment pen</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-drawPoints" href="#fgContour-drawPoints"><span class="function-name">drawPoints</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgContour-drawPoints">drawPoints</a>(pointPen) - draw the <a href="./__builtin__.html#object">object</a> with a point pen</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-empty" href="#fgContour-empty"><span class="function-name">empty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgContour-empty">empty</a>() - return True if contour haven't any node</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-filterOnPoints" href="#fgContour-filterOnPoints"><span class="function-name">filterOnPoints</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgContour-filterOnPoints">filterOnPoints</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-getNode" href="#fgContour-getNode"><span class="function-name">getNode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgNode">fgNode</a> <a href="#fgContour-getNode">getNode</a>(int nodeIndex) - get node by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-getNodes" href="#fgContour-getNodes"><span class="function-name">getNodes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">[ <a href="#fgNode">fgNode</a> ] <a href="#fgContour-getNodes">getNodes</a>() - get list of <a href="#fgNode">fgNode</a> objects</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-getUFONodesList" href="#fgContour-getUFONodesList"><span class="function-name">getUFONodesList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">[ ((x, y), 'nodetype', bool smooth, 'name') ] <a href="#fgContour-getUFONodesList">getUFONodesList</a>() -get list of contour nodes as UFO-style tuples</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-insertNode" href="#fgContour-insertNode"><span class="function-name">insertNode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgContour-insertNode">insertNode</a>(<a href="#fgNode">fgNode</a>, int insertTo) - insert node into position insertTo</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-isCompatible" href="#fgContour-isCompatible"><span class="function-name">isCompatible</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgContour-isCompatible">isCompatible</a>(<a href="#fgContour">fgContour</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-length" href="#fgContour-length"><span class="function-name">length</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgContour-length">length</a>() - get count of nodes</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-midPoint" href="#fgContour-midPoint"><span class="function-name">midPoint</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgContour-midPoint">midPoint</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-reverse" href="#fgContour-reverse"><span class="function-name">reverse</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgContour-reverse">reverse</a>() - reverse order of contour nodes</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-toCurves" href="#fgContour-toCurves"><span class="function-name">toCurves</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgContour-toCurves">toCurves</a>([tolerance = 5.])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-toShortSplines" href="#fgContour-toShortSplines"><span class="function-name">toShortSplines</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgContour-toShortSplines">toShortSplines</a>([tolerance = 5.[, bool short_splines = true]])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContour-transform" href="#fgContour-transform"><span class="function-name">transform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgContour">fgContour</a> <a href="#fgContour-transform">transform</a>(<a href="#fgMatrix">fgMatrix</a>)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">(string) name of contour</pre>

</dd>
</dl>
<dl class="descriptor"><dt>nodes</dt>
<dd>

<pre class="doc" markdown="0">([fgNode]) contour nodes</pre>

</dd>
</dl>
<dl class="descriptor"><dt>open</dt>
<dd>

<pre class="doc" markdown="0">(bool) open flag</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgContour-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgContours" href="#fgContours">class <span class="class-name">fgContours</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgContour objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgContours-__add__" href="#fgContours-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContours-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContours-__cmp__" href="#fgContours-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContours-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContours-__delattr__" href="#fgContours-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContours-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContours-__delitem__" href="#fgContours-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContours-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContours-__delslice__" href="#fgContours-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContours-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContours-__getattribute__" href="#fgContours-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContours-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContours-__getitem__" href="#fgContours-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContours-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContours-__getslice__" href="#fgContours-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContours-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContours-__init__" href="#fgContours-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContours-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContours-__len__" href="#fgContours-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContours-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContours-__mul__" href="#fgContours-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContours-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContours-__repr__" href="#fgContours-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContours-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContours-__rmul__" href="#fgContours-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContours-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContours-__setattr__" href="#fgContours-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContours-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContours-__setitem__" href="#fgContours-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContours-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContours-__setslice__" href="#fgContours-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgContours-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgContours-append" href="#fgContours-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgContours-asList" href="#fgContours-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgContours-clean" href="#fgContours-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgContours-del" href="#fgContours-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgContours-insert" href="#fgContours-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgContours-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgCurve" href="#fgCurve">class <span class="class-name">fgCurve</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Curve representation

Constructors:
  fgCurve() - default
  fgCurve(fgCurve) - copy
  fgCurve( [4 x fgPoint] )
  fgCurve( (q0, q1, q2, q3) )
  fgCurve( fgPoint, fgPoint )
  fgCurve( fgPoint, fgPoint, fgPoint )
  fgCurve( fgPoint, fgPoint, fgPoint, fgPoint )
  fgCurve( fgCurve, float t0, float t1 )</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgCurve-__cmp__" href="#fgCurve-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCurve-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-__delattr__" href="#fgCurve-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCurve-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-__getattribute__" href="#fgCurve-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCurve-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-__init__" href="#fgCurve-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCurve-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-__repr__" href="#fgCurve-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCurve-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-__setattr__" href="#fgCurve-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCurve-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-__str__" href="#fgCurve-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCurve-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-asDict" href="#fgCurve-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-asTuple" href="#fgCurve-asTuple"><span class="function-name">asTuple</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as tuple</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-bbox" href="#fgCurve-bbox"><span class="function-name">bbox</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect">fgRect</a> <a href="#fgCurve-bbox">bbox</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-check" href="#fgCurve-check"><span class="function-name">check</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgCurve-check">check</a>(float flatness, float length, float w0, float w1)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-coefficients" href="#fgCurve-coefficients"><span class="function-name">coefficients</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(<a href="#fgPoint">fgPoint</a> a, <a href="#fgPoint">fgPoint</a> b, <a href="#fgPoint">fgPoint</a> c, <a href="#fgPoint">fgPoint</a> d) <a href="#fgCurve-coefficients">coefficients</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-curvature" href="#fgCurve-curvature"><span class="function-name">curvature</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgCurve-curvature">curvature</a>(float t)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-d1" href="#fgCurve-d1"><span class="function-name">d1</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgCurve-d1">d1</a>(float t)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-d2" href="#fgCurve-d2"><span class="function-name">d2</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgCurve-d2">d2</a>(float t)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-direction" href="#fgCurve-direction"><span class="function-name">direction</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgCurve-direction">direction</a>(float time)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-eseg" href="#fgCurve-eseg"><span class="function-name">eseg</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgCurve">fgCurve</a> <a href="#fgCurve-eseg">eseg</a>(float u)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-flat" href="#fgCurve-flat"><span class="function-name">flat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgCurve-flat">flat</a>(double parameter = almost_zero)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-getExtrema" href="#fgCurve-getExtrema"><span class="function-name">getExtrema</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgCurve-getExtrema">getExtrema</a>(bool h, [float] )</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-getInflection" href="#fgCurve-getInflection"><span class="function-name">getInflection</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgCurve-getInflection">getInflection</a>( [float] )</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-hasExtrema" href="#fgCurve-hasExtrema"><span class="function-name">hasExtrema</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgCurve-hasExtrema">hasExtrema</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-isConvex" href="#fgCurve-isConvex"><span class="function-name">isConvex</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgCurve-isConvex">isConvex</a>( [float area] )</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-len" href="#fgCurve-len"><span class="function-name">len</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgCurve-len">len</a>(int quality)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-maximumDeviation" href="#fgCurve-maximumDeviation"><span class="function-name">maximumDeviation</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgCurve-maximumDeviation">maximumDeviation</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-merge" href="#fgCurve-merge"><span class="function-name">merge</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgCurve-merge">merge</a>(<a href="#fgCurve">fgCurve</a> c)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-point" href="#fgCurve-point"><span class="function-name">point</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgCurve-point">point</a>(float time)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-quickLen" href="#fgCurve-quickLen"><span class="function-name">quickLen</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgCurve-quickLen">quickLen</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-render" href="#fgCurve-render"><span class="function-name">render</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgCurve-render">render</a>([<a href="#fgPoint">fgPoint</a>/<a href="#fgPointU">fgPointU</a>], int quality)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-seg" href="#fgCurve-seg"><span class="function-name">seg</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgCurve">fgCurve</a> <a href="#fgCurve-seg">seg</a>(float stime, float etime)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-sseg" href="#fgCurve-sseg"><span class="function-name">sseg</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgCurve">fgCurve</a> <a href="#fgCurve-sseg">sseg</a>(float u)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCurve-time" href="#fgCurve-time"><span class="function-name">time</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgCurve-time">time</a>(<a href="#fgPoint">fgPoint</a>[, int quality[, [float min_dist] ]])</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>q0</dt>
<dd>

<pre class="doc" markdown="0">(fgPoint)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>q1</dt>
<dd>

<pre class="doc" markdown="0">(fgPoint)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>q2</dt>
<dd>

<pre class="doc" markdown="0">(fgPoint)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>q3</dt>
<dd>

<pre class="doc" markdown="0">(fgPoint)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgCurve-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgCuspPoint" href="#fgCuspPoint">class <span class="class-name">fgCuspPoint</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">CuspPoint representation

Constructors:
  fgCuspPoint() - default
  fgCuspPoint(fgCuspPoint) - copy</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgCuspPoint-__cmp__" href="#fgCuspPoint-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoint-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoint-__delattr__" href="#fgCuspPoint-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoint-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoint-__getattribute__" href="#fgCuspPoint-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoint-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoint-__init__" href="#fgCuspPoint-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoint-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoint-__repr__" href="#fgCuspPoint-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoint-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoint-__setattr__" href="#fgCuspPoint-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoint-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoint-__str__" href="#fgCuspPoint-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoint-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoint-middleH" href="#fgCuspPoint-middleH"><span class="function-name">middleH</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgCuspPoint-middleH">middleH</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoint-middleV" href="#fgCuspPoint-middleV"><span class="function-name">middleV</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgCuspPoint-middleV">middleV</a>()</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>hlink0</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hlink1</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>index</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>p</dt>
<dd>

<pre class="doc" markdown="0">(fgPoint)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>vlink0</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>vlink1</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgCuspPoint-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgCuspPoints" href="#fgCuspPoints">class <span class="class-name">fgCuspPoints</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgCuspPoint objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgCuspPoints-__add__" href="#fgCuspPoints-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoints-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoints-__cmp__" href="#fgCuspPoints-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoints-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoints-__delattr__" href="#fgCuspPoints-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoints-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoints-__delitem__" href="#fgCuspPoints-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoints-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoints-__delslice__" href="#fgCuspPoints-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoints-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoints-__getattribute__" href="#fgCuspPoints-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoints-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoints-__getitem__" href="#fgCuspPoints-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoints-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoints-__getslice__" href="#fgCuspPoints-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoints-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoints-__init__" href="#fgCuspPoints-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoints-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoints-__len__" href="#fgCuspPoints-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoints-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoints-__mul__" href="#fgCuspPoints-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoints-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoints-__repr__" href="#fgCuspPoints-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoints-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoints-__rmul__" href="#fgCuspPoints-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoints-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoints-__setattr__" href="#fgCuspPoints-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoints-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoints-__setitem__" href="#fgCuspPoints-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoints-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoints-__setslice__" href="#fgCuspPoints-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgCuspPoints-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoints-append" href="#fgCuspPoints-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoints-asList" href="#fgCuspPoints-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoints-clean" href="#fgCuspPoints-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoints-del" href="#fgCuspPoints-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgCuspPoints-insert" href="#fgCuspPoints-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgCuspPoints-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgDesignPosition" href="#fgDesignPosition">class <span class="class-name">fgDesignPosition</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Anchor representation

Constructors:
  fgDesignPosition() - default
  fgDesignPosition(fgDesignPosition) - copy
  fgDesignPosition(axisCount) - parametric</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgDesignPosition-__cmp__" href="#fgDesignPosition-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDesignPosition-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDesignPosition-__delattr__" href="#fgDesignPosition-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDesignPosition-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDesignPosition-__getattribute__" href="#fgDesignPosition-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDesignPosition-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDesignPosition-__init__" href="#fgDesignPosition-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDesignPosition-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDesignPosition-__repr__" href="#fgDesignPosition-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDesignPosition-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDesignPosition-__setattr__" href="#fgDesignPosition-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDesignPosition-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDesignPosition-__str__" href="#fgDesignPosition-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDesignPosition-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>data</dt>
<dd>

<pre class="doc" markdown="0">(list(double)) - data</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgDesignPosition-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgDeviceRecord" href="#fgDeviceRecord">class <span class="class-name">fgDeviceRecord</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">DeviceRecord representation

Constructors:
  fgDeviceRecord() - default
  fgDeviceRecord(fgDeviceRecord) - copy
  fgDeviceRecord(tuple( int ppm, int correction) )
  fgDeviceRecord( int ppm, int correction )</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgDeviceRecord-__cmp__" href="#fgDeviceRecord-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecord-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecord-__delattr__" href="#fgDeviceRecord-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecord-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecord-__getattribute__" href="#fgDeviceRecord-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecord-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecord-__init__" href="#fgDeviceRecord-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecord-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecord-__repr__" href="#fgDeviceRecord-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecord-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecord-__setattr__" href="#fgDeviceRecord-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecord-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecord-__str__" href="#fgDeviceRecord-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecord-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>correction</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>ppm</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgDeviceRecord-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgDeviceRecords" href="#fgDeviceRecords">class <span class="class-name">fgDeviceRecords</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgDeviceRecord objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgDeviceRecords-__add__" href="#fgDeviceRecords-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecords-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecords-__cmp__" href="#fgDeviceRecords-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecords-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecords-__delattr__" href="#fgDeviceRecords-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecords-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecords-__delitem__" href="#fgDeviceRecords-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecords-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecords-__delslice__" href="#fgDeviceRecords-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecords-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecords-__getattribute__" href="#fgDeviceRecords-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecords-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecords-__getitem__" href="#fgDeviceRecords-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecords-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecords-__getslice__" href="#fgDeviceRecords-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecords-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecords-__init__" href="#fgDeviceRecords-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecords-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecords-__len__" href="#fgDeviceRecords-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecords-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecords-__mul__" href="#fgDeviceRecords-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecords-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecords-__repr__" href="#fgDeviceRecords-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecords-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecords-__rmul__" href="#fgDeviceRecords-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecords-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecords-__setattr__" href="#fgDeviceRecords-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecords-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecords-__setitem__" href="#fgDeviceRecords-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecords-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecords-__setslice__" href="#fgDeviceRecords-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgDeviceRecords-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecords-append" href="#fgDeviceRecords-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgDeviceRecords-append">append</a>(item) or <a href="#fgDeviceRecords-append">append</a>( list(item) ) - add items to the end of the list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecords-asList" href="#fgDeviceRecords-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(items) <a href="#fgDeviceRecords-asList">asList</a>() - get items as list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecords-clean" href="#fgDeviceRecords-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgDeviceRecords-clean">clean</a>() - delete all items</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecords-del" href="#fgDeviceRecords-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgDeviceRecords-del">del</a>(index) - delete item by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgDeviceRecords-insert" href="#fgDeviceRecords-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgDeviceRecords-insert">insert</a>(position, item) - insert item into list at specified position</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgDeviceRecords-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgExtMapIntTofgShape" href="#fgExtMapIntTofgShape">class <span class="class-name">fgExtMapIntTofgShape</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgExtMapIntTofgShape dictionary</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgExtMapIntTofgShape-__cmp__" href="#fgExtMapIntTofgShape-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapIntTofgShape-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapIntTofgShape-__delattr__" href="#fgExtMapIntTofgShape-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapIntTofgShape-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapIntTofgShape-__delitem__" href="#fgExtMapIntTofgShape-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapIntTofgShape-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapIntTofgShape-__getattribute__" href="#fgExtMapIntTofgShape-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapIntTofgShape-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapIntTofgShape-__getitem__" href="#fgExtMapIntTofgShape-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapIntTofgShape-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapIntTofgShape-__init__" href="#fgExtMapIntTofgShape-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapIntTofgShape-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapIntTofgShape-__len__" href="#fgExtMapIntTofgShape-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapIntTofgShape-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapIntTofgShape-__repr__" href="#fgExtMapIntTofgShape-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapIntTofgShape-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapIntTofgShape-__setattr__" href="#fgExtMapIntTofgShape-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapIntTofgShape-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapIntTofgShape-__setitem__" href="#fgExtMapIntTofgShape-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapIntTofgShape-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapIntTofgShape-asDict" href="#fgExtMapIntTofgShape-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapIntTofgShape-del" href="#fgExtMapIntTofgShape-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapIntTofgShape-has_key" href="#fgExtMapIntTofgShape-has_key"><span class="function-name">has_key</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapIntTofgShape-keys" href="#fgExtMapIntTofgShape-keys"><span class="function-name">keys</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapIntTofgShape-value" href="#fgExtMapIntTofgShape-value"><span class="function-name">value</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgExtMapIntTofgShape-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgExtMapUCharToUChar" href="#fgExtMapUCharToUChar">class <span class="class-name">fgExtMapUCharToUChar</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgExtMapUCharToUChar dictionary</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgExtMapUCharToUChar-__cmp__" href="#fgExtMapUCharToUChar-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUCharToUChar-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUCharToUChar-__delattr__" href="#fgExtMapUCharToUChar-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUCharToUChar-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUCharToUChar-__delitem__" href="#fgExtMapUCharToUChar-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUCharToUChar-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUCharToUChar-__getattribute__" href="#fgExtMapUCharToUChar-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUCharToUChar-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUCharToUChar-__getitem__" href="#fgExtMapUCharToUChar-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUCharToUChar-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUCharToUChar-__init__" href="#fgExtMapUCharToUChar-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUCharToUChar-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUCharToUChar-__len__" href="#fgExtMapUCharToUChar-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUCharToUChar-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUCharToUChar-__repr__" href="#fgExtMapUCharToUChar-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUCharToUChar-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUCharToUChar-__setattr__" href="#fgExtMapUCharToUChar-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUCharToUChar-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUCharToUChar-__setitem__" href="#fgExtMapUCharToUChar-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUCharToUChar-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUCharToUChar-asDict" href="#fgExtMapUCharToUChar-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUCharToUChar-del" href="#fgExtMapUCharToUChar-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUCharToUChar-has_key" href="#fgExtMapUCharToUChar-has_key"><span class="function-name">has_key</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUCharToUChar-keys" href="#fgExtMapUCharToUChar-keys"><span class="function-name">keys</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUCharToUChar-value" href="#fgExtMapUCharToUChar-value"><span class="function-name">value</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgExtMapUCharToUChar-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgExtMapUIntToString" href="#fgExtMapUIntToString">class <span class="class-name">fgExtMapUIntToString</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgExtMapUIntToString dictionary</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgExtMapUIntToString-__cmp__" href="#fgExtMapUIntToString-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUIntToString-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUIntToString-__delattr__" href="#fgExtMapUIntToString-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUIntToString-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUIntToString-__delitem__" href="#fgExtMapUIntToString-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUIntToString-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUIntToString-__getattribute__" href="#fgExtMapUIntToString-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUIntToString-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUIntToString-__getitem__" href="#fgExtMapUIntToString-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUIntToString-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUIntToString-__init__" href="#fgExtMapUIntToString-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUIntToString-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUIntToString-__len__" href="#fgExtMapUIntToString-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUIntToString-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUIntToString-__repr__" href="#fgExtMapUIntToString-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUIntToString-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUIntToString-__setattr__" href="#fgExtMapUIntToString-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUIntToString-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUIntToString-__setitem__" href="#fgExtMapUIntToString-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUIntToString-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUIntToString-asDict" href="#fgExtMapUIntToString-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUIntToString-del" href="#fgExtMapUIntToString-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUIntToString-has_key" href="#fgExtMapUIntToString-has_key"><span class="function-name">has_key</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUIntToString-keys" href="#fgExtMapUIntToString-keys"><span class="function-name">keys</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUIntToString-value" href="#fgExtMapUIntToString-value"><span class="function-name">value</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgExtMapUIntToString-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgExtMapUShortToShort" href="#fgExtMapUShortToShort">class <span class="class-name">fgExtMapUShortToShort</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgExtMapUShortToShort dictionary</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgExtMapUShortToShort-__cmp__" href="#fgExtMapUShortToShort-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUShortToShort-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUShortToShort-__delattr__" href="#fgExtMapUShortToShort-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUShortToShort-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUShortToShort-__delitem__" href="#fgExtMapUShortToShort-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUShortToShort-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUShortToShort-__getattribute__" href="#fgExtMapUShortToShort-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUShortToShort-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUShortToShort-__getitem__" href="#fgExtMapUShortToShort-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUShortToShort-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUShortToShort-__init__" href="#fgExtMapUShortToShort-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUShortToShort-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUShortToShort-__len__" href="#fgExtMapUShortToShort-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUShortToShort-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUShortToShort-__repr__" href="#fgExtMapUShortToShort-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUShortToShort-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUShortToShort-__setattr__" href="#fgExtMapUShortToShort-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUShortToShort-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUShortToShort-__setitem__" href="#fgExtMapUShortToShort-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgExtMapUShortToShort-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUShortToShort-asDict" href="#fgExtMapUShortToShort-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUShortToShort-del" href="#fgExtMapUShortToShort-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUShortToShort-has_key" href="#fgExtMapUShortToShort-has_key"><span class="function-name">has_key</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUShortToShort-keys" href="#fgExtMapUShortToShort-keys"><span class="function-name">keys</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgExtMapUShortToShort-value" href="#fgExtMapUShortToShort-value"><span class="function-name">value</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgExtMapUShortToShort-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgFlagsDict" href="#fgFlagsDict">class <span class="class-name">fgFlagsDict</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">bool flags diactionary</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgFlagsDict-__add__" href="#fgFlagsDict-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFlagsDict-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFlagsDict-__cmp__" href="#fgFlagsDict-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFlagsDict-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFlagsDict-__delattr__" href="#fgFlagsDict-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFlagsDict-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFlagsDict-__delitem__" href="#fgFlagsDict-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFlagsDict-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFlagsDict-__delslice__" href="#fgFlagsDict-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFlagsDict-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFlagsDict-__getattribute__" href="#fgFlagsDict-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFlagsDict-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFlagsDict-__getitem__" href="#fgFlagsDict-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFlagsDict-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFlagsDict-__getslice__" href="#fgFlagsDict-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFlagsDict-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFlagsDict-__init__" href="#fgFlagsDict-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFlagsDict-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFlagsDict-__len__" href="#fgFlagsDict-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFlagsDict-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFlagsDict-__mul__" href="#fgFlagsDict-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFlagsDict-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFlagsDict-__repr__" href="#fgFlagsDict-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFlagsDict-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFlagsDict-__rmul__" href="#fgFlagsDict-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFlagsDict-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFlagsDict-__setattr__" href="#fgFlagsDict-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFlagsDict-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFlagsDict-__setitem__" href="#fgFlagsDict-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFlagsDict-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFlagsDict-__setslice__" href="#fgFlagsDict-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFlagsDict-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFlagsDict-asDict" href="#fgFlagsDict-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgFlagsDict-del" href="#fgFlagsDict-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgFlagsDict-has_key" href="#fgFlagsDict-has_key"><span class="function-name">has_key</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgFlagsDict-keys" href="#fgFlagsDict-keys"><span class="function-name">keys</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgFlagsDict-value" href="#fgFlagsDict-value"><span class="function-name">value</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgFlagsDict-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgFont" href="#fgFont">class <span class="class-name">fgFont</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Font representation

Constructors:
  fgFont() - create new empty font
  fgFont('font_name') -  - create new empty font with name 'font_name'</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgFont-__add__" href="#fgFont-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFont-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-__cmp__" href="#fgFont-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFont-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-__delattr__" href="#fgFont-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFont-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-__delitem__" href="#fgFont-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFont-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-__delslice__" href="#fgFont-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFont-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-__getattribute__" href="#fgFont-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFont-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-__getitem__" href="#fgFont-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFont-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-__getslice__" href="#fgFont-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFont-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-__init__" href="#fgFont-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFont-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-__len__" href="#fgFont-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFont-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-__mul__" href="#fgFont-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFont-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-__repr__" href="#fgFont-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFont-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-__rmul__" href="#fgFont-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFont-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-__setattr__" href="#fgFont-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFont-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-__setitem__" href="#fgFont-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFont-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-__setslice__" href="#fgFont-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFont-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-addGlyph" href="#fgFont-addGlyph"><span class="function-name">addGlyph</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyph">fgGlyph</a> <a href="#fgFont-addGlyph">addGlyph</a>(<a href="#fgGlyph">fgGlyph</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-appendFeatures" href="#fgFont-appendFeatures"><span class="function-name">appendFeatures</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgFont-appendFeatures">appendFeatures</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-averageHeight" href="#fgFont-averageHeight"><span class="function-name">averageHeight</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgFont-averageHeight">averageHeight</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-averageWidth" href="#fgFont-averageWidth"><span class="function-name">averageWidth</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgFont-averageWidth">averageWidth</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-boundingBox" href="#fgFont-boundingBox"><span class="function-name">boundingBox</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect">fgRect</a> <a href="#fgFont-boundingBox">boundingBox</a>(<a href="#fgMatrix">fgMatrix</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-calculateSafeZones" href="#fgFont-calculateSafeZones"><span class="function-name">calculateSafeZones</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">?</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-checkMaps" href="#fgFont-checkMaps"><span class="function-name">checkMaps</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFont-checkMaps">checkMaps</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-clearGlyphs" href="#fgFont-clearGlyphs"><span class="function-name">clearGlyphs</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFont-clearGlyphs">clearGlyphs</a>() - remove all glyphs</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-clearMaps" href="#fgFont-clearMaps"><span class="function-name">clearMaps</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFont-clearMaps">clearMaps</a>() - force clear all font internal caches</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-copyFrom" href="#fgFont-copyFrom"><span class="function-name">copyFrom</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFont-copyFrom">copyFrom</a>(<a href="#fgFont">fgFont</a> sourceFont) - copy all data and glyphs from source font</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-createGlyph" href="#fgFont-createGlyph"><span class="function-name">createGlyph</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyph">fgGlyph</a> <a href="#fgFont-createGlyph">createGlyph</a>('name'[, int unicode[, bool clearExisting = false]])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-dropHintingTables" href="#fgFont-dropHintingTables"><span class="function-name">dropHintingTables</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFont-dropHintingTables">dropHintingTables</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-dropLayoutTables" href="#fgFont-dropLayoutTables"><span class="function-name">dropLayoutTables</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFont-dropLayoutTables">dropLayoutTables</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-fixOrdering" href="#fgFont-fixOrdering"><span class="function-name">fixOrdering</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgFont-fixOrdering">fixOrdering</a>(float upm[, sortMethod='sortUnicode']) - sort glyphs by selected method. Methods are 'sortNone', 'sortName', 'sortUnicode', 'sortIndex', 'sortIndexReverse'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-hasColors" href="#fgFont-hasColors"><span class="function-name">hasColors</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgFont-hasColors">hasColors</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-hasPictures" href="#fgFont-hasPictures"><span class="function-name">hasPictures</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgFont-hasPictures">hasPictures</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-has_key" href="#fgFont-has_key"><span class="function-name">has_key</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgFont-has_key">has_key</a>('name') - return true if font contains glyph with name 'name'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-items" href="#fgFont-items"><span class="function-name">items</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">[('name', <a href="#fgGlyph">fgGlyph</a>)] <a href="#fgFont-items">items</a>() - returns a list of font's ('name', <a href="#fgGlyph">fgGlyph</a>) tuple pairs</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-keys" href="#fgFont-keys"><span class="function-name">keys</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">['names'] <a href="#fgFont-keys">keys</a>() - return list of names of all glyphs in the font</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-killUnicode" href="#fgFont-killUnicode"><span class="function-name">killUnicode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFont-killUnicode">killUnicode</a>(unicode) - remove selected unicode from all glyph unicodes lists</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-rebuildMaps" href="#fgFont-rebuildMaps"><span class="function-name">rebuildMaps</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFont-rebuildMaps">rebuildMaps</a>() - force clear and rebuild all font internal caches</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-removeGlyph" href="#fgFont-removeGlyph"><span class="function-name">removeGlyph</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool/Nothing <a href="#fgFont-removeGlyph">removeGlyph</a>('name'/unicode) - remove glyph selected by 'name' or unicode (int)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-save" href="#fgFont-save"><span class="function-name">save</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFont-save">save</a>('path/filename'[, bool save_vfb=false]) - save font in UFO or VFB format</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-scale" href="#fgFont-scale"><span class="function-name">scale</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFont-scale">scale</a>(float) - scale font UPM</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-sortGlyphs" href="#fgFont-sortGlyphs"><span class="function-name">sortGlyphs</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFont-sortGlyphs">sortGlyphs</a>(sortMethod) - sort glyphs. sortMethod: 'sortNone'/'sortName'/'sortUnicode'/'sortIndex'/'sortIndexReverse'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-update" href="#fgFont-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFont-update">update</a>() - force rebuild font chaches and request font update</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFont-values" href="#fgFont-values"><span class="function-name">values</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">[<a href="#fgGlyph">fgGlyph</a>] <a href="#fgFont-values">values</a>() - returns list of font's <a href="#fgGlyph">fgGlyph</a></pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>axes</dt>
<dd>

<pre class="doc" markdown="0">(fgAxes) axes info</pre>

</dd>
</dl>
<dl class="descriptor"><dt>coding</dt>
<dd>

<pre class="doc" markdown="0">(fgCoding) encoding info</pre>

</dd>
</dl>
<dl class="descriptor"><dt>features</dt>
<dd>

<pre class="doc" markdown="0">(fgOTLayout) features data</pre>

</dd>
</dl>
<dl class="descriptor"><dt>glyphs</dt>
<dd>

<pre class="doc" markdown="0">([fgGlyph]) font glyphs list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>groups</dt>
<dd>

<pre class="doc" markdown="0">(fgGroups) glyph groups list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>guides</dt>
<dd>

<pre class="doc" markdown="0">(fgGuides) guides list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hinting</dt>
<dd>

<pre class="doc" markdown="0">(fgFontHinting) hinting info</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hints</dt>
<dd>

<pre class="doc" markdown="0">(fgHints) hints list for font 'Body' layer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">(long) package id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>info</dt>
<dd>

<pre class="doc" markdown="0">(fgFontInfo) font info data</pre>

</dd>
</dl>
<dl class="descriptor"><dt>kerning</dt>
<dd>

<pre class="doc" markdown="0">(fgKerning) kerning data</pre>

</dd>
</dl>
<dl class="descriptor"><dt>lib</dt>
<dd>

<pre class="doc" markdown="0">(fgLib) additional font data</pre>

</dd>
</dl>
<dl class="descriptor"><dt>master</dt>
<dd>

<pre class="doc" markdown="0">(fgLayer) font master layer</pre>

</dd>
</dl>
<dl class="descriptor"><dt>metricsClasses</dt>
<dd>

<pre class="doc" markdown="0">(fgMetricsClasses) list of metrics classes</pre>

</dd>
</dl>
<dl class="descriptor"><dt>path</dt>
<dd>

<pre class="doc" markdown="0">(string) path and font file name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>shapes</dt>
<dd>

<pre class="doc" markdown="0">(fgMapShapes) font shapes map</pre>

</dd>
</dl>
<dl class="descriptor"><dt>tables</dt>
<dd>

<pre class="doc" markdown="0">(fgMapBytes) raw OT tables data</pre>

</dd>
</dl>
<dl class="descriptor"><dt>translatedNames</dt>
<dd>

<pre class="doc" markdown="0">([tuples]) raw style->names.translated data</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgFont-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgFontGateData" href="#fgFontGateData">class <span class="class-name">fgFontGateData</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">FontGateData representation

Constructors:
  fgFontGateData() - default
  fgFontGateData(fgFontGateData) - copy</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgFontGateData-OK" href="#fgFontGateData-OK"><span class="function-name">OK</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgFontGateData-OK">OK</a>() - return true if status is gdsOK</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-__cmp__" href="#fgFontGateData-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontGateData-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-__delattr__" href="#fgFontGateData-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontGateData-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-__getattribute__" href="#fgFontGateData-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontGateData-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-__init__" href="#fgFontGateData-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontGateData-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-__repr__" href="#fgFontGateData-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontGateData-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-__setattr__" href="#fgFontGateData-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontGateData-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-__str__" href="#fgFontGateData-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontGateData-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-activeLayer" href="#fgFontGateData-activeLayer"><span class="function-name">activeLayer</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgLayer">fgLayer</a> <a href="#fgFontGateData-activeLayer">activeLayer</a>() - get active layer or Nothing if no layers exists</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-addContour" href="#fgFontGateData-addContour"><span class="function-name">addContour</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgContour">fgContour</a> <a href="#fgFontGateData-addContour">addContour</a>(<a href="#fgContour">fgContour</a>) - add contour into 'Body' layer</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-addShape" href="#fgFontGateData-addShape"><span class="function-name">addShape</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgShape">fgShape</a> <a href="#fgFontGateData-addShape">addShape</a>(<a href="#fgShape">fgShape</a>) - add shape into 'Body' layer</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-bad" href="#fgFontGateData-bad"><span class="function-name">bad</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgFontGateData-bad">bad</a>() - return true if status isn't gdsOK</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-bodyLayer" href="#fgFontGateData-bodyLayer"><span class="function-name">bodyLayer</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgLayer">fgLayer</a> <a href="#fgFontGateData-bodyLayer">bodyLayer</a>() - get layer named 'Body', any existing non-service layer if not found or Nothing if no layers exists</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-bodyLayerStrict" href="#fgFontGateData-bodyLayerStrict"><span class="function-name">bodyLayerStrict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgLayer">fgLayer</a> <a href="#fgFontGateData-bodyLayerStrict">bodyLayerStrict</a>() - get layer named 'Body'. if it's not present, create it on the fly</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-boundingBox" href="#fgFontGateData-boundingBox"><span class="function-name">boundingBox</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect">fgRect</a> <a href="#fgFontGateData-boundingBox">boundingBox</a>(<a href="#fgGlyphsR">fgGlyphsR</a>, <a href="#fgMatrix">fgMatrix</a>, bool prepareExport) - calculate bounding box</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-checkContours" href="#fgFontGateData-checkContours"><span class="function-name">checkContours</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFontGateData-checkContours">checkContours</a>() - ckeck for multi-segment contours and split it into one segment's contours</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-copy" href="#fgFontGateData-copy"><span class="function-name">copy</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFontGateData">fgFontGateData</a> <a href="#fgFontGateData-copy">copy</a>() - create alone copy of data</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-countNodesContours" href="#fgFontGateData-countNodesContours"><span class="function-name">countNodesContours</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(nodesCount, contoursCount) <a href="#fgFontGateData-countNodesContours">countNodesContours</a>() - calculate stats for 'Body' layer if it present, return (0,0) otherwise</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-countPictures" href="#fgFontGateData-countPictures"><span class="function-name">countPictures</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgFontGateData-countPictures">countPictures</a>() - return pictures count</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-countShapes" href="#fgFontGateData-countShapes"><span class="function-name">countShapes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgFontGateData-countShapes">countShapes</a>() - return shapes count</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-findLayer" href="#fgFontGateData-findLayer"><span class="function-name">findLayer</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgLayer">fgLayer</a> <a href="#fgFontGateData-findLayer">findLayer</a>('name') - get layer by name, return Nothing if no layer found</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-getFontGateData" href="#fgFontGateData-getFontGateData"><span class="function-name">getFontGateData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFontGateData">fgFontGateData</a> <a href="#fgFontGateData-getFontGateData">getFontGateData</a>() - return self</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-getType" href="#fgFontGateData-getType"><span class="function-name">getType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#fgFontGateData-getType">getType</a>() - return 'dtFontGate'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-hasBody" href="#fgFontGateData-hasBody"><span class="function-name">hasBody</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgFontGateData-hasBody">hasBody</a>(bool prepareExport) - return true if non-empty body layer is present</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-hasColors" href="#fgFontGateData-hasColors"><span class="function-name">hasColors</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgFontGateData-hasColors">hasColors</a>() - return true if colors is present</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-hasHints" href="#fgFontGateData-hasHints"><span class="function-name">hasHints</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgFontGateData-hasHints">hasHints</a>() - return true if hints is present</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-hasPictures" href="#fgFontGateData-hasPictures"><span class="function-name">hasPictures</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgFontGateData-hasPictures">hasPictures</a>() - return true if pictures is present</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-maskLayer" href="#fgFontGateData-maskLayer"><span class="function-name">maskLayer</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgLayer">fgLayer</a> <a href="#fgFontGateData-maskLayer">maskLayer</a>(bool createIfMissing)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-modified" href="#fgFontGateData-modified"><span class="function-name">modified</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgFontGateData-modified">modified</a>() - return true if data was changed</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-resetBbox" href="#fgFontGateData-resetBbox"><span class="function-name">resetBbox</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFontGateData-resetBbox">resetBbox</a>() - reset bbox cache</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-setParent" href="#fgFontGateData-setParent"><span class="function-name">setParent</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFontGateData-setParent">setParent</a>(<a href="#fgGlyph">fgGlyph</a>) - set parent glyph</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-status" href="#fgFontGateData-status"><span class="function-name">status</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">'gdsOK'/'gdsInvalid' <a href="#fgFontGateData-status">status</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-transform" href="#fgFontGateData-transform"><span class="function-name">transform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFontGateData-transform">transform</a>(<a href="#fgMatrix">fgMatrix</a>) - transform data</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontGateData-updated" href="#fgFontGateData-updated"><span class="function-name">updated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFontGateData-updated">updated</a>() - mark data as changed, reset internal caches</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>layers</dt>
<dd>

<pre class="doc" markdown="0">(fgLayers) layers list</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgFontGateData-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgFontHinting" href="#fgFontHinting">class <span class="class-name">fgFontHinting</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Font Hinting data representation

Constructors:
  fgFontHinting() - default
  fgFontHinting(fgFontHinting) - copy</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgFontHinting-__cmp__" href="#fgFontHinting-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontHinting-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontHinting-__delattr__" href="#fgFontHinting-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontHinting-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontHinting-__getattribute__" href="#fgFontHinting-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontHinting-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontHinting-__init__" href="#fgFontHinting-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontHinting-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontHinting-__repr__" href="#fgFontHinting-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontHinting-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontHinting-__setattr__" href="#fgFontHinting-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontHinting-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontHinting-__str__" href="#fgFontHinting-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontHinting-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontHinting-generateStemsProgram" href="#fgFontHinting-generateStemsProgram"><span class="function-name">generateStemsProgram</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFontHinting-generateStemsProgram">generateStemsProgram</a>(Position upm, bool keepValues)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontHinting-getBlueValues" href="#fgFontHinting-getBlueValues"><span class="function-name">getBlueValues</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list( float ) <a href="#fgFontHinting-getBlueValues">getBlueValues</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontHinting-getFamilyBlues" href="#fgFontHinting-getFamilyBlues"><span class="function-name">getFamilyBlues</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list( float ) <a href="#fgFontHinting-getFamilyBlues">getFamilyBlues</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontHinting-getFamilyOtherBlues" href="#fgFontHinting-getFamilyOtherBlues"><span class="function-name">getFamilyOtherBlues</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list( float ) <a href="#fgFontHinting-getFamilyBlues">getFamilyBlues</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontHinting-getOtherBlues" href="#fgFontHinting-getOtherBlues"><span class="function-name">getOtherBlues</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list( float ) <a href="#fgFontHinting-getOtherBlues">getOtherBlues</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontHinting-getZone" href="#fgFontHinting-getZone"><span class="function-name">getZone</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgZone">fgZone</a>/Nothing <a href="#fgFontHinting-getZone">getZone</a>(int index, bool top)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontHinting-getZonesCount" href="#fgFontHinting-getZonesCount"><span class="function-name">getZonesCount</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgFontHinting-getZonesCount">getZonesCount</a>(bool top)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>blueFuzz</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>blueScale</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>blueShift</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>codePPM</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>cvt</dt>
<dd>

<pre class="doc" markdown="0">( bytesarray )</pre>

</dd>
</dl>
<dl class="descriptor"><dt>dict</dt>
<dd>

<pre class="doc" markdown="0">( { string : int } )</pre>

</dd>
</dl>
<dl class="descriptor"><dt>dropoutPPM</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>familyZones</dt>
<dd>

<pre class="doc" markdown="0">(fgZones)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>flex</dt>
<dd>

<pre class="doc" markdown="0">(bool)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>forceBold</dt>
<dd>

<pre class="doc" markdown="0">(bool)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>forceBoldTreshold</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>fpgm</dt>
<dd>

<pre class="doc" markdown="0">( bytesarray )</pre>

</dd>
</dl>
<dl class="descriptor"><dt>gasp</dt>
<dd>

<pre class="doc" markdown="0">( [ fgGaspRecord ] )</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hdmx</dt>
<dd>

<pre class="doc" markdown="0">( [ int ] )</pre>

</dd>
</dl>
<dl class="descriptor"><dt>maxp</dt>
<dd>

<pre class="doc" markdown="0">( fgMaxP )</pre>

</dd>
</dl>
<dl class="descriptor"><dt>prep</dt>
<dd>

<pre class="doc" markdown="0">( bytesarray )</pre>

</dd>
</dl>
<dl class="descriptor"><dt>stemH</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>stemSnapLimit</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>stemV</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>stemsH</dt>
<dd>

<pre class="doc" markdown="0">(fgStems)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>stemsV</dt>
<dd>

<pre class="doc" markdown="0">(fgStems)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>t1stemsH</dt>
<dd>

<pre class="doc" markdown="0">(fgStems)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>t1stemsV</dt>
<dd>

<pre class="doc" markdown="0">(fgStems)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>t1zones</dt>
<dd>

<pre class="doc" markdown="0">(fgZones)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>vdmx</dt>
<dd>

<pre class="doc" markdown="0">( [ fgVdmxRecord ] )</pre>

</dd>
</dl>
<dl class="descriptor"><dt>zonePPM</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>zones</dt>
<dd>

<pre class="doc" markdown="0">(fgZones)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgFontHinting-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgFontInfo" href="#fgFontInfo">class <span class="class-name">fgFontInfo</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">FontInfo data

No constructors - it's the direct member of the fgFont object</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgFontInfo-__cmp__" href="#fgFontInfo-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontInfo-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontInfo-__delattr__" href="#fgFontInfo-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontInfo-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontInfo-__getattribute__" href="#fgFontInfo-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontInfo-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontInfo-__init__" href="#fgFontInfo-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontInfo-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontInfo-__repr__" href="#fgFontInfo-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontInfo-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontInfo-__setattr__" href="#fgFontInfo-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontInfo-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>ascender</dt>
<dd>

<pre class="doc" markdown="0">Ascender value</pre>

</dd>
</dl>
<dl class="descriptor"><dt>capHeight</dt>
<dd>

<pre class="doc" markdown="0">Cap height value</pre>

</dd>
</dl>
<dl class="descriptor"><dt>caretOffset</dt>
<dd>

<pre class="doc" markdown="0">Caret offset value</pre>

</dd>
</dl>
<dl class="descriptor"><dt>copyright</dt>
<dd>

<pre class="doc" markdown="0">Copyright statement</pre>

</dd>
</dl>
<dl class="descriptor"><dt>descender</dt>
<dd>

<pre class="doc" markdown="0">Descender value</pre>

</dd>
</dl>
<dl class="descriptor"><dt>dict</dt>
<dd>

<pre class="doc" markdown="0">Other font info tags and data</pre>

</dd>
</dl>
<dl class="descriptor"><dt>familyName</dt>
<dd>

<pre class="doc" markdown="0">Family name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>italicAngle</dt>
<dd>

<pre class="doc" markdown="0">Italic angle</pre>

</dd>
</dl>
<dl class="descriptor"><dt>macintoshFONDFamilyID</dt>
<dd>

<pre class="doc" markdown="0">Family ID number. Corresponds to the ffFamID in the Macintosh FOND resource</pre>

</dd>
</dl>
<dl class="descriptor"><dt>macintoshFONDName</dt>
<dd>

<pre class="doc" markdown="0">Font name for the Macintosh FOND resource</pre>

</dd>
</dl>
<dl class="descriptor"><dt>note</dt>
<dd>

<pre class="doc" markdown="0">Arbitrary note about the font</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeHeadCreated</dt>
<dd>

<pre class="doc" markdown="0">Creation date and time</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeHeadFlags</dt>
<dd>

<pre class="doc" markdown="0">A list of bit numbers indicating the flags. Corresponds to the OpenType head table flags field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeHeadFontDirectionHint</dt>
<dd>

<pre class="doc" markdown="0">Deprecated (Set to 2). Corresponds to the OpenType head table fontDirectionHint field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeHeadLowestRecPPEM</dt>
<dd>

<pre class="doc" markdown="0">Smallest readable size in pixels. Corresponds to the OpenType head table lowestRecPPEM field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeHeadModified</dt>
<dd>

<pre class="doc" markdown="0">Last modification date and time</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeHheaAscender</dt>
<dd>

<pre class="doc" markdown="0">Ascender value. Corresponds to the OpenType hhea table Ascender field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeHheaCaretOffset</dt>
<dd>

<pre class="doc" markdown="0">Caret offset value. Corresponds to the OpenType hhea table caretOffset field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeHheaCaretSlopeRise</dt>
<dd>

<pre class="doc" markdown="0">Caret slope rise value. Corresponds to the OpenType hhea table caretSlopeRise field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeHheaCaretSlopeRun</dt>
<dd>

<pre class="doc" markdown="0">Caret slope run value. Corresponds to the OpenType hhea table caretSlopeRun field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeHheaDescender</dt>
<dd>

<pre class="doc" markdown="0">Descender value. Corresponds to the OpenType hhea table Descender field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeHheaLineGap</dt>
<dd>

<pre class="doc" markdown="0">Line gap value. Corresponds to the OpenType hhea table LineGap field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameCompatibleFullName</dt>
<dd>

<pre class="doc" markdown="0">Compatible full name. Corresponds to the OpenType name table name ID 18</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameDescription</dt>
<dd>

<pre class="doc" markdown="0">Description of the font. Corresponds to the OpenType name table name ID 10</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameDesigner</dt>
<dd>

<pre class="doc" markdown="0">Designer name. Corresponds to the OpenType name table name ID 9</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameDesignerURL</dt>
<dd>

<pre class="doc" markdown="0">URL for the designer. Corresponds to the OpenType name table name ID 12</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameLicense</dt>
<dd>

<pre class="doc" markdown="0">License text. Corresponds to the OpenType name table name ID 13</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameLicenseURL</dt>
<dd>

<pre class="doc" markdown="0">URL for the license. Corresponds to the OpenType name table name ID 14</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameManufacturer</dt>
<dd>

<pre class="doc" markdown="0">Manufacturer name. Corresponds to the OpenType name table name ID 8</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameManufacturerURL</dt>
<dd>

<pre class="doc" markdown="0">Manufacturer URL. Corresponds to the OpenType name table name ID 11</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNamePreferredFamilyName</dt>
<dd>

<pre class="doc" markdown="0">Preferred family name. Corresponds to the OpenType name table name ID 16</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNamePreferredSubfamilyName</dt>
<dd>

<pre class="doc" markdown="0">Preferred subfamily name. Corresponds to the OpenType name table name ID 17</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameSampleText</dt>
<dd>

<pre class="doc" markdown="0">Sample text. Corresponds to the OpenType name table name ID 20</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameUniqueID</dt>
<dd>

<pre class="doc" markdown="0">Unique ID string. Corresponds to the OpenType name table name ID 3</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameVersion</dt>
<dd>

<pre class="doc" markdown="0">Version string. Corresponds to the OpenType name table name ID 5</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameWWSFamilyName</dt>
<dd>

<pre class="doc" markdown="0">WWS family name. Corresponds to the OpenType name table name ID 21</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeNameWWSSubfamilyName</dt>
<dd>

<pre class="doc" markdown="0">WWS Subfamily name. Corresponds to the OpenType name table name ID 22</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2CodePageRanges</dt>
<dd>

<pre class="doc" markdown="0">A list of bit numbers that are supported code page ranges in the font. Corresponds to the OpenType OS/2 table ulCodePageRange1 and ulCodePageRange2 fields</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2FamilyClass</dt>
<dd>

<pre class="doc" markdown="0">Two integers representing the IBM font class and font subclass of the font. The first number, representing the class ID, should be in the range 0-14. The second number, representing the subclass, should be in the range 0-15. Corresponds to the OpenType OS/2 table sFamilyClass field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2Panose</dt>
<dd>

<pre class="doc" markdown="0">The list should contain 10 integers that represent the setting for each category in the Panose specification. This corresponds to the OpenType OS/2 table Panose field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2Selection</dt>
<dd>

<pre class="doc" markdown="0">A list of bit numbers indicating the bits that should be set in fsSelection. Corresponds to the OpenType OS/2 table selection field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2StrikeoutPosition</dt>
<dd>

<pre class="doc" markdown="0">Strikeout position. Corresponds to the OpenType OS/2 table yStrikeoutPosition field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2StrikeoutSize</dt>
<dd>

<pre class="doc" markdown="0">Strikeout size. Corresponds to the OpenType OS/2 table yStrikeoutSize field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2SubscriptXOffset</dt>
<dd>

<pre class="doc" markdown="0">Subscript x offset. Corresponds to the OpenType OS/2 table ySubscriptXOffset field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2SubscriptXSize</dt>
<dd>

<pre class="doc" markdown="0">Subscript horizontal font size. Corresponds to the OpenType OS/2 table ySubscriptXSize field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2SubscriptYOffset</dt>
<dd>

<pre class="doc" markdown="0">Subscript y offset. Corresponds to the OpenType OS/2 table ySubscriptYOffset field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2SubscriptYSize</dt>
<dd>

<pre class="doc" markdown="0">Subscript vertical font size. Corresponds to the OpenType OS/2 table ySubscriptYSize field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2SuperscriptXOffset</dt>
<dd>

<pre class="doc" markdown="0">Superscript x offset. Corresponds to the OpenType OS/2 table ySuperscriptXOffset field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2SuperscriptXSize</dt>
<dd>

<pre class="doc" markdown="0">Superscript horizontal font size. Corresponds to the OpenType OS/2 table ySuperscriptXSize field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2SuperscriptYOffset</dt>
<dd>

<pre class="doc" markdown="0">Superscript y offset. Corresponds to the OpenType OS/2 table ySuperscriptYOffset field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2SuperscriptYSize</dt>
<dd>

<pre class="doc" markdown="0">Superscript vertical font size. Corresponds to the OpenType OS/2 table ySuperscriptYSize field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2Type</dt>
<dd>

<pre class="doc" markdown="0">A list of bit numbers indicating the embedding type. Corresponds to the OpenType OS/2 table fsType field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2TypoAscender</dt>
<dd>

<pre class="doc" markdown="0">Ascender value. Corresponds to the OpenType OS/2 table sTypoAscender field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2TypoDescender</dt>
<dd>

<pre class="doc" markdown="0">Descender value. Corresponds to the OpenType OS/2 table sTypoDescender field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2TypoLineGap</dt>
<dd>

<pre class="doc" markdown="0">Line gap value. Corresponds to the OpenType OS/2 table sTypoLineGap field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2UnicodeRanges</dt>
<dd>

<pre class="doc" markdown="0">A list of bit numbers that are supported Unicode ranges in the font. Corresponds to the OpenType OS/2 table ulUnicodeRange1, ulUnicodeRange2, ulUnicodeRange3 and ulUnicodeRange4 fields</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2VendorID</dt>
<dd>

<pre class="doc" markdown="0">Four character identifier for the creator of the font. Corresponds to the OpenType OS/2 table achVendID field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2WeightClass</dt>
<dd>

<pre class="doc" markdown="0">Weight class value. Must be a positive integer. Corresponds to the OpenType OS/2 table usWeightClass field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2WidthClass</dt>
<dd>

<pre class="doc" markdown="0">Width class value. Must be in the range 1-9. Corresponds to the OpenType OS/2 table usWidthClass field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2WinAscent</dt>
<dd>

<pre class="doc" markdown="0">Ascender value. Corresponds to the OpenType OS/2 table usWinAscent field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeOS2WinDescent</dt>
<dd>

<pre class="doc" markdown="0">Descender value. Corresponds to the OpenType OS/2 table usWinDescent field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeVheaCaretOffset</dt>
<dd>

<pre class="doc" markdown="0">Caret offset value. Corresponds to the OpenType vhea table caretOffset field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeVheaCaretSlopeRise</dt>
<dd>

<pre class="doc" markdown="0">Caret slope rise value. Corresponds to the OpenType vhea table caretSlopeRise field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeVheaCaretSlopeRun</dt>
<dd>

<pre class="doc" markdown="0">Caret slope run value. Corresponds to the OpenType vhea table caretSlopeRun field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeVheaVertTypoAscender</dt>
<dd>

<pre class="doc" markdown="0">Ascender value. Corresponds to the OpenType vhea table vertTypoAscender field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeVheaVertTypoDescender</dt>
<dd>

<pre class="doc" markdown="0">Descender value. Corresponds to the OpenType vhea table vertTypoDescender field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>openTypeVheaVertTypoLineGap</dt>
<dd>

<pre class="doc" markdown="0">Line gap value. Corresponds to the OpenType vhea table vertTypoLineGap field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptBlueFuzz</dt>
<dd>

<pre class="doc" markdown="0">BlueFuzz value. This corresponds to the Type 1/CFF BlueFuzz field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptBlueScale</dt>
<dd>

<pre class="doc" markdown="0">BlueScale value. This corresponds to the Type 1/CFF BlueScale field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptBlueShift</dt>
<dd>

<pre class="doc" markdown="0">BlueShift value. This corresponds to the Type 1/CFF BlueShift field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptBlueValues</dt>
<dd>

<pre class="doc" markdown="0">A list of up to 14 integers or floats specifying the values that should be in the Type 1/CFF BlueValues field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptDefaultCharacter</dt>
<dd>

<pre class="doc" markdown="0">The name of the glyph that should be used as the default character in PFM files</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptDefaultWidthX</dt>
<dd>

<pre class="doc" markdown="0">Default width for glyphs</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptFamilyBlues</dt>
<dd>

<pre class="doc" markdown="0">A list of up to 14 integers or floats specifying the values that should be in the Type 1/CFF FamilyBlues field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptFamilyOtherBlues</dt>
<dd>

<pre class="doc" markdown="0">A list of up to 10 integers or floats specifying the values that should be in the Type 1/CFF FamilyOtherBlues field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptFontName</dt>
<dd>

<pre class="doc" markdown="0">Name to be used for the FontName field in Type 1/CFF table</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptForceBold</dt>
<dd>

<pre class="doc" markdown="0">Indicates how the Type 1/CFF ForceBold field should be set</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptFullName</dt>
<dd>

<pre class="doc" markdown="0">Name to be used for the FullName field in Type 1/CFF table</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptIsFixedPitch</dt>
<dd>

<pre class="doc" markdown="0">Indicates if the font is monospaced. A compiler could calculate this automatically, but the designer may wish to override this setting. This corresponds to the Type 1/CFF isFixedPitched field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptNominalWidthX</dt>
<dd>

<pre class="doc" markdown="0">Nominal width for glyphs</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptOtherBlues</dt>
<dd>

<pre class="doc" markdown="0">A list of up to 10 integers or floats specifying the values that should be in the Type 1/CFF OtherBlues field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptSlantAngle</dt>
<dd>

<pre class="doc" markdown="0">Artificial slant angle</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptStemSnapH</dt>
<dd>

<pre class="doc" markdown="0">List of horizontal stems sorted in increasing order. Up to 12 integers or floats are possible. This corresponds to the Type 1/CFF StemSnapH field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptStemSnapV</dt>
<dd>

<pre class="doc" markdown="0">List of vertical stems sorted in increasing order. Up to 12 integers or floats are possible. This corresponds to the Type 1/CFF StemSnapV field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptUnderlinePosition</dt>
<dd>

<pre class="doc" markdown="0">Underline position value. Corresponds to the Type 1/CFF/post table UnderlinePosition field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptUnderlineThickness</dt>
<dd>

<pre class="doc" markdown="0">Underline thickness value. Corresponds to the Type 1/CFF/post table UnderlineThickness field</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptUniqueID</dt>
<dd>

<pre class="doc" markdown="0">A unique ID number as defined in the Type 1/CFF specification</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptWeightName</dt>
<dd>

<pre class="doc" markdown="0">A string indicating the overall weight of the font. This corresponds to the Type 1/CFF Weight field. It should be in sync with the openTypeOS2WeightClass value</pre>

</dd>
</dl>
<dl class="descriptor"><dt>postscriptWindowsCharacterSet</dt>
<dd>

<pre class="doc" markdown="0">The Windows character set. postscriptWindowsCharacterSet Options. Possible values are 1..20</pre>

</dd>
</dl>
<dl class="descriptor"><dt>styleMapFamilyName</dt>
<dd>

<pre class="doc" markdown="0">Family name used for bold, italic and bold italic style mapping</pre>

</dd>
</dl>
<dl class="descriptor"><dt>styleMapStyleName</dt>
<dd>

<pre class="doc" markdown="0">Styling link name. Perrmitted values are 'Regular', 'Italic', 'Bold', 'Bold Italic' (exactly as spelled). No other values are permitted</pre>

</dd>
</dl>
<dl class="descriptor"><dt>styleName</dt>
<dd>

<pre class="doc" markdown="0">Style name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>trademark</dt>
<dd>

<pre class="doc" markdown="0">Trademark statement</pre>

</dd>
</dl>
<dl class="descriptor"><dt>unitsPerEm</dt>
<dd>

<pre class="doc" markdown="0">Units per em</pre>

</dd>
</dl>
<dl class="descriptor"><dt>versionMajor</dt>
<dd>

<pre class="doc" markdown="0">Major version</pre>

</dd>
</dl>
<dl class="descriptor"><dt>versionMinor</dt>
<dd>

<pre class="doc" markdown="0">Minor version</pre>

</dd>
</dl>
<dl class="descriptor"><dt>xHeight</dt>
<dd>

<pre class="doc" markdown="0">x-height value</pre>

</dd>
</dl>
<dl class="descriptor"><dt>year</dt>
<dd>

<pre class="doc" markdown="0">The year the font was created</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgFontInfo-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgFontInfoDict" href="#fgFontInfoDict">class <span class="class-name">fgFontInfoDict</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Font info dictionaries</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgFontInfoDict-__cmp__" href="#fgFontInfoDict-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontInfoDict-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontInfoDict-__delattr__" href="#fgFontInfoDict-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontInfoDict-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontInfoDict-__getattribute__" href="#fgFontInfoDict-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontInfoDict-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontInfoDict-__init__" href="#fgFontInfoDict-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontInfoDict-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontInfoDict-__repr__" href="#fgFontInfoDict-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontInfoDict-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgFontInfoDict-__setattr__" href="#fgFontInfoDict-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgFontInfoDict-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>flags</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>hinting</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>metrics</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>names</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>values</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgFontInfoDict-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgGaspRecord" href="#fgGaspRecord">class <span class="class-name">fgGaspRecord</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">GaspRecord representation

Constructors:  fgGaspRecord() - default
  fgGaspRecord(fgGaspRecord) - copy
  fgGaspRecord(int rangeMaxPPEM, int rangeGaspBehavior) - parametric</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgGaspRecord-__cmp__" href="#fgGaspRecord-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecord-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecord-__delattr__" href="#fgGaspRecord-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecord-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecord-__getattribute__" href="#fgGaspRecord-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecord-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecord-__init__" href="#fgGaspRecord-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecord-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecord-__repr__" href="#fgGaspRecord-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecord-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecord-__setattr__" href="#fgGaspRecord-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecord-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecord-__str__" href="#fgGaspRecord-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecord-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecord-addSymmetry" href="#fgGaspRecord-addSymmetry"><span class="function-name">addSymmetry</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecord-rangeGaspBehavior" href="#fgGaspRecord-rangeGaspBehavior"><span class="function-name">rangeGaspBehavior</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecord-set" href="#fgGaspRecord-set"><span class="function-name">set</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>DOGRAY</dt>
<dd>

<pre class="doc" markdown="0">(bool)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>GRIDFIT</dt>
<dd>

<pre class="doc" markdown="0">(bool)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>SYMMETRIC_GRIDFIT</dt>
<dd>

<pre class="doc" markdown="0">(bool)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>SYMMETRIC_SMOOTHING</dt>
<dd>

<pre class="doc" markdown="0">(bool)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>rangeMaxpPPEM</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgGaspRecord-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgGaspRecords" href="#fgGaspRecords">class <span class="class-name">fgGaspRecords</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgGaspRecord objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgGaspRecords-__add__" href="#fgGaspRecords-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecords-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecords-__cmp__" href="#fgGaspRecords-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecords-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecords-__delattr__" href="#fgGaspRecords-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecords-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecords-__delitem__" href="#fgGaspRecords-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecords-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecords-__delslice__" href="#fgGaspRecords-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecords-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecords-__getattribute__" href="#fgGaspRecords-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecords-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecords-__getitem__" href="#fgGaspRecords-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecords-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecords-__getslice__" href="#fgGaspRecords-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecords-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecords-__init__" href="#fgGaspRecords-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecords-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecords-__len__" href="#fgGaspRecords-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecords-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecords-__mul__" href="#fgGaspRecords-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecords-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecords-__repr__" href="#fgGaspRecords-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecords-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecords-__rmul__" href="#fgGaspRecords-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecords-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecords-__setattr__" href="#fgGaspRecords-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecords-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecords-__setitem__" href="#fgGaspRecords-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecords-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecords-__setslice__" href="#fgGaspRecords-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGaspRecords-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecords-append" href="#fgGaspRecords-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGaspRecords-append">append</a>(item) or <a href="#fgGaspRecords-append">append</a>( list(item) ) - add items to the end of the list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecords-asList" href="#fgGaspRecords-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(items) <a href="#fgGaspRecords-asList">asList</a>() - get items as list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecords-clean" href="#fgGaspRecords-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGaspRecords-clean">clean</a>() - delete all items</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecords-del" href="#fgGaspRecords-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGaspRecords-del">del</a>(index) - delete item by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGaspRecords-insert" href="#fgGaspRecords-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGaspRecords-insert">insert</a>(position, item) - insert item into list at specified position</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgGaspRecords-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgGlyph" href="#fgGlyph">class <span class="class-name">fgGlyph</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Glyph representation

Constructors:
  fgGlyph() - default
  fgGlyph(fgGlyph) - copy
  fgGlyph('name') - create by name</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgGlyph-__add__" href="#fgGlyph-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyph-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__cmp__" href="#fgGlyph-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyph-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__delattr__" href="#fgGlyph-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyph-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__delitem__" href="#fgGlyph-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyph-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__delslice__" href="#fgGlyph-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyph-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__getattribute__" href="#fgGlyph-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyph-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__getitem__" href="#fgGlyph-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyph-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__getslice__" href="#fgGlyph-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyph-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__init__" href="#fgGlyph-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyph-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__len__" href="#fgGlyph-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyph-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__mul__" href="#fgGlyph-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyph-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__repr__" href="#fgGlyph-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyph-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__rmul__" href="#fgGlyph-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyph-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__setattr__" href="#fgGlyph-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyph-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__setitem__" href="#fgGlyph-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyph-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__setslice__" href="#fgGlyph-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyph-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-addUnicode" href="#fgGlyph-addUnicode"><span class="function-name">addUnicode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyph-addUnicode">addUnicode</a>(unicode) - add unicode to glyph</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-append" href="#fgGlyph-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyph-append">append</a>(<a href="#fgGlyph">fgGlyph</a>[, mtx=<a href="#fgMatrix">fgMatrix</a>()]) - append contours of source glyph to current glyph</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-clear" href="#fgGlyph-clear"><span class="function-name">clear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyph-clear">clear</a>(contours=true, components=true, anchors=true, guides=true, hints=true) - clear glyph's data</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-countPictures" href="#fgGlyph-countPictures"><span class="function-name">countPictures</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgGlyph-countPictures">countPictures</a>() - return count of glyph pictures</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-createContour" href="#fgGlyph-createContour"><span class="function-name">createContour</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgContour">fgContour</a> <a href="#fgGlyph-createContour">createContour</a>() - create new contour</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-createData" href="#fgGlyph-createData"><span class="function-name">createData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(variable type) <a href="#fgGlyph-createData">createData</a>(GlyphDataType) - create glyph data, specified by GlyphDataType. Possible values are 'dtNone', 'dtFontGate', 'dtTrueType', 'dtType1', 'dtCFF', 'dtProteus', 'dtBitmaps'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-decompose" href="#fgGlyph-decompose"><span class="function-name">decompose</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGlyph-decompose">decompose</a>() - decompose glyph</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-deleteContour" href="#fgGlyph-deleteContour"><span class="function-name">deleteContour</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyph-deleteContour">deleteContour</a>(contourIndex) - delete contour by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-draw" href="#fgGlyph-draw"><span class="function-name">draw</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyph-draw">draw</a>(penObject[, <a href="#fgMatrix">fgMatrix</a>]) - draw contour by penObject (like <a href="#fgPen">fgPen</a>) with transform matrix <a href="#fgMatrix">fgMatrix</a></pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-fgData" href="#fgGlyph-fgData"><span class="function-name">fgData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFontGateData">fgFontGateData</a>/Nothing <a href="#fgGlyph-fgData">fgData</a>() - get dtFontGate data if it's exist</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-fgDataCreate" href="#fgGlyph-fgDataCreate"><span class="function-name">fgDataCreate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFontGateData">fgFontGateData</a> <a href="#fgGlyph-fgDataCreate">fgDataCreate</a>() - get dtFontGate data (create new one if missing)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-fixComposites" href="#fgGlyph-fixComposites"><span class="function-name">fixComposites</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGlyph-fixComposites">fixComposites</a>(fixRotation=false)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-getData" href="#fgGlyph-getData"><span class="function-name">getData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(variable type) <a href="#fgGlyph-getData">getData</a>([GlyphDataType='dtFontGate']) - get glyph data, specified by GlyphDataType. Possible values are 'dtNone', 'dtFontGate', 'dtTrueType', 'dtType1', 'dtCFF', 'dtProteus', 'dtBitmaps'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-getPen" href="#fgGlyph-getPen"><span class="function-name">getPen</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPen">fgPen</a> <a href="#fgGlyph-getPen">getPen</a>() - create new pen <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-hasBody" href="#fgGlyph-hasBody"><span class="function-name">hasBody</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGlyph-hasBody">hasBody</a>() - return True if glyph has contours or picture</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-hasColors" href="#fgGlyph-hasColors"><span class="function-name">hasColors</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGlyph-hasColors">hasColors</a>() - return True if glyph has color pictures</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-hasData" href="#fgGlyph-hasData"><span class="function-name">hasData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGlyph-hasData">hasData</a>(GlyphDataType) - return True if glyph data, specified by GlyphDataType, is exist. Possible values are 'dtNone', 'dtFontGate', 'dtTrueType', 'dtType1', 'dtCFF', 'dtProteus', 'dtBitmaps'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-hasHints" href="#fgGlyph-hasHints"><span class="function-name">hasHints</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGlyph-hasHints">hasHints</a>() - return True if glyph has hints</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-hasPictures" href="#fgGlyph-hasPictures"><span class="function-name">hasPictures</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGlyph-hasPictures">hasPictures</a>() - return True if glyph has pictures</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-hasUnicode" href="#fgGlyph-hasUnicode"><span class="function-name">hasUnicode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGlyph-hasUnicode">hasUnicode</a>(unicode) - return True if glyph has specified unicode</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-keepData" href="#fgGlyph-keepData"><span class="function-name">keepData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGlyph-keepData">keepData</a>(GlyphDataType) - remove all glyph data, except one specified by GlyphDataType. Possible values are 'dtNone', 'dtFontGate', 'dtTrueType', 'dtType1', 'dtCFF', 'dtProteus', 'dtBitmaps'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-killData" href="#fgGlyph-killData"><span class="function-name">killData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGlyph-killData">killData</a>(GlyphDataType) - remove glyph data, specified by GlyphDataType. Possible values are 'dtNone', 'dtFontGate', 'dtTrueType', 'dtType1', 'dtCFF', 'dtProteus', 'dtBitmaps'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-killUnicode" href="#fgGlyph-killUnicode"><span class="function-name">killUnicode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyph-killUnicode">killUnicode</a>(unicode) - remove unicode from glyph</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-modified" href="#fgGlyph-modified"><span class="function-name">modified</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyph-modified">modified</a>(GlyphDataType) - inform that glyph data GlyphDataType has been modified. Possible values are 'dtNone', 'dtFontGate', 'dtTrueType', 'dtType1', 'dtCFF', 'dtProteus', 'dtBitmaps'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-move" href="#fgGlyph-move"><span class="function-name">move</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyph-move">move</a>(dx, dy) - move contour by (dx, dy)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-removeOverlap" href="#fgGlyph-removeOverlap"><span class="function-name">removeOverlap</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyph-removeOverlap">removeOverlap</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-setData" href="#fgGlyph-setData"><span class="function-name">setData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyph-setData">setData</a>(GlyphData-like <a href="./__builtin__.html#object">object</a>) - set glyph data</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-setUnicode" href="#fgGlyph-setUnicode"><span class="function-name">setUnicode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyph-setUnicode">setUnicode</a>(unicode) - assign unicode to glyph</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-transform" href="#fgGlyph-transform"><span class="function-name">transform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyph-transform">transform</a>(<a href="#fgMatrix">fgMatrix</a>) - transform glyph by <a href="#fgMatrix">fgMatrix</a> data</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-ttData" href="#fgGlyph-ttData"><span class="function-name">ttData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgTrueTypeData">fgTrueTypeData</a>/Nothing <a href="#fgGlyph-ttData">ttData</a>() - get dtTrueType data if it's exist</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-ttDataCreate" href="#fgGlyph-ttDataCreate"><span class="function-name">ttDataCreate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgTrueTypeData">fgTrueTypeData</a> <a href="#fgGlyph-ttDataCreate">ttDataCreate</a>() - get dtTrueType data (create new one if missing)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-update" href="#fgGlyph-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyph-update">update</a>()</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>activeLayer</dt>
<dd>

<pre class="doc" markdown="0">(fgLayer) active layer or Nothing if not found</pre>

</dd>
</dl>
<dl class="descriptor"><dt>anchors</dt>
<dd>

<pre class="doc" markdown="0">([ fgAnchor ]) anchor's list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>bodyLayer</dt>
<dd>

<pre class="doc" markdown="0">(fgLayer) layer 'Body' or Nothing if not found</pre>

</dd>
</dl>
<dl class="descriptor"><dt>bodyLayerStrict</dt>
<dd>

<pre class="doc" markdown="0">(fgLayer) layer 'Body' (create one if not found)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>box</dt>
<dd>

<pre class="doc" markdown="0">(fgRect) glyph bounding box (int values)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>carets</dt>
<dd>

<pre class="doc" markdown="0">([ fgCaret ]) caret's list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>components</dt>
<dd>

<pre class="doc" markdown="0">([ fgComponent ]) component's list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>dict</dt>
<dd>

<pre class="doc" markdown="0">(fgGlyphDict) glyph's data dictionary</pre>

</dd>
</dl>
<dl class="descriptor"><dt>fbox</dt>
<dd>

<pre class="doc" markdown="0">(fgRect) glyph bounding box (int/float values)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>guides</dt>
<dd>

<pre class="doc" markdown="0">([ fgGuide ]) guide's list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>height</dt>
<dd>

<pre class="doc" markdown="0">(float) advancedHeight</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hints</dt>
<dd>

<pre class="doc" markdown="0">([ fgHint ]) hint's list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">(long) glyph ID</pre>

</dd>
</dl>
<dl class="descriptor"><dt>image</dt>
<dd>

<pre class="doc" markdown="0">(fgBitmap) first glyph image</pre>

</dd>
</dl>
<dl class="descriptor"><dt>index</dt>
<dd>

<pre class="doc" markdown="0">(int) glyph index from font.tableIndex</pre>

</dd>
</dl>
<dl class="descriptor"><dt>kerningLeft</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>kerningRight</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>layer</dt>
<dd>

<pre class="doc" markdown="0">(fgLayer) working layer (if present) or None. Read-only attribute, use layerName='string'|index  to change</pre>

</dd>
</dl>
<dl class="descriptor"><dt>layerName</dt>
<dd>

<pre class="doc" markdown="0">(string) name of the working layer name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>layers</dt>
<dd>

<pre class="doc" markdown="0">([ fgLayer ]) layer's list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>leftMargin</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>lib</dt>
<dd>

<pre class="doc" markdown="0">(fgLib) additional glyph's data</pre>

</dd>
</dl>
<dl class="descriptor"><dt>mark</dt>
<dd>

<pre class="doc" markdown="0">(int) glyph's mark value</pre>

</dd>
</dl>
<dl class="descriptor"><dt>mask</dt>
<dd>

<pre class="doc" markdown="0">(fgGlyph/Nothing) mask glyph</pre>

</dd>
</dl>
<dl class="descriptor"><dt>metrics</dt>
<dd>

<pre class="doc" markdown="0">(fgPoint) advancedWidth and advancedHeight</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">(string) glyph name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>note</dt>
<dd>

<pre class="doc" markdown="0">(string)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>otInfo</dt>
<dd>

<pre class="doc" markdown="0">(fgOtInfo)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>parent</dt>
<dd>

<pre class="doc" markdown="0">(fgFont) parent font for glyph</pre>

</dd>
</dl>
<dl class="descriptor"><dt>rightMargin</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>unicode</dt>
<dd>

<pre class="doc" markdown="0">(int/Nothing) first glyph's unicode or Nothing if unicodes aren't defined</pre>

</dd>
</dl>
<dl class="descriptor"><dt>unicodes</dt>
<dd>

<pre class="doc" markdown="0">([ int ]) unicode's list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>vsb</dt>
<dd>

<pre class="doc" markdown="0">(float) vsb</pre>

</dd>
</dl>
<dl class="descriptor"><dt>width</dt>
<dd>

<pre class="doc" markdown="0">(float) advancedWidth</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgGlyph-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgGlyphData" href="#fgGlyphData">class <span class="class-name">fgGlyphData</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">GlyphData representation

Constructors:
  fgGlyphData() - default
  fgGlyphData(fgGlyphData) - copy</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgGlyphData-OK" href="#fgGlyphData-OK"><span class="function-name">OK</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGlyphData-OK">OK</a>() - return true if status is gdsOK</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-__cmp__" href="#fgGlyphData-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphData-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-__delattr__" href="#fgGlyphData-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphData-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-__getattribute__" href="#fgGlyphData-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphData-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-__init__" href="#fgGlyphData-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphData-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-__repr__" href="#fgGlyphData-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphData-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-__setattr__" href="#fgGlyphData-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphData-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-bad" href="#fgGlyphData-bad"><span class="function-name">bad</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGlyphData-bad">bad</a>() - return true if status isn't gdsOK</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-boundingBox" href="#fgGlyphData-boundingBox"><span class="function-name">boundingBox</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect">fgRect</a> <a href="#fgGlyphData-boundingBox">boundingBox</a>(<a href="#fgGlyphsR">fgGlyphsR</a>, <a href="#fgMatrix">fgMatrix</a>, bool prepareExport) - calculate bounding box</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-copy" href="#fgGlyphData-copy"><span class="function-name">copy</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyphData">fgGlyphData</a> <a href="#fgGlyphData-copy">copy</a>() - create alone copy of data</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-countPictures" href="#fgGlyphData-countPictures"><span class="function-name">countPictures</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgGlyphData-countPictures">countPictures</a>() - return pictures count</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-countShapes" href="#fgGlyphData-countShapes"><span class="function-name">countShapes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgGlyphData-countShapes">countShapes</a>() - return shapes count</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-getFontGateData" href="#fgGlyphData-getFontGateData"><span class="function-name">getFontGateData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFontGateData">fgFontGateData</a> <a href="#fgGlyphData-getFontGateData">getFontGateData</a>() - return Nothing</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-getType" href="#fgGlyphData-getType"><span class="function-name">getType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#fgGlyphData-getType">getType</a>() - return 'dtTrueType'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-hasBody" href="#fgGlyphData-hasBody"><span class="function-name">hasBody</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGlyphData-hasBody">hasBody</a>(bool prepareExport) - return true if non-empty body layer is present</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-hasColors" href="#fgGlyphData-hasColors"><span class="function-name">hasColors</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGlyphData-hasColors">hasColors</a>() - return true if colors is present</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-hasHints" href="#fgGlyphData-hasHints"><span class="function-name">hasHints</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGlyphData-hasHints">hasHints</a>() - return true if hints is present</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-hasPictures" href="#fgGlyphData-hasPictures"><span class="function-name">hasPictures</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGlyphData-hasPictures">hasPictures</a>() - return true if pictures is present</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-modified" href="#fgGlyphData-modified"><span class="function-name">modified</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGlyphData-modified">modified</a>() - return true if data was changed</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-setParent" href="#fgGlyphData-setParent"><span class="function-name">setParent</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyphData-setParent">setParent</a>(<a href="#fgGlyph">fgGlyph</a>) - set parent glyph</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-status" href="#fgGlyphData-status"><span class="function-name">status</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">'gdsOK'/'gdsInvalid' <a href="#fgGlyphData-status">status</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-transform" href="#fgGlyphData-transform"><span class="function-name">transform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyphData-transform">transform</a>(<a href="#fgMatrix">fgMatrix</a>) - transform data</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphData-updated" href="#fgGlyphData-updated"><span class="function-name">updated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyphData-updated">updated</a>() - mark data as changed, reset internal caches</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgGlyphData-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgGlyphDict" href="#fgGlyphDict">class <span class="class-name">fgGlyphDict</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Glyph dictionaries</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgGlyphDict-__cmp__" href="#fgGlyphDict-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphDict-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphDict-__delattr__" href="#fgGlyphDict-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphDict-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphDict-__getattribute__" href="#fgGlyphDict-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphDict-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphDict-__init__" href="#fgGlyphDict-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphDict-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphDict-__repr__" href="#fgGlyphDict-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphDict-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphDict-__setattr__" href="#fgGlyphDict-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphDict-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>flags</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>lib</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>tags</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>values</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgGlyphDict-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgGlyphIDsSet" href="#fgGlyphIDsSet">class <span class="class-name">fgGlyphIDsSet</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">GlyphIDs set

Constructors:
  fgGlyphIDsSet() - default
  fgGlyphIDsSet(fgGlyphIDsSet) - copy</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgGlyphIDsSet-__add__" href="#fgGlyphIDsSet-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphIDsSet-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphIDsSet-__cmp__" href="#fgGlyphIDsSet-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphIDsSet-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphIDsSet-__delattr__" href="#fgGlyphIDsSet-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphIDsSet-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphIDsSet-__delitem__" href="#fgGlyphIDsSet-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphIDsSet-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphIDsSet-__delslice__" href="#fgGlyphIDsSet-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphIDsSet-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphIDsSet-__getattribute__" href="#fgGlyphIDsSet-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphIDsSet-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphIDsSet-__getitem__" href="#fgGlyphIDsSet-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphIDsSet-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphIDsSet-__getslice__" href="#fgGlyphIDsSet-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphIDsSet-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphIDsSet-__init__" href="#fgGlyphIDsSet-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphIDsSet-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphIDsSet-__len__" href="#fgGlyphIDsSet-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphIDsSet-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphIDsSet-__mul__" href="#fgGlyphIDsSet-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphIDsSet-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphIDsSet-__repr__" href="#fgGlyphIDsSet-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphIDsSet-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphIDsSet-__rmul__" href="#fgGlyphIDsSet-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphIDsSet-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphIDsSet-__setattr__" href="#fgGlyphIDsSet-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphIDsSet-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphIDsSet-__setitem__" href="#fgGlyphIDsSet-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphIDsSet-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphIDsSet-__setslice__" href="#fgGlyphIDsSet-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphIDsSet-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphIDsSet-asList" href="#fgGlyphIDsSet-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">[ int ] <a href="#fgGlyphIDsSet-asList">asList</a>() - return set as list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphIDsSet-clean" href="#fgGlyphIDsSet-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyphIDsSet-clean">clean</a>() - remove all id's from set</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphIDsSet-contains" href="#fgGlyphIDsSet-contains"><span class="function-name">contains</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGlyphIDsSet-contains">contains</a>(int id) - return True if set contains id</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphIDsSet-del" href="#fgGlyphIDsSet-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyphIDsSet-del">del</a>(int id) - remove id from set</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgGlyphIDsSet-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgGlyphs" href="#fgGlyphs">class <span class="class-name">fgGlyphs</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgGlyph objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgGlyphs-__add__" href="#fgGlyphs-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphs-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphs-__cmp__" href="#fgGlyphs-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphs-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphs-__delattr__" href="#fgGlyphs-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphs-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphs-__delitem__" href="#fgGlyphs-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphs-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphs-__delslice__" href="#fgGlyphs-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphs-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphs-__getattribute__" href="#fgGlyphs-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphs-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphs-__getitem__" href="#fgGlyphs-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphs-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphs-__getslice__" href="#fgGlyphs-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphs-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphs-__init__" href="#fgGlyphs-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphs-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphs-__len__" href="#fgGlyphs-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphs-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphs-__mul__" href="#fgGlyphs-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphs-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphs-__repr__" href="#fgGlyphs-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphs-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphs-__rmul__" href="#fgGlyphs-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphs-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphs-__setattr__" href="#fgGlyphs-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphs-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphs-__setitem__" href="#fgGlyphs-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphs-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphs-__setslice__" href="#fgGlyphs-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphs-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphs-append" href="#fgGlyphs-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphs-asList" href="#fgGlyphs-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphs-clean" href="#fgGlyphs-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphs-del" href="#fgGlyphs-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphs-insert" href="#fgGlyphs-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgGlyphs-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgGlyphsR" href="#fgGlyphsR">class <span class="class-name">fgGlyphsR</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgGlyphsR representation

Constructors:
  fgGlyphsR() - default
  fgGlyphsR(fgGlyphsR) - copy
  fgGlyphsR(fgGlyphs) - create from list(fgGlyph)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgGlyphsR-__cmp__" href="#fgGlyphsR-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphsR-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphsR-__delattr__" href="#fgGlyphsR-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphsR-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphsR-__getattribute__" href="#fgGlyphsR-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphsR-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphsR-__init__" href="#fgGlyphsR-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphsR-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphsR-__repr__" href="#fgGlyphsR-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphsR-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphsR-__setattr__" href="#fgGlyphsR-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphsR-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphsR-__str__" href="#fgGlyphsR-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGlyphsR-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphsR-find" href="#fgGlyphsR-find"><span class="function-name">find</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyph">fgGlyph</a> <a href="#fgGlyphsR-find">find</a>(name|unicode)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphsR-getStats" href="#fgGlyphsR-getStats"><span class="function-name">getStats</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(totalGlyphs, avgNodesCount, avgContoursCount) <a href="#fgGlyphsR-getStats">getStats</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphsR-glyph" href="#fgGlyphsR-glyph"><span class="function-name">glyph</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyph">fgGlyph</a> <a href="#fgGlyphsR-glyph">glyph</a>(int index)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphsR-glyphByID" href="#fgGlyphsR-glyphByID"><span class="function-name">glyphByID</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyph">fgGlyph</a> <a href="#fgGlyphsR-glyphByID">glyphByID</a>(int ID)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphsR-index" href="#fgGlyphsR-index"><span class="function-name">index</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgGlyphsR-index">index</a>(<a href="#fgGlyph">fgGlyph</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphsR-indexByID" href="#fgGlyphsR-indexByID"><span class="function-name">indexByID</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgGlyphsR-index">index</a>(int ID)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyphsR-rebuildUnicodeMap" href="#fgGlyphsR-rebuildUnicodeMap"><span class="function-name">rebuildUnicodeMap</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGlyphsR-rebuildUnicodeMap">rebuildUnicodeMap</a>()</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgGlyphsR-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgGroup" href="#fgGroup">class <span class="class-name">fgGroup</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Kerning/Metrics group

Constructors:
  fgGroup() - default
  fgGroup(fgGroup) - copy
  fgGroup( tuple('name', list(ids), mode, 'mainglyphname') ) - parametric
           possible values for mode are 'FeaClassGroupMode', 'KernLeftGroupMode', 'KernRightGroupMode', 'KernBothSideGroupMode'</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgGroup-__add__" href="#fgGroup-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroup-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroup-__delattr__" href="#fgGroup-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroup-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroup-__delitem__" href="#fgGroup-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroup-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroup-__delslice__" href="#fgGroup-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroup-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroup-__getattribute__" href="#fgGroup-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroup-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroup-__getitem__" href="#fgGroup-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroup-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroup-__getslice__" href="#fgGroup-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroup-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroup-__init__" href="#fgGroup-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroup-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroup-__len__" href="#fgGroup-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroup-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroup-__mul__" href="#fgGroup-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroup-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroup-__repr__" href="#fgGroup-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroup-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroup-__rmul__" href="#fgGroup-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroup-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroup-__setattr__" href="#fgGroup-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroup-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroup-__setitem__" href="#fgGroup-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroup-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroup-__setslice__" href="#fgGroup-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroup-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroup-isBoth" href="#fgGroup-isBoth"><span class="function-name">isBoth</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">True if group mode is 'KernBothSideGroupMode'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroup-isFeaGroup" href="#fgGroup-isFeaGroup"><span class="function-name">isFeaGroup</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">True if group mode is 'FeaClassGroupMode'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroup-isLeft" href="#fgGroup-isLeft"><span class="function-name">isLeft</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">True if group mode is 'KernLeftGroupMode' or 'KernBothSideGroupMode'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroup-isRight" href="#fgGroup-isRight"><span class="function-name">isRight</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">True if group mode is 'KernRightGroupMode' or 'KernBothSideGroupMode'</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">(int) group id</pre>

</dd>
</dl>
<dl class="descriptor"><dt>mode</dt>
<dd>

<pre class="doc" markdown="0">('FeaClassGroupMode'/'KernLeftGroupMode'/'KernRightGroupMode'/'KernBothSideGroupMode') group mode</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">(string) group name</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgGroup-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgGroups" href="#fgGroups">class <span class="class-name">fgGroups</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Glyph groups list

Constructors:
  fgGroups() - default
  fgGroups(fgDataOwnerData) - parametric</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgGroups-__add__" href="#fgGroups-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroups-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-__delattr__" href="#fgGroups-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroups-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-__delitem__" href="#fgGroups-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroups-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-__delslice__" href="#fgGroups-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroups-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-__getattribute__" href="#fgGroups-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroups-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-__getitem__" href="#fgGroups-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroups-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-__getslice__" href="#fgGroups-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroups-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-__init__" href="#fgGroups-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroups-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-__len__" href="#fgGroups-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroups-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-__mul__" href="#fgGroups-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroups-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-__repr__" href="#fgGroups-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroups-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-__rmul__" href="#fgGroups-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroups-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-__setattr__" href="#fgGroups-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroups-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-__setitem__" href="#fgGroups-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroups-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-__setslice__" href="#fgGroups-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGroups-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-asDict" href="#fgGroups-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">dict('name' : <a href="#fgGroup">fgGroup</a>) <a href="#fgGroups-asDict">asDict</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-clear" href="#fgGroups-clear"><span class="function-name">clear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGroups-clear">clear</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-fromClassRecords" href="#fgGroups-fromClassRecords"><span class="function-name">fromClassRecords</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-fromDict" href="#fgGroups-fromDict"><span class="function-name">fromDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGroups-fromDict">fromDict</a>(dict('name':<a href="#fgGroup">fgGroup</a>))</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-get" href="#fgGroups-get"><span class="function-name">get</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGroup">fgGroup</a> <a href="#fgGroups-get">get</a>('name')</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-getAsClassRecords" href="#fgGroups-getAsClassRecords"><span class="function-name">getAsClassRecords</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-getCompiled" href="#fgGroups-getCompiled"><span class="function-name">getCompiled</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#fgGroups-getCompiled">getCompiled</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-has_key" href="#fgGroups-has_key"><span class="function-name">has_key</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGroups-has_key">has_key</a>('name')</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-items" href="#fgGroups-items"><span class="function-name">items</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(tuple('name', <a href="#fgGroup">fgGroup</a>)) <a href="#fgGroups-items">items</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-keys" href="#fgGroups-keys"><span class="function-name">keys</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(names of group) <a href="#fgGroups-keys">keys</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-remove" href="#fgGroups-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGroups-remove">remove</a>('name')</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-rename" href="#fgGroups-rename"><span class="function-name">rename</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgGroups-rename">rename</a>('old_name', 'new_name')</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGroups-values" href="#fgGroups-values"><span class="function-name">values</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#fgGroup">fgGroup</a>) <a href="#fgGroups-values">values</a>()</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgGroups-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgGuide" href="#fgGuide">class <span class="class-name">fgGuide</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Guide representation

Constructors:
  fgGuide() - default
  fgGuide(fgGuide) - copy
  fgGuide(float pos[, bool horizontal = false])
  fgGuide(fgPoint p0, fgPoint p1[, name=''[, horizonta=false[, color=fgColor]]])</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgGuide-__cmp__" href="#fgGuide-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuide-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuide-__delattr__" href="#fgGuide-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuide-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuide-__getattribute__" href="#fgGuide-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuide-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuide-__init__" href="#fgGuide-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuide-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuide-__repr__" href="#fgGuide-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuide-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuide-__setattr__" href="#fgGuide-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuide-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuide-copy" href="#fgGuide-copy"><span class="function-name">copy</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGuide">fgGuide</a> <a href="#fgGuide-copy">copy</a>() - copy <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>color</dt>
<dd>

<pre class="doc" markdown="0">(fgColor)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>horizontal</dt>
<dd>

<pre class="doc" markdown="0">True if guide is horizontal</pre>

</dd>
</dl>
<dl class="descriptor"><dt>index</dt>
<dd>

<pre class="doc" markdown="0">(int) index in owner guides list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">(string) guide name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>p0</dt>
<dd>

<pre class="doc" markdown="0">(fgPoint)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>p1</dt>
<dd>

<pre class="doc" markdown="0">(fgPoint)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>position</dt>
<dd>

<pre class="doc" markdown="0">(int) y value of p0, p1 if guide is horizontal, x value - if vertical, none if guide nor horizontal/vertical</pre>

</dd>
</dl>
<dl class="descriptor"><dt>vertical</dt>
<dd>

<pre class="doc" markdown="0">True if guide is vertical</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgGuide-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgGuides" href="#fgGuides">class <span class="class-name">fgGuides</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgGuide objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgGuides-__add__" href="#fgGuides-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuides-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-__cmp__" href="#fgGuides-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuides-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-__delattr__" href="#fgGuides-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuides-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-__delitem__" href="#fgGuides-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuides-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-__delslice__" href="#fgGuides-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuides-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-__getattribute__" href="#fgGuides-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuides-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-__getitem__" href="#fgGuides-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuides-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-__getslice__" href="#fgGuides-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuides-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-__init__" href="#fgGuides-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuides-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-__len__" href="#fgGuides-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuides-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-__mul__" href="#fgGuides-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuides-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-__repr__" href="#fgGuides-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuides-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-__rmul__" href="#fgGuides-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuides-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-__setattr__" href="#fgGuides-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuides-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-__setitem__" href="#fgGuides-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuides-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-__setslice__" href="#fgGuides-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgGuides-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-append" href="#fgGuides-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGuides-append">append</a>(item) or <a href="#fgGuides-append">append</a>( list(item) ) - add items to the end of the list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-asList" href="#fgGuides-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(items) <a href="#fgGuides-asList">asList</a>() - get items as list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-clean" href="#fgGuides-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGuides-clean">clean</a>() - delete all items</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-del" href="#fgGuides-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGuides-del">del</a>(index) - delete item by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-insert" href="#fgGuides-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGuides-insert">insert</a>(position, item) - insert item into list at specified position</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-remove" href="#fgGuides-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGuides-remove">remove</a>(<a href="#fgPoint">fgPoint</a> p0, <a href="#fgPoint">fgPoint</a> p1) - remove item if it's points are equal to specified</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGuides-removeHV" href="#fgGuides-removeHV"><span class="function-name">removeHV</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgGuides-removeHV">removeHV</a>(float position, bool horizontal)</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgGuides-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgHint" href="#fgHint">class <span class="class-name">fgHint</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Hint representation

Constructors:
  fgHint() - default
  fgHint(fgHint) - copy
  fgHint(name= , v= , dv= , point0= , point1= , p0= , p1= , points0= , points1= , horizontal= )</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgHint-__cmp__" href="#fgHint-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHint-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHint-__delattr__" href="#fgHint-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHint-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHint-__getattribute__" href="#fgHint-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHint-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHint-__init__" href="#fgHint-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHint-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHint-__repr__" href="#fgHint-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHint-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHint-__setattr__" href="#fgHint-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHint-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHint-copy" href="#fgHint-copy"><span class="function-name">copy</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>dv</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>horizontal</dt>
<dd>

<pre class="doc" markdown="0">(bool)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>index</dt>
<dd>

<pre class="doc" markdown="0">(int) index from owner's hints list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">(string) hint name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>p0</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>p1</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>point0</dt>
<dd>

<pre class="doc" markdown="0">(string)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>point1</dt>
<dd>

<pre class="doc" markdown="0">(string)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>points0</dt>
<dd>

<pre class="doc" markdown="0">([int])</pre>

</dd>
</dl>
<dl class="descriptor"><dt>points1</dt>
<dd>

<pre class="doc" markdown="0">([int])</pre>

</dd>
</dl>
<dl class="descriptor"><dt>v</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgHint-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgHintCommand" href="#fgHintCommand">class <span class="class-name">fgHintCommand</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">HintCommand representation

Constructors:
  fgHintCommand() - default
  fgHintCommand(fgHintCommand) - copy
  fgHintCommand(code, index) - parametric, possible values for code are 'none'/'hintH'/'hintV'/'replace'</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgHintCommand-__cmp__" href="#fgHintCommand-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommand-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommand-__delattr__" href="#fgHintCommand-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommand-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommand-__getattribute__" href="#fgHintCommand-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommand-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommand-__init__" href="#fgHintCommand-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommand-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommand-__repr__" href="#fgHintCommand-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommand-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommand-__setattr__" href="#fgHintCommand-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommand-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommand-__str__" href="#fgHintCommand-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommand-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>code</dt>
<dd>

<pre class="doc" markdown="0">('none'/'hintH'/'hintV'/'replace') code</pre>

</dd>
</dl>
<dl class="descriptor"><dt>index</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>pointName</dt>
<dd>

<pre class="doc" markdown="0">(string)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>subrIndex</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgHintCommand-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgHintCommands" href="#fgHintCommands">class <span class="class-name">fgHintCommands</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgHintCommand objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgHintCommands-__add__" href="#fgHintCommands-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommands-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommands-__cmp__" href="#fgHintCommands-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommands-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommands-__delattr__" href="#fgHintCommands-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommands-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommands-__delitem__" href="#fgHintCommands-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommands-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommands-__delslice__" href="#fgHintCommands-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommands-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommands-__getattribute__" href="#fgHintCommands-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommands-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommands-__getitem__" href="#fgHintCommands-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommands-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommands-__getslice__" href="#fgHintCommands-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommands-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommands-__init__" href="#fgHintCommands-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommands-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommands-__len__" href="#fgHintCommands-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommands-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommands-__mul__" href="#fgHintCommands-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommands-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommands-__repr__" href="#fgHintCommands-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommands-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommands-__rmul__" href="#fgHintCommands-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommands-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommands-__setattr__" href="#fgHintCommands-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommands-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommands-__setitem__" href="#fgHintCommands-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommands-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommands-__setslice__" href="#fgHintCommands-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHintCommands-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommands-append" href="#fgHintCommands-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommands-asList" href="#fgHintCommands-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommands-clean" href="#fgHintCommands-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommands-del" href="#fgHintCommands-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgHintCommands-insert" href="#fgHintCommands-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgHintCommands-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgHints" href="#fgHints">class <span class="class-name">fgHints</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgHint objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgHints-__add__" href="#fgHints-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHints-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-__cmp__" href="#fgHints-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHints-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-__delattr__" href="#fgHints-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHints-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-__delitem__" href="#fgHints-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHints-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-__delslice__" href="#fgHints-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHints-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-__getattribute__" href="#fgHints-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHints-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-__getitem__" href="#fgHints-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHints-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-__getslice__" href="#fgHints-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHints-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-__init__" href="#fgHints-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHints-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-__len__" href="#fgHints-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHints-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-__mul__" href="#fgHints-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHints-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-__repr__" href="#fgHints-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHints-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-__rmul__" href="#fgHints-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHints-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-__setattr__" href="#fgHints-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHints-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-__setitem__" href="#fgHints-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHints-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-__setslice__" href="#fgHints-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgHints-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-append" href="#fgHints-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgHints-append">append</a>(item) or <a href="#fgHints-append">append</a>( list(item) ) - add items to the end of the list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-asList" href="#fgHints-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(items) <a href="#fgHints-asList">asList</a>() - get items as list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-clean" href="#fgHints-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgHints-clean">clean</a>() - delete all items</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-del" href="#fgHints-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgHints-del">del</a>(index) - delete item by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-getAsDict" href="#fgHints-getAsDict"><span class="function-name">getAsDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">dict(items) <a href="#fgHints-getAsDict">getAsDict</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-getAsList" href="#fgHints-getAsList"><span class="function-name">getAsList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-insert" href="#fgHints-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgHints-insert">insert</a>(position, item) - insert item into list at specified position</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-removeByName" href="#fgHints-removeByName"><span class="function-name">removeByName</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgHints-removeByName">removeByName</a>('name')</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-removeHV" href="#fgHints-removeHV"><span class="function-name">removeHV</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgHints-removeHV">removeHV</a>(float v, float dv, bool horizontal)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-setFromDict" href="#fgHints-setFromDict"><span class="function-name">setFromDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgHints-setFromDict">setFromDict</a>(dict(items))</pre>

</dd></dl>
<dl class="function"><dt><a name="fgHints-setFromList" href="#fgHints-setFromList"><span class="function-name">setFromList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgHints-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgIntDict" href="#fgIntDict">class <span class="class-name">fgIntDict</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">int dictionary</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgIntDict-__add__" href="#fgIntDict-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgIntDict-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgIntDict-__cmp__" href="#fgIntDict-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgIntDict-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgIntDict-__delattr__" href="#fgIntDict-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgIntDict-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgIntDict-__delitem__" href="#fgIntDict-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgIntDict-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgIntDict-__delslice__" href="#fgIntDict-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgIntDict-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgIntDict-__getattribute__" href="#fgIntDict-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgIntDict-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgIntDict-__getitem__" href="#fgIntDict-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgIntDict-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgIntDict-__getslice__" href="#fgIntDict-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgIntDict-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgIntDict-__init__" href="#fgIntDict-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgIntDict-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgIntDict-__len__" href="#fgIntDict-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgIntDict-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgIntDict-__mul__" href="#fgIntDict-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgIntDict-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgIntDict-__repr__" href="#fgIntDict-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgIntDict-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgIntDict-__rmul__" href="#fgIntDict-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgIntDict-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgIntDict-__setattr__" href="#fgIntDict-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgIntDict-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgIntDict-__setitem__" href="#fgIntDict-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgIntDict-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgIntDict-__setslice__" href="#fgIntDict-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgIntDict-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgIntDict-asDict" href="#fgIntDict-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgIntDict-del" href="#fgIntDict-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgIntDict-has_key" href="#fgIntDict-has_key"><span class="function-name">has_key</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgIntDict-keys" href="#fgIntDict-keys"><span class="function-name">keys</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgIntDict-value" href="#fgIntDict-value"><span class="function-name">value</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgIntDict-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgKerning" href="#fgKerning">class <span class="class-name">fgKerning</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Kerning representation

Constructors:
  fgKerning(fgDataOwnerData)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgKerning-__add__" href="#fgKerning-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerning-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-__cmp__" href="#fgKerning-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerning-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-__delattr__" href="#fgKerning-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerning-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-__delitem__" href="#fgKerning-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerning-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-__delslice__" href="#fgKerning-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerning-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-__getattribute__" href="#fgKerning-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerning-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-__getitem__" href="#fgKerning-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerning-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-__getslice__" href="#fgKerning-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerning-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-__init__" href="#fgKerning-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerning-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-__len__" href="#fgKerning-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerning-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-__mul__" href="#fgKerning-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerning-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-__repr__" href="#fgKerning-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerning-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-__rmul__" href="#fgKerning-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerning-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-__setattr__" href="#fgKerning-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerning-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-__setitem__" href="#fgKerning-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerning-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-__setslice__" href="#fgKerning-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerning-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-addGroup" href="#fgKerning-addGroup"><span class="function-name">addGroup</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-asDict" href="#fgKerning-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">dict(<a href="#fgKerningObjectPair">fgKerningObjectPair</a> : float) <a href="#fgKerning-asDict">asDict</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-clear" href="#fgKerning-clear"><span class="function-name">clear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-deleteAllGroups" href="#fgKerning-deleteAllGroups"><span class="function-name">deleteAllGroups</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-deleteGroup" href="#fgKerning-deleteGroup"><span class="function-name">deleteGroup</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-get" href="#fgKerning-get"><span class="function-name">get</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgKerning-get">get</a>(<a href="#fgKerningObjectPair">fgKerningObjectPair</a> / tuple('name1', 'name2')) - get kerning value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-getPlainPairs" href="#fgKerning-getPlainPairs"><span class="function-name">getPlainPairs</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-getPlainPairsDict" href="#fgKerning-getPlainPairsDict"><span class="function-name">getPlainPairsDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-hasGroupKerning" href="#fgKerning-hasGroupKerning"><span class="function-name">hasGroupKerning</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-has_key" href="#fgKerning-has_key"><span class="function-name">has_key</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgKerning-has_key">has_key</a>(<a href="#fgKerningObjectPair">fgKerningObjectPair</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-items" href="#fgKerning-items"><span class="function-name">items</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list( tuple(<a href="#fgKerningObjectPair">fgKerningObjectPair</a>, float) ) <a href="#fgKerning-items">items</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-keys" href="#fgKerning-keys"><span class="function-name">keys</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(<a href="#fgKerningObjectPair">fgKerningObjectPair</a>) <a href="#fgKerning-keys">keys</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-remove" href="#fgKerning-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-renameGroup" href="#fgKerning-renameGroup"><span class="function-name">renameGroup</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-scale" href="#fgKerning-scale"><span class="function-name">scale</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-setPlainPairs" href="#fgKerning-setPlainPairs"><span class="function-name">setPlainPairs</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerning-values" href="#fgKerning-values"><span class="function-name">values</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list( float ) <a href="#fgKerning-values">values</a>()</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>groups</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgKerning-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgKerningGroups" href="#fgKerningGroups">class <span class="class-name">fgKerningGroups</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Dictionary of kerning groups

Constructors:
  fgKerningGroups(fgDataOwnerData) - default</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgKerningGroups-__cmp__" href="#fgKerningGroups-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningGroups-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningGroups-__delattr__" href="#fgKerningGroups-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningGroups-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningGroups-__delitem__" href="#fgKerningGroups-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningGroups-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningGroups-__getattribute__" href="#fgKerningGroups-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningGroups-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningGroups-__getitem__" href="#fgKerningGroups-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningGroups-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningGroups-__init__" href="#fgKerningGroups-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningGroups-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningGroups-__len__" href="#fgKerningGroups-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningGroups-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningGroups-__repr__" href="#fgKerningGroups-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningGroups-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningGroups-__setattr__" href="#fgKerningGroups-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningGroups-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningGroups-__setitem__" href="#fgKerningGroups-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningGroups-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningGroups-asDict" href="#fgKerningGroups-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningGroups-clear" href="#fgKerningGroups-clear"><span class="function-name">clear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgKerningGroups-clear">clear</a>() - delete all items</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningGroups-has_key" href="#fgKerningGroups-has_key"><span class="function-name">has_key</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgKerningGroups-has_key">has_key</a>('groupName')</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningGroups-items" href="#fgKerningGroups-items"><span class="function-name">items</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list( tuple('groupName', tuple( list('glyphName'), mode ) ) <a href="#fgKerningGroups-items">items</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningGroups-keys" href="#fgKerningGroups-keys"><span class="function-name">keys</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list('groupName') <a href="#fgKerningGroups-keys">keys</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningGroups-remove" href="#fgKerningGroups-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgKerningGroups-remove">remove</a>('groupName'[, deleteDependentKerningPairs = false])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningGroups-rename" href="#fgKerningGroups-rename"><span class="function-name">rename</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool/Nothing <a href="#fgKerningGroups-rename">rename</a>('oldGroupName', 'newGroupName')</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningGroups-values" href="#fgKerningGroups-values"><span class="function-name">values</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list ( tuple( list('glyphName'), mode ) ) <a href="#fgKerningGroups-values">values</a>()</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgKerningGroups-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgKerningObject" href="#fgKerningObject">class <span class="class-name">fgKerningObject</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">KerningObject representation

Constructors:  fgKerningObject() - default
  fgKerningObject(fgKerningObject) - copy
  fgKerningObject('name', mode) - mode must be one of 'glyphMode'/'groupMode'</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgKerningObject-__add__" href="#fgKerningObject-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObject-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObject-__cmp__" href="#fgKerningObject-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObject-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObject-__delattr__" href="#fgKerningObject-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObject-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObject-__delitem__" href="#fgKerningObject-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObject-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObject-__delslice__" href="#fgKerningObject-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObject-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObject-__getattribute__" href="#fgKerningObject-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObject-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObject-__getitem__" href="#fgKerningObject-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObject-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObject-__getslice__" href="#fgKerningObject-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObject-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObject-__init__" href="#fgKerningObject-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObject-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObject-__len__" href="#fgKerningObject-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObject-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObject-__mul__" href="#fgKerningObject-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObject-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObject-__repr__" href="#fgKerningObject-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObject-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObject-__rmul__" href="#fgKerningObject-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObject-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObject-__setattr__" href="#fgKerningObject-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObject-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObject-__setitem__" href="#fgKerningObject-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObject-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObject-__setslice__" href="#fgKerningObject-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObject-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObject-asDict" href="#fgKerningObject-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObject-asTuple" href="#fgKerningObject-asTuple"><span class="function-name">asTuple</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as tuple</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">(string) glyph or group name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>mode</dt>
<dd>

<pre class="doc" markdown="0">('glyphMode'/'groupMode')</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgKerningObject-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgKerningObjectPair" href="#fgKerningObjectPair">class <span class="class-name">fgKerningObjectPair</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">KerningObjectPair representation

Constructors:  fgKerningObjectPair() - default
  fgKerningObjectPair(fgKerningObjectPair) - copy
  fgKerningObjectPair( tuple(fgKerningObject, fgKerningObject) )
  fgKerningObjectPair('nameLeft', 'nameRight')
  fgKerningObjectPair(fgKerningObject, fgKerningObject)
  fgKerningObjectPair('nameLeft', 'nameRight', modeLeft, modeRight) - modeLeft, modeRight must be one of 'glyphMode'/'groupMode'</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgKerningObjectPair-__add__" href="#fgKerningObjectPair-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObjectPair-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObjectPair-__cmp__" href="#fgKerningObjectPair-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObjectPair-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObjectPair-__delattr__" href="#fgKerningObjectPair-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObjectPair-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObjectPair-__delitem__" href="#fgKerningObjectPair-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObjectPair-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObjectPair-__delslice__" href="#fgKerningObjectPair-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObjectPair-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObjectPair-__getattribute__" href="#fgKerningObjectPair-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObjectPair-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObjectPair-__getitem__" href="#fgKerningObjectPair-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObjectPair-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObjectPair-__getslice__" href="#fgKerningObjectPair-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObjectPair-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObjectPair-__hash__" href="#fgKerningObjectPair-__hash__"><span class="function-name">__hash__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObjectPair-__hash__">__hash__</a>() <==> hash(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObjectPair-__init__" href="#fgKerningObjectPair-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObjectPair-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObjectPair-__len__" href="#fgKerningObjectPair-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObjectPair-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObjectPair-__mul__" href="#fgKerningObjectPair-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObjectPair-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObjectPair-__repr__" href="#fgKerningObjectPair-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObjectPair-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObjectPair-__rmul__" href="#fgKerningObjectPair-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObjectPair-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObjectPair-__setattr__" href="#fgKerningObjectPair-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObjectPair-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObjectPair-__setitem__" href="#fgKerningObjectPair-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObjectPair-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObjectPair-__setslice__" href="#fgKerningObjectPair-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgKerningObjectPair-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObjectPair-asDict" href="#fgKerningObjectPair-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="fgKerningObjectPair-asTuple" href="#fgKerningObjectPair-asTuple"><span class="function-name">asTuple</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as tuple</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>left</dt>
<dd>

<pre class="doc" markdown="0">(fgKerningObject) - left glyph or group</pre>

</dd>
</dl>
<dl class="descriptor"><dt>right</dt>
<dd>

<pre class="doc" markdown="0">(fgKerningObject) - right glyph or group</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgKerningObjectPair-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgLayer" href="#fgLayer">class <span class="class-name">fgLayer</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Layer representation

Constructors:
  fgLayer() - default
  fgLayer(fgLayer) - copy
  fgLayer('name') - create named layer

Math operation:
  fgLayer + fgLayer
  fgLayer - fgLayer</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgLayer-__add__" href="#fgLayer-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayer-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-__cmp__" href="#fgLayer-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayer-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-__delattr__" href="#fgLayer-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayer-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-__delitem__" href="#fgLayer-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayer-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-__delslice__" href="#fgLayer-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayer-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-__getattribute__" href="#fgLayer-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayer-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-__getitem__" href="#fgLayer-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayer-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-__getslice__" href="#fgLayer-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayer-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-__init__" href="#fgLayer-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayer-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-__len__" href="#fgLayer-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayer-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-__mul__" href="#fgLayer-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayer-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-__radd__" href="#fgLayer-__radd__"><span class="function-name">__radd__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayer-__radd__">__radd__</a>(y) <==> y+x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-__repr__" href="#fgLayer-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayer-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-__rmul__" href="#fgLayer-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayer-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-__rsub__" href="#fgLayer-__rsub__"><span class="function-name">__rsub__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayer-__rsub__">__rsub__</a>(y) <==> y-x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-__setattr__" href="#fgLayer-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayer-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-__setitem__" href="#fgLayer-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayer-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-__setslice__" href="#fgLayer-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayer-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-__sub__" href="#fgLayer-__sub__"><span class="function-name">__sub__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayer-__sub__">__sub__</a>(y) <==> x-y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-addContour" href="#fgLayer-addContour"><span class="function-name">addContour</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgContour">fgContour</a> <a href="#fgLayer-addContour">addContour</a>(<a href="#fgContour">fgContour</a>) - add contour to layer</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-boundingBox" href="#fgLayer-boundingBox"><span class="function-name">boundingBox</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect">fgRect</a>/Nothing <a href="#fgLayer-boundingBox">boundingBox</a>(<a href="#fgMatrix">fgMatrix</a>[, prepareExport = false])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-checkContours" href="#fgLayer-checkContours"><span class="function-name">checkContours</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgLayer-checkContours">checkContours</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-countContours" href="#fgLayer-countContours"><span class="function-name">countContours</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgLayer-countContours">countContours</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-countHints" href="#fgLayer-countHints"><span class="function-name">countHints</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgLayer-countHints">countHints</a>(bool horizontal)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-countNodes" href="#fgLayer-countNodes"><span class="function-name">countNodes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgLayer-countNodes">countNodes</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-countPictures" href="#fgLayer-countPictures"><span class="function-name">countPictures</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgLayer-countPictures">countPictures</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-countShapes" href="#fgLayer-countShapes"><span class="function-name">countShapes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgLayer-countShapes">countShapes</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-findHint" href="#fgLayer-findHint"><span class="function-name">findHint</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgLayer-findHint">findHint</a>(<a href="#fgHint">fgHint</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-findNode" href="#fgLayer-findNode"><span class="function-name">findNode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgNode">fgNode</a>/Nothing <a href="#fgLayer-findNode">findNode</a>(nodeIndex / 'nodeName') - find name by index or name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-hasColors" href="#fgLayer-hasColors"><span class="function-name">hasColors</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgLayer-hasColors">hasColors</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-hasHints" href="#fgLayer-hasHints"><span class="function-name">hasHints</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgLayer-hasHints">hasHints</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-hasPictures" href="#fgLayer-hasPictures"><span class="function-name">hasPictures</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgLayer-hasPictures">hasPictures</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-hints2links" href="#fgLayer-hints2links"><span class="function-name">hints2links</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgLayer-hints2links">hints2links</a>(double tolerance[, <a href="#fgCuspPoints">fgCuspPoints</a>])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-indexToName" href="#fgLayer-indexToName"><span class="function-name">indexToName</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">'nodeName' <a href="#fgLayer-indexToName">indexToName</a>(int nodeIndex)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-isCompatible" href="#fgLayer-isCompatible"><span class="function-name">isCompatible</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool/Nothing <a href="#fgLayer-isCompatible">isCompatible</a>(flLayer)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-nameToIndex" href="#fgLayer-nameToIndex"><span class="function-name">nameToIndex</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgLayer-nameToIndex">nameToIndex</a>('nodeName')</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-prepareNodeNames" href="#fgLayer-prepareNodeNames"><span class="function-name">prepareNodeNames</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgLayer-prepareNodeNames">prepareNodeNames</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-removeHints" href="#fgLayer-removeHints"><span class="function-name">removeHints</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgLayer-removeHints">removeHints</a>(bool horizontal)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayer-transform" href="#fgLayer-transform"><span class="function-name">transform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgLayer-transform">transform</a>(const Matrix& mx[, apply = true])</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>active</dt>
<dd>

<pre class="doc" markdown="0">(bool)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>anchors</dt>
<dd>

<pre class="doc" markdown="0">(fgAnchors)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>guides</dt>
<dd>

<pre class="doc" markdown="0">(fgGuides)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hints</dt>
<dd>

<pre class="doc" markdown="0">(fgHints)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hintsProgram</dt>
<dd>

<pre class="doc" markdown="0">(fgHintCommands)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>locked</dt>
<dd>

<pre class="doc" markdown="0">(bool)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>matrix</dt>
<dd>

<pre class="doc" markdown="0">(fgMatrix)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">(string)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>opacity</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>reference</dt>
<dd>

<pre class="doc" markdown="0">(fgPoint)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>service</dt>
<dd>

<pre class="doc" markdown="0">(bool)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>visible</dt>
<dd>

<pre class="doc" markdown="0">(bool)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>wireframe</dt>
<dd>

<pre class="doc" markdown="0">(bool)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgLayer-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgLayers" href="#fgLayers">class <span class="class-name">fgLayers</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgLayer objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgLayers-__add__" href="#fgLayers-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayers-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayers-__cmp__" href="#fgLayers-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayers-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayers-__delattr__" href="#fgLayers-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayers-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayers-__delitem__" href="#fgLayers-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayers-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayers-__delslice__" href="#fgLayers-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayers-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayers-__getattribute__" href="#fgLayers-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayers-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayers-__getitem__" href="#fgLayers-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayers-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayers-__getslice__" href="#fgLayers-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayers-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayers-__init__" href="#fgLayers-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayers-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayers-__len__" href="#fgLayers-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayers-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayers-__mul__" href="#fgLayers-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayers-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayers-__repr__" href="#fgLayers-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayers-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayers-__rmul__" href="#fgLayers-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayers-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayers-__setattr__" href="#fgLayers-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayers-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayers-__setitem__" href="#fgLayers-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayers-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayers-__setslice__" href="#fgLayers-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLayers-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayers-append" href="#fgLayers-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayers-asList" href="#fgLayers-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayers-clean" href="#fgLayers-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayers-del" href="#fgLayers-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgLayers-insert" href="#fgLayers-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgLayers-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgLib" href="#fgLib">class <span class="class-name">fgLib</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Dictionary with font- or glyph-related data</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgLib-__delattr__" href="#fgLib-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLib-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLib-__delitem__" href="#fgLib-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLib-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLib-__getattribute__" href="#fgLib-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLib-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLib-__getitem__" href="#fgLib-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLib-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLib-__init__" href="#fgLib-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLib-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLib-__len__" href="#fgLib-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLib-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLib-__repr__" href="#fgLib-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLib-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLib-__setattr__" href="#fgLib-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLib-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLib-__setitem__" href="#fgLib-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgLib-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgLib-clear" href="#fgLib-clear"><span class="function-name">clear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgLib-get" href="#fgLib-get"><span class="function-name">get</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgLib-hasKey" href="#fgLib-hasKey"><span class="function-name">hasKey</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgLib-items" href="#fgLib-items"><span class="function-name">items</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgLib-keys" href="#fgLib-keys"><span class="function-name">keys</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgLib-update" href="#fgLib-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgLib-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgMapBytes" href="#fgMapBytes">class <span class="class-name">fgMapBytes</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Raw data dictionary</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgMapBytes-__add__" href="#fgMapBytes-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMapBytes-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMapBytes-__cmp__" href="#fgMapBytes-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMapBytes-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMapBytes-__delattr__" href="#fgMapBytes-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMapBytes-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMapBytes-__delitem__" href="#fgMapBytes-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMapBytes-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMapBytes-__delslice__" href="#fgMapBytes-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMapBytes-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMapBytes-__getattribute__" href="#fgMapBytes-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMapBytes-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMapBytes-__getitem__" href="#fgMapBytes-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMapBytes-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMapBytes-__getslice__" href="#fgMapBytes-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMapBytes-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMapBytes-__init__" href="#fgMapBytes-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMapBytes-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMapBytes-__len__" href="#fgMapBytes-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMapBytes-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMapBytes-__mul__" href="#fgMapBytes-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMapBytes-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMapBytes-__repr__" href="#fgMapBytes-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMapBytes-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMapBytes-__rmul__" href="#fgMapBytes-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMapBytes-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMapBytes-__setattr__" href="#fgMapBytes-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMapBytes-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMapBytes-__setitem__" href="#fgMapBytes-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMapBytes-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMapBytes-__setslice__" href="#fgMapBytes-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMapBytes-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMapBytes-asDict" href="#fgMapBytes-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgMapBytes-del" href="#fgMapBytes-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgMapBytes-has_key" href="#fgMapBytes-has_key"><span class="function-name">has_key</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgMapBytes-keys" href="#fgMapBytes-keys"><span class="function-name">keys</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgMapBytes-value" href="#fgMapBytes-value"><span class="function-name">value</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgMapBytes-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgMaster" href="#fgMaster">class <span class="class-name">fgMaster</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Anchor representation

Constructors:
  fgMaster() - default
  fgMaster(fgMaster) - copy
  fgMaster('name') - create with name='name'</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgMaster-__cmp__" href="#fgMaster-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaster-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaster-__delattr__" href="#fgMaster-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaster-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaster-__getattribute__" href="#fgMaster-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaster-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaster-__init__" href="#fgMaster-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaster-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaster-__repr__" href="#fgMaster-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaster-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaster-__setattr__" href="#fgMaster-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaster-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaster-__str__" href="#fgMaster-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaster-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">(string) - name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>penColor</dt>
<dd>

<pre class="doc" markdown="0">(int) - penColor</pre>

</dd>
</dl>
<dl class="descriptor"><dt>position</dt>
<dd>

<pre class="doc" markdown="0">(fgDesignPosition)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgMaster-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgMasters" href="#fgMasters">class <span class="class-name">fgMasters</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgMaster objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgMasters-__add__" href="#fgMasters-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMasters-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMasters-__cmp__" href="#fgMasters-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMasters-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMasters-__delattr__" href="#fgMasters-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMasters-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMasters-__delitem__" href="#fgMasters-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMasters-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMasters-__delslice__" href="#fgMasters-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMasters-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMasters-__getattribute__" href="#fgMasters-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMasters-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMasters-__getitem__" href="#fgMasters-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMasters-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMasters-__getslice__" href="#fgMasters-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMasters-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMasters-__init__" href="#fgMasters-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMasters-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMasters-__len__" href="#fgMasters-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMasters-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMasters-__mul__" href="#fgMasters-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMasters-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMasters-__repr__" href="#fgMasters-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMasters-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMasters-__rmul__" href="#fgMasters-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMasters-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMasters-__setattr__" href="#fgMasters-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMasters-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMasters-__setitem__" href="#fgMasters-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMasters-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMasters-__setslice__" href="#fgMasters-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMasters-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMasters-append" href="#fgMasters-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgMasters-append">append</a>(item) or <a href="#fgMasters-append">append</a>( list(item) ) - add items to the end of the list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMasters-asList" href="#fgMasters-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(items) <a href="#fgMasters-asList">asList</a>() - get items as list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMasters-clean" href="#fgMasters-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgMasters-clean">clean</a>() - delete all items</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMasters-del" href="#fgMasters-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgMasters-del">del</a>(index) - delete item by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMasters-insert" href="#fgMasters-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgMasters-insert">insert</a>(position, item) - insert item into list at specified position</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgMasters-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgMatrix" href="#fgMatrix">class <span class="class-name">fgMatrix</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Transformation matrix representation

Constructors:
  fgMatrix() - default
  fgMatrix(fgMatrix) - copy
  fgMatrix(float m11, float m12, float m21, float m22, float dx, float dy)

Math operation:
  fgMatrix * fgMatrix</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgMatrix-__add__" href="#fgMatrix-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__delattr__" href="#fgMatrix-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__delitem__" href="#fgMatrix-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__delslice__" href="#fgMatrix-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__eq__" href="#fgMatrix-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__ge__" href="#fgMatrix-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__getattribute__" href="#fgMatrix-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__getitem__" href="#fgMatrix-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__getslice__" href="#fgMatrix-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__gt__" href="#fgMatrix-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__init__" href="#fgMatrix-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__le__" href="#fgMatrix-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__len__" href="#fgMatrix-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__lt__" href="#fgMatrix-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__mul__" href="#fgMatrix-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__mul__">__mul__</a>(y) <==> x*y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__ne__" href="#fgMatrix-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__repr__" href="#fgMatrix-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__rmul__" href="#fgMatrix-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__rmul__">__rmul__</a>(y) <==> y*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__setattr__" href="#fgMatrix-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__setitem__" href="#fgMatrix-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__setslice__" href="#fgMatrix-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-__str__" href="#fgMatrix-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMatrix-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-asDict" href="#fgMatrix-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-asTuple" href="#fgMatrix-asTuple"><span class="function-name">asTuple</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as tuple</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-assign" href="#fgMatrix-assign"><span class="function-name">assign</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgMatrix-assign">assign</a>(<a href="#fgMatrix">fgMatrix</a>) or <a href="#fgMatrix-assign">assign</a>(m11, m12, m21, m22, dx, dy)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-determinant" href="#fgMatrix-determinant"><span class="function-name">determinant</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgMatrix-determinant">determinant</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-invert" href="#fgMatrix-invert"><span class="function-name">invert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgMatrix-invert">invert</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-inverted" href="#fgMatrix-inverted"><span class="function-name">inverted</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgMatrix">fgMatrix</a> <a href="#fgMatrix-inverted">inverted</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-invertible" href="#fgMatrix-invertible"><span class="function-name">invertible</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgMatrix-invertible">invertible</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-noMove" href="#fgMatrix-noMove"><span class="function-name">noMove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgMatrix-noMove">noMove</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-noRotate" href="#fgMatrix-noRotate"><span class="function-name">noRotate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgMatrix-noRotate">noRotate</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-noScale" href="#fgMatrix-noScale"><span class="function-name">noScale</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgMatrix-noScale">noScale</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-scale" href="#fgMatrix-scale"><span class="function-name">scale</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgMatrix-scale">scale</a>(float s)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-slant" href="#fgMatrix-slant"><span class="function-name">slant</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgMatrix-slant">slant</a>(float angle) or float <a href="#fgMatrix-slant">slant</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMatrix-standard" href="#fgMatrix-standard"><span class="function-name">standard</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgMatrix-standard">standard</a>()</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>dx</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>dy</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>m11</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>m12</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>m21</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>m22</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgMatrix-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgMaxP" href="#fgMaxP">class <span class="class-name">fgMaxP</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgMaxP representation</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgMaxP-__add__" href="#fgMaxP-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaxP-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaxP-__cmp__" href="#fgMaxP-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaxP-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaxP-__delattr__" href="#fgMaxP-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaxP-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaxP-__delitem__" href="#fgMaxP-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaxP-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaxP-__delslice__" href="#fgMaxP-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaxP-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaxP-__getattribute__" href="#fgMaxP-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaxP-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaxP-__getitem__" href="#fgMaxP-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaxP-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaxP-__getslice__" href="#fgMaxP-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaxP-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaxP-__init__" href="#fgMaxP-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaxP-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaxP-__len__" href="#fgMaxP-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaxP-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaxP-__mul__" href="#fgMaxP-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaxP-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaxP-__repr__" href="#fgMaxP-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaxP-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaxP-__rmul__" href="#fgMaxP-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaxP-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaxP-__setattr__" href="#fgMaxP-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaxP-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaxP-__setitem__" href="#fgMaxP-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaxP-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaxP-__setslice__" href="#fgMaxP-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaxP-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaxP-__str__" href="#fgMaxP-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMaxP-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaxP-asDict" href="#fgMaxP-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMaxP-asTuple" href="#fgMaxP-asTuple"><span class="function-name">asTuple</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as tuple</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>maxFunctionDefs</dt>
</dl>
<dl class="descriptor"><dt>maxInstructionDefs</dt>
</dl>
<dl class="descriptor"><dt>maxStackElements</dt>
</dl>
<dl class="descriptor"><dt>maxStorage</dt>
</dl>
<dl class="descriptor"><dt>maxTwilightPoints</dt>
</dl>
<dl class="descriptor"><dt>maxZones</dt>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgMaxP-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgMetricsClass" href="#fgMetricsClass">class <span class="class-name">fgMetricsClass</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">MetricsClass representation

Constructors:
  fgMetricsClass() - default
  fgMetricsClass(fgMetricsClass) - copy</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgMetricsClass-__cmp__" href="#fgMetricsClass-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClass-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClass-__delattr__" href="#fgMetricsClass-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClass-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClass-__getattribute__" href="#fgMetricsClass-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClass-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClass-__init__" href="#fgMetricsClass-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClass-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClass-__repr__" href="#fgMetricsClass-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClass-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClass-__setattr__" href="#fgMetricsClass-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClass-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClass-__str__" href="#fgMetricsClass-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClass-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClass-hasGlyph" href="#fgMetricsClass-hasGlyph"><span class="function-name">hasGlyph</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgMetricsClass-hasGlyph">hasGlyph</a>(int glyphID/'glyphName')</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClass-keyGlyphName" href="#fgMetricsClass-keyGlyphName"><span class="function-name">keyGlyphName</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">'keyGlyphName' <a href="#fgMetricsClass-keyGlyphName">keyGlyphName</a>()</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>glyphs</dt>
<dd>

<pre class="doc" markdown="0">(fgGlyphIDsSet)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>left</dt>
<dd>

<pre class="doc" markdown="0">(bool)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">(string)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>right</dt>
<dd>

<pre class="doc" markdown="0">(bool)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>width</dt>
<dd>

<pre class="doc" markdown="0">(bool)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgMetricsClass-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgMetricsClasses" href="#fgMetricsClasses">class <span class="class-name">fgMetricsClasses</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgMetricsClass objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgMetricsClasses-__add__" href="#fgMetricsClasses-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClasses-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClasses-__cmp__" href="#fgMetricsClasses-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClasses-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClasses-__delattr__" href="#fgMetricsClasses-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClasses-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClasses-__delitem__" href="#fgMetricsClasses-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClasses-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClasses-__delslice__" href="#fgMetricsClasses-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClasses-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClasses-__getattribute__" href="#fgMetricsClasses-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClasses-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClasses-__getitem__" href="#fgMetricsClasses-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClasses-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClasses-__getslice__" href="#fgMetricsClasses-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClasses-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClasses-__init__" href="#fgMetricsClasses-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClasses-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClasses-__len__" href="#fgMetricsClasses-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClasses-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClasses-__mul__" href="#fgMetricsClasses-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClasses-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClasses-__repr__" href="#fgMetricsClasses-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClasses-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClasses-__rmul__" href="#fgMetricsClasses-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClasses-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClasses-__setattr__" href="#fgMetricsClasses-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClasses-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClasses-__setitem__" href="#fgMetricsClasses-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClasses-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClasses-__setslice__" href="#fgMetricsClasses-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgMetricsClasses-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClasses-append" href="#fgMetricsClasses-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClasses-asList" href="#fgMetricsClasses-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClasses-clean" href="#fgMetricsClasses-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClasses-del" href="#fgMetricsClasses-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgMetricsClasses-insert" href="#fgMetricsClasses-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgMetricsClasses-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgNametable" href="#fgNametable">class <span class="class-name">fgNametable</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">NameTable - unicode->name translation and vice versa</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgNametable-__delattr__" href="#fgNametable-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNametable-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNametable-__getattribute__" href="#fgNametable-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNametable-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNametable-__init__" href="#fgNametable-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNametable-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNametable-__repr__" href="#fgNametable-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNametable-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNametable-__setattr__" href="#fgNametable-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNametable-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNametable-easyCompare" href="#fgNametable-easyCompare"><span class="function-name">easyCompare</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgNametable-easyCompare">easyCompare</a>('name0', 'name1')</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNametable-getAlternativeNames" href="#fgNametable-getAlternativeNames"><span class="function-name">getAlternativeNames</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list( 'altGlyphName' ) <a href="#fgNametable-getAlternativeNames">getAlternativeNames</a>('glyphName')</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNametable-load" href="#fgNametable-load"><span class="function-name">load</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgNametable-load">load</a>(string path_to_file)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNametable-name" href="#fgNametable-name"><span class="function-name">name</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">'glyphName' <a href="#fgNametable-name">name</a>(int unicode)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNametable-unc" href="#fgNametable-unc"><span class="function-name">unc</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgNametable-unc">unc</a>('glyphName')</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>loaded</dt>
<dd>

<pre class="doc" markdown="0">(bool)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgNametable-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgNode" href="#fgNode">class <span class="class-name">fgNode</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Node representation

Constructors:
  fgNode() - default
  fgNode(fgNode) - copy
  fgNode('Move'/'On'/'Off'/'Curve', fgPoint[, smooth=false])
  fgNode('Move'/'On'/'Off'/'Curve', fgPoint, 'name'[, smooth=false])

Math operation:
  fgNode + fgNode
  fgNode - fgNode
  fgNode * float</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgNode-__add__" href="#fgNode-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNode-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-__cmp__" href="#fgNode-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNode-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-__delattr__" href="#fgNode-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNode-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-__getattribute__" href="#fgNode-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNode-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-__init__" href="#fgNode-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNode-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-__mul__" href="#fgNode-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNode-__mul__">__mul__</a>(y) <==> x*y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-__radd__" href="#fgNode-__radd__"><span class="function-name">__radd__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNode-__radd__">__radd__</a>(y) <==> y+x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-__repr__" href="#fgNode-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNode-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-__rmul__" href="#fgNode-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNode-__rmul__">__rmul__</a>(y) <==> y*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-__rsub__" href="#fgNode-__rsub__"><span class="function-name">__rsub__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNode-__rsub__">__rsub__</a>(y) <==> y-x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-__setattr__" href="#fgNode-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNode-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-__sub__" href="#fgNode-__sub__"><span class="function-name">__sub__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNode-__sub__">__sub__</a>(y) <==> x-y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-isG2" href="#fgNode-isG2"><span class="function-name">isG2</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgNode-isG2">isG2</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-isInterpolatedX" href="#fgNode-isInterpolatedX"><span class="function-name">isInterpolatedX</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgNode-isInterpolatedX">isInterpolatedX</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-isInterpolatedY" href="#fgNode-isInterpolatedY"><span class="function-name">isInterpolatedY</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgNode-isInterpolatedY">isInterpolatedY</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-isOff" href="#fgNode-isOff"><span class="function-name">isOff</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgNode-isOff">isOff</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-isOn" href="#fgNode-isOn"><span class="function-name">isOn</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgNode-isOn">isOn</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-isSelected" href="#fgNode-isSelected"><span class="function-name">isSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgNode-isSelected">isSelected</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-setG2" href="#fgNode-setG2"><span class="function-name">setG2</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgNode-setG2">setG2</a>([true])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-setInterpolatedX" href="#fgNode-setInterpolatedX"><span class="function-name">setInterpolatedX</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgNode-setInterpolatedX">setInterpolatedX</a>([true])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-setInterpolatedY" href="#fgNode-setInterpolatedY"><span class="function-name">setInterpolatedY</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgNode-setInterpolatedY">setInterpolatedY</a>([true])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-setSelected" href="#fgNode-setSelected"><span class="function-name">setSelected</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgNode-setSelected">setSelected</a>([true])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNode-transform" href="#fgNode-transform"><span class="function-name">transform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgNode-transform">transform</a>(<a href="#fgMatrix">fgMatrix</a>)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>flags</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>kind</dt>
<dd>

<pre class="doc" markdown="0">('Move'/'On'/'Off'/'Curve')</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">(string)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>point</dt>
<dd>

<pre class="doc" markdown="0">(fgPoint)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>smooth</dt>
<dd>

<pre class="doc" markdown="0">(bool)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgNode-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgNodes" href="#fgNodes">class <span class="class-name">fgNodes</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgNode objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgNodes-__add__" href="#fgNodes-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNodes-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNodes-__cmp__" href="#fgNodes-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNodes-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNodes-__delattr__" href="#fgNodes-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNodes-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNodes-__delitem__" href="#fgNodes-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNodes-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNodes-__delslice__" href="#fgNodes-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNodes-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNodes-__getattribute__" href="#fgNodes-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNodes-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNodes-__getitem__" href="#fgNodes-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNodes-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNodes-__getslice__" href="#fgNodes-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNodes-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNodes-__init__" href="#fgNodes-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNodes-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNodes-__len__" href="#fgNodes-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNodes-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNodes-__mul__" href="#fgNodes-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNodes-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNodes-__repr__" href="#fgNodes-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNodes-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNodes-__rmul__" href="#fgNodes-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNodes-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNodes-__setattr__" href="#fgNodes-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNodes-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNodes-__setitem__" href="#fgNodes-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNodes-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNodes-__setslice__" href="#fgNodes-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgNodes-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgNodes-append" href="#fgNodes-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgNodes-asList" href="#fgNodes-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgNodes-clean" href="#fgNodes-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgNodes-del" href="#fgNodes-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgNodes-insert" href="#fgNodes-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgNodes-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOTLayout" href="#fgOTLayout">class <span class="class-name">fgOTLayout</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">OpenType Layout representation

Constructors:
  fgOTLayout(fgDataOwnerData)
  fgOTLayout(fgFont)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOTLayout-__add__" href="#fgOTLayout-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOTLayout-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-__delattr__" href="#fgOTLayout-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOTLayout-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-__delitem__" href="#fgOTLayout-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOTLayout-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-__delslice__" href="#fgOTLayout-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOTLayout-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-__getattribute__" href="#fgOTLayout-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOTLayout-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-__getitem__" href="#fgOTLayout-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOTLayout-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-__getslice__" href="#fgOTLayout-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOTLayout-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-__init__" href="#fgOTLayout-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOTLayout-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-__len__" href="#fgOTLayout-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOTLayout-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-__mul__" href="#fgOTLayout-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOTLayout-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-__repr__" href="#fgOTLayout-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOTLayout-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-__rmul__" href="#fgOTLayout-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOTLayout-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-__setattr__" href="#fgOTLayout-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOTLayout-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-__setitem__" href="#fgOTLayout-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOTLayout-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-__setslice__" href="#fgOTLayout-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOTLayout-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-clear" href="#fgOTLayout-clear"><span class="function-name">clear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgOTLayout-clear">clear</a>() - remove all features</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-get_feature" href="#fgOTLayout-get_feature"><span class="function-name">get_feature</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#fgOTLayout-get_feature">get_feature</a>(string / numeric tag) - get feature text</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-get_prefix" href="#fgOTLayout-get_prefix"><span class="function-name">get_prefix</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#fgOTLayout-get_prefix">get_prefix</a>() - get common part of fea data</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-has_key" href="#fgOTLayout-has_key"><span class="function-name">has_key</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgOTLayout-has_key">has_key</a>(string / numeric tag) - True if feature is present</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-keys" href="#fgOTLayout-keys"><span class="function-name">keys</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(string) <a href="#fgOTLayout-keys">keys</a>() - list of feature tags</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-remove" href="#fgOTLayout-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgOTLayout-remove">remove</a>(string / numeric tag) - remove feature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-set_feature" href="#fgOTLayout-set_feature"><span class="function-name">set_feature</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgOTLayout-set_feature">set_feature</a>(string / numeric tag, string new_content) - set feature text</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOTLayout-set_prefix" href="#fgOTLayout-set_prefix"><span class="function-name">set_prefix</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgOTLayout-set_prefix">set_prefix</a>(string new_prefix) - set common part of fea data</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOTLayout-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOpt_AutoMetrics" href="#fgOpt_AutoMetrics">class <span class="class-name">fgOpt_AutoMetrics</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgOpt_AutoMetrics options page</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOpt_AutoMetrics-__delattr__" href="#fgOpt_AutoMetrics-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_AutoMetrics-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_AutoMetrics-__getattribute__" href="#fgOpt_AutoMetrics-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_AutoMetrics-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_AutoMetrics-__init__" href="#fgOpt_AutoMetrics-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_AutoMetrics-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_AutoMetrics-__repr__" href="#fgOpt_AutoMetrics-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_AutoMetrics-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_AutoMetrics-__setattr__" href="#fgOpt_AutoMetrics-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_AutoMetrics-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_AutoMetrics-__str__" href="#fgOpt_AutoMetrics-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_AutoMetrics-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>close</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>left</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>right</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOpt_AutoMetrics-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOpt_EOTExport" href="#fgOpt_EOTExport">class <span class="class-name">fgOpt_EOTExport</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgOpt_EOTExport options page</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOpt_EOTExport-__delattr__" href="#fgOpt_EOTExport-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_EOTExport-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_EOTExport-__getattribute__" href="#fgOpt_EOTExport-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_EOTExport-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_EOTExport-__init__" href="#fgOpt_EOTExport-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_EOTExport-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_EOTExport-__repr__" href="#fgOpt_EOTExport-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_EOTExport-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_EOTExport-__setattr__" href="#fgOpt_EOTExport-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_EOTExport-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_EOTExport-__str__" href="#fgOpt_EOTExport-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_EOTExport-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>doCompression</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>doXORCryptData</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>otExport</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOpt_EOTExport-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOpt_ExpandKerning" href="#fgOpt_ExpandKerning">class <span class="class-name">fgOpt_ExpandKerning</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgOpt_ExpandKerning options page</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOpt_ExpandKerning-__delattr__" href="#fgOpt_ExpandKerning-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_ExpandKerning-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_ExpandKerning-__getattribute__" href="#fgOpt_ExpandKerning-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_ExpandKerning-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_ExpandKerning-__init__" href="#fgOpt_ExpandKerning-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_ExpandKerning-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_ExpandKerning-__repr__" href="#fgOpt_ExpandKerning-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_ExpandKerning-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_ExpandKerning-__setattr__" href="#fgOpt_ExpandKerning-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_ExpandKerning-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_ExpandKerning-__str__" href="#fgOpt_ExpandKerning-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_ExpandKerning-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>applyToAssistance</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>codepage</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>count</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>keep</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>limitAction</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>limitCmap10</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>limitCodepage</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>limitCount</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>limitFontWindow</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOpt_ExpandKerning-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOpt_Font" href="#fgOpt_Font">class <span class="class-name">fgOpt_Font</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgOpt_Font options page</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOpt_Font-__delattr__" href="#fgOpt_Font-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_Font-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_Font-__getattribute__" href="#fgOpt_Font-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_Font-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_Font-__init__" href="#fgOpt_Font-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_Font-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_Font-__repr__" href="#fgOpt_Font-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_Font-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_Font-__setattr__" href="#fgOpt_Font-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_Font-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_Font-__str__" href="#fgOpt_Font-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_Font-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>autoMetrics</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>buildPclt</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>detectG2</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>detectInterpolation</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>expandKerning</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>fitAscender</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>fitDescender</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>optimize</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>otExport</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>placeDuplicate</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>placePaste</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>t1Autohint</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>t1Export</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>ttAutohint</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOpt_Font-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOpt_KerningOptions" href="#fgOpt_KerningOptions">class <span class="class-name">fgOpt_KerningOptions</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgOpt_KerningOptions options page</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOpt_KerningOptions-__delattr__" href="#fgOpt_KerningOptions-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_KerningOptions-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_KerningOptions-__getattribute__" href="#fgOpt_KerningOptions-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_KerningOptions-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_KerningOptions-__init__" href="#fgOpt_KerningOptions-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_KerningOptions-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_KerningOptions-__repr__" href="#fgOpt_KerningOptions-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_KerningOptions-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_KerningOptions-__setattr__" href="#fgOpt_KerningOptions-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_KerningOptions-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_KerningOptions-__str__" href="#fgOpt_KerningOptions-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_KerningOptions-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>saveTheOnlySubtableInKernTable</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>useScriptInfoForOneSubtableCutting</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOpt_KerningOptions-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOpt_OTExport" href="#fgOpt_OTExport">class <span class="class-name">fgOpt_OTExport</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgOpt_OTExport options page</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOpt_OTExport-__delattr__" href="#fgOpt_OTExport-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_OTExport-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_OTExport-__getattribute__" href="#fgOpt_OTExport-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_OTExport-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_OTExport-__init__" href="#fgOpt_OTExport-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_OTExport-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_OTExport-__repr__" href="#fgOpt_OTExport-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_OTExport-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_OTExport-__setattr__" href="#fgOpt_OTExport-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_OTExport-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_OTExport-__str__" href="#fgOpt_OTExport-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_OTExport-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>CBDT</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>COLR</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>SVG</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>addCharacters</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>applyBBoxSavings</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>autoWinAscDesc</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>autohint</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>autohintGlyphs</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>autohintingMode</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>autotrace</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>cff</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>cff_adobe</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>cff_compress</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>cmap10</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>copyHDMXData</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>decompose</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>doAutohinting</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>doHintsCompile</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>exportCBDT</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>exportCOLR</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>exportSBIX</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>exportSVG</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>exportVOLT</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>feaFileOptions</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>featuresCompile</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>featuresRestore</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>fixDirection</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>fixNames</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>fontNames</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>generateLTSH</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>headBBoxSavings</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>kerningOptions</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>noReorder</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>roundCoordinates</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>sbix</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>silent_mode</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>subrize</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>t1autohint</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>ttfautohint</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>useTTFAutohint</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>writeBinaryHinting</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>writeBitmaps</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>writeDeviceMetrics</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>writeGDEF</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>writeHintedFont</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>writeKernFeature</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>writeKernTable</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>writeOriginalHinting</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOpt_OTExport-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOpt_OTExportFeaFile" href="#fgOpt_OTExportFeaFile">class <span class="class-name">fgOpt_OTExportFeaFile</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgOpt_OTExportFeaFile options page</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOpt_OTExportFeaFile-__delattr__" href="#fgOpt_OTExportFeaFile-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_OTExportFeaFile-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_OTExportFeaFile-__getattribute__" href="#fgOpt_OTExportFeaFile-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_OTExportFeaFile-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_OTExportFeaFile-__init__" href="#fgOpt_OTExportFeaFile-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_OTExportFeaFile-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_OTExportFeaFile-__repr__" href="#fgOpt_OTExportFeaFile-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_OTExportFeaFile-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_OTExportFeaFile-__setattr__" href="#fgOpt_OTExportFeaFile-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_OTExportFeaFile-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_OTExportFeaFile-__str__" href="#fgOpt_OTExportFeaFile-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_OTExportFeaFile-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>doWriteGDEF</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>inlineLookups</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>verbose</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>write_body</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>write_classes</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>write_prefix</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOpt_OTExportFeaFile-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOpt_OTImport" href="#fgOpt_OTImport">class <span class="class-name">fgOpt_OTImport</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgOpt_OTImport options page</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOpt_OTImport-__delattr__" href="#fgOpt_OTImport-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_OTImport-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_OTImport-__getattribute__" href="#fgOpt_OTImport-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_OTImport-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_OTImport-__init__" href="#fgOpt_OTImport-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_OTImport-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_OTImport-__repr__" href="#fgOpt_OTImport-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_OTImport-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_OTImport-__setattr__" href="#fgOpt_OTImport-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_OTImport-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_OTImport-__str__" href="#fgOpt_OTImport-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_OTImport-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>convertCurves</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>convertNames</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>curveConvertPrecision</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>featuresDecompile</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>featuresStore</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>ignoreGlyphs</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>namesGrouping</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>readKerningFromFeature</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>readKerningFromTable</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>readMacSpecificNaming</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>shortSplines</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>storeAAT</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>storeOriginalHinting</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOpt_OTImport-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOpt_Optimize" href="#fgOpt_Optimize">class <span class="class-name">fgOpt_Optimize</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgOpt_Optimize options page</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOpt_Optimize-__delattr__" href="#fgOpt_Optimize-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_Optimize-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_Optimize-__getattribute__" href="#fgOpt_Optimize-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_Optimize-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_Optimize-__init__" href="#fgOpt_Optimize-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_Optimize-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_Optimize-__repr__" href="#fgOpt_Optimize-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_Optimize-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_Optimize-__setattr__" href="#fgOpt_Optimize-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_Optimize-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_Optimize-__str__" href="#fgOpt_Optimize-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_Optimize-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>align</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>reduce</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOpt_Optimize-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOpt_T1Autohint" href="#fgOpt_T1Autohint">class <span class="class-name">fgOpt_T1Autohint</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgOpt_T1Autohint options page</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOpt_T1Autohint-__delattr__" href="#fgOpt_T1Autohint-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_T1Autohint-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_T1Autohint-__getattribute__" href="#fgOpt_T1Autohint-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_T1Autohint-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_T1Autohint-__init__" href="#fgOpt_T1Autohint-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_T1Autohint-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_T1Autohint-__repr__" href="#fgOpt_T1Autohint-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_T1Autohint-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_T1Autohint-__setattr__" href="#fgOpt_T1Autohint-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_T1Autohint-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_T1Autohint-__str__" href="#fgOpt_T1Autohint-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_T1Autohint-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>hHinting</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>hStems</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>maxHWidth</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>maxVWidth</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>minHLen</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>minHWidth</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>minVLen</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>minVWidth</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>ratioH</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>ratioV</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>useAdobeAutohinter</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>vHinting</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>vStems</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>zones</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOpt_T1Autohint-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOpt_T1Export" href="#fgOpt_T1Export">class <span class="class-name">fgOpt_T1Export</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgOpt_T1Export options page</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOpt_T1Export-__delattr__" href="#fgOpt_T1Export-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_T1Export-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_T1Export-__getattribute__" href="#fgOpt_T1Export-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_T1Export-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_T1Export-__init__" href="#fgOpt_T1Export-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_T1Export-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_T1Export-__repr__" href="#fgOpt_T1Export-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_T1Export-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_T1Export-__setattr__" href="#fgOpt_T1Export-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_T1Export-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_T1Export-__str__" href="#fgOpt_T1Export-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_T1Export-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>AFM</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>ASCII</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>INF</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>PFM</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>autohint</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>cff</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>cid</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>decompose</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>downloadable</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>encoding</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>fixDirection</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>flex</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>fsType</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>roundCoordinates</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>scale1000</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>sort</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>swapNotice</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>unicode</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>useOS2</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOpt_T1Export-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOpt_T1Import" href="#fgOpt_T1Import">class <span class="class-name">fgOpt_T1Import</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgOpt_T1Import options page</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOpt_T1Import-__delattr__" href="#fgOpt_T1Import-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_T1Import-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_T1Import-__getattribute__" href="#fgOpt_T1Import-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_T1Import-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_T1Import-__init__" href="#fgOpt_T1Import-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_T1Import-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_T1Import-__repr__" href="#fgOpt_T1Import-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_T1Import-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_T1Import-__setattr__" href="#fgOpt_T1Import-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_T1Import-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_T1Import-__str__" href="#fgOpt_T1Import-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_T1Import-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>decompose</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>familyGrouping</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>ignoreGlyphs</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>readMacSpecificNaming</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>singleMasterOnly</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOpt_T1Import-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOpt_TTAutohint" href="#fgOpt_TTAutohint">class <span class="class-name">fgOpt_TTAutohint</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgOpt_TTAutohint options page</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOpt_TTAutohint-__delattr__" href="#fgOpt_TTAutohint-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_TTAutohint-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_TTAutohint-__getattribute__" href="#fgOpt_TTAutohint-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_TTAutohint-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_TTAutohint-__init__" href="#fgOpt_TTAutohint-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_TTAutohint-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_TTAutohint-__repr__" href="#fgOpt_TTAutohint-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_TTAutohint-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_TTAutohint-__setattr__" href="#fgOpt_TTAutohint-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_TTAutohint-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_TTAutohint-__str__" href="#fgOpt_TTAutohint-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_TTAutohint-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>allow3Stems</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>allowDeltas</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>hHinting</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>hintSidebearing</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>hintToCenter</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>interpolateCusps</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>interpolateDoubleLinks</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>treshold</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>vHinting</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOpt_TTAutohint-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOpt_TTFAutohint" href="#fgOpt_TTFAutohint">class <span class="class-name">fgOpt_TTFAutohint</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgOpt_TTFAutohint options page</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOpt_TTFAutohint-__delattr__" href="#fgOpt_TTFAutohint-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_TTFAutohint-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_TTFAutohint-__getattribute__" href="#fgOpt_TTFAutohint-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_TTFAutohint-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_TTFAutohint-__init__" href="#fgOpt_TTFAutohint-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_TTFAutohint-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_TTFAutohint-__repr__" href="#fgOpt_TTFAutohint-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_TTFAutohint-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_TTFAutohint-__setattr__" href="#fgOpt_TTFAutohint-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_TTFAutohint-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_TTFAutohint-__str__" href="#fgOpt_TTFAutohint-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_TTFAutohint-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>TTFA_info</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>adjust_subglyphs</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>control_name</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>default_script</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>dehint</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>detailed_info</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>dw_cleartype_strong_stem_width</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>fallback_script</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>fallback_stem_width</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>family_suffix</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>gdi_cleartype_strong_stem_width</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>gray_strong_stem_width</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>hint_composites</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>hinting_limit</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>hinting_range_max</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>hinting_range_min</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>ignore_restrictions</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>increase_x_height</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>no_info</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>symbol</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>windows_compatibility</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>x_height_snapping_exceptions_string</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOpt_TTFAutohint-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOpt_UfoFontExport" href="#fgOpt_UfoFontExport">class <span class="class-name">fgOpt_UfoFontExport</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgOpt_UfoFontExport options page</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOpt_UfoFontExport-__delattr__" href="#fgOpt_UfoFontExport-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_UfoFontExport-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_UfoFontExport-__getattribute__" href="#fgOpt_UfoFontExport-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_UfoFontExport-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_UfoFontExport-__init__" href="#fgOpt_UfoFontExport-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_UfoFontExport-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_UfoFontExport-__repr__" href="#fgOpt_UfoFontExport-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_UfoFontExport-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_UfoFontExport-__setattr__" href="#fgOpt_UfoFontExport-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_UfoFontExport-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_UfoFontExport-__str__" href="#fgOpt_UfoFontExport-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_UfoFontExport-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>base64</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>compress</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>formatVersion</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>writeLayoutTTX</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOpt_UfoFontExport-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOpt_UfoFontImport" href="#fgOpt_UfoFontImport">class <span class="class-name">fgOpt_UfoFontImport</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgOpt_UfoFontImport options page</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOpt_UfoFontImport-__delattr__" href="#fgOpt_UfoFontImport-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_UfoFontImport-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_UfoFontImport-__getattribute__" href="#fgOpt_UfoFontImport-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_UfoFontImport-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_UfoFontImport-__init__" href="#fgOpt_UfoFontImport-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_UfoFontImport-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_UfoFontImport-__repr__" href="#fgOpt_UfoFontImport-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_UfoFontImport-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_UfoFontImport-__setattr__" href="#fgOpt_UfoFontImport-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_UfoFontImport-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_UfoFontImport-__str__" href="#fgOpt_UfoFontImport-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_UfoFontImport-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>compileFeatures</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>fixOrdering</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>readLayoutTTX</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>removeOverlap</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOpt_UfoFontImport-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOpt_VfbExport" href="#fgOpt_VfbExport">class <span class="class-name">fgOpt_VfbExport</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgOpt_VfbExport options page</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOpt_VfbExport-__delattr__" href="#fgOpt_VfbExport-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_VfbExport-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_VfbExport-__getattribute__" href="#fgOpt_VfbExport-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_VfbExport-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_VfbExport-__init__" href="#fgOpt_VfbExport-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_VfbExport-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_VfbExport-__repr__" href="#fgOpt_VfbExport-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_VfbExport-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_VfbExport-__setattr__" href="#fgOpt_VfbExport-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_VfbExport-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_VfbExport-__str__" href="#fgOpt_VfbExport-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_VfbExport-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>saveEncoding</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOpt_VfbExport-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOpt_VfbImport" href="#fgOpt_VfbImport">class <span class="class-name">fgOpt_VfbImport</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgOpt_VfbImport options page</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOpt_VfbImport-__delattr__" href="#fgOpt_VfbImport-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_VfbImport-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_VfbImport-__getattribute__" href="#fgOpt_VfbImport-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_VfbImport-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_VfbImport-__init__" href="#fgOpt_VfbImport-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_VfbImport-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_VfbImport-__repr__" href="#fgOpt_VfbImport-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_VfbImport-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_VfbImport-__setattr__" href="#fgOpt_VfbImport-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_VfbImport-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_VfbImport-__str__" href="#fgOpt_VfbImport-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_VfbImport-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>autoReplace</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>compileFeatures</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>fixOrdering</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>separateMasters</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOpt_VfbImport-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOpt_WOFFExport" href="#fgOpt_WOFFExport">class <span class="class-name">fgOpt_WOFFExport</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgOpt_WOFFExport options page</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOpt_WOFFExport-__delattr__" href="#fgOpt_WOFFExport-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_WOFFExport-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_WOFFExport-__getattribute__" href="#fgOpt_WOFFExport-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_WOFFExport-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_WOFFExport-__init__" href="#fgOpt_WOFFExport-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_WOFFExport-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_WOFFExport-__repr__" href="#fgOpt_WOFFExport-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_WOFFExport-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_WOFFExport-__setattr__" href="#fgOpt_WOFFExport-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_WOFFExport-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOpt_WOFFExport-__str__" href="#fgOpt_WOFFExport-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOpt_WOFFExport-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>otExport</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOpt_WOFFExport-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOptions" href="#fgOptions">class <span class="class-name">fgOptions</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">FontGate options</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOptions-__delattr__" href="#fgOptions-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOptions-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOptions-__getattribute__" href="#fgOptions-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOptions-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOptions-__init__" href="#fgOptions-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOptions-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOptions-__repr__" href="#fgOptions-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOptions-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOptions-__setattr__" href="#fgOptions-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOptions-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOptions-__str__" href="#fgOptions-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOptions-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>eotexport</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>font</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>otexport</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>otimport</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>t1export</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>t1import</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>ufoexport</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>ufoimport</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>vfbexport</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>vfbimport</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>woffexport</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOptions-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOtInfo" href="#fgOtInfo">class <span class="class-name">fgOtInfo</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">OT Info representation

Constructors:
  fgOtInfo() - default
  fgOtInfo(fgOtInfo) - copy</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOtInfo-__cmp__" href="#fgOtInfo-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOtInfo-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOtInfo-__delattr__" href="#fgOtInfo-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOtInfo-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOtInfo-__getattribute__" href="#fgOtInfo-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOtInfo-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOtInfo-__init__" href="#fgOtInfo-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOtInfo-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOtInfo-__repr__" href="#fgOtInfo-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOtInfo-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOtInfo-__setattr__" href="#fgOtInfo-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOtInfo-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOtInfo-__str__" href="#fgOtInfo-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOtInfo-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>glyphClass</dt>
<dd>

<pre class="doc" markdown="0">('Unspecified'/'Simple'/'Ligature'/'Mark'/'Component')</pre>

</dd>
</dl>
<dl class="descriptor"><dt>markClass</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>otClasses</dt>
<dd>

<pre class="doc" markdown="0">( [ int ] )</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOtInfo-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgOtValue" href="#fgOtValue">class <span class="class-name">fgOtValue</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">OT Value representation

Constructors:
  fgOtValue() - default
  fgOtValue(fgOtValue) - copy
  fgOtValue(float) - by float value
  fgOtValue(int/long) - by int/long value

Math operation:
  fgOtValue + fgOtValue
  fgOtValue - fgOtValue
  fgOtValue * float</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgOtValue-__add__" href="#fgOtValue-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOtValue-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOtValue-__cmp__" href="#fgOtValue-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOtValue-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOtValue-__delattr__" href="#fgOtValue-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOtValue-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOtValue-__getattribute__" href="#fgOtValue-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOtValue-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOtValue-__init__" href="#fgOtValue-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOtValue-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOtValue-__mul__" href="#fgOtValue-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOtValue-__mul__">__mul__</a>(y) <==> x*y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOtValue-__radd__" href="#fgOtValue-__radd__"><span class="function-name">__radd__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOtValue-__radd__">__radd__</a>(y) <==> y+x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOtValue-__repr__" href="#fgOtValue-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOtValue-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOtValue-__rmul__" href="#fgOtValue-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOtValue-__rmul__">__rmul__</a>(y) <==> y*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOtValue-__rsub__" href="#fgOtValue-__rsub__"><span class="function-name">__rsub__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOtValue-__rsub__">__rsub__</a>(y) <==> y-x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOtValue-__setattr__" href="#fgOtValue-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOtValue-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOtValue-__str__" href="#fgOtValue-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOtValue-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgOtValue-__sub__" href="#fgOtValue-__sub__"><span class="function-name">__sub__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgOtValue-__sub__">__sub__</a>(y) <==> x-y</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>coordinate</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>deviceTable</dt>
<dd>

<pre class="doc" markdown="0">(fgDeviceRecords)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>point_index</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgOtValue-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgPackages" href="#fgPackages">class <span class="class-name">fgPackages</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Font packages representation

Constructors:
  fgPackages() - default
  fgPackages(fgPackages) - copy
  fgPackages('pathToFontFileOrFolder')</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgPackages-__add__" href="#fgPackages-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPackages-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-__delattr__" href="#fgPackages-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPackages-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-__delitem__" href="#fgPackages-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPackages-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-__delslice__" href="#fgPackages-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPackages-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-__getattribute__" href="#fgPackages-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPackages-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-__getitem__" href="#fgPackages-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPackages-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-__getslice__" href="#fgPackages-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPackages-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-__init__" href="#fgPackages-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPackages-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-__len__" href="#fgPackages-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPackages-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-__mul__" href="#fgPackages-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPackages-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-__repr__" href="#fgPackages-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPackages-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-__rmul__" href="#fgPackages-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPackages-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-__setattr__" href="#fgPackages-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPackages-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-__setitem__" href="#fgPackages-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPackages-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-__setslice__" href="#fgPackages-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPackages-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-add" href="#fgPackages-add"><span class="function-name">add</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPackages-add">add</a>(<a href="#fgFont">fgFont</a> or <a href="#fgPackages">fgPackages</a> <a href="./__builtin__.html#object">object</a>) - add font(s)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-close" href="#fgPackages-close"><span class="function-name">close</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPackages-close">close</a>() - remove all font(s) from list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-copyFrom" href="#fgPackages-copyFrom"><span class="function-name">copyFrom</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPackages-copyFrom">copyFrom</a>(<a href="#fgPackages">fgPackages</a>) - copy all fonts from another <a href="#fgPackages">fgPackages</a> <a href="./__builtin__.html#object">object</a></pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-create" href="#fgPackages-create"><span class="function-name">create</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPackages-create">create</a>() - add empty font to list and return it's index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-indexOf" href="#fgPackages-indexOf"><span class="function-name">indexOf</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPackages-indexOf">indexOf</a>(<a href="#fgFont">fgFont</a>) - return font index or (-1) if missing in list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-open" href="#fgPackages-open"><span class="function-name">open</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPackages-open">open</a>(path) - open existing font(s) from 'path' location and return first index of created font(s)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPackages-remove" href="#fgPackages-remove"><span class="function-name">remove</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPackages-remove">remove</a>(int index) - remove font by index</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgPackages-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgPen" href="#fgPen">class <span class="class-name">fgPen</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Pen representation

Constructors:
  fgPen(fgGlyph) - default
  fgPen(fgPen) - copy</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgPen-__delattr__" href="#fgPen-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPen-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPen-__getattribute__" href="#fgPen-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPen-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPen-__init__" href="#fgPen-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPen-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPen-__repr__" href="#fgPen-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPen-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPen-__setattr__" href="#fgPen-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPen-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPen-beginPath" href="#fgPen-beginPath"><span class="function-name">beginPath</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPen-beginPath">beginPath</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPen-closePath" href="#fgPen-closePath"><span class="function-name">closePath</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPen-closePath">closePath</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPen-curveTo" href="#fgPen-curveTo"><span class="function-name">curveTo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPen-curveTo">curveTo</a>(<a href="#fgPoint">fgPoint</a>...)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPen-curveToOne" href="#fgPen-curveToOne"><span class="function-name">curveToOne</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPen-curveToOne">curveToOne</a>(<a href="#fgPoint">fgPoint</a>, <a href="#fgPoint">fgPoint</a>, <a href="#fgPoint">fgPoint</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPen-endPath" href="#fgPen-endPath"><span class="function-name">endPath</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPen-endPath">endPath</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPen-lineTo" href="#fgPen-lineTo"><span class="function-name">lineTo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPen-lineTo">lineTo</a>(<a href="#fgPoint">fgPoint</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPen-moveTo" href="#fgPen-moveTo"><span class="function-name">moveTo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPen-moveTo">moveTo</a>(<a href="#fgPoint">fgPoint</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPen-qCurveToOne" href="#fgPen-qCurveToOne"><span class="function-name">qCurveToOne</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPen-qCurveToOne">qCurveToOne</a>(<a href="#fgPoint">fgPoint</a>, <a href="#fgPoint">fgPoint</a>)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>smooth</dt>
<dd>

<pre class="doc" markdown="0">(bool)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgPen-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgPoint" href="#fgPoint">class <span class="class-name">fgPoint</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Point representation

Constructors:
  fgPoint() - default
  fgPoint(fgPoint) - copy
  fgPoint(float x)
  fgPoint(tuple(float x, float y))
  fgPoint(float x, float y)

Math Operations:
  fgPoint + fgPoint
  fgPoint - fgPoint
  fgPoint * fgPoint
  fgPoint * float - vector product
  fgPoint / float
  fgPoint << fgPoint - True if first point is less or equal to second
  fgPoint >> fgPoint - True if first point is greater or equal to second
  fgPoint ^ fgPoint - scalar product</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgPoint-__add__" href="#fgPoint-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__cmp__" href="#fgPoint-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__delattr__" href="#fgPoint-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__delitem__" href="#fgPoint-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__delslice__" href="#fgPoint-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__div__" href="#fgPoint-__div__"><span class="function-name">__div__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__div__">__div__</a>(y) <==> x/y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__eq__" href="#fgPoint-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__ge__" href="#fgPoint-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__getattribute__" href="#fgPoint-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__getitem__" href="#fgPoint-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__getslice__" href="#fgPoint-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__gt__" href="#fgPoint-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__init__" href="#fgPoint-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__le__" href="#fgPoint-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__len__" href="#fgPoint-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__len__">__len__</a>() <==> <a href="#fgPoint-len">len</a>(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__lshift__" href="#fgPoint-__lshift__"><span class="function-name">__lshift__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__lshift__">__lshift__</a>(y) <==> x<<y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__lt__" href="#fgPoint-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__mul__" href="#fgPoint-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__mul__">__mul__</a>(y) <==> x*y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__ne__" href="#fgPoint-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__radd__" href="#fgPoint-__radd__"><span class="function-name">__radd__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__radd__">__radd__</a>(y) <==> y+x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__rdiv__" href="#fgPoint-__rdiv__"><span class="function-name">__rdiv__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__rdiv__">__rdiv__</a>(y) <==> y/x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__repr__" href="#fgPoint-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__rlshift__" href="#fgPoint-__rlshift__"><span class="function-name">__rlshift__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__rlshift__">__rlshift__</a>(y) <==> y<<x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__rmul__" href="#fgPoint-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__rmul__">__rmul__</a>(y) <==> y*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__rrshift__" href="#fgPoint-__rrshift__"><span class="function-name">__rrshift__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__rrshift__">__rrshift__</a>(y) <==> y>>x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__rshift__" href="#fgPoint-__rshift__"><span class="function-name">__rshift__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__rshift__">__rshift__</a>(y) <==> x>>y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__rsub__" href="#fgPoint-__rsub__"><span class="function-name">__rsub__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__rsub__">__rsub__</a>(y) <==> y-x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__rxor__" href="#fgPoint-__rxor__"><span class="function-name">__rxor__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__rxor__">__rxor__</a>(y) <==> y^x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__setattr__" href="#fgPoint-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__setitem__" href="#fgPoint-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__setslice__" href="#fgPoint-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__str__" href="#fgPoint-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__sub__" href="#fgPoint-__sub__"><span class="function-name">__sub__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__sub__">__sub__</a>(y) <==> x-y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-__xor__" href="#fgPoint-__xor__"><span class="function-name">__xor__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPoint-__xor__">__xor__</a>(y) <==> x^y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-angleDiff" href="#fgPoint-angleDiff"><span class="function-name">angleDiff</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgPoint-angleDiff">angleDiff</a>(<a href="#fgPoint">fgPoint</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-angleSum" href="#fgPoint-angleSum"><span class="function-name">angleSum</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgPoint-angleSum">angleSum</a>(<a href="#fgPoint">fgPoint</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-asDict" href="#fgPoint-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-asTuple" href="#fgPoint-asTuple"><span class="function-name">asTuple</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as tuple</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-assign" href="#fgPoint-assign"><span class="function-name">assign</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint-assign">assign</a>(<a href="#fgPoint">fgPoint</a>) or <a href="#fgPoint-assign">assign</a>(float x, float y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-clear" href="#fgPoint-clear"><span class="function-name">clear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint-clear">clear</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-close_to" href="#fgPoint-close_to"><span class="function-name">close_to</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgPoint-close_to">close_to</a>(<a href="#fgPoint">fgPoint</a>[, d=0.00001])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-collinear" href="#fgPoint-collinear"><span class="function-name">collinear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgPoint-collinear">collinear</a>(<a href="#fgPoint">fgPoint</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-direction" href="#fgPoint-direction"><span class="function-name">direction</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgPoint-direction">direction</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-dist" href="#fgPoint-dist"><span class="function-name">dist</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgPoint-dist">dist</a>(<a href="#fgPoint">fgPoint</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-dist2" href="#fgPoint-dist2"><span class="function-name">dist2</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgPoint-dist2">dist2</a>(<a href="#fgPoint">fgPoint</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-distance" href="#fgPoint-distance"><span class="function-name">distance</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgPoint-distance">distance</a>(<a href="#fgPoint">fgPoint</a>[, horizontal=false]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-doubleScale" href="#fgPoint-doubleScale"><span class="function-name">doubleScale</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">scale(<a href="#fgPoint">fgPoint</a>) or scale(float sx, float sy)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-flip" href="#fgPoint-flip"><span class="function-name">flip</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint-flip">flip</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-flipped" href="#fgPoint-flipped"><span class="function-name">flipped</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgPoint-flipped">flipped</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-ix" href="#fgPoint-ix"><span class="function-name">ix</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgPoint-ix">ix</a>() - integer fast</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-iy" href="#fgPoint-iy"><span class="function-name">iy</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgPoint-iy">iy</a>() - integer fast</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-len" href="#fgPoint-len"><span class="function-name">len</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgPoint-len">len</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-len2" href="#fgPoint-len2"><span class="function-name">len2</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgPoint-len2">len2</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-normal" href="#fgPoint-normal"><span class="function-name">normal</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgPoint-normal">normal</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-rotate" href="#fgPoint-rotate"><span class="function-name">rotate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgPoint-rotate">rotate</a>(<a href="#fgPoint">fgPoint</a> v, <a href="#fgPoint">fgPoint</a> c)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-round" href="#fgPoint-round"><span class="function-name">round</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgPoint-round">round</a>([doRound=true])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-rx" href="#fgPoint-rx"><span class="function-name">rx</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgPoint-rx">rx</a>() - integer rounded</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-ry" href="#fgPoint-ry"><span class="function-name">ry</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgPoint-ry">ry</a>() - integer rounded</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-transform" href="#fgPoint-transform"><span class="function-name">transform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint-transform">transform</a>(<a href="#fgMatrix">fgMatrix</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-transformed" href="#fgPoint-transformed"><span class="function-name">transformed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgPoint-transformed">transformed</a>(<a href="#fgMatrix">fgMatrix</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-value" href="#fgPoint-value"><span class="function-name">value</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgPoint-value">value</a>([horizontal=true])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPoint-zero" href="#fgPoint-zero"><span class="function-name">zero</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgPoint-zero">zero</a>()</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>x</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>y</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgPoint-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgPointU" href="#fgPointU">class <span class="class-name">fgPointU</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">PointU representation

Constructors:
  fgPointU() - default
  fgPointU(fgPoint) - copy
  fgPointU(fgPointU) - copy
  fgPointU(fgPoint, float u)
  fgPointU(tuple(float x, float y, float u))
  fgPointU(float x, float y, float u)

Math Operations:
  fgPointU + fgPoint/fgPointU
  fgPointU - fgPoint/fgPointU
  fgPointU * fgPoint/fgPointU
  fgPointU * float - vector product
  fgPointU / float
  fgPointU << fgPointU - True if first point is less or equal to second
  fgPointU >> fgPointU - True if first point is greater or equal to second
  fgPointU ^ fgPointU - scalar product</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgPointU-__add__" href="#fgPointU-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__cmp__" href="#fgPointU-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__delattr__" href="#fgPointU-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__delitem__" href="#fgPointU-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__delslice__" href="#fgPointU-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__div__" href="#fgPointU-__div__"><span class="function-name">__div__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__div__">__div__</a>(y) <==> x/y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__eq__" href="#fgPointU-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__ge__" href="#fgPointU-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__getattribute__" href="#fgPointU-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__getitem__" href="#fgPointU-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__getslice__" href="#fgPointU-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__gt__" href="#fgPointU-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__init__" href="#fgPointU-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__le__" href="#fgPointU-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__len__" href="#fgPointU-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__len__">__len__</a>() <==> <a href="#fgPointU-len">len</a>(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__lshift__" href="#fgPointU-__lshift__"><span class="function-name">__lshift__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__lshift__">__lshift__</a>(y) <==> x<<y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__lt__" href="#fgPointU-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__mul__" href="#fgPointU-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__mul__">__mul__</a>(y) <==> x*y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__ne__" href="#fgPointU-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__radd__" href="#fgPointU-__radd__"><span class="function-name">__radd__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__radd__">__radd__</a>(y) <==> y+x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__rdiv__" href="#fgPointU-__rdiv__"><span class="function-name">__rdiv__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__rdiv__">__rdiv__</a>(y) <==> y/x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__repr__" href="#fgPointU-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__rlshift__" href="#fgPointU-__rlshift__"><span class="function-name">__rlshift__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__rlshift__">__rlshift__</a>(y) <==> y<<x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__rmul__" href="#fgPointU-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__rmul__">__rmul__</a>(y) <==> y*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__rrshift__" href="#fgPointU-__rrshift__"><span class="function-name">__rrshift__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__rrshift__">__rrshift__</a>(y) <==> y>>x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__rshift__" href="#fgPointU-__rshift__"><span class="function-name">__rshift__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__rshift__">__rshift__</a>(y) <==> x>>y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__rsub__" href="#fgPointU-__rsub__"><span class="function-name">__rsub__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__rsub__">__rsub__</a>(y) <==> y-x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__rxor__" href="#fgPointU-__rxor__"><span class="function-name">__rxor__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__rxor__">__rxor__</a>(y) <==> y^x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__setattr__" href="#fgPointU-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__setitem__" href="#fgPointU-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__setslice__" href="#fgPointU-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__str__" href="#fgPointU-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__sub__" href="#fgPointU-__sub__"><span class="function-name">__sub__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__sub__">__sub__</a>(y) <==> x-y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-__xor__" href="#fgPointU-__xor__"><span class="function-name">__xor__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgPointU-__xor__">__xor__</a>(y) <==> x^y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-angleDiff" href="#fgPointU-angleDiff"><span class="function-name">angleDiff</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgPointU-angleDiff">angleDiff</a>(<a href="#fgPoint">fgPoint</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-angleSum" href="#fgPointU-angleSum"><span class="function-name">angleSum</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgPointU-angleSum">angleSum</a>(<a href="#fgPoint">fgPoint</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-asDict" href="#fgPointU-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-asTuple" href="#fgPointU-asTuple"><span class="function-name">asTuple</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as tuple</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-assign" href="#fgPointU-assign"><span class="function-name">assign</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPointU-assign">assign</a>(<a href="#fgPointU">fgPointU</a>) or <a href="#fgPointU-assign">assign</a>(float x, float y, float u)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-clear" href="#fgPointU-clear"><span class="function-name">clear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPointU-clear">clear</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-close_to" href="#fgPointU-close_to"><span class="function-name">close_to</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgPointU-close_to">close_to</a>(<a href="#fgPointU">fgPointU</a>[, d=0.00001])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-collinear" href="#fgPointU-collinear"><span class="function-name">collinear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgPointU-collinear">collinear</a>(<a href="#fgPoint">fgPoint</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-direction" href="#fgPointU-direction"><span class="function-name">direction</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgPointU-direction">direction</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-dist" href="#fgPointU-dist"><span class="function-name">dist</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgPointU-dist">dist</a>(<a href="#fgPoint">fgPoint</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-dist2" href="#fgPointU-dist2"><span class="function-name">dist2</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgPointU-dist2">dist2</a>(<a href="#fgPoint">fgPoint</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-distance" href="#fgPointU-distance"><span class="function-name">distance</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgPointU-distance">distance</a>(<a href="#fgPoint">fgPoint</a>[, horizontal=false]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-doubleScale" href="#fgPointU-doubleScale"><span class="function-name">doubleScale</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">scale(<a href="#fgPoint">fgPoint</a>) or scale(float sx, float sy)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-flip" href="#fgPointU-flip"><span class="function-name">flip</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPointU-flip">flip</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-flipped" href="#fgPointU-flipped"><span class="function-name">flipped</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgPointU-flipped">flipped</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-ix" href="#fgPointU-ix"><span class="function-name">ix</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgPointU-ix">ix</a>() - integer fast</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-iy" href="#fgPointU-iy"><span class="function-name">iy</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgPointU-iy">iy</a>() - integer fast</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-len" href="#fgPointU-len"><span class="function-name">len</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgPointU-len">len</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-len2" href="#fgPointU-len2"><span class="function-name">len2</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgPointU-len2">len2</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-normal" href="#fgPointU-normal"><span class="function-name">normal</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgPointU-normal">normal</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-rotate" href="#fgPointU-rotate"><span class="function-name">rotate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgPointU-rotate">rotate</a>(<a href="#fgPointU">fgPointU</a> v, <a href="#fgPoint">fgPoint</a> c)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-round" href="#fgPointU-round"><span class="function-name">round</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgPointU-round">round</a>([doRound=true])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-rx" href="#fgPointU-rx"><span class="function-name">rx</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgPointU-rx">rx</a>() - integer rounded</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-ry" href="#fgPointU-ry"><span class="function-name">ry</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgPointU-ry">ry</a>() - integer rounded</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-transform" href="#fgPointU-transform"><span class="function-name">transform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPointU-transform">transform</a>(<a href="#fgMatrix">fgMatrix</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-transformed" href="#fgPointU-transformed"><span class="function-name">transformed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgPointU-transformed">transformed</a>(<a href="#fgMatrix">fgMatrix</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-value" href="#fgPointU-value"><span class="function-name">value</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgPointU-value">value</a>([horizontal=true])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgPointU-zero" href="#fgPointU-zero"><span class="function-name">zero</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgPointU-zero">zero</a>()</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>u</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>x</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>y</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgPointU-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgRect" href="#fgRect">class <span class="class-name">fgRect</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Rectangle representation

Constructors:
  fgRect() - default
  fgRect(fgRect) - copy
  fgRect(fgPoint, fgPoint)
  fgRect(fgPoint, fgPoint, bool empty)
  fgRect(float x1, float y1, float x2, float y2)

Math Operations:
  fgRect + fgPoint
  fgRect + fgRect
  fgRect + float
  fgRect - fgPoint
  fgRect - fgRect
  fgRect - float
  fgRect * float
  fgRect / float
  fgRect & fgRect
  fgRect | fgRect</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgRect-__add__" href="#fgRect-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__and__" href="#fgRect-__and__"><span class="function-name">__and__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__and__">__and__</a>(y) <==> x&y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__delattr__" href="#fgRect-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__delitem__" href="#fgRect-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__delslice__" href="#fgRect-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__div__" href="#fgRect-__div__"><span class="function-name">__div__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__div__">__div__</a>(y) <==> x/y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__eq__" href="#fgRect-__eq__"><span class="function-name">__eq__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__eq__">__eq__</a>(y) <==> x==y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__ge__" href="#fgRect-__ge__"><span class="function-name">__ge__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__ge__">__ge__</a>(y) <==> x>=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__getattribute__" href="#fgRect-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__getitem__" href="#fgRect-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__getslice__" href="#fgRect-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__gt__" href="#fgRect-__gt__"><span class="function-name">__gt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__gt__">__gt__</a>(y) <==> x>y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__init__" href="#fgRect-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__le__" href="#fgRect-__le__"><span class="function-name">__le__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__le__">__le__</a>(y) <==> x<=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__len__" href="#fgRect-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__lt__" href="#fgRect-__lt__"><span class="function-name">__lt__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__lt__">__lt__</a>(y) <==> x<y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__mul__" href="#fgRect-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__mul__">__mul__</a>(y) <==> x*y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__ne__" href="#fgRect-__ne__"><span class="function-name">__ne__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__ne__">__ne__</a>(y) <==> x!=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__or__" href="#fgRect-__or__"><span class="function-name">__or__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__or__">__or__</a>(y) <==> x|y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__radd__" href="#fgRect-__radd__"><span class="function-name">__radd__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__radd__">__radd__</a>(y) <==> y+x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__rand__" href="#fgRect-__rand__"><span class="function-name">__rand__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__rand__">__rand__</a>(y) <==> y&x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__rdiv__" href="#fgRect-__rdiv__"><span class="function-name">__rdiv__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__rdiv__">__rdiv__</a>(y) <==> y/x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__repr__" href="#fgRect-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__rmul__" href="#fgRect-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__rmul__">__rmul__</a>(y) <==> y*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__ror__" href="#fgRect-__ror__"><span class="function-name">__ror__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__ror__">__ror__</a>(y) <==> y|x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__rsub__" href="#fgRect-__rsub__"><span class="function-name">__rsub__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__rsub__">__rsub__</a>(y) <==> y-x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__setattr__" href="#fgRect-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__setitem__" href="#fgRect-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__setslice__" href="#fgRect-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__str__" href="#fgRect-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-__sub__" href="#fgRect-__sub__"><span class="function-name">__sub__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRect-__sub__">__sub__</a>(y) <==> x-y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-adjust" href="#fgRect-adjust"><span class="function-name">adjust</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect-adjust">adjust</a>(float x1, float y1, float x2, float y2)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-adjusted" href="#fgRect-adjusted"><span class="function-name">adjusted</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect">fgRect</a> <a href="#fgRect-adjusted">adjusted</a>(float x1, float y1, float x2, float y2)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-asDict" href="#fgRect-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent Py::Object as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-asTuple" href="#fgRect-asTuple"><span class="function-name">asTuple</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent Py::Object as tuple</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-assign" href="#fgRect-assign"><span class="function-name">assign</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect-assign">assign</a>(<a href="#fgPoint">fgPoint</a>, <a href="#fgPoint">fgPoint</a>[, fix=true]) or <a href="#fgRect-assign">assign</a>(float, float, float, float[, fix=true])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-bottom" href="#fgRect-bottom"><span class="function-name">bottom</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgRect-bottom">bottom</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-center" href="#fgRect-center"><span class="function-name">center</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgRect-center">center</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-clear" href="#fgRect-clear"><span class="function-name">clear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect-clear">clear</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-contains" href="#fgRect-contains"><span class="function-name">contains</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgRect-contains">contains</a>(<a href="#fgPoint">fgPoint</a>) or bool <a href="#fgRect-contains">contains</a>(<a href="#fgRect">fgRect</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-containsX" href="#fgRect-containsX"><span class="function-name">containsX</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgRect-containsX">containsX</a>(float)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-containsY" href="#fgRect-containsY"><span class="function-name">containsY</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgRect-containsY">containsY</a>(float)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-diagonal" href="#fgRect-diagonal"><span class="function-name">diagonal</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgRect-diagonal">diagonal</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-empty" href="#fgRect-empty"><span class="function-name">empty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect-empty">empty</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-fix" href="#fgRect-fix"><span class="function-name">fix</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect-fix">fix</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-fix_x" href="#fgRect-fix_x"><span class="function-name">fix_x</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect-fix_x">fix_x</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-fix_y" href="#fgRect-fix_y"><span class="function-name">fix_y</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect-fix_y">fix_y</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-height" href="#fgRect-height"><span class="function-name">height</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgRect-height">height</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-intersects" href="#fgRect-intersects"><span class="function-name">intersects</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgRect-intersects">intersects</a>(<a href="#fgRect">fgRect</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-left" href="#fgRect-left"><span class="function-name">left</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgRect-left">left</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-move" href="#fgRect-move"><span class="function-name">move</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect-move">move</a>(float dx, float dy)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-moved" href="#fgRect-moved"><span class="function-name">moved</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect">fgRect</a> <a href="#fgRect-moved">moved</a>(float dx, float dy)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-right" href="#fgRect-right"><span class="function-name">right</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgRect-right">right</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-setBottom" href="#fgRect-setBottom"><span class="function-name">setBottom</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect-setBottom">setBottom</a>(float)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-setHeight" href="#fgRect-setHeight"><span class="function-name">setHeight</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect-setHeight">setHeight</a>(float)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-setLeft" href="#fgRect-setLeft"><span class="function-name">setLeft</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect-setLeft">setLeft</a>(float)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-setRect" href="#fgRect-setRect"><span class="function-name">setRect</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect-setRect">setRect</a>(int x, int y, int w, int h)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-setRight" href="#fgRect-setRight"><span class="function-name">setRight</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect-setRight">setRight</a>(float)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-setSize" href="#fgRect-setSize"><span class="function-name">setSize</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect-setSize">setSize</a>(<a href="#fgPoint">fgPoint</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-setTop" href="#fgRect-setTop"><span class="function-name">setTop</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect-setTop">setTop</a>(float)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-setWidth" href="#fgRect-setWidth"><span class="function-name">setWidth</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect-setWidth">setWidth</a>(float)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-size" href="#fgRect-size"><span class="function-name">size</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgRect-size">size</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-top" href="#fgRect-top"><span class="function-name">top</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgRect-top">top</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-transform" href="#fgRect-transform"><span class="function-name">transform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect-transform">transform</a>(<a href="#fgMatrix">fgMatrix</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-transformed" href="#fgRect-transformed"><span class="function-name">transformed</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect">fgRect</a> <a href="#fgRect-transformed">transformed</a>(<a href="#fgMatrix">fgMatrix</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-width" href="#fgRect-width"><span class="function-name">width</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgRect-width">width</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRect-zero" href="#fgRect-zero"><span class="function-name">zero</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect-zero">zero</a>()</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>ll</dt>
<dd>

<pre class="doc" markdown="0">(fgPoint) lower left point</pre>

</dd>
</dl>
<dl class="descriptor"><dt>ur</dt>
<dd>

<pre class="doc" markdown="0">(fgPoint) upper right point</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgRect-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgRendered" href="#fgRendered">class <span class="class-name">fgRendered</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgRendered representation</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgRendered-__add__" href="#fgRendered-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRendered-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRendered-__cmp__" href="#fgRendered-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRendered-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRendered-__delattr__" href="#fgRendered-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRendered-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRendered-__delitem__" href="#fgRendered-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRendered-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRendered-__delslice__" href="#fgRendered-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRendered-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRendered-__getattribute__" href="#fgRendered-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRendered-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRendered-__getitem__" href="#fgRendered-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRendered-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRendered-__getslice__" href="#fgRendered-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRendered-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRendered-__init__" href="#fgRendered-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRendered-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRendered-__len__" href="#fgRendered-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRendered-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRendered-__mul__" href="#fgRendered-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRendered-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRendered-__repr__" href="#fgRendered-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRendered-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRendered-__rmul__" href="#fgRendered-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRendered-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRendered-__setattr__" href="#fgRendered-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRendered-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRendered-__setitem__" href="#fgRendered-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRendered-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRendered-__setslice__" href="#fgRendered-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRendered-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRendered-__str__" href="#fgRendered-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgRendered-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRendered-asDict" href="#fgRendered-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="fgRendered-asTuple" href="#fgRendered-asTuple"><span class="function-name">asTuple</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as tuple</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>bitmap</dt>
</dl>
<dl class="descriptor"><dt>metrics</dt>
</dl>
<dl class="descriptor"><dt>position</dt>
</dl>
<dl class="descriptor"><dt>ppm</dt>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgRendered-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgShape" href="#fgShape">class <span class="class-name">fgShape</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Shape representation

Constructors:
  fgShape() - default
  fgShape(fgShape) - copy
  fgShape(fgShape, fgShape, float tx, float ty)
  fgShape(fgShape, fgShape, float tx, float ty, int blend_mode)

Math Operations:
  fgShape + fgShape
  fgShape - fgShape
  fgShape * float</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgShape-__add__" href="#fgShape-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShape-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-__cmp__" href="#fgShape-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShape-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-__delattr__" href="#fgShape-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShape-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-__getattribute__" href="#fgShape-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShape-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-__init__" href="#fgShape-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShape-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-__mul__" href="#fgShape-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShape-__mul__">__mul__</a>(y) <==> x*y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-__radd__" href="#fgShape-__radd__"><span class="function-name">__radd__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShape-__radd__">__radd__</a>(y) <==> y+x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-__repr__" href="#fgShape-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShape-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-__rmul__" href="#fgShape-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShape-__rmul__">__rmul__</a>(y) <==> y*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-__rsub__" href="#fgShape-__rsub__"><span class="function-name">__rsub__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShape-__rsub__">__rsub__</a>(y) <==> y-x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-__setattr__" href="#fgShape-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShape-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-__sub__" href="#fgShape-__sub__"><span class="function-name">__sub__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShape-__sub__">__sub__</a>(y) <==> x-y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-addContour" href="#fgShape-addContour"><span class="function-name">addContour</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgContour">fgContour</a> <a href="#fgShape-addContour">addContour</a>(<a href="#fgContour">fgContour</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-addShape" href="#fgShape-addShape"><span class="function-name">addShape</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgShape-addShape">addShape</a>(<a href="#fgShape">fgShape</a>, int mode) ???</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-applyTransform" href="#fgShape-applyTransform"><span class="function-name">applyTransform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgShape-applyTransform">applyTransform</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-area" href="#fgShape-area"><span class="function-name">area</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgShape-area">area</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-assignStyle" href="#fgShape-assignStyle"><span class="function-name">assignStyle</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgShape-assignStyle">assignStyle</a>(<a href="#fgShape">fgShape</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-autoInterpolated" href="#fgShape-autoInterpolated"><span class="function-name">autoInterpolated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgShape-autoInterpolated">autoInterpolated</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-autoSmooth" href="#fgShape-autoSmooth"><span class="function-name">autoSmooth</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgShape-autoSmooth">autoSmooth</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-boundingBox" href="#fgShape-boundingBox"><span class="function-name">boundingBox</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect">fgRect</a>/Nothing <a href="#fgShape-boundingBox">boundingBox</a>(<a href="#fgMatrix">fgMatrix</a>[, bool prepareExport=false])</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-checkContours" href="#fgShape-checkContours"><span class="function-name">checkContours</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgShape-checkContours">checkContours</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-containsOffPoint" href="#fgShape-containsOffPoint"><span class="function-name">containsOffPoint</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgShape-containsOffPoint">containsOffPoint</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-countContours" href="#fgShape-countContours"><span class="function-name">countContours</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgShape-countContours">countContours</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-countNodes" href="#fgShape-countNodes"><span class="function-name">countNodes</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgShape-countNodes">countNodes</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-excludeShape" href="#fgShape-excludeShape"><span class="function-name">excludeShape</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgShape-excludeShape">excludeShape</a>(<a href="#fgShape">fgShape</a>, int mode) ???</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-hasBody" href="#fgShape-hasBody"><span class="function-name">hasBody</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgShape-hasBody">hasBody</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-hasContours" href="#fgShape-hasContours"><span class="function-name">hasContours</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgShape-hasContours">hasContours</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-isCompatible" href="#fgShape-isCompatible"><span class="function-name">isCompatible</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool/Nothing <a href="#fgShape-isCompatible">isCompatible</a>(<a href="#fgShape">fgShape</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-removeOverlap" href="#fgShape-removeOverlap"><span class="function-name">removeOverlap</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgShape-removeOverlap">removeOverlap</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-reverse" href="#fgShape-reverse"><span class="function-name">reverse</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgShape-reverse">reverse</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-sortContours" href="#fgShape-sortContours"><span class="function-name">sortContours</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgShape-sortContours">sortContours</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-subtractShape" href="#fgShape-subtractShape"><span class="function-name">subtractShape</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgShape-subtractShape">subtractShape</a>(<a href="#fgShape">fgShape</a>, int mode) ???</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShape-transform" href="#fgShape-transform"><span class="function-name">transform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgShape-transform">transform</a>(<a href="#fgMatrix">fgMatrix</a>)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>angle</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>body</dt>
<dd>

<pre class="doc" markdown="0">(fgBrush)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>calligraphic</dt>
<dd>

<pre class="doc" markdown="0">(bool)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>cap_type</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>contours</dt>
<dd>

<pre class="doc" markdown="0">(fgContours)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>join_type</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>matrix</dt>
<dd>

<pre class="doc" markdown="0">(fgMatrix)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">(string)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>opacity</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>pen</dt>
<dd>

<pre class="doc" markdown="0">(fgBrush)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>picture</dt>
<dd>

<pre class="doc" markdown="0">(fgBitmap)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>width</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgShape-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgShapes" href="#fgShapes">class <span class="class-name">fgShapes</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgShape objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgShapes-__add__" href="#fgShapes-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShapes-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShapes-__cmp__" href="#fgShapes-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShapes-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShapes-__delattr__" href="#fgShapes-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShapes-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShapes-__delitem__" href="#fgShapes-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShapes-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShapes-__delslice__" href="#fgShapes-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShapes-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShapes-__getattribute__" href="#fgShapes-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShapes-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShapes-__getitem__" href="#fgShapes-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShapes-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShapes-__getslice__" href="#fgShapes-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShapes-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShapes-__init__" href="#fgShapes-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShapes-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShapes-__len__" href="#fgShapes-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShapes-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShapes-__mul__" href="#fgShapes-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShapes-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShapes-__repr__" href="#fgShapes-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShapes-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShapes-__rmul__" href="#fgShapes-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShapes-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShapes-__setattr__" href="#fgShapes-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShapes-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShapes-__setitem__" href="#fgShapes-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShapes-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShapes-__setslice__" href="#fgShapes-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgShapes-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgShapes-append" href="#fgShapes-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgShapes-asList" href="#fgShapes-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgShapes-clean" href="#fgShapes-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgShapes-del" href="#fgShapes-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgShapes-insert" href="#fgShapes-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgShapes-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgStem" href="#fgStem">class <span class="class-name">fgStem</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Stem representation

Constructors:
  fgStem() - default
  fgStem(fgStem) - copy
  fgStem(float)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgStem-__cmp__" href="#fgStem-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStem-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStem-__delattr__" href="#fgStem-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStem-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStem-__getattribute__" href="#fgStem-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStem-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStem-__init__" href="#fgStem-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStem-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStem-__repr__" href="#fgStem-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStem-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStem-__setattr__" href="#fgStem-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStem-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStem-__str__" href="#fgStem-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStem-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStem-clear" href="#fgStem-clear"><span class="function-name">clear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgStem-clear">clear</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStem-fillProgram" href="#fgStem-fillProgram"><span class="function-name">fillProgram</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(int) <a href="#fgStem-fillProgram">fillProgram</a>(float upm)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStem-ppm" href="#fgStem-ppm"><span class="function-name">ppm</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgStem-ppm">ppm</a>(float upm, int k)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStem-setProgram" href="#fgStem-setProgram"><span class="function-name">setProgram</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgStem-setProgram">setProgram</a>(int k, int ppm, bool keepValues)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">(string)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>program</dt>
<dd>

<pre class="doc" markdown="0">( dict(int:int) )</pre>

</dd>
</dl>
<dl class="descriptor"><dt>value</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgStem-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgStems" href="#fgStems">class <span class="class-name">fgStems</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgStem objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgStems-__add__" href="#fgStems-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStems-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStems-__cmp__" href="#fgStems-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStems-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStems-__delattr__" href="#fgStems-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStems-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStems-__delitem__" href="#fgStems-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStems-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStems-__delslice__" href="#fgStems-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStems-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStems-__getattribute__" href="#fgStems-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStems-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStems-__getitem__" href="#fgStems-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStems-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStems-__getslice__" href="#fgStems-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStems-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStems-__init__" href="#fgStems-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStems-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStems-__len__" href="#fgStems-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStems-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStems-__mul__" href="#fgStems-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStems-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStems-__repr__" href="#fgStems-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStems-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStems-__rmul__" href="#fgStems-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStems-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStems-__setattr__" href="#fgStems-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStems-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStems-__setitem__" href="#fgStems-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStems-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStems-__setslice__" href="#fgStems-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStems-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStems-append" href="#fgStems-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgStems-append">append</a>(item) or <a href="#fgStems-append">append</a>( list(item) ) - add items to the end of the list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStems-asList" href="#fgStems-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(items) <a href="#fgStems-asList">asList</a>() - get items as list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStems-clean" href="#fgStems-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgStems-clean">clean</a>() - delete all items</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStems-del" href="#fgStems-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgStems-del">del</a>(index) - delete item by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStems-insert" href="#fgStems-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgStems-insert">insert</a>(position, item) - insert item into list at specified position</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgStems-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgStringDict" href="#fgStringDict">class <span class="class-name">fgStringDict</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">string dictionary</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgStringDict-__add__" href="#fgStringDict-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStringDict-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStringDict-__cmp__" href="#fgStringDict-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStringDict-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStringDict-__delattr__" href="#fgStringDict-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStringDict-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStringDict-__delitem__" href="#fgStringDict-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStringDict-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStringDict-__delslice__" href="#fgStringDict-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStringDict-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStringDict-__getattribute__" href="#fgStringDict-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStringDict-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStringDict-__getitem__" href="#fgStringDict-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStringDict-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStringDict-__getslice__" href="#fgStringDict-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStringDict-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStringDict-__init__" href="#fgStringDict-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStringDict-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStringDict-__len__" href="#fgStringDict-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStringDict-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStringDict-__mul__" href="#fgStringDict-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStringDict-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStringDict-__repr__" href="#fgStringDict-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStringDict-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStringDict-__rmul__" href="#fgStringDict-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStringDict-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStringDict-__setattr__" href="#fgStringDict-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStringDict-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStringDict-__setitem__" href="#fgStringDict-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStringDict-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStringDict-__setslice__" href="#fgStringDict-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgStringDict-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgStringDict-asDict" href="#fgStringDict-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgStringDict-del" href="#fgStringDict-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgStringDict-has_key" href="#fgStringDict-has_key"><span class="function-name">has_key</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgStringDict-keys" href="#fgStringDict-keys"><span class="function-name">keys</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgStringDict-value" href="#fgStringDict-value"><span class="function-name">value</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgStringDict-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgTTInterpreter" href="#fgTTInterpreter">class <span class="class-name">fgTTInterpreter</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">TTInterpreter representation

Constructors:
  fgTTInterpreter() - default
  fgTTInterpreter(fgTTInterpreter) - copy</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgTTInterpreter-__delattr__" href="#fgTTInterpreter-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTTInterpreter-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTTInterpreter-__getattribute__" href="#fgTTInterpreter-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTTInterpreter-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTTInterpreter-__init__" href="#fgTTInterpreter-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTTInterpreter-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTTInterpreter-__repr__" href="#fgTTInterpreter-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTTInterpreter-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTTInterpreter-__setattr__" href="#fgTTInterpreter-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTTInterpreter-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTTInterpreter-__str__" href="#fgTTInterpreter-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTTInterpreter-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgTTInterpreter-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgTrueTypeData" href="#fgTrueTypeData">class <span class="class-name">fgTrueTypeData</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">TrueTypeData representation

Constructors:
  fgTrueTypeData() - default
  fgTrueTypeData(fgTrueTypeData) - copy</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgTrueTypeData-OK" href="#fgTrueTypeData-OK"><span class="function-name">OK</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgTrueTypeData-OK">OK</a>() - return true if status is gdsOK</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-__cmp__" href="#fgTrueTypeData-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypeData-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-__delattr__" href="#fgTrueTypeData-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypeData-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-__getattribute__" href="#fgTrueTypeData-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypeData-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-__init__" href="#fgTrueTypeData-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypeData-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-__repr__" href="#fgTrueTypeData-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypeData-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-__setattr__" href="#fgTrueTypeData-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypeData-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-bad" href="#fgTrueTypeData-bad"><span class="function-name">bad</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgTrueTypeData-bad">bad</a>() - return true if status isn't gdsOK</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-bottomSideBearing" href="#fgTrueTypeData-bottomSideBearing"><span class="function-name">bottomSideBearing</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgTrueTypeData-bottomSideBearing">bottomSideBearing</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-boundingBox" href="#fgTrueTypeData-boundingBox"><span class="function-name">boundingBox</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect">fgRect</a> <a href="#fgTrueTypeData-boundingBox">boundingBox</a>(<a href="#fgGlyphsR">fgGlyphsR</a>, <a href="#fgMatrix">fgMatrix</a>, bool prepareExport) - calculate bounding box</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-clearImports" href="#fgTrueTypeData-clearImports"><span class="function-name">clearImports</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgTrueTypeData-clearImports">clearImports</a>() - clear instructions and hdmx, set yPels = 1</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-copy" href="#fgTrueTypeData-copy"><span class="function-name">copy</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgTrueTypeData">fgTrueTypeData</a> <a href="#fgTrueTypeData-copy">copy</a>() - create alone copy of data</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-countPictures" href="#fgTrueTypeData-countPictures"><span class="function-name">countPictures</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgTrueTypeData-countPictures">countPictures</a>() - return pictures count</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-empty" href="#fgTrueTypeData-empty"><span class="function-name">empty</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgTrueTypeData-empty">empty</a>() - return true if state == sEmpty or no endpoints present</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-getFontGateData" href="#fgTrueTypeData-getFontGateData"><span class="function-name">getFontGateData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgFontGateData">fgFontGateData</a> <a href="#fgTrueTypeData-getFontGateData">getFontGateData</a>() - return Nothing</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-getType" href="#fgTrueTypeData-getType"><span class="function-name">getType</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">string <a href="#fgTrueTypeData-getType">getType</a>() - return 'dtTrueType'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-hasBody" href="#fgTrueTypeData-hasBody"><span class="function-name">hasBody</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgTrueTypeData-hasBody">hasBody</a>(bool prepareExport) - return true if non-empty body layer is present</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-hasColors" href="#fgTrueTypeData-hasColors"><span class="function-name">hasColors</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgTrueTypeData-hasColors">hasColors</a>() - return true if colors is present</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-hasHints" href="#fgTrueTypeData-hasHints"><span class="function-name">hasHints</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgTrueTypeData-hasHints">hasHints</a>() - return true if hints is present</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-hasPictures" href="#fgTrueTypeData-hasPictures"><span class="function-name">hasPictures</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgTrueTypeData-hasPictures">hasPictures</a>() - return true if pictures is present</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-modified" href="#fgTrueTypeData-modified"><span class="function-name">modified</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgTrueTypeData-modified">modified</a>() - return true if data was changed</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-rightSideBearing" href="#fgTrueTypeData-rightSideBearing"><span class="function-name">rightSideBearing</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgTrueTypeData-rightSideBearing">rightSideBearing</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-setParent" href="#fgTrueTypeData-setParent"><span class="function-name">setParent</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgTrueTypeData-setParent">setParent</a>(<a href="#fgGlyph">fgGlyph</a>) - set parent glyph</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-status" href="#fgTrueTypeData-status"><span class="function-name">status</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">'gdsOK'/'gdsInvalid' <a href="#fgTrueTypeData-status">status</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-transform" href="#fgTrueTypeData-transform"><span class="function-name">transform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgTrueTypeData-transform">transform</a>(<a href="#fgMatrix">fgMatrix</a>) - transform data</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-updateBoundingBox" href="#fgTrueTypeData-updateBoundingBox"><span class="function-name">updateBoundingBox</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgTrueTypeData-updateBoundingBox">updateBoundingBox</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-updated" href="#fgTrueTypeData-updated"><span class="function-name">updated</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgTrueTypeData-updated">updated</a>() - mark data as changed, reset internal caches</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-valid" href="#fgTrueTypeData-valid"><span class="function-name">valid</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgTrueTypeData-valid">valid</a>() - return true if state == sValid | sDecomposed</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-xExtent" href="#fgTrueTypeData-xExtent"><span class="function-name">xExtent</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgTrueTypeData-xExtent">xExtent</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypeData-yExtent" href="#fgTrueTypeData-yExtent"><span class="function-name">yExtent</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fgTrueTypeData-yExtent">yExtent</a>()</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>advanceHeight</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>advanceWidth</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>endpoint</dt>
<dd>

<pre class="doc" markdown="0">([int])</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hdmx</dt>
<dd>

<pre class="doc" markdown="0">(fgHdmx)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>instructions</dt>
<dd>

<pre class="doc" markdown="0">(fgBuffer)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>leftSideBearing</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>points</dt>
<dd>

<pre class="doc" markdown="0">(fgTrueTypePoints)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>pointsMap</dt>
<dd>

<pre class="doc" markdown="0">({ 'name': int value })</pre>

</dd>
</dl>
<dl class="descriptor"><dt>topSideBearing</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>xMax</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>xMin</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>yMax</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>yMin</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>yPels</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgTrueTypeData-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgTrueTypePoint" href="#fgTrueTypePoint">class <span class="class-name">fgTrueTypePoint</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">TrueType Point representation

Constructors:
  fgTrueTypePoint() - default
  fgTrueTypePoint(fgTrueTypePoint) - copy
  fgTrueTypePoint(fgPoint)
  fgTrueTypePoint(bool on, int x, int y)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgTrueTypePoint-__add__" href="#fgTrueTypePoint-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoint-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-__cmp__" href="#fgTrueTypePoint-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoint-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-__delattr__" href="#fgTrueTypePoint-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoint-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-__delitem__" href="#fgTrueTypePoint-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoint-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-__delslice__" href="#fgTrueTypePoint-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoint-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-__getattribute__" href="#fgTrueTypePoint-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoint-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-__getitem__" href="#fgTrueTypePoint-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoint-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-__getslice__" href="#fgTrueTypePoint-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoint-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-__init__" href="#fgTrueTypePoint-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoint-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-__len__" href="#fgTrueTypePoint-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoint-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-__mul__" href="#fgTrueTypePoint-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoint-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-__repr__" href="#fgTrueTypePoint-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoint-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-__rmul__" href="#fgTrueTypePoint-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoint-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-__setattr__" href="#fgTrueTypePoint-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoint-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-__setitem__" href="#fgTrueTypePoint-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoint-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-__setslice__" href="#fgTrueTypePoint-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoint-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-__str__" href="#fgTrueTypePoint-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoint-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-asDict" href="#fgTrueTypePoint-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-asTuple" href="#fgTrueTypePoint-asTuple"><span class="function-name">asTuple</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as tuple</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-assign" href="#fgTrueTypePoint-assign"><span class="function-name">assign</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgTrueTypePoint-assign">assign</a>(int x, int y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-onCurve" href="#fgTrueTypePoint-onCurve"><span class="function-name">onCurve</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgTrueTypePoint-onCurve">onCurve</a>() or <a href="#fgTrueTypePoint-onCurve">onCurve</a>(bool value)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-repeat" href="#fgTrueTypePoint-repeat"><span class="function-name">repeat</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgTrueTypePoint-repeat">repeat</a>()  or <a href="#fgTrueTypePoint-repeat">repeat</a>(bool value)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-touched" href="#fgTrueTypePoint-touched"><span class="function-name">touched</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgTrueTypePoint-touched">touched</a>() or <a href="#fgTrueTypePoint-touched">touched</a>(bool value)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-xSame" href="#fgTrueTypePoint-xSame"><span class="function-name">xSame</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgTrueTypePoint-xSame">xSame</a>()   or <a href="#fgTrueTypePoint-xSame">xSame</a>(bool value)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-xShort" href="#fgTrueTypePoint-xShort"><span class="function-name">xShort</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgTrueTypePoint-xShort">xShort</a>()  or <a href="#fgTrueTypePoint-xShort">xShort</a>(bool value)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-ySame" href="#fgTrueTypePoint-ySame"><span class="function-name">ySame</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgTrueTypePoint-ySame">ySame</a>()   or <a href="#fgTrueTypePoint-ySame">ySame</a>(bool value)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoint-yShort" href="#fgTrueTypePoint-yShort"><span class="function-name">yShort</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgTrueTypePoint-yShort">yShort</a>()  or <a href="#fgTrueTypePoint-yShort">yShort</a>(bool value)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>flag</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>x</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>y</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgTrueTypePoint-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgTrueTypePoints" href="#fgTrueTypePoints">class <span class="class-name">fgTrueTypePoints</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgTrueTypePoint objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgTrueTypePoints-__add__" href="#fgTrueTypePoints-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoints-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoints-__cmp__" href="#fgTrueTypePoints-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoints-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoints-__delattr__" href="#fgTrueTypePoints-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoints-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoints-__delitem__" href="#fgTrueTypePoints-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoints-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoints-__delslice__" href="#fgTrueTypePoints-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoints-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoints-__getattribute__" href="#fgTrueTypePoints-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoints-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoints-__getitem__" href="#fgTrueTypePoints-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoints-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoints-__getslice__" href="#fgTrueTypePoints-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoints-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoints-__init__" href="#fgTrueTypePoints-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoints-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoints-__len__" href="#fgTrueTypePoints-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoints-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoints-__mul__" href="#fgTrueTypePoints-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoints-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoints-__repr__" href="#fgTrueTypePoints-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoints-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoints-__rmul__" href="#fgTrueTypePoints-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoints-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoints-__setattr__" href="#fgTrueTypePoints-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoints-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoints-__setitem__" href="#fgTrueTypePoints-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoints-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoints-__setslice__" href="#fgTrueTypePoints-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgTrueTypePoints-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoints-append" href="#fgTrueTypePoints-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgTrueTypePoints-append">append</a>(item) or <a href="#fgTrueTypePoints-append">append</a>( list(item) ) - add items to the end of the list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoints-asList" href="#fgTrueTypePoints-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(items) <a href="#fgTrueTypePoints-asList">asList</a>() - get items as list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoints-clean" href="#fgTrueTypePoints-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgTrueTypePoints-clean">clean</a>() - delete all items</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoints-del" href="#fgTrueTypePoints-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgTrueTypePoints-del">del</a>(index) - delete item by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgTrueTypePoints-insert" href="#fgTrueTypePoints-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgTrueTypePoints-insert">insert</a>(position, item) - insert item into list at specified position</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgTrueTypePoints-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgValuesDict" href="#fgValuesDict">class <span class="class-name">fgValuesDict</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">float values dictionary</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgValuesDict-__add__" href="#fgValuesDict-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgValuesDict-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgValuesDict-__cmp__" href="#fgValuesDict-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgValuesDict-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgValuesDict-__delattr__" href="#fgValuesDict-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgValuesDict-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgValuesDict-__delitem__" href="#fgValuesDict-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgValuesDict-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgValuesDict-__delslice__" href="#fgValuesDict-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgValuesDict-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgValuesDict-__getattribute__" href="#fgValuesDict-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgValuesDict-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgValuesDict-__getitem__" href="#fgValuesDict-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgValuesDict-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgValuesDict-__getslice__" href="#fgValuesDict-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgValuesDict-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgValuesDict-__init__" href="#fgValuesDict-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgValuesDict-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgValuesDict-__len__" href="#fgValuesDict-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgValuesDict-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgValuesDict-__mul__" href="#fgValuesDict-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgValuesDict-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgValuesDict-__repr__" href="#fgValuesDict-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgValuesDict-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgValuesDict-__rmul__" href="#fgValuesDict-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgValuesDict-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgValuesDict-__setattr__" href="#fgValuesDict-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgValuesDict-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgValuesDict-__setitem__" href="#fgValuesDict-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgValuesDict-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgValuesDict-__setslice__" href="#fgValuesDict-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgValuesDict-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgValuesDict-asDict" href="#fgValuesDict-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgValuesDict-del" href="#fgValuesDict-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgValuesDict-has_key" href="#fgValuesDict-has_key"><span class="function-name">has_key</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgValuesDict-keys" href="#fgValuesDict-keys"><span class="function-name">keys</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>
<dl class="function"><dt><a name="fgValuesDict-value" href="#fgValuesDict-value"><span class="function-name">value</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"></pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgValuesDict-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgVdmxRecord" href="#fgVdmxRecord">class <span class="class-name">fgVdmxRecord</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">fgVdmxRecord representation</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgVdmxRecord-__add__" href="#fgVdmxRecord-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecord-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecord-__cmp__" href="#fgVdmxRecord-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecord-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecord-__delattr__" href="#fgVdmxRecord-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecord-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecord-__delitem__" href="#fgVdmxRecord-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecord-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecord-__delslice__" href="#fgVdmxRecord-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecord-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecord-__getattribute__" href="#fgVdmxRecord-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecord-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecord-__getitem__" href="#fgVdmxRecord-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecord-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecord-__getslice__" href="#fgVdmxRecord-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecord-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecord-__init__" href="#fgVdmxRecord-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecord-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecord-__len__" href="#fgVdmxRecord-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecord-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecord-__mul__" href="#fgVdmxRecord-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecord-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecord-__repr__" href="#fgVdmxRecord-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecord-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecord-__rmul__" href="#fgVdmxRecord-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecord-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecord-__setattr__" href="#fgVdmxRecord-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecord-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecord-__setitem__" href="#fgVdmxRecord-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecord-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecord-__setslice__" href="#fgVdmxRecord-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecord-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecord-__str__" href="#fgVdmxRecord-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecord-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecord-asDict" href="#fgVdmxRecord-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecord-asTuple" href="#fgVdmxRecord-asTuple"><span class="function-name">asTuple</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as tuple</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>yMax</dt>
</dl>
<dl class="descriptor"><dt>yMin</dt>
</dl>
<dl class="descriptor"><dt>yPelHeight</dt>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgVdmxRecord-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgVdmxRecords" href="#fgVdmxRecords">class <span class="class-name">fgVdmxRecords</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgVdmxRecord objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgVdmxRecords-__add__" href="#fgVdmxRecords-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecords-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecords-__cmp__" href="#fgVdmxRecords-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecords-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecords-__delattr__" href="#fgVdmxRecords-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecords-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecords-__delitem__" href="#fgVdmxRecords-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecords-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecords-__delslice__" href="#fgVdmxRecords-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecords-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecords-__getattribute__" href="#fgVdmxRecords-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecords-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecords-__getitem__" href="#fgVdmxRecords-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecords-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecords-__getslice__" href="#fgVdmxRecords-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecords-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecords-__init__" href="#fgVdmxRecords-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecords-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecords-__len__" href="#fgVdmxRecords-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecords-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecords-__mul__" href="#fgVdmxRecords-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecords-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecords-__repr__" href="#fgVdmxRecords-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecords-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecords-__rmul__" href="#fgVdmxRecords-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecords-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecords-__setattr__" href="#fgVdmxRecords-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecords-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecords-__setitem__" href="#fgVdmxRecords-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecords-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecords-__setslice__" href="#fgVdmxRecords-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVdmxRecords-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecords-append" href="#fgVdmxRecords-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVdmxRecords-append">append</a>(item) or <a href="#fgVdmxRecords-append">append</a>( list(item) ) - add items to the end of the list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecords-asList" href="#fgVdmxRecords-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(items) <a href="#fgVdmxRecords-asList">asList</a>() - get items as list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecords-clean" href="#fgVdmxRecords-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVdmxRecords-clean">clean</a>() - delete all items</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecords-del" href="#fgVdmxRecords-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVdmxRecords-del">del</a>(index) - delete item by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVdmxRecords-insert" href="#fgVdmxRecords-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVdmxRecords-insert">insert</a>(position, item) - insert item into list at specified position</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgVdmxRecords-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgVector" href="#fgVector">class <span class="class-name">fgVector</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Vector representation

Constructors:
  fgVector() - default
  fgVector(fgVector) - copy
  fgVector(fgPoint q0[, fgPoint q1]) - from one or two points
  fgVector(fgPoint, float l, float a)</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgVector-__cmp__" href="#fgVector-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVector-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-__delattr__" href="#fgVector-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVector-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-__getattribute__" href="#fgVector-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVector-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-__init__" href="#fgVector-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVector-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-__repr__" href="#fgVector-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVector-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-__setattr__" href="#fgVector-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVector-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-__str__" href="#fgVector-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVector-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-angle" href="#fgVector-angle"><span class="function-name">angle</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgVector-angle">angle</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-angleTo" href="#fgVector-angleTo"><span class="function-name">angleTo</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgVector-angleTo">angleTo</a>(<a href="#fgVector">fgVector</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-asDict" href="#fgVector-asDict"><span class="function-name">asDict</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as dictionary</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-asTuple" href="#fgVector-asTuple"><span class="function-name">asTuple</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">represent <a href="./__builtin__.html#object">object</a> as tuple</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-bbox" href="#fgVector-bbox"><span class="function-name">bbox</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgRect">fgRect</a> <a href="#fgVector-bbox">bbox</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-center" href="#fgVector-center"><span class="function-name">center</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgVector-center">center</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-delta" href="#fgVector-delta"><span class="function-name">delta</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgVector-delta">delta</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-direction" href="#fgVector-direction"><span class="function-name">direction</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgVector-direction">direction</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-equivalent" href="#fgVector-equivalent"><span class="function-name">equivalent</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgVector-equivalent">equivalent</a>(<a href="#fgVector">fgVector</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-intersect" href="#fgVector-intersect"><span class="function-name">intersect</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a>/None <a href="#fgVector-intersect">intersect</a>(<a href="#fgVector">fgVector</a>) or (<a href="#fgPoint">fgPoint</a>, t)/None <a href="#fgVector-intersect">intersect</a>(<a href="#fgVector">fgVector</a>, bool get_t)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-intersectY" href="#fgVector-intersectY"><span class="function-name">intersectY</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float/None <a href="#fgVector-intersectY">intersectY</a>(float pos)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-len" href="#fgVector-len"><span class="function-name">len</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgVector-len">len</a>() - distance between q0 and q1</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-parallel" href="#fgVector-parallel"><span class="function-name">parallel</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fgVector-parallel">parallel</a>(<a href="#fgVector">fgVector</a>)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-point" href="#fgVector-point"><span class="function-name">point</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgPoint">fgPoint</a> <a href="#fgVector-point">point</a>(float time)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVector-time" href="#fgVector-time"><span class="function-name">time</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgVector-time">time</a>(<a href="#fgPoint">fgPoint</a>)</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>q0</dt>
<dd>

<pre class="doc" markdown="0">(fgPoint)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>q1</dt>
<dd>

<pre class="doc" markdown="0">(fgPoint)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgVector-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgVectorBool" href="#fgVectorBool">class <span class="class-name">fgVectorBool</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">[char] vector</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgVectorBool-__add__" href="#fgVectorBool-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorBool-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorBool-__cmp__" href="#fgVectorBool-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorBool-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorBool-__delattr__" href="#fgVectorBool-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorBool-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorBool-__delitem__" href="#fgVectorBool-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorBool-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorBool-__delslice__" href="#fgVectorBool-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorBool-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorBool-__getattribute__" href="#fgVectorBool-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorBool-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorBool-__getitem__" href="#fgVectorBool-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorBool-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorBool-__getslice__" href="#fgVectorBool-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorBool-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorBool-__init__" href="#fgVectorBool-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorBool-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorBool-__len__" href="#fgVectorBool-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorBool-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorBool-__mul__" href="#fgVectorBool-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorBool-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorBool-__repr__" href="#fgVectorBool-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorBool-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorBool-__rmul__" href="#fgVectorBool-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorBool-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorBool-__setattr__" href="#fgVectorBool-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorBool-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorBool-__setitem__" href="#fgVectorBool-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorBool-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorBool-__setslice__" href="#fgVectorBool-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorBool-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorBool-append" href="#fgVectorBool-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorBool-append">append</a>(item) or <a href="#fgVectorBool-append">append</a>( list(item) ) - add items to the end of the list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorBool-asList" href="#fgVectorBool-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(items) <a href="#fgVectorBool-asList">asList</a>() - get items as list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorBool-clean" href="#fgVectorBool-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorBool-clean">clean</a>() - delete all items</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorBool-del" href="#fgVectorBool-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorBool-del">del</a>(index) - delete item by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorBool-insert" href="#fgVectorBool-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorBool-insert">insert</a>(position, item) - insert item into list at specified position</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgVectorBool-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgVectorChar" href="#fgVectorChar">class <span class="class-name">fgVectorChar</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">[char] vector</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgVectorChar-__add__" href="#fgVectorChar-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorChar-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorChar-__cmp__" href="#fgVectorChar-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorChar-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorChar-__delattr__" href="#fgVectorChar-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorChar-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorChar-__delitem__" href="#fgVectorChar-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorChar-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorChar-__delslice__" href="#fgVectorChar-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorChar-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorChar-__getattribute__" href="#fgVectorChar-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorChar-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorChar-__getitem__" href="#fgVectorChar-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorChar-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorChar-__getslice__" href="#fgVectorChar-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorChar-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorChar-__init__" href="#fgVectorChar-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorChar-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorChar-__len__" href="#fgVectorChar-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorChar-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorChar-__mul__" href="#fgVectorChar-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorChar-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorChar-__repr__" href="#fgVectorChar-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorChar-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorChar-__rmul__" href="#fgVectorChar-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorChar-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorChar-__setattr__" href="#fgVectorChar-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorChar-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorChar-__setitem__" href="#fgVectorChar-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorChar-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorChar-__setslice__" href="#fgVectorChar-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorChar-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorChar-append" href="#fgVectorChar-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorChar-append">append</a>(item) or <a href="#fgVectorChar-append">append</a>( list(item) ) - add items to the end of the list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorChar-asList" href="#fgVectorChar-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(items) <a href="#fgVectorChar-asList">asList</a>() - get items as list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorChar-clean" href="#fgVectorChar-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorChar-clean">clean</a>() - delete all items</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorChar-del" href="#fgVectorChar-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorChar-del">del</a>(index) - delete item by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorChar-insert" href="#fgVectorChar-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorChar-insert">insert</a>(position, item) - insert item into list at specified position</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgVectorChar-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgVectorDouble" href="#fgVectorDouble">class <span class="class-name">fgVectorDouble</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">[double] vector</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgVectorDouble-__add__" href="#fgVectorDouble-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorDouble-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorDouble-__cmp__" href="#fgVectorDouble-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorDouble-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorDouble-__delattr__" href="#fgVectorDouble-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorDouble-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorDouble-__delitem__" href="#fgVectorDouble-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorDouble-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorDouble-__delslice__" href="#fgVectorDouble-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorDouble-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorDouble-__getattribute__" href="#fgVectorDouble-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorDouble-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorDouble-__getitem__" href="#fgVectorDouble-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorDouble-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorDouble-__getslice__" href="#fgVectorDouble-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorDouble-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorDouble-__init__" href="#fgVectorDouble-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorDouble-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorDouble-__len__" href="#fgVectorDouble-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorDouble-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorDouble-__mul__" href="#fgVectorDouble-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorDouble-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorDouble-__repr__" href="#fgVectorDouble-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorDouble-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorDouble-__rmul__" href="#fgVectorDouble-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorDouble-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorDouble-__setattr__" href="#fgVectorDouble-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorDouble-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorDouble-__setitem__" href="#fgVectorDouble-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorDouble-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorDouble-__setslice__" href="#fgVectorDouble-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorDouble-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorDouble-append" href="#fgVectorDouble-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorDouble-append">append</a>(item) or <a href="#fgVectorDouble-append">append</a>( list(item) ) - add items to the end of the list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorDouble-asList" href="#fgVectorDouble-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(items) <a href="#fgVectorDouble-asList">asList</a>() - get items as list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorDouble-clean" href="#fgVectorDouble-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorDouble-clean">clean</a>() - delete all items</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorDouble-del" href="#fgVectorDouble-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorDouble-del">del</a>(index) - delete item by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorDouble-insert" href="#fgVectorDouble-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorDouble-insert">insert</a>(position, item) - insert item into list at specified position</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgVectorDouble-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgVectorInt" href="#fgVectorInt">class <span class="class-name">fgVectorInt</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">[int] vector</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgVectorInt-__add__" href="#fgVectorInt-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorInt-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorInt-__cmp__" href="#fgVectorInt-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorInt-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorInt-__delattr__" href="#fgVectorInt-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorInt-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorInt-__delitem__" href="#fgVectorInt-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorInt-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorInt-__delslice__" href="#fgVectorInt-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorInt-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorInt-__getattribute__" href="#fgVectorInt-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorInt-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorInt-__getitem__" href="#fgVectorInt-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorInt-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorInt-__getslice__" href="#fgVectorInt-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorInt-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorInt-__init__" href="#fgVectorInt-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorInt-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorInt-__len__" href="#fgVectorInt-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorInt-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorInt-__mul__" href="#fgVectorInt-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorInt-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorInt-__repr__" href="#fgVectorInt-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorInt-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorInt-__rmul__" href="#fgVectorInt-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorInt-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorInt-__setattr__" href="#fgVectorInt-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorInt-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorInt-__setitem__" href="#fgVectorInt-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorInt-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorInt-__setslice__" href="#fgVectorInt-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorInt-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorInt-append" href="#fgVectorInt-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorInt-append">append</a>(item) or <a href="#fgVectorInt-append">append</a>( list(item) ) - add items to the end of the list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorInt-asList" href="#fgVectorInt-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(items) <a href="#fgVectorInt-asList">asList</a>() - get items as list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorInt-clean" href="#fgVectorInt-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorInt-clean">clean</a>() - delete all items</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorInt-del" href="#fgVectorInt-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorInt-del">del</a>(index) - delete item by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorInt-insert" href="#fgVectorInt-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorInt-insert">insert</a>(position, item) - insert item into list at specified position</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgVectorInt-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgVectorPoint" href="#fgVectorPoint">class <span class="class-name">fgVectorPoint</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">[fgPoint] vector</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgVectorPoint-__add__" href="#fgVectorPoint-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorPoint-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorPoint-__cmp__" href="#fgVectorPoint-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorPoint-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorPoint-__delattr__" href="#fgVectorPoint-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorPoint-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorPoint-__delitem__" href="#fgVectorPoint-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorPoint-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorPoint-__delslice__" href="#fgVectorPoint-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorPoint-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorPoint-__getattribute__" href="#fgVectorPoint-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorPoint-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorPoint-__getitem__" href="#fgVectorPoint-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorPoint-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorPoint-__getslice__" href="#fgVectorPoint-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorPoint-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorPoint-__init__" href="#fgVectorPoint-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorPoint-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorPoint-__len__" href="#fgVectorPoint-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorPoint-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorPoint-__mul__" href="#fgVectorPoint-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorPoint-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorPoint-__repr__" href="#fgVectorPoint-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorPoint-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorPoint-__rmul__" href="#fgVectorPoint-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorPoint-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorPoint-__setattr__" href="#fgVectorPoint-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorPoint-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorPoint-__setitem__" href="#fgVectorPoint-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorPoint-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorPoint-__setslice__" href="#fgVectorPoint-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorPoint-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorPoint-append" href="#fgVectorPoint-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorPoint-append">append</a>(item) or <a href="#fgVectorPoint-append">append</a>( list(item) ) - add items to the end of the list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorPoint-asList" href="#fgVectorPoint-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(items) <a href="#fgVectorPoint-asList">asList</a>() - get items as list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorPoint-clean" href="#fgVectorPoint-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorPoint-clean">clean</a>() - delete all items</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorPoint-del" href="#fgVectorPoint-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorPoint-del">del</a>(index) - delete item by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorPoint-insert" href="#fgVectorPoint-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorPoint-insert">insert</a>(position, item) - insert item into list at specified position</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgVectorPoint-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgVectorUInt16" href="#fgVectorUInt16">class <span class="class-name">fgVectorUInt16</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">[uint16_t] vector</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgVectorUInt16-__add__" href="#fgVectorUInt16-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt16-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt16-__cmp__" href="#fgVectorUInt16-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt16-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt16-__delattr__" href="#fgVectorUInt16-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt16-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt16-__delitem__" href="#fgVectorUInt16-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt16-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt16-__delslice__" href="#fgVectorUInt16-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt16-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt16-__getattribute__" href="#fgVectorUInt16-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt16-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt16-__getitem__" href="#fgVectorUInt16-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt16-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt16-__getslice__" href="#fgVectorUInt16-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt16-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt16-__init__" href="#fgVectorUInt16-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt16-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt16-__len__" href="#fgVectorUInt16-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt16-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt16-__mul__" href="#fgVectorUInt16-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt16-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt16-__repr__" href="#fgVectorUInt16-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt16-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt16-__rmul__" href="#fgVectorUInt16-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt16-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt16-__setattr__" href="#fgVectorUInt16-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt16-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt16-__setitem__" href="#fgVectorUInt16-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt16-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt16-__setslice__" href="#fgVectorUInt16-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt16-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt16-append" href="#fgVectorUInt16-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorUInt16-append">append</a>(item) or <a href="#fgVectorUInt16-append">append</a>( list(item) ) - add items to the end of the list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt16-asList" href="#fgVectorUInt16-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(items) <a href="#fgVectorUInt16-asList">asList</a>() - get items as list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt16-clean" href="#fgVectorUInt16-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorUInt16-clean">clean</a>() - delete all items</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt16-del" href="#fgVectorUInt16-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorUInt16-del">del</a>(index) - delete item by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt16-insert" href="#fgVectorUInt16-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorUInt16-insert">insert</a>(position, item) - insert item into list at specified position</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgVectorUInt16-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgVectorUInt32" href="#fgVectorUInt32">class <span class="class-name">fgVectorUInt32</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">[uint32t] vector</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgVectorUInt32-__add__" href="#fgVectorUInt32-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt32-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt32-__cmp__" href="#fgVectorUInt32-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt32-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt32-__delattr__" href="#fgVectorUInt32-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt32-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt32-__delitem__" href="#fgVectorUInt32-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt32-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt32-__delslice__" href="#fgVectorUInt32-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt32-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt32-__getattribute__" href="#fgVectorUInt32-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt32-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt32-__getitem__" href="#fgVectorUInt32-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt32-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt32-__getslice__" href="#fgVectorUInt32-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt32-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt32-__init__" href="#fgVectorUInt32-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt32-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt32-__len__" href="#fgVectorUInt32-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt32-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt32-__mul__" href="#fgVectorUInt32-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt32-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt32-__repr__" href="#fgVectorUInt32-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt32-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt32-__rmul__" href="#fgVectorUInt32-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt32-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt32-__setattr__" href="#fgVectorUInt32-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt32-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt32-__setitem__" href="#fgVectorUInt32-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt32-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt32-__setslice__" href="#fgVectorUInt32-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgVectorUInt32-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt32-append" href="#fgVectorUInt32-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorUInt32-append">append</a>(item) or <a href="#fgVectorUInt32-append">append</a>( list(item) ) - add items to the end of the list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt32-asList" href="#fgVectorUInt32-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(items) <a href="#fgVectorUInt32-asList">asList</a>() - get items as list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt32-clean" href="#fgVectorUInt32-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorUInt32-clean">clean</a>() - delete all items</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt32-del" href="#fgVectorUInt32-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorUInt32-del">del</a>(index) - delete item by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgVectorUInt32-insert" href="#fgVectorUInt32-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgVectorUInt32-insert">insert</a>(position, item) - insert item into list at specified position</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgVectorUInt32-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgZone" href="#fgZone">class <span class="class-name">fgZone</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Zone representation

Constructors:
  fgZone() - default
  fgZone(fgZone) - copy</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgZone-__cmp__" href="#fgZone-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZone-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZone-__delattr__" href="#fgZone-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZone-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZone-__getattribute__" href="#fgZone-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZone-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZone-__init__" href="#fgZone-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZone-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZone-__repr__" href="#fgZone-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZone-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZone-__setattr__" href="#fgZone-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZone-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZone-__str__" href="#fgZone-__str__"><span class="function-name">__str__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZone-__str__">__str__</a>() <==> str(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZone-clear" href="#fgZone-clear"><span class="function-name">clear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgZone-clear">clear</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZone-getIntValues" href="#fgZone-getIntValues"><span class="function-name">getIntValues</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">tuple( int y0, int y1 ) <a href="#fgZone-getIntValues">getIntValues</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZone-v0" href="#fgZone-v0"><span class="function-name">v0</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgZone-v0">v0</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZone-v1" href="#fgZone-v1"><span class="function-name">v1</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">float <a href="#fgZone-v1">v1</a>()</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">(string)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>position</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>program</dt>
<dd>

<pre class="doc" markdown="0">( dict(int:int) )</pre>

</dd>
</dl>
<dl class="descriptor"><dt>top</dt>
<dd>

<pre class="doc" markdown="0">(bool)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>width</dt>
<dd>

<pre class="doc" markdown="0">(float)</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgZone-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="fgZones" href="#fgZones">class <span class="class-name">fgZones</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">list of fgZone objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgZones-__add__" href="#fgZones-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZones-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZones-__cmp__" href="#fgZones-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZones-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZones-__delattr__" href="#fgZones-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZones-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZones-__delitem__" href="#fgZones-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZones-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZones-__delslice__" href="#fgZones-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZones-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZones-__getattribute__" href="#fgZones-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZones-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZones-__getitem__" href="#fgZones-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZones-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZones-__getslice__" href="#fgZones-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZones-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZones-__init__" href="#fgZones-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZones-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZones-__len__" href="#fgZones-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZones-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZones-__mul__" href="#fgZones-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZones-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZones-__repr__" href="#fgZones-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZones-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZones-__rmul__" href="#fgZones-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZones-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZones-__setattr__" href="#fgZones-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZones-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZones-__setitem__" href="#fgZones-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZones-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZones-__setslice__" href="#fgZones-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fgZones-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZones-append" href="#fgZones-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgZones-append">append</a>(item) or <a href="#fgZones-append">append</a>( list(item) ) - add items to the end of the list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZones-asList" href="#fgZones-asList"><span class="function-name">asList</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">list(items) <a href="#fgZones-asList">asList</a>() - get items as list</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZones-clean" href="#fgZones-clean"><span class="function-name">clean</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgZones-clean">clean</a>() - delete all items</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZones-del" href="#fgZones-del"><span class="function-name">del</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgZones-del">del</a>(index) - delete item by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgZones-insert" href="#fgZones-insert"><span class="function-name">insert</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fgZones-insert">insert</a>(position, item) - insert item into list at specified position</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fgZones-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd>
<dt class="class"><h2><a name="pyfgDataOwnerData" href="#pyfgDataOwnerData">class <span class="class-name">pyfgDataOwnerData</span></a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">pyfgDataOwnerData objects</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="pyfgDataOwnerData-__delattr__" href="#pyfgDataOwnerData-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#pyfgDataOwnerData-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="pyfgDataOwnerData-__getattribute__" href="#pyfgDataOwnerData-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#pyfgDataOwnerData-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="pyfgDataOwnerData-__init__" href="#pyfgDataOwnerData-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#pyfgDataOwnerData-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="pyfgDataOwnerData-__repr__" href="#pyfgDataOwnerData-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#pyfgDataOwnerData-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="pyfgDataOwnerData-__setattr__" href="#pyfgDataOwnerData-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#pyfgDataOwnerData-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#pyfgDataOwnerData-__new__">__new__</a>(S, ...) -> a new <a href="./__builtin__.html#object">object</a> with type S, a subtype of T</pre>

</dd></dl>
</dd></dl></div></div>
