

<a name="fontgate.fgGlyph"></a>

# `fgGlyph`


<dt class="class"><h2><span class="class-name">fontgate.fgGlyph</span> = <a name="fontgate.fgGlyph" href="#fontgate.fgGlyph">class fgGlyph</a>(<a href="./__builtin__.html#object">object</a>)</h2></dt><dd class="class"><dd>


<pre class="doc" markdown="0">Glyph representation

Constructors:
  fgGlyph() - default
  fgGlyph(fgGlyph) - copy
  fgGlyph('name') - create by name</pre>


</dd><h4 class="head-methods">Methods </h4><dl class="function"><dt><a name="fgGlyph-__add__" href="#fgGlyph-__add__"><span class="function-name">__add__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fontgate.fgGlyph-__add__">__add__</a>(y) <==> x+y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__cmp__" href="#fgGlyph-__cmp__"><span class="function-name">__cmp__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fontgate.fgGlyph-__cmp__">__cmp__</a>(y) <==> cmp(x,y)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__delattr__" href="#fgGlyph-__delattr__"><span class="function-name">__delattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fontgate.fgGlyph-__delattr__">__delattr__</a>('name') <==> del x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__delitem__" href="#fgGlyph-__delitem__"><span class="function-name">__delitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fontgate.fgGlyph-__delitem__">__delitem__</a>(y) <==> del x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__delslice__" href="#fgGlyph-__delslice__"><span class="function-name">__delslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fontgate.fgGlyph-__delslice__">__delslice__</a>(i, j) <==> del x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__getattribute__" href="#fgGlyph-__getattribute__"><span class="function-name">__getattribute__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fontgate.fgGlyph-__getattribute__">__getattribute__</a>('name') <==> x.name</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__getitem__" href="#fgGlyph-__getitem__"><span class="function-name">__getitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fontgate.fgGlyph-__getitem__">__getitem__</a>(y) <==> x[y]</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__getslice__" href="#fgGlyph-__getslice__"><span class="function-name">__getslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fontgate.fgGlyph-__getslice__">__getslice__</a>(i, j) <==> x[i:j]

Use of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__init__" href="#fgGlyph-__init__"><span class="function-name">__init__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fontgate.fgGlyph-__init__">__init__</a>(...) initializes x; see help(type(x)) for signature</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__len__" href="#fgGlyph-__len__"><span class="function-name">__len__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fontgate.fgGlyph-__len__">__len__</a>() <==> len(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__mul__" href="#fgGlyph-__mul__"><span class="function-name">__mul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fontgate.fgGlyph-__mul__">__mul__</a>(n) <==> x*n</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__repr__" href="#fgGlyph-__repr__"><span class="function-name">__repr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fontgate.fgGlyph-__repr__">__repr__</a>() <==> repr(x)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__rmul__" href="#fgGlyph-__rmul__"><span class="function-name">__rmul__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fontgate.fgGlyph-__rmul__">__rmul__</a>(n) <==> n*x</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__setattr__" href="#fgGlyph-__setattr__"><span class="function-name">__setattr__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fontgate.fgGlyph-__setattr__">__setattr__</a>('name', value) <==> x.name = value</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__setitem__" href="#fgGlyph-__setitem__"><span class="function-name">__setitem__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fontgate.fgGlyph-__setitem__">__setitem__</a>(i, y) <==> x[i]=y</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-__setslice__" href="#fgGlyph-__setslice__"><span class="function-name">__setslice__</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">x.<a href="#fontgate.fgGlyph-__setslice__">__setslice__</a>(i, j, y) <==> x[i:j]=y

Use  of negative indices is not supported.</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-addUnicode" href="#fgGlyph-addUnicode"><span class="function-name">addUnicode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fontgate.fgGlyph-addUnicode">addUnicode</a>(unicode) - add unicode to glyph</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-append" href="#fgGlyph-append"><span class="function-name">append</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fontgate.fgGlyph-append">append</a>(fgGlyph[, mtx=fgMatrix()]) - append contours of source glyph to current glyph</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-clear" href="#fgGlyph-clear"><span class="function-name">clear</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fontgate.fgGlyph-clear">clear</a>(contours=true, components=true, anchors=true, guides=true, hints=true) - clear glyph's data</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-countPictures" href="#fgGlyph-countPictures"><span class="function-name">countPictures</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int <a href="#fontgate.fgGlyph-countPictures">countPictures</a>() - return count of glyph pictures</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-createContour" href="#fgGlyph-createContour"><span class="function-name">createContour</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">fgContour <a href="#fontgate.fgGlyph-createContour">createContour</a>() - create new contour</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-createData" href="#fgGlyph-createData"><span class="function-name">createData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(variable type) <a href="#fontgate.fgGlyph-createData">createData</a>(GlyphDataType) - create glyph data, specified by GlyphDataType. Possible values are 'dtNone', 'dtFontGate', 'dtTrueType', 'dtType1', 'dtCFF', 'dtProteus', 'dtBitmaps'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-decompose" href="#fgGlyph-decompose"><span class="function-name">decompose</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fontgate.fgGlyph-decompose">decompose</a>() - decompose glyph</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-deleteContour" href="#fgGlyph-deleteContour"><span class="function-name">deleteContour</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fontgate.fgGlyph-deleteContour">deleteContour</a>(contourIndex) - delete contour by index</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-draw" href="#fgGlyph-draw"><span class="function-name">draw</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fontgate.fgGlyph-draw">draw</a>(penObject[, fgMatrix]) - draw contour by penObject (like fgPen) with transform matrix fgMatrix</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-fgData" href="#fgGlyph-fgData"><span class="function-name">fgData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">fgFontGateData/Nothing <a href="#fontgate.fgGlyph-fgData">fgData</a>() - get dtFontGate data if it's exist</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-fgDataCreate" href="#fgGlyph-fgDataCreate"><span class="function-name">fgDataCreate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">fgFontGateData <a href="#fontgate.fgGlyph-fgDataCreate">fgDataCreate</a>() - get dtFontGate data (create new one if missing)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-fixComposites" href="#fgGlyph-fixComposites"><span class="function-name">fixComposites</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fontgate.fgGlyph-fixComposites">fixComposites</a>(fixRotation=false)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-getData" href="#fgGlyph-getData"><span class="function-name">getData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(variable type) <a href="#fontgate.fgGlyph-getData">getData</a>([GlyphDataType='dtFontGate']) - get glyph data, specified by GlyphDataType. Possible values are 'dtNone', 'dtFontGate', 'dtTrueType', 'dtType1', 'dtCFF', 'dtProteus', 'dtBitmaps'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-getPen" href="#fgGlyph-getPen"><span class="function-name">getPen</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">fgPen <a href="#fontgate.fgGlyph-getPen">getPen</a>() - create new pen object</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-hasBody" href="#fgGlyph-hasBody"><span class="function-name">hasBody</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fontgate.fgGlyph-hasBody">hasBody</a>() - return True if glyph has contours or picture</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-hasColors" href="#fgGlyph-hasColors"><span class="function-name">hasColors</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fontgate.fgGlyph-hasColors">hasColors</a>() - return True if glyph has color pictures</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-hasData" href="#fgGlyph-hasData"><span class="function-name">hasData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fontgate.fgGlyph-hasData">hasData</a>(GlyphDataType) - return True if glyph data, specified by GlyphDataType, is exist. Possible values are 'dtNone', 'dtFontGate', 'dtTrueType', 'dtType1', 'dtCFF', 'dtProteus', 'dtBitmaps'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-hasHints" href="#fgGlyph-hasHints"><span class="function-name">hasHints</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fontgate.fgGlyph-hasHints">hasHints</a>() - return True if glyph has hints</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-hasPictures" href="#fgGlyph-hasPictures"><span class="function-name">hasPictures</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fontgate.fgGlyph-hasPictures">hasPictures</a>() - return True if glyph has pictures</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-hasUnicode" href="#fgGlyph-hasUnicode"><span class="function-name">hasUnicode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fontgate.fgGlyph-hasUnicode">hasUnicode</a>(unicode) - return True if glyph has specified unicode</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-keepData" href="#fgGlyph-keepData"><span class="function-name">keepData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fontgate.fgGlyph-keepData">keepData</a>(GlyphDataType) - remove all glyph data, except one specified by GlyphDataType. Possible values are 'dtNone', 'dtFontGate', 'dtTrueType', 'dtType1', 'dtCFF', 'dtProteus', 'dtBitmaps'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-killData" href="#fgGlyph-killData"><span class="function-name">killData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool <a href="#fontgate.fgGlyph-killData">killData</a>(GlyphDataType) - remove glyph data, specified by GlyphDataType. Possible values are 'dtNone', 'dtFontGate', 'dtTrueType', 'dtType1', 'dtCFF', 'dtProteus', 'dtBitmaps'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-killUnicode" href="#fgGlyph-killUnicode"><span class="function-name">killUnicode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fontgate.fgGlyph-killUnicode">killUnicode</a>(unicode) - remove unicode from glyph</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-modified" href="#fgGlyph-modified"><span class="function-name">modified</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fontgate.fgGlyph-modified">modified</a>(GlyphDataType) - inform that glyph data GlyphDataType has been modified. Possible values are 'dtNone', 'dtFontGate', 'dtTrueType', 'dtType1', 'dtCFF', 'dtProteus', 'dtBitmaps'</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-move" href="#fgGlyph-move"><span class="function-name">move</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fontgate.fgGlyph-move">move</a>(dx, dy) - move contour by (dx, dy)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-removeOverlap" href="#fgGlyph-removeOverlap"><span class="function-name">removeOverlap</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fontgate.fgGlyph-removeOverlap">removeOverlap</a>()</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-setData" href="#fgGlyph-setData"><span class="function-name">setData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fontgate.fgGlyph-setData">setData</a>(GlyphData-like object) - set glyph data</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-setUnicode" href="#fgGlyph-setUnicode"><span class="function-name">setUnicode</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fontgate.fgGlyph-setUnicode">setUnicode</a>(unicode) - assign unicode to glyph</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-transform" href="#fgGlyph-transform"><span class="function-name">transform</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fontgate.fgGlyph-transform">transform</a>(fgMatrix) - transform glyph by fgMatrix data</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-ttData" href="#fgGlyph-ttData"><span class="function-name">ttData</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">fgTrueTypeData/Nothing <a href="#fontgate.fgGlyph-ttData">ttData</a>() - get dtTrueType data if it's exist</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-ttDataCreate" href="#fgGlyph-ttDataCreate"><span class="function-name">ttDataCreate</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">fgTrueTypeData <a href="#fontgate.fgGlyph-ttDataCreate">ttDataCreate</a>() - get dtTrueType data (create new one if missing)</pre>

</dd></dl>
<dl class="function"><dt><a name="fgGlyph-update" href="#fgGlyph-update"><span class="function-name">update</span></a><span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0"><a href="#fontgate.fgGlyph-update">update</a>()</pre>

</dd></dl>

  <h4 class="head-desc">Descriptors </h4><dl class="descriptor"><dt>activeLayer</dt>
<dd>

<pre class="doc" markdown="0">(fgLayer) active layer or Nothing if not found</pre>

</dd>
</dl>
<dl class="descriptor"><dt>anchors</dt>
<dd>

<pre class="doc" markdown="0">([ fgAnchor ]) anchor's list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>bodyLayer</dt>
<dd>

<pre class="doc" markdown="0">(fgLayer) layer 'Body' or Nothing if not found</pre>

</dd>
</dl>
<dl class="descriptor"><dt>bodyLayerStrict</dt>
<dd>

<pre class="doc" markdown="0">(fgLayer) layer 'Body' (create one if not found)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>box</dt>
<dd>

<pre class="doc" markdown="0">(fgRect) glyph bounding box (int values)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>carets</dt>
<dd>

<pre class="doc" markdown="0">([ fgCaret ]) caret's list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>components</dt>
<dd>

<pre class="doc" markdown="0">([ fgComponent ]) component's list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>dict</dt>
<dd>

<pre class="doc" markdown="0">(fgGlyphDict) glyph's data dictionary</pre>

</dd>
</dl>
<dl class="descriptor"><dt>fbox</dt>
<dd>

<pre class="doc" markdown="0">(fgRect) glyph bounding box (int/float values)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>guides</dt>
<dd>

<pre class="doc" markdown="0">([ fgGuide ]) guide's list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>height</dt>
<dd>

<pre class="doc" markdown="0">(float) advancedHeight</pre>

</dd>
</dl>
<dl class="descriptor"><dt>hints</dt>
<dd>

<pre class="doc" markdown="0">([ fgHint ]) hint's list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>id</dt>
<dd>

<pre class="doc" markdown="0">(long) glyph ID</pre>

</dd>
</dl>
<dl class="descriptor"><dt>image</dt>
<dd>

<pre class="doc" markdown="0">(fgBitmap) first glyph image</pre>

</dd>
</dl>
<dl class="descriptor"><dt>index</dt>
<dd>

<pre class="doc" markdown="0">(int) glyph index from font.tableIndex</pre>

</dd>
</dl>
<dl class="descriptor"><dt>kerningLeft</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>kerningRight</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>layer</dt>
<dd>

<pre class="doc" markdown="0">(fgLayer) working layer (if present) or None. Read-only attribute, use layerName='string'|index  to change</pre>

</dd>
</dl>
<dl class="descriptor"><dt>layerName</dt>
<dd>

<pre class="doc" markdown="0">(string) name of the working layer name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>layers</dt>
<dd>

<pre class="doc" markdown="0">([ fgLayer ]) layer's list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>leftMargin</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>lib</dt>
<dd>

<pre class="doc" markdown="0">(fgLib) additional glyph's data</pre>

</dd>
</dl>
<dl class="descriptor"><dt>mark</dt>
<dd>

<pre class="doc" markdown="0">(int) glyph's mark value</pre>

</dd>
</dl>
<dl class="descriptor"><dt>mask</dt>
<dd>

<pre class="doc" markdown="0">(fgGlyph/Nothing) mask glyph</pre>

</dd>
</dl>
<dl class="descriptor"><dt>metrics</dt>
<dd>

<pre class="doc" markdown="0">(fgPoint) advancedWidth and advancedHeight</pre>

</dd>
</dl>
<dl class="descriptor"><dt>name</dt>
<dd>

<pre class="doc" markdown="0">(string) glyph name</pre>

</dd>
</dl>
<dl class="descriptor"><dt>note</dt>
<dd>

<pre class="doc" markdown="0">(string)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>otInfo</dt>
<dd>

<pre class="doc" markdown="0">(fgOtInfo)</pre>

</dd>
</dl>
<dl class="descriptor"><dt>parent</dt>
<dd>

<pre class="doc" markdown="0">(fgFont) parent font for glyph</pre>

</dd>
</dl>
<dl class="descriptor"><dt>rightMargin</dt>
<dd>

<pre class="doc" markdown="0"></pre>

</dd>
</dl>
<dl class="descriptor"><dt>unicode</dt>
<dd>

<pre class="doc" markdown="0">(int/Nothing) first glyph's unicode or Nothing if unicodes aren't defined</pre>

</dd>
</dl>
<dl class="descriptor"><dt>unicodes</dt>
<dd>

<pre class="doc" markdown="0">([ int ]) unicode's list</pre>

</dd>
</dl>
<dl class="descriptor"><dt>vsb</dt>
<dd>

<pre class="doc" markdown="0">(float) vsb</pre>

</dd>
</dl>
<dl class="descriptor"><dt>width</dt>
<dd>

<pre class="doc" markdown="0">(float) advancedWidth</pre>

</dd>
</dl>

  <h4 class="head-attrs">Attributes </h4><dl><dt><span class="other-name">__new__</span> = &lt;built-in method __new__ of type object&gt;<dd>

<pre class="doc" markdown="0">T.<a href="#fontgate.fgGlyph-__new__">__new__</a>(S, ...) -> a new object with type S, a subtype of T</pre>

</dd></dl>
</dd>


<a name="fontgate.fgGlyph.activeLayer"></a>

## `activeLayer`


<dl class="descriptor"><dt>fontgate.fgGlyph.activeLayer</dt>
<dd>

<pre class="doc" markdown="0">(fgLayer) active layer or Nothing if not found</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.addUnicode"></a>

## `addUnicode`


<dl class="function"><dt><a name="-fontgate.fgGlyph.addUnicode" href="#-fontgate.fgGlyph.addUnicode"><span class="function-name">fontgate.fgGlyph.addUnicode</span></a> = addUnicode<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">addUnicode(unicode) - add unicode to glyph</pre>

</dd></dl>



<a name="fontgate.fgGlyph.anchors"></a>

## `anchors`


<dl class="descriptor"><dt>fontgate.fgGlyph.anchors</dt>
<dd>

<pre class="doc" markdown="0">([ fgAnchor ]) anchor's list</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.append"></a>

## `append`


<dl class="function"><dt><a name="-fontgate.fgGlyph.append" href="#-fontgate.fgGlyph.append"><span class="function-name">fontgate.fgGlyph.append</span></a> = append<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">append(fgGlyph[, mtx=fgMatrix()]) - append contours of source glyph to current glyph</pre>

</dd></dl>



<a name="fontgate.fgGlyph.bodyLayer"></a>

## `bodyLayer`


<dl class="descriptor"><dt>fontgate.fgGlyph.bodyLayer</dt>
<dd>

<pre class="doc" markdown="0">(fgLayer) layer 'Body' or Nothing if not found</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.bodyLayerStrict"></a>

## `bodyLayerStrict`


<dl class="descriptor"><dt>fontgate.fgGlyph.bodyLayerStrict</dt>
<dd>

<pre class="doc" markdown="0">(fgLayer) layer 'Body' (create one if not found)</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.box"></a>

## `box`


<dl class="descriptor"><dt>fontgate.fgGlyph.box</dt>
<dd>

<pre class="doc" markdown="0">(fgRect) glyph bounding box (int values)</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.carets"></a>

## `carets`


<dl class="descriptor"><dt>fontgate.fgGlyph.carets</dt>
<dd>

<pre class="doc" markdown="0">([ fgCaret ]) caret's list</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.clear"></a>

## `clear`


<dl class="function"><dt><a name="-fontgate.fgGlyph.clear" href="#-fontgate.fgGlyph.clear"><span class="function-name">fontgate.fgGlyph.clear</span></a> = clear<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">clear(contours=true, components=true, anchors=true, guides=true, hints=true) - clear glyph's data</pre>

</dd></dl>



<a name="fontgate.fgGlyph.components"></a>

## `components`


<dl class="descriptor"><dt>fontgate.fgGlyph.components</dt>
<dd>

<pre class="doc" markdown="0">([ fgComponent ]) component's list</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.countPictures"></a>

## `countPictures`


<dl class="function"><dt><a name="-fontgate.fgGlyph.countPictures" href="#-fontgate.fgGlyph.countPictures"><span class="function-name">fontgate.fgGlyph.countPictures</span></a> = countPictures<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">int countPictures() - return count of glyph pictures</pre>

</dd></dl>



<a name="fontgate.fgGlyph.createContour"></a>

## `createContour`


<dl class="function"><dt><a name="-fontgate.fgGlyph.createContour" href="#-fontgate.fgGlyph.createContour"><span class="function-name">fontgate.fgGlyph.createContour</span></a> = createContour<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">fgContour createContour() - create new contour</pre>

</dd></dl>



<a name="fontgate.fgGlyph.createData"></a>

## `createData`


<dl class="function"><dt><a name="-fontgate.fgGlyph.createData" href="#-fontgate.fgGlyph.createData"><span class="function-name">fontgate.fgGlyph.createData</span></a> = createData<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(variable type) createData(GlyphDataType) - create glyph data, specified by GlyphDataType. Possible values are 'dtNone', 'dtFontGate', 'dtTrueType', 'dtType1', 'dtCFF', 'dtProteus', 'dtBitmaps'</pre>

</dd></dl>



<a name="fontgate.fgGlyph.decompose"></a>

## `decompose`


<dl class="function"><dt><a name="-fontgate.fgGlyph.decompose" href="#-fontgate.fgGlyph.decompose"><span class="function-name">fontgate.fgGlyph.decompose</span></a> = decompose<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool decompose() - decompose glyph</pre>

</dd></dl>



<a name="fontgate.fgGlyph.deleteContour"></a>

## `deleteContour`


<dl class="function"><dt><a name="-fontgate.fgGlyph.deleteContour" href="#-fontgate.fgGlyph.deleteContour"><span class="function-name">fontgate.fgGlyph.deleteContour</span></a> = deleteContour<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">deleteContour(contourIndex) - delete contour by index</pre>

</dd></dl>



<a name="fontgate.fgGlyph.dict"></a>

## `dict`


<dl class="descriptor"><dt>fontgate.fgGlyph.dict</dt>
<dd>

<pre class="doc" markdown="0">(fgGlyphDict) glyph's data dictionary</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.draw"></a>

## `draw`


<dl class="function"><dt><a name="-fontgate.fgGlyph.draw" href="#-fontgate.fgGlyph.draw"><span class="function-name">fontgate.fgGlyph.draw</span></a> = draw<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">draw(penObject[, fgMatrix]) - draw contour by penObject (like fgPen) with transform matrix fgMatrix</pre>

</dd></dl>



<a name="fontgate.fgGlyph.fbox"></a>

## `fbox`


<dl class="descriptor"><dt>fontgate.fgGlyph.fbox</dt>
<dd>

<pre class="doc" markdown="0">(fgRect) glyph bounding box (int/float values)</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.fgData"></a>

## `fgData`


<dl class="function"><dt><a name="-fontgate.fgGlyph.fgData" href="#-fontgate.fgGlyph.fgData"><span class="function-name">fontgate.fgGlyph.fgData</span></a> = fgData<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">fgFontGateData/Nothing fgData() - get dtFontGate data if it's exist</pre>

</dd></dl>



<a name="fontgate.fgGlyph.fgDataCreate"></a>

## `fgDataCreate`


<dl class="function"><dt><a name="-fontgate.fgGlyph.fgDataCreate" href="#-fontgate.fgGlyph.fgDataCreate"><span class="function-name">fontgate.fgGlyph.fgDataCreate</span></a> = fgDataCreate<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">fgFontGateData fgDataCreate() - get dtFontGate data (create new one if missing)</pre>

</dd></dl>



<a name="fontgate.fgGlyph.fixComposites"></a>

## `fixComposites`


<dl class="function"><dt><a name="-fontgate.fgGlyph.fixComposites" href="#-fontgate.fgGlyph.fixComposites"><span class="function-name">fontgate.fgGlyph.fixComposites</span></a> = fixComposites<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool fixComposites(fixRotation=false)</pre>

</dd></dl>



<a name="fontgate.fgGlyph.getData"></a>

## `getData`


<dl class="function"><dt><a name="-fontgate.fgGlyph.getData" href="#-fontgate.fgGlyph.getData"><span class="function-name">fontgate.fgGlyph.getData</span></a> = getData<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">(variable type) getData([GlyphDataType='dtFontGate']) - get glyph data, specified by GlyphDataType. Possible values are 'dtNone', 'dtFontGate', 'dtTrueType', 'dtType1', 'dtCFF', 'dtProteus', 'dtBitmaps'</pre>

</dd></dl>



<a name="fontgate.fgGlyph.getPen"></a>

## `getPen`


<dl class="function"><dt><a name="-fontgate.fgGlyph.getPen" href="#-fontgate.fgGlyph.getPen"><span class="function-name">fontgate.fgGlyph.getPen</span></a> = getPen<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">fgPen getPen() - create new pen object</pre>

</dd></dl>



<a name="fontgate.fgGlyph.guides"></a>

## `guides`


<dl class="descriptor"><dt>fontgate.fgGlyph.guides</dt>
<dd>

<pre class="doc" markdown="0">([ fgGuide ]) guide's list</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.hasBody"></a>

## `hasBody`


<dl class="function"><dt><a name="-fontgate.fgGlyph.hasBody" href="#-fontgate.fgGlyph.hasBody"><span class="function-name">fontgate.fgGlyph.hasBody</span></a> = hasBody<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool hasBody() - return True if glyph has contours or picture</pre>

</dd></dl>



<a name="fontgate.fgGlyph.hasColors"></a>

## `hasColors`


<dl class="function"><dt><a name="-fontgate.fgGlyph.hasColors" href="#-fontgate.fgGlyph.hasColors"><span class="function-name">fontgate.fgGlyph.hasColors</span></a> = hasColors<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool hasColors() - return True if glyph has color pictures</pre>

</dd></dl>



<a name="fontgate.fgGlyph.hasData"></a>

## `hasData`


<dl class="function"><dt><a name="-fontgate.fgGlyph.hasData" href="#-fontgate.fgGlyph.hasData"><span class="function-name">fontgate.fgGlyph.hasData</span></a> = hasData<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool hasData(GlyphDataType) - return True if glyph data, specified by GlyphDataType, is exist. Possible values are 'dtNone', 'dtFontGate', 'dtTrueType', 'dtType1', 'dtCFF', 'dtProteus', 'dtBitmaps'</pre>

</dd></dl>



<a name="fontgate.fgGlyph.hasHints"></a>

## `hasHints`


<dl class="function"><dt><a name="-fontgate.fgGlyph.hasHints" href="#-fontgate.fgGlyph.hasHints"><span class="function-name">fontgate.fgGlyph.hasHints</span></a> = hasHints<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool hasHints() - return True if glyph has hints</pre>

</dd></dl>



<a name="fontgate.fgGlyph.hasPictures"></a>

## `hasPictures`


<dl class="function"><dt><a name="-fontgate.fgGlyph.hasPictures" href="#-fontgate.fgGlyph.hasPictures"><span class="function-name">fontgate.fgGlyph.hasPictures</span></a> = hasPictures<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool hasPictures() - return True if glyph has pictures</pre>

</dd></dl>



<a name="fontgate.fgGlyph.hasUnicode"></a>

## `hasUnicode`


<dl class="function"><dt><a name="-fontgate.fgGlyph.hasUnicode" href="#-fontgate.fgGlyph.hasUnicode"><span class="function-name">fontgate.fgGlyph.hasUnicode</span></a> = hasUnicode<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool hasUnicode(unicode) - return True if glyph has specified unicode</pre>

</dd></dl>



<a name="fontgate.fgGlyph.height"></a>

## `height`


<dl class="descriptor"><dt>fontgate.fgGlyph.height</dt>
<dd>

<pre class="doc" markdown="0">(float) advancedHeight</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.hints"></a>

## `hints`


<dl class="descriptor"><dt>fontgate.fgGlyph.hints</dt>
<dd>

<pre class="doc" markdown="0">([ fgHint ]) hint's list</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.id"></a>

## `id`


<dl class="descriptor"><dt>fontgate.fgGlyph.id</dt>
<dd>

<pre class="doc" markdown="0">(long) glyph ID</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.image"></a>

## `image`


<dl class="descriptor"><dt>fontgate.fgGlyph.image</dt>
<dd>

<pre class="doc" markdown="0">(fgBitmap) first glyph image</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.index"></a>

## `index`


<dl class="descriptor"><dt>fontgate.fgGlyph.index</dt>
<dd>

<pre class="doc" markdown="0">(int) glyph index from font.tableIndex</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.keepData"></a>

## `keepData`


<dl class="function"><dt><a name="-fontgate.fgGlyph.keepData" href="#-fontgate.fgGlyph.keepData"><span class="function-name">fontgate.fgGlyph.keepData</span></a> = keepData<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool keepData(GlyphDataType) - remove all glyph data, except one specified by GlyphDataType. Possible values are 'dtNone', 'dtFontGate', 'dtTrueType', 'dtType1', 'dtCFF', 'dtProteus', 'dtBitmaps'</pre>

</dd></dl>



<a name="fontgate.fgGlyph.kerningLeft"></a>

## `kerningLeft`


<dl class="descriptor"><dt>fontgate.fgGlyph.kerningLeft</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.kerningRight"></a>

## `kerningRight`


<dl class="descriptor"><dt>fontgate.fgGlyph.kerningRight</dt>
<dd>

<pre class="doc" markdown="0">(int)</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.killData"></a>

## `killData`


<dl class="function"><dt><a name="-fontgate.fgGlyph.killData" href="#-fontgate.fgGlyph.killData"><span class="function-name">fontgate.fgGlyph.killData</span></a> = killData<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">bool killData(GlyphDataType) - remove glyph data, specified by GlyphDataType. Possible values are 'dtNone', 'dtFontGate', 'dtTrueType', 'dtType1', 'dtCFF', 'dtProteus', 'dtBitmaps'</pre>

</dd></dl>



<a name="fontgate.fgGlyph.killUnicode"></a>

## `killUnicode`


<dl class="function"><dt><a name="-fontgate.fgGlyph.killUnicode" href="#-fontgate.fgGlyph.killUnicode"><span class="function-name">fontgate.fgGlyph.killUnicode</span></a> = killUnicode<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">killUnicode(unicode) - remove unicode from glyph</pre>

</dd></dl>



<a name="fontgate.fgGlyph.layer"></a>

## `layer`


<dl class="descriptor"><dt>fontgate.fgGlyph.layer</dt>
<dd>

<pre class="doc" markdown="0">(fgLayer) working layer (if present) or None. Read-only attribute, use layerName='string'|index  to change</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.layerName"></a>

## `layerName`


<dl class="descriptor"><dt>fontgate.fgGlyph.layerName</dt>
<dd>

<pre class="doc" markdown="0">(string) name of the working layer name</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.layers"></a>

## `layers`


<dl class="descriptor"><dt>fontgate.fgGlyph.layers</dt>
<dd>

<pre class="doc" markdown="0">([ fgLayer ]) layer's list</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.lib"></a>

## `lib`


<dl class="descriptor"><dt>fontgate.fgGlyph.lib</dt>
<dd>

<pre class="doc" markdown="0">(fgLib) additional glyph's data</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.mark"></a>

## `mark`


<dl class="descriptor"><dt>fontgate.fgGlyph.mark</dt>
<dd>

<pre class="doc" markdown="0">(int) glyph's mark value</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.mask"></a>

## `mask`


<dl class="descriptor"><dt>fontgate.fgGlyph.mask</dt>
<dd>

<pre class="doc" markdown="0">(fgGlyph/Nothing) mask glyph</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.metrics"></a>

## `metrics`


<dl class="descriptor"><dt>fontgate.fgGlyph.metrics</dt>
<dd>

<pre class="doc" markdown="0">(fgPoint) advancedWidth and advancedHeight</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.modified"></a>

## `modified`


<dl class="function"><dt><a name="-fontgate.fgGlyph.modified" href="#-fontgate.fgGlyph.modified"><span class="function-name">fontgate.fgGlyph.modified</span></a> = modified<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">modified(GlyphDataType) - inform that glyph data GlyphDataType has been modified. Possible values are 'dtNone', 'dtFontGate', 'dtTrueType', 'dtType1', 'dtCFF', 'dtProteus', 'dtBitmaps'</pre>

</dd></dl>



<a name="fontgate.fgGlyph.move"></a>

## `move`


<dl class="function"><dt><a name="-fontgate.fgGlyph.move" href="#-fontgate.fgGlyph.move"><span class="function-name">fontgate.fgGlyph.move</span></a> = move<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">move(dx, dy) - move contour by (dx, dy)</pre>

</dd></dl>



<a name="fontgate.fgGlyph.name"></a>

## `name`


<dl class="descriptor"><dt>fontgate.fgGlyph.name</dt>
<dd>

<pre class="doc" markdown="0">(string) glyph name</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.note"></a>

## `note`


<dl class="descriptor"><dt>fontgate.fgGlyph.note</dt>
<dd>

<pre class="doc" markdown="0">(string)</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.otInfo"></a>

## `otInfo`


<dl class="descriptor"><dt>fontgate.fgGlyph.otInfo</dt>
<dd>

<pre class="doc" markdown="0">(fgOtInfo)</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.parent"></a>

## `parent`


<dl class="descriptor"><dt>fontgate.fgGlyph.parent</dt>
<dd>

<pre class="doc" markdown="0">(fgFont) parent font for glyph</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.removeOverlap"></a>

## `removeOverlap`


<dl class="function"><dt><a name="-fontgate.fgGlyph.removeOverlap" href="#-fontgate.fgGlyph.removeOverlap"><span class="function-name">fontgate.fgGlyph.removeOverlap</span></a> = removeOverlap<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">removeOverlap()</pre>

</dd></dl>



<a name="fontgate.fgGlyph.setData"></a>

## `setData`


<dl class="function"><dt><a name="-fontgate.fgGlyph.setData" href="#-fontgate.fgGlyph.setData"><span class="function-name">fontgate.fgGlyph.setData</span></a> = setData<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">setData(GlyphData-like object) - set glyph data</pre>

</dd></dl>



<a name="fontgate.fgGlyph.setUnicode"></a>

## `setUnicode`


<dl class="function"><dt><a name="-fontgate.fgGlyph.setUnicode" href="#-fontgate.fgGlyph.setUnicode"><span class="function-name">fontgate.fgGlyph.setUnicode</span></a> = setUnicode<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">setUnicode(unicode) - assign unicode to glyph</pre>

</dd></dl>



<a name="fontgate.fgGlyph.transform"></a>

## `transform`


<dl class="function"><dt><a name="-fontgate.fgGlyph.transform" href="#-fontgate.fgGlyph.transform"><span class="function-name">fontgate.fgGlyph.transform</span></a> = transform<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">transform(fgMatrix) - transform glyph by fgMatrix data</pre>

</dd></dl>



<a name="fontgate.fgGlyph.ttData"></a>

## `ttData`


<dl class="function"><dt><a name="-fontgate.fgGlyph.ttData" href="#-fontgate.fgGlyph.ttData"><span class="function-name">fontgate.fgGlyph.ttData</span></a> = ttData<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">fgTrueTypeData/Nothing ttData() - get dtTrueType data if it's exist</pre>

</dd></dl>



<a name="fontgate.fgGlyph.ttDataCreate"></a>

## `ttDataCreate`


<dl class="function"><dt><a name="-fontgate.fgGlyph.ttDataCreate" href="#-fontgate.fgGlyph.ttDataCreate"><span class="function-name">fontgate.fgGlyph.ttDataCreate</span></a> = ttDataCreate<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">fgTrueTypeData ttDataCreate() - get dtTrueType data (create new one if missing)</pre>

</dd></dl>



<a name="fontgate.fgGlyph.unicode"></a>

## `unicode`


<dl class="descriptor"><dt>fontgate.fgGlyph.unicode</dt>
<dd>

<pre class="doc" markdown="0">(int/Nothing) first glyph's unicode or Nothing if unicodes aren't defined</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.unicodes"></a>

## `unicodes`


<dl class="descriptor"><dt>fontgate.fgGlyph.unicodes</dt>
<dd>

<pre class="doc" markdown="0">([ int ]) unicode's list</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.update"></a>

## `update`


<dl class="function"><dt><a name="-fontgate.fgGlyph.update" href="#-fontgate.fgGlyph.update"><span class="function-name">fontgate.fgGlyph.update</span></a> = update<span class="argspec">(...)</span></dt><dd>

<pre class="doc" markdown="0">update()</pre>

</dd></dl>



<a name="fontgate.fgGlyph.vsb"></a>

## `vsb`


<dl class="descriptor"><dt>fontgate.fgGlyph.vsb</dt>
<dd>

<pre class="doc" markdown="0">(float) vsb</pre>

</dd>
</dl>



<a name="fontgate.fgGlyph.width"></a>

## `width`


<dl class="descriptor"><dt>fontgate.fgGlyph.width</dt>
<dd>

<pre class="doc" markdown="0">(float) advancedWidth</pre>

</dd>
</dl>

