
# FontLab 7 Python API documentation

## Viewing the documentation

Visit the [fontlabcom.github.io/fontlab-python-docs](https://fontlabcom.github.io/fontlab-python-docs) to view the documentation in the browser.

## Building the documentation

Install FontLab 7 and Python 2.7 that FontLab uses.

In Terminal or command-line, run:

```
python2 -m pip install --user --upgrade git+https://github.com/twardoch/pydocmk2
```

### Building the FontLab 7 Python API docs

Go to the [`fontlab7/build`](fontlab7/build) folder.

Open [`build_fontlab7_api_docs.vfpy`](fontlab7/build/build_fontlab7_api_docs.vfpy) in FontLab 7 and wait until the `pydocmk2` packages generates the Markdown files into the [`fontlab7/srcdocs/mkdocs`](fontlab7/srcdocs/mkdocs) folder.

In Terminal, go to Go to the [`fontlab7/build`](fontlab7/build) folder and run:

```
python2 -m mkdocs build -v -f ../mkdocs.yml --dirty
```

or, on macOS, double-click [`build_fontlab7_api_docs.command`](fontlab7/build/build_fontlab7_api_docs.command)

This will build the HTML documentation using `mkdocs` into the [`docs/`](docs) folder.

### Building the FontLab 7 PythonQt API docs

Go to the [`pythonqt/build`](pythonqt/build) folder, and proceed the same way. This will build into the [`docs/pythonqt`](docs/pythonqt) folder.

## Contributing to the documentation

Before you contribute to this repository, you must agree to the [FontLab Individual Contributor License Agreement](https://cla-assistant.io/fontlabcom/fontlab-python-docs)

### Simple

1. Look up a base name (without the `.md` extension) in the [`srcdocs/mkdocs`](srcdocs/mkdocs) folder.
2. Go to the [wiki](https://github.com/fontlabcom/fontlab-python-docs/wiki) and create a new article with the same name.
3. Write your content — we’ll review it and move it to the official docs.

### Advanced

Fork the repo.

The [`fontlab7/srcdocs/`](fontlab7/srcdocs) folder has three subfolders:

- [`docs`](fontlab7/srcdocs/docs) contains `.md` files that will be included in the documentation as separate documents
- [`pre`](fontlab7/srcdocs/pre) may contain optional `.md` files that have the same names as the autogenerated API documents (e.g. `typerig.core.objects.cubicbezier.md`): the content of each such file will be **prepended** to the autogenerated doc file (inserted after the first header)
- [`post`](fontlab7/srcdocs/post) may contain optional `.md` files that have the same names as the autogenerated API documents (e.g. `typerig.core.objects.cubicbezier.md`): the content of each such file will be **appended** to the autogenerated doc file (added to the end)

You may create new documents in `pre` and `post` folders to enhance the autogenerated content with human-authored documentation.

Create a pull request and we’ll consider it.

The [`pydocmk.yml`](fontlab7/pydocmk.yml) YAML file controls the build process, see [pydocmk2](https://twardoch.github.io/pydocmk2/) for details.

## License

The documentation is licensed under the [Apache 2 license](LICENSE). Copyright © 2017-2020 Fontlab Ltd.
