---
layout: documentation
menu: xtradb
subtitle: Percona XtraDB Cluster
---
# Percona XtraDB Cluster

## Supported Versions

- `8.0`
- `5.7` {% include teams.html %}

## Support Level

<table class="table">
    <tr>
        <th width="25%">Compatible</th>
        <td>✅</td>
    </tr>
    <tr>
        <th width="25%">Certified</th>
        <td>✅</td>
    </tr>
    <tr>
        <th width="25%">Guaranteed</th>
        <td>✅ {% include teams.html %}</td>
    </tr>
</table>

Support Level determines the degree of support available for this database ([learn more](/documentation/learnmore/database-support)). 

## Drivers

<table class="table">
<tr>
<th>URL format</th>
<td><code>jdbc:mysql://<i>host</i>:<i>port</i>/<i>database</i></code></td>
</tr>
<tr>
<th>Ships with Flyway Command-line</th>
<td>Yes</td>
</tr>
<tr>
<th>Maven Central coordinates</th>
<td><code>mysql:mysql-connector-java:8.0.12</code></td>
</tr>
<tr>
<th>Supported versions</th>
<td><code>8.0.12</code> and later</td>
</tr>
<tr>
<th>Default Java class</th>
<td><code>com.mysql.jdbc.Driver</code></td>
</tr>
</table>

## SQL Script Syntax

- [Standard SQL syntax](/documentation/concepts/migrations#sql-based-migrations#syntax) with statement delimiter **;**
- Delimiter change for stored procedures using DELIMITER statements
- Comment directives generated by mysqldump (/!.../;)
- MySQL-style single-line comments (# Comment)

### Compatibility

- DDL exported by mysqldump can be used unchanged in a Flyway migration.
- Any MySQL SQL script executed by Flyway, can be executed by the MySQL command-line tool and other
        MySQL-compatible tools (after the placeholders have been replaced).
        
### Example

<pre class="prettyprint">/* Single line comment */
CREATE TABLE test_data (
 value VARCHAR(25) NOT NULL,
 PRIMARY KEY(value)
);

/*
Multi-line
comment
*/

-- MySQL procedure
DELIMITER //
CREATE PROCEDURE AddData()
 BEGIN
   # MySQL-style single line comment
   INSERT INTO test_data (value) VALUES ('Hello');
 END //
DELIMITER;

CALL AddData();

-- MySQL comments directives generated by mysqlsump
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;

-- Placeholder
INSERT INTO ${tableName} (name) VALUES ('Mr. T');</pre>

## Limitations

- [Issue 558](https://github.com/flyway/flyway/issues/558)
        The parser currently doesn't support multiple comment directives on a single line.<br/>
        Example: /*!50003 CREATE*/ /*!50017 DEFINER=`...`*/ /*!50003 TRIGGER EntityBeforeInsert ...

<p class="next-steps">
    <a class="btn btn-primary" href="/documentation/database/tidb">TiDB <i class="fa fa-arrow-right"></i></a>
</p>