---
layout: documentation
menu: mysql
subtitle: MySQL
---
# MySQL

## Supported Versions

- `8.0`
- `5.7` {% include teams.html %}
- `5.6` {% include teams.html %}
- `5.5` {% include enterprise.html %}
- `5.1` {% include enterprise.html %}

## Support Level

<table class="table">
    <tr>
        <th width="25%">Compatible</th>
        <td>✅</td>
    </tr>
    <tr>
        <th width="25%">Certified</th>
        <td>✅</td>
    </tr>
    <tr>
        <th width="25%">Guaranteed</th>
        <td>✅ {% include teams.html %}</td>
    </tr>
</table>

Support Level determines the degree of support available for this database ([learn more](/documentation/learnmore/database-support)). 

## Drivers

<table class="table">
<thead>
<tr>
<th></th>
<th>MySQL (for MySQL 5.5 and newer)</th>
<th>MariaDB (for MySQL 5.1)</th>
</tr>
</thead>
<tr>
<th>URL format</th>
<td><code>jdbc:mysql://<i>host</i>:<i>port</i>/<i>database</i></code></td>
<td><code>jdbc:mysql://<i>host</i>:<i>port</i>/<i>database</i></code></td>
</tr>
<tr>
<th>SSL support</th>
<td>Yes - add <code>?useSsl=true</code></td>
<td>Yes - add <code>?useSsl=true</code></td>
</tr>
<tr>
<th>Ships with Flyway Command-line</th>
<td>No</td>
<td>Yes</td>
</tr>
<tr>
<th>Maven Central coordinates</th>
<td><code>mysql:mysql-connector-java:8.0.12</code></td>
<td><code>org.mariadb.jdbc:mariadb-java-client:2.3.0</code></td>
</tr>
<tr>
<th>Supported versions</th>
<td><code>5.1.44</code> and later</td>
<td><code>2.0.0</code> and later</td>
</tr>
<tr>
<th>Default Java class</th>
<td><code>com.mysql.jdbc.Driver</code></td>
<td><code>org.mariadb.jdbc.Driver</code></td>
</tr>
</table>

### Compatibility

- If a MySQL driver is not present on the project classpath, MariaDB will be used as a fallback driver. If this is not desired, add `disableMariaDbDriver` to your database URL.

## Java Usage
MySQL support is a separate dependency for Flyway and will need to be added to your Java project to access these features.

### Maven
#### Community
```xml
<dependency>
    <groupId>org.flywaydb</groupId>
    <artifactId>flyway-mysql</artifactId>
</dependency>
```
#### Teams
```xml
<dependency>
    <groupId>org.flywaydb.enterprise</groupId>
    <artifactId>flyway-mysql</artifactId>
</dependency>
```
### Gradle
#### Community
```groovy
dependencies {
    compile "org.flywaydb:flyway-mysql"
}
```
#### Teams
```groovy
dependencies {
    compile "org.flywaydb.enterprise:flyway-mysql"
}
```

## SQL Script Syntax

- [Standard SQL syntax](/documentation/concepts/migrations#sql-based-migrations#syntax) with statement delimiter **;**
- Delimiter change for stored procedures using DELIMITER statements
- Comment directives generated by mysqldump (/!.../;)
- MySQL-style single-line comments (# Comment)

### Compatibility

- DDL exported by mysqldump can be used unchanged in a Flyway migration.
- Any MySQL SQL script executed by Flyway, can be executed by the MySQL command-line tool and other
        MySQL-compatible tools (after the placeholders have been replaced).
        
### Example

```sql
/* Single line comment */
CREATE TABLE test_data (
 value VARCHAR(25) NOT NULL,
 PRIMARY KEY(value)
);

/*
Multi-line
comment
*/

-- MySQL procedure
DELIMITER //
CREATE PROCEDURE AddData()
 BEGIN
   # MySQL-style single line comment
   INSERT INTO test_data (value) VALUES ('Hello');
 END //
DELIMITER;

CALL AddData();

-- MySQL comments directives generated by mysqlsump
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;

-- Placeholder
INSERT INTO ${tableName} (name) VALUES ('Mr. T');
```

## Authentication

Flyway supports the following MySQL authentication methods:

- MySQL Option Files

### Option Files
{% include teams.html %}

A username and password can be retrieved from MySQL option files for authentication, in which case they do not need to be supplied in configuration. The following table lists which option files are searched for per operating system, in order.

| Windows                                      |   | Other                |
|----------------------------------------------|---|----------------------|
| `%WINDIR%\my.ini`, `%WINDIR%\my.cnf`         |   | `/etc/my.cnf`        |
| `C:\my.ini`, `C:\my.cnf`                     |   | `/etc/mysql/my.cnf`  |
| `%MYSQL_HOME%\my.ini`, `%MYSQL_HOME%\my.cnf` |   | `$MYSQL_HOME/my.cnf` |
| `%APPDATA%\MySQL\.mylogin.cnf`               |   | `~/.my.cnf`          |
|                                              |   | `~/.mylogin.cnf`     |

You can read more about MySQL option files [here](https://dev.mysql.com/doc/refman/8.0/en/option-files.html).

## Limitations

- No support for option file inclusions
- No support for loading properties other than `user` and `password` from option files

<p class="next-steps">
    <a class="btn btn-primary" href="/documentation/database/aurora-mysql">Aurora MySQL <i class="fa fa-arrow-right"></i></a>
</p>
