---
layout: documentation
menu: mariadb
subtitle: MariaDB
---
# MariaDB

## Supported Versions

- `10.6`
- `10.5`
- `10.4`
- `10.3`
- `10.2`
- `10.1` {% include teams.html %}
- `10.0` {% include teams.html %}
- `5.5` {% include teams.html %}
- `5.3` {% include teams.html %}
- `5.2` {% include teams.html %}
- `5.1` {% include teams.html %}

## Support Level

<table class="table">
    <tr>
        <th width="25%">Compatible</th>
        <td>✅</td>
    </tr>
    <tr>
        <th width="25%">Certified</th>
        <td>✅</td>
    </tr>
    <tr>
        <th width="25%">Guaranteed</th>
        <td>✅ {% include teams.html %}</td>
    </tr>
</table>

Support Level determines the degree of support available for this database ([learn more](/documentation/learnmore/database-support)).

## Driver

<table class="table">
<tr>
<th>URL format</th>
<td><code>jdbc:(mysql|mariadb)://<i>host</i>:<i>port</i>/<i>database</i></code></td>
</tr>
<tr>
<th>SSL support</th>
<td>Yes - add <code>?useSsl=true</code></td>
</tr>
<tr>
<th>Ships with Flyway Command-line</th>
<td>Yes</td>
</tr>
<tr>
<th>Maven Central coordinates</th>
<td><code>org.mariadb.jdbc:mariadb-java-client:2.6.0</code></td>
</tr>
<tr>
<th>Supported versions</th>
<td><code>2.0.0</code> and later</td>
</tr>
<tr>
<th>Default Java class</th>
<td><code>org.mariadb.jdbc.Driver</code></td>
</tr>
</table>

## Java Usage
MariaDB support is a separate dependency for Flyway and will need to be added to your Java project to access these features.
MariaDB is found within the `flyway-mysql` plugin module.
### Maven
#### Community
```xml
<dependency>
    <groupId>org.flywaydb</groupId>
    <artifactId>flyway-mysql</artifactId>
</dependency>
```
#### Teams
```xml
<dependency>
    <groupId>org.flywaydb.enterprise</groupId>
    <artifactId>flyway-mysql</artifactId>
</dependency>
```
### Gradle
#### Community
```groovy
dependencies {
    compile "org.flywaydb:flyway-mysql"
}
```
#### Teams
```groovy
dependencies {
    compile "org.flywaydb.enterprise:flyway-mysql"
}
```

## SQL Script Syntax

- [Standard SQL syntax](/documentation/concepts/migrations#sql-based-migrations#syntax) with statement delimiter **;**
- Delimiter change for stored procedures using DELIMITER statements
- Comment directives generated by mysqldump (/!.../;)
- MySQL-style single-line comments (# Comment)

### Compatibility

- DDL exported by mysqldump can be used unchanged in a Flyway migration.
- Any MySQL SQL script executed by Flyway, can be executed by the MySQL command-line tool and other
        MySQL-compatible tools (after the placeholders have been replaced).

### Example

```sql
/* Single line comment */
CREATE TABLE test_data (
 value VARCHAR(25) NOT NULL,
 PRIMARY KEY(value)
);

/*
Multi-line
comment
*/

-- MySQL procedure
DELIMITER //
CREATE PROCEDURE AddData()
 BEGIN
   # MySQL-style single line comment
   INSERT INTO test_data (value) VALUES ('Hello');
 END //
DELIMITER;

CALL AddData();

-- MySQL comments directives generated by mysqlsump
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;

-- Placeholder
INSERT INTO ${tableName} (name) VALUES ('Mr. T');
```

<p class="next-steps">
    <a class="btn btn-primary" href="/documentation/database/xtradb">Percona XtraDB Cluster <i class="fa fa-arrow-right"></i></a>
</p>
