---
layout: documentation
menu: h2
subtitle: H2
---
# H2

## Supported Versions

- `2.0`
- `1.4`
- `1.3` {% include teams.html %}
- `1.2` {% include teams.html %}

## Support Level

<table class="table">
    <tr>
        <th width="25%">Compatible</th>
        <td>✅</td>
    </tr>
    <tr>
        <th width="25%">Certified</th>
        <td>✅</td>
    </tr>
    <tr>
        <th width="25%">Guaranteed</th>
        <td>✅ {% include teams.html %}</td>
    </tr>
</table>

Support Level determines the degree of support available for this database ([learn more](/documentation/learnmore/database-support)). 

## Driver

<table class="table">
<tr>
<th>URL format</th>
<td><code>jdbc:h2:<i>file</i></code></td>
</tr>
<tr>
<th>Ships with Flyway Command-line</th>
<td>Yes</td>
</tr>
<tr>
<th>Maven Central coordinates</th>
<td><code>com.h2database:h2:2.0.206</code></td>
</tr>
<tr>
<th>Supported versions</th>
<td><code>1.2.137</code> and later</td>
</tr>
<tr>
<th>Default Java class</th>
<td><code>org.h2.Driver</code></td>
</tr>
</table>

## SQL Script Syntax

- [Standard SQL syntax](/documentation/concepts/migrations#sql-based-migrations#syntax) with statement delimiter **;**
- $$ delimited strings

### Compatibility

- DDL exported by H2 can be used unchanged in a Flyway migration
- Any H2 SQL script executed by Flyway, can be executed by the h2 tools (after the placeholders have been replaced)
        
### Example

```sql
/* Single line comment */
CREATE TABLE test_data (
 value VARCHAR(25) NOT NULL PRIMARY KEY
);

/*
Multi-line
comment
*/

-- Sql-style comment

-- Placeholder
INSERT INTO ${tableName} (name) VALUES ('Mr. T');
INSERT INTO test_user (name) VALUES ( $$'Mr. Semicolon+Linebreak;
another line'$$);
```

## Limitations

- Due to H2 limitations DOMAIN objects can only be cleaned in the current schema

<p class="next-steps">
    <a class="btn btn-primary" href="/documentation/database/hsqldb">HSQLDB <i class="fa fa-arrow-right"></i></a>
</p>
