---
layout: blog
subtitle: Flyway 7.3.0 Released
permalink: /blog/flyway-7.3.0.html
author: julia
---

**Flyway 7.3.0** is out! This release contains new features and improvements over Flyway 7.2.0.

## Highlights
- A placeholder for the full filename of a migration file
- Script config files can specify `shouldExecute`
- Retrying connections back off exponentially
- Dry Run output can be directed to AWS S3 or Google Cloud Storage

You can find a detailed list of the changes in the [release notes](/documentation/learnmore/releaseNotes#7.3.0).

### Migration filename placeholder

It can be useful to know the full name of a migration file at the time it's executed, for auditing purposes. The 
migration description is of course preserved in Flyway's history, but this wasn't available to the migration
itself. You can now use the placeholder `${flyway:filename}` and the migration's full name will be substituted.

See [the documentation](/documentation/configuration/placeholder) for more details. 

### Script config files

A new option for script configuration files is `shouldExecute`. This can be set to true or false, as an
alternative to using cherry-picking, or to a condition in the form `expression1==expression2`. Allowing
expressions, which can include placeholders, means that you can specify scripts to run in particular
environments and be ignored in others - useful if, say, you want to create static test data but not in a
production environment!

### Retrying connections

When Flyway is not able to make a database connection, it will try again. However, retrying at 1
second intervals will cause a significant number of errors if the database is busy or unavailable for some
time, and that may be unwelcome if, for example, each one results in an alert in a monitoring system. So,
Flyway now increases the interval between retries exponentially as the number of failures increases. The
more failures Flyway encounters, the more likely it is that the database will not be available any time soon
and that more attempts will just add noise into the situation.

### Dry Run output to cloud storage
{% include teams.html %}

Migrations can already be stored in, and read from, AWS S3 and Google Cloud Storage. You can now send Dry Run
output to a bucket in either platform in exactly the same way - just specify `s3:<bucket>/<filename>` or
`gcs:<bucket>/<filename>` in the `flyway.dryRunOutput` parameter similarly to the way you would for 
`flyway.locations`. 

See [the documentation](/documentation/configuration/dryRunOutput/) for more details, including necessary libraries
and authentication options.

## Download it now and enjoy!

You can [download Flyway 7.3.0](/download) now! We recommend you upgrade if you are affected by any
of the issues logged in the release notes.

Flyway is brought to you with <i class="fa fa-heart"></i> by the [Redgate](https://red-gate.com) team:
[Julia Hayward](https://twitter.com/Julia_Hayward),
[Ajay Ahir](https://github.com/DoodleBobBuffPants), and [Mikiel Agutu](https://twitter.com/mikielagutu),
with a lot of help from [Axel Fontaine](https://twitter.com/axelfontaine)
as well as the [many contributors](/documentation/contribute/hallOfFame).

Now it's your turn! Spread the word, follow [@flywaydb](https://twitter.com/flywaydb) on Twitter and
subscribe to our newsletter below to be the first one to be notified about updates.
