---
layout: blog
subtitle: DB DevOps
permalink: /blog/db-devops.html
author: tey
---

## Why and how you should automate database migrations

The desire to release features faster and deliver value to customers sooner is prompting many IT teams to adopt DevOps and Agile practices. By automating parts of the development process where possible and working in shorter cycles to release small changes more often, those teams that do well 
experience fewer errors and produce higher quality code.

All of which is good news until it comes to the database. While DevOps is becoming standard practice in application development, the greatest challenge when integrating database development into a DevOps process is synchronizing application and database changes.

The issue often isn’t writing the database code to make the necessary changes. Instead, it’s deploying the changes and incorporating them with different changes from other developers at the same time. This is the point when many development teams see their releases falter, particularly when they use a migrations-based approach to deploy database changes.

## Coping with multiple scripts – and multiple databases

As new code is developed to move from the old database scheme to the desired database schema, a script of each individual change is kept. To update the database with the changes, these migration scripts are run in sequence.

This often means a DBA has to sort through a pile of scripts and work out which ones to apply in what order, which can result in delays, problems and errors when the changes are deployed. This can be exacerbated further when teams are using branches and every script has to be painstakingly looked at, line by line, to work out the order they need to run in and highlight any conflicts.

Another factor now coming into play is the number of different databases and platforms being used by IT teams. While SQL Server or Oracle databases are still preferred for mission-critical and legacy applications, there is a rise in the take-up of open source databases like MySQL, PostgreSQL and MariaDB, along with cloud platforms like Aurora, Redshift and Snowflake.

This is further compounded by the variety of open source databases in use in the same organization. Among the findings in Percona’s [2019 Open Source Data Management Software Survey](https://learn.percona.com/hubfs/Percona_Open_Source_DataManagement_Software_Survey_2019.pdf), for example, 92% of respondents stated they use more than one database, 89% had more than one open source database, and 73% had multiple database types.

But how can teams address the inevitable complexity that arises, both within and across teams, and when multiple databases are in use or their advantages are being explored?

## Why use Flyway?

Flyway is used by 300,000 active users, from single developers to large IT teams in major companies. We can say we're the world’s most popular open source migrations framework for database deployments. Flyway takes care of just one task – database migrations – and does it quickly and simply.

A highly configurable solution, it enables a bespoke migrations-based deployment strategy to be created that is easy to adopt and scale across teams. Simple to set up and easy to master, it allows developers to manage migration scripts with confidence across 20 of the most common database engines through a standardized process, regardless of the platform used, and automate their sequential deployment. By doing so, it removes the manual, time-consuming and error-prone process of deploying migration scripts and can even be integrated into a wider CI/CD release management process.

As a result, teams can deliver updates, enhancements and fixes to customers more frequently, with developers aligning database and application development practices, and Ops teams no longer being weighed down by migration issues. More importantly, Flyway ensures that teams working on different platforms all have a consistent way of working, allowing them to be more flexible in responding to changing business needs.

Teams that introduce Flyway typically see a four-fold increase in database deployments, with some releasing changes ten times faster. By introducing an automated process which removes human error and hours of manual checks, migrations suddenly become fast and easy.

## The advantages of open source software

Flyway’s origins as an open source tool also bring other significant benefits. Open source software is gaining ground with development teams because it is developed by professionals for professionals, and offers high quality and support, low costs and no vendor lock-in.

While Flyway remains a community-based open source tool with thousands upon thousands of users as well as active contributors to the code base, it also has a dedicated development team behind it. This enables new features to be constantly developed for both the free Community version and the paid-for business version, Flyway Teams.

This gives development teams a route to prove the value of the solution using the Community version, without any up-front costs or commitment. Teams can make the first steps to demonstrate the value Flyway brings to DevOps practices, enabling the business case to be made for investing in the advanced features which Flyway Teams offers, such as:

- Additional functionality like undo scripts and dry runs
- Guaranteed compatibility with legacy databases for 10 years from their GA (General Availability) release date
- Upgraded support, directly from the Flyway engineering team

To find out more about Flyway, download the whitepaper, [Enabling fast and easy database migrations for high-performing DevOps teams](https://www.red-gate.com/products/dba/flyway/entrypage/enabling-fast-and-easy-database-migrations-whitepaper/).

To see just how fast and easy those migrations are, download the fully-functional, 30-day free trial of the Flyway Teams Edition.
