---
layout: blog
subtitle: Flyway 7.1.0 Released
permalink: /blog/flyway-7.1.0.html
author: philip
---

**Flyway 7.1.0** is out! This release contains new features and improvements over Flyway 7.0.0.

## Highlights
- Support pgpass for authentication
- Allow for filtering info output by date or version
- Allow arbitrary script callbacks
- Allow number of lock retries to be configured

You can find a detailed list of the changes in the [release notes](/documentation/learnmore/releaseNotes#7.1.0).

### Filtering info output
{% include teams.html %}

In the Flyway CLI output from `info` can be filtered to only the parts of the history that you care about using the following 4 parameters, or a combination thereof:
- `infoSinceDate`: Limits info to show only migrations applied after this date, and any unapplied migrations. Must be in the format `dd/MM/yyyy HH:mm` (e.g. `01/12/2020 13:00`)
- `infoUntilDate`: Limits info to show only migrations applied before this date. Must be in the format `dd/MM/yyyy HH:mm` (e.g. `01/12/2020 13:00`)
- `infoSinceVersion`: Limits info to show only migrations greater than or equal to this version, and any repeatable migrations. (e.g `1.1`)
- `infoUntilVersion`: Limits info to show only migrations less than or equal to this version, and any repeatable migrations. (e.g. `1.1`)

Example:
<pre class="console">&gt; flyway info -infoSinceDate="01/12/2020 13:00"
</pre>

See [the documentation](/documentation/usage/commandline/info#filtering-output) for more details. 

### Configuring lock retries

Sometimes you may want multiple instances of Flyway to run, each executing potentially very long lived migrations. Flyway will ensure only a single instance executes at once, but may timeout, giving an error for the instance that was waiting. With this new configuration parameter, you can tell Flyway how long you want it to try to acquire the lock before failing, allowing you to support this workflow.

```powershell
./flyway -lockRetryCount=10 migrate
```

See [the documentation](/documentation/configuration/parameters/lockRetryCount) for more details. 

### Highlights of changes since 7.0.0
- Add Log4J v2 support
- Allow custom S3Client to be supplied
- Make AWS S3 SDK optional
- Fix table locking retry logic
- Fix getting Oracle database name
- Parser fixes to Oracle, MySQL, and SQL Server
- Log instead of throwing exception when PostgreSQL advisory locking fails
- Passwords embedded in Flyway URLs redacted analogously to <code>flyway.password</code> parameter

You can find a detailed list of the changes in the [release notes](/documentation/learnmore/releaseNotes#7.0.1)

## Download it now and enjoy!

You can [download Flyway 7.1.0](/download) now! We recommend you upgrade if you are affected by any
of the issues logged in the release notes.

Flyway is brought to you with <i class="fa fa-heart"></i> by the [Redgate](https://red-gate.com) team:
[Julia Hayward](https://twitter.com/Julia_Hayward),
[Philip Liddell](https://github.com/Lyeeedar), and [Mikiel Agutu](https://twitter.com/mikielagutu),
with a lot of help from [Axel Fontaine](https://twitter.com/axelfontaine)
as well as the [many contributors](/documentation/contribute/hallOfFame).

Now it's your turn! Spread the word, follow [@flywaydb](https://twitter.com/flywaydb) on Twitter and
subscribe to our newsletter below to be the first one to be notified about updates.
