---
layout: blog
subtitle: Flyway 6.5.0 Released
permalink: /blog/flyway-6.5.0.html
author: philip
---

**Flyway 6.5.0** is out! This release contains new features and improvements over Flyway 6.4.0.

## Highlights

- You can now set a property to disable automatic schema creation
- You can now configure script encoding on a per-script bases
- You can now provide your own ResourceProvider and ClassProvider in the api

You can find a detailed list of the changes in the [release notes](/documentation/learnmore/releaseNotes#6.5).

### Toggle schema creation

By default, Flyway will attempt to create the schemas provided by the `schemas` and `defaultSchema` configuration options. This behavior can be toggled with the `createSchemas` configuration option.

This might be useful when you want complete control over how schemas are created.

See [the documentation](../documentation/concepts/migrations#toggle-schema-creation) for more details.

### Script encoding
Script config files have been extended to allow for specifying the encoding of the script they are linked to.

```properties
# Encoding of this SQL migration. Caution: changing the encoding after this migration has been run
# will invalidate the calculated checksum and require a `flyway repair`.
encoding=ISO_8859_1
```

See [the documentation](../documentation/configuration/scriptconfigfiles) for more details. 

### Highlights of changes since 6.4.0
- Add CockroachDB 20.1 support
- Add CockroachDB history table pseudolocking
- Many parser bug fixes for MySQL, MariaDB, DB2, Oracle, PostgreSQL, Sybase ASE
- Better support for SQL*Plus SET FEEDBACK
- Fixes to clean for SQL Server, DB2
- Fixes to Flyway repair

You can find a detailed list of the changes in the [release notes](/documentation/learnmore/releaseNotes#6.4.1)

## Download it now and enjoy!

You can [download Flyway 6.5.0](/download) now! We recommend you upgrade if you are affected by any
of the issues logged in the release notes.

Flyway is brought to you with <i class="fa fa-heart"></i> by the [Redgate](https://red-gate.com) team:
[Julia Hayward](https://twitter.com/Julia_Hayward),
[Philip Liddell](https://github.com/Lyeeedar), and [Mikiel Agutu](https://twitter.com/mikielagutu),
with a lot of help from [Axel Fontaine](https://twitter.com/axelfontaine)
as well as the [many contributors](/documentation/contribute/hallOfFame).

Now it's your turn! Spread the word, follow [@flywaydb](https://twitter.com/flywaydb) on Twitter and
subscribe to our newsletter below to be the first one to be notified about updates.
