---
layout: blog
subtitle: Flyway 6.4 Released
permalink: /blog/flyway-6.4.html
author: mikiel
---

**Flyway 6.4.0** is out! This release contains new features and improvements over Flyway 6.3.0.

## Highlights

- Allow wildcard patterns in the `locations` configuration option
- In the CLI, read configuration from standard input
- In the CLI, don't prompt for username and password for Azure AD auth types

You can find a detailed list of the changes in the [release notes](/documentation/learnmore/releaseNotes#6.4).

### Configuration from standard input

You can now provide configuration options to the standard input of the Flyway command line. Flyway will expect such configuration to be in the same format as a configuration file.

This allows you to compose Flyway with other operations. For instance, you can use `gpg` to encrypt a configuration file, including database credentials, then pipe the decrypted configuration into Flyway.

Encrypt the config file:
<pre class="console">
<span>&gt;</span> gpg -e -r "John Smith" flyway.conf
</pre>

Decrypt the file and pipe it to Flyway:
<pre class="console">
<span>&gt;</span> gpg -d -q flyway.conf.gpg | flyway info -configFiles=-
</pre>

See [the documentation](../documentation/usage/commandline/#configuration-from-standard-input) for more details.

### Wildcard locations

Locations can now contain wildcard patterns. This allows matching against a path pattern instead of a single path. Supported wildcards:<br/>

- `**` : Matches any 0 or more directories
  - e.g. `db/**/test` will match `db/version1.0/test`, `db/version2.0/test`, `db/development/version/1.0/test` but not `db/version1.0/release`
- `*` : Matches any 0 or more non-separator characters
  - e.g. `db/release1.*` will match `db/release1.0`, `db/release1.1`, `db/release1.123` but not `db/release2.0`)
- `?` : Matches any 1 non-separator character
  - e.g. `db/release1.?` will match `db/release1.0`, `db/release1.1` but not `db/release1.11`

## Download it now and enjoy!

You can [download Flyway 6.4.0](/download) now! We recommend you upgrade if you are affected by any
of the issues logged in the  [release notes](/documentation/learnmore/releaseNotes#6.4).

Flyway is brought to you with <i class="fa fa-heart"></i> by the [Redgate](https://red-gate.com) team:
[Julia Hayward](https://twitter.com/Julia_Hayward),
[Philip Liddell](https://github.com/Lyeeedar), and [Mikiel Agutu](https://twitter.com/mikielagutu),
with a lot of help from [Axel Fontaine](https://twitter.com/axelfontaine)
as well as the [many contributors](/documentation/contribute/hallOfFame).

Now it's your turn! Spread the word, follow [@flywaydb](https://twitter.com/flywaydb) on Twitter and
subscribe to our newsletter below to be the first one to be notified about updates.