---
layout: blog
subtitle: Flyway 6.3.0 Released
permalink: /blog/flyway-6.3.0.html
author: philip
---

**Flyway 6.3.0** is out! This release contains new features and improvements over Flyway 6.2.0.

## Highlights

The highlights of the features introduced since the 6.2.0 release include:


#### New in Flyway 6.3.0
- Add a `loadDefaultConfigurationFiles` method to the api to load `flyway.conf` files from the default locations
- Add working directory support to the clients that didn't already have it
- Add support for multiline properties in configuration files
- Add support for a `flyway:timestamp` default placeholder
- Placeholders now affect the migration checksum


#### Introduced in patch releases since Flyway 6.2.0
- Add support for CockroachDb 19.1
- Oracle SQL*Plus parsing extended to support `SPOOL`
- Oracle drivers are now shipped with the commandline
- Add support for Snowflake key-auth and SQL Server integratedSecurity


You can find a detailed list of issues fixed in the [release notes](/documentation/learnmore/releaseNotes#6.3.0).


## Load default configuration files API method

The API now contains a method to load configuration files from the default locations. These are:
- `$installationDir$/conf/flyway.conf`
- `$user.home$/flyway.conf`
- `$workingDirectory$/flyway.conf`

You can use it as follows:

```api
Flyway flyway = Flyway.configure(newClassLoader)
    .loadDefaultConfigurationFiles()
    .load();
```


## Multiline properties in configuration files

Configuration files now support splitting a property over multiple lines. To do this simple end a line with a backslash. All sequential backslash-ending lines will be appended together when the configuration file is loaded by Flyway.

e.g.

```properties
flyway.locations=filesystem:my/migrations/release-v1,\
filesystem:my/migrations/release-v2,\
filesystem:my/migrations/release-v3,\
filesystem:my/migrations/release-v3.5,\
filesystem:my/migrations/release-v4,\
filesystem:my/migrations/release-v5
```


## Timestamp placeholder

A new default placeholder has been added, called `flyway:timestamp`. This contains the current time, in the format `yyyy-MM-dd HH:mm:ss`.



## Download it now and enjoy!

You can [download Flyway 6.3.0](/download) now! We recommend you upgrade if you are affected by any
of the issues logged in the release notes.

Flyway is brought to you with <i class="fa fa-heart"></i> by the [Redgate](https://red-gate.com) team:
[Julia Hayward](https://twitter.com/Julia_Hayward),
[Philip Liddell](https://github.com/Lyeeedar), and [Mikiel Agutu](https://twitter.com/mikielagutu),
with a lot of help from [Axel Fontaine](https://twitter.com/axelfontaine)
as well as the [many contributors](/documentation/contribute/hallOfFame).

Now it's your turn! Spread the word, follow [@flywaydb](https://twitter.com/flywaydb) on Twitter and
subscribe to our newsletter below to be the first one to be notified about updates.
