---
layout: blog
subtitle: Flyway 6.2.0 Released
permalink: /blog/flyway-6.2.0.html
author: alex
---

**Flyway 6.2.0** is out! This release contains new features and improvements over Flyway 6.1.0.

## Highlights

The highlights of the 6.2.0 release include:

- Add `-color` CLI option to allow overriding the default colorization
- Add `flyway.validateMigrationNaming` option to fail validation if scripts that don't match the naming pattern are found in one of the configured locations
- Create all schemas specified in `flyway.schemas`
- Add `FLYWAY_DEFAULT_SCHEMA` environment variable

We've also written a guide for adding support to your database.

You can find a detailed list of issues fixed in the [release notes](/documentation/learnmore/releaseNotes#6.2.0).

## Validate migration naming

We've added the `flyway.validateMigrationNaming` configuration option to enforce the naming pattern for scripts in the configured locations. When set to `true`, validation will fail if any such scripts are found. If left as `false` (the default and current behavior), such scripts are ignored.

This can be useful to identify scripts with naming errors such as `V1_My_description.sql` (single instead of double underscore used as separator) or `v1__My_description.sql` (lowercase instead of uppercase "v" used as prefix).

## Create all schemas

Previously, if at least one schema in `flyway.schemas` already existed, none would be created. Flyway will now create all non-existing schemas.

## Override CLI colorization

We've added [the `-color` CLI option](/documentation/usage/commandline/#colors) to allow overriding the colorization strategy. Set it to `never` to disable it, `always` to enforce it and `auto` (the default and current behavior) to colorize when appropriate (e.g. when attached to a console).

## Contribute database support to Flyway

We've published [a guide](/documentation/contribute/contributingDatabaseSupport) for people who want to see their database supported by Flyway.

## Download it now and enjoy!

You can [download Flyway 6.2.0](/download) now! We recommend you upgrade if you are affected by any
of the issues logged in the release notes.

Flyway is brought to you with <i class="fa fa-heart"></i> by the [Redgate](https://red-gate.com) team:
[Julia Hayward](https://twitter.com/Julia_Hayward),
[Alex Tercete](https://twitter.com/alextercete), and [Mikiel Agutu](https://twitter.com/mikielagutu),
with a lot of help from [Axel Fontaine](https://twitter.com/axelfontaine)
as well as the [many contributors](/documentation/contribute/hallOfFame).

Now it's your turn! Spread the word, follow [@flywaydb](https://twitter.com/flywaydb) on Twitter and
subscribe to our newsletter below to be the first one to be notified about updates.