---
layout: blog
subtitle: Flyway 6.1.0 Released
permalink: /blog/flyway-6.1.0.html
author: alex
---

**Flyway 6.1.0** is out! This release contains new features and improvements over Flyway 6.0.0.

## Highlights

The highlights of the 6.1.0 release include:

- Manual transaction override
- Snowflake support
- Machine-readable output for the `info` command
- Default placeholders
- Environment variable substitution in config files

You can find a detailed list of issues fixed in the [release notes](/documentation/learnmore/releaseNotes#6.1.0).

## Manual transaction override

You can now override Flyway's decision to wrap the execution of a script in a transaction by creating a _script config file_: a file which lives alongside the script and which is named by appending `.conf` to the script file name.

For example, to force the migration file `V1__Non_transactional.sql` to run outside a transaction, create a config file `V1__Non_transactional.sql.conf` next to it with the following contents:

```properties
executeInTransaction=false
```

This approach also works for callbacks.

## Snowflake support

<img src="/assets/posts/flyway-6.1.0/snowflake.png" style="float: left; height: 50px; margin: 10px;"> We now support the [**Snowflake**](https://www.snowflake.com/) database. For the time being, you'll still need to download the driver manually when using the CLI, but we're in touch with the Snowflake team to get permission to ship it with Flyway.

Find out more [here](/documentation/database/snowflake)!

## Machine-readable output

You can now output JSON from `flyway info` by using the `-outputType=json` flag.

```bash
flyway info -outputType=json
```

We expect to expand this to other commands over time.

## Default placeholders

[Default placeholders](/documentation/concepts/migrations#placeholder-replacement) (prefixed by the `flyway` namespace) can now be used in migration scripts:

```sql
GRANT SELECT ON SCHEMA ${flyway:defaultSchema} TO ${flyway:user};
```

In addition to the two shown in the example above, you can also use `${flyway:database}`.

## Environment variable substitution in config files

Environment variables are now [substituted in config files](/documentation/configuration/configfile#environment-variable-substitution):

```properties
flyway.placeholders.myPlaceholder=${MY_ENVIRONMENT_VARIABLE}
```

## Download it now and enjoy!

You can [download Flyway 6.1.0](/download) now! We recommend you upgrade if you are affected by any of the issues
logged in the release notes.

Flyway is brought to you with <i class="fa fa-heart"></i> by the [Redgate](https://red-gate.com) team:
[Julia Hayward](https://twitter.com/Julia_Hayward),
[Alex Tercete](https://twitter.com/alextercete), and [Mikiel Agutu](https://twitter.com/mikielagutu),
with a lot of help from [Axel Fontaine](https://twitter.com/axelfontaine)
as well as the [many contributors](/documentation/contribute/hallOfFame).

Now it's your turn! Spread the word, follow [@flywaydb](https://twitter.com/flywaydb) on Twitter and subscribe
to our newsletter below to be the first one to be notified about updates.