---
layout: blog
subtitle: "Flyway 6.0.0 Released"
permalink: /blog/flyway-6.0.0.html
author: julia
---
**Flyway 6.0.0** is out! This is the first full release by Redgate, and contains **many new features and
improvements** over Flyway 5.2.4. This version also adds more features and fixes on top of the previous beta releases.  

## Highlights

The highlights of the 6.0.0 release include:

- A brand new parser
- Firebird support
- Validation of migration encoding
- SELECT output is now configurable
- Colorized output
- Database support policy made more consistent
- Many bug fixes

You can find a detailed list of issues fixed in the [release notes](/documentation/learnmore/releaseNotes#6.0.0).

## Parser

The SQL parser has been completely rebuilt from the ground up for better performance, lower memory consumption and 
vastly improved handling of some of the edge cases the old parser had been struggling with for years. This 
originally appeared in the 6.0.0-beta, and our early adopters' experiences with it have helped us iron out
some more edge cases.

## Firebird

<img src="/assets/posts/flyway-6.0.0/firebird.jpg" style="float: left; height: 100px; margin: 10px;"> We now support the 
open-source [**Firebird**](https://firebirdsql.org/en/start/) database. Initially we will be supporting 
the current release, Firebird 3.0, and are testing against the beta builds of Firebird 4.0 so we'll be ready
when it is formally released. We decided not 
to support v2.5 straight away as it dates from 2010, point-release development stopped in Q2 2019, and
it will be moved to end-of-life as soon as 4.0 is out. We'll review how much demand there is
for older versions again soon. 

Find out more [here](/documentation/database/firebird)!


## Encoding validation

If you have a development team producing scripts in a number of environments, it's quite possible that they
will have different encodings - and be executed with invalid characters. We've enhanced the initial validation
step so that if Flyway can reliably detect a problem, for example, if it is expecting a `UTF-8` script and finds 
a `windows-1252` file, it will stop and complain rather than doing something unexpected to the database. 

## SELECT output configuration 

{% include teams.html %} If you are running migrations with `SELECT` statements that return a large amount of output, 
it can obscure the
progress and outcome of the migrations as well as potentially filling up your log folders. We've added a new 
option `outputQueryResults` so that you can suppress this output if it's not helpful to you. 

## Colorized output

We've enhanced the command-line output still further by automatically colouring errors red, warnings yellow
and success messages green, making it even more clear how your migrations are progressing. This will happen
whenever `stdout` is associated with a terminal.

![Example colorized output](/assets/posts/flyway-6.0.0/colorized-output.png) 

## Many new database versions

There have been a lot of database releases since 5.2.4, and this is the first production release with support for:

- PostgreSQL 11 and 12 
- DB2 11.5 
- HSQLDB 2.5 
- CockroachDB 2.1 
- SQL Server 2019 
- MariaDB 10.4 
- Oracle 19c 

## A more consistent approach to database support

We've now standardised on database versions being supported by both Community and Pro editions for **five** years
since their release. The Enterprise edition provides ongoing support for older databases, for customers that 
require it.

## Download it now and enjoy!

You can [download Flyway 6.0.0](/download) now! **All users are encouraged to upgrade.**

Flyway is brought to you with <i class="fa fa-heart"></i> by the [Redgate](https://red-gate.com) team: 
[Julia Hayward](https://twitter.com/Julia_Hayward),
[Alex Tercete](https://twitter.com/alextercete), and [Mikiel Agutu](https://twitter.com/mikielagutu),
with a lot of help from [Axel Fontaine](https://twitter.com/axelfontaine)
as well as the [many contributors](/documentation/contribute/hallOfFame).

Now it's your turn! Spread the word, follow [@flywaydb](https://twitter.com/flywaydb) on Twitter and subscribe
to our newsletter below to be the first one to be notified about updates. We are already looking at what will appear
in Flyway 6.1.0, and you can help us by giving a thumbs-up to existing feature requests in our 
[Github Issues](https://github.com/flyway/flyway/issues), or submitting a new issue yourself. 
