---
layout: blog
subtitle: "Flyway 5.2.0 Released"
permalink: /blog/flyway-5.2.0.html
---
After a summer of hard work we are happy to release the next major update in the Flyway 5.x series, **Flyway 5.2.0**.
It comes with many of new features and improvements.

## Highlights

These are the highlights of this release:
- Java 11 support
- Oracle 18c support
- MariaDB 10.3 support
- Percona XtraDB Cluster support
- Aurora MySQL and Aurora PostgreSQL support
- Configuration improvements
- Docker Compose improvements
- Unified command-line distribution
- Oracle SQL*Plus @other_script.sql execution support

Let's dive right in!

## Java 11 support

The Java platform keeps on moving forward and has now arrived at an important milestone: Java 11. The release marks
both the introduction of the new commercial Oracle LTS release model with one LTS release every 3 years as well as
the fact that feature parity has now been achieved at last between OpenJDK and the Oracle JDK. Starting with this 
release both the Oracle JRE and the OpenJDK JRE are now fully supported by Flyway.

## Oracle 18c support

Five years after the initial release of Oracle 12, we now have a brand new Oracle major release: 18c. It was initially
available exclusively for Oracle Cloud. And now since August 2018 it is also available for download and Flyway 5.2.0
comes with full support for it. 

## MariaDB 10.3 support

MariaDB is also constantly moving forward. Version 10.3 is now out with additional features not found in MySQL.

<img src="/assets/logos/mariadb.svg" title="MariaDB" height="85">

Starting with 5.2.0, all editions of Flyway now officially supports this release as well.

## Percona XtraDB Cluster support

On the MySQL side, Flyway now also fully supports Percona XtraDB Cluster 5.7.

<img src="/assets/logos/perconaxtradbcluster.png" title="Percona XtraDB Cluster">

## Aurora MySQL and Aurora PostgreSQL support

And finally on the database front, Flyway 5.2.0 now also fully supports both Amazon Aurora MySQL and Amazon Aurora
PostgreSQL in all versions of the respective engines.

## Configuration improvements

[Flyway 5.1.0](/blog/flyway-5.1.0.html) introduced a new fluent configuration style for the Flyway API.
This new style has now become the new default. Configuring Flyway can now be done with just a single statement:

```java
Flyway flyway = Flyway.configure().dataSource(url, user, password).load();
flyway.migrate();
```

And this can be made even more concise if you only want to invoke a single operation:
```java
Flyway.configure().dataSource(url, user, password).load().migrate();
```

This marks an important step in the transition to making the Flyway object itself immutable, which will enable
further optimizations from Flyway 6.0 onwards.

## Docker Compose improvements

Many Docker images for databases on Docker Hub unfortunately do not support Docker's very useful `HEALTHCHECK` feature
and there doesn't appear to be a solution in sight.

This particularly complicates things when used in conjunction with Flyway in a Docker Compose setup where all containers
are started at the same time, as this almost unanimously results in the Flyway container coming up before the database
is ready and then failing to connect.

While workarounds such as adding an extra sleep to the Flyway container's command do work, they aren't satisfactory as
the sleep will either be too short and things will fail, or the sleep will be too long and it will needlessly delay
things.

To remedy this Flyway 5.2.0 now comes with a new `connectRetries` property which instructs Flyway to reattempt failed
connections up to this many times at 1 second intervals. This together now enables the following nice
 `docker-compose.yml` setup:

```yml
version: '3'
services:
  flyway:
    image: boxfuse/flyway
    command: -url=jdbc:mysql://db -user=root -password=P@ssw0rd -connectRetries=300 migrate
    volumes:
    - .:/flyway/sql
    depends_on:
    - db
  db:
    image: mysql
    environment:
    - MYSQL_ROOT_PASSWORD=P@ssw0rd
    command: --character-set-server=utf8mb4 --collation-server=utf8mb4_unicode_ci
    ports:
    - 3306:3306
```

Running `docker-compose up` will pull both images, start both containers and Flyway will wait up to 300 seconds for
MySQL to become available. As soon as it is and Flyway will connect to it and perform the migration.

## Unified command-line distribution
{% include teams.html %}

Starting with Flyway 5.2.0 the command-line distribution comes bundled with all editions of Flyway. By default the
community edition is active. To launch any of the other editions set the `FLYWAY_EDITION` environment variable to 
either `trial`, `pro` or `enterprise`. These 3 also require the new `licenseKey` parameter to be set to `trial` to
accept the [Flyway Trial Edition license](/licenses/flyway-trial) and start a 30 trial or to your actual license key
for Flyway Pro and Enterprise Edition.

This in turn means that the [Flyway Docker image](https://hub.docker.com/r/flyway/flyway/) now also comes with all
edition of Flyway, making it easier for Flyway Pro and Enterprise Edition customers to use Flyway directly from
Docker Hub.

## Oracle SQL*Plus @other_script.sql execution support
{% include teams.html %}

Flyway 5.2.0 continues to expand Flyway's [SQL*Plus command support](/documentation/database/oracle#sqlplus-commands).
This release now adds support for the following additional commands:
 
- `@`
- `@@`
- `SET LINESIZE`
- `SET SUFFIX`
- `SHOW LINESIZE`
- `SHOW SUFFIX`
- `START`

With this Flyway now automatically handles SQL*Plus `@other_script.sql` external script references. These scripts are
automatically discovered using the configured Flyway locations and they are executed within the same transaction as the
main migration. Their checksum is also taken into account when calculating the overall checksum of the migration.

Additionally passing arguments is also fully supported and they will be mapped as expected to the numbered SQL*Plus
placeholders `&1`, `&2`, ...  

## Much more

All this is just the tip of the iceberg. With almost 50 issues fixed and features implemented, this release packs
tons of small improvements and polish across the board. So make sure to check out the [release notes](/documentation/learnmore/releaseNotes).

## Grab it while it's hot!

Enjoy Flyway 5.2.0 and [grab it while it's hot!](/download)

It is the fastest, most complete and most reliable Flyway release so far. **All users are encouraged to upgrade.**

Flyway is brought to you with <i class="fa fa-heart"></i> by [Axel Fontaine](https://twitter.com/axelfontaine),
[Boxfuse](https://boxfuse.com) and the [many contributors](/documentation/contribute/hallOfFame).

Now it's your turn! Spread the word, follow [@flywaydb](https://twitter.com/flywaydb) on Twitter and subscribe
to our newsletter below to be the first one to be notified about updates.