---
layout: blog
subtitle: "Flyway 5.1.0 Released"
permalink: /blog/flyway-5.1.0.html
---
Today we are happy to release the first major update in the Flyway 5.x series, **Flyway 5.1.0**. It comes with lots
of new features and improvements.

## Highlights

These are the highlights of this release:
- Java 10 support
- CockroachDB 2.0 support
- MySQL 8.0 support
- Informix support
- Callback revamp
- Configuration improvements
- Batching support
- Streaming support
- Oracle SQL*Plus variable substitution support

Let's dive right in!

## Java 10 support

Since the release of Java 9 in September last year, the Java platform has experienced a dramatic change in its release 
pace, with new releases coming out every 6 months. Flyway 5.1.0 now officially adds support for the brand new Java 10
release, extending support to Java 8, 9 and 10 for Flyway Community and Pro Edition and Java 6, 7, 8, 9 and 10 for
Flyway Enterprise Edition.

## CockroachDB 2.0 support

This releases comes with an update to CockroachDB support. CockroachDB has been rapidly gaining adaption
as a new PostgreSQL-compatible distributed SQL database built on a transactional and strongly-consistent
key-value store. 

![CockroachDB](/assets/logos/cockroachdb.png)

It has progressed rapidly since Flyway 5.0's release and Flyway 5.1.0 now adds official support for the brand new
CockroachDB 2.0 release in addition to the existing CockroachDB 1.1 support.

## MySQL 8.0 support

After a long development phase, MySQL 8.0 finally reached general availability with the MySQL 8.0.11 release last month.

<img src="/assets/logos/mysql.svg" title="MySQL" height="85">

Starting with 5.1.0, all editions of Flyway now officially supports this release as well.

## Informix support

Starting with Flyway 5.1.0, Informix has now been added to Flyway's ever growing list of supported databases.
All editions of Flyway now fully support Informix 12.10.

## Callback revamp

As the need for even more opportunities to hook into Flyway's lifecycle has become apparent, it became clear that
Flyway's existing callback infrastructure was in need of of revamp. With Flyway 5.1.0, there is now a brand new way
to write custom Java-based callbacks with the newly added `org.flywaydb.core.api.callback.Callback` interface:

```java
/**
 * This is the main callback interface that should be implemented to handle Flyway lifecycle events.
 */
public interface Callback {
    /**
     * Whether this callback supports this event or not. This is primarily meant as a way to optimize event
     * handling by avoiding unnecessary connection state setups for events that will not be handled anyway.
     *
     * @param event   The event to check.
     * @param context The context for this event.
     * @return {@code true} if it can be handled, {@code false} if not.
     */
    boolean supports(Event event, Context context);

    /**
     * Whether this event can be handled in a transaction or whether it must be handled outside a transaction
     * instead. In the vast majority of the cases the answer will be {@code true}. Only in the rare cases 
     * where non-transactional statements are executed should this return {@code false}.
     * This method is called before {@link #handle(Event, Context)} in order to determine in advance whether
     * a transaction can be used or not.
     *
     * @param event   The event to check.
     * @param context The context for this event.
     * @return {@code true} if it can be handled within a transaction (almost all cases). {@code false} if it
     * must be handled outside a transaction instead (very rare).
     */
    boolean canHandleInTransaction(Event event, Context context);

    /**
     * Handles this Flyway lifecycle event.
     *
     * @param event   The event to handle.
     * @param context The context for this event.
     */
    void handle(Event event, Context context);
}
```

This new facility comes with a number of clear improvements including the ability to handle a wider range of lifecyle
events, including failure conditions, and the ability to make callback execute non-transactionally.

Flyway's built-in SQL-based callback has already been retrofitted to seamlessly take advantage of this. This is particularly interesting
for PostgreSQL, Redshift and SQL Server users as Flyway now automatically detects whether a SQL callback contains a
SQL statement that cannot be run within a transaction and will then run the callback outside of a transaction if needed.

Additionally it is now possible to supply multiple SQL-based callbacks for the same lifecycle event. When more than
one SQL callback is present for an event, Flyway will apply the callbacks in the order of their description.

Existing interfaces have been deprecated, however you have plenty of time to migrate at your best convenience.
Existing Java-based callbacks will continue to work unchanged until Flyway 6.0, after which that support will be removed. 

## Configuration improvements

Building on the work that was started with Flyway 5.0, Flyway 5.1 now introduces a number of powerful additions to
Flyway's configuration infrastructure.

First of all API users can now also ask Flyway to configure itself using [environment variables](/documentation/configuration/envvars).

Additionally Flyway now comes with a new `Configuration` interface along with two implementations:
`FluentConfiguration` for a modern fluent-style configuration and `ClassicConfiguration` for a classic JavaBean-style
configuration. This is particularly useful for users wanting to decouple configuration from Flyway usage and it also
makes it easy to supply your own configuration implementations if needed.  

## Batching support
{% include teams.html %}

When dealing with large amounts of reference data, the many network roundtrips of individual `INSERT` statements can
cause quite overhead. Flyway Pro and Enterprise Edition now let you dramatically speed things up by enabling the
`flyway.batch` flag. This will cause Flyway to automatically detect DML statements and batch their execution. On large
datasets this can result in an up to 99% reduction in network round-trip times. 

## Streaming support
{% include teams.html %}

By default Flyway fully loads SQL migration files in memory in order to parse and execute them. This is perfectly
fine for the vast majority of the cases. When dealing with very large migration files, measured in the hundreds of MB or
even multiple GB per file, this can become a problem and lead to very high memory consumption or even out of memory errors.

Starting with 5.1.0, Flyway Pro and Enterprise Edition let you dramatically reduce memory usage by enabling the
`flyway.stream` flag. This will causes Flyway to automatically check whether a SQL migration to be loaded from the
filesystem is large than 16 KB and if it is, transparently stream it instead of fully loading it.

## Oracle SQL*Plus variable substitution support
{% include teams.html %}

Building upon Flyway's [existing SQL*Plus support](/documentation/database/oracle#sqlplus-commands),
once you enable the `flyway.oracle.sqlplus` flag, Flyway now also automatically handles the following additional commands:
 
- `DEFINE`
- `UNDEFINE`
- `SET DEFINE`
- `SET SCAN`

With this Flyway now automatically handles SQL*Plus `&my_var` placeholders with full support for defining and undefining
values directly in your migrations scripts as well as changing the define character from `&` to the character of your choice.

When attempting to resolve placeholders, Flyway will consult both its own placeholder store and well as the dynamic
SQL*Plus one. 

## Much more

All this is just the tip of the iceberg. With almost 60 issues fixed and features implemented, this release packs
tons of small improvements and polish across the board. So make sure to check out the [release notes](/documentation/learnmore/releaseNotes).

## Grab it while it's hot!

Enjoy Flyway 5.1.0 and [grab it while it's hot!](/download)

It is the fastest, most complete and most reliable Flyway release so far. **All users are encouraged to upgrade.**

Flyway is brought to you with <i class="fa fa-heart"></i> by [Axel Fontaine](https://twitter.com/axelfontaine),
[Boxfuse](https://boxfuse.com) and the [many contributors](/documentation/contribute/hallOfFame).

Now it's your turn! Spread the word, follow [@flywaydb](https://twitter.com/flywaydb) on Twitter and subscribe
to our newsletter below to be the first one to be notified about updates.