---
layout: blog
subtitle: "Flyway 5.0.0 Released"
permalink: /blog/flyway-5.0.0.html
---
**Flyway 5.0.0** is out and this is a big release! It has been a long time coming and it ships with **lots of new features and
improvements**.

## Highlights

These are the highlights of this release:
- Deprecated code removal, base platform upgrades and plugin spinoffs
- Multiple editions
- Java 9 support
- CockroachDB support
- Official Docker images
- Improved configuration
- Undo migrations
- Dry runs
- Oracle SQL*Plus commands support


Let's dive right in!

## Deprecated code removal, base platform upgrades and plugin spinoffs

When developing Flyway we take compatibility very seriously. There are however times when the project evolves in
directions we hadn't originally anticipated and things that were once adequate now become problematic. We work very hard
to avoid breaking things and instead we carefully deprecate and guide our users to suitable replacements.
And that's why we love a major release. It always feels like a breath of fresh air, as it gives us with the opportunity
to finally prune the codebase of all those elements we have previously deprecated. And Flyway 5.0.0 is no exception.

Starting with this release:
- All previously deprecated methods have been removed
- **Java 8** is the new minimum supported version (up from Java 6)
- Maven 3.0 is the new minimum supported version (up from Maven 2.2)
- Gradle 3.0 is the new minimum supported version (up from Gradle 2.1)
- The JRE shipping with Flyway Command-line has be updated to 8u152
- All drivers shipping with Flyway Command-line have been updated to their latest versions


The other big change is that the Ant and SBT plugins have now been spun off in their own separate repos
([flyway/flyway-ant](https://github.com/flyway/flyway-ant) and [flyway/flyway-sbt](https://github.com/flyway/flyway-sbt))
and are now being maintained by Tomas Tulka and David Weber respectively.
And for the SBT users out there, the SBT plugin is now fully compatible with SBT 1.0.

## Multiple editions

The biggest change by far though is that Flyway now comes in 3 editions:

- Flyway Community Edition
- Flyway Pro Edition
- Flyway Enterprise Edition

**Flyway Community Edition** is the new name for Flyway open-source and continues to provide the great Apache v2 licensed 
database migration tool and library you know. It remains as focused and dedicated to provide you with the best database
migration and continuous delivery tooling out there. In fact it is even better than ever and has landed a vast number
of improvements in this release. And we have plenty more in store for the releases to come!

**Flyway Pro Edition** builds on the foundation of Flyway Community Edition and comes with additional features aimed at
power users and companies requiring even more flexibility. Additional features include Oracle SQL*Plus commands support,
dry runs, undo migrations, custom error handlers and more. We'll discuss some of these below. Flyway Pro Edition is
available under a commercial license as a yearly subscription. We made sure it also ships with full source code, so that
you have the same ease of debugging as you would have with the community edition.

**Flyway Enterprise Edition** includes everything from Flyway Pro Edition and more. It is aimed at companies that have the widest
variety and the most extensive type of workloads. And because we know not every project is able to always upgrade as
quickly to the latest version of all its platforms, this edition has been designed to maintain compatibility with
Java 6 and Java 7 as well as older versions of databases that no longer enjoy mainstream support by their vendors.
Additionally Flyway Enterprise Edition also comes with dedicated email supported with guaranteed response times to
ensure that whenever you have an issue, someone is there to assist you.  

## Java 9 support

Flyway 5.0.0 now comes with full Java 9 compatibility. All internal classes have been upgraded to support both Java 8
and Java 9 and Flyway 5.0.0 now works perfectly with both releases. For now `flyway-core` ships as an automatic module
with the id `org.flywaydb.core`. We plan on moving to a fully modular jar in the future once Java 9 becomes the new
baseline for the project.

## CockroachDB support

This releases brings CockroachDB support to the table. CockroachDB has been rapidly gaining adaption as a new kind of
cloud-native SQL database. It is distributed SQL database built on a transactional and strongly-consistent
key-value store. It scales horizontally; survives disk, machine, rack, and even datacenter failures with minimal
latency disruption and no manual intervention; supports strongly-consistent ACID transactions; and provides a familiar
SQL API for structuring, manipulating, and querying data.

![CockroachDB](/assets/logos/cockroachdb.png)

Starting with Flyway 5.0.0, CockroachDB 1.1 and newer are now fully supported by all editions of Flyway.

## Official Docker images

![Docker Hub](/assets/posts/flyway-5.0.0/dockerhub.png){: .screenshot}

We always try to make Flyway as easy to use as possible and installation is a big part of that experience. Starting
with Flyway 5.0.0 we now also provide official Docker images for Flyway. If you are a Docker user, all you need to do
to get up and running is

<pre class="console"><span>&gt;</span> docker pull <strong>boxfuse/flyway</strong></pre>

From there on migrating a database is as easy as

<pre class="console"><span>&gt;</span> docker run --rm <strong>boxfuse/flyway</strong> -url=... -user=... -password=... migrate</pre>

We have made sure it is easy for your to add your own migrations files, JDBC drivery and configuration as well.
Go to Docker Hub for [detailed usage instructions](https://hub.docker.com/r/boxfuse/flyway/).

## Improved configuration

To make it easier to work with Docker, Heroku, Boxfuse and other cloud-native solutions we have added support
for environment variable-based configuration for Flyway Command-line as well as the Maven and Gradle plugins.

Now all you need to do is launch your instance or container with the following environment variables and Flyway will
automatically pick them up:

- `FLYWAY_URL=...`
- `FLYWAY_USER=...`
- `FLYWAY_PASSWORD=...`

All configuration properties are supported. You can find a detailed reference in the [docs](/documentation/configuration/envvars).

Additionally Flyway can now load configuration from multiple configuration files, in the order you have specified them.
This makes it easy to keep certain properties like passwords out of certain configuration files, like the ones checked into SCM.

## Undo migrations

This has certainly been the most controversial design decision Flyway took from the start: no down or undo migrations.
The only way is forward. That practice, in combination with things like rigorous CI and staging environments,
backward-compatible migration, DDL transactions and storage system snapshot restores have proven this initial decision
to be very viable indeed as it really fits continuous delivery workflows like a glove. There are however situations and
workflows where the lack of undo migrations did cause some real pain. To address this we have now added support for them
to the Flyway Pro and Enterprise Editions. Defining an undo migration to compensate for the effects of a regular
versioned migration is now as simple as creating a SQL file starting `U` instead of `V` and populating it with the
necessary statements.

For example to undo the effects of version 5 you can now create a file named `U5__My_description.sql` and run

<pre class="console"><span>&gt;</span> flyway <strong>undo</strong></pre>

This will by default undo the latest versioned migration. To undo more than one migration in one go, you can set `target`
to the desired version up to which you want to undo. You can also combine this with `group` to undo all these migrations
within a single transaction.

## Dry runs

Another heavily requested feature has been the ability to perform migration dry runs. This way Flyway doesn't directly
modify the database and produces a `.sql` file instead containing all the statements it would have otherwise executed.
We have now added this feature to the Flyway Pro and Enterprise Editions. All you need to do to achieve this is

<pre class="console"><span>&gt;</span> flyway migrate <strong>-dryRunOutput=</strong>/my/sql/dryrun-outputfile.sql</pre>

Flyway will then use read-only database connections, leave the database untouched and output all statements in this file.
This works with both SQL and Java migrations as well as any custom types you may have. And it's not just migrate. 
All other Flyway commands are supported as well.

## Oracle SQL*Plus commands support

Many Oracle users migrating to Flyway often have scripts containing SQL*Plus statements. These are special statements
that aren't regular SQL. Instead they are instructions for the popular SQL*Plus CLI. The Oracle JDBC driver doesn't
support them and this caused these script to fail. The Flyway Pro and Enterprise Editions now come with direct support
for these commands. In Flyway 5.0.0 the following commands are fully supported:
 
- `EXECUTE`
- `PROMPT`
- `REMARK`
- `SET NULL`
- `SET SERVEROUTPUT OFF`
- `SET SERVEROUTPUT ON`
- `SHOW CON_ID`
- `SHOW ERRORS`
- `SHOW RELEASE`
- `SHOW USER`
- `WHENEVER SQLERROR CONTINUE`
- `WHENEVER SQLERROR EXIT FAILURE`

All other SQL*Plus commands (including their short forms) are cleanly suppressed with a warning. This makes it much
easier to move large numbers of existing migration scripts directly to a Flyway-based workflow without needing to
correct them. 

## Much more

All this is just the tip of the iceberg. With more than 100 issues fixed and features implemented, this release packs
tons of small improvements and polish across the board. There are many parser improvements, clean improvements,
non-transactional statement support improvements and lots of bug fixes. In fact there are far to many to list here,
so make sure to check out the [release notes](/documentation/learnmore/releaseNotes).

## Grab it while it's hot!

Enjoy Flyway 5.0.0 and [grab it while it's hot!](/download)

It is by far the fastest, most complete and most reliable Flyway release so far. **All users are encouraged to upgrade.**

Flyway is brought to you with <i class="fa fa-heart"></i> by [Axel Fontaine](https://twitter.com/axelfontaine),
[Boxfuse](https://boxfuse.com) and the [many contributors](/documentation/contribute/hallOfFame).

Now it's your turn! Spread the word, follow [@flywaydb](https://twitter.com/flywaydb) on Twitter and subscribe
to our newsletter below to be the first one to be notified about updates.

