# Admin Dashboard for iOS

![Flyve MDM banner](https://user-images.githubusercontent.com/663460/26935464-54267e9c-4c6c-11e7-86df-8cfa6658133e.png)

[![License](https://img.shields.io/badge/license-LGPL_v3.0-blue.svg)](https://github.com/flyve-mdm/ios-mdm-dashboard/blob/develop/LICENSE.md)
[![Follow twitter](https://img.shields.io/twitter/follow/FlyveMDM.svg?style=social&label=Twitter&style=flat-square)](https://twitter.com/FlyveMDM)
[![Project Status: WIP](http://www.repostatus.org/badges/latest/wip.svg)](http://www.repostatus.org/#wip)
[![Telegram Group](https://img.shields.io/badge/Telegram-Group-blue.svg)](https://t.me/flyvemdm)
[![IRC Chat](https://img.shields.io/badge/IRC-%23flyvemdm-green.svg)](http://webchat.freenode.net/?channels=flyve-mdm)
[![Conventional Commits](https://img.shields.io/badge/Conventional%20Commits-1.0.0-yellow.svg)](https://conventionalcommits.org)
[![GitHub release](https://img.shields.io/github/release/flyve-mdm/ios-mdm-dashboard.svg)](https://github.com/flyve-mdm/ios-mdm-dashboard/releases)

Flyve MDM is a Mobile device management software that enables you to secure and manage all the mobile devices of your business or family via a web-based console.

To get started, check out [Flyve MDM Website](https://flyve-mdm.com/)!

## Table of contents

* [Synopsis](#synopsis)
* [Build Status](#build-status)
* [Installation](#installation)
* [Documentation](#documentation)
* [Versioning](#versioning)
* [Contact](#contact)
* [Professional Services](#professional-services)
* [Contribute](#contribute)
* [Copying](#copying)

## Synopsis

Admin Dashboard for iOS allows you to manage all your mobile devices effectively, offering a range of powerful security features to protect sensitive company data stored on mobile devices, designed with an intuitive and clear interface for your confort, since the opening of the app you will count with a responsive and concise screen thinking in the user experience.

You will be able to:

* Create an inventory of all of your company terminals (mobile fleet inventory)
* Configure and deploy your mobile fleet
* Install and uninstall remote applications
* Send files remotely to all terminals
* Deploy and control Bluetooth and Wi-Fi connectivity
* Activate real-time geolocation of your terminals
* Delete, partially or totally, your data in case of loss or theft
* Ability to control and monitor the security policy

For more information visit our [Official Website](http://flyve.org/ios-mdm-dashboard/).

## Build Status

| **LTS** | **Bleeding Edge** |
|:---:|:---:|
| [![Build Status](https://circleci.com/gh/flyve-mdm/ios-mdm-dashboard/tree/master.svg?style=svg)](https://circleci.com/gh/flyve-mdm/ios-mdm-dashboard/tree/master) | [![Build Status](https://circleci.com/gh/flyve-mdm/ios-mdm-dashboard/tree/develop.svg?style=svg)](https://circleci.com/gh/flyve-mdm/ios-mdm-dashboard/tree/develop)

## Installation

The Admin Dashboard for iOS is running on iOS 9.3 and higher.

Download the latest IPA, from GitHub releases, TestFlight or Apple Store.

[<img src="https://user-images.githubusercontent.com/663460/26986739-23bffc6e-4d49-11e7-92a2-cdba1b517a08.png" alt="Download from iTunes" height="60">](https://itunes.apple.com/us/app/flyve-mdm-admin-dashboard)
[<img src="https://user-images.githubusercontent.com/663460/30159664-a0e818f4-93c9-11e7-9937-501201c36709.png" alt="Download IPA from GitHub" height="60">](https://github.com/flyve-mdm/ios-mdm-dashboard/releases/latest)

## Documentation

We maintain a detailed documentation of the project on the website, check the [How-tos](http://flyve.org/ios-mdm-dashboard/howtos/) and [Development](http://flyve.org/ios-mdm-dashboard/) section.

## Versioning

In order to provide transparency on our release cycle and to maintain backward compatibility, Flyve MDM is maintained under [the Semantic Versioning guidelines](http://semver.org/). We are committed to following and complying with the rules, the best we can.

See [the tags section of our GitHub project](https://github.com/flyve-mdm/ios-mdm-dashboard/tags) for changelogs for each release version of Flyve MDM. Release announcement posts on [the official Teclib' blog](http://www.teclib-edition.com/en/communities/blog-posts/) contain summaries of the most noteworthy changes made in each release.

## Contact

For notices about major changes and general discussion of Flyve MDM development, subscribe to the [/r/FlyveMDM](http://www.reddit.com/r/FlyveMDM) subreddit.
You can also chat with us via IRC in [#flyve-mdm on freenode](http://webchat.freenode.net/?channels=flyve-mdm) or [@flyvemdm on Telegram](https://t.me/flyvemdm).
Ping me @hectorerb if you get stuck.

## Professional Services

The Flyve MDM and GLPI Network services are available through our [Partner's Network](http://www.teclib-edition.com/en/partners/). We provide special training, bug fixes with editor subscription, contributions for new features, and more.

Obtain a personalized service experience, associated with benefits and opportunities.

## Contribute

Want to file a bug, contribute some code, or improve documentation? Excellent! Read up on our
guidelines for [contributing](./CONTRIBUTING.md) and then check out one of our issues in the [Issues Dashboard](https://github.com/flyve-mdm/ios-mdm-dashboard/issues).

## Copying

* **Name**: [Flyve MDM](https://flyve-mdm.com/) is a registered trademark of [Teclib'](http://www.teclib-edition.com/en/).
* **Code**: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License ([LGPLv3](https://www.gnu.org/licenses/lgpl-3.0.en.html)).
* **Documentation**: released under Attribution 4.0 International ([CC BY 4.0](https://creativecommons.org/licenses/by/4.0/)).
