/**
 *  LICENSE
 *
 *  This file is part of the GLPI API Client Library for Swift,
 *  a subproject of GLPI. GLPI is a free IT Asset Management.
 *
 *  Glpi is Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  -----------------------------------------------------------------------------------
 *  @author    Hector Rondon - <hrondon@teclib.com>
 *  @copyright Copyright Teclib. All rights reserved.
 *  @license   Apache License, Version 2.0 https://www.apache.org/licenses/LICENSE-2.0
 *  @link      https://github.com/glpi-project/swift-library-glpi
 *  @link      https://glpi-project.github.io/swift-library-glpi/
 *  @link      http://www.glpi-project.org/
 *  -----------------------------------------------------------------------------------
 */

import Foundation

public enum ItemType {
    case Alert
    case AuthLDAP
    case Computer
    case Config
    case ConsumableItem
    case Contact
    case Contract
    case CronTask
    case CronTaskLog
    case DBConnection
    case DisplayPreference
    case Document
    case AuthLdapReplicate
    case Event
    case KnowbaseItem
    case Link
    case Log
    case MailCollector
    case Monitor
    case NetworkEquipment
    case Notification
    case NotificationEvent
    case NotificationMailSetting
    case AuthMail
    case NotificationTemplate
    case NotImportedEmail
    case Peripheral
    case Phone
    case Plugin
    case Printer
    case Profile
    case Project
    case QueuedMail
    case Reminder
    case Bookmark
    case RSSFeed
    case Rule
    case RuleCollection
    case SLA
    case SlaLevel_Ticket
    case Software
    case SoftwareLicense
    case Supplier
    case TicketFollowup
    case TicketSatisfaction
    case CartridgeItem
    case Transfer
    case User
    case CommonDBConnexity
    case CommonDropdown
    case CommonITILObject
    case CommonITILTask
    case AutoUpdateSystem
    case Blacklist
    case CartridgeItemType
    case Item_DeviceSoundCard
    case Item_Problem
    case Item_Project
    case Item_Ticket
    case ITILCategory
    case KnowbaseItem_Profile
    case KnowbaseItem_User
    case KnowbaseItemCategory
    case KnowbaseItemTranslation
    case Link_Itemtype
    case Change
    case Location
    case Manufacturer
    case MonitorModel
    case MonitorType
    case Netpoint
    case Network
    case NetworkAlias
    case NetworkEquipmentFirmware
    case NetworkEquipmentModel
    case NetworkEquipmentType
    case Change_Group
    case NetworkInterface
    case NetworkName
    case NetworkPort
    case NetworkPort_NetworkPort
    case NetworkPort_Vlan
    case NetworkPortAggregate
    case NetworkPortAlias
    case NetworkPortDialup
    case NetworkPortEthernet
    case NetworkPortInstantiation
    case Change_Item
    case NetworkPortLocal
    case NetworkPortMigration
    case NetworkPortWifi
    case Notepad
    case NotificationTarget
    case NotificationTargetCartridgeItem
    case NotificationTargetChange
    case NotificationTargetCommonITILObject
    case NotificationTargetConsumableItem
    case NotificationTargetContract
    case Change_Problem
    case NotificationTargetCrontask
    case NotificationTargetDBConnection
    case NotificationTargetFieldUnicity
    case NotificationTargetInfocom
    case NotificationTargetMailCollector
    case NotificationTargetPlanningRecall
    case NotificationTargetProblem
    case NotificationTargetProject
    case NotificationTargetProjectTask
    case NotificationTargetReservation
    case Change_Project
    case NotificationTargetSoftwareLicense
    case NotificationTargetTicket
    case NotificationTargetUser
    case NotificationTemplateTranslation
    case OperatingSystem
    case OperatingSystemServicePack
    case OperatingSystemVersion
    case PeripheralModel
    case PeripheralType
    case PhoneModel
    case Change_Supplier
    case PhonePowerSupply
    case PhoneType
    case PlanningRecall
    case PrinterModel
    case PrinterType
    case Problem
    case Problem_Supplier
    case Problem_Ticket
    case Problem_User
    case ProblemCost
    case Change_Ticket
    case ProblemTask
    case Profile_Reminder
    case Profile_RSSFeed
    case Profile_User
    case ProfileRight
    case ProjectCost
    case ProjectState
    case ProjectTask
    case ProjectTask_Ticket
    case ProjectTaskTeam
    case Change_User
    case ProjectTaskType
    case ProjectTeam
    case ProjectType
    case RegisteredID
    case Reminder_User
    case RequestType
    case Reservation
    case ReservationItem
    case RSSFeed_User
    case RuleAction
    case ChangeCost
    case RuleCriteria
    case RuleDictionnaryComputerModel
    case RuleDictionnaryComputerModelCollection
    case RuleDictionnaryComputerType
    case RuleDictionnaryComputerTypeCollection
    case RuleDictionnaryDropdown
    case RuleDictionnaryDropdownCollection
    case RuleDictionnaryManufacturer
    case RuleDictionnaryManufacturerCollection
    case RuleDictionnaryMonitorModel
    case BlacklistedMailContent
    case ChangeTask
    case RuleDictionnaryMonitorModelCollection
    case RuleDictionnaryMonitorType
    case RuleDictionnaryMonitorTypeCollection
    case RuleDictionnaryNetworkEquipmentModel
    case RuleDictionnaryNetworkEquipmentModelCollection
    case RuleDictionnaryNetworkEquipmentType
    case RuleDictionnaryNetworkEquipmentTypeCollection
    case RuleDictionnaryOperatingSystem
    case RuleDictionnaryOperatingSystemCollection
    case RuleDictionnaryOperatingSystemServicePack
    case ChangeValidation
    case RuleDictionnaryOperatingSystemServicePackCollection
    case RuleDictionnaryOperatingSystemVersion
    case RuleDictionnaryOperatingSystemVersionCollection
    case RuleDictionnaryPeripheralModel
    case RuleDictionnaryPeripheralModelCollection
    case RuleDictionnaryPeripheralType
    case RuleDictionnaryPeripheralTypeCollection
    case RuleDictionnaryPhoneModel
    case RuleDictionnaryPhoneModelCollection
    case RuleDictionnaryPhoneType
    case CommonDBChild
    case RuleDictionnaryPhoneTypeCollection
    case RuleDictionnaryPrinter
    case RuleDictionnaryPrinterCollection
    case RuleDictionnaryPrinterModel
    case RuleDictionnaryPrinterModelCollection
    case RuleDictionnaryPrinterType
    case RuleDictionnaryPrinterTypeCollection
    case RuleDictionnarySoftware
    case RuleDictionnarySoftwareCollection
    case RuleImportComputer
    case CommonDBRelation
    case RuleImportComputerCollection
    case RuleImportEntity
    case RuleImportEntityCollection
    case RuleMailCollector
    case RuleMailCollectorCollection
    case RuleRight
    case RuleRightCollection
    case RuleRightParameter
    case RuleSoftwareCategory
    case RuleSoftwareCategoryCollection
    case CommonDevice
    case RuleTicket
    case RuleTicketCollection
    case SlaLevel
    case SlaLevelAction
    case SlaLevelCriteria
    case SoftwareCategory
    case SoftwareLicenseType
    case SoftwareVersion
    case SolutionTemplate
    case SolutionType
    case CommonImplicitTreeDropdown
    case SsoVariable
    case State
    case Supplier_Ticket
    case SupplierType
    case TaskCategory
    case Ticket
    case Ticket_Ticket
    case Ticket_User
    case TicketCost
    case TicketRecurrent
    case CommonITILActor
    case TicketTask
    case TicketTemplate
    case TicketTemplateHiddenField
    case TicketTemplateMandatoryField
    case TicketTemplatePredefinedField
    case TicketValidation
    case UserCategory
    case UserEmail
    case UserTitle
    case VirtualMachineState
    case CommonITILCost
    case VirtualMachineSystem
    case VirtualMachineType
    case Vlan
    case WifiNetwork
    case CommonITILValidation
    case CommonTreeDropdown
    case Bookmark_User
    case Computer_Item
    case Computer_SoftwareLicense
    case Computer_SoftwareVersion
    case ComputerDisk
    case ComputerModel
    case ComputerType
    case ComputerVirtualMachine
    case Consumable
    case ConsumableItemType
    case Contact_Supplier
    case Budget
    case ContactType
    case Contract_Item
    case Contract_Supplier
    case ContractCost
    case ContractType
    case DeviceCase
    case DeviceCaseType
    case DeviceControl
    case DeviceDrive
    case DeviceGraphicCard
    case Calendar
    case DeviceHardDrive
    case DeviceMemory
    case DeviceMemoryType
    case DeviceMotherboard
    case DeviceNetworkCard
    case DevicePci
    case DevicePowerSupply
    case DeviceProcessor
    case DeviceSoundCard
    case Document_Item
    case Calendar_Holiday
    case DocumentCategory
    case DocumentType
    case Domain
    case DropdownTranslation
    case Entity
    case Entity_KnowbaseItem
    case Entity_Reminder
    case Entity_RSSFeed
    case Fieldblacklist
    case FieldUnicity
    case CalendarSegment
    case Filesystem
    case FQDN
    case FQDNLabel
    case Group
    case Group_KnowbaseItem
    case Group_Problem
    case Group_Reminder
    case Group_RSSFeed
    case Group_Ticket
    case Group_User
    case Cartridge
    case Holiday
    case Infocom
    case InterfaceType
    case IPAddress
    case IPAddress_IPNetwork
    case IPNetmask
    case IPNetwork
    case IPNetwork_Vlan
    case Item_DeviceCase
    case Item_DeviceControl
    case CartridgeItem_PrinterModel
    case Item_DeviceDrive
    case Item_DeviceGraphicCard
    case Item_DeviceHardDrive
    case Item_DeviceMemory
    case Item_DeviceMotherboard
    case Item_DeviceNetworkCard
    case Item_DevicePci
    case Item_DevicePowerSupply
    case Item_DeviceProcessor
    case Item_Devices
}
