# Contributing to Flyer Chat

Thank you for your interest in contributing to Flyer Chat! Our vision is to create an easy-to-use chat experience for any application and while we can't have everything right from the start, we can build it together! If you plan to implement a feature and open a pull request, make sure you don't spend a lot of time on it, otherwise open an issue so we can discuss bigger stuff.

The [Open Source Guides](https://opensource.guide) website has a collection of resources for individuals, communities, and companies who want to learn how to run and contribute to an open-source project. Contributors and people new to open source alike will find the following guides especially useful:

* [How to Contribute to Open Source](https://opensource.guide/how-to-contribute/)
* [Building Welcoming Communities](https://opensource.guide/building-community/)

## Helping with Documentation

We use [Docusaurus](https://docusaurus.io) to build our documentation which is located in the [docs](https://github.com/flyerhq/react-native-firebase-chat-core/tree/main/docs) folder. If you are adding new functionality or introducing a behavior change, we will ask you to update the documentation to reflect your changes.

## Contributing Code

Code-level contributions to Flyer Chat generally come in the form of pull requests. These are done by forking the repo and making changes locally. Directly in the repo, there is the [example](https://github.com/flyerhq/react-native-firebase-chat-core/tree/main/example) project that you can install on your device (or simulators) and use to test the changes you're making to Flyer Chat sources.

[Here](https://opensource.guide/how-to-contribute/#opening-a-pull-request) you can read how to open a pull request.

Please read [this section](https://github.com/demchenkoalex/react-native-module-template#how-to-see-my-changes-immediately-in-the-example) of the template library we use so the hot reload works for you when you are changing source files. Run `yarn` in the root folder to install dependencies for the library and `yarn` / `npx pod-install` in the `example` folder to install dependencies for the example project. After you are done with the changes, run `yarn compile`, `yarn lint` and `yarn type-coverage` in the root folder to make sure your code is consistent with our style.

## Community Contributions

Contributions to Flyer Chat are not limited to GitHub. You can help others by sharing your experience using Flyer Chat, whether that is through blog posts, presenting talks at conferences, or simply sharing your thoughts on social media.

## License

By contributing to Flyer Chat, you agree that your contributions will be licensed under its [Apache License, Version 2.0](LICENSE).
