import { render } from '@testing-library/react-native'
import * as React from 'react'

import { derivedTextMessage } from '../../../../jest/fixtures'
import { Message } from '../Message'

describe('message', () => {
  it('renders undefined in ContentContainer', () => {
    expect.assertions(2)
    const { getByTestId } = render(
      <Message
        message={{ ...derivedTextMessage, type: 'custom' }}
        messageWidth={440}
        onMessagePress={jest.fn}
        roundBorder
        showAvatar
        showName
        showStatus
      />
    )
    const ContentContainer = getByTestId('ContentContainer')
    expect(ContentContainer).toBeDefined()
    expect(ContentContainer).toHaveProperty('props.children[0]', undefined)
  })

  it('renders undefined in ContentContainer with wrong message type', () => {
    expect.assertions(2)
    const { getByTestId } = render(
      <Message
        message={{ ...derivedTextMessage, type: 'unsupported' }}
        messageWidth={440}
        onMessagePress={jest.fn}
        roundBorder
        showAvatar
        showName
        showStatus
      />
    )
    const ContentContainer = getByTestId('ContentContainer')
    expect(ContentContainer).toBeDefined()
    expect(ContentContainer).toHaveProperty('props.children[0]', undefined)
  })
})
