<p align="center">
  ⚠️⚠️ Currently not maintained, please fork or look for alternatives ⚠️⚠️
</p>

<br>

<p align="center">
  <a href="https://flyer.chat">
    <img src="https://flyer.chat/assets/logo-dark.svg" width="288px" alt="Flyer Chat Logo" />
  </a>
</p>

<h1 align="center">React Native Chat UI</h1>

<p align="center">
  Actively maintained, community-driven chat UI implementation with an optional <a href="https://github.com/flyerhq/react-native-firebase-chat-core">Firebase BaaS</a>.
</p>

<p align="center">
  <a href="https://www.npmjs.com/package/@flyerhq/react-native-chat-ui">
    <img alt="NPM" src="https://img.shields.io/npm/v/@flyerhq/react-native-chat-ui" />
  </a>
  <a href="https://github.com/flyerhq/react-native-chat-ui/actions?query=workflow%3Abuild">
    <img alt="Build Status" src="https://github.com/flyerhq/react-native-chat-ui/workflows/build/badge.svg" />
  </a>
  <a href="https://codeclimate.com/github/flyerhq/react-native-chat-ui/maintainability">
    <img alt="Maintainability" src="https://api.codeclimate.com/v1/badges/6913931b6ad4f98d7a57/maintainability" />
  </a>
  <a href="https://codeclimate.com/github/flyerhq/react-native-chat-ui/test_coverage">
    <img alt="Test Coverage" src="https://api.codeclimate.com/v1/badges/6913931b6ad4f98d7a57/test_coverage" />
  </a>
  <a href="https://github.com/plantain-00/type-coverage">
    <img alt="Type Coverage" src="https://img.shields.io/badge/dynamic/json.svg?label=type-coverage&suffix=%&query=$.typeCoverage.is&uri=https%3A%2F%2Fraw.githubusercontent.com%2Fflyerhq%2Freact-native-chat-ui%2Fmain%2Fpackage.json" />
  </a>
</p>

<br>

<p align="center">
  <a href="https://flyer.chat">
    <img alt="Chat Image" src="https://user-images.githubusercontent.com/14123304/121787953-a6121500-cbc9-11eb-83ff-db0435d2cd57.png" />
  </a>
</p>

<br>

Flyer Chat is a platform for creating in-app chat experiences using React Native or [Flutter](https://github.com/flyerhq/flutter_chat_ui). This repository contains chat UI implementation for React Native.

* **Free, open-source and community-driven**. We offer no paid plugins and strive to create an easy-to-use, almost drop-in chat experience for any application. Contributions are more than welcome! Please read our [Contributing Guide](CONTRIBUTING.md).

* **Backend agnostic**. You can choose the backend you prefer. But if you don't have one, we provide our own free and open-source [Firebase implementation](https://github.com/flyerhq/react-native-firebase-chat-core), which can be used to create a working chat in minutes. We are also working on our more advanced SaaS and self-hosted solutions.

* **Customizable**. Supports custom themes, locales and more. Check our [documentation](https://docs.flyer.chat/react-native/chat-ui) for the info. More options are on the way, let us know if something is missing.

* **Minimum dependencies**. Our packages are lightweight. Use your favourite packages for selecting images, opening files etc. See the [example](https://github.com/flyerhq/react-native-chat-ui/blob/main/example/src/App.tsx) for possible implementation.

## Getting Started

### Requirements

`React Native >=0.60.0`

Read our [documentation](https://docs.flyer.chat/react-native/chat-ui) or see the [example](https://github.com/flyerhq/react-native-chat-ui/tree/main/example) project.

## Contributing

Please read our [Contributing Guide](CONTRIBUTING.md) before submitting a pull request to the project.

## Code of Conduct

Flyer Chat has adopted the [Contributor Covenant](https://www.contributor-covenant.org) as its Code of Conduct, and we expect project participants to adhere to it. Please read [the full text](CODE_OF_CONDUCT.md) so that you can understand what actions will and will not be tolerated.

## License

Licensed under the [Apache License, Version 2.0](LICENSE)
