// @flow
import uuid from "uuid";
import v1 from "uuid/v1";
import v3 from "uuid/v3";
import v4 from "uuid/v4";
import v5 from "uuid/v5";

(uuid.v1(): string);
(uuid.v4(): string);
(uuid(): string);

(v1(): string);
(v4(): string);
(v3(): string);
(v5(): string);

uuid.v1({
  node: [0x01, 0x23, 0x45, 0x67, 0x89, 0xab],
  clockseq: 0x1234,
  msecs: new Date("2011-11-01").getTime(),
  nsecs: 5678
});

v1({
  node: [0x01, 0x23, 0x45, 0x67, 0x89, 0xab],
  clockseq: 0x1234,
  msecs: new Date("2011-11-01").getTime(),
  nsecs: 5678
});

// $FlowExpectedError
uuid.v1({ yolo: true });
// $FlowExpectedError
v1({ yolo: true });
// $FlowExpectedError
uuid.v4({ yolo: true });
// $FlowExpectedError
v4({ yolo: true });
// $FlowExpectedError
v3({ yolo: true });
// $FlowExpectedError
v5({ yolo: true });

const arr = new Array(32);

uuid.v4({
  random: [
    0x10,
    0x91,
    0x56,
    0xbe,
    0xc4,
    0xfb,
    0xc1,
    0xea,
    0x71,
    0xb4,
    0xef,
    0xe1,
    0x67,
    0x1c,
    0x58,
    0x36
  ]
});

v4({
  random: [
    0x10,
    0x91,
    0x56,
    0xbe,
    0xc4,
    0xfb,
    0xc1,
    0xea,
    0x71,
    0xb4,
    0xef,
    0xe1,
    0x67,
    0x1c,
    0x58,
    0x36
  ]
});

uuid.v4({
  // Fake random number generator
  rng: () => [
    0x10,
    0x91,
    0x56,
    0xbe,
    0xc4,
    0xfb,
    0xc1,
    0xea,
    0x71,
    0xb4,
    0xef,
    0xe1,
    0x67,
    0x1c,
    0x58,
    0x36
  ]
});

v4({
  // Fake random number generator
  rng: () => [
    0x10,
    0x91,
    0x56,
    0xbe,
    0xc4,
    0xfb,
    0xc1,
    0xea,
    0x71,
    0xb4,
    0xef,
    0xe1,
    0x67,
    0x1c,
    0x58,
    0x36
  ]
});

uuid.v4({
  // Fake random number generator
  rng: () => Buffer.alloc(16)
});

v4({
  // Fake random number generator
  rng: () => Buffer.alloc(16)
});

// $FlowExpectedError
uuid.v4({
  rng: () => "bla"
});

// $FlowExpectedError
v4({
  rng: () => "bla"
});

v3.name;
v3("bla");
v3("bla", "bla");
v3("bla", v3.DNS);
v3("bla", v3.URL);
v3([0x10, 0x91, 0x56, 0xbe, 0xc4, 0xfb, 0xc1, 0xea]);
v3(
  [0x10, 0x91, 0x56, 0xbe, 0xc4, 0xfb, 0xc1, 0xea],
  [0x71, 0xb4, 0xef, 0xe1, 0x67, 0x1c, 0x58, 0x36]
);

// $FlowExpectedError
v3("bla", { yolo: true });

v5.name;
v5("bla");
v5("bla", "bla");
v5("bla", v5.DNS);
v5("bla", v5.URL);
v5([0x10, 0x91, 0x56, 0xbe, 0xc4, 0xfb, 0xc1, 0xea]);
v5(
  [0x10, 0x91, 0x56, 0xbe, 0xc4, 0xfb, 0xc1, 0xea],
  [0x71, 0xb4, 0xef, 0xe1, 0x67, 0x1c, 0x58, 0x36]
);

// $FlowExpectedError
v5("bla", { yolo: true });
