declare module "openai" {
  import type { Axios, AxiosPromise, AxiosXHRConfig } from "axios";

  /**
   * OpenAI API
   * APIs for sampling from and fine-tuning language models
   *
   * The version of the OpenAPI document: 1.3.0
   *
   *
   * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
   * https://openapi-generator.tech
   * Do not edit the class manually.
   */
  declare interface ConfigurationParameters {
    apiKey?:
      | string
      | Promise<string>
      | ((name: string) => string)
      | ((name: string) => Promise<string>);
    organization?: string;
    username?: string;
    password?: string;
    accessToken?:
      | string
      | Promise<string>
      | ((name?: string, scopes?: string[]) => string)
      | ((name?: string, scopes?: string[]) => Promise<string>);
    basePath?: string;
    baseOptions?: any;
    formDataCtor?: () => any;
  }
  declare class Configuration {
    /**
     * parameter for apiKey security
     * @param name security name
     * @memberof Configuration
     */
    apiKey?:
      | string
      | Promise<string>
      | ((name: string) => string)
      | ((name: string) => Promise<string>);

    /**
     * OpenAI organization id
     * @type {string}
     * @memberof Configuration
     */
    organization?: string;

    /**
     * parameter for basic security
     * @type {string}
     * @memberof Configuration
     */
    username?: string;

    /**
     * parameter for basic security
     * @type {string}
     * @memberof Configuration
     */
    password?: string;

    /**
     * parameter for oauth2 security
     * @param name security name
     * @param scopes oauth2 scope
     * @memberof Configuration
     */
    accessToken?:
      | string
      | Promise<string>
      | ((name?: string, scopes?: string[]) => string)
      | ((name?: string, scopes?: string[]) => Promise<string>);

    /**
     * override base path
     * @type {string}
     * @memberof Configuration
     */
    basePath?: string;

    /**
     * base options for axios calls
     * @type {any}
     * @memberof Configuration
     */
    baseOptions?: any;

    /**
     * The FormData constructor that will be used to create multipart form data
     * requests. You can inject this here so that execution environments that
     * do not support the FormData class can still run the generated client.
     * @type {() => FormData}
     */
    formDataCtor?: () => any;
    constructor(param?: ConfigurationParameters): this;

    /**
     * Check if the given MIME is a JSON MIME.
     * JSON MIME examples:
     *   application/json
     *   application/json; charset=UTF8
     *   APPLICATION/JSON
     *   application/vnd.company+json
     * @param mime - MIME (Multipurpose Internet Mail Extensions)
     * @return True if the given MIME is JSON, false otherwise.
     */
    isJsonMime(mime: string): boolean;
  }

  /**
   * @export
   * @interface RequestArgs
   */
  declare interface RequestArgs {
    url: string;
    options: AxiosXHRConfig<Object>;
  }
  declare class BaseAPI {
    basePath: string;
    axios: Axios;
    configuration: Configuration | void;
    constructor(
      configuration?: Configuration,
      basePath?: string,
      axios?: Axios
    ): this;
  }

  /**
   * @export
   * @interface ChatCompletionFunctions
   */
  declare interface ChatCompletionFunctions {
    /**
     * The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.
     * @type {string}
     * @memberof ChatCompletionFunctions
     */
    name: string;

    /**
     * The description of what the function does.
     * @type {string}
     * @memberof ChatCompletionFunctions
     */
    description?: string;

    /**
     * The parameters the functions accepts, described as a JSON Schema object. See the [guide](/docs/guides/gpt/function-calling) for examples, and the [JSON Schema reference](https://json-schema.org/understanding-json-schema/) for documentation about the format.
     * @type {{
[key: string]: any,
}}
     * @memberof ChatCompletionFunctions
     */
    parameters?: {
      [key: string]: any,
    };
  }
  declare interface ChatCompletionRequestMessage {
    role: ChatCompletionRequestMessageRoleEnumType;

    /**
     * The contents of the message. `content` is required for all messages except assistant messages with function calls.
     * @type {string}
     * @memberof ChatCompletionRequestMessage
     */
    content?: string;

    /**
     * The name of the author of this message. `name` is required if role is `function`, and it should be the name of the function whose response is in the `content`. May contain a-z, A-Z, 0-9, and underscores, with a maximum length of 64 characters.
     * @type {string}
     * @memberof ChatCompletionRequestMessage
     */
    name?: string;

    /**
     * @type {ChatCompletionRequestMessageFunctionCall}
     * @memberof ChatCompletionRequestMessage
     */
    function_call?: ChatCompletionRequestMessageFunctionCall;
  }
  declare var ChatCompletionRequestMessageRoleEnum: {
    +System: "system",
    +User: "user",
    +Assistant: "assistant",
    +Function: "function",
    ...
  };
  declare type ChatCompletionRequestMessageRoleEnumType = "system" | "user" | "assistant" | "function";

  /**
   * The name and arguments of a function that should be called, as generated by the model.
   * @export
   * @interface ChatCompletionRequestMessageFunctionCall
   */
  declare interface ChatCompletionRequestMessageFunctionCall {
    /**
     * The name of the function to call.
     * @type {string}
     * @memberof ChatCompletionRequestMessageFunctionCall
     */
    name?: string;

    /**
     * The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
     * @type {string}
     * @memberof ChatCompletionRequestMessageFunctionCall
     */
    arguments?: string;
  }
  declare interface ChatCompletionResponseMessage {
    role: ChatCompletionResponseMessageRoleEnumType;

    /**
     * The contents of the message.
     * @type {string}
     * @memberof ChatCompletionResponseMessage
     */
    content?: string;

    /**
     * @type {ChatCompletionRequestMessageFunctionCall}
     * @memberof ChatCompletionResponseMessage
     */
    function_call?: ChatCompletionRequestMessageFunctionCall;
  }
  declare var ChatCompletionResponseMessageRoleEnum: {
    +System: "system",
    +User: "user",
    +Assistant: "assistant",
    +Function: "function",
    ...
  };
  declare type ChatCompletionResponseMessageRoleEnumType = $ElementType<
    typeof ChatCompletionResponseMessageRoleEnum,
    $Keys<typeof ChatCompletionResponseMessageRoleEnum>
  >;

  /**
   * @export
   * @interface CreateAnswerRequest
   */
  declare interface CreateAnswerRequest {
    /**
     * ID of the model to use for completion. You can select one of `ada`, `babbage`, `curie`, or `davinci`.
     * @type {string}
     * @memberof CreateAnswerRequest
     */
    model: string;

    /**
     * Question to get answered.
     * @type {string}
     * @memberof CreateAnswerRequest
     */
    question: string;

    /**
     * List of (question, answer) pairs that will help steer the model towards the tone and answer format you\'d like. We recommend adding 2 to 3 examples.
     * @type {Array<any>}
     * @memberof CreateAnswerRequest
     */
    examples: Array<any>;

    /**
     * A text snippet containing the contextual information used to generate the answers for the `examples` you provide.
     * @type {string}
     * @memberof CreateAnswerRequest
     */
    examples_context: string;

    /**
     * List of documents from which the answer for the input `question` should be derived. If this is an empty list, the question will be answered based on the question-answer examples.  You should specify either `documents` or a `file`, but not both.
     * @type {Array<string>}
     * @memberof CreateAnswerRequest
     */
    documents?: Array<string> | null;

    /**
     * The ID of an uploaded file that contains documents to search over. See [upload file](/docs/api-reference/files/upload) for how to upload a file of the desired format and purpose.  You should specify either `documents` or a `file`, but not both.
     * @type {string}
     * @memberof CreateAnswerRequest
     */
    file?: string | null;

    /**
     * ID of the model to use for [Search](/docs/api-reference/searches/create). You can select one of `ada`, `babbage`, `curie`, or `davinci`.
     * @type {string}
     * @memberof CreateAnswerRequest
     */
    search_model?: string | null;

    /**
     * The maximum number of documents to be ranked by [Search](/docs/api-reference/searches/create) when using `file`. Setting it to a higher value leads to improved accuracy but with increased latency and cost.
     * @type {number}
     * @memberof CreateAnswerRequest
     */
    max_rerank?: number | null;

    /**
     * What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.
     * @type {number}
     * @memberof CreateAnswerRequest
     */
    temperature?: number | null;

    /**
     * Include the log probabilities on the `logprobs` most likely tokens, as well the chosen tokens. For example, if `logprobs` is 5, the API will return a list of the 5 most likely tokens. The API will always return the `logprob` of the sampled token, so there may be up to `logprobs+1` elements in the response.  The maximum value for `logprobs` is 5.  When `logprobs` is set, `completion` will be automatically added into `expand` to get the logprobs.
     * @type {number}
     * @memberof CreateAnswerRequest
     */
    logprobs?: number | null;

    /**
     * The maximum number of tokens allowed for the generated answer
     * @type {number}
     * @memberof CreateAnswerRequest
     */
    max_tokens?: number | null;

    /**
     * @type {CreateAnswerRequestStop}
     * @memberof CreateAnswerRequest
     */
    stop?: CreateAnswerRequestStop | null;

    /**
     * How many answers to generate for each question.
     * @type {number}
     * @memberof CreateAnswerRequest
     */
    n?: number | null;

    /**
     * Modify the likelihood of specified tokens appearing in the completion.  Accepts a json object that maps tokens (specified by their token ID in the GPT tokenizer) to an associated bias value from -100 to 100. You can use this [tokenizer tool](/tokenizer?view=bpe) (which works for both GPT-2 and GPT-3) to convert text to token IDs. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.  As an example, you can pass `{\"50256\": -100}` to prevent the <|endoftext|> token from being generated.
     * @type {{[key: string]: any}}
     * @memberof CreateAnswerRequest
     */
    logit_bias?: { [key: string]: any } | null;

    /**
     * A special boolean flag for showing metadata. If set to `true`, each document entry in the returned JSON will contain a \"metadata\" field.  This flag only takes effect when `file` is set.
     * @type {boolean}
     * @memberof CreateAnswerRequest
     */
    return_metadata?: boolean | null;

    /**
     * If set to `true`, the returned JSON will include a \"prompt\" field containing the final prompt that was used to request a completion. This is mainly useful for debugging purposes.
     * @type {boolean}
     * @memberof CreateAnswerRequest
     */
    return_prompt?: boolean | null;

    /**
     * If an object name is in the list, we provide the full information of the object; otherwise, we only provide the object ID. Currently we support `completion` and `file` objects for expansion.
     * @type {Array<any>}
     * @memberof CreateAnswerRequest
     */
    expand?: Array<any> | null;

    /**
     * A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
     * @type {string}
     * @memberof CreateAnswerRequest
     */
    user?: string;
  }

  /**
   * @type {CreateAnswerRequestStop} Up to 4 sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence.
   * @export
   */
  declare type CreateAnswerRequestStop = Array<string> | string;

  /**
   * @export
   * @interface CreateAnswerResponse
   */
  declare interface CreateAnswerResponse {
    /**
     * @type {string}
     * @memberof CreateAnswerResponse
     */
    object?: string;

    /**
     * @type {string}
     * @memberof CreateAnswerResponse
     */
    model?: string;

    /**
     * @type {string}
     * @memberof CreateAnswerResponse
     */
    search_model?: string;

    /**
     * @type {string}
     * @memberof CreateAnswerResponse
     */
    completion?: string;

    /**
     * @type {Array<string>}
     * @memberof CreateAnswerResponse
     */
    answers?: Array<string>;

    /**
     * @type {Array<CreateAnswerResponseSelectedDocumentsInner>}
     * @memberof CreateAnswerResponse
     */
    selected_documents?: Array<CreateAnswerResponseSelectedDocumentsInner>;
  }

  /**
   * @export
   * @interface CreateAnswerResponseSelectedDocumentsInner
   */
  declare interface CreateAnswerResponseSelectedDocumentsInner {
    /**
     * @type {number}
     * @memberof CreateAnswerResponseSelectedDocumentsInner
     */
    document?: number;

    /**
     * @type {string}
     * @memberof CreateAnswerResponseSelectedDocumentsInner
     */
    text?: string;
  }

  /**
   * @export
   * @interface CreateChatCompletionRequest
   */
  declare interface CreateChatCompletionRequest {
    /**
     * ID of the model to use. See the [model endpoint compatibility](/docs/models/model-endpoint-compatibility) table for details on which models work with the Chat API.
     * @type {string}
     * @memberof CreateChatCompletionRequest
     */
    model: string;

    /**
     * A list of messages comprising the conversation so far. [Example Python code](https://github.com/openai/openai-cookbook/blob/main/examples/How_to_format_inputs_to_ChatGPT_models.ipynb).
     * @type {Array<ChatCompletionRequestMessage>}
     * @memberof CreateChatCompletionRequest
     */
    messages: Array<ChatCompletionRequestMessage>;

    /**
     * A list of functions the model may generate JSON inputs for.
     * @type {Array<ChatCompletionFunctions>}
     * @memberof CreateChatCompletionRequest
     */
    functions?: Array<ChatCompletionFunctions>;

    /**
     * @type {CreateChatCompletionRequestFunctionCall}
     * @memberof CreateChatCompletionRequest
     */
    function_call?: CreateChatCompletionRequestFunctionCall;

    /**
     * What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.  We generally recommend altering this or `top_p` but not both.
     * @type {number}
     * @memberof CreateChatCompletionRequest
     */
    temperature?: number | null;

    /**
     * An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.  We generally recommend altering this or `temperature` but not both.
     * @type {number}
     * @memberof CreateChatCompletionRequest
     */
    top_p?: number | null;

    /**
     * How many chat completion choices to generate for each input message.
     * @type {number}
     * @memberof CreateChatCompletionRequest
     */
    n?: number | null;

    /**
     * If set, partial message deltas will be sent, like in ChatGPT. Tokens will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available, with the stream terminated by a `data: [DONE]` message. [Example Python code](https://github.com/openai/openai-cookbook/blob/main/examples/How_to_stream_completions.ipynb).
     * @type {boolean}
     * @memberof CreateChatCompletionRequest
     */
    stream?: boolean | null;

    /**
     * @type {CreateChatCompletionRequestStop}
     * @memberof CreateChatCompletionRequest
     */
    stop?: CreateChatCompletionRequestStop;

    /**
     * The maximum number of [tokens](/tokenizer) to generate in the chat completion.  The total length of input tokens and generated tokens is limited by the model\'s context length. [Example Python code](https://github.com/openai/openai-cookbook/blob/main/examples/How_to_count_tokens_with_tiktoken.ipynb) for counting tokens.
     * @type {number}
     * @memberof CreateChatCompletionRequest
     */
    max_tokens?: number;

    /**
     * Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model\'s likelihood to talk about new topics.  [See more information about frequency and presence penalties.](/docs/api-reference/parameter-details)
     * @type {number}
     * @memberof CreateChatCompletionRequest
     */
    presence_penalty?: number | null;

    /**
     * Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model\'s likelihood to repeat the same line verbatim.  [See more information about frequency and presence penalties.](/docs/api-reference/parameter-details)
     * @type {number}
     * @memberof CreateChatCompletionRequest
     */
    frequency_penalty?: number | null;

    /**
     * Modify the likelihood of specified tokens appearing in the completion.  Accepts a json object that maps tokens (specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.
     * @type {{[key: string]: any}}
     * @memberof CreateChatCompletionRequest
     */
    logit_bias?: { [key: string]: any } | null;

    /**
     * A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
     * @type {string}
     * @memberof CreateChatCompletionRequest
     */
    user?: string;
  }

  /**
   * @type {CreateChatCompletionRequestFunctionCall} Controls how the model responds to function calls. \"none\" means the model does not call a function, and responds to the end-user. \"auto\" means the model can pick between an end-user or calling a function.  Specifying a particular function via `{\"name\":\\ \"my_function\"}` forces the model to call that function. \"none\" is the default when no functions are present. \"auto\" is the default if functions are present.
   * @export
   */
  declare type CreateChatCompletionRequestFunctionCall =
    | CreateChatCompletionRequestFunctionCallOneOf
    | string;

  /**
   * @export
   * @interface CreateChatCompletionRequestFunctionCallOneOf
   */
  declare interface CreateChatCompletionRequestFunctionCallOneOf {
    /**
     * The name of the function to call.
     * @type {string}
     * @memberof CreateChatCompletionRequestFunctionCallOneOf
     */
    name: string;
  }

  /**
   * @type {CreateChatCompletionRequestStop} Up to 4 sequences where the API will stop generating further tokens.
   * @export
   */
  declare type CreateChatCompletionRequestStop = Array<string> | string;

  /**
   * @export
   * @interface CreateChatCompletionResponse
   */
  declare interface CreateChatCompletionResponse {
    /**
     * @type {string}
     * @memberof CreateChatCompletionResponse
     */
    id: string;

    /**
     * @type {string}
     * @memberof CreateChatCompletionResponse
     */
    object: string;

    /**
     * @type {number}
     * @memberof CreateChatCompletionResponse
     */
    created: number;

    /**
     * @type {string}
     * @memberof CreateChatCompletionResponse
     */
    model: string;

    /**
     * @type {Array<CreateChatCompletionResponseChoicesInner>}
     * @memberof CreateChatCompletionResponse
     */
    choices: Array<CreateChatCompletionResponseChoicesInner>;

    /**
     * @type {CreateCompletionResponseUsage}
     * @memberof CreateChatCompletionResponse
     */
    usage?: CreateCompletionResponseUsage;
  }

  /**
   * @export
   * @interface CreateChatCompletionResponseChoicesInner
   */
  declare interface CreateChatCompletionResponseChoicesInner {
    /**
     * @type {number}
     * @memberof CreateChatCompletionResponseChoicesInner
     */
    index?: number;

    /**
     * @type {ChatCompletionResponseMessage}
     * @memberof CreateChatCompletionResponseChoicesInner
     */
    message?: ChatCompletionResponseMessage;

    /**
     * @type {string}
     * @memberof CreateChatCompletionResponseChoicesInner
     */
    finish_reason?: string;
  }

  /**
   * @export
   * @interface CreateClassificationRequest
   */
  declare interface CreateClassificationRequest {
    /**
     * ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
     * @type {string}
     * @memberof CreateClassificationRequest
     */
    model: string;

    /**
     * Query to be classified.
     * @type {string}
     * @memberof CreateClassificationRequest
     */
    query: string;

    /**
     * A list of examples with labels, in the following format:  `[[\"The movie is so interesting.\", \"Positive\"], [\"It is quite boring.\", \"Negative\"], ...]`  All the label strings will be normalized to be capitalized.  You should specify either `examples` or `file`, but not both.
     * @type {Array<any>}
     * @memberof CreateClassificationRequest
     */
    examples?: Array<any> | null;

    /**
     * The ID of the uploaded file that contains training examples. See [upload file](/docs/api-reference/files/upload) for how to upload a file of the desired format and purpose.  You should specify either `examples` or `file`, but not both.
     * @type {string}
     * @memberof CreateClassificationRequest
     */
    file?: string | null;

    /**
     * The set of categories being classified. If not specified, candidate labels will be automatically collected from the examples you provide. All the label strings will be normalized to be capitalized.
     * @type {Array<string>}
     * @memberof CreateClassificationRequest
     */
    labels?: Array<string> | null;

    /**
     * ID of the model to use for [Search](/docs/api-reference/searches/create). You can select one of `ada`, `babbage`, `curie`, or `davinci`.
     * @type {string}
     * @memberof CreateClassificationRequest
     */
    search_model?: string | null;

    /**
     * What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.
     * @type {number}
     * @memberof CreateClassificationRequest
     */
    temperature?: number | null;

    /**
     * Include the log probabilities on the `logprobs` most likely tokens, as well the chosen tokens. For example, if `logprobs` is 5, the API will return a list of the 5 most likely tokens. The API will always return the `logprob` of the sampled token, so there may be up to `logprobs+1` elements in the response.  The maximum value for `logprobs` is 5.  When `logprobs` is set, `completion` will be automatically added into `expand` to get the logprobs.
     * @type {number}
     * @memberof CreateClassificationRequest
     */
    logprobs?: number | null;

    /**
     * The maximum number of examples to be ranked by [Search](/docs/api-reference/searches/create) when using `file`. Setting it to a higher value leads to improved accuracy but with increased latency and cost.
     * @type {number}
     * @memberof CreateClassificationRequest
     */
    max_examples?: number | null;

    /**
     * Modify the likelihood of specified tokens appearing in the completion.  Accepts a json object that maps tokens (specified by their token ID in the GPT tokenizer) to an associated bias value from -100 to 100. You can use this [tokenizer tool](/tokenizer?view=bpe) (which works for both GPT-2 and GPT-3) to convert text to token IDs. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.  As an example, you can pass `{\"50256\": -100}` to prevent the <|endoftext|> token from being generated.
     * @type {{[key: string]: any}}
     * @memberof CreateClassificationRequest
     */
    logit_bias?: { [key: string]: any } | null;

    /**
     * If set to `true`, the returned JSON will include a \"prompt\" field containing the final prompt that was used to request a completion. This is mainly useful for debugging purposes.
     * @type {boolean}
     * @memberof CreateClassificationRequest
     */
    return_prompt?: boolean | null;

    /**
     * A special boolean flag for showing metadata. If set to `true`, each document entry in the returned JSON will contain a \"metadata\" field.  This flag only takes effect when `file` is set.
     * @type {boolean}
     * @memberof CreateClassificationRequest
     */
    return_metadata?: boolean | null;

    /**
     * If an object name is in the list, we provide the full information of the object; otherwise, we only provide the object ID. Currently we support `completion` and `file` objects for expansion.
     * @type {Array<any>}
     * @memberof CreateClassificationRequest
     */
    expand?: Array<any> | null;

    /**
     * A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
     * @type {string}
     * @memberof CreateClassificationRequest
     */
    user?: string;
  }

  /**
   * @export
   * @interface CreateClassificationResponse
   */
  declare interface CreateClassificationResponse {
    /**
     * @type {string}
     * @memberof CreateClassificationResponse
     */
    object?: string;

    /**
     * @type {string}
     * @memberof CreateClassificationResponse
     */
    model?: string;

    /**
     * @type {string}
     * @memberof CreateClassificationResponse
     */
    search_model?: string;

    /**
     * @type {string}
     * @memberof CreateClassificationResponse
     */
    completion?: string;

    /**
     * @type {string}
     * @memberof CreateClassificationResponse
     */
    label?: string;

    /**
     * @type {Array<CreateClassificationResponseSelectedExamplesInner>}
     * @memberof CreateClassificationResponse
     */
    selected_examples?: Array<CreateClassificationResponseSelectedExamplesInner>;
  }

  /**
   * @export
   * @interface CreateClassificationResponseSelectedExamplesInner
   */
  declare interface CreateClassificationResponseSelectedExamplesInner {
    /**
     * @type {number}
     * @memberof CreateClassificationResponseSelectedExamplesInner
     */
    document?: number;

    /**
     * @type {string}
     * @memberof CreateClassificationResponseSelectedExamplesInner
     */
    text?: string;

    /**
     * @type {string}
     * @memberof CreateClassificationResponseSelectedExamplesInner
     */
    label?: string;
  }

  /**
   * @export
   * @interface CreateCompletionRequest
   */
  declare interface CreateCompletionRequest {
    /**
     * ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
     * @type {string}
     * @memberof CreateCompletionRequest
     */
    model: string;

    /**
     * @type {CreateCompletionRequestPrompt}
     * @memberof CreateCompletionRequest
     */
    prompt?: CreateCompletionRequestPrompt | null;

    /**
     * The suffix that comes after a completion of inserted text.
     * @type {string}
     * @memberof CreateCompletionRequest
     */
    suffix?: string | null;

    /**
     * The maximum number of [tokens](/tokenizer) to generate in the completion.  The token count of your prompt plus `max_tokens` cannot exceed the model\'s context length. [Example Python code](https://github.com/openai/openai-cookbook/blob/main/examples/How_to_count_tokens_with_tiktoken.ipynb) for counting tokens.
     * @type {number}
     * @memberof CreateCompletionRequest
     */
    max_tokens?: number | null;

    /**
     * What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.  We generally recommend altering this or `top_p` but not both.
     * @type {number}
     * @memberof CreateCompletionRequest
     */
    temperature?: number | null;

    /**
     * An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.  We generally recommend altering this or `temperature` but not both.
     * @type {number}
     * @memberof CreateCompletionRequest
     */
    top_p?: number | null;

    /**
     * How many completions to generate for each prompt.  **Note:** Because this parameter generates many completions, it can quickly consume your token quota. Use carefully and ensure that you have reasonable settings for `max_tokens` and `stop`.
     * @type {number}
     * @memberof CreateCompletionRequest
     */
    n?: number | null;

    /**
     * Whether to stream back partial progress. If set, tokens will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available, with the stream terminated by a `data: [DONE]` message. [Example Python code](https://github.com/openai/openai-cookbook/blob/main/examples/How_to_stream_completions.ipynb).
     * @type {boolean}
     * @memberof CreateCompletionRequest
     */
    stream?: boolean | null;

    /**
     * Include the log probabilities on the `logprobs` most likely tokens, as well the chosen tokens. For example, if `logprobs` is 5, the API will return a list of the 5 most likely tokens. The API will always return the `logprob` of the sampled token, so there may be up to `logprobs+1` elements in the response.  The maximum value for `logprobs` is 5.
     * @type {number}
     * @memberof CreateCompletionRequest
     */
    logprobs?: number | null;

    /**
     * Echo back the prompt in addition to the completion
     * @type {boolean}
     * @memberof CreateCompletionRequest
     */
    echo?: boolean | null;

    /**
     * @type {CreateCompletionRequestStop}
     * @memberof CreateCompletionRequest
     */
    stop?: CreateCompletionRequestStop | null;

    /**
     * Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model\'s likelihood to talk about new topics.  [See more information about frequency and presence penalties.](/docs/api-reference/parameter-details)
     * @type {number}
     * @memberof CreateCompletionRequest
     */
    presence_penalty?: number | null;

    /**
     * Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model\'s likelihood to repeat the same line verbatim.  [See more information about frequency and presence penalties.](/docs/api-reference/parameter-details)
     * @type {number}
     * @memberof CreateCompletionRequest
     */
    frequency_penalty?: number | null;

    /**
     * Generates `best_of` completions server-side and returns the \"best\" (the one with the highest log probability per token). Results cannot be streamed.  When used with `n`, `best_of` controls the number of candidate completions and `n` specifies how many to return – `best_of` must be greater than `n`.  **Note:** Because this parameter generates many completions, it can quickly consume your token quota. Use carefully and ensure that you have reasonable settings for `max_tokens` and `stop`.
     * @type {number}
     * @memberof CreateCompletionRequest
     */
    best_of?: number | null;

    /**
     * Modify the likelihood of specified tokens appearing in the completion.  Accepts a json object that maps tokens (specified by their token ID in the GPT tokenizer) to an associated bias value from -100 to 100. You can use this [tokenizer tool](/tokenizer?view=bpe) (which works for both GPT-2 and GPT-3) to convert text to token IDs. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.  As an example, you can pass `{\"50256\": -100}` to prevent the <|endoftext|> token from being generated.
     * @type {{[key: string]: any}}
     * @memberof CreateCompletionRequest
     */
    logit_bias?: { [key: string]: any } | null;

    /**
     * A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
     * @type {string}
     * @memberof CreateCompletionRequest
     */
    user?: string;
  }

  /**
   * @type {CreateCompletionRequestPrompt} The prompt(s) to generate completions for, encoded as a string, array of strings, array of tokens, or array of token arrays.  Note that <|endoftext|> is the document separator that the model sees during training, so if a prompt is not specified the model will generate as if from the beginning of a new document.
   * @export
   */
  declare type CreateCompletionRequestPrompt =
    | Array<any>
    | Array<number>
    | Array<string>
    | string;

  /**
   * @type {CreateCompletionRequestStop} Up to 4 sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence.
   * @export
   */
  declare type CreateCompletionRequestStop = Array<string> | string;

  /**
   * @export
   * @interface CreateCompletionResponse
   */
  declare interface CreateCompletionResponse {
    /**
     * @type {string}
     * @memberof CreateCompletionResponse
     */
    id: string;

    /**
     * @type {string}
     * @memberof CreateCompletionResponse
     */
    object: string;

    /**
     * @type {number}
     * @memberof CreateCompletionResponse
     */
    created: number;

    /**
     * @type {string}
     * @memberof CreateCompletionResponse
     */
    model: string;

    /**
     * @type {Array<CreateCompletionResponseChoicesInner>}
     * @memberof CreateCompletionResponse
     */
    choices: Array<CreateCompletionResponseChoicesInner>;

    /**
     * @type {CreateCompletionResponseUsage}
     * @memberof CreateCompletionResponse
     */
    usage?: CreateCompletionResponseUsage;
  }

  /**
   * @export
   * @interface CreateCompletionResponseChoicesInner
   */
  declare interface CreateCompletionResponseChoicesInner {
    /**
     * @type {string}
     * @memberof CreateCompletionResponseChoicesInner
     */
    text?: string;

    /**
     * @type {number}
     * @memberof CreateCompletionResponseChoicesInner
     */
    index?: number;

    /**
     * @type {CreateCompletionResponseChoicesInnerLogprobs}
     * @memberof CreateCompletionResponseChoicesInner
     */
    logprobs?: CreateCompletionResponseChoicesInnerLogprobs | null;

    /**
     * @type {string}
     * @memberof CreateCompletionResponseChoicesInner
     */
    finish_reason?: string;
  }

  /**
   * @export
   * @interface CreateCompletionResponseChoicesInnerLogprobs
   */
  declare interface CreateCompletionResponseChoicesInnerLogprobs {
    /**
     * @type {Array<string>}
     * @memberof CreateCompletionResponseChoicesInnerLogprobs
     */
    tokens?: Array<string>;

    /**
     * @type {Array<number>}
     * @memberof CreateCompletionResponseChoicesInnerLogprobs
     */
    token_logprobs?: Array<number>;

    /**
     * @type {Array<{[key: string]: any}>}
     * @memberof CreateCompletionResponseChoicesInnerLogprobs
     */
    top_logprobs?: Array<{ [key: string]: any }>;

    /**
     * @type {Array<number>}
     * @memberof CreateCompletionResponseChoicesInnerLogprobs
     */
    text_offset?: Array<number>;
  }

  /**
   * @export
   * @interface CreateCompletionResponseUsage
   */
  declare interface CreateCompletionResponseUsage {
    /**
     * @type {number}
     * @memberof CreateCompletionResponseUsage
     */
    prompt_tokens: number;

    /**
     * @type {number}
     * @memberof CreateCompletionResponseUsage
     */
    completion_tokens: number;

    /**
     * @type {number}
     * @memberof CreateCompletionResponseUsage
     */
    total_tokens: number;
  }

  /**
   * @export
   * @interface CreateEditRequest
   */
  declare interface CreateEditRequest {
    /**
     * ID of the model to use. You can use the `text-davinci-edit-001` or `code-davinci-edit-001` model with this endpoint.
     * @type {string}
     * @memberof CreateEditRequest
     */
    model: string;

    /**
     * The input text to use as a starting point for the edit.
     * @type {string}
     * @memberof CreateEditRequest
     */
    input?: string | null;

    /**
     * The instruction that tells the model how to edit the prompt.
     * @type {string}
     * @memberof CreateEditRequest
     */
    instruction: string;

    /**
     * How many edits to generate for the input and instruction.
     * @type {number}
     * @memberof CreateEditRequest
     */
    n?: number | null;

    /**
     * What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.  We generally recommend altering this or `top_p` but not both.
     * @type {number}
     * @memberof CreateEditRequest
     */
    temperature?: number | null;

    /**
     * An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.  We generally recommend altering this or `temperature` but not both.
     * @type {number}
     * @memberof CreateEditRequest
     */
    top_p?: number | null;
  }

  /**
   * @export
   * @interface CreateEditResponse
   */
  declare interface CreateEditResponse {
    /**
     * @type {string}
     * @memberof CreateEditResponse
     */
    object: string;

    /**
     * @type {number}
     * @memberof CreateEditResponse
     */
    created: number;

    /**
     * @type {Array<CreateCompletionResponseChoicesInner>}
     * @memberof CreateEditResponse
     */
    choices: Array<CreateCompletionResponseChoicesInner>;

    /**
     * @type {CreateCompletionResponseUsage}
     * @memberof CreateEditResponse
     */
    usage: CreateCompletionResponseUsage;
  }

  /**
   * @export
   * @interface CreateEmbeddingRequest
   */
  declare interface CreateEmbeddingRequest {
    /**
     * ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
     * @type {string}
     * @memberof CreateEmbeddingRequest
     */
    model: string;

    /**
     * @type {CreateEmbeddingRequestInput}
     * @memberof CreateEmbeddingRequest
     */
    input: CreateEmbeddingRequestInput;

    /**
     * A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
     * @type {string}
     * @memberof CreateEmbeddingRequest
     */
    user?: string;
  }

  /**
   * @type {CreateEmbeddingRequestInput} Input text to embed, encoded as a string or array of tokens. To embed multiple inputs in a single request, pass an array of strings or array of token arrays. Each input must not exceed the max input tokens for the model (8191 tokens for `text-embedding-ada-002`). [Example Python code](https://github.com/openai/openai-cookbook/blob/main/examples/How_to_count_tokens_with_tiktoken.ipynb) for counting tokens.
   * @export
   */
  declare type CreateEmbeddingRequestInput =
    | Array<any>
    | Array<number>
    | Array<string>
    | string;

  /**
   * @export
   * @interface CreateEmbeddingResponse
   */
  declare interface CreateEmbeddingResponse {
    /**
     * @type {string}
     * @memberof CreateEmbeddingResponse
     */
    object: string;

    /**
     * @type {string}
     * @memberof CreateEmbeddingResponse
     */
    model: string;

    /**
     * @type {Array<CreateEmbeddingResponseDataInner>}
     * @memberof CreateEmbeddingResponse
     */
    data: Array<CreateEmbeddingResponseDataInner>;

    /**
     * @type {CreateEmbeddingResponseUsage}
     * @memberof CreateEmbeddingResponse
     */
    usage: CreateEmbeddingResponseUsage;
  }

  /**
   * @export
   * @interface CreateEmbeddingResponseDataInner
   */
  declare interface CreateEmbeddingResponseDataInner {
    /**
     * @type {number}
     * @memberof CreateEmbeddingResponseDataInner
     */
    index: number;

    /**
     * @type {string}
     * @memberof CreateEmbeddingResponseDataInner
     */
    object: string;

    /**
     * @type {Array<number>}
     * @memberof CreateEmbeddingResponseDataInner
     */
    embedding: Array<number>;
  }

  /**
   * @export
   * @interface CreateEmbeddingResponseUsage
   */
  declare interface CreateEmbeddingResponseUsage {
    /**
     * @type {number}
     * @memberof CreateEmbeddingResponseUsage
     */
    prompt_tokens: number;

    /**
     * @type {number}
     * @memberof CreateEmbeddingResponseUsage
     */
    total_tokens: number;
  }

  /**
   * @export
   * @interface CreateFineTuneRequest
   */
  declare interface CreateFineTuneRequest {
    /**
     * The ID of an uploaded file that contains training data.  See [upload file](/docs/api-reference/files/upload) for how to upload a file.  Your dataset must be formatted as a JSONL file, where each training example is a JSON object with the keys \"prompt\" and \"completion\". Additionally, you must upload your file with the purpose `fine-tune`.  See the [fine-tuning guide](/docs/guides/fine-tuning/creating-training-data) for more details.
     * @type {string}
     * @memberof CreateFineTuneRequest
     */
    training_file: string;

    /**
     * The ID of an uploaded file that contains validation data.  If you provide this file, the data is used to generate validation metrics periodically during fine-tuning. These metrics can be viewed in the [fine-tuning results file](/docs/guides/fine-tuning/analyzing-your-fine-tuned-model). Your train and validation data should be mutually exclusive.  Your dataset must be formatted as a JSONL file, where each validation example is a JSON object with the keys \"prompt\" and \"completion\". Additionally, you must upload your file with the purpose `fine-tune`.  See the [fine-tuning guide](/docs/guides/fine-tuning/creating-training-data) for more details.
     * @type {string}
     * @memberof CreateFineTuneRequest
     */
    validation_file?: string | null;

    /**
     * The name of the base model to fine-tune. You can select one of \"ada\", \"babbage\", \"curie\", \"davinci\", or a fine-tuned model created after 2022-04-21. To learn more about these models, see the [Models](https://platform.openai.com/docs/models) documentation.
     * @type {string}
     * @memberof CreateFineTuneRequest
     */
    model?: string | null;

    /**
     * The number of epochs to train the model for. An epoch refers to one full cycle through the training dataset.
     * @type {number}
     * @memberof CreateFineTuneRequest
     */
    n_epochs?: number | null;

    /**
     * The batch size to use for training. The batch size is the number of training examples used to train a single forward and backward pass.  By default, the batch size will be dynamically configured to be ~0.2% of the number of examples in the training set, capped at 256 - in general, we\'ve found that larger batch sizes tend to work better for larger datasets.
     * @type {number}
     * @memberof CreateFineTuneRequest
     */
    batch_size?: number | null;

    /**
     * The learning rate multiplier to use for training. The fine-tuning learning rate is the original learning rate used for pretraining multiplied by this value.  By default, the learning rate multiplier is the 0.05, 0.1, or 0.2 depending on final `batch_size` (larger learning rates tend to perform better with larger batch sizes). We recommend experimenting with values in the range 0.02 to 0.2 to see what produces the best results.
     * @type {number}
     * @memberof CreateFineTuneRequest
     */
    learning_rate_multiplier?: number | null;

    /**
     * The weight to use for loss on the prompt tokens. This controls how much the model tries to learn to generate the prompt (as compared to the completion which always has a weight of 1.0), and can add a stabilizing effect to training when completions are short.  If prompts are extremely long (relative to completions), it may make sense to reduce this weight so as to avoid over-prioritizing learning the prompt.
     * @type {number}
     * @memberof CreateFineTuneRequest
     */
    prompt_loss_weight?: number | null;

    /**
     * If set, we calculate classification-specific metrics such as accuracy and F-1 score using the validation set at the end of every epoch. These metrics can be viewed in the [results file](/docs/guides/fine-tuning/analyzing-your-fine-tuned-model).  In order to compute classification metrics, you must provide a `validation_file`. Additionally, you must specify `classification_n_classes` for multiclass classification or `classification_positive_class` for binary classification.
     * @type {boolean}
     * @memberof CreateFineTuneRequest
     */
    compute_classification_metrics?: boolean | null;

    /**
     * The number of classes in a classification task.  This parameter is required for multiclass classification.
     * @type {number}
     * @memberof CreateFineTuneRequest
     */
    classification_n_classes?: number | null;

    /**
     * The positive class in binary classification.  This parameter is needed to generate precision, recall, and F1 metrics when doing binary classification.
     * @type {string}
     * @memberof CreateFineTuneRequest
     */
    classification_positive_class?: string | null;

    /**
     * If this is provided, we calculate F-beta scores at the specified beta values. The F-beta score is a generalization of F-1 score. This is only used for binary classification.  With a beta of 1 (i.e. the F-1 score), precision and recall are given the same weight. A larger beta score puts more weight on recall and less on precision. A smaller beta score puts more weight on precision and less on recall.
     * @type {Array<number>}
     * @memberof CreateFineTuneRequest
     */
    classification_betas?: Array<number> | null;

    /**
     * A string of up to 40 characters that will be added to your fine-tuned model name.  For example, a `suffix` of \"custom-model-name\" would produce a model name like `ada:ft-your-org:custom-model-name-2022-02-15-04-21-04`.
     * @type {string}
     * @memberof CreateFineTuneRequest
     */
    suffix?: string | null;
  }
  declare interface CreateImageRequest {
    /**
     * A text description of the desired image(s). The maximum length is 1000 characters.
     * @type {string}
     * @memberof CreateImageRequest
     */
    prompt: string;

    /**
     * The number of images to generate. Must be between 1 and 10.
     * @type {number}
     * @memberof CreateImageRequest
     */
    n?: number | null;
    size?: CreateImageRequestSizeEnumType;
    response_format?: CreateImageRequestResponseFormatEnumType;

    /**
     * A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
     * @type {string}
     * @memberof CreateImageRequest
     */
    user?: string;
  }
  declare var CreateImageRequestSizeEnum: {
    +_256x256: "256x256",
    +_512x512: "512x512",
    +_1024x1024: "1024x1024",
    ...
  };
  declare type CreateImageRequestSizeEnumType = $ElementType<
    typeof CreateImageRequestSizeEnum,
    $Keys<typeof CreateImageRequestSizeEnum>
  >;
  declare var CreateImageRequestResponseFormatEnum: {
    +Url: "url",
    +B64Json: "b64_json",
    ...
  };
  declare type CreateImageRequestResponseFormatEnumType = $ElementType<
    typeof CreateImageRequestResponseFormatEnum,
    $Keys<typeof CreateImageRequestResponseFormatEnum>
  >;

  /**
   * @export
   * @interface CreateModerationRequest
   */
  declare interface CreateModerationRequest {
    /**
     * @type {CreateModerationRequestInput}
     * @memberof CreateModerationRequest
     */
    input: CreateModerationRequestInput;

    /**
     * Two content moderations models are available: `text-moderation-stable` and `text-moderation-latest`.  The default is `text-moderation-latest` which will be automatically upgraded over time. This ensures you are always using our most accurate model. If you use `text-moderation-stable`, we will provide advanced notice before updating the model. Accuracy of `text-moderation-stable` may be slightly lower than for `text-moderation-latest`.
     * @type {string}
     * @memberof CreateModerationRequest
     */
    model?: string;
  }

  /**
   * @type {CreateModerationRequestInput} The input text to classify
   * @export
   */
  declare type CreateModerationRequestInput = Array<string> | string;

  /**
   * @export
   * @interface CreateModerationResponse
   */
  declare interface CreateModerationResponse {
    /**
     * @type {string}
     * @memberof CreateModerationResponse
     */
    id: string;

    /**
     * @type {string}
     * @memberof CreateModerationResponse
     */
    model: string;

    /**
     * @type {Array<CreateModerationResponseResultsInner>}
     * @memberof CreateModerationResponse
     */
    results: Array<CreateModerationResponseResultsInner>;
  }

  /**
   * @export
   * @interface CreateModerationResponseResultsInner
   */
  declare interface CreateModerationResponseResultsInner {
    /**
     * @type {boolean}
     * @memberof CreateModerationResponseResultsInner
     */
    flagged: boolean;

    /**
     * @type {CreateModerationResponseResultsInnerCategories}
     * @memberof CreateModerationResponseResultsInner
     */
    categories: CreateModerationResponseResultsInnerCategories;

    /**
     * @type {CreateModerationResponseResultsInnerCategoryScores}
     * @memberof CreateModerationResponseResultsInner
     */
    category_scores: CreateModerationResponseResultsInnerCategoryScores;
  }

  /**
   * @export
   * @interface CreateModerationResponseResultsInnerCategories
   */
  declare interface CreateModerationResponseResultsInnerCategories {
    /**
     * @type {boolean}
     * @memberof CreateModerationResponseResultsInnerCategories
     */
    hate: boolean;

    /**
     * @type {boolean}
     * @memberof CreateModerationResponseResultsInnerCategories
     */
    // "hate/threatening": boolean; // Illegal name. [unsupported-syntax]

    /**
     * @type {boolean}
     * @memberof CreateModerationResponseResultsInnerCategories
     */
    // "self-harm": boolean; // Illegal name. [unsupported-syntax]

    /**
     * @type {boolean}
     * @memberof CreateModerationResponseResultsInnerCategories
     */
    sexual: boolean;

    /**
     * @type {boolean}
     * @memberof CreateModerationResponseResultsInnerCategories
     */
    // "sexual/minors": boolean; // Illegal name. [unsupported-syntax]

    /**
     * @type {boolean}
     * @memberof CreateModerationResponseResultsInnerCategories
     */
    violence: boolean;

    /**
     * @type {boolean}
     * @memberof CreateModerationResponseResultsInnerCategories
     */
    // "violence/graphic": boolean; // Illegal name. [unsupported-syntax]
  }

  /**
   * @export
   * @interface CreateModerationResponseResultsInnerCategoryScores
   */
  declare interface CreateModerationResponseResultsInnerCategoryScores {
    /**
     * @type {number}
     * @memberof CreateModerationResponseResultsInnerCategoryScores
     */
    hate: number;

    /**
     * @type {number}
     * @memberof CreateModerationResponseResultsInnerCategoryScores
     */
    // "hate/threatening": number; // Illegal name. [unsupported-syntax]

    /**
     * @type {number}
     * @memberof CreateModerationResponseResultsInnerCategoryScores
     */
    // "self-harm": number; // Illegal name. [unsupported-syntax]

    /**
     * @type {number}
     * @memberof CreateModerationResponseResultsInnerCategoryScores
     */
    sexual: number;

    /**
     * @type {number}
     * @memberof CreateModerationResponseResultsInnerCategoryScores
     */
    // "sexual/minors": number; // Illegal name. [unsupported-syntax]

    /**
     * @type {number}
     * @memberof CreateModerationResponseResultsInnerCategoryScores
     */
    violence: number;

    /**
     * @type {number}
     * @memberof CreateModerationResponseResultsInnerCategoryScores
     */
    // "violence/graphic": number; // Illegal name. [unsupported-syntax]
  }

  /**
   * @export
   * @interface CreateSearchRequest
   */
  declare interface CreateSearchRequest {
    /**
     * Query to search against the documents.
     * @type {string}
     * @memberof CreateSearchRequest
     */
    query: string;

    /**
     * Up to 200 documents to search over, provided as a list of strings.  The maximum document length (in tokens) is 2034 minus the number of tokens in the query.  You should specify either `documents` or a `file`, but not both.
     * @type {Array<string>}
     * @memberof CreateSearchRequest
     */
    documents?: Array<string> | null;

    /**
     * The ID of an uploaded file that contains documents to search over.  You should specify either `documents` or a `file`, but not both.
     * @type {string}
     * @memberof CreateSearchRequest
     */
    file?: string | null;

    /**
     * The maximum number of documents to be re-ranked and returned by search.  This flag only takes effect when `file` is set.
     * @type {number}
     * @memberof CreateSearchRequest
     */
    max_rerank?: number | null;

    /**
     * A special boolean flag for showing metadata. If set to `true`, each document entry in the returned JSON will contain a \"metadata\" field.  This flag only takes effect when `file` is set.
     * @type {boolean}
     * @memberof CreateSearchRequest
     */
    return_metadata?: boolean | null;

    /**
     * A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
     * @type {string}
     * @memberof CreateSearchRequest
     */
    user?: string;
  }

  /**
   * @export
   * @interface CreateSearchResponse
   */
  declare interface CreateSearchResponse {
    /**
     * @type {string}
     * @memberof CreateSearchResponse
     */
    object?: string;

    /**
     * @type {string}
     * @memberof CreateSearchResponse
     */
    model?: string;

    /**
     * @type {Array<CreateSearchResponseDataInner>}
     * @memberof CreateSearchResponse
     */
    data?: Array<CreateSearchResponseDataInner>;
  }

  /**
   * @export
   * @interface CreateSearchResponseDataInner
   */
  declare interface CreateSearchResponseDataInner {
    /**
     * @type {string}
     * @memberof CreateSearchResponseDataInner
     */
    object?: string;

    /**
     * @type {number}
     * @memberof CreateSearchResponseDataInner
     */
    document?: number;

    /**
     * @type {number}
     * @memberof CreateSearchResponseDataInner
     */
    score?: number;
  }

  /**
   * @export
   * @interface CreateTranscriptionResponse
   */
  declare interface CreateTranscriptionResponse {
    /**
     * @type {string}
     * @memberof CreateTranscriptionResponse
     */
    text: string;
  }

  /**
   * @export
   * @interface CreateTranslationResponse
   */
  declare interface CreateTranslationResponse {
    /**
     * @type {string}
     * @memberof CreateTranslationResponse
     */
    text: string;
  }

  /**
   * @export
   * @interface DeleteFileResponse
   */
  declare interface DeleteFileResponse {
    /**
     * @type {string}
     * @memberof DeleteFileResponse
     */
    id: string;

    /**
     * @type {string}
     * @memberof DeleteFileResponse
     */
    object: string;

    /**
     * @type {boolean}
     * @memberof DeleteFileResponse
     */
    deleted: boolean;
  }

  /**
   * @export
   * @interface DeleteModelResponse
   */
  declare interface DeleteModelResponse {
    /**
     * @type {string}
     * @memberof DeleteModelResponse
     */
    id: string;

    /**
     * @type {string}
     * @memberof DeleteModelResponse
     */
    object: string;

    /**
     * @type {boolean}
     * @memberof DeleteModelResponse
     */
    deleted: boolean;
  }

  /**
   * @export
   * @interface Engine
   */
  declare interface Engine {
    /**
     * @type {string}
     * @memberof Engine
     */
    id: string;

    /**
     * @type {string}
     * @memberof Engine
     */
    object: string;

    /**
     * @type {number}
     * @memberof Engine
     */
    created: number | null;

    /**
     * @type {boolean}
     * @memberof Engine
     */
    ready: boolean;
  }

  /**
   * @export
   * @interface ErrorResponse
   */
  declare interface ErrorResponse {
    /**
     * @type {Error}
     * @memberof ErrorResponse
     */
    error: Error;
  }

  /**
   * @export
   * @interface FineTune
   */
  declare interface FineTune {
    /**
     * @type {string}
     * @memberof FineTune
     */
    id: string;

    /**
     * @type {string}
     * @memberof FineTune
     */
    object: string;

    /**
     * @type {number}
     * @memberof FineTune
     */
    created_at: number;

    /**
     * @type {number}
     * @memberof FineTune
     */
    updated_at: number;

    /**
     * @type {string}
     * @memberof FineTune
     */
    model: string;

    /**
     * @type {string}
     * @memberof FineTune
     */
    fine_tuned_model: string | null;

    /**
     * @type {string}
     * @memberof FineTune
     */
    organization_id: string;

    /**
     * @type {string}
     * @memberof FineTune
     */
    status: string;

    /**
     * @type {{[key: string]: any}}
     * @memberof FineTune
     */
    hyperparams: { [key: string]: any };

    /**
     * @type {Array<OpenAIFile>}
     * @memberof FineTune
     */
    training_files: Array<OpenAIFile>;

    /**
     * @type {Array<OpenAIFile>}
     * @memberof FineTune
     */
    validation_files: Array<OpenAIFile>;

    /**
     * @type {Array<OpenAIFile>}
     * @memberof FineTune
     */
    result_files: Array<OpenAIFile>;

    /**
     * @type {Array<FineTuneEvent>}
     * @memberof FineTune
     */
    events?: Array<FineTuneEvent>;
  }

  /**
   * @export
   * @interface FineTuneEvent
   */
  declare interface FineTuneEvent {
    /**
     * @type {string}
     * @memberof FineTuneEvent
     */
    object: string;

    /**
     * @type {number}
     * @memberof FineTuneEvent
     */
    created_at: number;

    /**
     * @type {string}
     * @memberof FineTuneEvent
     */
    level: string;

    /**
     * @type {string}
     * @memberof FineTuneEvent
     */
    message: string;
  }

  /**
   * @export
   * @interface ImagesResponse
   */
  declare interface ImagesResponse {
    /**
     * @type {number}
     * @memberof ImagesResponse
     */
    created: number;

    /**
     * @type {Array<ImagesResponseDataInner>}
     * @memberof ImagesResponse
     */
    data: Array<ImagesResponseDataInner>;
  }

  /**
   * @export
   * @interface ImagesResponseDataInner
   */
  declare interface ImagesResponseDataInner {
    /**
     * @type {string}
     * @memberof ImagesResponseDataInner
     */
    url?: string;

    /**
     * @type {string}
     * @memberof ImagesResponseDataInner
     */
    b64_json?: string;
  }

  /**
   * @export
   * @interface ListEnginesResponse
   */
  declare interface ListEnginesResponse {
    /**
     * @type {string}
     * @memberof ListEnginesResponse
     */
    object: string;

    /**
     * @type {Array<Engine>}
     * @memberof ListEnginesResponse
     */
    data: Array<Engine>;
  }

  /**
   * @export
   * @interface ListFilesResponse
   */
  declare interface ListFilesResponse {
    /**
     * @type {string}
     * @memberof ListFilesResponse
     */
    object: string;

    /**
     * @type {Array<OpenAIFile>}
     * @memberof ListFilesResponse
     */
    data: Array<OpenAIFile>;
  }

  /**
   * @export
   * @interface ListFineTuneEventsResponse
   */
  declare interface ListFineTuneEventsResponse {
    /**
     * @type {string}
     * @memberof ListFineTuneEventsResponse
     */
    object: string;

    /**
     * @type {Array<FineTuneEvent>}
     * @memberof ListFineTuneEventsResponse
     */
    data: Array<FineTuneEvent>;
  }

  /**
   * @export
   * @interface ListFineTunesResponse
   */
  declare interface ListFineTunesResponse {
    /**
     * @type {string}
     * @memberof ListFineTunesResponse
     */
    object: string;

    /**
     * @type {Array<FineTune>}
     * @memberof ListFineTunesResponse
     */
    data: Array<FineTune>;
  }

  /**
   * @export
   * @interface ListModelsResponse
   */
  declare interface ListModelsResponse {
    /**
     * @type {string}
     * @memberof ListModelsResponse
     */
    object: string;

    /**
     * @type {Array<Model>}
     * @memberof ListModelsResponse
     */
    data: Array<Model>;
  }

  /**
   * @export
   * @interface Model
   */
  declare interface Model {
    /**
     * @type {string}
     * @memberof Model
     */
    id: string;

    /**
     * @type {string}
     * @memberof Model
     */
    object: string;

    /**
     * @type {number}
     * @memberof Model
     */
    created: number;

    /**
     * @type {string}
     * @memberof Model
     */
    owned_by: string;
  }

  /**
   * @export
   * @interface ModelError
   */
  declare interface ModelError {
    /**
     * @type {string}
     * @memberof ModelError
     */
    type: string;

    /**
     * @type {string}
     * @memberof ModelError
     */
    message: string;

    /**
     * @type {string}
     * @memberof ModelError
     */
    param: string | null;

    /**
     * @type {string}
     * @memberof ModelError
     */
    code: string | null;
  }

  /**
   * @export
   * @interface OpenAIFile
   */
  declare interface OpenAIFile {
    /**
     * @type {string}
     * @memberof OpenAIFile
     */
    id: string;

    /**
     * @type {string}
     * @memberof OpenAIFile
     */
    object: string;

    /**
     * @type {number}
     * @memberof OpenAIFile
     */
    bytes: number;

    /**
     * @type {number}
     * @memberof OpenAIFile
     */
    created_at: number;

    /**
     * @type {string}
     * @memberof OpenAIFile
     */
    filename: string;

    /**
     * @type {string}
     * @memberof OpenAIFile
     */
    purpose: string;

    /**
     * @type {string}
     * @memberof OpenAIFile
     */
    status?: string;

    /**
     * @type {{[key: string]: any}}
     * @memberof OpenAIFile
     */
    status_details?: { [key: string]: any } | null;
  }

  /**
   * OpenAIApi - axios parameter creator
   * @export
   */
  declare var OpenAIApiAxiosParamCreator: (configuration?: Configuration) => {
    /**
     * @summary Immediately cancel a fine-tune job.
     * @param {string} fineTuneId The ID of the fine-tune job to cancel
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    cancelFineTune: (
      fineTuneId: string,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Answers the specified question using the provided documents and examples.  The endpoint first [searches](/docs/api-reference/searches) over provided documents or files to find relevant context. The relevant context is combined with the provided examples and question to create the prompt for [completion](/docs/api-reference/completions).
     * @param {CreateAnswerRequest} createAnswerRequest
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     */
    createAnswer: (
      createAnswerRequest: CreateAnswerRequest,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Creates a model response for the given chat conversation.
     * @param {CreateChatCompletionRequest} createChatCompletionRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createChatCompletion: (
      createChatCompletionRequest: CreateChatCompletionRequest,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Classifies the specified `query` using provided examples.  The endpoint first [searches](/docs/api-reference/searches) over the labeled examples to select the ones most relevant for the particular query. Then, the relevant examples are combined with the query to construct a prompt to produce the final label via the [completions](/docs/api-reference/completions) endpoint.  Labeled examples can be provided via an uploaded `file`, or explicitly listed in the request using the `examples` parameter for quick tests and small scale use cases.
     * @param {CreateClassificationRequest} createClassificationRequest
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     */
    createClassification: (
      createClassificationRequest: CreateClassificationRequest,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Creates a completion for the provided prompt and parameters.
     * @param {CreateCompletionRequest} createCompletionRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createCompletion: (
      createCompletionRequest: CreateCompletionRequest,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Creates a new edit for the provided input, instruction, and parameters.
     * @param {CreateEditRequest} createEditRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createEdit: (
      createEditRequest: CreateEditRequest,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Creates an embedding vector representing the input text.
     * @param {CreateEmbeddingRequest} createEmbeddingRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createEmbedding: (
      createEmbeddingRequest: CreateEmbeddingRequest,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Upload a file that contains document(s) to be used across various endpoints/features. Currently, the size of all the files uploaded by one organization can be up to 1 GB. Please contact us if you need to increase the storage limit.
     * @param {File} file Name of the [JSON Lines](https://jsonlines.readthedocs.io/en/latest/) file to be uploaded.  If the &#x60;purpose&#x60; is set to \\\&quot;fine-tune\\\&quot;, each line is a JSON record with \\\&quot;prompt\\\&quot; and \\\&quot;completion\\\&quot; fields representing your [training examples](/docs/guides/fine-tuning/prepare-training-data).
     * @param {string} purpose The intended purpose of the uploaded documents.  Use \\\&quot;fine-tune\\\&quot; for [Fine-tuning](/docs/api-reference/fine-tunes). This allows us to validate the format of the uploaded file.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createFile: (
      file: File,
      purpose: string,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Creates a job that fine-tunes a specified model from a given dataset.  Response includes details of the enqueued job including job status and the name of the fine-tuned models once complete.  [Learn more about Fine-tuning](/docs/guides/fine-tuning)
     * @param {CreateFineTuneRequest} createFineTuneRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createFineTune: (
      createFineTuneRequest: CreateFineTuneRequest,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Creates an image given a prompt.
     * @param {CreateImageRequest} createImageRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createImage: (
      createImageRequest: CreateImageRequest,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Creates an edited or extended image given an original image and a prompt.
     * @param {File} image The image to edit. Must be a valid PNG file, less than 4MB, and square. If mask is not provided, image must have transparency, which will be used as the mask.
     * @param {string} prompt A text description of the desired image(s). The maximum length is 1000 characters.
     * @param {File} [mask] An additional image whose fully transparent areas (e.g. where alpha is zero) indicate where &#x60;image&#x60; should be edited. Must be a valid PNG file, less than 4MB, and have the same dimensions as &#x60;image&#x60;.
     * @param {number} [n] The number of images to generate. Must be between 1 and 10.
     * @param {string} [size] The size of the generated images. Must be one of &#x60;256x256&#x60;, &#x60;512x512&#x60;, or &#x60;1024x1024&#x60;.
     * @param {string} [responseFormat] The format in which the generated images are returned. Must be one of &#x60;url&#x60; or &#x60;b64_json&#x60;.
     * @param {string} [user] A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createImageEdit: (
      image: File,
      prompt: string,
      mask?: File,
      n?: number,
      size?: string,
      responseFormat?: string,
      user?: string,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Creates a variation of a given image.
     * @param {File} image The image to use as the basis for the variation(s). Must be a valid PNG file, less than 4MB, and square.
     * @param {number} [n] The number of images to generate. Must be between 1 and 10.
     * @param {string} [size] The size of the generated images. Must be one of &#x60;256x256&#x60;, &#x60;512x512&#x60;, or &#x60;1024x1024&#x60;.
     * @param {string} [responseFormat] The format in which the generated images are returned. Must be one of &#x60;url&#x60; or &#x60;b64_json&#x60;.
     * @param {string} [user] A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createImageVariation: (
      image: File,
      n?: number,
      size?: string,
      responseFormat?: string,
      user?: string,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Classifies if text violates OpenAI\'s Content Policy
     * @param {CreateModerationRequest} createModerationRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createModeration: (
      createModerationRequest: CreateModerationRequest,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary The search endpoint computes similarity scores between provided query and documents. Documents can be passed directly to the API if there are no more than 200 of them.  To go beyond the 200 document limit, documents can be processed offline and then used for efficient retrieval at query time. When `file` is set, the search endpoint searches over all the documents in the given file and returns up to the `max_rerank` number of documents. These documents will be returned along with their search scores.  The similarity score is a positive score that usually ranges from 0 to 300 (but can sometimes go higher), where a score above 200 usually means the document is semantically similar to the query.
     * @param {string} engineId The ID of the engine to use for this request.  You can select one of &#x60;ada&#x60;, &#x60;babbage&#x60;, &#x60;curie&#x60;, or &#x60;davinci&#x60;.
     * @param {CreateSearchRequest} createSearchRequest
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     */
    createSearch: (
      engineId: string,
      createSearchRequest: CreateSearchRequest,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Transcribes audio into the input language.
     * @param {File} file The audio file object (not file name) to transcribe, in one of these formats: mp3, mp4, mpeg, mpga, m4a, wav, or webm.
     * @param {string} model ID of the model to use. Only &#x60;whisper-1&#x60; is currently available.
     * @param {string} [prompt] An optional text to guide the model\\\&#39;s style or continue a previous audio segment. The [prompt](/docs/guides/speech-to-text/prompting) should match the audio language.
     * @param {string} [responseFormat] The format of the transcript output, in one of these options: json, text, srt, verbose_json, or vtt.
     * @param {number} [temperature] The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use [log probability](https://en.wikipedia.org/wiki/Log_probability) to automatically increase the temperature until certain thresholds are hit.
     * @param {string} [language] The language of the input audio. Supplying the input language in [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) format will improve accuracy and latency.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createTranscription: (
      file: File,
      model: string,
      prompt?: string,
      responseFormat?: string,
      temperature?: number,
      language?: string,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Translates audio into into English.
     * @param {File} file The audio file object (not file name) translate, in one of these formats: mp3, mp4, mpeg, mpga, m4a, wav, or webm.
     * @param {string} model ID of the model to use. Only &#x60;whisper-1&#x60; is currently available.
     * @param {string} [prompt] An optional text to guide the model\\\&#39;s style or continue a previous audio segment. The [prompt](/docs/guides/speech-to-text/prompting) should be in English.
     * @param {string} [responseFormat] The format of the transcript output, in one of these options: json, text, srt, verbose_json, or vtt.
     * @param {number} [temperature] The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use [log probability](https://en.wikipedia.org/wiki/Log_probability) to automatically increase the temperature until certain thresholds are hit.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createTranslation: (
      file: File,
      model: string,
      prompt?: string,
      responseFormat?: string,
      temperature?: number,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Delete a file.
     * @param {string} fileId The ID of the file to use for this request
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteFile: (
      fileId: string,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Delete a fine-tuned model. You must have the Owner role in your organization.
     * @param {string} model The model to delete
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteModel: (
      model: string,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Returns the contents of the specified file
     * @param {string} fileId The ID of the file to use for this request
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    downloadFile: (
      fileId: string,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Lists the currently available (non-finetuned) models, and provides basic information about each one such as the owner and availability.
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     */
    listEngines: (options?: AxiosXHRConfig<Object>) => Promise<RequestArgs>,

    /**
     * @summary Returns a list of files that belong to the user\'s organization.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listFiles: (options?: AxiosXHRConfig<Object>) => Promise<RequestArgs>,

    /**
     * @summary Get fine-grained status updates for a fine-tune job.
     * @param {string} fineTuneId The ID of the fine-tune job to get events for.
     * @param {boolean} [stream] Whether to stream events for the fine-tune job. If set to true, events will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available. The stream will terminate with a &#x60;data: [DONE]&#x60; message when the job is finished (succeeded, cancelled, or failed).  If set to false, only events generated so far will be returned.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listFineTuneEvents: (
      fineTuneId: string,
      stream?: boolean,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary List your organization\'s fine-tuning jobs
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listFineTunes: (options?: AxiosXHRConfig<Object>) => Promise<RequestArgs>,

    /**
     * @summary Lists the currently available models, and provides basic information about each one such as the owner and availability.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listModels: (options?: AxiosXHRConfig<Object>) => Promise<RequestArgs>,

    /**
     * @summary Retrieves a model instance, providing basic information about it such as the owner and availability.
     * @param {string} engineId The ID of the engine to use for this request
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     */
    retrieveEngine: (
      engineId: string,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Returns information about a specific file.
     * @param {string} fileId The ID of the file to use for this request
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    retrieveFile: (
      fileId: string,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Gets info about the fine-tune job.  [Learn more about Fine-tuning](/docs/guides/fine-tuning)
     * @param {string} fineTuneId The ID of the fine-tune job
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    retrieveFineTune: (
      fineTuneId: string,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,

    /**
     * @summary Retrieves a model instance, providing basic information about the model such as the owner and permissioning.
     * @param {string} model The ID of the model to use for this request
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    retrieveModel: (
      model: string,
      options?: AxiosXHRConfig<Object>
    ) => Promise<RequestArgs>,
    ...
  };

  /**
   * OpenAIApi - functional programming interface
   * @export
   */
  declare var OpenAIApiFp: (configuration?: Configuration) => {
    /**
     * @summary Immediately cancel a fine-tune job.
     * @param {string} fineTuneId The ID of the fine-tune job to cancel
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    cancelFineTune(
      fineTuneId: string,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (axios?: Axios, basePath?: string) => AxiosPromise<FineTune>
    >,

    /**
     * @summary Answers the specified question using the provided documents and examples.  The endpoint first [searches](/docs/api-reference/searches) over provided documents or files to find relevant context. The relevant context is combined with the provided examples and question to create the prompt for [completion](/docs/api-reference/completions).
     * @param {CreateAnswerRequest} createAnswerRequest
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     */
    createAnswer(
      createAnswerRequest: CreateAnswerRequest,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (
        axios?: Axios,
        basePath?: string
      ) => AxiosPromise<CreateAnswerResponse>
    >,

    /**
     * @summary Creates a model response for the given chat conversation.
     * @param {CreateChatCompletionRequest} createChatCompletionRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createChatCompletion(
      createChatCompletionRequest: CreateChatCompletionRequest,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (
        axios?: Axios,
        basePath?: string
      ) => AxiosPromise<CreateChatCompletionResponse>
    >,

    /**
     * @summary Classifies the specified `query` using provided examples.  The endpoint first [searches](/docs/api-reference/searches) over the labeled examples to select the ones most relevant for the particular query. Then, the relevant examples are combined with the query to construct a prompt to produce the final label via the [completions](/docs/api-reference/completions) endpoint.  Labeled examples can be provided via an uploaded `file`, or explicitly listed in the request using the `examples` parameter for quick tests and small scale use cases.
     * @param {CreateClassificationRequest} createClassificationRequest
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     */
    createClassification(
      createClassificationRequest: CreateClassificationRequest,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (
        axios?: Axios,
        basePath?: string
      ) => AxiosPromise<CreateClassificationResponse>
    >,

    /**
     * @summary Creates a completion for the provided prompt and parameters.
     * @param {CreateCompletionRequest} createCompletionRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createCompletion(
      createCompletionRequest: CreateCompletionRequest,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (
        axios?: Axios,
        basePath?: string
      ) => AxiosPromise<CreateCompletionResponse>
    >,

    /**
     * @summary Creates a new edit for the provided input, instruction, and parameters.
     * @param {CreateEditRequest} createEditRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createEdit(
      createEditRequest: CreateEditRequest,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (
        axios?: Axios,
        basePath?: string
      ) => AxiosPromise<CreateEditResponse>
    >,

    /**
     * @summary Creates an embedding vector representing the input text.
     * @param {CreateEmbeddingRequest} createEmbeddingRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createEmbedding(
      createEmbeddingRequest: CreateEmbeddingRequest,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (
        axios?: Axios,
        basePath?: string
      ) => AxiosPromise<CreateEmbeddingResponse>
    >,

    /**
     * @summary Upload a file that contains document(s) to be used across various endpoints/features. Currently, the size of all the files uploaded by one organization can be up to 1 GB. Please contact us if you need to increase the storage limit.
     * @param {File} file Name of the [JSON Lines](https://jsonlines.readthedocs.io/en/latest/) file to be uploaded.  If the &#x60;purpose&#x60; is set to \\\&quot;fine-tune\\\&quot;, each line is a JSON record with \\\&quot;prompt\\\&quot; and \\\&quot;completion\\\&quot; fields representing your [training examples](/docs/guides/fine-tuning/prepare-training-data).
     * @param {string} purpose The intended purpose of the uploaded documents.  Use \\\&quot;fine-tune\\\&quot; for [Fine-tuning](/docs/api-reference/fine-tunes). This allows us to validate the format of the uploaded file.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createFile(
      file: File,
      purpose: string,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (axios?: Axios, basePath?: string) => AxiosPromise<OpenAIFile>
    >,

    /**
     * @summary Creates a job that fine-tunes a specified model from a given dataset.  Response includes details of the enqueued job including job status and the name of the fine-tuned models once complete.  [Learn more about Fine-tuning](/docs/guides/fine-tuning)
     * @param {CreateFineTuneRequest} createFineTuneRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createFineTune(
      createFineTuneRequest: CreateFineTuneRequest,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (axios?: Axios, basePath?: string) => AxiosPromise<FineTune>
    >,

    /**
     * @summary Creates an image given a prompt.
     * @param {CreateImageRequest} createImageRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createImage(
      createImageRequest: CreateImageRequest,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (axios?: Axios, basePath?: string) => AxiosPromise<ImagesResponse>
    >,

    /**
     * @summary Creates an edited or extended image given an original image and a prompt.
     * @param {File} image The image to edit. Must be a valid PNG file, less than 4MB, and square. If mask is not provided, image must have transparency, which will be used as the mask.
     * @param {string} prompt A text description of the desired image(s). The maximum length is 1000 characters.
     * @param {File} [mask] An additional image whose fully transparent areas (e.g. where alpha is zero) indicate where &#x60;image&#x60; should be edited. Must be a valid PNG file, less than 4MB, and have the same dimensions as &#x60;image&#x60;.
     * @param {number} [n] The number of images to generate. Must be between 1 and 10.
     * @param {string} [size] The size of the generated images. Must be one of &#x60;256x256&#x60;, &#x60;512x512&#x60;, or &#x60;1024x1024&#x60;.
     * @param {string} [responseFormat] The format in which the generated images are returned. Must be one of &#x60;url&#x60; or &#x60;b64_json&#x60;.
     * @param {string} [user] A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createImageEdit(
      image: File,
      prompt: string,
      mask?: File,
      n?: number,
      size?: string,
      responseFormat?: string,
      user?: string,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (axios?: Axios, basePath?: string) => AxiosPromise<ImagesResponse>
    >,

    /**
     * @summary Creates a variation of a given image.
     * @param {File} image The image to use as the basis for the variation(s). Must be a valid PNG file, less than 4MB, and square.
     * @param {number} [n] The number of images to generate. Must be between 1 and 10.
     * @param {string} [size] The size of the generated images. Must be one of &#x60;256x256&#x60;, &#x60;512x512&#x60;, or &#x60;1024x1024&#x60;.
     * @param {string} [responseFormat] The format in which the generated images are returned. Must be one of &#x60;url&#x60; or &#x60;b64_json&#x60;.
     * @param {string} [user] A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createImageVariation(
      image: File,
      n?: number,
      size?: string,
      responseFormat?: string,
      user?: string,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (axios?: Axios, basePath?: string) => AxiosPromise<ImagesResponse>
    >,

    /**
     * @summary Classifies if text violates OpenAI\'s Content Policy
     * @param {CreateModerationRequest} createModerationRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createModeration(
      createModerationRequest: CreateModerationRequest,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (
        axios?: Axios,
        basePath?: string
      ) => AxiosPromise<CreateModerationResponse>
    >,

    /**
     * @summary The search endpoint computes similarity scores between provided query and documents. Documents can be passed directly to the API if there are no more than 200 of them.  To go beyond the 200 document limit, documents can be processed offline and then used for efficient retrieval at query time. When `file` is set, the search endpoint searches over all the documents in the given file and returns up to the `max_rerank` number of documents. These documents will be returned along with their search scores.  The similarity score is a positive score that usually ranges from 0 to 300 (but can sometimes go higher), where a score above 200 usually means the document is semantically similar to the query.
     * @param {string} engineId The ID of the engine to use for this request.  You can select one of &#x60;ada&#x60;, &#x60;babbage&#x60;, &#x60;curie&#x60;, or &#x60;davinci&#x60;.
     * @param {CreateSearchRequest} createSearchRequest
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     */
    createSearch(
      engineId: string,
      createSearchRequest: CreateSearchRequest,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (
        axios?: Axios,
        basePath?: string
      ) => AxiosPromise<CreateSearchResponse>
    >,

    /**
     * @summary Transcribes audio into the input language.
     * @param {File} file The audio file object (not file name) to transcribe, in one of these formats: mp3, mp4, mpeg, mpga, m4a, wav, or webm.
     * @param {string} model ID of the model to use. Only &#x60;whisper-1&#x60; is currently available.
     * @param {string} [prompt] An optional text to guide the model\\\&#39;s style or continue a previous audio segment. The [prompt](/docs/guides/speech-to-text/prompting) should match the audio language.
     * @param {string} [responseFormat] The format of the transcript output, in one of these options: json, text, srt, verbose_json, or vtt.
     * @param {number} [temperature] The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use [log probability](https://en.wikipedia.org/wiki/Log_probability) to automatically increase the temperature until certain thresholds are hit.
     * @param {string} [language] The language of the input audio. Supplying the input language in [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) format will improve accuracy and latency.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createTranscription(
      file: File,
      model: string,
      prompt?: string,
      responseFormat?: string,
      temperature?: number,
      language?: string,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (
        axios?: Axios,
        basePath?: string
      ) => AxiosPromise<CreateTranscriptionResponse>
    >,

    /**
     * @summary Translates audio into into English.
     * @param {File} file The audio file object (not file name) translate, in one of these formats: mp3, mp4, mpeg, mpga, m4a, wav, or webm.
     * @param {string} model ID of the model to use. Only &#x60;whisper-1&#x60; is currently available.
     * @param {string} [prompt] An optional text to guide the model\\\&#39;s style or continue a previous audio segment. The [prompt](/docs/guides/speech-to-text/prompting) should be in English.
     * @param {string} [responseFormat] The format of the transcript output, in one of these options: json, text, srt, verbose_json, or vtt.
     * @param {number} [temperature] The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use [log probability](https://en.wikipedia.org/wiki/Log_probability) to automatically increase the temperature until certain thresholds are hit.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createTranslation(
      file: File,
      model: string,
      prompt?: string,
      responseFormat?: string,
      temperature?: number,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (
        axios?: Axios,
        basePath?: string
      ) => AxiosPromise<CreateTranslationResponse>
    >,

    /**
     * @summary Delete a file.
     * @param {string} fileId The ID of the file to use for this request
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteFile(
      fileId: string,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (
        axios?: Axios,
        basePath?: string
      ) => AxiosPromise<DeleteFileResponse>
    >,

    /**
     * @summary Delete a fine-tuned model. You must have the Owner role in your organization.
     * @param {string} model The model to delete
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteModel(
      model: string,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (
        axios?: Axios,
        basePath?: string
      ) => AxiosPromise<DeleteModelResponse>
    >,

    /**
     * @summary Returns the contents of the specified file
     * @param {string} fileId The ID of the file to use for this request
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    downloadFile(
      fileId: string,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (axios?: Axios, basePath?: string) => AxiosPromise<string>
    >,

    /**
     * @summary Lists the currently available (non-finetuned) models, and provides basic information about each one such as the owner and availability.
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     */
    listEngines(
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (
        axios?: Axios,
        basePath?: string
      ) => AxiosPromise<ListEnginesResponse>
    >,

    /**
     * @summary Returns a list of files that belong to the user\'s organization.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listFiles(
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (
        axios?: Axios,
        basePath?: string
      ) => AxiosPromise<ListFilesResponse>
    >,

    /**
     * @summary Get fine-grained status updates for a fine-tune job.
     * @param {string} fineTuneId The ID of the fine-tune job to get events for.
     * @param {boolean} [stream] Whether to stream events for the fine-tune job. If set to true, events will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available. The stream will terminate with a &#x60;data: [DONE]&#x60; message when the job is finished (succeeded, cancelled, or failed).  If set to false, only events generated so far will be returned.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listFineTuneEvents(
      fineTuneId: string,
      stream?: boolean,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (
        axios?: Axios,
        basePath?: string
      ) => AxiosPromise<ListFineTuneEventsResponse>
    >,

    /**
     * @summary List your organization\'s fine-tuning jobs
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listFineTunes(
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (
        axios?: Axios,
        basePath?: string
      ) => AxiosPromise<ListFineTunesResponse>
    >,

    /**
     * @summary Lists the currently available models, and provides basic information about each one such as the owner and availability.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listModels(
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (
        axios?: Axios,
        basePath?: string
      ) => AxiosPromise<ListModelsResponse>
    >,

    /**
     * @summary Retrieves a model instance, providing basic information about it such as the owner and availability.
     * @param {string} engineId The ID of the engine to use for this request
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     */
    retrieveEngine(
      engineId: string,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (axios?: Axios, basePath?: string) => AxiosPromise<Engine>
    >,

    /**
     * @summary Returns information about a specific file.
     * @param {string} fileId The ID of the file to use for this request
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    retrieveFile(
      fileId: string,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (axios?: Axios, basePath?: string) => AxiosPromise<OpenAIFile>
    >,

    /**
     * @summary Gets info about the fine-tune job.  [Learn more about Fine-tuning](/docs/guides/fine-tuning)
     * @param {string} fineTuneId The ID of the fine-tune job
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    retrieveFineTune(
      fineTuneId: string,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (axios?: Axios, basePath?: string) => AxiosPromise<FineTune>
    >,

    /**
     * @summary Retrieves a model instance, providing basic information about the model such as the owner and permissioning.
     * @param {string} model The ID of the model to use for this request
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    retrieveModel(
      model: string,
      options?: AxiosXHRConfig<Object>
    ): Promise<
      (axios?: Axios, basePath?: string) => AxiosPromise<Model>
    >,
    ...
  };

  /**
   * OpenAIApi - factory interface
   * @export
   */
  declare var OpenAIApiFactory: (
    configuration?: Configuration,
    basePath?: string,
    axios?: Axios
  ) => {
    /**
     * @summary Immediately cancel a fine-tune job.
     * @param {string} fineTuneId The ID of the fine-tune job to cancel
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    cancelFineTune(fineTuneId: string, options?: any): AxiosPromise<FineTune>,

    /**
     * @summary Answers the specified question using the provided documents and examples.  The endpoint first [searches](/docs/api-reference/searches) over provided documents or files to find relevant context. The relevant context is combined with the provided examples and question to create the prompt for [completion](/docs/api-reference/completions).
     * @param {CreateAnswerRequest} createAnswerRequest
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     */
    createAnswer(
      createAnswerRequest: CreateAnswerRequest,
      options?: any
    ): AxiosPromise<CreateAnswerResponse>,

    /**
     * @summary Creates a model response for the given chat conversation.
     * @param {CreateChatCompletionRequest} createChatCompletionRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createChatCompletion(
      createChatCompletionRequest: CreateChatCompletionRequest,
      options?: any
    ): AxiosPromise<CreateChatCompletionResponse>,

    /**
     * @summary Classifies the specified `query` using provided examples.  The endpoint first [searches](/docs/api-reference/searches) over the labeled examples to select the ones most relevant for the particular query. Then, the relevant examples are combined with the query to construct a prompt to produce the final label via the [completions](/docs/api-reference/completions) endpoint.  Labeled examples can be provided via an uploaded `file`, or explicitly listed in the request using the `examples` parameter for quick tests and small scale use cases.
     * @param {CreateClassificationRequest} createClassificationRequest
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     */
    createClassification(
      createClassificationRequest: CreateClassificationRequest,
      options?: any
    ): AxiosPromise<CreateClassificationResponse>,

    /**
     * @summary Creates a completion for the provided prompt and parameters.
     * @param {CreateCompletionRequest} createCompletionRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createCompletion(
      createCompletionRequest: CreateCompletionRequest,
      options?: any
    ): AxiosPromise<CreateCompletionResponse>,

    /**
     * @summary Creates a new edit for the provided input, instruction, and parameters.
     * @param {CreateEditRequest} createEditRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createEdit(
      createEditRequest: CreateEditRequest,
      options?: any
    ): AxiosPromise<CreateEditResponse>,

    /**
     * @summary Creates an embedding vector representing the input text.
     * @param {CreateEmbeddingRequest} createEmbeddingRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createEmbedding(
      createEmbeddingRequest: CreateEmbeddingRequest,
      options?: any
    ): AxiosPromise<CreateEmbeddingResponse>,

    /**
     * @summary Upload a file that contains document(s) to be used across various endpoints/features. Currently, the size of all the files uploaded by one organization can be up to 1 GB. Please contact us if you need to increase the storage limit.
     * @param {File} file Name of the [JSON Lines](https://jsonlines.readthedocs.io/en/latest/) file to be uploaded.  If the &#x60;purpose&#x60; is set to \\\&quot;fine-tune\\\&quot;, each line is a JSON record with \\\&quot;prompt\\\&quot; and \\\&quot;completion\\\&quot; fields representing your [training examples](/docs/guides/fine-tuning/prepare-training-data).
     * @param {string} purpose The intended purpose of the uploaded documents.  Use \\\&quot;fine-tune\\\&quot; for [Fine-tuning](/docs/api-reference/fine-tunes). This allows us to validate the format of the uploaded file.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createFile(
      file: File,
      purpose: string,
      options?: any
    ): AxiosPromise<OpenAIFile>,

    /**
     * @summary Creates a job that fine-tunes a specified model from a given dataset.  Response includes details of the enqueued job including job status and the name of the fine-tuned models once complete.  [Learn more about Fine-tuning](/docs/guides/fine-tuning)
     * @param {CreateFineTuneRequest} createFineTuneRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createFineTune(
      createFineTuneRequest: CreateFineTuneRequest,
      options?: any
    ): AxiosPromise<FineTune>,

    /**
     * @summary Creates an image given a prompt.
     * @param {CreateImageRequest} createImageRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createImage(
      createImageRequest: CreateImageRequest,
      options?: any
    ): AxiosPromise<ImagesResponse>,

    /**
     * @summary Creates an edited or extended image given an original image and a prompt.
     * @param {File} image The image to edit. Must be a valid PNG file, less than 4MB, and square. If mask is not provided, image must have transparency, which will be used as the mask.
     * @param {string} prompt A text description of the desired image(s). The maximum length is 1000 characters.
     * @param {File} [mask] An additional image whose fully transparent areas (e.g. where alpha is zero) indicate where &#x60;image&#x60; should be edited. Must be a valid PNG file, less than 4MB, and have the same dimensions as &#x60;image&#x60;.
     * @param {number} [n] The number of images to generate. Must be between 1 and 10.
     * @param {string} [size] The size of the generated images. Must be one of &#x60;256x256&#x60;, &#x60;512x512&#x60;, or &#x60;1024x1024&#x60;.
     * @param {string} [responseFormat] The format in which the generated images are returned. Must be one of &#x60;url&#x60; or &#x60;b64_json&#x60;.
     * @param {string} [user] A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createImageEdit(
      image: File,
      prompt: string,
      mask?: File,
      n?: number,
      size?: string,
      responseFormat?: string,
      user?: string,
      options?: any
    ): AxiosPromise<ImagesResponse>,

    /**
     * @summary Creates a variation of a given image.
     * @param {File} image The image to use as the basis for the variation(s). Must be a valid PNG file, less than 4MB, and square.
     * @param {number} [n] The number of images to generate. Must be between 1 and 10.
     * @param {string} [size] The size of the generated images. Must be one of &#x60;256x256&#x60;, &#x60;512x512&#x60;, or &#x60;1024x1024&#x60;.
     * @param {string} [responseFormat] The format in which the generated images are returned. Must be one of &#x60;url&#x60; or &#x60;b64_json&#x60;.
     * @param {string} [user] A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createImageVariation(
      image: File,
      n?: number,
      size?: string,
      responseFormat?: string,
      user?: string,
      options?: any
    ): AxiosPromise<ImagesResponse>,

    /**
     * @summary Classifies if text violates OpenAI\'s Content Policy
     * @param {CreateModerationRequest} createModerationRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createModeration(
      createModerationRequest: CreateModerationRequest,
      options?: any
    ): AxiosPromise<CreateModerationResponse>,

    /**
     * @summary The search endpoint computes similarity scores between provided query and documents. Documents can be passed directly to the API if there are no more than 200 of them.  To go beyond the 200 document limit, documents can be processed offline and then used for efficient retrieval at query time. When `file` is set, the search endpoint searches over all the documents in the given file and returns up to the `max_rerank` number of documents. These documents will be returned along with their search scores.  The similarity score is a positive score that usually ranges from 0 to 300 (but can sometimes go higher), where a score above 200 usually means the document is semantically similar to the query.
     * @param {string} engineId The ID of the engine to use for this request.  You can select one of &#x60;ada&#x60;, &#x60;babbage&#x60;, &#x60;curie&#x60;, or &#x60;davinci&#x60;.
     * @param {CreateSearchRequest} createSearchRequest
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     */
    createSearch(
      engineId: string,
      createSearchRequest: CreateSearchRequest,
      options?: any
    ): AxiosPromise<CreateSearchResponse>,

    /**
     * @summary Transcribes audio into the input language.
     * @param {File} file The audio file object (not file name) to transcribe, in one of these formats: mp3, mp4, mpeg, mpga, m4a, wav, or webm.
     * @param {string} model ID of the model to use. Only &#x60;whisper-1&#x60; is currently available.
     * @param {string} [prompt] An optional text to guide the model\\\&#39;s style or continue a previous audio segment. The [prompt](/docs/guides/speech-to-text/prompting) should match the audio language.
     * @param {string} [responseFormat] The format of the transcript output, in one of these options: json, text, srt, verbose_json, or vtt.
     * @param {number} [temperature] The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use [log probability](https://en.wikipedia.org/wiki/Log_probability) to automatically increase the temperature until certain thresholds are hit.
     * @param {string} [language] The language of the input audio. Supplying the input language in [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) format will improve accuracy and latency.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createTranscription(
      file: File,
      model: string,
      prompt?: string,
      responseFormat?: string,
      temperature?: number,
      language?: string,
      options?: any
    ): AxiosPromise<CreateTranscriptionResponse>,

    /**
     * @summary Translates audio into into English.
     * @param {File} file The audio file object (not file name) translate, in one of these formats: mp3, mp4, mpeg, mpga, m4a, wav, or webm.
     * @param {string} model ID of the model to use. Only &#x60;whisper-1&#x60; is currently available.
     * @param {string} [prompt] An optional text to guide the model\\\&#39;s style or continue a previous audio segment. The [prompt](/docs/guides/speech-to-text/prompting) should be in English.
     * @param {string} [responseFormat] The format of the transcript output, in one of these options: json, text, srt, verbose_json, or vtt.
     * @param {number} [temperature] The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use [log probability](https://en.wikipedia.org/wiki/Log_probability) to automatically increase the temperature until certain thresholds are hit.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createTranslation(
      file: File,
      model: string,
      prompt?: string,
      responseFormat?: string,
      temperature?: number,
      options?: any
    ): AxiosPromise<CreateTranslationResponse>,

    /**
     * @summary Delete a file.
     * @param {string} fileId The ID of the file to use for this request
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteFile(fileId: string, options?: any): AxiosPromise<DeleteFileResponse>,

    /**
     * @summary Delete a fine-tuned model. You must have the Owner role in your organization.
     * @param {string} model The model to delete
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteModel(
      model: string,
      options?: any
    ): AxiosPromise<DeleteModelResponse>,

    /**
     * @summary Returns the contents of the specified file
     * @param {string} fileId The ID of the file to use for this request
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    downloadFile(fileId: string, options?: any): AxiosPromise<string>,

    /**
     * @summary Lists the currently available (non-finetuned) models, and provides basic information about each one such as the owner and availability.
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     */
    listEngines(options?: any): AxiosPromise<ListEnginesResponse>,

    /**
     * @summary Returns a list of files that belong to the user\'s organization.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listFiles(options?: any): AxiosPromise<ListFilesResponse>,

    /**
     * @summary Get fine-grained status updates for a fine-tune job.
     * @param {string} fineTuneId The ID of the fine-tune job to get events for.
     * @param {boolean} [stream] Whether to stream events for the fine-tune job. If set to true, events will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available. The stream will terminate with a &#x60;data: [DONE]&#x60; message when the job is finished (succeeded, cancelled, or failed).  If set to false, only events generated so far will be returned.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listFineTuneEvents(
      fineTuneId: string,
      stream?: boolean,
      options?: any
    ): AxiosPromise<ListFineTuneEventsResponse>,

    /**
     * @summary List your organization\'s fine-tuning jobs
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listFineTunes(options?: any): AxiosPromise<ListFineTunesResponse>,

    /**
     * @summary Lists the currently available models, and provides basic information about each one such as the owner and availability.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listModels(options?: any): AxiosPromise<ListModelsResponse>,

    /**
     * @summary Retrieves a model instance, providing basic information about it such as the owner and availability.
     * @param {string} engineId The ID of the engine to use for this request
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     */
    retrieveEngine(engineId: string, options?: any): AxiosPromise<Engine>,

    /**
     * @summary Returns information about a specific file.
     * @param {string} fileId The ID of the file to use for this request
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    retrieveFile(fileId: string, options?: any): AxiosPromise<OpenAIFile>,

    /**
     * @summary Gets info about the fine-tune job.  [Learn more about Fine-tuning](/docs/guides/fine-tuning)
     * @param {string} fineTuneId The ID of the fine-tune job
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    retrieveFineTune(fineTuneId: string, options?: any): AxiosPromise<FineTune>,

    /**
     * @summary Retrieves a model instance, providing basic information about the model such as the owner and permissioning.
     * @param {string} model The ID of the model to use for this request
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    retrieveModel(model: string, options?: any): AxiosPromise<Model>,
    ...
  };

  /**
   * OpenAIApi - object-oriented interface
   * @export
   * @class OpenAIApi
   * @extends
   */
  declare class OpenAIApi mixins BaseAPI {
    /**
     * @summary Immediately cancel a fine-tune job.
     * @param {string} fineTuneId The ID of the fine-tune job to cancel
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    cancelFineTune(
      fineTuneId: string,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<FineTune, any>;

    /**
     * @summary Answers the specified question using the provided documents and examples.  The endpoint first [searches](/docs/api-reference/searches) over provided documents or files to find relevant context. The relevant context is combined with the provided examples and question to create the prompt for [completion](/docs/api-reference/completions).
     * @param {CreateAnswerRequest} createAnswerRequest
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    createAnswer(
      createAnswerRequest: CreateAnswerRequest,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<CreateAnswerResponse, any>;

    /**
     * @summary Creates a model response for the given chat conversation.
     * @param {CreateChatCompletionRequest} createChatCompletionRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    createChatCompletion(
      createChatCompletionRequest: CreateChatCompletionRequest,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<CreateChatCompletionResponse, any>;

    /**
     * @summary Classifies the specified `query` using provided examples.  The endpoint first [searches](/docs/api-reference/searches) over the labeled examples to select the ones most relevant for the particular query. Then, the relevant examples are combined with the query to construct a prompt to produce the final label via the [completions](/docs/api-reference/completions) endpoint.  Labeled examples can be provided via an uploaded `file`, or explicitly listed in the request using the `examples` parameter for quick tests and small scale use cases.
     * @param {CreateClassificationRequest} createClassificationRequest
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    createClassification(
      createClassificationRequest: CreateClassificationRequest,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<CreateClassificationResponse, any>;

    /**
     * @summary Creates a completion for the provided prompt and parameters.
     * @param {CreateCompletionRequest} createCompletionRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    createCompletion(
      createCompletionRequest: CreateCompletionRequest,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<CreateCompletionResponse, any>;

    /**
     * @summary Creates a new edit for the provided input, instruction, and parameters.
     * @param {CreateEditRequest} createEditRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    createEdit(
      createEditRequest: CreateEditRequest,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<CreateEditResponse, any>;

    /**
     * @summary Creates an embedding vector representing the input text.
     * @param {CreateEmbeddingRequest} createEmbeddingRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    createEmbedding(
      createEmbeddingRequest: CreateEmbeddingRequest,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<CreateEmbeddingResponse, any>;

    /**
     * @summary Upload a file that contains document(s) to be used across various endpoints/features. Currently, the size of all the files uploaded by one organization can be up to 1 GB. Please contact us if you need to increase the storage limit.
     * @param {File} file Name of the [JSON Lines](https://jsonlines.readthedocs.io/en/latest/) file to be uploaded.  If the &#x60;purpose&#x60; is set to \\\&quot;fine-tune\\\&quot;, each line is a JSON record with \\\&quot;prompt\\\&quot; and \\\&quot;completion\\\&quot; fields representing your [training examples](/docs/guides/fine-tuning/prepare-training-data).
     * @param {string} purpose The intended purpose of the uploaded documents.  Use \\\&quot;fine-tune\\\&quot; for [Fine-tuning](/docs/api-reference/fine-tunes). This allows us to validate the format of the uploaded file.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    createFile(
      file: File,
      purpose: string,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<OpenAIFile, any>;

    /**
     * @summary Creates a job that fine-tunes a specified model from a given dataset.  Response includes details of the enqueued job including job status and the name of the fine-tuned models once complete.  [Learn more about Fine-tuning](/docs/guides/fine-tuning)
     * @param {CreateFineTuneRequest} createFineTuneRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    createFineTune(
      createFineTuneRequest: CreateFineTuneRequest,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<FineTune, any>;

    /**
     * @summary Creates an image given a prompt.
     * @param {CreateImageRequest} createImageRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    createImage(
      createImageRequest: CreateImageRequest,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<ImagesResponse, any>;

    /**
     * @summary Creates an edited or extended image given an original image and a prompt.
     * @param {File} image The image to edit. Must be a valid PNG file, less than 4MB, and square. If mask is not provided, image must have transparency, which will be used as the mask.
     * @param {string} prompt A text description of the desired image(s). The maximum length is 1000 characters.
     * @param {File} [mask] An additional image whose fully transparent areas (e.g. where alpha is zero) indicate where &#x60;image&#x60; should be edited. Must be a valid PNG file, less than 4MB, and have the same dimensions as &#x60;image&#x60;.
     * @param {number} [n] The number of images to generate. Must be between 1 and 10.
     * @param {string} [size] The size of the generated images. Must be one of &#x60;256x256&#x60;, &#x60;512x512&#x60;, or &#x60;1024x1024&#x60;.
     * @param {string} [responseFormat] The format in which the generated images are returned. Must be one of &#x60;url&#x60; or &#x60;b64_json&#x60;.
     * @param {string} [user] A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    createImageEdit(
      image: File,
      prompt: string,
      mask?: File,
      n?: number,
      size?: string,
      responseFormat?: string,
      user?: string,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<ImagesResponse, any>;

    /**
     * @summary Creates a variation of a given image.
     * @param {File} image The image to use as the basis for the variation(s). Must be a valid PNG file, less than 4MB, and square.
     * @param {number} [n] The number of images to generate. Must be between 1 and 10.
     * @param {string} [size] The size of the generated images. Must be one of &#x60;256x256&#x60;, &#x60;512x512&#x60;, or &#x60;1024x1024&#x60;.
     * @param {string} [responseFormat] The format in which the generated images are returned. Must be one of &#x60;url&#x60; or &#x60;b64_json&#x60;.
     * @param {string} [user] A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    createImageVariation(
      image: File,
      n?: number,
      size?: string,
      responseFormat?: string,
      user?: string,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<ImagesResponse, any>;

    /**
     * @summary Classifies if text violates OpenAI\'s Content Policy
     * @param {CreateModerationRequest} createModerationRequest
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    createModeration(
      createModerationRequest: CreateModerationRequest,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<CreateModerationResponse, any>;

    /**
     * @summary The search endpoint computes similarity scores between provided query and documents. Documents can be passed directly to the API if there are no more than 200 of them.  To go beyond the 200 document limit, documents can be processed offline and then used for efficient retrieval at query time. When `file` is set, the search endpoint searches over all the documents in the given file and returns up to the `max_rerank` number of documents. These documents will be returned along with their search scores.  The similarity score is a positive score that usually ranges from 0 to 300 (but can sometimes go higher), where a score above 200 usually means the document is semantically similar to the query.
     * @param {string} engineId The ID of the engine to use for this request.  You can select one of &#x60;ada&#x60;, &#x60;babbage&#x60;, &#x60;curie&#x60;, or &#x60;davinci&#x60;.
     * @param {CreateSearchRequest} createSearchRequest
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    createSearch(
      engineId: string,
      createSearchRequest: CreateSearchRequest,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<CreateSearchResponse, any>;

    /**
     * @summary Transcribes audio into the input language.
     * @param {File} file The audio file object (not file name) to transcribe, in one of these formats: mp3, mp4, mpeg, mpga, m4a, wav, or webm.
     * @param {string} model ID of the model to use. Only &#x60;whisper-1&#x60; is currently available.
     * @param {string} [prompt] An optional text to guide the model\\\&#39;s style or continue a previous audio segment. The [prompt](/docs/guides/speech-to-text/prompting) should match the audio language.
     * @param {string} [responseFormat] The format of the transcript output, in one of these options: json, text, srt, verbose_json, or vtt.
     * @param {number} [temperature] The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use [log probability](https://en.wikipedia.org/wiki/Log_probability) to automatically increase the temperature until certain thresholds are hit.
     * @param {string} [language] The language of the input audio. Supplying the input language in [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) format will improve accuracy and latency.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    createTranscription(
      file: File,
      model: string,
      prompt?: string,
      responseFormat?: string,
      temperature?: number,
      language?: string,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<CreateTranscriptionResponse, any>;

    /**
     * @summary Translates audio into into English.
     * @param {File} file The audio file object (not file name) translate, in one of these formats: mp3, mp4, mpeg, mpga, m4a, wav, or webm.
     * @param {string} model ID of the model to use. Only &#x60;whisper-1&#x60; is currently available.
     * @param {string} [prompt] An optional text to guide the model\\\&#39;s style or continue a previous audio segment. The [prompt](/docs/guides/speech-to-text/prompting) should be in English.
     * @param {string} [responseFormat] The format of the transcript output, in one of these options: json, text, srt, verbose_json, or vtt.
     * @param {number} [temperature] The sampling temperature, between 0 and 1. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use [log probability](https://en.wikipedia.org/wiki/Log_probability) to automatically increase the temperature until certain thresholds are hit.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    createTranslation(
      file: File,
      model: string,
      prompt?: string,
      responseFormat?: string,
      temperature?: number,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<CreateTranslationResponse, any>;

    /**
     * @summary Delete a file.
     * @param {string} fileId The ID of the file to use for this request
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    deleteFile(
      fileId: string,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<DeleteFileResponse, any>;

    /**
     * @summary Delete a fine-tuned model. You must have the Owner role in your organization.
     * @param {string} model The model to delete
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    deleteModel(
      model: string,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<DeleteModelResponse, any>;

    /**
     * @summary Returns the contents of the specified file
     * @param {string} fileId The ID of the file to use for this request
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    downloadFile(
      fileId: string,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<string, any>;

    /**
     * @summary Lists the currently available (non-finetuned) models, and provides basic information about each one such as the owner and availability.
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    listEngines(
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<ListEnginesResponse, any>;

    /**
     * @summary Returns a list of files that belong to the user\'s organization.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    listFiles(
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<ListFilesResponse, any>;

    /**
     * @summary Get fine-grained status updates for a fine-tune job.
     * @param {string} fineTuneId The ID of the fine-tune job to get events for.
     * @param {boolean} [stream] Whether to stream events for the fine-tune job. If set to true, events will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available. The stream will terminate with a &#x60;data: [DONE]&#x60; message when the job is finished (succeeded, cancelled, or failed).  If set to false, only events generated so far will be returned.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    listFineTuneEvents(
      fineTuneId: string,
      stream?: boolean,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<ListFineTuneEventsResponse, any>;

    /**
     * @summary List your organization\'s fine-tuning jobs
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    listFineTunes(
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<ListFineTunesResponse, any>;

    /**
     * @summary Lists the currently available models, and provides basic information about each one such as the owner and availability.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    listModels(
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<ListModelsResponse, any>;

    /**
     * @summary Retrieves a model instance, providing basic information about it such as the owner and availability.
     * @param {string} engineId The ID of the engine to use for this request
     * @param {*} [options] Override http request option.
     * @deprecated
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    retrieveEngine(
      engineId: string,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<Engine, any>;

    /**
     * @summary Returns information about a specific file.
     * @param {string} fileId The ID of the file to use for this request
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    retrieveFile(
      fileId: string,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<OpenAIFile, any>;

    /**
     * @summary Gets info about the fine-tune job.  [Learn more about Fine-tuning](/docs/guides/fine-tuning)
     * @param {string} fineTuneId The ID of the fine-tune job
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    retrieveFineTune(
      fineTuneId: string,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<FineTune, any>;

    /**
     * @summary Retrieves a model instance, providing basic information about the model such as the owner and permissioning.
     * @param {string} model The ID of the model to use for this request
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof OpenAIApi
     */
    retrieveModel(
      model: string,
      options?: AxiosXHRConfig<Object>
    ): AxiosPromise<Model, any>;
  }
}
