declare module 'keycode' {
  declare type CodesMap = $ReadOnly<
    $Exact<{
      '0': 48,
      '1': 49,
      '2': 50,
      '3': 51,
      '4': 52,
      '5': 53,
      '6': 54,
      '7': 55,
      '8': 56,
      '9': 57,
      "'": 222,
      ',': 188,
      '-': 189,
      '.': 190,
      '/': 191,
      ';': 186,
      '=': 187,
      '[': 219,
      '\\': 220,
      ']': 221,
      '`': 192,
      a: 65,
      alt: 18,
      b: 66,
      backspace: 8,
      break: 19,
      c: 67,
      caps: 20,
      'caps lock': 20,
      cmd: 91,
      command: 91,
      control: 17,
      ctl: 17,
      ctrl: 17,
      d: 68,
      del: 46,
      delete: 46,
      down: 40,
      e: 69,
      end: 35,
      enter: 13,
      esc: 27,
      escape: 27,
      f: 70,
      f1: 112,
      f10: 121,
      f11: 122,
      f12: 123,
      f2: 113,
      f3: 114,
      f4: 115,
      f5: 116,
      f6: 117,
      f7: 118,
      f8: 119,
      f9: 120,
      g: 71,
      h: 72,
      home: 36,
      i: 73,
      ins: 45,
      insert: 45,
      j: 74,
      k: 75,
      l: 76,
      left: 37,
      'left command': 91,
      m: 77,
      'my calculator': 183,
      'my computer': 182,
      n: 78,
      'num lock': 144,
      'numpad *': 106,
      'numpad +': 107,
      'numpad -': 109,
      'numpad .': 110,
      'numpad /': 111,
      'numpad 0': 96,
      'numpad 1': 97,
      'numpad 2': 98,
      'numpad 3': 99,
      'numpad 4': 100,
      'numpad 5': 101,
      'numpad 6': 102,
      'numpad 7': 103,
      'numpad 8': 104,
      'numpad 9': 105,
      o: 79,
      option: 18,
      p: 80,
      'page down': 34,
      'page up': 33,
      pause: 19,
      'pause/break': 19,
      pgdn: 34,
      pgup: 33,
      q: 81,
      r: 82,
      return: 13,
      right: 39,
      'right command': 93,
      s: 83,
      'scroll lock': 145,
      shift: 16,
      space: 32,
      spacebar: 32,
      spc: 32,
      t: 84,
      tab: 9,
      u: 85,
      up: 38,
      v: 86,
      w: 87,
      windows: 91,
      x: 88,
      y: 89,
      z: 90,
      '⇧': 16,
      '⌃': 17,
      '⌘': 91,
      '⌥': 18,
    }>
  >;

  declare type AliasesMap = $ReadOnly<
    $Exact<{
      windows: 91,
      '⇧': 16,
      '⌥': 18,
      '⌃': 17,
      '⌘': 91,
      ctl: 17,
      control: 17,
      option: 18,
      pause: 19,
      break: 19,
      caps: 20,
      return: 13,
      escape: 27,
      spc: 32,
      spacebar: 32,
      pgup: 33,
      pgdn: 34,
      ins: 45,
      del: 46,
      cmd: 91,
    }>
  >;

  declare type InverseCodesMap = $ReadOnly<
    $Exact<{
      '48': '0',
      '49': '1',
      '50': '2',
      '51': '3',
      '52': '4',
      '53': '5',
      '54': '6',
      '55': '7',
      '56': '8',
      '57': '9',
      '222': "'",
      '188': ',',
      '189': '-',
      '190': '.',
      '191': '/',
      '186': ';',
      '187': '=',
      '219': '[',
      '220': '\\',
      '221': ']',
      '192': '`',
      '65': 'a',
      '18': 'alt',
      '66': 'b',
      '8': 'backspace',
      '19': 'break',
      '67': 'c',
      '20': 'caps',
      '20': 'caps lock',
      '91': 'cmd',
      '91': 'command',
      '17': 'control',
      '17': 'ctl',
      '17': 'ctrl',
      '68': 'd',
      '46': 'del',
      '46': 'delete',
      '40': 'down',
      '69': 'e',
      '35': 'end',
      '13': 'enter',
      '27': 'esc',
      '27': 'escape',
      '70': 'f',
      '112': 'f1',
      '121': 'f10',
      '122': 'f11',
      '123': 'f12',
      '113': 'f2',
      '114': 'f3',
      '115': 'f4',
      '116': 'f5',
      '117': 'f6',
      '118': 'f7',
      '119': 'f8',
      '120': 'f9',
      '71': 'g',
      '72': 'h',
      '36': 'home',
      '73': 'i',
      '45': 'ins',
      '45': 'insert',
      '74': 'j',
      '75': 'k',
      '76': 'l',
      '37': 'left',
      '91': 'left command',
      '77': 'm',
      '183': 'my calculator',
      '182': 'my computer',
      '78': 'n',
      '144': 'num lock',
      '106': 'numpad *',
      '107': 'numpad +',
      '109': 'numpad -',
      '110': 'numpad .',
      '111': 'numpad /',
      '96': 'numpad 0',
      '97': 'numpad 1',
      '98': 'numpad 2',
      '99': 'numpad 3',
      '100': 'numpad 4',
      '101': 'numpad 5',
      '102': 'numpad 6',
      '103': 'numpad 7',
      '104': 'numpad 8',
      '105': 'numpad 9',
      '79': 'o',
      '18': 'option',
      '80': 'p',
      '34': 'page down',
      '33': 'page up',
      '19': 'pause',
      '19': 'pause/break',
      '34': 'pgdn',
      '33': 'pgup',
      '81': 'q',
      '82': 'r',
      '13': 'return',
      '39': 'right',
      '93': 'right command',
      '83': 's',
      '145': 'scroll lock',
      '16': 'shift',
      '32': 'space',
      '32': 'spacebar',
      '32': 'spc',
      '84': 't',
      '9': 'tab',
      '85': 'u',
      '38': 'up',
      '86': 'v',
      '87': 'w',
      '91': 'windows',
      '88': 'x',
      '89': 'y',
      '90': 'z',
      '16': '⇧',
      '17': '⌃',
      '91': '⌘',
      '18': '⌥',
    }>
  >;

  declare interface KeyCode {
    (keyCode: number): $Values<InverseCodesMap>;
    (key: string): $Values<CodesMap>;
    (KeyboardEvent): $Values<InverseCodesMap>;
    isEventKey: (event: KeyboardEvent, number | string) => boolean;
    codes: CodesMap;
    aliases: AliasesMap;
    names: InverseCodesMap;
  }

  declare module.exports: KeyCode;
}
